/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.CreateMembers;
import com.j_spaces.tools.cluster.DescEventListener;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ListItemAlreadyExistsException;
import com.j_spaces.tools.cluster.NewGroup;
import com.j_spaces.tools.cluster.ResourcesInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CreateGroups
extends JPanel {
    public JPanel optionPanel;
    public JLabel groupNameLabel;
    public JPanel buttonPanel;
    public JPanel editButtonPanel;
    public JPanel moveButtonPanel;
    public JButton moveDownButton;
    public JButton moveUpButton;
    public JButton addButton;
    public JButton removeButton;
    public JButton editButton;
    public JButton renameButton;
    public JButton newLikeButton;
    public DefaultListModel groupModel;
    public JListExt groupList;
    public NewGroup m_newGroupDialog;
    public CreateMembers m_createMemDialog;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public CreateGroups(CreateMembers createMembers) {
        block2: {
            this.optionPanel = new JPanel();
            this.groupNameLabel = new JLabel();
            this.buttonPanel = new JPanel();
            this.editButtonPanel = new JPanel();
            this.moveButtonPanel = new JPanel();
            this.moveDownButton = new JButton();
            this.moveUpButton = new JButton();
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.editButton = new JButton();
            this.renameButton = new JButton();
            this.newLikeButton = new JButton();
            this.groupModel = new DefaultListModel();
            this.groupList = new JListExt(this.groupModel, null);
            this.m_createMemDialog = createMembers;
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void jbInit() throws Exception {
        this.m_newGroupDialog = new NewGroup(this);
        this.groupList.setCellRenderer(new GroupRenderer(null));
        this.setLayout(new BorderLayout());
        this.optionPanel.setLayout(new BorderLayout());
        this.addButton.setRequestFocusEnabled(false);
        this.removeButton.setRequestFocusEnabled(false);
        this.editButton.setRequestFocusEnabled(false);
        this.newLikeButton.setRequestFocusEnabled(false);
        this.buttonPanel.setLayout(new BorderLayout());
        this.editButtonPanel.setLayout(new VerticalFlowLayout());
        this.moveDownButton.setRequestFocusEnabled(false);
        this.moveUpButton.setRequestFocusEnabled(false);
        this.moveButtonPanel.setLayout(new VerticalFlowLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.renameButton.setRequestFocusEnabled(false);
        this.addButton.setIcon(this.getImage("newGroup.gif"));
        this.newLikeButton.setIcon(this.getImage("newLikeGroup.gif"));
        this.removeButton.setIcon(this.getImage("removeGroup.gif"));
        this.moveUpButton.setIcon(this.getImage("moveUp.gif"));
        this.renameButton.setIcon(this.getImage("renameGroup.gif"));
        this.moveDownButton.setIcon(this.getImage("moveDown.gif"));
        this.editButton.setIcon(this.getImage("editGroup.gif"));
        String[] stringArray = ResourcesInfo.createGroup.getLabels();
        this.optionPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), stringArray[0]), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        this.groupNameLabel.setText(stringArray[1]);
        String[] stringArray2 = ResourcesInfo.createGroup.getButtons();
        this.addButton.setText(stringArray2[0]);
        this.addButton.setHorizontalAlignment(10);
        this.newLikeButton.setText(stringArray2[1]);
        this.newLikeButton.setHorizontalAlignment(10);
        this.editButton.setText(stringArray2[2]);
        this.editButton.setHorizontalAlignment(10);
        this.renameButton.setText(stringArray2[3]);
        this.renameButton.setHorizontalAlignment(10);
        this.removeButton.setText(stringArray2[4]);
        this.removeButton.setHorizontalAlignment(10);
        this.moveUpButton.setText(stringArray2[5]);
        this.moveUpButton.setHorizontalAlignment(10);
        this.moveDownButton.setText(stringArray2[6]);
        this.moveDownButton.setHorizontalAlignment(10);
        String[] stringArray3 = ResourcesInfo.createGroup.getToolTips();
        JLabel jLabel = this.m_createMemDialog.m_newCluster.stepDescLabel;
        this.addButton.addMouseListener(new DescEventListener(jLabel, stringArray3[0]));
        this.newLikeButton.addMouseListener(new DescEventListener(jLabel, stringArray3[1]));
        this.editButton.addMouseListener(new DescEventListener(jLabel, stringArray3[2]));
        this.renameButton.addMouseListener(new DescEventListener(jLabel, stringArray3[3]));
        this.removeButton.addMouseListener(new DescEventListener(jLabel, stringArray3[4]));
        this.moveDownButton.addMouseListener(new DescEventListener(jLabel, stringArray3[5]));
        this.moveUpButton.addMouseListener(new DescEventListener(jLabel, stringArray3[6]));
        this.groupList.addMouseListener(new DescEventListener(jLabel, stringArray3[7]));
        this.groupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n2 = CreateGroups.this.groupList.locationToIndex(mouseEvent.getPoint());
                    if (n2 == -1) {
                        return;
                    }
                    CreateGroups.this.editGroup();
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGroups.this.removeGroup();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGroups.this.editGroup();
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGroups.this.moveDownButton();
            }
        });
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGroups.this.moveUpButton();
            }
        });
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGroups.this.renameGroup();
            }
        });
        this.newLikeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGroups.this.createGroupNewLike();
            }
        });
        this.add((Component)this.optionPanel, "Center");
        this.optionPanel.add((Component)this.groupNameLabel, "North");
        this.optionPanel.add((Component)new JScrollPane(this.groupList), "Center");
        this.optionPanel.add((Component)this.buttonPanel, "East");
        this.buttonPanel.add((Component)this.editButtonPanel, "North");
        this.editButtonPanel.add((Component)this.addButton, null);
        this.editButtonPanel.add((Component)this.newLikeButton, null);
        this.editButtonPanel.add((Component)this.editButton, null);
        this.editButtonPanel.add((Component)this.renameButton, null);
        this.editButtonPanel.add((Component)this.removeButton, null);
        this.buttonPanel.add((Component)this.moveButtonPanel, "South");
        this.moveButtonPanel.add((Component)this.moveUpButton, null);
        this.moveButtonPanel.add((Component)this.moveDownButton, null);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGroups.this.m_newGroupDialog.showDialog(CreateGroups.this.m_createMemDialog.m_newCluster.getClusterName());
            }
        });
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n2 = CreateGroups.this.groupList.getAnchorSelectionIndex();
                CreateGroups.this.groupList.ensureIndexIsVisible(n2);
                if (CreateGroups.this.groupModel.size() <= 1 || n2 <= 0) {
                    CreateGroups.this.moveUpButton.setEnabled(false);
                } else {
                    CreateGroups.this.moveUpButton.setEnabled(true);
                }
                if (CreateGroups.this.groupModel.size() <= 1 || n2 + 1 >= CreateGroups.this.groupModel.size()) {
                    CreateGroups.this.moveDownButton.setEnabled(false);
                } else {
                    CreateGroups.this.moveDownButton.setEnabled(true);
                }
            }
        });
        this.moveDownButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.newLikeButton.setEnabled(false);
        this.renameButton.setEnabled(false);
    }

    private ImageIcon getImage(String string) {
        return new ImageIcon(this.getClass().getResource("/image/cluster-wizard/" + string));
    }

    public void setGroupInfo(GroupInfo groupInfo, boolean bl2) {
        if (bl2) {
            int n2 = this.groupList.getSelectedIndex();
            this.groupModel.set(n2, groupInfo);
        } else {
            this.groupModel.addElement(groupInfo);
            this.groupList.setSelectedIndex(this.groupModel.getSize() - 1);
        }
        JSpaceUtilities.setAWTComponentsStatus(this.editButtonPanel, true);
    }

    public boolean isGroupExists(String string) throws ListItemAlreadyExistsException {
        return this.groupList.contains(string);
    }

    public void moveUpButton() {
        Object e2 = this.groupList.getSelectedValue();
        int n2 = this.groupList.getSelectedIndex();
        Object e3 = this.groupModel.get(n2 - 1);
        this.groupModel.set(n2 - 1, e2);
        this.groupModel.set(n2, e3);
        this.groupList.setSelectedIndex(n2 - 1);
    }

    public void moveDownButton() {
        Object e2 = this.groupList.getSelectedValue();
        int n2 = this.groupList.getSelectedIndex();
        Object e3 = this.groupModel.get(n2 + 1);
        this.groupModel.set(n2 + 1, e2);
        this.groupModel.set(n2, e3);
        this.groupList.setSelectedIndex(n2 + 1);
    }

    public void editGroup() {
        this.m_newGroupDialog.showEditData((GroupInfo)this.groupList.getSelectedValue(), true);
    }

    public void removeGroup() {
        GroupInfo groupInfo;
        int n2;
        if (JOptionPane.showConfirmDialog(this, "Remove group, are you sure?", "Confirmation", 0) != 0) {
            return;
        }
        int n3 = this.groupList.getSelectedIndex();
        String string = this.groupList.getSelectedValue().toString();
        for (n2 = 0; n2 < this.groupModel.getSize(); ++n2) {
            groupInfo = (GroupInfo)this.groupModel.get(n2);
            if (groupInfo.failOverInfo == null || groupInfo.failOverInfo.alterGroup == null || !this.contains(string, groupInfo.failOverInfo.alterGroup)) continue;
            JOptionPane.showMessageDialog(this, "Can not to perform remove this (" + string + ") group,\nbecause it used in other (" + groupInfo.groupName + ") failover group as alternate.", "Information", 1);
            return;
        }
        this.groupModel.remove(n3);
        if (n3 == this.groupModel.getSize()) {
            this.groupList.setSelectedIndex(n3 - 1);
        } else {
            this.groupList.setSelectedIndex(n3);
        }
        block1: for (n2 = 0; n2 < this.groupModel.getSize(); ++n2) {
            groupInfo = (GroupInfo)this.groupModel.get(n2);
            if (groupInfo.failOverInfo == null || groupInfo.failOverInfo.alterGroup == null || groupInfo.failOverInfo.alterGroup.length <= 0) continue;
            for (int i2 = 0; i2 < groupInfo.failOverInfo.alterGroup.length; ++i2) {
                if (groupInfo.failOverInfo.alterGroup[i2] == null || !groupInfo.failOverInfo.alterGroup[i2].equals(string)) continue;
                groupInfo.failOverInfo.alterGroup[i2] = null;
                continue block1;
            }
        }
        if (this.groupModel.size() == 0) {
            JSpaceUtilities.setAWTComponentsStatus(this.buttonPanel, false);
            this.addButton.setEnabled(true);
        }
    }

    public void createGroupNewLike() {
        this.m_newGroupDialog.showEditData((GroupInfo)this.groupList.getSelectedValue(), false);
    }

    private void renameGroup() {
        GroupInfo groupInfo = (GroupInfo)this.groupList.getSelectedValue();
        String string = groupInfo.groupName;
        String string2 = JOptionPane.showInputDialog(this, "Enter new group name:", "Rename Group", 2);
        if (string2 == null || string2.trim().length() <= 0) {
            return;
        }
        try {
            this.groupList.contains(string2);
        }
        catch (ListItemAlreadyExistsException listItemAlreadyExistsException) {
            JOptionPane.showConfirmDialog(this, "This group: " + string2 + " already exists.", "Error", -1, 0, ResourcesInfo.WARNING_ICON);
            return;
        }
        groupInfo.groupName = string2.trim();
        this.groupList.repaint();
        block2: for (int i2 = 0; i2 < this.groupModel.getSize(); ++i2) {
            GroupInfo groupInfo2 = (GroupInfo)this.groupModel.get(i2);
            if (groupInfo2.failOverInfo == null || groupInfo2.failOverInfo.alterGroup == null || groupInfo2.failOverInfo.alterGroup.length <= 0) continue;
            for (int i3 = 0; i3 < groupInfo2.failOverInfo.alterGroup.length; ++i3) {
                if (groupInfo2.failOverInfo.alterGroup[i3] == null || !groupInfo2.failOverInfo.alterGroup[i3].equals(string)) continue;
                groupInfo2.failOverInfo.alterGroup[i3] = groupInfo.groupName;
                continue block2;
            }
        }
    }

    public DefaultListModel getGroupModel() {
        return this.groupModel;
    }

    public void clearAllGroupInfo() {
        this.groupModel.clear();
        JSpaceUtilities.setAWTComponentsStatus(this.buttonPanel, false);
        this.addButton.setEnabled(true);
    }

    private boolean contains(Object object, Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!objectArray[i2].toString().equals(object)) continue;
            return true;
        }
        return false;
    }

    private static class JListExt
    extends JList {
        private JListExt(DefaultListModel defaultListModel) {
            super(defaultListModel);
            this.setSelectionMode(0);
        }

        public boolean contains(String string) throws ListItemAlreadyExistsException {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
                GroupInfo groupInfo = (GroupInfo)defaultListModel.get(i2);
                if (!string.equals(groupInfo.groupName)) continue;
                throw new ListItemAlreadyExistsException("The group: " + string + " already exists.");
            }
            return false;
        }

        public /* synthetic */ JListExt(DefaultListModel defaultListModel, 1 var2_2) {
            this(defaultListModel);
        }
    }

    private static class GroupRenderer
    extends DefaultListCellRenderer {
        public ImageIcon groupIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/groupTree.gif"));

        private GroupRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            this.setIcon(this.groupIcon);
            return this;
        }

        public /* synthetic */ GroupRenderer(1 var1_1) {
            this();
        }
    }
}

