/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.dynamic.mapping;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public class PhysicalSpace
implements Serializable {
    private String _name;
    private final HashMap _logicMap = new HashMap();
    private final int[] _logicCount;

    public PhysicalSpace(String string, int n2) {
        this._name = string;
        this._logicCount = new int[n2];
    }

    public final String getName() {
        return this._name;
    }

    public boolean isOwner(Integer n2) {
        LinkedList linkedList = (LinkedList)this._logicMap.get(n2);
        return linkedList != null && linkedList.size() > 0;
    }

    public Set getLogics() {
        return this._logicMap.entrySet();
    }

    public LinkedList getLogic(Integer n2) {
        return (LinkedList)this._logicMap.get(n2);
    }

    public boolean removeLogic(Integer n2, Integer n3) {
        LinkedList linkedList = (LinkedList)this._logicMap.get(n2);
        boolean bl2 = linkedList.remove(n3);
        if (bl2) {
            if (linkedList.size() == 0) {
                this._logicMap.remove(n2);
            }
            int n4 = n3;
            this._logicCount[n4] = this._logicCount[n4] - 1;
        }
        return bl2;
    }

    public void addLogic(Integer n2, Integer n3) {
        LinkedList<Integer> linkedList = (LinkedList<Integer>)this._logicMap.get(n2);
        if (linkedList == null) {
            linkedList = new LinkedList<Integer>();
            this._logicMap.put(n2, linkedList);
        }
        linkedList.add(n3);
        int n4 = n3;
        this._logicCount[n4] = this._logicCount[n4] + 1;
    }

    public int numberOfLogics() {
        return this._logicMap.size();
    }

    public int numberOfLogics(int n2) {
        return this._logicCount[n2];
    }

    public boolean equals(Object object) {
        return this == object || this._name.equals(((PhysicalSpace)object)._name);
    }

    public String toString() {
        return this._name;
    }
}

