/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.Constants;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLValidationException;
import com.j_spaces.core.client.SpaceURLValidator;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.lookup.entry.ClusterGroup;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.GenericEntry;
import com.j_spaces.lookup.entry.Persistent;
import com.j_spaces.lookup.entry.State;
import com.j_spaces.obf.df;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.Name;

public class SpaceURLParser {
    private static final String b = "10098";
    public static final HashMap a = new HashMap();
    private static final Logger c;

    private SpaceURLParser() {
    }

    public static SpaceURL parseURL(String string) throws MalformedURLException {
        return SpaceURLParser.parseURL(string, null);
    }

    public static SpaceURL parseURL(String string, Properties properties) throws MalformedURLException {
        String string2;
        SpaceURL spaceURL;
        int n2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        block53: {
            String string8;
            int n3;
            string = JSpaceUtilities.removeInvertedCommas(string);
            string = JSpaceUtilities.removeDelimiter(string, ' ', '{', '}');
            if (c.isLoggable(Level.FINE)) {
                c.fine("Using SpaceURL: " + string);
            }
            if ((n3 = string.indexOf(63)) != string.lastIndexOf(63)) {
                throw new SpaceURLValidationException("The space url has more than one '?' character");
            }
            if (n3 == -1 && string.indexOf(38) > -1) {
                throw new SpaceURLValidationException("The space url contains the '&' delimiter but is missing the '?' character. Make sure the '?' character is set after the space/container name.");
            }
            int n4 = 3;
            string7 = null;
            string6 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            int n5 = string.indexOf("/./");
            int n6 = n5 + 3;
            if (n5 != -1) {
                ++n4;
            }
            if (n5 == 0) {
                string4 = "java:";
                string5 = "localhost:10098";
                int n7 = string.indexOf(63);
                if (n7 != -1) {
                    string6 = string.substring(n6, n7);
                    n2 = string.indexOf("_container");
                    if (n2 != -1) {
                        string6 = string.substring(n2 + 11, n7);
                    }
                } else {
                    string6 = string.substring(n6);
                    n2 = string.indexOf("_container");
                    if (n2 != -1) {
                        string6 = string.substring(n2 + 11, string.length());
                    }
                }
                string7 = string6 + "_container";
                string3 = "default";
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                n2 = stringTokenizer.countTokens();
                if (n2 < n4) {
                    throw new MalformedURLException(string);
                }
                string4 = stringTokenizer.nextToken();
                if (!SpaceURL.AVAILABLE_PROTOCOLS.contains(string4)) {
                    throw new MalformedURLException("Unknown protocol found in space url: " + string);
                }
                string8 = stringTokenizer.nextToken();
                string5 = string8.equals("*") || string4.equalsIgnoreCase("jini:") ? string8 : SpaceURLParser.getRMIDurl(string8);
                if (n5 != -1) {
                    string6 = stringTokenizer.nextToken("?");
                    if (string6.startsWith("/./")) {
                        string6 = string6.substring(3);
                    } else if (string6.startsWith("/")) {
                        string6 = string6.substring(1);
                    }
                    string7 = string6 + "_container";
                    string3 = "default";
                    if (n2 == n4 && string7.equals("*")) {
                        throw new MalformedURLException(string + " container name can not be equals to *");
                    }
                    if (string7.equals("*") && string4.equalsIgnoreCase("rmi:")) {
                        throw new MalformedURLException(string + " URL can not be RMI protocol and container name equals to *");
                    }
                    if (string4.equalsIgnoreCase("rmi:") && string5.equals("*")) {
                        string5 = SpaceURLParser.getRMIDurl(string7);
                    } else if (string4.equalsIgnoreCase("rmi:") && !string5.equals("*")) {
                        string5 = SpaceURLParser.getRMIDurl(string5);
                    }
                } else {
                    string7 = stringTokenizer.nextToken();
                    if (n2 == n4 && string7.indexOf(63) != -1) {
                        string7 = string7.substring(0, string7.indexOf(63));
                    }
                    if (n2 == n4 && string7.equals("*")) {
                        throw new MalformedURLException(string + " container name can not be equals to *");
                    }
                    if (string7.equals("*") && string4.equalsIgnoreCase("rmi:")) {
                        throw new MalformedURLException(string + " URL can not be RMI protocol and container name equals to *");
                    }
                    if (string4.equalsIgnoreCase("rmi:") && string5.equals("*")) {
                        string5 = SpaceURLParser.getRMIDurl(string7);
                    } else if (string4.equalsIgnoreCase("rmi:") && !string5.equals("*")) {
                        string5 = SpaceURLParser.getRMIDurl(string5);
                    }
                }
                if (stringTokenizer.hasMoreTokens() && n5 == -1) {
                    string6 = stringTokenizer.nextToken("?");
                    string6 = string6.startsWith("/") ? string6.substring(1) : string6;
                }
            }
            spaceURL = new SpaceURL();
            spaceURL.setProperty("url", string);
            SpaceURLParser.c(spaceURL);
            n2 = 0;
            string8 = spaceURL.getProperty("ignoreValidation");
            if (!JSpaceUtilities.isEmpty(string8) && Boolean.valueOf(string8).booleanValue()) {
                n2 = 1;
            }
            try {
                if (n2 == 0) {
                    SpaceURLValidator.validate(spaceURL);
                }
            }
            catch (SpaceURLValidationException spaceURLValidationException) {
                throw spaceURLValidationException;
            }
            catch (Exception exception) {
                if (!c.isLoggable(Level.SEVERE)) break block53;
                c.log(Level.SEVERE, "Space URL validation failed due to  ", exception);
            }
        }
        String string9 = spaceURL.getProperty("properties");
        if (properties != null) {
            string2 = properties.getProperty("gs.space.url.arg.properties");
            if (!JSpaceUtilities.isEmpty(string2)) {
                string9 = string2;
            }
            spaceURL.put("customproperties", properties);
        } else {
            properties = new Properties();
            spaceURL.put("customproperties", properties);
        }
        properties = SpaceURLParser.a(string9, spaceURL);
        if (spaceURL.containsKey("cluster_schema") && !spaceURL.containsKey("schema")) {
            string3 = "default";
            spaceURL.setProperty("schema", string3);
        }
        if (n2 == 0) {
            SpaceURLValidator.validateClusterSchemaAttributes(spaceURL);
        }
        if (string4.equalsIgnoreCase("java:")) {
            String string10;
            string2 = spaceURL.getProperty("cluster_schema");
            if (string2 != null) {
                if (spaceURL.containsKey("id")) {
                    string10 = spaceURL.getProperty("id");
                    string7 = string7 + string10;
                }
                if ((string10 = spaceURL.getProperty("backup_id")) != null) {
                    string7 = string7 + '_' + string10;
                }
            }
            if (string5 != null && string5.indexOf(58) != -1) {
                string10 = properties.getProperty("com.j_spaces.core.container.directory_services.jndi.enabled");
                if (JSpaceUtilities.isEmpty(string10)) {
                    properties.setProperty("com.j_spaces.core.container.directory_services.jndi.enabled", "true");
                } else if (string10.equalsIgnoreCase("true")) {
                    properties.setProperty("com.j_spaces.core.container.directory_services.jndi.enabled", "true");
                } else if (string10.equalsIgnoreCase("false")) {
                    properties.setProperty("com.j_spaces.core.container.directory_services.jndi.enabled", "false");
                }
                String string11 = properties.getProperty("com.j_spaces.core.container.directory_services.jndi.url");
                if (JSpaceUtilities.isEmpty(string11)) {
                    properties.setProperty("com.j_spaces.core.container.directory_services.jndi.url", string5);
                } else {
                    properties.setProperty("com.j_spaces.core.container.directory_services.jndi.url", string11);
                }
            }
        }
        spaceURL.setProperty("protocol", string4);
        spaceURL.setContainerName(string7);
        spaceURL.setSpaceName(string6);
        spaceURL.setProperty("membername", string7 + ":" + spaceURL.getSpaceName());
        if (string3 != null && !spaceURL.containsKey("schema")) {
            spaceURL.setProperty("schema", string3);
        }
        spaceURL.setProperty("host", string5);
        if (!spaceURL.getProtocol().equalsIgnoreCase("rmi:")) {
            SpaceURLParser.a(spaceURL);
            SpaceURLParser.b(spaceURL);
        }
        return spaceURL;
    }

    public static void a(SpaceURL spaceURL) {
        Properties properties = (Properties)spaceURL.get("customproperties");
        String string = System.getProperty("com.gs.jini_lus.locators");
        String string2 = properties.getProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host");
        String string3 = spaceURL.getProperty("locators");
        String string4 = null;
        if (spaceURL.getHost() != null && spaceURL.getProtocol().equalsIgnoreCase("jini:")) {
            string4 = spaceURL.getHost();
        }
        String[] stringArray = null;
        String string5 = string + ',' + string2 + ',' + string3 + "," + string4;
        stringArray = string5.trim().split(",");
        HashSet<String> hashSet = new HashSet<String>();
        String string6 = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equalsIgnoreCase("null") || hashSet.contains(stringArray[i2])) continue;
            hashSet.add(stringArray[i2]);
            if (string6.equalsIgnoreCase("")) {
                string6 = string6 + stringArray[i2];
                continue;
            }
            string6 = string6 + ',';
            string6 = string6 + stringArray[i2];
        }
        if (!JSpaceUtilities.isEmpty(string6)) {
            properties.setProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host", string6);
            spaceURL.setProperty("locators", string6);
            System.setProperty("com.gs.jini_lus.locators", JSpaceUtilities.removeInvertedCommas(string6));
            if (c.isLoggable(Level.FINE)) {
                c.fine("\nSpaceURL locators attribute, <com.gs.jini_lus.locators> system property and <com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host> XPATH were set to: " + string6);
            }
        }
    }

    public static void b(SpaceURL spaceURL) {
        String string;
        String string2 = System.getProperty("com.gs.jini_lus.groups");
        if (!JSpaceUtilities.isEmpty(string2)) {
            string2 = JSpaceUtilities.removeInvertedCommas(string2);
        }
        if (!JSpaceUtilities.isEmpty(string = spaceURL.getProperty("groups"))) {
            String string3 = string;
            if (!JSpaceUtilities.isEmpty(string2)) {
                int n2;
                String[] stringArray = df.b(string2);
                String[] stringArray2 = df.b(string);
                HashSet<String> hashSet = new HashSet<String>();
                if (stringArray2 != null) {
                    for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        hashSet.add(stringArray2[n2]);
                    }
                }
                if (stringArray != null) {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        if (hashSet.contains(stringArray[n2])) continue;
                        string3 = string3 + ',' + stringArray[n2];
                    }
                }
                if (c.isLoggable(Level.FINE)) {
                    c.fine("\nFound [ -Dcom.gs.jini_lus.groups=" + string2 + " ] property. SpaceURL groups attribute" + " and -D" + "com.gs.jini_lus.groups" + " will be set to: " + string3);
                }
            }
            System.setProperty("com.gs.jini_lus.groups", JSpaceUtilities.removeInvertedCommas(string3));
        } else {
            if (JSpaceUtilities.isEmpty(string2)) {
                string2 = Constants.LookupManager.LOOKUP_GROUP_DEFAULT;
                System.setProperty("com.j_spaces.core.container.directory_services.jini_lus.groups", string2);
            }
            spaceURL.setProperty("groups", string2);
            if (c.isLoggable(Level.FINE)) {
                c.fine("\nFound [ -Dcom.gs.jini_lus.groups=" + string2 + " ] property. SpaceURL will be appended with the attribute groups=" + string2);
            }
        }
    }

    public static Properties a(String string, SpaceURL spaceURL) {
        Properties properties;
        block20: {
            properties = null;
            try {
                Object object;
                properties = (Properties)spaceURL.get("customproperties");
                if (!JSpaceUtilities.isEmpty(string)) {
                    object = ResourceLoader.findCustomPropertiesObj(string);
                    properties.putAll((Map<?, ?>)object);
                    if (properties != null) {
                        spaceURL.put("customproperties", properties);
                    }
                }
                if (properties == null) break block20;
                object = properties.keys();
                while (object.hasMoreElements()) {
                    Object object2;
                    String string2;
                    String string3 = (String)object.nextElement();
                    int n2 = string3.lastIndexOf("gs.space.url.arg");
                    int n3 = string3.lastIndexOf("gs.space.url.arg_line");
                    int n4 = string3.lastIndexOf("-D");
                    if (n4 != -1) {
                        string2 = string3.substring(2);
                        object2 = properties.getProperty(string3);
                        if (!JSpaceUtilities.isEmpty((String)object2)) {
                            object2 = JSpaceUtilities.removeInvertedCommas((String)object2);
                        }
                        System.setProperty(string2, (String)object2);
                        if (!c.isLoggable(Level.FINE)) continue;
                        c.fine("Key - [" + string2 + "] Value - [" + (String)object2 + "] was set as a System Property from Properties object.");
                        continue;
                    }
                    if (n2 != -1 && n3 == -1) {
                        string2 = string3.substring(string3.lastIndexOf(46) + 1);
                        if (SpaceURL.getSpaceUrlAttributes().contains(string2.toLowerCase())) {
                            object2 = properties.getProperty(string3);
                            if (!JSpaceUtilities.isEmpty((String)object2)) {
                                object2 = JSpaceUtilities.removeInvertedCommas((String)object2);
                            }
                            if (((String)object2).equals("")) {
                                object2 = "true";
                            }
                            spaceURL.setProperty(string2.toLowerCase(), (String)object2);
                            if (!c.isLoggable(Level.FINE)) continue;
                            c.fine("SpaceURL attribute - [" + string2.toLowerCase() + "] Value - [" + (String)object2 + "] was added to SpaceURL from Properties object.");
                            continue;
                        }
                        if (!c.isLoggable(Level.FINE)) continue;
                        c.fine("A non valid SpaceURL attribute - [" + string2.toLowerCase() + "] Value - [" + properties.getProperty(string3) + "] was loaded from Properties object.");
                        continue;
                    }
                    if (n3 == -1) continue;
                    string2 = properties.getProperty(string3);
                    string2 = JSpaceUtilities.removeInvertedCommas(string2);
                    object2 = new StringTokenizer(string2, "&");
                    if (string3.indexOf("&") != -1) {
                        object2 = new StringTokenizer(((StringTokenizer)object2).nextToken(), "&");
                    }
                    String string4 = null;
                    String string5 = null;
                    int n5 = 0;
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        try {
                            StringTokenizer stringTokenizer = new StringTokenizer(((StringTokenizer)object2).nextToken(), "=");
                            string4 = stringTokenizer.nextToken().toLowerCase();
                            if (SpaceURL.getSpaceUrlAttributes().contains(string4.toLowerCase())) {
                                string5 = stringTokenizer.nextToken();
                                if (string5.equals("")) {
                                    string5 = "true";
                                }
                                spaceURL.setProperty(string4.toLowerCase(), string5);
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            spaceURL.setProperty(string4.toLowerCase(), "true");
                            string5 = null;
                        }
                        if (c.isLoggable(Level.FINE)) {
                            if (string5 != null) {
                                c.fine("SpaceURL attribute - [" + string4.toLowerCase() + "] Value - [" + string5 + "] was added to SpaceURL from Properties object.");
                            } else {
                                c.fine("SpaceURL attribute - [" + string4.toLowerCase() + "] Value - [true] was added to SpaceURL from Properties object.");
                            }
                        }
                        ++n5;
                    }
                }
            }
            catch (Throwable throwable) {
                if (!c.isLoggable(Level.INFO)) break block20;
                c.info("Could not set properties loaded from < " + string + " > custom properties file: " + throwable.getMessage());
            }
        }
        return properties;
    }

    public static SpaceURL c(SpaceURL spaceURL) {
        String string = spaceURL.getProperty("url");
        Hashtable<String, Entry> hashtable = new Hashtable<String, Entry>();
        spaceURL.put("GENERIC.LOOKUP.ATTRIBUES", hashtable);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?");
        if (stringTokenizer.countTokens() < 2) {
            return spaceURL;
        }
        stringTokenizer.nextToken();
        if (string.indexOf(38) != -1) {
            stringTokenizer = new StringTokenizer(stringTokenizer.nextToken(), "&");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = string2.split("=", 2);
            String string3 = stringArray[0].toLowerCase();
            if (stringArray.length < 2) {
                spaceURL.put(string3, "true");
                continue;
            }
            String string4 = stringArray[1];
            Entry entry = (Entry)a.get(string3);
            if (entry != null) {
                if (entry instanceof GenericEntry) {
                    hashtable.put(string3, ((GenericEntry)entry).fromString(string4));
                    continue;
                }
                if (!(entry instanceof Name)) continue;
                hashtable.put(string3, new Name(string4));
                continue;
            }
            spaceURL.put(string3, string4);
        }
        return spaceURL;
    }

    public static String getRMIDurl(String string) {
        if (string.indexOf(58) == -1) {
            return string + ':' + b;
        }
        return string;
    }

    public static void printUsage() {
        if (c.isLoggable(Level.INFO)) {
            c.info("Use: Protocol://[host]:[port]/[container_name]/[space_name]?[query_string]\nProtocol: [ RMI | JINI | JAVA (for embedded instance) | WS ]\n\nExamples of Space Urls:\n/./mySpace?schema=cache&properties=gs (which uses default gs.properties configuration file)\nor java://localhost:10098/containerNameor \nor java://localhost:10098/containerName/mySpace\nor /./mySpace (which translates to java://localhost:10098/containerName/mySpace?schema=default)\nor /./mySpace?schema=cache (which translates to java://localhost:10098/containerName/mySpace?schema=cache)");
            c.info("\nSetting up 4 nodes cluster with a partitioned cache with backup instances will be done using the following space url:\nFor Member 1: /./myCache?schema=cache&cluster_schema=partitioned&total_members=4,2&id=1\nFor Member 1 backup 1: /./myCache?schema=cache&cluster_schema=partitioned&total_members=4,2&id=2&backup_id=1");
            c.info("\nSetting up 4 nodes cluster with an async replicated policy will be done using the following space url:\nFor Member 1: /./myCache?schema=cache&cluster_schema=async_replicated&total_members=4&id=1\nFor Member 2: /./myCache?schema=cache&cluster_schema=async_replicated&total_members=4&id=2");
            c.info("\nExample of Multicast lookup using Jini: jini:/*/container name/space name\njini:/*/*/space name\njini:/*/container name\n\nExample of Unicast lookup using Jini: jini:/myhost/container name/space name\njini:/myhost/*/space name\njini:/myhost/container name\n\nExample of RMI protocol lookup: rmi:/myhost:port/container name/space name\nrmi:/myhost:port/*/space name\nrmi:/myhost:port/container name\nrmi:/myhost:port/*/space name\n");
        }
    }

    static {
        a.put("containername", new ContainerName());
        a.put("persistent", new Persistent());
        a.put("clustername", new ClusterName());
        a.put("clustergroup", new ClusterGroup());
        a.put("state", new State());
        a.put("servicename", new Name());
        c = Logger.getLogger("com.gigaspaces.client");
    }
}

