/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.DropClassException;
import com.j_spaces.core.EntryPacket;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.IRemoteJSpace;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.SecurityContext;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.JSpaceAdminProxy;
import com.j_spaces.core.client.AbstractSpaceProxy;
import com.j_spaces.core.client.ActionListener;
import com.j_spaces.core.client.ActionMaker;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.IMetaDataEntry;
import com.j_spaces.core.client.JSpaceProxyUtil;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.RegExQuery;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.TokenQuery;
import com.j_spaces.core.client.TypeTableEntry;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.core.service.Service;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.ParserManager;
import com.j_spaces.jdbc.QPConstants;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.map.Envelope;
import com.j_spaces.obf.cj;
import com.j_spaces.obf.ct;
import com.j_spaces.obf.fd;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.space.InternalSpaceException;

public abstract class AbstractDirectSpaceProxy
extends AbstractSpaceProxy
implements IDirectSpaceProxy,
Service,
ReferentUuid,
Serializable,
ActionMaker {
    private static final long serialVersionUID = 8175102445636269461L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");
    public final Uuid _uuid;
    private int _hashCode;
    public IRemoteJSpace m_RemoteJSpace;
    public boolean m_IsCollocated;
    public boolean m_IsVersioned = false;
    public boolean m_FifoProxy;
    public boolean m_NOWriteLeaseMode;
    public final int m_SerializationType;
    public final int m_ImplicitNumOfIndexes;
    public boolean m_EnforceSecurity;
    public String m_ContainerName;
    public String m_SpaceName;
    public IStubHandler m_StubHandler;
    public transient boolean m_Initialized_Proxy;
    public transient boolean m_Initialized_Proxy_Completed;
    public transient Object m_SpaceInitializeLock;
    public transient boolean m_CheckedSystemProperties;
    public transient SpaceContext m_SpaceContext;
    public transient Object m_SpaceContextLock;
    public transient Object m_RemoteJSpaceLock;
    public transient ParserManager m_ParserManager;
    public transient Hashtable m_ParserCacheHash;
    public Transaction m_defaultTxn = null;
    public transient ct m_encrypter;
    public ActionListener _actionListener = null;
    public IJSpaceContainer m_ContainerProxy;
    public transient int m_UpdateProxyModifiers;
    public transient int m_ReadTakeProxyModifiers;
    public static final Random _randomRetry = new Random();
    public static final int DELAY_RETRY_TIME = 1000;
    public static final String _codebase = System.getProperty("java.rmi.server.codebase");
    public final String _timeProvider = System.getProperty("com.gs.time-provider");
    private boolean _isOneWay;
    public final String _memberName;
    public JSpaceAttributes _spaceAttributes;
    public transient IJSpace _embeddedProxy;
    public transient JSpaceProxyUtil _proxyUtil;
    public SpaceURL _spaceURL;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractDirectSpaceProxy(IJSpace iJSpace, IJSpaceContainer iJSpaceContainer, IRemoteJSpace iRemoteJSpace, Uuid uuid, String string, String string2, boolean bl2, boolean bl3, IStubHandler iStubHandler, int n2, int n3, JSpaceAttributes jSpaceAttributes) {
        fd.b(iRemoteJSpace, "server cannot be null");
        fd.b(uuid, "uuid cannot be null");
        this._uuid = uuid;
        this._hashCode = uuid.hashCode();
        this._embeddedProxy = iJSpace;
        this.m_ContainerProxy = iJSpaceContainer;
        this.m_RemoteJSpace = iRemoteJSpace;
        this.m_ContainerName = string;
        this.m_SpaceName = string2;
        this.m_IsCollocated = bl2;
        this.m_SerializationType = n2;
        this.m_ImplicitNumOfIndexes = n3;
        this._spaceAttributes = jSpaceAttributes;
        this.m_EnforceSecurity = bl3;
        this.m_StubHandler = iStubHandler;
        this.preInitializeProxy();
        this.initilize();
        this._memberName = string + ":" + string2;
    }

    public abstract void init();

    public abstract void _setSecurityContext(SecurityContext var1) throws RemoteException;

    public abstract Envelope readEnvelope(Envelope var1) throws RemoteException, UnusableEntryException;

    public IJSpace getEmbeddedProxy() {
        return this.m_IsCollocated ? this : this._embeddedProxy;
    }

    public Uuid getReferentUuid() {
        return this._uuid;
    }

    public void setSecured(boolean bl2) {
        this.m_EnforceSecurity = bl2;
    }

    public String getMemberName() {
        return this._memberName;
    }

    public void setSecurityContext(SecurityContext securityContext) throws RemoteException {
        if (!this.m_Initialized_Proxy_Completed) {
            this.abstractProxyInit();
        }
        if (!this.isSecured()) {
            return;
        }
        if (securityContext == null) {
            throw new SpaceSecurityException("setSecurityContext: SecurityContext is null.");
        }
        if (this.m_encrypter == null) {
            this.m_encrypter = ct.a();
        }
        String string = securityContext.getUsername();
        String string2 = securityContext.getPassword();
        Object object = securityContext.getImplementorContext();
        if (!securityContext.isEncrypted() && !"ANONYMOUS".equals(string)) {
            string2 = this.m_encrypter.a(string2);
        }
        securityContext = new SecurityContext(string, string2);
        securityContext.setImplementorContext(object);
        securityContext.setEncrypted(true);
        this._setSecurityContext(securityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abstractProxyInit() {
        Object object = this.m_SpaceInitializeLock;
        synchronized (object) {
            if (this.m_Initialized_Proxy) {
                return;
            }
            this._isOneWay = Boolean.getBoolean("com.gs.onewaywrite") || Boolean.getBoolean("com.gs.onewayupdate");
            this.init();
            this.initParserManager();
            this.m_Initialized_Proxy = true;
        }
        this.m_Initialized_Proxy_Completed = true;
    }

    public void preInitializeProxy() {
        try {
            if (this._timeProvider != null) {
                System.setProperty("com.gs.time-provider", this._timeProvider);
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    public void setAnonymusSecurityContext() throws RemoteException {
        if (this.getSpaceContext() != null) {
            return;
        }
        this.setSecurityContext(new SecurityContext("ANONYMOUS", "ANONYMOUS"));
    }

    public void clean() throws RemoteException {
        SpaceContext spaceContext = this.checkPermission('W');
        this.getRemoteJSpace().clean(spaceContext);
        this.directClean();
    }

    public void directClean() {
        this._proxyUtil.clear();
        if (this.m_ParserManager != null) {
            this.m_ParserManager.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteJSpace getRemoteJSpace() {
        Object object = this.m_RemoteJSpaceLock;
        synchronized (object) {
            return this.m_RemoteJSpace;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_IsCollocated = false;
        this.initilize();
    }

    private void initilize() {
        this.m_SpaceContextLock = new Object();
        this.m_SpaceInitializeLock = new Object();
        this.m_RemoteJSpaceLock = new Object();
        this._proxyUtil = new JSpaceProxyUtil(this, this.m_SerializationType, this.m_ImplicitNumOfIndexes);
    }

    public void dropClass(String string) throws RemoteException, DropClassException {
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)this.getAdmin();
        iRemoteJSpaceAdmin.dropClass(string);
        this._proxyUtil.deleteClassDefinitionFromProxy(string);
    }

    public String getName() {
        return this.m_SpaceName;
    }

    public boolean isSecured() {
        return this.m_EnforceSecurity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpaceContext getSpaceContext() {
        Object object = this.m_SpaceContextLock;
        synchronized (object) {
            return this.m_SpaceContext;
        }
    }

    public SpaceContext checkPermission(char c2) throws RemoteException {
        String string;
        if (!this.isSecured()) {
            return null;
        }
        SpaceContext spaceContext = this.getSpaceContext();
        if (spaceContext == null && !this.m_CheckedSystemProperties) {
            string = System.getProperty("com.gs.security.userid");
            if (string != null) {
                String string2 = System.getProperty("com.gs.security.password");
                SecurityContext securityContext = new SecurityContext(string, string2);
                try {
                    this.setSecurityContext(securityContext);
                    spaceContext = this.getSpaceContext();
                }
                catch (RemoteException remoteException) {
                    System.out.println("ERROR SetSecurityContext failed during proxy initialization for user=" + string);
                    throw remoteException;
                }
            }
            this.m_CheckedSystemProperties = true;
        }
        if (spaceContext == null) {
            try {
                this.setAnonymusSecurityContext();
            }
            catch (Exception exception) {
                throw new SpaceSecurityException("setSecurityContext() failed for anonymous user", exception);
            }
            spaceContext = this.getSpaceContext();
        }
        if ((string = spaceContext.m_SecurityContext.getPermissions()) == null) {
            return spaceContext;
        }
        if (string.indexOf(c2) == -1) {
            throw new SpaceSecurityException("No local-permission for operation type: " + c2 + ". Operation aborted.");
        }
        return spaceContext;
    }

    public void setNOWriteLeaseMode(boolean bl2) {
        this.m_NOWriteLeaseMode = bl2;
    }

    public boolean isNOWriteLeaseMode() {
        return this.m_NOWriteLeaseMode;
    }

    public void setOptimisticLocking(boolean bl2) {
        this.m_IsVersioned = bl2;
    }

    public boolean isOptimisticLockingEnabled() {
        return this.m_IsVersioned;
    }

    public boolean isEmbedded() {
        return this.m_IsCollocated;
    }

    public void setFifo(boolean bl2) {
        this.m_FifoProxy = bl2;
    }

    public boolean isFifo() {
        return this.m_FifoProxy;
    }

    public Entry getEntryFromExternalEntry(Entry entry) throws UnusableEntryException {
        EntryPacket entryPacket = this.getGSEntry(entry);
        return this._proxyUtil.getEntry(entryPacket, false, this.m_IsVersioned);
    }

    public Entry getEntry(EntryPacket entryPacket) throws UnusableEntryException {
        return this._proxyUtil.getEntry(entryPacket, false, this.m_IsVersioned);
    }

    public ExternalEntry getExternalEntry(EntryPacket entryPacket) throws UnusableEntryException {
        return (ExternalEntry)this._proxyUtil.getEntry(entryPacket, true, this.m_IsVersioned);
    }

    public Entry getEntry(IGSEntry iGSEntry) throws UnusableEntryException {
        return this._proxyUtil.getEntry(iGSEntry.getClassName(), iGSEntry.getCodebase(), iGSEntry.getFieldsValues(), iGSEntry.getUID(), iGSEntry.getVersion(), iGSEntry.getTimeToLive(), iGSEntry.isFifo(), iGSEntry.isTransient(), this.m_IsVersioned);
    }

    public Entry getEntry(ExternalEntry externalEntry) throws UnusableEntryException {
        return this._proxyUtil.getEntry(externalEntry.getClassName(), null, externalEntry.getFieldsValues(), externalEntry.getUID(), externalEntry.getVersionID(), externalEntry.getTimeToLive(), externalEntry.isFifo(), externalEntry.isTransient(), this.m_IsVersioned);
    }

    public ExternalEntry getExternalEntry(IGSEntry iGSEntry) throws UnusableEntryException {
        return this._proxyUtil.getExternalEntry(iGSEntry.getClassName(), iGSEntry.getCodebase(), null, iGSEntry.getUID(), iGSEntry.getFieldsValues(), iGSEntry.getVersion(), iGSEntry.getTimeToLive(), iGSEntry.isTransient(), iGSEntry.getFieldsTypes(), iGSEntry.getFieldsNames(), iGSEntry.getSuperClassesNames(), iGSEntry.getIndexIndicators(), iGSEntry.isReplicatable(), iGSEntry.getFormat(), iGSEntry.getPrimaryKeyName(), iGSEntry.isFifo());
    }

    public void fillEntryPacket(EntryPacket entryPacket) {
        TypeTableEntry typeTableEntry = this._proxyUtil.isTypeInfo(entryPacket.m_ClassName);
        if (typeTableEntry == null) {
            throw new InternalSpaceException(this.m_SpaceName + " TypeTableEntry not found for : " + entryPacket.m_ClassName);
        }
        entryPacket.m_FieldsNames = typeTableEntry.m_FieldsNames;
        entryPacket.m_FieldsTypes = typeTableEntry.m_FieldsTypes;
        entryPacket.m_SuperClasses = typeTableEntry.m_SuperClasses;
        entryPacket.m_CodeBase = typeTableEntry.m_CodeBase;
        entryPacket.m_IndexIndicators = typeTableEntry.m_IndexedFields;
        entryPacket.m_Replicatable = typeTableEntry.m_IsReplicatable;
        entryPacket._firstIndexName = typeTableEntry.getFirstIndexName();
        entryPacket._objectFormat = typeTableEntry.getObjectFormat();
    }

    public EntryPacket getGSEntry(Entry entry) {
        if (entry == null) {
            return new EntryPacket();
        }
        if (entry instanceof EntrySnapshot) {
            EntrySnapshot entrySnapshot = (EntrySnapshot)entry;
            EntryPacket entryPacket = entrySnapshot.getEntryPacket();
            TypeTableEntry typeTableEntry = this._proxyUtil.isTypeInfo(entryPacket.m_ClassName);
            entryPacket.m_CodeBase = typeTableEntry.getCodeBase();
            entryPacket.m_SuperClasses = typeTableEntry.getSuperClasses();
            entryPacket.m_FieldsNames = typeTableEntry.getFieldsNames();
            entryPacket.m_FieldsTypes = typeTableEntry.getFieldsTypes();
            entryPacket.m_IndexIndicators = typeTableEntry.getIndexedFields();
            entryPacket.m_Replicatable = typeTableEntry.isReplicatable();
            entryPacket._objectFormat = typeTableEntry.getObjectFormat();
            entryPacket._firstIndexName = typeTableEntry.getFirstIndexName();
            return entryPacket;
        }
        EntryPacket entryPacket = this._proxyUtil.buildEntryPacket(entry);
        if (this.m_FifoProxy) {
            entryPacket.m_FifoOrder = this.m_FifoProxy;
        }
        if (this.m_NOWriteLeaseMode) {
            entryPacket.m_NOWriteLease = this.m_NOWriteLeaseMode;
        }
        if (entry instanceof IMetaDataEntry) {
            IMetaDataEntry iMetaDataEntry = (IMetaDataEntry)entry;
            if (!this.m_FifoProxy) {
                entryPacket.m_FifoOrder = iMetaDataEntry.isFifo();
            }
            if (!this.m_NOWriteLeaseMode) {
                entryPacket.m_NOWriteLease = iMetaDataEntry.isNOWriteLeaseMode();
            }
        }
        return entryPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPacket getEntryPacket(IRemoteJSpace iRemoteJSpace, Entry entry, TypeTableEntry typeTableEntry, boolean bl2, boolean bl3) {
        Object[] objectArray;
        if (entry == null || typeTableEntry == null) {
            return new EntryPacket();
        }
        String string = null;
        boolean bl4 = this.m_FifoProxy;
        boolean bl5 = false;
        boolean bl6 = this.m_NOWriteLeaseMode;
        int n2 = 0;
        if (entry instanceof ExternalEntry) {
            objectArray = (ExternalEntry)entry;
            string = objectArray.m_UID;
            n2 = objectArray.m_VersionID;
            if (!this.m_FifoProxy) {
                bl4 = objectArray.m_isFifo;
            }
            bl5 = objectArray.m_isTransient;
            if (!this.m_NOWriteLeaseMode) {
                bl6 = objectArray.m_NOWriteLeaseMode;
            }
        } else {
            if (typeTableEntry.m_GetUidMethod != null) {
                string = JSpaceProxyUtil.getEntryUid(entry, typeTableEntry);
            }
            if ((typeTableEntry.m_GetEntryInfoMethod != null || this.m_IsVersioned) && (objectArray = JSpaceProxyUtil.getEntryInfo(entry, typeTableEntry)) != null) {
                string = objectArray.m_UID;
                n2 = objectArray.m_VersionID;
            }
            if (entry instanceof IMetaDataEntry) {
                objectArray = (IMetaDataEntry)entry;
                bl5 = objectArray.isTransient();
                if (!this.m_FifoProxy) {
                    bl4 = objectArray.isFifo();
                }
                if (!this.m_NOWriteLeaseMode) {
                    bl6 = objectArray.isNOWriteLeaseMode();
                }
            }
        }
        if (!this.m_IsVersioned) {
            n2 = 0;
        }
        objectArray = this._proxyUtil.getEntryValues(entry, typeTableEntry);
        if (this.m_SerializationType == 0 && string == null && !typeTableEntry.m_UnusableNoSerilFields.isEmpty()) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || !bl2) continue;
                Class<?> clazz = typeTableEntry.m_Fields[i2].getType();
                Class<?> clazz2 = class$java$lang$Object;
                if (clazz2 == null) {
                    clazz2 = new Object[0].getClass().getComponentType();
                }
                if (clazz == clazz2 || !typeTableEntry.m_UnusableNoSerilFields.contains(typeTableEntry.m_Fields[i2])) continue;
                String string2 = "\n Entry class: " + typeTableEntry.getClassName() + "\n Field name: " + typeTableEntry.m_Fields[i2].getName() + "\n must implement equals() and hashCode() methods when using 'Native Serialization' mode.";
                throw new IllegalArgumentException(string2);
            }
        }
        if (typeTableEntry.isFirstTime(iRemoteJSpace) || bl3) {
            TypeTableEntry typeTableEntry2 = typeTableEntry;
            synchronized (typeTableEntry2) {
                if (typeTableEntry.isFirstTime(iRemoteJSpace) || bl3) {
                    EntryPacket entryPacket;
                    block24: {
                        entryPacket = new EntryPacket(typeTableEntry.getClassName(), string, typeTableEntry.getCodeBase(), typeTableEntry.getSuperClasses(), typeTableEntry.getFieldsNames(), typeTableEntry.getFieldsTypes(), typeTableEntry.m_SuperClassesChecksum, typeTableEntry.m_FieldsNamesChecksum, typeTableEntry.m_FieldsTypesChecksum, objectArray, n2, 0L, typeTableEntry.getIndexedFields(), typeTableEntry.isReplicatable(), bl4, bl5, bl6, typeTableEntry.getObjectFormat(), typeTableEntry.getFirstIndexName());
                        try {
                            if (this._isOneWay) {
                                iRemoteJSpace.snapshot(entryPacket);
                            }
                            typeTableEntry.setFirstTime(iRemoteJSpace);
                        }
                        catch (Exception exception) {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.fine(this.m_SpaceName + " space RegisterFirstTime [" + typeTableEntry.getClassName() + "] -> Snapshot operation failed. Space might be failed down or proxy handles died RemoteSpace stub. Reason: " + exception);
                            }
                            if (exception instanceof RemoteException) break block24;
                            if (exception instanceof RuntimeException) {
                                throw (RuntimeException)exception;
                            }
                            throw new RuntimeException(this.m_SpaceName + " space RegisterFirstTime [" + typeTableEntry.getClassName() + "] -> Snapshot operation failed", exception);
                        }
                    }
                    return entryPacket;
                }
            }
        }
        return new EntryPacket(typeTableEntry.getClassName(), string, null, typeTableEntry.m_SuperClassesChecksum, typeTableEntry.m_FieldsNamesChecksum, typeTableEntry.m_FieldsTypesChecksum, objectArray, n2, 0L, bl4, bl5, bl6, typeTableEntry.getObjectFormat());
    }

    public final EntryPacket getEntryPacketFromEntry(IRemoteJSpace iRemoteJSpace, Entry entry, boolean bl2) {
        return this.getEntryPacketFromEntry(iRemoteJSpace, entry, bl2, false);
    }

    public final EntryPacket getEntryPacketFromEntry(IRemoteJSpace iRemoteJSpace, Entry entry, boolean bl2, boolean bl3) {
        if (entry == null) {
            return new EntryPacket();
        }
        if (entry instanceof ExternalEntry) {
            return this.getEntryPacketFromExternalEntry(iRemoteJSpace, entry, bl2, bl3);
        }
        if (entry instanceof EntrySnapshot) {
            return ((EntrySnapshot)entry).getEntryPacket();
        }
        Class<?> clazz = entry.getClass();
        String string = clazz.getName();
        TypeTableEntry typeTableEntry = this._proxyUtil.isTypeInfo(string);
        if (typeTableEntry != null && typeTableEntry.m_Class != null) {
            return this.getEntryPacket(iRemoteJSpace, entry, typeTableEntry, bl2, bl3);
        }
        return this.getEntryPacket(iRemoteJSpace, entry, this._proxyUtil.getTypeInfo(string, RMIClassLoader.getClassAnnotation(clazz), entry), bl2, bl3);
    }

    public final EntryPacket getEntryPacketFromExternalEntry(IRemoteJSpace iRemoteJSpace, Entry entry, boolean bl2) {
        return this.getEntryPacketFromExternalEntry(iRemoteJSpace, entry, bl2, false);
    }

    public final EntryPacket getEntryPacketFromExternalEntry(IRemoteJSpace iRemoteJSpace, Entry entry, boolean bl2, boolean bl3) {
        if (entry == null) {
            return new EntryPacket();
        }
        ExternalEntry externalEntry = (ExternalEntry)entry;
        if (externalEntry.m_ClassName == null) {
            if (externalEntry.m_UID != null) {
                return new EntryPacket(externalEntry.m_UID, externalEntry.m_VersionID);
            }
            if (externalEntry.m_MultipleUIDs != null && externalEntry.m_MultipleUIDs.length > 0) {
                return new EntryPacket(externalEntry.m_MultipleUIDs);
            }
            return new EntryPacket();
        }
        TypeTableEntry typeTableEntry = this._proxyUtil.isTypeInfo(externalEntry.m_ClassName);
        if (typeTableEntry != null) {
            return this.getEntryPacket(iRemoteJSpace, entry, typeTableEntry, bl2, bl3);
        }
        return this.getEntryPacket(iRemoteJSpace, entry, this._proxyUtil.getTypeInfo(externalEntry.m_ClassName, _codebase, entry), bl2, bl3);
    }

    public EntryPacket constructEntryPacketFromEntry(Entry entry) {
        return this.getEntryPacketFromEntry(this.m_RemoteJSpace, entry, true);
    }

    public int getImplicitNumOfIndexes() {
        return this.m_ImplicitNumOfIndexes;
    }

    public int getSerializationType() {
        return this.m_SerializationType;
    }

    public Object getAdmin() throws RemoteException {
        SpaceContext spaceContext = this.checkPermission('A');
        IRemoteJSpace iRemoteJSpace = this.getRemoteJSpace();
        if (iRemoteJSpace == null) {
            throw new RemoteException("Admin object is not available. Space: " + this.m_ContainerName + ":" + this.m_SpaceName + " might be down.");
        }
        iRemoteJSpace.getAdmin(spaceContext);
        Object object = ((Administrable)((Object)this.m_RemoteJSpace)).getAdmin();
        if (object instanceof JSpaceAdminProxy) {
            ((JSpaceAdminProxy)object).setSpace(this);
        }
        return object;
    }

    private void initParserManager() {
        QPConstants.SPACE_READ_LEASE = this._spaceAttributes.getQpSpaceReadLeaseTime();
        QPConstants.SPACE_WRITE_LEASE = this._spaceAttributes.getQpSpaceWriteLeaseTime();
        QPConstants.TRANSACTION_TIMEOUT = this._spaceAttributes.getQpTransactionTimeout();
        QPConstants.PARSER_CASE_SENSETIVITY = this._spaceAttributes.isQPParserCaseSensetivity();
        QPConstants.DATE_FORMAT = this._spaceAttributes.getQpDateFormat();
        QPConstants.DATETIME_FORMAT = this._spaceAttributes.getQpDateTimeFormat();
        QPConstants.TIME_FORMAT = this._spaceAttributes.getQpTimeFormat();
        this.m_ParserManager = ParserManager.getInstance(true);
        this.m_ParserCacheHash = new Hashtable();
    }

    private Query prepareStatement(Entry entry, String string, Transaction transaction) throws SQLException {
        QPConstants.PARSER_CASE_SENSETIVITY = true;
        Query query = null;
        transaction = this.beforeSpaceAction(transaction);
        if (string != null && string.length() != 0 && string.indexOf("?") < 0) {
            query = this.m_ParserManager.handleStatement(string, this, this.m_ParserCacheHash);
        } else {
            Object[] objectArray;
            String[] stringArray;
            AbstractDMLQuery abstractDMLQuery = (AbstractDMLQuery)this.m_ParserManager.handleStatement(string, this, this.m_ParserCacheHash);
            AbstractDMLQuery abstractDMLQuery2 = (AbstractDMLQuery)abstractDMLQuery.clone();
            if (entry instanceof ExternalEntry) {
                stringArray = ((ExternalEntry)entry).getFieldsNames();
                objectArray = ((ExternalEntry)entry).getFieldsValues();
            } else {
                Entry entry2 = ((SQLQuery)entry).getEntry();
                EntryPacket entryPacket = this.getGSEntry(entry2);
                stringArray = entryPacket.m_FieldsNames;
                objectArray = entryPacket.m_FieldsValues;
            }
            abstractDMLQuery2.setTemplatePreparedValues(stringArray, objectArray);
            query = abstractDMLQuery2;
        }
        return query;
    }

    private ResponsePacket executeSqlStatment(Query query, Transaction transaction) throws SQLException {
        ResponsePacket responsePacket = null;
        responsePacket = query.executeOnSpace(this, transaction, this.m_ParserCacheHash);
        return responsePacket;
    }

    private String buildQuery(String string, SQLQuery sQLQuery, int n2) {
        if (sQLQuery.isStoredProcedure()) {
            return sQLQuery.m_Expression;
        }
        StringBuffer stringBuffer = new StringBuffer(string + " from ");
        stringBuffer.append(sQLQuery.m_ClassName);
        if (n2 == 1) {
            stringBuffer.append(" where rownum=1");
        } else if (n2 < Integer.MAX_VALUE) {
            stringBuffer.append(" where rownum<=" + n2);
        }
        if (sQLQuery.m_Expression != null && sQLQuery.m_Expression.length() != 0) {
            if (sQLQuery.hasWhereClause()) {
                if (n2 == Integer.MAX_VALUE) {
                    stringBuffer.append(" where ");
                } else {
                    stringBuffer.append(" and ");
                }
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(sQLQuery.m_Expression);
        }
        return stringBuffer.toString();
    }

    public Object executeSQLQuery(String string, SQLQuery sQLQuery, Transaction transaction, int n2, boolean bl2) throws RemoteException {
        this.introduceTemplate(sQLQuery);
        String string2 = null;
        try {
            int n3;
            Object object;
            ResponsePacket responsePacket;
            string2 = this.buildQuery(string, sQLQuery, n2);
            Query query = this.prepareStatement(sQLQuery, string2, transaction);
            if (query instanceof AbstractDMLQuery && !bl2) {
                ((AbstractDMLQuery)query).setConvertResultToArray(false);
            }
            if ((responsePacket = this.executeSqlStatment(query, transaction)).getException() != null) {
                throw responsePacket.getException();
            }
            ResultEntry resultEntry = responsePacket.getResultEntry();
            Object[][] objectArray = null;
            if (resultEntry != null) {
                objectArray = resultEntry.getFieldValues();
            }
            if (bl2 && objectArray != null) {
                return objectArray[0][0];
            }
            Entry[] entryArray = new Entry[]{};
            Collection collection = responsePacket.getResultSet();
            if (collection != null) {
                entryArray = collection.toArray(entryArray);
            } else if (objectArray != null) {
                entryArray = new Entry[objectArray.length];
                object = this._proxyUtil.getTypeInfo(sQLQuery.getEntry());
                for (n3 = 0; n3 < entryArray.length; ++n3) {
                    entryArray[n3] = new ExternalEntry(object.m_ClassName, objectArray[n3], resultEntry.getFieldNames(), object.m_FieldsTypes);
                }
            }
            if (!sQLQuery.isExternalEntry()) {
                object = new Entry[entryArray.length];
                for (n3 = 0; n3 < entryArray.length; ++n3) {
                    object[n3] = this.getEntryFromExternalEntry(entryArray[n3]);
                }
                entryArray = object;
            }
            return entryArray;
        }
        catch (Exception exception) {
            throw new RemoteException("Failed to execute SQLQuery : [" + string2 + "]", exception);
        }
    }

    public Entry readSQLTemplate(SQLQuery sQLQuery, Transaction transaction) throws RemoteException {
        Entry[] entryArray = (Entry[])this.executeSQLQuery("select *", sQLQuery, transaction, 1, false);
        if (entryArray.length == 0) {
            return null;
        }
        return entryArray[0];
    }

    public Entry getSQLTemplate(SQLQuery sQLQuery, Transaction transaction) throws RemoteException {
        this.introduceTemplate(sQLQuery);
        String string = null;
        try {
            string = this.buildQuery("select *", sQLQuery, Integer.MAX_VALUE);
            Query query = this.prepareStatement(sQLQuery, string, transaction);
            ((AbstractDMLQuery)query).setNotifyQuery(true);
            ((AbstractDMLQuery)query).setConvertResultToArray(false);
            query.validateQuery(this, this.m_ParserCacheHash);
            ResponsePacket responsePacket = this.executeSqlStatment(query, transaction);
            if (responsePacket.getException() != null) {
                throw responsePacket.getException();
            }
            Collection collection = responsePacket.getResultSet();
            Entry[] entryArray = (Entry[])collection.toArray();
            if (entryArray == null || entryArray.length == 0) {
                return null;
            }
            Entry entry = entryArray[0];
            return entry;
        }
        catch (Exception exception) {
            throw new RemoteException("Failed to execute SQLQuery : [" + string + "]", exception);
        }
    }

    private void introduceTemplate(SQLQuery sQLQuery) throws RemoteException {
        if (this._proxyUtil.isTypeInfo(sQLQuery.m_ClassName) == null) {
            Object object;
            Object object2 = object = sQLQuery.getObject() != null ? sQLQuery.getObject() : sQLQuery.getEntry();
            if (object != null) {
                this.snapshot(object);
            } else {
                throw new IllegalArgumentException("Insufficient field-type information in ExternalEntry for class: " + sQLQuery.m_ClassName + ";\nTo appropriately introduce the ExternalEntry, construct it with it's field-names and field-types.");
            }
        }
    }

    public int countSQL(SQLQuery sQLQuery, Transaction transaction) throws RemoteException {
        return (Integer)this.executeSQLQuery("select count(*)", sQLQuery, transaction, 1, true);
    }

    public Entry[] readMultSQLTemplate(SQLQuery sQLQuery, Transaction transaction, int n2) throws RemoteException {
        return (Entry[])this.executeSQLQuery("select *", sQLQuery, transaction, n2, false);
    }

    public Entry[] takeMultSQLTemplate(SQLQuery sQLQuery, Transaction transaction, int n2) throws RemoteException {
        return (Entry[])this.executeSQLQuery("delete", sQLQuery, transaction, n2, false);
    }

    public Entry takeSQLTemplate(SQLQuery sQLQuery, Transaction transaction) throws RemoteException {
        Entry[] entryArray = (Entry[])this.executeSQLQuery("delete", sQLQuery, transaction, 1, false);
        if (entryArray.length == 0) {
            return null;
        }
        return entryArray[0];
    }

    public Entry[] readMultRegExQuery(RegExQuery regExQuery, Transaction transaction, boolean bl2, int n2) throws RemoteException, TransactionException, UnusableEntryException {
        Entry[] entryArray = bl2 ? this.takeMultiple(regExQuery.getExternalEntry(), transaction, n2) : this.readMultiple(regExQuery.getExternalEntry(), transaction, n2);
        if (entryArray != null && !regExQuery.isExternalEntry()) {
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                entryArray[i2] = this.getEntryFromExternalEntry(entryArray[i2]);
            }
        }
        return entryArray;
    }

    public Entry readRegExQuery(RegExQuery regExQuery, Transaction transaction, long l2, boolean bl2, boolean bl3) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        Entry entry = null;
        if (!bl2 && !bl3) {
            entry = this.read(regExQuery.getExternalEntry(), transaction, l2);
        } else if (bl2 && !bl3) {
            entry = this.readIfExists(regExQuery.getExternalEntry(), transaction, l2);
        } else if (!bl2 && bl3) {
            entry = this.take(regExQuery.getExternalEntry(), transaction, l2);
        } else if (bl2 && bl3) {
            entry = this.takeIfExists(regExQuery.getExternalEntry(), transaction, l2);
        }
        if (!regExQuery.isExternalEntry()) {
            entry = this.getEntryFromExternalEntry(entry);
        }
        return entry;
    }

    public abstract long checkLocalXtnValidityAndGetLease(ServerTransaction var1) throws TransactionException;

    public Lease writeExternalizableEntry(IRemoteJSpace iRemoteJSpace, Object object, Transaction transaction, long l2, int n2) throws RemoteException, TransactionException {
        IMetaDataEntry iMetaDataEntry;
        boolean bl2 = false;
        IMetaDataEntry iMetaDataEntry2 = iMetaDataEntry = object instanceof IMetaDataEntry ? (IMetaDataEntry)object : null;
        if (iMetaDataEntry != null && iMetaDataEntry.__getEntryInfo() == null) {
            iMetaDataEntry = (IMetaDataEntry)object;
            if (iMetaDataEntry.isFifo() || this.isFifo()) {
                n2 |= 0x800;
            }
            if ((bl2 = iMetaDataEntry.isNOWriteLeaseMode()) || this.isNOWriteLeaseMode() || Modifiers.isNoReturnValue(n2)) {
                n2 |= 0x80;
            }
        } else {
            bl2 = this.isNOWriteLeaseMode();
            if (bl2) {
                n2 |= 2;
            }
            if (this.isFifo()) {
                n2 |= 0x800;
            }
        }
        Lease lease = iRemoteJSpace.write(object, transaction, l2, n2 | 0x400);
        lease = cj.a(lease, iRemoteJSpace, iMetaDataEntry);
        if (bl2) {
            return null;
        }
        return lease;
    }

    public Lease[] writeExternalizableEntry(IRemoteJSpace iRemoteJSpace, Object[] objectArray, Transaction transaction, long l2, int n2) throws RemoteException, TransactionException {
        IMetaDataEntry[] iMetaDataEntryArray;
        boolean bl2 = this.isNOWriteLeaseMode();
        IMetaDataEntry[] iMetaDataEntryArray2 = iMetaDataEntryArray = objectArray instanceof IMetaDataEntry[] ? (IMetaDataEntry[])objectArray : null;
        if (iMetaDataEntryArray != null) {
            iMetaDataEntryArray = (IMetaDataEntry[])objectArray;
            if (bl2 || Modifiers.isNoReturnValue(n2)) {
                n2 |= 0x80;
            }
        } else if (bl2) {
            n2 |= 2;
        }
        if (this.isFifo()) {
            n2 |= 0x800;
        }
        Lease[] leaseArray = iRemoteJSpace.writeMultiple(objectArray, transaction, l2, n2 | 0x400);
        leaseArray = cj.a(leaseArray, iRemoteJSpace, iMetaDataEntryArray);
        if (bl2) {
            return null;
        }
        return leaseArray;
    }

    public IStubHandler getStubHandler() {
        return this.m_StubHandler;
    }

    public void setDefaultTransaction(Transaction transaction) {
        this.m_defaultTxn = transaction;
    }

    public IJSpaceContainer getContainer() {
        return this.m_ContainerProxy;
    }

    public static long getRandomRetryDelay() {
        return _randomRetry.nextInt(1000) + 1000;
    }

    public void setActionListener(ActionListener actionListener) {
        this._actionListener = actionListener;
    }

    public void sleepBeforeRetry() throws InterruptedException {
        Thread.sleep(AbstractDirectSpaceProxy.getRandomRetryDelay());
    }

    public Transaction beforeSpaceAction(Transaction transaction) {
        if (!this.m_Initialized_Proxy_Completed) {
            this.abstractProxyInit();
        }
        if (this._actionListener != null) {
            this._actionListener.action();
        }
        return transaction == null ? this.m_defaultTxn : transaction;
    }

    public int handleTokenizedTemplate(TokenQuery tokenQuery, Entry entry) {
        String string;
        String string2 = tokenQuery.getTokenizedFieldName();
        String string3 = _codebase;
        if (entry instanceof ExternalEntry) {
            string = ((ExternalEntry)entry).m_ClassName;
        } else {
            string3 = RMIClassLoader.getClassAnnotation(entry.getClass());
            string = entry.getClass().getName();
        }
        TypeTableEntry typeTableEntry = this._proxyUtil.getTypeInfo(string, string3, entry);
        int n2 = -1;
        String[] stringArray = typeTableEntry.getFieldsNames();
        if (stringArray != null) {
            n2 = typeTableEntry.getTokenizedFieldPosition();
            for (int i2 = 0; n2 == -1 && i2 < stringArray.length; ++i2) {
                if (!stringArray[i2].equalsIgnoreCase(string2)) continue;
                String string4 = typeTableEntry.m_FieldsTypes[i2];
                Class<?> clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = new String[0].getClass().getComponentType();
                }
                if (!string4.equals(clazz.getName())) {
                    throw new InternalSpaceException("TokenQuery's tokenizer field '" + string2 + "' must be of type java.lang.String");
                }
                n2 = i2;
                typeTableEntry.setTokenizedFieldPosition(n2);
            }
        }
        if (n2 == -1) {
            throw new InternalSpaceException("TokenQuery's entry '" + entry.getClass().getName() + "' does not contain '" + string2 + "' field");
        }
        if (!stringArray[n2].equals(string2)) {
            throw new InternalSpaceException("TokenQuery allows only one tokenized field per class");
        }
        return n2;
    }

    public int setUpdateModifiers(int n2) {
        if (UpdateModifiers.isUpdateOrWrite(n2) && UpdateModifiers.isPartialUpdate(n2)) {
            throw new RuntimeException("setUpdateMode:invalid update modifiers- PARTIAL Update cannot be specified with UPDATE_OR_WRITE ");
        }
        int n3 = this.m_UpdateProxyModifiers;
        this.m_UpdateProxyModifiers = n2;
        return n3;
    }

    public int getUpdateModifiers() {
        return this.m_UpdateProxyModifiers;
    }

    public int setReadTakeModifiers(int n2) {
        int n3 = this.m_ReadTakeProxyModifiers;
        this.m_ReadTakeProxyModifiers = n2;
        return n3;
    }

    public int getReadTakeModifiers() {
        return this.m_ReadTakeProxyModifiers;
    }

    public SpaceURL getURL() {
        return this._spaceURL;
    }

    public void setURL(SpaceURL spaceURL) {
        this._spaceURL = spaceURL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractDirectSpaceProxy) {
            return this._uuid.equals(((AbstractDirectSpaceProxy)object)._uuid);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return this.m_ContainerName + ":" + this.m_SpaceName;
    }
}

