/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.j_spaces.core.IRemoteJSpace;
import com.j_spaces.core.JSpaceImpl;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.LeaseMapProxy;
import com.j_spaces.core.client.EntryInfo;
import com.j_spaces.kernel.time.SystemTime;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

public class LeaseProxy
implements LeaseContext,
Externalizable {
    private static final long serialVersionUID = 1L;
    public transient long m_AbsExprTime;
    public transient IRemoteJSpace m_EmbeddedSpace;
    public transient IRemoteJSpace m_RemoteSpace;
    private int m_SerialFormat;
    private boolean m_PartialSerialization;
    public String m_EntryUID;
    public String m_Classname;
    public int m_SAObjectType;
    public boolean isTimeout;

    public LeaseProxy() {
    }

    public LeaseProxy(long l2, String string, JSpaceImpl jSpaceImpl) {
        this.m_AbsExprTime = l2;
        this.m_EntryUID = string;
        this.m_EmbeddedSpace = jSpaceImpl;
        this.m_SerialFormat = 1;
    }

    public LeaseProxy(long l2, String string, JSpaceImpl jSpaceImpl, String string2, int n2) {
        this(l2, string, jSpaceImpl);
        this.m_Classname = string2;
        this.m_SAObjectType = n2;
        if (jSpaceImpl != null && jSpaceImpl.i != null && jSpaceImpl.i.b.k && n2 == 1) {
            this.m_PartialSerialization = true;
        }
    }

    public boolean canBatch(Lease lease) {
        if (!(lease instanceof LeaseProxy)) {
            return false;
        }
        LeaseProxy leaseProxy = (LeaseProxy)lease;
        if (this.m_EmbeddedSpace == null) {
            return this.m_RemoteSpace.equals(leaseProxy.m_RemoteSpace);
        }
        return this.m_EmbeddedSpace.equals(leaseProxy.m_EmbeddedSpace);
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        if (this.m_EmbeddedSpace == null) {
            this.m_RemoteSpace.cancel(this.m_EntryUID, this.m_Classname, this.m_SAObjectType);
        } else {
            this.m_EmbeddedSpace.cancel(this.m_EntryUID, this.m_Classname, this.m_SAObjectType);
        }
    }

    public LeaseMap createLeaseMap(long l2) {
        return new LeaseMapProxy(this, l2);
    }

    public long getExpiration() {
        return this.m_AbsExprTime;
    }

    public int getSerialFormat() {
        return this.m_SerialFormat;
    }

    public void setSerialFormat(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid serial format");
        }
        this.m_SerialFormat = n2;
    }

    public void renew(long l2) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        long l3 = this.m_EmbeddedSpace == null ? this.m_RemoteSpace.renew(this.m_EntryUID, this.m_Classname, this.m_SAObjectType, l2) : this.m_EmbeddedSpace.renew(this.m_EntryUID, this.m_Classname, this.m_SAObjectType, l2);
        this.m_AbsExprTime = SystemTime.timeMillis() + l3;
        if (this.m_AbsExprTime < 0L) {
            this.m_AbsExprTime = Long.MAX_VALUE;
        }
    }

    public IRemoteJSpace getSpace() {
        return this.m_EmbeddedSpace == null ? this.m_RemoteSpace : this.m_EmbeddedSpace;
    }

    public void setExprInternal(long l2) {
        this.m_AbsExprTime = l2;
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public int getObjectType() {
        return this.m_SAObjectType;
    }

    public String getUID() {
        return this.m_EntryUID;
    }

    public void setUID(String string) {
        this.m_EntryUID = string;
    }

    public EntryInfo getEntryInfo() {
        return new EntryInfo(this.m_EntryUID, 1);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.m_RemoteSpace = (IRemoteJSpace)objectInput.readObject();
        this.m_EntryUID = objectInput.readUTF();
        this.m_SerialFormat = objectInput.readInt();
        this.m_PartialSerialization = objectInput.readBoolean();
        if (!this.m_PartialSerialization && objectInput.readBoolean()) {
            this.m_Classname = objectInput.readUTF();
        }
        this.m_SAObjectType = objectInput.readInt();
        this.m_AbsExprTime = objectInput.readLong();
        if (this.m_SerialFormat == 1) {
            this.m_AbsExprTime += SystemTime.timeMillis();
            if (this.m_AbsExprTime < 0L) {
                this.m_AbsExprTime = Long.MAX_VALUE;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.m_RemoteSpace);
        objectOutput.writeUTF(this.m_EntryUID);
        objectOutput.writeInt(this.m_SerialFormat);
        if (this.m_PartialSerialization) {
            objectOutput.writeBoolean(true);
        } else {
            objectOutput.writeBoolean(false);
            if (this.m_Classname != null) {
                objectOutput.writeBoolean(true);
                objectOutput.writeUTF(this.m_Classname);
            } else {
                objectOutput.writeBoolean(false);
            }
        }
        objectOutput.writeInt(this.m_SAObjectType);
        objectOutput.writeLong(this.m_SerialFormat == 2 ? this.m_AbsExprTime : this.m_AbsExprTime - SystemTime.timeMillis());
    }

    public void setSpaceStub(IRemoteJSpace iRemoteJSpace) {
        this.m_RemoteSpace = iRemoteJSpace;
    }

    public Object getObject() {
        return null;
    }

    public void setObject(Object object) {
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }
}

