/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.HostName;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.BufferedReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Level;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class ListSpaces
extends AbstractSpaceCommand {
    public static final int a = 1;
    public static final int b = 2;
    public static final int c = 4;
    private OptionHandler d;
    public static final String OPERATION_NAME = "list";
    private static int[] e = new int[]{15, 12, 8, 10, 11, 10, 12, 21, 21, 15};
    private static String[] f = new String[]{"Space name", "count", "secured", "clustered", "persistent", "state", "schema", "jini group", "container name", "host name"};
    private static final String g = "Yes";
    private static final String h = "No";
    static /* synthetic */ Class class$com$j_spaces$lookup$entry$HostName;
    static /* synthetic */ Class class$com$j_spaces$lookup$entry$ContainerName;

    public ListSpaces() {
        String[] stringArray = new String[]{"h", "help", "url", "c", "cluster", "stats", "noRTI", "noCount", "entry"};
        this.d = new OptionHandler(Formatter.fromArray((String[])stringArray));
        this.searchedSpaceState = -1;
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*****************************************************\n");
        stringBuffer.append("Usage: space list [options]\n");
        stringBuffer.append("options:\n");
        stringBuffer.append("\t-h/-help    prints help\n");
        stringBuffer.append("\t-url    space url\n");
        stringBuffer.append("\t-c/-cluster    cluster operation\n");
        stringBuffer.append("\t-stats\n");
        stringBuffer.append("\t-noRTI/-noCount\n");
        return stringBuffer.toString();
    }

    public String process(String string, BufferedReader bufferedReader) {
        try {
            Map map = this.d.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            int n2 = 0;
            n2 |= 4;
            if (map.containsKey("stats")) {
                n2 |= 1;
            } else if (map.containsKey("noRTI") || map.containsKey("noCount")) {
                n2 |= 2;
            }
            ServiceItem[] serviceItemArray = null;
            String string2 = (String)map.get("url");
            if (map.containsKey("url")) {
                ClusterPolicy clusterPolicy;
                if (JSpaceUtilities.isEmpty(string2, true)) {
                    CLIUtilities.printMissingValueMessage("url");
                    return "";
                }
                Object object = null;
                try {
                    object = this.find(string2);
                }
                catch (FinderException finderException) {
                    return "";
                }
                if (object == null) {
                    CLIUtilities.printWrongServiceURLMessage(string2);
                    return "";
                }
                IJSpace iJSpace = null;
                if (object instanceof IJSpaceContainer) {
                    SpaceURL spaceURL = SpaceURLParser.parseURL(string2);
                    ServiceItem[] serviceItemArray2 = this.getContainerSpaces((IJSpaceContainer)object, spaceURL.getProtocol());
                    this.a(serviceItemArray2, n2);
                    return "";
                }
                if (object instanceof IJSpace) {
                    iJSpace = (IJSpace)object;
                }
                if ((clusterPolicy = this.getClusterPolicy(iJSpace)) != null) {
                    if (map.containsKey("c") || map.containsKey("cluster")) {
                        System.out.println("Attempting to receive cluster members...");
                        serviceItemArray = CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
                    } else {
                        String string3 = this.showClusterWarningMessageAndReadUserInput(bufferedReader);
                        if (string3 == null || string3.equals("c")) {
                            return "";
                        }
                        serviceItemArray = string3.equals("n") ? CLIFinder.findSpaceServices(string2, this.searchedSpaceState) : CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
                    }
                } else {
                    serviceItemArray = CLIFinder.findSpaceServices(string2, this.searchedSpaceState);
                }
            } else {
                serviceItemArray = CLIFinder.findAllSpaceServices();
            }
            if (serviceItemArray != null) {
                this.a(serviceItemArray, n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }

    public String showClusterWarningMessageAndReadUserInput(BufferedReader bufferedReader) throws IOException {
        String string = "The space is clustered.Do you want to display list of all the spaces members in this cluster?\nEnter \"y\" for Yes, \"n\" for displaying list with only one space.";
        System.out.println(string);
        return bufferedReader.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ServiceItem[] serviceItemArray, int n2) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if ((n2 & 1) != 0) {
            bl2 = true;
        }
        if ((n2 & 2) != 0) {
            bl3 = true;
        }
        if ((n2 & 4) != 0) {
            bl4 = true;
        }
        StringBuffer stringBuffer = null;
        System.out.println(ListSpaces.a(f));
        String string = "---------------------------------------------------------------------------------------------------------------------------------";
        System.out.println(string);
        if (serviceItemArray != null) {
            for (int i2 = 0; i2 < serviceItemArray.length; ++i2) {
                String string2;
                Object var31_35;
                Object object;
                String string22;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                SpaceURL spaceURL;
                String string3;
                IJSpace iJSpace;
                block37: {
                    iJSpace = (IJSpace)serviceItemArray[i2].service;
                    string3 = iJSpace.getName();
                    spaceURL = iJSpace.getURL();
                    try {
                        if (!bl2) break block37;
                        stringBuffer = new StringBuffer();
                        object7 = iJSpace.getAdmin();
                        if (!(object7 instanceof StatisticsAdmin)) break block37;
                        object6 = (StatisticsAdmin)object7;
                        if (!object6.isStatisticsAvailable()) {
                            object5 = "Statistics for Space \"" + string3 + "\" not Available. " + "Please Start the Statistics Filter.";
                            System.out.println((String)object5);
                        } else {
                            object5 = object6.getStatistics();
                            object4 = object5.keySet();
                            this.a((Map)object5);
                            object3 = object4.iterator();
                            if (object3.hasNext()) {
                                stringBuffer.append("\n\tStatistics\n");
                                stringBuffer.append("\t--------------------------------------------------\n");
                            }
                            while (object3.hasNext()) {
                                object2 = (Integer)object3.next();
                                int n3 = (Integer)object2;
                                string22 = this.a(n3);
                                if (string22 == null) continue;
                                object = (StatisticsContext)object5.get(object2);
                                stringBuffer.append("\t" + string22 + " : ");
                                stringBuffer.append(object);
                                stringBuffer.append("\n");
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Exception thrown while fetching statistics for space " + string3);
                        if (!_logger.isLoggable(Level.SEVERE)) continue;
                        _logger.log(Level.SEVERE, exception.toString(), exception);
                        continue;
                    }
                }
                object7 = "-";
                object6 = "false";
                object5 = "-";
                object4 = "-";
                object3 = "-";
                object2 = "-";
                String string4 = "-";
                string22 = "-";
                object = "-";
                IRemoteJSpaceAdmin iRemoteJSpaceAdmin = null;
                SpaceRuntimeInfo spaceRuntimeInfo = null;
                StringBuffer stringBuffer2 = new StringBuffer();
                try {
                    try {
                        SpaceConfig spaceConfig;
                        Entry[] entryArray;
                        block38: {
                            entryArray = serviceItemArray[i2].attributeSets;
                            iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
                            object4 = JSpaceState.convertToString(new Integer(iRemoteJSpaceAdmin.getState()));
                            if (!bl3) {
                                try {
                                    spaceRuntimeInfo = iRemoteJSpaceAdmin.getRuntimeInfo();
                                    object5 = ListSpaces.b(spaceRuntimeInfo);
                                }
                                catch (Exception exception) {
                                    if (!_logger.isLoggable(Level.SEVERE)) break block38;
                                    _logger.log(Level.SEVERE, exception.toString(), exception);
                                }
                            }
                        }
                        object7 = (spaceConfig = iRemoteJSpaceAdmin.getConfig()).isClustered() ? g : h;
                        Object object8 = object3 = spaceConfig.isPersistent() ? g : h;
                        if (spaceConfig.isClustered() && spaceURL.getClusterSchema() != null) {
                            stringBuffer2.append("Cluster schema: " + spaceURL.getClusterSchema() + "\n");
                        }
                        stringBuffer2.append("URL: " + spaceURL.getURL() + "\n");
                        object2 = spaceConfig.getSchemaName();
                        Class<?> clazz = class$com$j_spaces$lookup$entry$ContainerName;
                        if (clazz == null) {
                            clazz = new ContainerName[0].getClass().getComponentType();
                        }
                        ContainerName containerName = (ContainerName)this.a(entryArray, clazz);
                        Class<?> clazz2 = class$com$j_spaces$lookup$entry$HostName;
                        if (clazz2 == null) {
                            clazz2 = new HostName[0].getClass().getComponentType();
                        }
                        HostName hostName = (HostName)this.a(entryArray, clazz2);
                        IJSpaceContainer iJSpaceContainer = null;
                        if (containerName != null) {
                            string22 = containerName.name;
                        } else {
                            iJSpaceContainer = iJSpace.getContainer();
                            if (iJSpaceContainer != null) {
                                string22 = iJSpaceContainer.getName();
                            }
                        }
                        if (hostName != null) {
                            object = hostName.name;
                        } else {
                            if (iJSpaceContainer == null) {
                                iJSpaceContainer = iJSpace.getContainer();
                            }
                            if (iJSpaceContainer instanceof IJSpaceContainerAdmin) {
                                IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((Object)iJSpaceContainer);
                                object = iJSpaceContainerAdmin.getConfig().containerHostName;
                            }
                        }
                        try {
                            string4 = JSpaceUtilities.getJiniGroupRepresentation(iRemoteJSpaceAdmin);
                        }
                        catch (RemoteException remoteException) {
                        }
                        var31_35 = null;
                        string2 = iJSpace.isSecured() ? g : h;
                    }
                    catch (Exception exception) {
                        if (_logger.isLoggable(Level.SEVERE)) {
                            _logger.log(Level.SEVERE, exception.toString(), exception);
                        }
                        var31_35 = null;
                        object6 = iJSpace.isSecured() ? g : h;
                        System.out.println(ListSpaces.a(new String[]{string3, object5, object6, object7, object3, object4, object2, string4, string22, object}));
                        System.out.println(stringBuffer2.toString());
                        if (bl4 && spaceRuntimeInfo != null) {
                            ListSpaces.a(spaceRuntimeInfo);
                        }
                        if (stringBuffer != null && stringBuffer.length() > 0) {
                            System.out.println(stringBuffer.toString());
                        }
                        System.out.println(string);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var31_35 = null;
                    object6 = iJSpace.isSecured() ? g : h;
                    System.out.println(ListSpaces.a(new String[]{string3, object5, object6, object7, object3, object4, object2, string4, string22, object}));
                    System.out.println(stringBuffer2.toString());
                    if (bl4 && spaceRuntimeInfo != null) {
                        ListSpaces.a(spaceRuntimeInfo);
                    }
                    if (stringBuffer != null && stringBuffer.length() > 0) {
                        System.out.println(stringBuffer.toString());
                    }
                    System.out.println(string);
                    throw throwable;
                }
                object6 = string2;
                System.out.println(ListSpaces.a(new String[]{string3, object5, object6, object7, object3, object4, object2, string4, string22, object}));
                System.out.println(stringBuffer2.toString());
                if (bl4 && spaceRuntimeInfo != null) {
                    ListSpaces.a(spaceRuntimeInfo);
                }
                if (stringBuffer != null && stringBuffer.length() > 0) {
                    System.out.println(stringBuffer.toString());
                }
                System.out.println(string);
            }
        }
    }

    private void a(Map map) {
        StatisticsContext statisticsContext;
        StatisticsContext statisticsContext2;
        if (map.containsKey(_Integer.valueOf(12))) {
            statisticsContext2 = (StatisticsContext)map.get(_Integer.valueOf(2));
            statisticsContext = (StatisticsContext)map.get(_Integer.valueOf(12));
            if (statisticsContext2 != null) {
                statisticsContext2.setCurrentCount(new AtomicLong(statisticsContext2.getCurrentCount() + statisticsContext.getCurrentCount()));
            } else {
                map.put(_Integer.valueOf(2), statisticsContext);
            }
            map.remove(_Integer.valueOf(12));
        }
        if (map.containsKey(_Integer.valueOf(14))) {
            statisticsContext2 = (StatisticsContext)map.get(_Integer.valueOf(3));
            statisticsContext = (StatisticsContext)map.get(_Integer.valueOf(14));
            if (statisticsContext2 != null) {
                statisticsContext2.setCurrentCount(new AtomicLong(statisticsContext2.getCurrentCount() + statisticsContext.getCurrentCount()));
            } else {
                map.put(_Integer.valueOf(3), statisticsContext);
            }
            map.remove(_Integer.valueOf(14));
        }
    }

    private String a(int n2) {
        switch (n2) {
            case 2: {
                return "Read".toUpperCase();
            }
            case 12: {
                return "READ MULTIPLE";
            }
            case 0: {
                return "Write".toUpperCase();
            }
            case 9: {
                return "Update".toUpperCase();
            }
            case 4: {
                return "Notify registration".toUpperCase();
            }
            case 15: {
                return "Notify sent".toUpperCase();
            }
            case 16: {
                return "Notify ack.".toUpperCase();
            }
            case 3: {
                return "Take".toUpperCase();
            }
            case 14: {
                return "TAKE MULTIPLE";
            }
        }
        return null;
    }

    private Entry a(Entry[] entryArray, Class clazz) {
        if (entryArray != null) {
            Entry[] entryArray2 = entryArray;
            int n2 = entryArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Entry entry = entryArray2[i2];
                if (!entry.getClass().equals(clazz)) continue;
                return entry;
            }
        }
        return null;
    }

    private static void a(SpaceRuntimeInfo spaceRuntimeInfo) {
        try {
            if (spaceRuntimeInfo.m_ClassNames.size() <= 0) {
                return;
            }
            for (int i2 = 0; i2 < spaceRuntimeInfo.m_ClassNames.size(); ++i2) {
                System.out.println("Class Name: " + (String)spaceRuntimeInfo.m_ClassNames.get(i2) + "\tInstances count: " + spaceRuntimeInfo.m_NumOFEntries.get(i2));
            }
            System.out.println("");
        }
        catch (SecurityException securityException) {
            System.out.println("No admin permission for anonymous user.");
            _logger.log(Level.SEVERE, securityException.toString(), securityException);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, exception.toString(), exception);
        }
    }

    private static String b(SpaceRuntimeInfo spaceRuntimeInfo) {
        int n2 = 0;
        for (int i2 = 0; i2 < spaceRuntimeInfo.m_NumOFEntries.size(); ++i2) {
            n2 += ((Integer)spaceRuntimeInfo.m_NumOFEntries.get(i2)).intValue();
        }
        return String.valueOf(n2);
    }

    private static String a(String[] stringArray) {
        String string = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = stringArray[i2].length() >= e[i2] ? string + stringArray[i2].substring(0, e[i2] - 1).concat(".") : string + stringArray[i2];
            for (int i3 = 0; i3 < e[i2] - stringArray[i2].length(); ++i3) {
                string = string + ' ';
            }
        }
        return string;
    }
}

