/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import com.j_spaces.core.IJSpace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.isqlviewer.core.CorePlugin;
import org.isqlviewer.core.EnhancedDataRenderer;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.ActionPopupMenu;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.core.model.ResultSetTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITabbedPane;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.swing.SortableHeaderRenderer;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.ui.ExportWizard;
import org.isqlviewer.ui.MutableContentViewer;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public final class SQLWorkBench
extends JComponent
implements SwingConstants,
IPCListener {
    private static final long serialVersionUID = 1L;
    private static final String CLIENT_RAW_SQL = "raw-sql";
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private UserPreferences preferences = this.sysConfig.getPreferences();
    private SQLEditor txtSQLEditor = null;
    private ActionPopupMenu tablePopupMenu = new ActionPopupMenu();
    private ResultsetToolbar jtbResultset = null;
    private HistoryToolbar jtbHistory = null;
    private AppController controller = null;
    private ITabbedPane resultPane = new ITabbedPane(1);
    private JSplitPane contentPane = new JSplitPane(0);
    private JPanel resultsPanel = new JPanel(new BorderLayout());
    private BookmarkDnDSupport bookmarkDropper = new BookmarkDnDSupport(this);
    private InputSupport actionHandler = new InputSupport(null);
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
    private static String tabTitle = "";
    private boolean isTabAdditionProceed = false;
    private ResultDelegate resultDelegate;
    private static final String QUERY_DELIMETER = ":";
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ResultDelegate getResultDelegate() {
        return this.resultDelegate;
    }

    public SQLWorkBench(AppController appController) {
        try {
            this.controller = appController;
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, BasicUtilities.getString("Fatal_Error_Occured"), true);
            System.exit(-1);
        }
    }

    public void setControler(AppController appController) {
        this.controller = appController;
    }

    public void executeBookmark(SQLBookmark sQLBookmark, AppController appController, boolean bl2) {
        if (sQLBookmark != null && this.controller.validateConnection()) {
            SQLBookmark sQLBookmark2 = (SQLBookmark)sQLBookmark.clone();
            String string = this.processSQLParameters(sQLBookmark2.getSQL());
            if (string == null) {
                return;
            }
            sQLBookmark2.setSQL(string);
            DatabaseConnection databaseConnection = appController.getJDBCConnection();
            if (sQLBookmark.hasParameters()) {
                try {
                    PreparedStatement preparedStatement = sQLBookmark2.toPreparedStatement(databaseConnection);
                    ResultSetViewer resultSetViewer = this.createResultSetDelegate();
                    sQLBookmark.updateLastAcessTime();
                    sQLBookmark.updateUseCount();
                    databaseConnection.executeStatement(preparedStatement, sQLBookmark2.getSQL(), resultSetViewer);
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                }
            } else {
                sQLBookmark.updateLastAcessTime();
                sQLBookmark.updateUseCount();
                this.performQuery(bl2, sQLBookmark2.getSQL(), true);
            }
            sQLBookmark2 = null;
        } else {
            BasicUtilities.beep();
        }
    }

    public void receiveMessage(Object object, String string, Object object2) {
        String string2 = object2.toString().trim();
        if (string2.length() >= 1 && this.controller.validateConnection()) {
            this.performQuery(string2, true);
        }
    }

    public void restoreSession() {
        this.txtSQLEditor.setText(this.preferences.get("session.".concat("SQLWorkbench.sql.txt")));
        String string = "session.".concat("SQLWorkbench.split.loc");
        int n2 = this.preferences.getInt(string);
        if (n2 < 0) {
            this.contentPane.setDividerLocation(0.5);
        } else {
            this.contentPane.setDividerLocation(n2);
        }
    }

    public void saveSession() {
        int n2 = this.contentPane.getDividerLocation();
        this.preferences.putInt("session.".concat("SQLWorkbench.split.loc"), n2);
        this.preferences.put("session.".concat("SQLWorkbench.sql.txt"), this.txtSQLEditor.getText());
    }

    public ResultSetViewer createResultSetDelegate() {
        return new ResultDelegate(this, this.controller.getJDBCConnection());
    }

    public void actionRefreshTableView() {
        String string;
        String string2 = this.txtSQLEditor.getText().trim();
        ITable iTable = this.getSelectedTable();
        String string3 = string = iTable == null ? "" : (String)iTable.getClientProperty(CLIENT_RAW_SQL);
        if (string.length() >= 1) {
            if (this.controller.validateConnection()) {
                this.performQuery(true, string, false);
            }
        } else if (string2.length() >= 1) {
            if (this.controller.validateConnection()) {
                this.performQuery(true, string2, true);
            }
        } else {
            this.controller.showInvalidConnection();
        }
    }

    public void showDatarenderer(ITable iTable, int n2, int n3, String string) {
        PluginFactory pluginFactory = this.sysConfig.getPluginFactory();
        CorePlugin corePlugin = pluginFactory.pluginForName(2, string);
        EnhancedDataRenderer enhancedDataRenderer = (EnhancedDataRenderer)corePlugin;
        if (enhancedDataRenderer != null) {
            String string2 = enhancedDataRenderer.getName();
            String string3 = enhancedDataRenderer.getDescription();
            Icon icon = enhancedDataRenderer.getUserIcon();
            MutableContentViewer mutableContentViewer = new MutableContentViewer();
            Object object = null;
            object = enhancedDataRenderer.supportsMultipleSelections() ? iTable.getSelectedSubModel() : iTable.getValueAt(n2, n3);
            mutableContentViewer.setContent(object, enhancedDataRenderer);
            this.resultPane.addTab(string2, icon, mutableContentViewer, string3);
            int n4 = this.resultPane.indexOfComponent(mutableContentViewer);
            this.resultPane.setClosableTab(n4, true);
            this.resultPane.setSelectedIndex(n4);
        }
    }

    public void toggleResultSetDataView(ResultsetView resultsetView, boolean bl2) {
        if (resultsetView != null) {
            ITable iTable = resultsetView.getTable();
            resultsetView.clearFiltering();
            ResultSetToggler resultSetToggler = new ResultSetToggler(this.controller, iTable, this.jtbResultset, bl2);
            SwingUtilities.invokeLater(resultSetToggler);
        }
    }

    public void toggleLockAction(int n2, boolean bl2) {
        ActionManager actionManager = this.controller.getActionManager();
        if (n2 >= 0) {
            Action action;
            if (this.resultPane.isTabLocked(n2)) {
                if (bl2) {
                    this.resultPane.unlockTab(n2);
                    action = actionManager.getAction(29);
                } else {
                    action = actionManager.getAction(30);
                }
            } else if (bl2) {
                this.resultPane.lockTab(n2);
                action = actionManager.getAction(30);
            } else {
                action = actionManager.getAction(29);
            }
            if (this.jtbResultset != null) {
                this.jtbResultset.toggleAction(29, action);
            }
        }
        this.validateTree();
    }

    public void toggleColumnDeleteAction(final JTable jTable, boolean bl2) {
        ActionManager actionManager = this.controller.getActionManager();
        Action action = null;
        if (jTable != null) {
            if (jTable.getRowSelectionAllowed()) {
                if (bl2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BasicUtilities.removeSelectedRows(jTable);
                        }
                    });
                    return;
                }
                action = actionManager.getAction(19);
            } else if (jTable.getColumnSelectionAllowed()) {
                if (bl2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BasicUtilities.removeSelectedColumns(jTable);
                        }
                    });
                    return;
                }
                action = actionManager.getAction(20);
            }
            if (this.jtbResultset != null) {
                this.jtbResultset.toggleAction(20, action);
            }
        }
    }

    public void processAction(ActionEvent actionEvent) {
        boolean bl2 = (actionEvent.getModifiers() & 1) == 1;
        boolean bl3 = (actionEvent.getModifiers() & BasicUtilities.CMD_MASK) == BasicUtilities.CMD_MASK;
        ITable iTable = this.getSelectedTable();
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        switch (actionEvent.getID()) {
            case 26: 
            case 27: {
                this.toggleResultSetDataView((ResultsetView)this.resultPane.getSelectedComponent(), true);
                break;
            }
            case 29: 
            case 30: {
                this.toggleLockAction(this.resultPane.getSelectedIndex(), true);
                break;
            }
            case 19: 
            case 20: {
                this.toggleColumnDeleteAction(iTable, true);
                break;
            }
            case 511: {
                this.toggleColumnDeleteAction(iTable, false);
                break;
            }
            case 16: {
                this.actionRefreshTableView();
                break;
            }
            case 28: {
                this.resultPane.removeUnlockedTabs();
                break;
            }
            case 35: {
                this.createBookmark();
                break;
            }
            case 45: {
                this.resultPane.removeSelectedTab();
                break;
            }
            case 32: {
                if (iTable == null) break;
                int n2 = iTable.getSelectedColumn();
                int n3 = iTable.getSelectedRow();
                JMenuItem jMenuItem = (JMenuItem)object;
                this.showDatarenderer(iTable, n3, n2, (String)jMenuItem.getClientProperty("class-name"));
                break;
            }
            case 15: {
                System.out.println("--*****SQL EXE********---");
                if (!this.controller.validateConnection()) break;
                String string2 = this.txtSQLEditor.getText();
                if (string2.length() >= 1) {
                    if (bl2) {
                        this.resultPane.removeAllTabs();
                    }
                    this.performQuery(string2, true);
                    break;
                }
                BasicUtilities.beep();
                break;
            }
            case 47: {
                if (!this.controller.validateConnection()) break;
                String string3 = this.txtSQLEditor.getSelectedText();
                if (string3.length() >= 1) {
                    if (bl2) {
                        this.resultPane.removeAllTabs();
                    }
                    this.performQuery(string3, true);
                    break;
                }
                BasicUtilities.beep();
                break;
            }
            case 43: {
                int n4 = this.resultPane.getSelectedIndex();
                if (n4 + 1 >= this.resultPane.getTabCount() || this.resultPane.getTabCount() < 1) break;
                this.resultPane.setSelectedIndex(n4 + 1);
                break;
            }
            case 44: {
                int n5 = this.resultPane.getSelectedIndex();
                if (n5 - 1 < 0 || this.resultPane.getTabCount() < 1) break;
                this.resultPane.setSelectedIndex(n5 - 1);
                break;
            }
            case 64768: {
                if (iTable == null || !bl3) break;
                this.txtSQLEditor.setText((String)iTable.getClientProperty(CLIENT_RAW_SQL));
                break;
            }
            case 64769: {
                if (iTable == null || this.controller.zoomComponent(this.resultPane) == null) break;
                this.resultsPanel.add((Component)this.resultPane, "Center");
                this.invalidate();
                this.repaint();
                break;
            }
            case 10: {
                if (string.equalsIgnoreCase("dnd-proxy")) {
                    Transferable transferable = (Transferable)object;
                    Object object2 = null;
                    try {
                        object2 = transferable.getTransferData(EnhancedTableModel.FLAVOR_OBJECT);
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.beep();
                        return;
                    }
                    EnhancedTableModel enhancedTableModel = (EnhancedTableModel)object2;
                    Class<?> clazz = class$javax$swing$JFrame;
                    if (clazz == null) {
                        clazz = class$javax$swing$JFrame = new JFrame[0].getClass().getComponentType();
                    }
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(clazz, this);
                    ExportWizard exportWizard = new ExportWizard((Frame)jFrame, enhancedTableModel, this.controller.getJDBCConnection());
                    exportWizard.show();
                    break;
                }
                if (iTable == null) break;
                Class<?> clazz = class$javax$swing$JFrame;
                if (clazz == null) {
                    clazz = class$javax$swing$JFrame = new JFrame[0].getClass().getComponentType();
                }
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(clazz, this);
                ResultSetTableModel resultSetTableModel = (ResultSetTableModel)iTable.getModel();
                EnhancedTableModel enhancedTableModel = null;
                enhancedTableModel = resultSetTableModel.isShowingMetadata() ? resultSetTableModel.getMetadataAsModel() : resultSetTableModel;
                ExportWizard exportWizard = new ExportWizard((Frame)jFrame, enhancedTableModel, this.controller.getJDBCConnection());
                exportWizard.show();
                break;
            }
            case 1: {
                if (iTable != null) {
                    String string4 = (String)iTable.getClientProperty(CLIENT_RAW_SQL);
                    PrinterPreview.print(iTable.getModel(), string4);
                    break;
                }
                if (this.delegatePrint()) break;
                BasicUtilities.beep();
                break;
            }
            case 5: {
                if (iTable != null) {
                    String string5 = (String)iTable.getClientProperty(CLIENT_RAW_SQL);
                    Class<?> clazz = class$javax$swing$JFrame;
                    if (clazz == null) {
                        clazz = class$javax$swing$JFrame = new JFrame[0].getClass().getComponentType();
                    }
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(clazz, this);
                    PrinterPreview.showPrintPreviewDialog(jFrame, (Object)iTable.getModel(), string5);
                    break;
                }
                if (this.delegatePrintPreview()) break;
                BasicUtilities.beep();
                break;
            }
            case 11: {
                if (iTable != null) {
                    BasicUtilities.copySelectedCellsToClipBoard(iTable);
                    break;
                }
                BasicUtilities.beep();
                break;
            }
            case 18: {
                HistoryManager historyManager = this.sysConfig.getHistoryManager();
                HistoryItem historyItem = historyManager.newer();
                if (historyItem == null) break;
                this.txtSQLEditor.setText(historyItem.getSQLData());
                break;
            }
            case 17: {
                HistoryManager historyManager = this.sysConfig.getHistoryManager();
                HistoryItem historyItem = historyManager.older();
                if (historyItem == null) break;
                this.txtSQLEditor.setText(historyItem.getSQLData());
                break;
            }
            case 49: {
                BasicUtilities.beep();
                break;
            }
            case 50: {
                iTable.handleInspection(iTable.getSelectedRow(), false);
                break;
            }
            case 51: {
                iTable.handleInspection(iTable.getSelectedRow(), true);
            }
        }
    }

    public SQLEditor getEditor() {
        return this.txtSQLEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITable getSelectedTable() {
        ITabbedPane iTabbedPane = this.resultPane;
        synchronized (iTabbedPane) {
            try {
                if (this.resultPane.isEmpty()) {
                    return null;
                }
                ResultsetView resultsetView = (ResultsetView)this.resultPane.getSelectedComponent();
                return resultsetView.getTable();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delegatePrint() {
        ITabbedPane iTabbedPane = this.resultPane;
        synchronized (iTabbedPane) {
            try {
                if (this.resultPane.isEmpty()) {
                    return false;
                }
                MutableContentViewer mutableContentViewer = (MutableContentViewer)this.resultPane.getSelectedComponent();
                return mutableContentViewer.performPrint();
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delegatePrintPreview() {
        ITabbedPane iTabbedPane = this.resultPane;
        synchronized (iTabbedPane) {
            try {
                if (this.resultPane.getTabCount() <= 0) {
                    return false;
                }
                MutableContentViewer mutableContentViewer = (MutableContentViewer)this.resultPane.getSelectedComponent();
                return mutableContentViewer.performPrintPreview();
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    public void createResultSetToolBar() {
        this.jtbResultset = new ResultsetToolbar(this.controller.getActionManager());
        String string = this.preferences.get("toolbar.resultset-dock");
        if (string.equalsIgnoreCase("East") || string.equalsIgnoreCase("West")) {
            this.jtbResultset.setOrientation(1);
        } else {
            this.jtbResultset.setOrientation(0);
        }
        this.jtbResultset.setVisible(this.preferences.getBoolean("toolbar.resultset-visible"));
        this.jtbResultset.setName(BasicUtilities.getString("Resultset_Toolbar"));
        JComponent jComponent = (JComponent)this.contentPane.getBottomComponent();
        jComponent.add((Component)this.jtbResultset, string);
        this.validateTree();
    }

    public void createHistoryToolBar() {
        this.jtbHistory = new HistoryToolbar(this.txtSQLEditor, this.controller.getActionManager());
        String string = this.preferences.get("toolbar.history-dock");
        if (string.equalsIgnoreCase("East") || string.equalsIgnoreCase("West")) {
            this.jtbHistory.setOrientation(1);
        } else {
            this.jtbHistory.setOrientation(0);
        }
        this.jtbHistory.setVisible(this.preferences.getBoolean("toolbar.history-visible"));
        this.jtbHistory.setName(BasicUtilities.getString("History_Toolbar"));
        JComponent jComponent = (JComponent)this.contentPane.getTopComponent();
        jComponent.add((Component)this.jtbHistory, string);
        this.validateTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryToolbar() {
        if (this.jtbResultset != null) {
            try {
                JComponent jComponent = (JComponent)this.contentPane.getTopComponent();
                jComponent.remove(this.jtbHistory);
                this.jtbHistory.removeAll();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.jtbHistory = null;
                this.validateTree();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultsetToolbar() {
        if (this.jtbResultset != null) {
            try {
                JComponent jComponent = (JComponent)this.contentPane.getBottomComponent();
                jComponent.remove(this.jtbHistory);
                this.jtbResultset.removeAll();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.jtbResultset = null;
                this.validateTree();
            }
        }
    }

    public String processSQLParameters(String string) {
        String[] stringArray = StringUtilities.getSQLParameters(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            String string3 = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("SQL_Param_Prompt", string2));
            if (string3 == null) {
                System.out.println(BasicUtilities.getString("Query_Cancelled"));
                hashMap.clear();
                hashMap = null;
                stringArray = null;
                return null;
            }
            hashMap.put(string2, string3);
        }
        String string4 = StringUtilities.applySQLParameters(hashMap, string);
        hashMap.clear();
        hashMap = null;
        stringArray = null;
        return string4;
    }

    public void performQuery(String string, boolean bl2) {
        this.performQuery(false, string, bl2);
    }

    public void performQuery(boolean bl2, String string, boolean bl3) {
        String string2 = string = string == null ? "" : string;
        if (string.trim().length() == 0) {
            System.out.println(BasicUtilities.getString("Empty_SQL_Error"));
            return;
        }
        boolean bl4 = this.jtbHistory.isMultipleSpaceQuerySelected();
        DatabaseConnection databaseConnection = this.controller.getJDBCConnection();
        try {
            if (databaseConnection != null) {
                databaseConnection.setUseSingleSpace(!bl4);
            }
            if (!bl2 && (string = this.processSQLParameters(string)) == null) {
                return;
            }
            if (bl3) {
                this.sysConfig.getHistoryManager().addHistoryItem(string, databaseConnection);
            }
            int n2 = -1;
            if (bl2 && this.preferences.getBoolean("general.refresh-reuse")) {
                if (this.resultPane.isEmpty()) {
                    n2 = this.resultPane.getTabCount();
                    this.isTabAdditionProceed = true;
                    this.resultPane.addTab("", new JLabel());
                    this.isTabAdditionProceed = false;
                } else {
                    n2 = this.resultPane.getSelectedIndex();
                }
            } else {
                n2 = this.resultPane.getTabCount();
                JLabel jLabel = new JLabel();
                this.isTabAdditionProceed = true;
                this.resultPane.addTab("", jLabel);
                this.isTabAdditionProceed = false;
                n2 = this.resultPane.indexOfComponent(jLabel);
            }
            this.resultDelegate = (ResultDelegate)this.createResultSetDelegate();
            this.resultPane.setComponentAt(n2, this.resultDelegate);
            this.resultPane.setClosableTab(n2, false);
            this.resultPane.setToolTipTextAt(n2, "");
            this.resultPane.setIconAt(n2, null);
            this.resultPane.setSelectedIndex(n2);
            databaseConnection.executeStaticRequest(string, this.resultDelegate);
        }
        catch (Throwable throwable) {
            this.txtSQLEditor.requestFocus();
            throwable.printStackTrace();
            BasicUtilities.HandleException(throwable, "SQLWorkbench::performQuery()");
        }
        try {
            SQLWarningViewer.addConnectionWarnings(databaseConnection.getWarnings());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initUI() throws Exception {
        Object object;
        ActionManager actionManager = this.controller.getActionManager();
        actionManager.addActionListener(this.actionHandler);
        actionManager.addItemListener(this.actionHandler);
        this.tablePopupMenu.addAction(actionManager.getAction(19));
        this.tablePopupMenu.addAction(actionManager.getAction(16));
        this.tablePopupMenu.addAction(actionManager.getAction(11));
        JMenu jMenu = new JMenu(BasicUtilities.getString("Enhance_Data_View_Mnu"));
        jMenu.setIcon(BasicUtilities.loadIconResource("ZoomIn16"));
        this.tablePopupMenu.add(jMenu);
        this.tablePopupMenu.addSeparator();
        this.tablePopupMenu.addAction(actionManager.getAction(50));
        this.tablePopupMenu.addAction(actionManager.getAction(51));
        this.sysConfig.getIPCService().subscribe(this, "isql-sql-execute");
        PluginFactory pluginFactory = this.sysConfig.getPluginFactory();
        Collection collection = pluginFactory.createDataRenderers();
        Iterator iterator = collection.iterator();
        Action action = actionManager.getAction(32);
        while (iterator.hasNext()) {
            object = (EnhancedDataRenderer)iterator.next();
            JMenuItem jMenuItem = new JMenuItem(action);
            jMenuItem.setText(object.getName());
            jMenuItem.setIcon(object.getUserIcon());
            jMenuItem.putClientProperty("class-name", object.getClass().getName());
            jMenuItem.setToolTipText(object.getDescription());
            jMenu.add(jMenuItem);
            try {
                object.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.txtSQLEditor = new SQLEditor(this.controller);
        this.setLayout(new BorderLayout());
        object = new JPanel(new BorderLayout());
        this.resultsPanel.add((Component)this.resultPane, "Center");
        ((Container)object).add((Component)this.txtSQLEditor, "Center");
        this.resultPane.addActionListener(this.actionHandler);
        this.resultPane.addChangeListener(this.actionHandler);
        this.add((Component)this.contentPane, "Center");
        this.contentPane.setContinuousLayout(true);
        this.contentPane.setTopComponent((Component)object);
        this.contentPane.setBottomComponent(this.resultsPanel);
        this.resultPane.setDropTarget(new DropTarget(this.resultPane, this.bookmarkDropper));
        this.resultPane.setMaxTabCount(this.preferences.getInt("general.max-resultsets"));
        this.createResultSetToolBar();
        this.createHistoryToolBar();
        this.actionHandler.stateChanged(new ChangeEvent(this.resultPane));
    }

    private void createBookmark() {
        Object object;
        Object object2;
        String string;
        String string2 = this.txtSQLEditor.getText().trim();
        ITable iTable = this.getSelectedTable();
        String string3 = string = iTable == null ? "" : (String)iTable.getClientProperty(CLIENT_RAW_SQL);
        if (string2.length() == 0 && string.length() == 0) {
            BasicUtilities.beep();
            return;
        }
        SQLBookmark sQLBookmark = null;
        if (!string.equalsIgnoreCase(string2) && string.length() >= 1) {
            object2 = BasicUtilities.getString("Choose_SQL_For_Bookmark");
            String string4 = (String)JOptionPane.showInputDialog(this, null, (String)object2, 2, null, object = new String[]{BasicUtilities.getString("Select_From_Editor"), BasicUtilities.getString("Select_From_Selected_Tab")}, object[1]);
            if (string4 != null) {
                String string5 = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("Enter_Name_for_Bookmark"));
                if (string5 == null) {
                    return;
                }
                if (string4.equals(object[0])) {
                    sQLBookmark = new SQLBookmark(string5, string2);
                } else if (string4.equals(object[1])) {
                    sQLBookmark = new SQLBookmark(string5, string);
                }
            }
        } else if (string.length() >= 1) {
            object2 = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("Enter_Name_for_Bookmark"));
            if (object2 == null) {
                return;
            }
            sQLBookmark = new SQLBookmark((String)object2, string);
        } else if (string2.length() >= 1) {
            object2 = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("Enter_Name_for_Bookmark"));
            if (object2 == null) {
                return;
            }
            sQLBookmark = new SQLBookmark((String)object2, string2);
        } else {
            BasicUtilities.beep();
            return;
        }
        if (sQLBookmark == null) {
            BasicUtilities.beep();
            return;
        }
        sQLBookmark.setPath("/");
        object2 = this.sysConfig.getBookmarks();
        ((BookmarkTreeModel)object2).addBookmark(sQLBookmark);
        object = SwingUtilities.getWindowAncestor(this);
        this.dispatchEvent(new WindowEvent((Window)object, 205));
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        SQLWorkBench.UI_CONSTRAINT.gridx = n2;
        SQLWorkBench.UI_CONSTRAINT.gridy = n3;
        SQLWorkBench.UI_CONSTRAINT.gridwidth = n4;
        SQLWorkBench.UI_CONSTRAINT.gridheight = n5;
        SQLWorkBench.UI_CONSTRAINT.weightx = d2;
        SQLWorkBench.UI_CONSTRAINT.weighty = d3;
        SQLWorkBench.UI_CONSTRAINT.anchor = n6;
        SQLWorkBench.UI_CONSTRAINT.fill = n7;
    }

    public void setQueryString(String string, String string2) {
        tabTitle = SQLWorkBench.createQueryPrefix(string);
        this.txtSQLEditor.setText(string2);
    }

    public void runQuery(String string, String string2) {
        tabTitle = SQLWorkBench.createQueryPrefix(string);
        this.txtSQLEditor.setText(string2);
        this.performQuery(false, string2, false);
    }

    private static String createQueryPrefix(String string) {
        return string + QUERY_DELIMETER;
    }

    private static String getQuery(String string) {
        int n2 = string.indexOf(QUERY_DELIMETER);
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return null;
    }

    private static class ResultsetToolbar
    extends ActionToolBar {
        public JButton btnColRowDelete;
        public JButton btnViewToggle;
        public JButton btnLockToggle;

        public ResultsetToolbar(ActionManager actionManager) {
            super(actionManager);
            this.setOrientation(1);
            this.setFloatable(false);
        }

        public void toggleAction(int n2, Action action) {
            if (action != null) {
                switch (n2) {
                    case 26: 
                    case 27: {
                        this.toggleAction(this.btnViewToggle, action);
                        break;
                    }
                    case 29: 
                    case 30: {
                        this.toggleAction(this.btnLockToggle, action);
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.toggleAction(this.btnColRowDelete, action);
                    }
                }
            }
        }

        public void addButtons() {
            this.btnViewToggle = this.addButton(this.manager.getAction(27));
            this.btnColRowDelete = this.addButton(this.manager.getAction(19));
            this.btnLockToggle = this.addButton(this.manager.getAction(29));
            JButton jButton = this.addButton(this.manager.getAction(10));
            this.addDropActionSupport(jButton, new DataFlavor[]{EnhancedTableModel.FLAVOR_OBJECT}, 10);
            this.addButton(this.manager.getAction(28));
            if (this.getOrientation() == 1) {
                this.add(Box.createVerticalGlue());
            } else {
                this.add(Box.createHorizontalGlue());
            }
        }

        public void processDropProxy(Transferable transferable, int n2) {
        }
    }

    private static class HistoryToolbar
    extends ActionToolBar
    implements Runnable,
    MouseListener {
        private boolean pressed = false;
        private JPopupMenu menuNext = new JPopupMenu();
        private Point menuPoint = new Point(0, 0);
        private SQLEditor editor = null;
        private HistoryManager history = SystemConfig.getInstance().getHistoryManager();
        private JToggleButton multispaceQueryButton;

        public void run() {
            try {
                Thread.sleep(1250L);
                if (this.pressed) {
                    if (this.menuNext.getComponentCount() >= 1) {
                        this.menuNext.show(this, this.menuPoint.x, this.menuPoint.y);
                    } else {
                        BasicUtilities.beep();
                    }
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public boolean isMultipleSpaceQuerySelected() {
            return this.multispaceQueryButton.isSelected();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl2;
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.pressed = true;
            Component component = mouseEvent.getComponent();
            int n2 = component.getX();
            int n3 = component.getY() + component.getHeight();
            int n4 = this.history.getCursorIndex();
            int n5 = this.history.size();
            int n6 = Math.min(5, n5 - 1);
            boolean bl3 = bl2 = this.history.isCircular() && n6 >= 1 || n6 >= 1;
            if (!bl2) {
                BasicUtilities.beep();
                return;
            }
            boolean bl4 = component == this.getComponent(0);
            this.menuPoint.move(n2, n3);
            this.menuNext.removeAll();
            if (bl4) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n7 = n4 - i2 - 1;
                    if (n7 < 0) {
                        if (!this.history.isCircular()) {
                            return;
                        }
                        if (i2 >= 1) {
                            this.menuNext.addSeparator();
                        }
                        n7 = n4 = n5 - 1;
                    }
                    JMenuItem jMenuItem = this.menuNext.add(this.history.get(n7).toMenuString());
                    this.configureMenu(jMenuItem, n7);
                }
            } else {
                for (int i3 = 0; i3 < n6; ++i3) {
                    int n8 = n4 + i3 + 1;
                    if (n8 >= n5) {
                        if (!this.history.isCircular()) {
                            return;
                        }
                        if (i3 >= 1) {
                            this.menuNext.addSeparator();
                        }
                        n4 = 0;
                        n8 = 0;
                    }
                    JMenuItem jMenuItem = this.menuNext.add(this.history.get(n8).toMenuString());
                    this.configureMenu(jMenuItem, n8);
                }
            }
            new Thread(this).start();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.pressed = false;
            if (!mouseEvent.isConsumed() && this.menuNext.isShowing()) {
                Component component = mouseEvent.getComponent();
                mouseEvent.translatePoint(0, -1 * component.getHeight());
                if (this.menuNext.contains(mouseEvent.getPoint())) {
                    JMenuItem jMenuItem = (JMenuItem)this.menuNext.getComponentAt(mouseEvent.getPoint());
                    int n2 = (Integer)jMenuItem.getClientProperty("index");
                    HistoryItem historyItem = this.history.get(n2);
                    this.editor.setText(historyItem.getSQLData());
                    this.history.setCursorIndex(n2);
                    mouseEvent.consume();
                }
                this.menuNext.setVisible(false);
            }
        }

        public HistoryToolbar(SQLEditor sQLEditor, ActionManager actionManager) {
            super(actionManager);
            this.editor = sQLEditor;
            this.setFloatable(false);
            this.add(this.menuNext);
        }

        public void addButtons() {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/isqlviewer/resource/icons/Multiplespaces22.gif"));
            this.multispaceQueryButton = new JToggleButton(imageIcon, false);
            this.multispaceQueryButton.setToolTipText("Multi space query.");
            this.addButton(this.manager.getAction(17)).addMouseListener(this);
            this.addButton(this.manager.getAction(16));
            this.addButton(this.manager.getAction(15));
            this.addButton(this.manager.getAction(18)).addMouseListener(this);
            this.addButton(this.manager.getAction(35));
            this.addSeparator();
            this.add(this.multispaceQueryButton);
            this.add(Box.createHorizontalGlue());
            this.addButton(this.manager.getAction(14));
            this.addButton(this.manager.getAction(12));
            this.addButton(this.manager.getAction(13));
        }

        public void configureMenu(JMenuItem jMenuItem, int n2) {
            jMenuItem.putClientProperty("index", new Integer(n2));
            jMenuItem.setIcon(BasicUtilities.loadIconResource("History16"));
            jMenuItem.setFont(jMenuItem.getFont().deriveFont(9.0f));
        }

        public void processDropProxy(Transferable transferable, int n2) {
        }
    }

    public static class ResultDelegate
    extends JPanel
    implements ActionListener,
    ResultSetViewer {
        private JProgressBar eyecandy = new JProgressBar(0);
        private JLabel lblInfo = new JLabel();
        private JButton btnCancel = new JButton();
        private String sid = null;
        private DatabaseConnection currentConnection = new DatabaseConnection();
        private SQLWorkBench workbench = null;

        public ResultDelegate(SQLWorkBench sQLWorkBench, DatabaseConnection databaseConnection) {
            this.currentConnection = databaseConnection;
            this.workbench = sQLWorkBench;
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.btnCancel) {
                this.cancelButtonPressed();
            }
        }

        public void cancelButtonPressed() {
            int n2 = this.workbench.resultPane.indexOfComponent(this);
            this.btnCancel.setEnabled(false);
            this.workbench.resultPane.setClosableTab(n2, true);
            this.eyecandy.setIndeterminate(false);
            this.lblInfo.setText(BasicUtilities.getString("Query_Cancelled"));
            this.eyecandy.setValue(this.eyecandy.getMaximum());
            if (this.currentConnection == null) {
                this.currentConnection = new DatabaseConnection();
            }
            this.currentConnection.cancelStatement(this.sid);
        }

        public void statementInitialized(String string) {
            this.sid = string;
            int n2 = this.workbench.resultPane.indexOfComponent(this);
            if (n2 < 0) {
                n2 = this.workbench.resultPane.getTabCount();
                this.workbench.resultPane.addTab("", this);
            }
            this.lblInfo.setText(BasicUtilities.getString("Query_Initialized", string));
            this.btnCancel.setEnabled(true);
            this.workbench.resultPane.setClosableTab(n2, false);
            this.eyecandy.setIndeterminate(true);
            this.eyecandy.setValue(this.eyecandy.getMinimum());
        }

        public void handleSQLException(ResultSet resultSet, SQLException sQLException) {
            System.out.println(BasicUtilities.getString("Query_Failed"));
            BasicUtilities.HandleException(sQLException, null, this.currentConnection.getDebugOn());
            int n2 = this.workbench.resultPane.indexOfComponent(this);
            if (n2 >= 0) {
                this.workbench.resultPane.removeTabAt(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processResultSet(String string, ResultSet resultSet, String string2, int n2, IJSpace iJSpace) {
            this.btnCancel.setEnabled(false);
            this.lblInfo.setText(BasicUtilities.getString("Processing_Query_Results"));
            System.out.println(this.lblInfo.getText());
            if (resultSet != null) {
                try {
                    ResultSetTableModel resultSetTableModel = new ResultSetTableModel(resultSet, this, true);
                    ResultsetView resultsetView = new ResultsetView(this.workbench, iJSpace);
                    ITable iTable = resultsetView.getTable();
                    iTable.putClientProperty("ITable.JPopupMenu", this.workbench.tablePopupMenu);
                    iTable.putClientProperty(SQLWorkBench.CLIENT_RAW_SQL, string2);
                    resultsetView.setModel(resultSetTableModel);
                    String string3 = "";
                    Icon icon = null;
                    if (n2 >= 0) {
                        try {
                            String string4 = this.workbench.preferences.get("general.results-format");
                            string3 = JDBCUtilities.getResultString(string4, resultSet, this.currentConnection, resultSetTableModel);
                        }
                        catch (Throwable throwable) {
                            string3 = JDBCUtilities.getResultString("%s (%r,%c)", resultSet, this.currentConnection, resultSetTableModel);
                        }
                        icon = BasicUtilities.loadIconResource("Table16");
                    } else {
                        string3 = BasicUtilities.getString("Generated_Keys_Txt");
                        icon = BasicUtilities.loadIconResource("KeyTable16");
                    }
                    int n3 = this.workbench.resultPane.indexOfComponent(this);
                    if (n3 < 0) {
                        this.workbench.resultPane.addTab("", this);
                        n3 = this.workbench.resultPane.indexOfComponent(this);
                    }
                    String string5 = this.addSubText(this.workbench.txtSQLEditor.toHTML(string2));
                    this.workbench.resultPane.setToolTipTextAt(n3, string5);
                    this.workbench.resultPane.setTitleAt(n3, tabTitle + string2);
                    this.workbench.resultPane.setComponentAt(n3, resultsetView);
                    this.workbench.resultPane.setClosableTab(n3, true);
                    this.workbench.resultPane.setIconAt(n3, icon);
                    if (this.currentConnection.getQueryEchoOn()) {
                        String string6 = Integer.toString(resultSetTableModel.getTrueRowCount());
                        String string7 = BasicUtilities.getString("Number_Of_Records", string6);
                        System.out.println(string7);
                    }
                    BasicUtilities.optimizeTableView(iTable);
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, BasicUtilities.getString("Query_Exception"));
                    int n4 = this.workbench.resultPane.indexOfComponent(this);
                    if (n4 >= 0) {
                        this.workbench.resultPane.removeTabAt(n4);
                    }
                }
                finally {
                    SQLWarningViewer.addConnectionWarnings(this.currentConnection.getWarnings());
                    this.validateTree();
                }
            }
        }

        public void recieveResultsetWarnings(ResultSet resultSet, SQLWarning sQLWarning) {
            SQLWarningViewer.addResultsetWarnings(sQLWarning);
        }

        public void recieveStatementWarnings(Statement statement, SQLWarning sQLWarning) {
            SQLWarningViewer.addStatementWarnings(sQLWarning);
        }

        public void processRowUpdates(String string, int n2, String string2) {
            UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
            String string3 = Integer.toString(n2);
            boolean bl2 = userPreferences.getBoolean("general.showupdatetab-enabled");
            if (!bl2) {
                System.out.println(BasicUtilities.getString("Processing_Update_Count", string3));
                int n3 = this.workbench.resultPane.indexOfComponent(this);
                if (n3 >= 0) {
                    this.workbench.resultPane.removeTabAt(n3);
                }
            } else {
                this.btnCancel.setEnabled(false);
                int n4 = this.workbench.resultPane.indexOfComponent(this);
                if (n4 < 0) {
                    n4 = this.workbench.resultPane.getTabCount();
                    this.workbench.resultPane.addTab("", this);
                }
                this.eyecandy.setIndeterminate(false);
                this.eyecandy.setValue(this.eyecandy.getMaximum());
                String string4 = this.addSubText(this.workbench.txtSQLEditor.toHTML(string2));
                this.workbench.resultPane.setToolTipTextAt(n4, string4);
                this.workbench.resultPane.setClosableTab(n4, true);
                this.workbench.resultPane.setTitleAt(n4, BasicUtilities.getString("UpdateCount_Tab_Title", string3));
                this.workbench.resultPane.setIconAt(n4, BasicUtilities.loadIconResource("TableInfo16"));
                this.lblInfo.setText(BasicUtilities.getString("Processing_Update_Count", string3));
                this.putClientProperty(SQLWorkBench.CLIENT_RAW_SQL, string2);
            }
            this.validateTree();
            this.repaint();
        }

        public void handleStatementInterrupted(String string) {
            System.out.println(BasicUtilities.getString("Query_Failed"));
            int n2 = this.workbench.resultPane.indexOfComponent(this);
            this.workbench.resultPane.setClosableTab(n2, true);
            this.eyecandy.setIndeterminate(false);
            this.lblInfo.setText(BasicUtilities.getString("Query_Cancelled"));
            this.eyecandy.setValue(this.eyecandy.getMaximum());
        }

        public void processGeneratedKeys(String string, ResultSet resultSet, String string2) {
            this.processResultSet(string, resultSet, string2, Integer.MIN_VALUE, this.currentConnection.getGsSpaceProxy());
        }

        public boolean supportsGeneratedKeys() {
            return true;
        }

        public boolean supportsUpdateableResultSets() {
            return false;
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            this.btnCancel.setText(BasicUtilities.getString("Cancel"));
            this.btnCancel.setToolTipText(BasicUtilities.getString("Cancel_Statement_Tip"));
            this.btnCancel.addActionListener(this);
            SQLWorkBench.constrain(0, 0, 1, 5, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 1, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.lblInfo, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 2, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.eyecandy, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 3, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.btnCancel, UI_CONSTRAINT);
            SQLWorkBench.constrain(2, 0, 1, 5, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 4, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
        }

        private String addSubText(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = InputEvent.getModifiersExText(BasicUtilities.CMD_MASK << 6);
            String string3 = BasicUtilities.getString("SQL_TabTip_Text", string2);
            stringBuffer.append("<div align=\"center\"><font size=\"-2\" color=\"");
            stringBuffer.append(StringUtilities.getHTMLColor(Color.BLACK));
            stringBuffer.append("\"><tt><var>");
            stringBuffer.append(string3);
            stringBuffer.append("</var></tt></font></div>");
            return stringBuffer.toString();
        }
    }

    private static class BookmarkDnDSupport
    extends DropTargetAdapter {
        private SQLWorkBench workbench = null;

        public BookmarkDnDSupport(SQLWorkBench sQLWorkBench) {
            this.workbench = sQLWorkBench;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            JComponent jComponent = (JComponent)dropTargetDropEvent.getDropTargetContext().getComponent();
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                if (transferable.isDataFlavorSupported(BasicUtilities.bookmarkFlavour)) {
                    SQLBookmark sQLBookmark = (SQLBookmark)transferable.getTransferData(BasicUtilities.bookmarkFlavour);
                    boolean bl2 = jComponent instanceof ITable;
                    this.workbench.executeBookmark(sQLBookmark, this.workbench.controller, bl2);
                }
            }
            catch (Throwable throwable) {
                dropTargetDropEvent.rejectDrop();
            }
            finally {
                dropTargetDropEvent.dropComplete(true);
            }
        }
    }

    private class InputSupport
    implements ItemListener,
    ActionListener,
    PreferenceChangeListener,
    ChangeListener {
        private InputSupport() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ActionManager actionManager = SQLWorkBench.this.controller.getActionManager();
            Object object = changeEvent.getSource();
            if (object == SQLWorkBench.this.resultPane) {
                boolean bl2;
                boolean bl3 = bl2 = SQLWorkBench.this.resultPane.getTabCount() == 0;
                if (!bl2) {
                    try {
                        ResultsetView resultsetView = (ResultsetView)SQLWorkBench.this.resultPane.getSelectedComponent();
                        if (!SQLWorkBench.this.isTabAdditionProceed) {
                            String string = SQLWorkBench.this.resultPane.getTitleAt(SQLWorkBench.this.resultPane.getSelectedIndex());
                            String string2 = SQLWorkBench.getQuery(string);
                            SQLWorkBench.this.txtSQLEditor.setText(string2);
                        }
                        SQLWorkBench.this.toggleResultSetDataView(resultsetView, false);
                        SQLWorkBench.this.toggleColumnDeleteAction(SQLWorkBench.this.getSelectedTable(), false);
                        SQLWorkBench.this.toggleLockAction(SQLWorkBench.this.resultPane.getSelectedIndex(), false);
                    }
                    catch (Exception exception) {}
                } else if (SQLWorkBench.this.resultPane.getParent() != SQLWorkBench.this.resultsPanel && SQLWorkBench.this.controller.zoomComponent(SQLWorkBench.this.resultPane) != null) {
                    SQLWorkBench.this.resultsPanel.add((Component)SQLWorkBench.this.resultPane, "Center");
                    SQLWorkBench.this.invalidate();
                    SQLWorkBench.this.repaint();
                }
                SQLWorkBench.this.jtbResultset.setActionEnabled(!bl2);
                actionManager.setActionEnabled(1, !bl2);
                actionManager.setActionEnabled(5, !bl2);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JCheckBoxAction jCheckBoxAction = (JCheckBoxAction)itemEvent.getItem();
            String string = jCheckBoxAction.getValue("Name").toString();
            boolean bl2 = jCheckBoxAction.isSelected();
            if (string.equalsIgnoreCase(SQLWorkBench.this.jtbHistory.getName())) {
                SQLWorkBench.this.preferences.putBoolean("toolbar.history-visible", bl2);
            } else if (string.equalsIgnoreCase(SQLWorkBench.this.jtbResultset.getName())) {
                SQLWorkBench.this.preferences.putBoolean("toolbar.resultset-visible", bl2);
            }
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if (string.equals("toolbar.resultset-dock")) {
                SQLWorkBench.this.removeResultsetToolbar();
                SQLWorkBench.this.createResultSetToolBar();
            } else if (string.equals("toolbar.history-dock")) {
                SQLWorkBench.this.removeHistoryToolbar();
                SQLWorkBench.this.createHistoryToolBar();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SQLWorkBench.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SQLWorkBench.this.processAction(actionEvent);
            }
            catch (Throwable throwable) {
                _logger.log(Level.SEVERE, "SQLWorkbench::processAction() " + throwable.toString(), throwable);
            }
            finally {
                SQLWorkBench.this.setCursor(Cursor.getDefaultCursor());
                System.runFinalization();
            }
        }

        public /* synthetic */ InputSupport(1 var2_2) {
            this();
        }
    }

    private static class ResultSetToggler
    implements Runnable {
        private ITable table = null;
        private AppController ctrlr = null;
        private ResultsetToolbar toolbar = null;
        private boolean doSwitch = false;

        public ResultSetToggler(AppController appController, ITable iTable, ResultsetToolbar resultsetToolbar, boolean bl2) {
            this.table = iTable;
            this.ctrlr = appController;
            this.doSwitch = bl2;
            this.toolbar = resultsetToolbar;
        }

        public void run() {
            ActionManager actionManager = this.ctrlr.getActionManager();
            if (this.table != null) {
                Action action;
                ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
                if (resultSetTableModel.isShowingMetadata()) {
                    if (this.doSwitch) {
                        resultSetTableModel.showResultSetData();
                        action = actionManager.getAction(27);
                    } else {
                        action = actionManager.getAction(26);
                    }
                } else if (this.doSwitch) {
                    resultSetTableModel.showMetaData();
                    action = actionManager.getAction(26);
                } else {
                    action = actionManager.getAction(27);
                }
                if (this.doSwitch) {
                    BasicUtilities.optimizeTableView(this.table);
                }
                if (this.toolbar != null) {
                    this.toolbar.toggleAction(26, action);
                }
            }
        }
    }

    private static class ResultsetView
    extends JPanel
    implements ListSelectionListener,
    ActionListener,
    DocumentListener {
        private NumberFormat nf = NumberFormat.getIntegerInstance();
        private SQLWorkBench workbench = null;
        private ITable table = null;
        private JTextField txtFilter = new JTextField();
        private JLabel lblFilter = new JLabel();
        private JScrollPane jspTable = null;
        private Component glue = Box.createHorizontalGlue();
        private JLabel lblLocatr = new JLabel();
        private JLabel lblSearch = new JLabel(BasicUtilities.loadIconResource("Search"));
        private JButton btnHider = new JButton();
        private JButton actionPageUp = new JButton(BasicUtilities.loadIconResource("Up16"));
        private JButton actionPageDown = new JButton(BasicUtilities.loadIconResource("Down16"));
        private IJSpace _spaceProxy;

        public ResultsetView(SQLWorkBench sQLWorkBench, IJSpace iJSpace) {
            this.workbench = sQLWorkBench;
            this._spaceProxy = iJSpace;
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }

        private void initUI() {
            this.table = new ITable(this.workbench.controller.getActionManager());
            this.table.setSpaceProxy(this._spaceProxy);
            this.table.setDropTarget(new DropTarget(this.table, this.workbench.bookmarkDropper));
            this.table.setFont(this.table.getFont().deriveFont(10.0f));
            this.table.putClientProperty("ITable.JPopupMenu", this.workbench.tablePopupMenu);
            this.table.setDragEnabled(true);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.setSelectionMode(0);
            this.jspTable = new JScrollPane(this.table);
            this.lblLocatr.setBorder(BorderFactory.createEtchedBorder());
            this.btnHider.setIcon(new SortableHeaderRenderer.BasicArrowIcon(1, 4));
            this.btnHider.setBorderPainted(false);
            this.btnHider.setFocusPainted(false);
            this.btnHider.addActionListener(this);
            this.btnHider.setToolTipText(BasicUtilities.getString("Filter_Hide_Tip"));
            this.actionPageUp.addActionListener(this);
            this.actionPageUp.setBorderPainted(false);
            this.actionPageUp.setFocusPainted(false);
            this.actionPageUp.setToolTipText(BasicUtilities.getString("View_Prev"));
            this.actionPageDown.addActionListener(this);
            this.actionPageDown.setBorderPainted(false);
            this.actionPageDown.setFocusPainted(false);
            this.actionPageDown.setToolTipText(BasicUtilities.getString("View_Next"));
            this.txtFilter.setToolTipText(BasicUtilities.getString("Filter_Input_Tip"));
            this.txtFilter.getDocument().addDocumentListener(this);
            this.lblFilter.setFont(this.lblFilter.getFont().deriveFont(9.0f));
            this.setLayout(new GridBagLayout());
            SQLWorkBench.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
            this.add(this.glue, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 2);
            this.add((Component)this.lblSearch, UI_CONSTRAINT);
            SQLWorkBench.constrain(2, 0, 1, 1, 0.35, 0.0, 17, 2);
            this.add((Component)this.txtFilter, UI_CONSTRAINT);
            SQLWorkBench.constrain(3, 0, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.btnHider, UI_CONSTRAINT);
            SQLWorkBench.constrain(2, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.lblFilter, UI_CONSTRAINT);
            SQLWorkBench.constrain(0, 2, 4, 1, 1.0, 1.0, 10, 1);
            this.add((Component)this.jspTable, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 3, 4, 1, 1.0, 0.0, 13, 0);
            this.add((Component)this.lblLocatr, UI_CONSTRAINT);
        }

        public void setModel(EnhancedTableModel enhancedTableModel) {
            this.table.setModel(enhancedTableModel);
            if (enhancedTableModel.getTrueRowCount() >= 1) {
                this.table.setRowSelectionInterval(0, 0);
            }
            if (enhancedTableModel.getPageCount() > 1) {
                this.jspTable.setHorizontalScrollBarPolicy(32);
                this.jspTable.setVerticalScrollBarPolicy(22);
                this.jspTable.setCorner("UPPER_RIGHT_CORNER", this.actionPageUp);
                this.jspTable.setCorner("LOWER_RIGHT_CORNER", this.actionPageDown);
            } else {
                this.jspTable.setHorizontalScrollBarPolicy(30);
                this.jspTable.setVerticalScrollBarPolicy(20);
                this.jspTable.setCorner("UPPER_RIGHT_CORNER", Box.createHorizontalStrut(0));
                this.jspTable.setCorner("LOWER_RIGHT_CORNER", Box.createHorizontalStrut(0));
            }
        }

        public ITable getTable() {
            return this.table;
        }

        public void clearFiltering() {
            if (this.table != null) {
                ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
                resultSetTableModel.clearFilter();
            }
            this.txtFilter.setText(null);
            this.lblFilter.setText(null);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doFiltering();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doFiltering();
        }

        private void doFiltering() {
            if (this.table != null) {
                String string;
                ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
                int n2 = resultSetTableModel.applyFilter(string = this.txtFilter.getText().trim());
                if (n2 >= 1) {
                    String string2 = BasicUtilities.getString("Filter_Matches", Integer.toString(n2));
                    this.lblFilter.setText(string2);
                } else if (string.length() >= 1) {
                    this.lblFilter.setText(BasicUtilities.getString("Filter_No_Matches"));
                } else {
                    this.lblFilter.setText(null);
                }
                if (this.table.getRowCount() >= 1) {
                    this.table.setRowSelectionInterval(0, 0);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.btnHider) {
                this.txtFilter.setVisible(!this.txtFilter.isVisible());
                this.lblFilter.setVisible(!this.lblFilter.isVisible());
                this.lblSearch.setVisible(!this.lblSearch.isVisible());
                this.glue.setVisible(!this.glue.isVisible());
                if (this.txtFilter.isVisible()) {
                    this.btnHider.setIcon(new SortableHeaderRenderer.BasicArrowIcon(1, 4));
                    this.btnHider.setToolTipText(BasicUtilities.getString("Filter_Hide_Tip"));
                } else {
                    this.btnHider.setIcon(new SortableHeaderRenderer.BasicArrowIcon(5, 4));
                    this.btnHider.setToolTipText(BasicUtilities.getString("Filter_Show_Tip"));
                }
                this.validateTree();
                this.repaint();
            } else if (object == this.actionPageDown) {
                EnhancedTableModel enhancedTableModel = (EnhancedTableModel)this.table.getModel();
                enhancedTableModel.pageDown();
            } else if (object == this.actionPageUp) {
                EnhancedTableModel enhancedTableModel = (EnhancedTableModel)this.table.getModel();
                enhancedTableModel.pageUp();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            EnhancedTableModel enhancedTableModel = (EnhancedTableModel)this.table.getModel();
            String string = this.nf.format(enhancedTableModel.translateRow(this.table.getSelectedRow()) + 1);
            string = string.concat("/");
            string = string.concat(this.nf.format(enhancedTableModel.getTrueRowCount()));
            string = string.concat(" [");
            string = string.concat(this.nf.format(enhancedTableModel.getPageOffset() + 1));
            string = string.concat("/");
            string = string.concat(this.nf.format(enhancedTableModel.getPageCount()));
            this.lblLocatr.setText(" ".concat(string).concat("] "));
        }
    }
}

