/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.jetfire.ImportRunner;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ImportEditor;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.swing.TableFilterEditor;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;

public final class ImportWizard
extends WizardContainer
implements ActionListener {
    private ImportEditor dataMapper = null;
    private ProgressPanel pnlProgress = new ProgressPanel();
    private static final String STEP_SELECT = "SELECT";
    private static final String STEP_IMPORT = "IMPORT";
    private static final String STEP_PROGRESS = "PROGRESS";
    private EnhancedTableModel mdlImportData = new EnhancedTableModel(new String[0]);
    private DatabaseConnection databaseConnection;
    private TableFilterEditor jfeFilterSelector = null;
    private Thread importThread;

    public ImportWizard(Frame frame, DatabaseConnection databaseConnection) {
        super(frame);
        this.setTitle(BasicUtilities.getString("Import_Wizard_Title"));
        try {
            this.databaseConnection = databaseConnection;
            this.jfeFilterSelector = new TableFilterEditor(0, databaseConnection);
            this.initUI();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pack();
        this.setSize(new Dimension(800, 580));
        this.setLocationRelativeTo(frame);
        this.startWizard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.importThread != null) {
            this.importThread.interrupt();
            try {
                this.importThread.join(15000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.importThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 205) {
            int n2 = -1;
            if (n2 >= 0) {
                this.jfeFilterSelector.setSelectedFilterIndex(n2);
            } else {
                this.jfeFilterSelector.setSelectedFilterIndex(0);
            }
        } else if (windowEvent.getID() == 201) {
            if (this.importThread != null && this.importThread.isAlive()) {
                if (!this.importThread.isInterrupted()) {
                    this.importThread.interrupt();
                }
                try {
                    this.importThread.join(15000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.importThread = null;
                }
            }
            this.jfeFilterSelector.close();
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean isStepValid(String string) {
        if (string.equals(STEP_IMPORT)) {
            return !this.dataMapper.getImportConfig().isEmpty();
        }
        return super.isStepValid(string);
    }

    public void processStepChange(String string, boolean bl2, String string2) {
        if (string.equalsIgnoreCase(STEP_PROGRESS)) {
            this.setPreviousStepEnabled(true);
            this.setBanner(BasicUtilities.getString("Import_Progress_Banner"));
            this.setComment(BasicUtilities.getString("Import_Progress_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Import24"));
            int n2 = string2.equals(STEP_SELECT) ? 1 : 2;
            ImportWorker importWorker = new ImportWorker(n2);
            String string3 = "import:" + this.jfeFilterSelector.getSelectedFilter().getName();
            this.importThread = new Thread((Runnable)importWorker, string3);
            this.importThread.start();
            return;
        }
        if (string.equalsIgnoreCase(STEP_IMPORT)) {
            this.removeUserComponent(STEP_PROGRESS);
            this.pnlProgress.reset();
            this.addUserComponent(STEP_PROGRESS, this.pnlProgress);
            this.setBanner(BasicUtilities.getString("Import_Map_Banner"));
            this.setComment(BasicUtilities.getString("Import_Map_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Import24"));
            return;
        }
        if (string.equalsIgnoreCase(STEP_SELECT)) {
            this.removeUserComponent(STEP_IMPORT);
            this.setPreviousStepEnabled(false);
            this.setBanner(BasicUtilities.getString("Import_Select_Banner"));
            this.setComment(BasicUtilities.getString("Import_Select_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Database24"));
        }
    }

    private void initUI() {
        this.pnlProgress.addActionListener(this);
        this.jfeFilterSelector.setFilterContent(this.mdlImportData);
        this.setDefaultCloseOperation(2);
        this.setHomeAllowable(false);
        this.addUserComponent(STEP_SELECT, this.jfeFilterSelector);
        this.addUserComponent(STEP_PROGRESS, this.pnlProgress);
        this.setSize(800, 570);
    }

    private class ImportWorker
    implements Runnable {
        public static final int MODE_DATA_FILTER = 1;
        public static final int MODE_DATA_IMPORT = 2;
        private int opMode = 0;
        private PrintStream err = ImportWizard.access$000(ImportWizard.this).getErrStream();
        private PrintStream out = ImportWizard.access$000(ImportWizard.this).getOutStream();

        public ImportWorker(int n2) {
            if (n2 != 1 && n2 != 2) {
                throw new IllegalArgumentException();
            }
            this.opMode = n2;
        }

        public void run() {
            ImportWizard.this.setPreviousStepEnabled(false);
            ImportWizard.this.setNextStepEnabled(false);
            switch (this.opMode) {
                case 1: {
                    try {
                        this.runFilter();
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable, "ImportProcess:runFilter()");
                    }
                    break;
                }
                case 2: {
                    try {
                        ImportRunner importRunner = new ImportRunner(ImportWizard.this.dataMapper.getImportConfig(), ImportWizard.this.databaseConnection);
                        importRunner.setSourceData(ImportWizard.this.mdlImportData);
                        importRunner.setStdErr(this.err);
                        importRunner.setStdOut(this.out);
                        importRunner.runImport();
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable, "ImportProcess:runImport()");
                    }
                    this.out.println(BasicUtilities.getString("Import_Finish_Info"));
                    break;
                }
            }
            ImportWizard.this.setPreviousStepEnabled(true);
            ImportWizard.this.setNextStepEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void runFilter() {
            TableFilter tableFilter = ImportWizard.this.jfeFilterSelector.getSelectedFilter();
            InputStream inputStream = null;
            File file = null;
            if (tableFilter == null) {
                JOptionPane.showMessageDialog(ImportWizard.this, BasicUtilities.getString("Import_No_Filter_Error"));
                return;
            }
            tableFilter.addProgressListener(ImportWizard.this.pnlProgress);
            tableFilter.setLogStream(new PrintWriter(this.out, true));
            ImportWizard.this.mdlImportData.clearAll();
            if (tableFilter.isFileRequired(0)) {
                FileFilter[] fileFilterArray = tableFilter.getSupportedFileTypes(0);
                file = BasicUtilities.getSystemFile(ImportWizard.this, 2, fileFilterArray);
                if (file == null) {
                    this.out.println(BasicUtilities.getString("Import_Cancelled"));
                    return;
                }
                if (!tableFilter.accept(0, file)) {
                    this.out.println(BasicUtilities.getString("Import_File_Not_Accepted", file.getAbsolutePath()));
                    ImportWizard.this.setNextStepEnabled(false);
                    return;
                }
                try {
                    if (file.isFile()) {
                        inputStream = new FileInputStream(file);
                    }
                }
                catch (Throwable throwable) {
                    String string = BasicUtilities.getString("Error_Reading_File", file.getAbsolutePath());
                    BasicUtilities.HandleException(throwable, string, true, this.err);
                    ImportWizard.this.setNextStepEnabled(false);
                    return;
                }
            }
            int n2 = -1;
            Thread.currentThread().setContextClassLoader(tableFilter.getClass().getClassLoader());
            try {
                long l2 = System.currentTimeMillis();
                this.out.println(BasicUtilities.getString("Import_Starting", tableFilter.getName()));
                n2 = tableFilter.filterIn(ImportWizard.this.mdlImportData, file, inputStream);
                l2 = System.currentTimeMillis() - l2;
                this.out.println(BasicUtilities.getString("Import_Complete", Long.toString(l2)));
            }
            catch (IOException iOException) {
                n2 = 0;
                BasicUtilities.HandleException((Throwable)iOException, BasicUtilities.getString("IO_Filter_Error"), true, this.err);
            }
            catch (InterruptedException interruptedException) {
                n2 = 2;
                BasicUtilities.HandleException((Throwable)interruptedException, BasicUtilities.getString("Interrupted_Filter_Error"), true, this.err);
            }
            catch (Throwable throwable) {
                n2 = 0;
                BasicUtilities.HandleException(throwable, BasicUtilities.getString("Unhandled_Filter_Error"), true, this.err);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
                inputStream = null;
            }
            tableFilter.removeProgressListener(ImportWizard.this.pnlProgress);
            switch (n2) {
                case 2: {
                    this.err.println(BasicUtilities.getString("Interrupted_Filter_Error"));
                    return;
                }
                case 1: {
                    this.out.println(BasicUtilities.getString("Import_Finished", tableFilter.getName()));
                    return;
                }
                case 3: {
                    if (ImportWizard.this.dataMapper == null) {
                        ImportWizard.this.dataMapper = new ImportEditor(ImportWizard.this.databaseConnection);
                    }
                    ImportWizard.this.addUserComponent(ImportWizard.STEP_IMPORT, ImportWizard.this.dataMapper);
                    ImportWizard.this.dataMapper.setData(ImportWizard.this.mdlImportData);
                    this.out.println(BasicUtilities.getString("Import_Map_Required", tableFilter.getName()));
                    return;
                }
            }
            this.err.println(BasicUtilities.getString("Import_Failed", tableFilter.getName()));
        }
    }
}

