/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import com.j_spaces.core.IJSpace;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ITableCellEditor;
import org.isqlviewer.swing.ITableCellRenderer;
import org.isqlviewer.swing.SortableHeaderRenderer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.Sortable;
import org.isqlviewer.util.UserPreferences;
import org.pf.joi.Inspector;

public class ITable
extends JTable {
    public static final int INPUT_EVENT_DOUBLE_CLICK = 511;
    public static final int INPUT_EVENT_COMMAND_CLICK = 767;
    public static final int INPUT_EVENT_HEADER_CLICK = 1023;
    public static final String CLIENT_PRINTING = "isPrinting";
    public static final String CLIENT_JPOPUP_MENU = "ITable.JPopupMenu";
    private static final String DELETE_ACTION = "DELETE_SELECTED";
    private static DragSource dndDragSource = DragSource.getDefaultDragSource();
    public static SystemConfig config = SystemConfig.getInstance();
    public SortableHeaderRenderer header = new SortableHeaderRenderer(this);
    public ActionManager mgr = null;
    public MouseInputAdapter mouseInputHandler = null;
    public int defaultSortedColumn = -1;
    public boolean selectionToggle = true;
    public DnDSupport dndHandler = new DnDSupport(this);
    public DragGestureRecognizer dndRecognizer = null;
    private IJSpace _spaceProxy;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public ITable() {
        this((ActionManager)null);
    }

    public ITable(TableModel tableModel) {
        this((ActionManager)null);
        this.setModel(tableModel);
    }

    public ITable(ActionManager actionManager) {
        super(0, 0);
        super.setDragEnabled(false);
        this.mgr = actionManager;
        this.mouseInputHandler = new TableMouseAdapter(this);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(this.mouseInputHandler);
        this.addMouseMotionListener(this.mouseInputHandler);
        this.getTableHeader().setDefaultRenderer(this.header);
        this.getTableHeader().addMouseListener(this.mouseInputHandler);
        this.putClientProperty(CLIENT_PRINTING, new Boolean(false));
        this.initDefaultRenderers();
        this.initDefaultEditors();
        this.setAutoResizeMode(0);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = BasicUtilities.createKeyStroke(67, BasicUtilities.CMD_MASK);
        inputMap.put(keyStroke, "HT.CELL.COPY");
        actionMap.put("HT.CELL.COPY", new CellCopyAction(this));
    }

    public void refreshSorted() {
        Sortable sortable = null;
        if (this.getModel() instanceof Sortable) {
            sortable = (Sortable)((Object)this.getModel());
        }
        if (sortable == null) {
            return;
        }
        int n2 = this.header.getSortedColumn();
        if (n2 == -1) {
            return;
        }
        boolean bl2 = this.header.isAscending();
        if (sortable.canSort(n2, bl2)) {
            sortable.sort(n2, bl2);
        }
    }

    public EnhancedTableModel getSelectedSubModel() {
        int[] nArray = null;
        nArray = this.selectionToggle ? (this.getRowSelectionAllowed() ? this.getSelectedRows() : ITable.createIterativeArray(this.getRowCount())) : this.getSelectedRows();
        int[] nArray2 = null;
        nArray2 = this.selectionToggle ? (this.getColumnSelectionAllowed() ? this.getSelectedColumns() : ITable.createIterativeArray(this.getColumnCount())) : this.getSelectedRows();
        return ((EnhancedTableModel)this.getModel()).subModel(nArray, nArray2);
    }

    public void setSelectionToggleEnabled(boolean bl2) {
        this.selectionToggle = bl2;
    }

    public void addActionListener(ActionListener actionListener) {
        Class<?> clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = new ActionListener[0].getClass().getComponentType();
        }
        this.listenerList.add(clazz, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        Class<?> clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = new ActionListener[0].getClass().getComponentType();
        }
        this.listenerList.remove(clazz, actionListener);
    }

    public void setValueAt(Object object, int n2, int n3) {
        try {
            super.setValueAt(object, n2, n3);
        }
        catch (Throwable throwable) {
            Window window = SwingUtilities.getWindowAncestor(this);
            BasicUtilities.showExceptionPopup(window, throwable, throwable.getMessage());
        }
    }

    public void allowColumnReordering(boolean bl2) {
        this.getTableHeader().setReorderingAllowed(bl2);
    }

    public void allowColumnResizing(boolean bl2) {
        this.getTableHeader().setResizingAllowed(bl2);
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        Class<?> clazz;
        if (this.mgr != null) {
            this.mgr.forwardAction(actionEvent);
        }
        if ((clazz = class$java$awt$event$ActionListener) == null) {
            clazz = class$java$awt$event$ActionListener = new ActionListener[0].getClass().getComponentType();
        }
        ActionListener[] actionListenerArray = (ActionListener[])this.listenerList.getListeners(clazz);
        for (int i2 = 0; i2 < actionListenerArray.length; ++i2) {
            try {
                actionListenerArray[i2].actionPerformed(actionEvent);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void initDefaultRenderers() {
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz, new ITableCellRenderer());
        Class<?> clazz2 = class$java$lang$Number;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Number = new Number[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz2, new ITableCellRenderer(4));
        Class<?> clazz3 = class$java$lang$Float;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz3, new ITableCellRenderer(6));
        Class<?> clazz4 = class$java$lang$Double;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz4, new ITableCellRenderer(8));
        Class<?> clazz5 = class$java$util$Date;
        if (clazz5 == null) {
            clazz5 = class$java$util$Date = new Date[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz5, new ITableCellRenderer(91));
        Class<?> clazz6 = class$java$sql$Time;
        if (clazz6 == null) {
            clazz6 = class$java$sql$Time = new Time[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz6, new ITableCellRenderer(92));
        Class<?> clazz7 = class$java$sql$Timestamp;
        if (clazz7 == null) {
            clazz7 = class$java$sql$Timestamp = new Timestamp[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz7, new ITableCellRenderer(93));
        Class<?> clazz8 = class$java$sql$Blob;
        if (clazz8 == null) {
            clazz8 = class$java$sql$Blob = new Blob[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz8, new ITableCellRenderer(2004));
        Class<?> clazz9 = class$java$sql$Clob;
        if (clazz9 == null) {
            clazz9 = class$java$sql$Clob = new Clob[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz9, new ITableCellRenderer(2005));
        Class<?> clazz10 = class$java$sql$Ref;
        if (clazz10 == null) {
            clazz10 = class$java$sql$Ref = new Ref[0].getClass().getComponentType();
        }
        this.setDefaultRenderer(clazz10, new ITableCellRenderer(2006));
    }

    public void initDefaultEditors() {
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        this.setDefaultEditor(clazz, new ITableCellEditor(1111));
        Class<?> clazz2 = class$java$util$Date;
        if (clazz2 == null) {
            clazz2 = class$java$util$Date = new Date[0].getClass().getComponentType();
        }
        this.setDefaultEditor(clazz2, new ITableCellEditor(91));
        Class<?> clazz3 = class$java$sql$Time;
        if (clazz3 == null) {
            clazz3 = class$java$sql$Time = new Time[0].getClass().getComponentType();
        }
        this.setDefaultEditor(clazz3, new ITableCellEditor(92));
        Class<?> clazz4 = class$java$sql$Timestamp;
        if (clazz4 == null) {
            clazz4 = class$java$sql$Timestamp = new Timestamp[0].getClass().getComponentType();
        }
        this.setDefaultEditor(clazz4, new ITableCellEditor(93));
    }

    public void paintRow(Graphics2D graphics2D, int[] nArray, int n2, boolean bl2) {
        int n3 = this.getIntercellSpacing().width + 4 * SortableHeaderRenderer.SORT_ICON_WIDTH;
        int n4 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n2, nArray[i2]);
            Object object = this.getValueAt(n2, nArray[i2]);
            Component component = tableCellRenderer.getTableCellRendererComponent(this, object, bl2, false, n2, nArray[i2]);
            TableColumn tableColumn = this.columnModel.getColumn(nArray[i2]);
            int n5 = tableColumn.getWidth() + n3;
            Dimension dimension = new Dimension(n5, component.getPreferredSize().height);
            component.setSize(dimension);
            component.setLocation(0, 0);
            component.paint(graphics2D);
            graphics2D.translate(dimension.width, 0);
            if ((n4 += dimension.width) >= graphics2D.getClipBounds().width) break;
        }
    }

    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        int n3 = this.getSelectedRow();
        boolean bl3 = super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
        if (this.getModel() instanceof EnhancedTableModel) {
            EnhancedTableModel enhancedTableModel = (EnhancedTableModel)this.getModel();
            if (enhancedTableModel == null) {
                return bl3;
            }
            switch (keyEvent.getKeyCode()) {
                case 34: 
                case 40: {
                    if (n3 != this.getRowCount() - 1 || keyStroke.isOnKeyRelease() || !enhancedTableModel.pageDown()) break;
                    this.setRowSelectionInterval(0, 0);
                    this.scrollRectToVisible(this.getCellRect(0, 0, true));
                    break;
                }
                case 33: 
                case 38: {
                    if (n3 != 0 || keyStroke.isOnKeyRelease() || !enhancedTableModel.pageUp()) break;
                    this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
                    this.scrollRectToVisible(this.getCellRect(0, 0, true));
                }
            }
        }
        return bl3;
    }

    public void setColumnSelectionAllowed(boolean bl2) {
        super.setColumnSelectionAllowed(bl2);
        if (bl2) {
            if (this.mgr != null) {
                Action action = this.mgr.getAction(20);
                this.getActionMap().put(DELETE_ACTION, action);
                this.getInputMap().put((KeyStroke)action.getValue("AcceleratorKey"), DELETE_ACTION);
            }
            if (this.selectionToggle) {
                super.setRowSelectionAllowed(false);
            }
        } else if (this.selectionToggle) {
            this.setRowSelectionAllowed(true);
        }
    }

    public void setRowSelectionAllowed(boolean bl2) {
        super.setRowSelectionAllowed(bl2);
        if (bl2) {
            if (this.mgr != null) {
                Action action = this.mgr.getAction(19);
                this.getActionMap().put(DELETE_ACTION, action);
                this.getInputMap().put((KeyStroke)action.getValue("AcceleratorKey"), DELETE_ACTION);
            }
            if (this.selectionToggle) {
                super.setColumnSelectionAllowed(false);
            }
        } else if (this.selectionToggle) {
            super.setColumnSelectionAllowed(true);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.setRowHeight(fontMetrics.getHeight());
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2) {
            if (this.dndRecognizer == null) {
                this.dndRecognizer = dndDragSource.createDefaultDragGestureRecognizer(this, 3, this.dndHandler);
            }
        } else if (this.dndRecognizer != null) {
            this.dndRecognizer.resetRecognizer();
            this.dndRecognizer.removeDragGestureListener(this.dndHandler);
            this.dndRecognizer.setComponent(null);
            this.dndRecognizer = null;
        }
    }

    public boolean getDragEnabled() {
        return this.dndRecognizer == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        ITable iTable = this;
        synchronized (iTable) {
            if (tableModel instanceof Sortable) {
                this.refreshSorted();
            }
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getFirstRow() == -1) {
            this.setColumnSizes(0, this.getColumnCount());
            try {
                boolean bl2 = this.getTableHeader().getReorderingAllowed();
                this.allowColumnReordering(bl2 && this.getColumnCount() >= 2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.setColumnSizes(tableColumnModelEvent.getToIndex(), tableColumnModelEvent.getToIndex());
        super.columnAdded(tableColumnModelEvent);
    }

    private void setColumnSizes(int n2, int n3) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n4 = tableColumnModel.getColumnCount();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= n4) {
            n3 = n4 - 1;
        }
        if (n2 > n3) {
            return;
        }
        TableModel tableModel = this.getModel();
        int n5 = this.getRowCount();
        TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        int n6 = this.getIntercellSpacing().width + 4 * SortableHeaderRenderer.SORT_ICON_WIDTH;
        for (int i2 = n2; i2 <= n3; ++i2) {
            TableColumn tableColumn = tableColumnModel.getColumn(i2);
            tableColumn.setPreferredWidth(0);
            int n7 = this.getHeaderWidth(tableCellRenderer, tableColumn) + n6;
            int n8 = n5 == 0 ? 0 : this.getDataWidth(tableModel, tableColumn, i2, n5);
            int n9 = Math.max(n7, n8);
            tableColumn.setPreferredWidth(n9);
            tableColumn.setWidth(n9);
            Class<?> clazz = this.getColumnClass(i2);
            Class<?> clazz2 = class$java$lang$Boolean;
            if (clazz2 == null) {
                clazz2 = new Boolean[0].getClass().getComponentType();
            }
            if (clazz != clazz2 || this.getRowCount() < 1) continue;
            TableCellRenderer tableCellRenderer2 = this.getCellRenderer(0, i2);
            Object object = this.getValueAt(0, i2);
            Component component = tableCellRenderer2.getTableCellRendererComponent(this, object, false, false, 0, i2);
            this.setRowHeight(component.getPreferredSize().height);
        }
    }

    private int getHeaderWidth(TableCellRenderer tableCellRenderer, TableColumn tableColumn) {
        Component component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
        return component.getPreferredSize().width;
    }

    private int getDataWidth(TableModel tableModel, TableColumn tableColumn, int n2, int n3) {
        Boolean bl2;
        int n4 = this.convertColumnIndexToModel(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(tableModel.getColumnClass(n4));
            tableColumn.setCellRenderer(tableCellRenderer);
        }
        bl2 = (bl2 = (Boolean)this.getClientProperty(CLIENT_PRINTING)) == null ? Boolean.FALSE : bl2;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6;
            Object object = tableModel.getValueAt(i2, n4);
            Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, i2, n2);
            if (bl2.booleanValue()) {
                n6 = this.getRowHeight(i2);
                int n7 = component.getPreferredSize().height;
                n7 = Math.max(n7, n6);
                this.setRowHeight(i2, n7);
            }
            n6 = SortableHeaderRenderer.SORT_ICON_WIDTH;
            n5 = Math.max(n5, n6 += component.getPreferredSize().width + 2 * this.getIntercellSpacing().width);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInspection(int n2, boolean bl2) {
        try {
            Object object;
            SpaceBrowser.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            int n3 = this.getColumnCount();
            Object[] objectArray = new Object[n3];
            String[] stringArray = new String[n3];
            String string = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                objectArray[i2] = object = this.getValueAt(n2, i2);
                stringArray[i2] = this.getColumnName(i2);
                if (!"UID".equals(stringArray[i2])) continue;
                string = object.toString();
            }
            SpaceBrowser spaceBrowser = SpaceBrowser.getInstance();
            object = (DefaultMutableTreeNode)spaceBrowser.getSelectedTreeNode();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            String string2 = defaultMutableTreeNode2.toString() + ":" + defaultMutableTreeNode;
            Inspector inspector = null;
            if (bl2) {
                inspector = Inspector.inspect((String)(string == null ? "Row: [" + (n2 + 1) + "]" : string), (Object)objectArray, (String[])stringArray, (String)string2);
            } else if (string == null) {
                JOptionPane.showMessageDialog(spaceBrowser, "Unable to perform object inspection since its UID is not provided\nin query results.Instead row snapshot inspection will be performed.", "Object Inspection", 1);
                inspector = Inspector.inspect((String)("Row: [" + (n2 + 1) + "]"), (Object)objectArray, (String[])stringArray, (String)string2);
            } else {
                inspector = this.invokeObjectInspection(string, string2);
            }
        }
        finally {
            SpaceBrowser.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private Inspector invokeObjectInspection(String string, String string2) {
        Object object;
        try {
            object = JSpaceUtilities.getObjectFromSpaceByUid(this.getSpaceProxy(), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(SpaceBrowser.getInstance(), "The following class was not found. Please add it to the classpath:\n" + classNotFoundException.getMessage(), "Class Not Found", 2);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, classNotFoundException.toString(), classNotFoundException);
            }
            return null;
        }
        catch (Exception exception) {
            SpaceBrowser.showException(exception.toString(), exception);
            return null;
        }
        if (object == null) {
            JOptionPane.showMessageDialog(SpaceBrowser.getInstance(), "Unable to inspect object. It can not be found, probably was already been removed from the space.", "Object not found", 1);
            return null;
        }
        String string3 = object.getClass().getName();
        return Inspector.inspect((String)string, (Object)object, null, (String)(string2 + " " + string3));
    }

    private static int[] createIterativeArray(int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = i2;
        }
        return nArray;
    }

    public IJSpace getSpaceProxy() {
        return this._spaceProxy;
    }

    public void setSpaceProxy(IJSpace iJSpace) {
        this._spaceProxy = iJSpace;
    }

    private static class DnDSupport
    implements DragGestureListener,
    DragSourceListener {
        private static final Point pt = new Point(2, 2);
        private static final int MAX_ROWS = 7;
        private ITable table = null;

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public DnDSupport(ITable iTable) {
            this.table = iTable;
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            DragGestureRecognizer dragGestureRecognizer = dragGestureEvent.getSourceAsDragGestureRecognizer();
            try {
                EnhancedTableModel enhancedTableModel = this.table.getSelectedSubModel();
                if (enhancedTableModel.isEmpty()) {
                    return;
                }
                int[] nArray = null;
                nArray = this.table.selectionToggle ? (this.table.getRowSelectionAllowed() ? this.table.getSelectedRows() : ITable.createIterativeArray(this.table.getRowCount())) : this.table.getSelectedRows();
                int[] nArray2 = null;
                nArray2 = this.table.selectionToggle ? (this.table.getColumnSelectionAllowed() ? this.table.getSelectedColumns() : ITable.createIterativeArray(this.table.getColumnCount())) : this.table.getSelectedRows();
                EnhancedTableModel enhancedTableModel2 = enhancedTableModel;
                if (DragSource.isDragImageSupported()) {
                    int n2;
                    GraphicsConfiguration graphicsConfiguration = this.table.getGraphicsConfiguration();
                    Dimension dimension = this.table.getVisibleRect().getSize();
                    int n3 = 0;
                    int n4 = Math.min(7, nArray.length);
                    for (n2 = 0; n2 < n4; ++n2) {
                        n3 += this.table.getRowHeight(nArray[n2]);
                    }
                    n2 = 0;
                    for (int i2 = 0; i2 < nArray2.length; ++i2) {
                        n2 += this.table.getColumnModel().getColumn(nArray2[i2]).getPreferredWidth();
                    }
                    dimension.setSize(Math.min(dimension.width, n2), n3);
                    BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(dimension.width, n3);
                    int n5 = 0;
                    int n6 = 0;
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        int n7 = this.table.getRowHeight(nArray[i3]);
                        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n5, n6, dimension.width, n7);
                        this.table.paintRow(graphics2D2, nArray2, nArray[i3], false);
                        n6 += n7;
                    }
                    graphics2D.setColor(BasicUtilities.DND_HAZE);
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.drawRect(0, 0, dimension.width - 1, n3 - 1);
                    dndDragSource.startDrag(dragGestureEvent, null, bufferedImage, pt, enhancedTableModel2, this);
                } else {
                    dndDragSource.startDrag(dragGestureEvent, null, enhancedTableModel2, this);
                }
            }
            catch (Throwable throwable) {
                dragGestureRecognizer.resetRecognizer();
                BasicUtilities.beep();
            }
        }
    }

    private static class TableMouseAdapter
    extends MouseInputAdapter {
        private ITable table = null;

        public TableMouseAdapter(ITable iTable) {
            this.table = iTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent mouseEvent) {
            JComponent jComponent;
            Object object = mouseEvent.getSource();
            if (object instanceof JComponent && this.handlePopup(mouseEvent, jComponent = (JComponent)object)) {
                return;
            }
            int n2 = mouseEvent.getModifiers();
            int n3 = this.table.rowAtPoint(mouseEvent.getPoint());
            int n4 = this.table.columnAtPoint(mouseEvent.getPoint());
            boolean bl2 = (n2 & 1) == 1;
            boolean bl3 = (n2 & BasicUtilities.CMD_MASK) == BasicUtilities.CMD_MASK;
            boolean bl4 = (n2 & 8) == 8;
            boolean bl5 = SwingUtilities.isLeftMouseButton(mouseEvent);
            boolean bl6 = SwingUtilities.isMiddleMouseButton(mouseEvent);
            boolean bl7 = this.table.getModel().isCellEditable(n3, n4);
            int n5 = mouseEvent.getClickCount();
            if (object == this.table) {
                if (bl5 && n5 == 2 && !bl2 && !bl3) {
                    if (!bl7 && this.table.selectionToggle) {
                        ActionEvent actionEvent = new ActionEvent(this.table, 511, "");
                        this.table.fireActionEvent(actionEvent);
                        this.table.handleInspection(n3, false);
                    }
                } else if (n5 == 1 && (bl4 || bl6) && n3 >= 0 && n4 >= 0) {
                    ActionEvent actionEvent = new ActionEvent(object, 767, Integer.toString(n4), n3);
                    this.table.fireActionEvent(actionEvent);
                }
                return;
            }
            if (this.table.getModel() instanceof Sortable) {
                UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
                int n6 = userPreferences.getBoolean("general.1clicksort-enabled") ? 1 : 2;
                JTableHeader jTableHeader = (JTableHeader)object;
                if (jTableHeader.getResizingColumn() != null) {
                    if (n5 == 2) {
                        this.table.setColumnSizes(0, this.table.getColumnCount());
                    }
                    return;
                }
                Sortable sortable = (Sortable)((Object)this.table.getModel());
                int n7 = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                if (n5 == n6 && bl5 && n7 >= 0 && sortable != null) {
                    int n8 = this.table.header.getRenderedSortedColumn();
                    boolean bl8 = this.table.header.isAscending();
                    if (!sortable.canSort(n7, bl8)) {
                        BasicUtilities.beep();
                        return;
                    }
                    if (n8 != n7) {
                        this.table.header.setSortedColumn(n7, this.table, false);
                    } else {
                        this.table.header.setSortedColumn(n8, this.table, !bl8);
                    }
                    bl8 = this.table.header.isAscending();
                    n7 = this.table.header.getSortedColumn();
                    Sortable sortable2 = sortable;
                    synchronized (sortable2) {
                        sortable.sort(n7, bl8);
                        jTableHeader.repaint();
                    }
                }
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                this.handlePopup(mouseEvent, jComponent);
            }
        }

        private boolean handlePopup(MouseEvent mouseEvent, JComponent jComponent) {
            JPopupMenu jPopupMenu = null;
            if (mouseEvent.isPopupTrigger()) {
                try {
                    jPopupMenu = (JPopupMenu)jComponent.getClientProperty(ITable.CLIENT_JPOPUP_MENU);
                }
                catch (Throwable throwable) {
                    return false;
                }
                if (jPopupMenu != null) {
                    int n2 = this.table.rowAtPoint(mouseEvent.getPoint());
                    int[] nArray = this.table.getSelectedRows();
                    boolean bl2 = false;
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        if (nArray[i2] != n2) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        this.table.setRowSelectionInterval(n2, n2);
                    }
                    jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    private static class CellCopyAction
    extends AbstractAction {
        private ITable reference = null;

        public CellCopyAction(ITable iTable) {
            this.reference = iTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.reference != null) {
                if (!this.reference.getSelectionModel().isSelectionEmpty()) {
                    BasicUtilities.copySelectedCellsToClipBoard(this.reference);
                } else {
                    BasicUtilities.beep();
                }
            } else {
                BasicUtilities.beep();
            }
        }
    }
}

