/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.isqlviewer.util.BasicUtilities;

public class ByteArrayClob
implements Clob {
    public StringWriter clobStorage = new StringWriter();
    public StringBuffer buff = new StringBuffer("");

    public ByteArrayClob(String string) throws IOException {
        this(string.toCharArray());
    }

    public ByteArrayClob(char[] cArray) throws IOException {
        this.clobStorage.write(cArray);
        this.buff = this.clobStorage.getBuffer();
    }

    public ByteArrayClob(Reader reader) throws IOException {
        BasicUtilities.copyReader(reader, this.clobStorage);
        this.buff = this.clobStorage.getBuffer();
    }

    public long length() {
        return this.buff.length();
    }

    public String getSubString(long l2, int n2) {
        return this.buff.substring((int)l2, (int)l2 + n2);
    }

    public Reader getCharacterStream() {
        return new InputStreamReader(this.getAsciiStream());
    }

    public InputStream getAsciiStream() {
        String string = this.buff.toString();
        return new ByteArrayInputStream(string.getBytes());
    }

    public long position(String string, long l2) {
        String string2 = this.clobStorage.toString();
        return string2.indexOf(string, (int)l2);
    }

    public long position(Clob clob, long l2) {
        return 0L;
    }

    public int setString(long l2, String string) throws SQLException {
        return this.setString(l2, string, 0, string.length());
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        this.buff.insert((int)l2, string.toCharArray(), n2, n3);
        return n3;
    }

    public OutputStream setAsciiStream(long l2) {
        return new ByteArrayOutputStream();
    }

    public Writer setCharacterStream(long l2) {
        return new StringWriter();
    }

    public void truncate(long l2) throws SQLException {
        this.buff.setLength((int)l2);
    }
}

