/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.gs.digester.AbstractRulesImpl;
import org.apache.commons.gs.digester.RegexMatcher;
import org.apache.commons.gs.digester.Rule;

public class RegexRules
extends AbstractRulesImpl {
    private ArrayList registeredRules = new ArrayList();
    private RegexMatcher matcher;

    public RegexRules(RegexMatcher regexMatcher) {
        this.setRegexMatcher(regexMatcher);
    }

    public RegexMatcher getRegexMatcher() {
        return this.matcher;
    }

    public void setRegexMatcher(RegexMatcher regexMatcher) {
        if (regexMatcher == null) {
            throw new IllegalArgumentException("RegexMatcher must not be null.");
        }
        this.matcher = regexMatcher;
    }

    public void registerRule(String string, Rule rule) {
        this.registeredRules.add(new RegisteredRule(string, rule));
    }

    public void clear() {
        this.registeredRules.clear();
    }

    public List match(String string, String string2) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>(this.registeredRules.size());
        Iterator iterator = this.registeredRules.iterator();
        while (iterator.hasNext()) {
            RegisteredRule registeredRule = (RegisteredRule)iterator.next();
            if (!this.matcher.match(string2, registeredRule.pattern)) continue;
            arrayList.add(registeredRule.rule);
        }
        return arrayList;
    }

    public List rules() {
        ArrayList<Rule> arrayList = new ArrayList<Rule>(this.registeredRules.size());
        Iterator iterator = this.registeredRules.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((RegisteredRule)iterator.next()).rule);
        }
        return arrayList;
    }

    private class RegisteredRule {
        public String pattern;
        public Rule rule;

        public RegisteredRule(String string, Rule rule) {
            this.pattern = string;
            this.rule = rule;
        }
    }
}

