/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils.converters;

import java.math.BigInteger;
import org.apache.commons.gs.beanutils.ConversionException;
import org.apache.commons.gs.beanutils.Converter;

public final class BigIntegerConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public BigIntegerConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public BigIntegerConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (object instanceof BigInteger) {
            return object;
        }
        try {
            return new BigInteger(object.toString());
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(exception);
        }
    }
}

