/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._Class;

public class EnumMap_
extends TreeMap {
    private static final long serialVersionUID = 3267103726949236459L;
    private final Class keyType;

    public EnumMap_(Class keyType) {
        super(new EnumComparator());
        if (!_Class.isEnum(keyType)) {
            throw new NullPointerException();
        }
        this.keyType = keyType;
    }

    public EnumMap_(EnumMap_ map) {
        super(map);
        this.keyType = map.keyType;
    }

    public EnumMap_(Map map) {
        this(EnumMap_.getKeyType(map));
        this.putAll(map);
    }

    public Object put(Enum_ key, Object value) {
        Class<?> aClass = key.getClass();
        if (aClass != this.keyType && aClass.getSuperclass() != this.keyType) {
            throw new ClassCastException(aClass.getName());
        }
        return super.put(key, value);
    }

    public void putAll(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            this.put((Enum_)entry.getKey(), entry.getValue());
        }
    }

    public EnumMap_ clone() {
        return (EnumMap_)super.clone();
    }

    private static Class getKeyType(Map map) {
        if (map instanceof EnumMap_) {
            return ((EnumMap_)map).keyType;
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return ((Enum_)map.keySet().iterator().next()).getDeclaringClass();
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }

    public /* synthetic */ Object put(Object x0, Object x1) {
        return this.put((Enum_)x0, x1);
    }

    private static class EnumComparator
    implements Comparator,
    Serializable {
        private EnumComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Enum_) {
                return o2 instanceof Enum_ ? ((Enum_)o1).ordinal() - ((Enum_)o2).ordinal() : 1;
            }
            return o2 instanceof Enum_ ? -1 : 0;
        }
    }
}

