/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.Constants;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.LostConnectionException;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.core.exception.SpaceAlreadyStartedException;
import com.j_spaces.core.exception.SpaceAlreadyStoppedException;
import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.core.service.Service;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.ci;
import com.j_spaces.obf.df;
import com.j_spaces.obf.em;
import com.j_spaces.obf.ey;
import com.j_spaces.obf.li;
import com.j_spaces.tools.IServiceManager;
import com.j_spaces.tools.LookupServiceListener;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.FileFilterExt;
import com.j_spaces.tools.cluster.NewCluster;
import com.j_spaces.tools.cluster.view.ClusterTree;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.DynamicClusterRefreshThread;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.filters.SortFiltersDialog;
import com.j_spaces.tools.spacebrowser.BrowserLoginDialog;
import com.j_spaces.tools.spacebrowser.ButtonWithFixedTooltip;
import com.j_spaces.tools.spacebrowser.ContainerConfigPanel;
import com.j_spaces.tools.spacebrowser.ExceptionDialog;
import com.j_spaces.tools.spacebrowser.HelpAboutDialog;
import com.j_spaces.tools.spacebrowser.MenuWithIcon;
import com.j_spaces.tools.spacebrowser.NewSpaceDialog;
import com.j_spaces.tools.spacebrowser.OnLineHelpDialog;
import com.j_spaces.tools.spacebrowser.ProgressMonitorBar;
import com.j_spaces.tools.spacebrowser.SecureSpaceNode;
import com.j_spaces.tools.spacebrowser.ShowLogo;
import com.j_spaces.tools.spacebrowser.SpaceConfigPanel;
import com.j_spaces.tools.spacebrowser.SpaceRuntimePanel;
import com.j_spaces.tools.spacebrowser.SpaceTransactionsPanel;
import com.j_spaces.tools.spacebrowser.SpaceTreeNode;
import com.j_spaces.tools.spacebrowser.SpaceURLDialog;
import com.j_spaces.tools.spacebrowser.SpacesViewPanel;
import com.j_spaces.tools.spacebrowser.SrvManager;
import com.j_spaces.tools.spacebrowser.StaleContainerService;
import com.j_spaces.tools.spacebrowser.StaleServiceCleanerThread;
import com.j_spaces.tools.spacebrowser.StaleSpaceService;
import com.j_spaces.tools.spacebrowser.benchmark.BenchMarkPanel;
import com.j_spaces.tools.spacebrowser.benchmark.BenchMarkPanelFactory;
import com.j_spaces.tools.spacebrowser.statistics.ColorMap;
import com.j_spaces.tools.spacebrowser.statistics.PreferencesPanel;
import com.j_spaces.tools.spacebrowser.statistics.StatisticPanel;
import com.sun.jini.admin.DestroyAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryManager;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import net.sf.retrotranslator.runtime.java.util._Arrays;
import org.isqlviewer.ui.MainFrame;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.tools.webster.Webster;

public class SpaceBrowser
extends JFrame
implements Constants.SpaceBrowser,
Constants.LookupManager,
ActionListener {
    private static ResourceBundle resource;
    public Vector spaceEnableComp;
    public Vector containerEnableComp;
    private DefaultMutableTreeNode curSelectedNode;
    private TreePath curSelPath;
    private StaleServiceCleanerThread m_StaleServiceCleaner;
    private Hashtable m_containerMutableNode = new Hashtable();
    public Hashtable m_serviceIDtable = new Hashtable();
    public Hashtable m_proxyServiceTable = new Hashtable();
    private RestartContainerAL restartContainer = new RestartContainerAL();
    public static final String RESOURCE_DIR = "/image/browser";
    private static final String LOGO_ICON = "/image/browser/jspacesIcon.gif";
    private static final String TREE_ICONS = "tree.icons";
    private static final String TOOLBAR_ICONS = "toolbar.icons";
    private static final String TOOLBAR_TIPS = "toolbar.tips";
    private static final String FILE_MENU = "file.menu";
    private static final String FILE_MENU_ICON = "file.menu.icon";
    private static final String HELP_MENU = "help.menu";
    private static final String HELP_MENU_ICON = "help.menu.icon";
    private static final String HELP_MENU_DOCFILES = "help.menu.docfiles";
    private static final String CONTAINER_MENU = "container.menu";
    private static final String CONTAINER_MENU_ICON = "container.menu.icon";
    private static final String SPACE_MENU = "space.menu";
    private static final String CLUSTER_MENU = "cluster.menu";
    private static final String CLUSTER_MENU_ICON = "cluster.menu.icon";
    private static final String SPACE_MENU_ICON = "space.menu.icon";
    private static final String SPACE_CONFIG = "space.config";
    private static final String CONFIG_LABEL = "config.label";
    private static final String ADDRESS_LABEL = "address.label";
    private static final String ADDRESS_URL = "address.url";
    private static final String ADDRESS_TIP = "address.tip";
    private static final String WINDOW_TITLE = "window.title";
    private static final String STATUS_BAR = "statusbar.default.label";
    private static final String WINDOW_MENU = "window.menu";
    private static final String WINDOW_MENU_ICON = "window.menu.icon";
    public static final String CLASSES_LABEL = "Classes";
    public static final String TRANSACTIONS_LABEL = "Transactions";
    public static final String SQL_LABEL = "Query";
    public static final String STATISTICS_LABEL = "Statistics";
    public static final String BENCHMARK_LABEL = "Benchmark";
    public static final String USER_LABEL = "Users";
    private static final String SPACES_LABEL = "Spaces";
    public static final String CLUSTER_ROOT = "Clusters";
    private static final String SELECT = "SELECT * FROM SYSTABLES";
    private static final String QUERY_LIMIT = " WHERE rownum<1000";
    public static final String MESSAGE_OBJECT_DOES_NOT_EXIST = "Unable to inspect object. It can not be found, probably was already been removed from the space.";
    public ImageIcon QUESTION_ICON;
    public ImageIcon EXCEPTION_ICON;
    public int m_Retries = 2;
    public String localhost;
    private SpaceTreeNode selectedSpaceNode = null;
    private Hashtable statisticsPerSpace = new Hashtable();
    private SpaceBrowserMainContainer mainContainer = new SpaceBrowserMainContainer();
    public JPanel treeContainer = new JPanel();
    public JPanel mainConfigPanel = new JPanel();
    public JPanel adressContainer = new JPanel();
    public JPanel statusContainer = new JPanel();
    public JPanel toolsContainer = new JPanel();
    public NewSpaceDialog newSpaceDialog;
    public static ExceptionDialog expDialog;
    private SpaceRuntimePanel runtimePanel;
    private SpaceTransactionsPanel spaceTransactionsPanel;
    public ContainerConfigPanel containerConfigPanel;
    public SpaceConfigPanel spaceConfigPanel;
    public HelpAboutDialog helpAboutDialog;
    public OnLineHelpDialog onlineHelpDialog;
    public BrowserLoginDialog browserLoginDialog;
    private PreferencesPanel preferencesPanel;
    private SpacesViewPanel spacesViewPanel;
    private JButton createSpaceButton;
    private JButton destroySpaceButton;
    private JButton restartButton;
    private JButton shutdownButton;
    private JButton cleanButton;
    private JButton pingButton;
    private JButton refreshButton;
    private JButton helpButton;
    private JLabel adressLabel = new JLabel();
    public JLabel statusBar = new JLabel();
    private JLabel configLabel = new JLabel();
    private JLabel treeLabel = new JLabel();
    public JToolBar toolbar = new JToolBar();
    public JTextArea configText = new JTextArea();
    private JComboBox adressText = new JComboBox();
    private ComboBoxEditor addressEditor = this.adressText.getEditor();
    private JButton createSpaceUrlButton = new JButton();
    private SpaceURLDialog spaceURLDialog;
    public JTree conTree;
    private DefaultTreeModel conTreeModel;
    private BorderLayout toolsConBorderLayout = new BorderLayout();
    private BorderLayout adressConBorderLayout = new BorderLayout(2, 2);
    private BorderLayout mainConBorderLayout = new BorderLayout();
    private BorderLayout configConBorderLayout = new BorderLayout();
    private BorderLayout treeConBorderLayout = new BorderLayout();
    private BorderLayout statusConBoxLayout = new BorderLayout();
    public JMenuBar menuBar = new JMenuBar();
    private JPopupMenu popupTree = new JPopupMenu();
    private JPopupMenu gridTreePopupMenu = new JPopupMenu();
    private JPopupMenu clusterManagementPopupMenu = new JPopupMenu();
    private JMenu clusterPopupMenuItem;
    private JMenuItem newClusterPopupMenuItem;
    private JMenuItem openClusterPopupMenuItem;
    private JMenuItem verifyClusterPopupMenuItem;
    private JMenuItem viewClusterPopupMenuItem;
    private JMenu viewMenu;
    public JMenu fileMenu;
    public JMenuItem exitMenuItem;
    public JMenu containerMenu;
    public JMenuItem createMenuItem;
    public JMenuItem restartMenuItem;
    public JMenuItem shutdownMenuItem;
    public JMenuItem refreshMenuItem;
    public JMenuItem showDumpMenuItem;
    public JMenuItem createPopupMenuItem;
    public JMenuItem restartPopupMenuItem;
    public JMenuItem shutdownPopupMenuItem;
    public JMenuItem refreshPopupMenuItem;
    public JMenuItem showDumpPopupMenuItem;
    private JMenu clusterMenu;
    private JMenuItem newMenuItem;
    private JMenuItem newLikeMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem verifyMenuItem;
    private JMenuItem clusterViewMenuItem;
    private JMenuItem closeClusterMenuItem;
    private JMenuItem stopClusterMenuItem;
    private JMenuItem startClusterMenuItem;
    private JMenuItem cleanClusterMenuItem;
    private JMenuItem restartClusterMenuItem;
    private JMenuItem shutdownClusterMenuItem;
    public JMenu spaceMenu;
    public JMenuItem cleanMenuItem;
    public JMenuItem pingMenuItem;
    public JMenuItem destroyMenuItem;
    public JMenuItem restartSpaceMenuItem;
    public JMenuItem stopSpaceMenuItem;
    public JMenuItem startSpaceMenuItem;
    public JMenuItem cleanPopupMenuItem;
    public JMenuItem pingPopupMenuItem;
    public JMenuItem destroyPopupMenuItem;
    public JMenuItem restartSpacePopupMenuItem;
    public JMenuItem stopSpacePopupMenuItem;
    public JMenuItem startSpacePopupMenuItem;
    public JMenu windowMenu;
    public JMenuItem preferencesMenuItem;
    public JMenu helpMenu;
    public JMenuItem gigaApiMenuItem;
    public JMenuItem jiniApiMenuItem;
    public JMenuItem homePageMenuItem;
    public JMenuItem releaseNodeMenuItem;
    public JMenuItem aboutMenuItem;
    public NewCluster m_clusterWizardDialog;
    private ClusterViewDlg m_clusterViewDialog;
    public JFileChooser m_fileChooser;
    public IServiceManager m_srvManager;
    public boolean m_systemExit;
    private MainFrame iSQLPane;
    private EditCluster currentCluster = null;
    private JSplitPane spinPane;
    private static SpaceBrowser instance;
    private boolean isCreatedWithinAnotherGUIAppl;
    private static final String PROP_WIDTH = "WIDTH";
    private static final String PROP_HEIGHT = "HEIGHT";
    private static final String PROP_X = "X";
    private static final String PROP_Y = "Y";
    private static final String PROP_URL = "URL";
    private static final String PROP_MAX_SAVED_URL_COUNT = "MAX_SAVED_URL_COUNT";
    private static final int SAVED_URLS_COUNT = 10;
    private int curURLCount = 10;
    private static HashMap containersMap;
    private static Hashtable containerTreeNodeTable;
    private final DefaultMutableTreeNode spacesRoot = new DefaultMutableTreeNode("Spaces");
    private final DefaultMutableTreeNode clusterRoot = new DefaultMutableTreeNode("Clusters");
    private ShowDumpResultsFrame dumpResultsFrame;
    private DynamicClusterRefreshThread _dynamicClusterRefreshThread;
    private EditCluster curCluster;
    private static Logger _logger;
    private static final Map containerAdminMap;
    private LookupServiceListener sdmListener = null;
    private DiscoveryManagement ldm = null;
    private ServiceDiscoveryManager sdm = null;
    private static final String CONFIRM_MESSAGE_COMMON = "\nAre you sure you want to continue?";
    private static final String CONFIRM_MESSAGE_STOP_CLUSTER = "Cluster space members will be stopped.\nAre you sure you want to continue?";
    private static final String CONFIRM_MESSAGE_RESTART_CLUSTER = "Cluster space members will be restarted.\nAre you sure you want to continue?";
    private static final String CONFIRM_MESSAGE_CLEAN_CLUSTER = "Cluster space members will be cleaned.\nAre you sure you want to continue?";
    private static final String CONFIRM_MESSAGE_SHUTDOWN_CLUSTER = "Cluster space members will be shutdown.\nAre you sure you want to continue?";
    private static Webster websterHttpServer;
    static /* synthetic */ Class class$com$j_spaces$core$service$Service;

    private SpaceBrowser(boolean bl2) {
        this(bl2, false);
    }

    private SpaceBrowser(boolean bl2, boolean bl3) {
        SpaceBrowser.ensureSecurity();
        this.iSQLPane = new MainFrame();
        try {
            this.m_systemExit = bl2;
            this.isCreatedWithinAnotherGUIAppl = bl3;
            URL uRL = this.getClass().getResource("/image/cluster-wizard/question.gif");
            URL uRL2 = this.getClass().getResource("/image/browser/exceptionIcon.gif");
            this.QUESTION_ICON = new ImageIcon(uRL);
            this.EXCEPTION_ICON = new ImageIcon(uRL2);
            this.jbInit();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            this.setIconImage(toolkit.getImage(this.getClass().getResource(LOGO_ICON)));
            Properties properties = new Properties();
            try {
                String string = li.a() + "gsbrowser.config";
                properties.load(new FileInputStream(string));
                int n2 = Integer.parseInt((String)properties.get(PROP_X));
                int n3 = Integer.parseInt((String)properties.get(PROP_Y));
                int n4 = Integer.parseInt((String)properties.get(PROP_WIDTH));
                int n5 = Integer.parseInt((String)properties.get(PROP_HEIGHT));
                String string2 = (String)properties.get(PROP_MAX_SAVED_URL_COUNT);
                if (string2 != null) {
                    this.curURLCount = Integer.parseInt(string2);
                }
                for (int i2 = 0; i2 < this.curURLCount; ++i2) {
                    DefaultComboBoxModel defaultComboBoxModel;
                    Object object = properties.get(PROP_URL + (i2 + 1));
                    if (object == null || (defaultComboBoxModel = (DefaultComboBoxModel)this.adressText.getModel()).getIndexOf(object) != -1) continue;
                    this.adressText.addItem(object);
                }
                this.setBounds(n2, n3, n4, n5);
            }
            catch (Exception exception) {
                this.setSize(dimension.width, dimension.height - 25);
            }
            this.discoveryListenerInit();
            this.m_StaleServiceCleaner = new StaleServiceCleanerThread(this);
            new Thread(this.m_StaleServiceCleaner).start();
            this._dynamicClusterRefreshThread = new DynamicClusterRefreshThread(this);
            this._dynamicClusterRefreshThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ContainerConfig addContainerToMap(IJSpaceContainerAdmin iJSpaceContainerAdmin) throws RemoteException {
        String string;
        String string2;
        String string3;
        ContainerConfig containerConfig = (ContainerConfig)containerAdminMap.get(iJSpaceContainerAdmin);
        if (containerConfig == null) {
            containerConfig = iJSpaceContainerAdmin.getConfig();
            containerAdminMap.put(iJSpaceContainerAdmin, containerConfig);
        }
        if (!containersMap.containsKey(string3 = JSpaceUtilities.createContainerPresentName(string2 = containerConfig.containerHostName, string = containerConfig.containerName))) {
            containersMap.put(string3, containerConfig);
        }
        return containerConfig;
    }

    public static void addContainerToMap(ContainerConfig containerConfig, String string) {
        containersMap.put(string, containerConfig);
    }

    public static void removeContainerConfigFromMap(String string) {
        containersMap.remove(string);
    }

    public static void clearContainersMap() {
        containersMap.clear();
    }

    public static Hashtable cloneContainerTreeNodeTable() {
        return (Hashtable)containerTreeNodeTable.clone();
    }

    public static void addTreeNodeToContainerTreeNodeTable(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        containerTreeNodeTable.put(string, defaultMutableTreeNode);
    }

    public static DefaultMutableTreeNode removeTreeNodeFromContainerTreeNodeTable(String string) {
        return (DefaultMutableTreeNode)containerTreeNodeTable.remove(string);
    }

    public static DefaultMutableTreeNode getContainerTreeNode(String string) {
        return (DefaultMutableTreeNode)containerTreeNodeTable.get(string);
    }

    private SpaceBrowser() {
        this(true);
    }

    public static SpaceBrowser getInstance() {
        if (instance == null) {
            instance = new SpaceBrowser();
        }
        return instance;
    }

    private SpaceBrowser getBrowser() {
        return this;
    }

    public void replaceRightPanel(JComponent jComponent) {
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)jComponent, "Center");
        jComponent.validate();
        jComponent.repaint();
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    public SpaceTreeNode getSelectedSpaceNode() {
        return this.selectedSpaceNode;
    }

    private synchronized DefaultMutableTreeNode createSpaceNode(Object object, IJSpaceContainer iJSpaceContainer) {
        SpaceTreeNode spaceTreeNode = new SpaceTreeNode(object, iJSpaceContainer);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(spaceTreeNode);
        return defaultMutableTreeNode;
    }

    public void showQueryPanel(String string, SpaceTreeNode spaceTreeNode) {
        try {
            this.iSQLPane.setDBConnection(spaceTreeNode.getConnection());
            this.mainConfigPanel.removeAll();
            this.mainConfigPanel.add((Component)this.iSQLPane.getPanel(), "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            if (string.equals(SELECT)) {
                this.iSQLPane.getWorkBench().setQueryString(spaceTreeNode.toString(), string);
            } else {
                this.iSQLPane.getWorkBench().runQuery(spaceTreeNode.toString(), string + QUERY_LIMIT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MainFrame getISQLPane() {
        return this.iSQLPane;
    }

    private void discoveryListenerInit() {
        block9: {
            LookupLocator lookupLocator = null;
            try {
                this.sdmListener = new LookupServiceListener();
                this.m_srvManager = new SrvManager(this);
                this.sdmListener.addServiceManager(this.m_clusterViewDialog.getServiceManager());
                this.sdmListener.addServiceManager(this.m_srvManager);
                if (!this.isCreatedWithinAnotherGUIAppl) {
                    String string;
                    Object object;
                    String string2 = System.getProperty("com.gs.browser.unicast_discovery");
                    if (string2 != null) {
                        object = new StringTokenizer(string2, ":");
                        string = ((StringTokenizer)object).nextToken();
                        int n2 = 4160;
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                        }
                        lookupLocator = new LookupLocator(string, n2);
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("Unicast discovery on host: " + string2);
                        }
                    }
                    object = LookupDiscovery.ALL_GROUPS;
                    string = System.getProperty("com.gs.jini_lus.groups", null);
                    if (string != null) {
                        object = df.b(string);
                    }
                    LookupLocator[] lookupLocatorArray = null;
                    if (lookupLocator != null) {
                        lookupLocatorArray = new LookupLocator[]{lookupLocator};
                    }
                    this.ldm = new LookupDiscoveryManager((String[])object, lookupLocatorArray, this.sdmListener);
                    this.sdm = new ServiceDiscoveryManager(this.ldm, new LeaseRenewalManager());
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$com$j_spaces$core$service$Service;
                    if (clazz == null) {
                        clazz = class$com$j_spaces$core$service$Service = new Service[0].getClass().getComponentType();
                    }
                    classArray[0] = clazz;
                    ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
                    this.sdm.createLookupCache(serviceTemplate, null, this.sdmListener);
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) break block9;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    private void jbInit() throws Exception {
        try {
            resource = ResourceBundle.getBundle("SpaceBrowserResources");
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println();
            System.err.println("Can't find the SpaceBrowserResources.properties file that contains all resource names.");
            this.exit(1);
            throw missingResourceException;
        }
        this.adressText.setAutoscrolls(true);
        this.adressText.setFont(new Font("Dialog", 1, 12));
        this.createSpaceUrlButton.setText("...");
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setHorizontalTextPosition(2);
        this.statusContainer.setLayout(this.statusConBoxLayout);
        this.mainContainer.setLayout(this.mainConBorderLayout);
        this.toolsContainer.setLayout(this.toolsConBorderLayout);
        this.treeContainer.setLayout(this.treeConBorderLayout);
        this.mainConfigPanel.setLayout(this.configConBorderLayout);
        this.adressContainer.setLayout(this.adressConBorderLayout);
        this.toolsContainer.setBorder(BorderFactory.createEtchedBorder());
        this.configText.setBorder(BorderFactory.createEtchedBorder());
        this.statusContainer.setBorder(BorderFactory.createLoweredBevelBorder());
        this.configLabel.setPreferredSize(new Dimension(140, 27));
        this.treeLabel.setPreferredSize(new Dimension(160, 27));
        this.createDialogs();
        this.createToolbar();
        this.createMenus();
        this.initLabels();
        this.createTree();
        this.initActions();
        this.createClusterPopupMenu();
        this.createClusterManagementPopuMenu();
        this.initEnabledComponts();
        this.treeContainer.add((Component)new JScrollPane(this.conTree), "Center");
        this.treeContainer.add((Component)this.treeLabel, "North");
        Dimension dimension = new Dimension(650, 540);
        this.mainConfigPanel.setPreferredSize(dimension);
        this.toolsContainer.add((Component)this.toolbar, "Center");
        this.statusContainer.add((Component)this.statusBar, null);
        this.adressContainer.add((Component)this.adressLabel, "West");
        this.adressContainer.add((Component)this.adressText, "Center");
        this.adressContainer.add((Component)this.createSpaceUrlButton, "East");
        JComponent jComponent = this.isCreatedWithinAnotherGUIAppl ? new JScrollPane(this.mainConfigPanel) : this.mainConfigPanel;
        this.spinPane = new JSplitPane(1, this.treeContainer, jComponent);
        this.mainContainer.add((Component)this.adressContainer, "North");
        this.mainContainer.add((Component)this.spinPane, "Center");
        this.spacesViewPanel = new SpacesViewPanel(this);
        this.setEnable(this.spaceEnableComp, false);
        this.setEnable(this.containerEnableComp, false);
        if (!this.isCreatedWithinAnotherGUIAppl) {
            this.setJMenuBar(this.menuBar);
            this.getContentPane().add((Component)this.toolsContainer, "North");
            this.getContentPane().add((Component)this.statusContainer, "South");
            this.getContentPane().add((Component)this.mainContainer, "Center");
        }
    }

    private void createClusterPopupMenu() {
        String[] stringArray = SpaceBrowser.getResources(CLUSTER_MENU_ICON);
        String[] stringArray2 = SpaceBrowser.getResources(CLUSTER_MENU);
        this.clusterPopupMenuItem = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray2[0]));
        this.newClusterPopupMenuItem = new MenuWithIcon(stringArray2[1], stringArray[1]);
        this.openClusterPopupMenuItem = new MenuWithIcon(stringArray2[3], stringArray[3]);
        this.viewClusterPopupMenuItem = new MenuWithIcon("View...", stringArray[3]);
        this.verifyClusterPopupMenuItem = new MenuWithIcon(stringArray2[4], stringArray[4]);
        this.newClusterPopupMenuItem.addActionListener(this);
        this.openClusterPopupMenuItem.addActionListener(this);
        this.verifyClusterPopupMenuItem.addActionListener(this);
        this.viewClusterPopupMenuItem.addActionListener(this);
        this.gridTreePopupMenu.add(this.clusterPopupMenuItem);
        this.clusterPopupMenuItem.add(this.newClusterPopupMenuItem);
        this.clusterPopupMenuItem.add(this.openClusterPopupMenuItem);
        this.clusterPopupMenuItem.add(this.viewClusterPopupMenuItem);
        this.clusterPopupMenuItem.add(this.verifyClusterPopupMenuItem);
    }

    private void createClusterManagementPopuMenu() {
        this.startClusterMenuItem = new MenuWithIcon("Start Cluster", null);
        this.startClusterMenuItem.addActionListener(this);
        this.stopClusterMenuItem = new MenuWithIcon("Stop Cluster", null);
        this.stopClusterMenuItem.addActionListener(this);
        this.restartClusterMenuItem = new MenuWithIcon("Restart Cluster", null);
        this.restartClusterMenuItem.addActionListener(this);
        this.cleanClusterMenuItem = new MenuWithIcon("Clean Cluster", null);
        this.cleanClusterMenuItem.addActionListener(this);
        this.shutdownClusterMenuItem = new MenuWithIcon("Shutdown Cluster", null);
        this.shutdownClusterMenuItem.addActionListener(this);
        this.closeClusterMenuItem = new MenuWithIcon("Close", null);
        this.closeClusterMenuItem.addActionListener(this);
        this.clusterManagementPopupMenu.add(this.startClusterMenuItem);
        this.clusterManagementPopupMenu.add(this.stopClusterMenuItem);
        this.clusterManagementPopupMenu.add(this.restartClusterMenuItem);
        this.clusterManagementPopupMenu.add(this.cleanClusterMenuItem);
        this.clusterManagementPopupMenu.add(this.shutdownClusterMenuItem);
        this.clusterManagementPopupMenu.addSeparator();
        this.clusterManagementPopupMenu.add(this.closeClusterMenuItem);
    }

    private void initLabels() {
        this.setTitle(resource.getString(WINDOW_TITLE));
        String string = resource.getString(ADDRESS_URL) + this.getDefaultContainerName();
        this.adressText.addItem(string);
        this.adressText.setEditable(true);
        this.adressText.setToolTipText(resource.getString(ADDRESS_TIP));
        this.adressLabel.setText(" " + resource.getString(ADDRESS_LABEL));
        this.configLabel.setText(" " + resource.getString(CONFIG_LABEL));
        this.treeLabel.setText(" Grid Tree");
        this.statusBar.setText(" " + resource.getString(STATUS_BAR));
        this.statusBar = new JLabel(" " + resource.getString(STATUS_BAR), this.runtimePanel.getStopIcon(), 2);
    }

    private String getDefaultContainerName() {
        String string = null;
        string = System.getProperty("com.gs.browser.containername");
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "localhost";
            }
        }
        return string;
    }

    private void createDialogs() throws Exception {
        this.newSpaceDialog = new NewSpaceDialog(this);
        expDialog = new ExceptionDialog((Component)this, RESOURCE_DIR);
        this.runtimePanel = new SpaceRuntimePanel(this, true);
        this.containerConfigPanel = new ContainerConfigPanel(this);
        this.spaceConfigPanel = new SpaceConfigPanel(this);
        this.helpAboutDialog = new HelpAboutDialog(this);
        this.onlineHelpDialog = new OnLineHelpDialog(this);
        this.m_clusterWizardDialog = new NewCluster((Component)this);
        this.m_clusterViewDialog = new ClusterViewDlg(this);
        this.browserLoginDialog = new BrowserLoginDialog(this);
        this.preferencesPanel = new PreferencesPanel(this);
        this.spaceTransactionsPanel = new SpaceTransactionsPanel(this);
    }

    public ComboBoxModel getSchemasComboBoxModel() {
        String[] stringArray;
        Object object;
        IJSpaceContainerAdmin iJSpaceContainerAdmin = this.getCurrentContainer();
        if (iJSpaceContainerAdmin != null) {
            object = null;
            try {
                object = iJSpaceContainerAdmin.getConfig().getSpaceSchemasMap();
            }
            catch (RemoteException remoteException) {
                SpaceBrowser.showException(remoteException.toString(), remoteException);
                return new DefaultComboBoxModel<String>(Constants.Schemas.ALL_SCHEMAS_ARRAY);
            }
            Set set = object.keySet();
            stringArray = new String[set.size()];
            set.toArray(stringArray);
        } else {
            stringArray = Constants.Schemas.ALL_SCHEMAS_ARRAY;
        }
        object = new DefaultComboBoxModel<String>(stringArray);
        return object;
    }

    private void createMenus() {
        String[] stringArray = SpaceBrowser.getResources(FILE_MENU);
        String[] stringArray2 = SpaceBrowser.getResources(FILE_MENU_ICON);
        this.viewMenu = this.m_clusterViewDialog.getMenu();
        this.viewMenu.setEnabled(false);
        String[] stringArray3 = SpaceBrowser.getResources(CONTAINER_MENU);
        String[] stringArray4 = SpaceBrowser.getResources(CONTAINER_MENU_ICON);
        String[] stringArray5 = SpaceBrowser.getResources(CLUSTER_MENU);
        String[] stringArray6 = SpaceBrowser.getResources(CLUSTER_MENU_ICON);
        String[] stringArray7 = SpaceBrowser.getResources(SPACE_MENU);
        String[] stringArray8 = SpaceBrowser.getResources(SPACE_MENU_ICON);
        String[] stringArray9 = SpaceBrowser.getResources(WINDOW_MENU);
        String[] stringArray10 = SpaceBrowser.getResources(WINDOW_MENU_ICON);
        String[] stringArray11 = SpaceBrowser.getResources(HELP_MENU);
        String[] stringArray12 = SpaceBrowser.getResources(HELP_MENU_ICON);
        this.fileMenu = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray[0]));
        this.fileMenu.setMnemonic(MenuWithIcon.getMnemonics(stringArray[0]));
        this.exitMenuItem = new MenuWithIcon(stringArray[1], stringArray2[1]);
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.containerMenu = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray3[0]));
        this.containerMenu.setMnemonic(MenuWithIcon.getMnemonics(stringArray3[0]));
        this.createMenuItem = new MenuWithIcon(stringArray3[1], stringArray4[1]);
        this.restartMenuItem = new MenuWithIcon(stringArray3[2], stringArray4[2]);
        this.shutdownMenuItem = new MenuWithIcon(stringArray3[3], stringArray4[3]);
        this.refreshMenuItem = new MenuWithIcon(stringArray3[4], stringArray4[4]);
        this.showDumpMenuItem = new MenuWithIcon(stringArray3[5], stringArray4[5]);
        this.containerMenu.add(this.containerMenu);
        this.containerMenu.add(this.createMenuItem);
        this.containerMenu.add(this.restartMenuItem);
        this.containerMenu.add(this.shutdownMenuItem);
        this.containerMenu.add(this.refreshMenuItem);
        this.containerMenu.add(this.showDumpMenuItem);
        this.menuBar.add(this.containerMenu);
        this.spaceMenu = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray7[0]));
        this.spaceMenu.setMnemonic(MenuWithIcon.getMnemonics(stringArray7[0]));
        this.cleanMenuItem = new MenuWithIcon(stringArray7[1], stringArray8[1]);
        this.pingMenuItem = new MenuWithIcon(stringArray7[2], stringArray8[2]);
        this.destroyMenuItem = new MenuWithIcon(stringArray7[3], stringArray8[3]);
        this.restartSpaceMenuItem = new MenuWithIcon("&Restart", stringArray8[3]);
        this.stopSpaceMenuItem = new MenuWithIcon("S&top", stringArray8[3]);
        this.startSpaceMenuItem = new MenuWithIcon("&Start", stringArray8[3]);
        this.spaceMenu.add(this.cleanMenuItem);
        this.spaceMenu.add(this.pingMenuItem);
        this.spaceMenu.add(this.restartSpaceMenuItem);
        this.spaceMenu.add(this.destroyMenuItem);
        this.spaceMenu.addSeparator();
        this.spaceMenu.add(this.startSpaceMenuItem);
        this.spaceMenu.add(this.stopSpaceMenuItem);
        this.menuBar.add(this.spaceMenu);
        this.clusterMenu = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray5[0]));
        this.newMenuItem = new MenuWithIcon(stringArray5[1], stringArray6[1]);
        this.newLikeMenuItem = new MenuWithIcon(stringArray5[2], stringArray6[2]);
        this.openMenuItem = new MenuWithIcon(stringArray5[3], stringArray6[3]);
        this.verifyMenuItem = new MenuWithIcon(stringArray5[4], stringArray6[4]);
        this.clusterViewMenuItem = new MenuWithIcon("V&iewer...", stringArray6[3]);
        this.clusterMenu.add(this.newMenuItem);
        this.clusterMenu.add(this.newLikeMenuItem);
        this.clusterMenu.add(this.openMenuItem);
        this.clusterMenu.add(this.verifyMenuItem);
        this.clusterMenu.add(this.clusterViewMenuItem);
        this.menuBar.add(this.clusterMenu);
        this.windowMenu = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray9[0]));
        this.preferencesMenuItem = new MenuWithIcon(stringArray9[1], stringArray10[1]);
        this.windowMenu.add(this.preferencesMenuItem);
        this.menuBar.add(this.windowMenu);
        this.helpMenu = new JMenu(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray11[0]));
        this.helpMenu.setMnemonic(MenuWithIcon.getMnemonics(stringArray11[0]));
        this.releaseNodeMenuItem = new MenuWithIcon(stringArray11[1], stringArray12[1]);
        this.gigaApiMenuItem = new MenuWithIcon(stringArray11[2], stringArray12[2]);
        this.jiniApiMenuItem = new MenuWithIcon(stringArray11[3], stringArray12[3]);
        this.homePageMenuItem = new MenuWithIcon(stringArray11[4], stringArray12[4]);
        this.aboutMenuItem = new MenuWithIcon(stringArray11[5], stringArray12[5]);
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.createPopupMenuItem = new MenuWithIcon(stringArray3[1], stringArray4[1]);
        this.restartPopupMenuItem = new MenuWithIcon(stringArray3[2], stringArray4[2]);
        this.shutdownPopupMenuItem = new MenuWithIcon(stringArray3[3], stringArray4[3]);
        this.refreshPopupMenuItem = new MenuWithIcon(stringArray3[4], stringArray4[4]);
        this.showDumpPopupMenuItem = new MenuWithIcon(stringArray3[5], stringArray4[5]);
        this.cleanPopupMenuItem = new MenuWithIcon(stringArray7[1], stringArray8[1]);
        this.pingPopupMenuItem = new MenuWithIcon(stringArray7[2], stringArray8[2]);
        this.destroyPopupMenuItem = new MenuWithIcon(stringArray7[3], stringArray8[3]);
        this.restartSpacePopupMenuItem = new MenuWithIcon("&Restart", stringArray8[3]);
        this.stopSpacePopupMenuItem = new MenuWithIcon("S&top", stringArray8[3]);
        this.startSpacePopupMenuItem = new MenuWithIcon("&Start", stringArray8[3]);
        this.popupTree.add(this.createPopupMenuItem);
        this.popupTree.addSeparator();
        this.popupTree.add(this.restartPopupMenuItem);
        this.popupTree.add(this.shutdownPopupMenuItem);
        this.popupTree.add(this.refreshPopupMenuItem);
        this.popupTree.addSeparator();
        this.popupTree.add(this.cleanPopupMenuItem);
        this.popupTree.add(this.pingPopupMenuItem);
        this.popupTree.add(this.restartSpacePopupMenuItem);
        this.popupTree.add(this.destroyPopupMenuItem);
        this.popupTree.addSeparator();
        this.popupTree.add(this.startSpacePopupMenuItem);
        this.popupTree.add(this.stopSpacePopupMenuItem);
        this.popupTree.addSeparator();
        this.popupTree.add(this.showDumpPopupMenuItem);
    }

    private void createToolbar() {
        String[] stringArray = SpaceBrowser.getResources(TOOLBAR_TIPS);
        String[] stringArray2 = SpaceBrowser.getResources(TOOLBAR_ICONS);
        this.toolbar.setFloatable(true);
        this.createSpaceButton = new ButtonWithFixedTooltip(stringArray2[0], stringArray[0]);
        this.destroySpaceButton = new ButtonWithFixedTooltip(stringArray2[1], stringArray[1]);
        this.restartButton = new ButtonWithFixedTooltip(stringArray2[2], stringArray[2]);
        this.shutdownButton = new ButtonWithFixedTooltip(stringArray2[3], stringArray[3]);
        this.cleanButton = new ButtonWithFixedTooltip(stringArray2[4], stringArray[4]);
        this.pingButton = new ButtonWithFixedTooltip(stringArray2[5], stringArray[5]);
        this.refreshButton = new ButtonWithFixedTooltip(stringArray2[6], stringArray[6]);
        this.helpButton = new ButtonWithFixedTooltip(stringArray2[7], stringArray[7]);
        this.toolbar.add(this.createSpaceButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.restartButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.shutdownButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.refreshButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.pingButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.cleanButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.destroySpaceButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.helpButton);
        this.toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    private void createTree() {
        String[] stringArray = SpaceBrowser.getResources(SPACE_CONFIG);
        try {
            this.localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.localhost = "localhost";
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Hidden Root");
        this.conTree = new JTree(defaultMutableTreeNode);
        this.conTree.setRootVisible(false);
        this.conTreeModel = (DefaultTreeModel)this.conTree.getModel();
        this.conTreeModel.insertNodeInto(this.spacesRoot, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.conTreeModel.insertNodeInto(this.clusterRoot, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.conTreeModel.reload();
        this.conTree.setCellRenderer(new TreeRenderer());
        this.conTree.setAutoscrolls(true);
    }

    private void doSave(OutputStream outputStream, String string) {
        Properties properties = ColorMap.instance().getProperties();
        properties.put(PROP_X, String.valueOf(this.getX()));
        properties.put(PROP_Y, String.valueOf(this.getY()));
        properties.put(PROP_WIDTH, String.valueOf(this.getWidth()));
        properties.put(PROP_HEIGHT, String.valueOf(this.getHeight()));
        properties.put(PROP_MAX_SAVED_URL_COUNT, String.valueOf(this.curURLCount));
        ComboBoxModel comboBoxModel = this.adressText.getModel();
        int n2 = comboBoxModel.getSize();
        if (n2 > this.curURLCount) {
            n2 = this.curURLCount;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = (String)comboBoxModel.getElementAt(i2);
            properties.put(PROP_URL + (i2 + 1), string2);
        }
        try {
            properties.store(outputStream, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void initActions() {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                SpaceBrowser.this.onClose();
            }
        });
        CreateSpaceAL createSpaceAL = new CreateSpaceAL();
        this.createMenuItem.addActionListener(createSpaceAL);
        this.createPopupMenuItem.addActionListener(createSpaceAL);
        this.restartContainer = new RestartContainerAL();
        this.restartMenuItem.addActionListener(this.restartContainer);
        this.restartPopupMenuItem.addActionListener(this.restartContainer);
        ShutdownContainerAL shutdownContainerAL = new ShutdownContainerAL();
        this.shutdownMenuItem.addActionListener(shutdownContainerAL);
        this.shutdownPopupMenuItem.addActionListener(shutdownContainerAL);
        CleanSpaceAL cleanSpaceAL = new CleanSpaceAL();
        this.cleanMenuItem.addActionListener(cleanSpaceAL);
        this.cleanPopupMenuItem.addActionListener(cleanSpaceAL);
        PingSpaceAL pingSpaceAL = new PingSpaceAL();
        this.pingMenuItem.addActionListener(pingSpaceAL);
        this.pingPopupMenuItem.addActionListener(pingSpaceAL);
        DestroySpaceAL destroySpaceAL = new DestroySpaceAL();
        this.destroyMenuItem.addActionListener(destroySpaceAL);
        this.destroyPopupMenuItem.addActionListener(destroySpaceAL);
        RefreshContainerAL refreshContainerAL = new RefreshContainerAL();
        this.refreshMenuItem.addActionListener(refreshContainerAL);
        this.refreshPopupMenuItem.addActionListener(refreshContainerAL);
        ShowContainerDumpAction showContainerDumpAction = new ShowContainerDumpAction();
        this.showDumpMenuItem.addActionListener(showContainerDumpAction);
        this.showDumpPopupMenuItem.addActionListener(showContainerDumpAction);
        RestartSpaceAL restartSpaceAL = new RestartSpaceAL(this);
        this.restartSpaceMenuItem.addActionListener(restartSpaceAL);
        this.restartSpacePopupMenuItem.addActionListener(restartSpaceAL);
        StartSpaceAL startSpaceAL = new StartSpaceAL(this);
        this.startSpaceMenuItem.addActionListener(startSpaceAL);
        this.startSpacePopupMenuItem.addActionListener(startSpaceAL);
        StopSpaceAL stopSpaceAL = new StopSpaceAL(this);
        this.stopSpaceMenuItem.addActionListener(stopSpaceAL);
        this.stopSpacePopupMenuItem.addActionListener(stopSpaceAL);
        if (!this.isCreatedWithinAnotherGUIAppl) {
            this.createCommonActions();
            this.createSpaceButton.addActionListener(createSpaceAL);
            this.restartButton.addActionListener(this.restartContainer);
            this.shutdownButton.addActionListener(shutdownContainerAL);
            this.cleanButton.addActionListener(cleanSpaceAL);
            this.pingButton.addActionListener(pingSpaceAL);
            this.destroySpaceButton.addActionListener(destroySpaceAL);
            this.refreshButton.addActionListener(refreshContainerAL);
        }
        this.newLikeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    File file = SpaceBrowser.this.chooseFile();
                    if (file == null) {
                        return;
                    }
                    Hashtable hashtable = SpaceBrowser.this.getBrowserInfo();
                    SpaceBrowser.this.m_clusterWizardDialog.createEditInfo(file.getPath(), false, hashtable.size() > 0 ? hashtable : null);
                    SpaceBrowser.this.m_clusterWizardDialog.showClusterDialog();
                }
                catch (Exception exception) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, exception.toString(), exception);
                    }
                    JOptionPane.showConfirmDialog(SpaceBrowser.this, exception.getClass().getName() + " " + exception.getMessage(), "Error", -1, 0, SpaceBrowser.this.EXCEPTION_ICON);
                }
            }
        });
        this.openMenuItem.addActionListener(this);
        this.newMenuItem.addActionListener(this);
        this.verifyMenuItem.addActionListener(this);
        this.clusterViewMenuItem.addActionListener(this);
        this.addressEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)SpaceBrowser.this.addressEditor.getItem();
                ProgressThread progressThread = new ProgressThread();
                try {
                    progressThread.setURL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    expDialog.showException("Wrong space URL", malformedURLException);
                    return;
                }
                progressThread.start();
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)SpaceBrowser.this.adressText.getModel();
                if (defaultComboBoxModel.getIndexOf(string) == -1) {
                    SpaceBrowser.this.adressText.insertItemAt(string, 0);
                }
                SpaceBrowser.this.adressText.setSelectedItem(string);
            }
        });
        this.createSpaceUrlButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (SpaceBrowser.this.spaceURLDialog == null) {
                    try {
                        SpaceBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
                        SpaceBrowser.this.spaceURLDialog = new SpaceURLDialog(SpaceBrowser.this, "Space URL Builder", true);
                    }
                    finally {
                        SpaceBrowser.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                SpaceBrowser.this.spaceURLDialog.setUrl(SpaceBrowser.this.addressEditor.getItem().toString());
                SpaceBrowser.this.spaceURLDialog.setVisible(true);
                if (SpaceBrowser.this.spaceURLDialog.isPressedOK()) {
                    SpaceBrowser.this.addressEditor.setItem(SpaceBrowser.this.spaceURLDialog.getUrl());
                }
            }
        });
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceBrowser.this.preferencesPanel.setVisible(true);
            }
        });
        this.conTree.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent keyEvent) {
                int n2 = keyEvent.getKeyCode();
                if (n2 == 40 || n2 == 38 || n2 == 34 || n2 == 33) {
                    try {
                        SpaceBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
                        Toolkit.getDefaultToolkit().sync();
                        SpaceBrowser.this.doNodeSelected(SpaceBrowser.this.conTree.getSelectionPath());
                    }
                    finally {
                        SpaceBrowser.this.setCursor(new Cursor(0));
                    }
                }
            }
        });
        this.conTree.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = SpaceBrowser.this.conTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                try {
                    SpaceBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
                    SpaceBrowser.this.conTree.setSelectionPath(treePath);
                    SpaceBrowser.this.doNodeSelected(SpaceBrowser.this.conTree.getSelectionPath());
                }
                finally {
                    SpaceBrowser.this.setCursor(new Cursor(0));
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (treePath != null) {
                        Object object;
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPath()[treePath.getPath().length - 1];
                        Object object2 = defaultMutableTreeNode.getUserObject();
                        Object object3 = null;
                        Object object4 = null;
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                        if (defaultMutableTreeNode2 != null) {
                            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                            object3 = defaultMutableTreeNode2.getUserObject();
                        }
                        if (defaultMutableTreeNode3 != null) {
                            object4 = defaultMutableTreeNode3.getUserObject();
                        }
                        if (object2 instanceof JSpaceProxyWrapper) {
                            object = (JSpaceProxyWrapper)object2;
                            object2 = ((JSpaceProxyWrapper)object).proxy();
                        }
                        if (object2 instanceof SecureSpaceNode || object2 instanceof StaleSpaceService || object2 instanceof StaleContainerService) {
                            SpaceBrowser.this.setSelectedTreeNode(null);
                        } else {
                            SpaceBrowser.this.setSelectedTreeNode(defaultMutableTreeNode);
                            if (object2 instanceof IJSpaceContainer) {
                                SpaceBrowser.this.setEnable(SpaceBrowser.this.spaceEnableComp, false);
                                SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, true);
                            } else if (object2 instanceof IJSpace) {
                                SpaceBrowser.this.setEnableSpaceControls((IJSpace)object2);
                                SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, false);
                            } else if (defaultMutableTreeNode2 != null) {
                                object = defaultMutableTreeNode2.getUserObject();
                                if (object2 instanceof SpaceRuntimeInfo && !(object instanceof SecureSpaceNode)) {
                                    SpaceBrowser.this.setEnable(SpaceBrowser.this.spaceEnableComp, false);
                                    SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, false);
                                }
                            }
                        }
                        if (defaultMutableTreeNode.equals(SpaceBrowser.this.clusterRoot)) {
                            SpaceBrowser.this.gridTreePopupMenu.show(SpaceBrowser.this.conTree, mouseEvent.getX(), mouseEvent.getY());
                        } else if (object2 instanceof EditCluster) {
                            SpaceBrowser.this.handleClusterMenuState();
                            SpaceBrowser.this.clusterManagementPopupMenu.show(SpaceBrowser.this.conTree, mouseEvent.getX(), mouseEvent.getY());
                        } else if (!(object2 instanceof SpaceRuntimeInfo || object2.equals(SpaceBrowser.TRANSACTIONS_LABEL) || object2.equals(SpaceBrowser.SQL_LABEL) || object2.equals(SpaceBrowser.STATISTICS_LABEL) || object2.equals(SpaceBrowser.USER_LABEL) || object2.equals(SpaceBrowser.SPACES_LABEL) || object2.equals(SpaceBrowser.BENCHMARK_LABEL) || object3 instanceof EditCluster || object4 instanceof EditCluster || defaultMutableTreeNode.equals(SpaceBrowser.this.clusterRoot))) {
                            SpaceBrowser.this.popupTree.show(SpaceBrowser.this.conTree, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else {
                        SpaceBrowser.this.conTree.clearSelection();
                    }
                }
            }
        });
    }

    private void handleClusterMenuState() {
        ClusterMemberInfo[] clusterMemberInfoArray = this.currentCluster.getClusterMembers();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < clusterMemberInfoArray.length; ++i2) {
            ClusterMemberInfo clusterMemberInfo;
            String string = clusterMemberInfo.memberName;
            clusterMemberInfo = clusterMemberInfoArray[i2];
            boolean bl4 = clusterMemberInfo.isMirror();
            String string2 = ServiceManagerImpl.getMemberStatus(string, bl4);
            if ((string2.equals("Alive") || string2.equals("MirrorAlive")) && !bl2) {
                bl2 = true;
                if (bl3) break;
            }
            if (!string2.equals("Unreachable") && !string2.equals("MirrorUnreachable") || bl3) continue;
            bl3 = true;
            if (bl2) break;
        }
        this.startClusterMenuItem.setEnabled(bl3);
        this.stopClusterMenuItem.setEnabled(bl2);
        this.restartClusterMenuItem.setEnabled(bl2);
        this.shutdownClusterMenuItem.setEnabled(bl2);
        this.cleanClusterMenuItem.setEnabled(bl2);
    }

    private void onClose() {
        try {
            String string = li.a() + "gsbrowser.config";
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.doSave(fileOutputStream, "Frame Bounds");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.exit(0);
    }

    private void createCommonActions() {
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceBrowser.this.onClose();
            }
        });
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceBrowser.this.helpAboutDialog.setVisible(true);
            }
        });
        HelpAL helpAL = new HelpAL();
        this.helpButton.addActionListener(helpAL);
        this.gigaApiMenuItem.addActionListener(helpAL);
        this.jiniApiMenuItem.addActionListener(helpAL);
        this.homePageMenuItem.addActionListener(helpAL);
        this.releaseNodeMenuItem.addActionListener(helpAL);
    }

    private IJSpaceContainerAdmin getCurrentContainer() {
        if (this.spacesRoot.getChildCount() == 0) {
            return null;
        }
        Object object = null;
        TreePath treePath = this.conTree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPath()[treePath.getPath().length - 1];
            object = defaultMutableTreeNode.getUserObject();
            if (object == null || object.equals(SPACES_LABEL) || object.equals(CLUSTER_ROOT)) {
                return null;
            }
            if (object instanceof JSpaceProxyWrapper) {
                object = ((JSpaceProxyWrapper)object).proxy();
            }
            while (!(object instanceof IJSpaceContainerAdmin) && object != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                if (defaultMutableTreeNode2 != null) {
                    object = defaultMutableTreeNode2.getUserObject();
                    if (object instanceof JSpaceProxyWrapper) {
                        object = ((JSpaceProxyWrapper)object).proxy();
                    }
                } else {
                    object = null;
                }
                defaultMutableTreeNode = defaultMutableTreeNode2;
            }
        }
        return (IJSpaceContainerAdmin)object;
    }

    public void doNodeSelected(TreePath treePath) {
        Object object;
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPath()[treePath.getPath().length - 1];
        if (defaultMutableTreeNode.equals(this.curSelectedNode)) {
            return;
        }
        this.curCluster = null;
        this.curSelectedNode = defaultMutableTreeNode;
        this.curSelPath = treePath;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        this.viewMenu.setEnabled(false);
        this.runtimePanel.setControlEnabled(false);
        Object object3 = null;
        if (defaultMutableTreeNode2 != null) {
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
            object3 = defaultMutableTreeNode2.getUserObject();
            if (object3 instanceof SecureSpaceNode) {
                this.setSelectedTreeNode(defaultMutableTreeNode3, true, false);
                return;
            }
        }
        if (!((object2 = defaultMutableTreeNode.getUserObject()) instanceof IJSpaceContainerAdmin) && !(object2 instanceof IJSpace)) {
            this.setEnable(this.spaceEnableComp, false);
            this.setEnable(this.containerEnableComp, false);
        }
        if (object2.equals(SQL_LABEL)) {
            object = (SpaceTreeNode)object3;
            this.selectedSpaceNode = (SpaceTreeNode)object3;
            this.showQueryPanel(SELECT, (SpaceTreeNode)object);
            this.currentCluster = null;
        }
        if (object2.equals(TRANSACTIONS_LABEL)) {
            object = (SpaceTreeNode)object3;
            this.selectedSpaceNode = (SpaceTreeNode)object3;
            this.mainConfigPanel.removeAll();
            this.mainConfigPanel.add((Component)this.spaceTransactionsPanel, "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            IJSpace iJSpace = (IJSpace)((JSpaceProxyWrapper)defaultMutableTreeNode2.getUserObject()).proxy();
            this.spaceTransactionsPanel.setSpace(iJSpace);
            this.currentCluster = null;
        } else if (defaultMutableTreeNode.equals(this.clusterRoot)) {
            this.clearRightSplitPanel();
            this.setEnable(this.spaceEnableComp, false);
            this.setEnable(this.containerEnableComp, false);
        } else if (defaultMutableTreeNode.equals(this.spacesRoot)) {
            this.mainConfigPanel.removeAll();
            this.mainConfigPanel.add((Component)this.spacesViewPanel, "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            this.currentCluster = null;
        } else if (object2.equals(STATISTICS_LABEL)) {
            try {
                this.selectedSpaceNode = (SpaceTreeNode)object3;
                this.mainConfigPanel.removeAll();
                object = (StatisticPanel)this.statisticsPerSpace.get(this.selectedSpaceNode.getSpaceObjectID());
                if (object == null) {
                    object = new StatisticPanel(this.getBrowser());
                    this.statisticsPerSpace.put(this.selectedSpaceNode.getSpaceObjectID(), object);
                }
                this.mainConfigPanel.add((Component)object, "Center");
                this.mainConfigPanel.validate();
                this.mainConfigPanel.repaint();
                this.currentCluster = null;
            }
            catch (Exception exception) {}
        } else if (object2.equals(USER_LABEL)) {
            try {
                this.selectedSpaceNode = (SpaceTreeNode)object3;
                object = (JSpaceProxyWrapper)defaultMutableTreeNode3.getUserObject();
                ContainerConfig containerConfig = ((IJSpaceContainerAdmin)((JSpaceProxyWrapper)object).proxy()).getConfig();
                SortFiltersDialog sortFiltersDialog = this.spaceConfigPanel.advancedPanel.getFiltersDialog();
                sortFiltersDialog.setAdminAccount(new GenericPrincipal(containerConfig.adminName, containerConfig.adminPassword));
                String string = ((JSpaceProxyWrapper)defaultMutableTreeNode3.getUserObject()).getProxyName();
                this.spaceConfigPanel.updateDialog(string, (IJSpace)((JSpaceProxyWrapper)object3).proxy(), false);
                this.spaceConfigPanel.updateDialog(string, (IJSpace)((JSpaceProxyWrapper)object3).proxy());
                sortFiltersDialog.setCurContainerName(string);
                if (!sortFiltersDialog.editDefaultSecurityFilter((JSpaceProxyWrapper)object)) {
                    this.returnToSpacePanel(string, defaultMutableTreeNode3, defaultMutableTreeNode2, treePath);
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.currentCluster = null;
        } else if (object2.equals(BENCHMARK_LABEL)) {
            this.selectedSpaceNode = (SpaceTreeNode)object3;
            this.mainConfigPanel.removeAll();
            object = (JSpaceProxyWrapper)defaultMutableTreeNode3.getUserObject();
            JSpaceProxyWrapper jSpaceProxyWrapper = (JSpaceProxyWrapper)defaultMutableTreeNode3.getUserObject();
            IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)jSpaceProxyWrapper.proxy();
            BenchMarkPanel benchMarkPanel = BenchMarkPanelFactory.instance().getPanel(this.getBrowser(), (JSpaceProxyWrapper)object, iJSpaceContainerAdmin);
            this.mainConfigPanel.add((Component)benchMarkPanel, "Center");
            this.mainConfigPanel.validate();
            this.mainConfigPanel.repaint();
            this.currentCluster = null;
        } else {
            if (object2 instanceof SecureSpaceNode) {
                this.browserLoginDialog.showDialog(defaultMutableTreeNode);
                this.currentCluster = null;
                return;
            }
            if (object2 instanceof EditCluster) {
                this.curCluster = object = (EditCluster)object2;
                this.showClusterPanel((EditCluster)object, false);
                this.viewMenu.setEnabled(true);
                String string = ((EditCluster)object).getClusterName();
                this.m_clusterViewDialog.getClusterTree(string).showHighLevelNode(defaultMutableTreeNode, null);
                this.mainConfigPanel.validate();
                this.mainConfigPanel.repaint();
                return;
            }
            if (object3 instanceof EditCluster) {
                try {
                    this.curCluster = object = (EditCluster)object3;
                    this.showClusterPanel((EditCluster)object, false);
                    String string = this.curCluster.getClusterName();
                    this.m_clusterViewDialog.getClusterTree(string).performNodeAction(treePath);
                    this.viewMenu.setEnabled(true);
                    this.mainConfigPanel.validate();
                    this.mainConfigPanel.repaint();
                }
                catch (Exception exception) {
                    SpaceBrowser.showException(exception.toString(), exception);
                }
                return;
            }
            if (defaultMutableTreeNode3 != null && defaultMutableTreeNode3.getUserObject() instanceof EditCluster) {
                try {
                    object = (EditCluster)defaultMutableTreeNode3.getUserObject();
                    if (this.currentCluster == null || this.currentCluster != object) {
                        this.showClusterPanel((EditCluster)object, true);
                    }
                    this.curCluster = object;
                    String string = ((EditCluster)object).getClusterName();
                    this.m_clusterViewDialog.getClusterTree(string).performNodeAction(treePath);
                    this.viewMenu.setEnabled(true);
                    this.mainConfigPanel.validate();
                    this.mainConfigPanel.repaint();
                }
                catch (Exception exception) {
                    SpaceBrowser.showException(exception.toString(), exception);
                }
                return;
            }
        }
        if (object2 instanceof SpaceRuntimeInfo && object3 instanceof SecureSpaceNode) {
            this.browserLoginDialog.showDialog((DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
            this.currentCluster = null;
            return;
        }
        if (object2 instanceof JSpaceProxyWrapper) {
            object = (JSpaceProxyWrapper)object2;
            object2 = ((JSpaceProxyWrapper)object).proxy();
            this.currentCluster = null;
        }
        if (object2 instanceof StaleSpaceService || object2 instanceof StaleContainerService) {
            this.setSelectedTreeNode(null);
            this.currentCluster = null;
            return;
        }
        this.setSelectedTreeNode(defaultMutableTreeNode);
        if (object2 instanceof IJSpaceContainerAdmin) {
            try {
                this.updateContainerConfig((IJSpaceContainerAdmin)object2);
            }
            catch (LostConnectionException lostConnectionException) {
                this.removeContainerTree(defaultMutableTreeNode, false);
            }
        } else if (object2 instanceof IJSpace) {
            try {
                this.updateSpaceConfig(defaultMutableTreeNode.getParent().toString(), (IJSpace)object2);
            }
            catch (LostConnectionException lostConnectionException) {
                this.removeSpaceNode(defaultMutableTreeNode);
            }
        } else {
            if (defaultMutableTreeNode.getParent() == null) {
                return;
            }
            object = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            if (object instanceof StaleContainerService || object instanceof StaleSpaceService) {
                this.setSelectedTreeNode(null);
                return;
            }
            if (object2 instanceof SpaceRuntimeInfo) {
                this.selectedSpaceNode = (SpaceTreeNode)object3;
                this.showRuntimePanel();
            }
            this.currentCluster = null;
        }
    }

    private void clearRightSplitPanel() {
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    private void returnToSpacePanel(String string, DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, TreePath treePath) {
        this.setSelectedTreeNode(defaultMutableTreeNode);
        this.conTree.setSelectionPath(treePath.getParentPath());
        Object object = defaultMutableTreeNode2.getUserObject();
        if (object instanceof JSpaceProxyWrapper) {
            this.updateSpaceConfig(string, (IJSpace)((JSpaceProxyWrapper)object).proxy());
        } else if (object instanceof SecureSpaceNode) {
            this.updateSpaceConfig(string, ((SecureSpaceNode)object).getSpaceProxy());
        }
    }

    public File chooseFile() {
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(li.a() + File.separatorChar + "config");
            FileFilterExt fileFilterExt = new FileFilterExt("xml", "Cluster XML file");
            this.m_fileChooser.addChoosableFileFilter(fileFilterExt);
        }
        int n2 = this.m_fileChooser.showOpenDialog(this);
        File file = this.m_fileChooser.getSelectedFile();
        if (file == null || n2 != 0) {
            return null;
        }
        return file;
    }

    private Hashtable getBrowserInfo() {
        Hashtable hashtable = SpaceBrowser.cloneContainerTreeNodeTable();
        Hashtable<String, String[]> hashtable2 = new Hashtable<String, String[]>();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)hashtable.get(string);
                if (!(defaultMutableTreeNode.getUserObject() instanceof JSpaceProxyWrapper)) continue;
                IJSpaceContainer iJSpaceContainer = (IJSpaceContainer)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
                String[] stringArray = iJSpaceContainer.getSpaceNames();
                hashtable2.put(defaultMutableTreeNode.toString(), stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable2;
    }

    private void initEnabledComponts() {
        this.spaceEnableComp = new Vector();
        this.containerEnableComp = new Vector();
        this.spaceEnableComp.add(this.cleanButton);
        this.spaceEnableComp.add(this.pingButton);
        this.spaceEnableComp.add(this.cleanMenuItem);
        this.spaceEnableComp.add(this.pingMenuItem);
        this.spaceEnableComp.add(this.cleanPopupMenuItem);
        this.spaceEnableComp.add(this.pingPopupMenuItem);
        this.spaceEnableComp.add(this.destroySpaceButton);
        this.spaceEnableComp.add(this.destroyMenuItem);
        this.spaceEnableComp.add(this.destroyPopupMenuItem);
        this.spaceEnableComp.add(this.restartSpaceMenuItem);
        this.spaceEnableComp.add(this.restartSpacePopupMenuItem);
        this.spaceEnableComp.add(this.startSpaceMenuItem);
        this.spaceEnableComp.add(this.startSpacePopupMenuItem);
        this.spaceEnableComp.add(this.stopSpaceMenuItem);
        this.spaceEnableComp.add(this.stopSpacePopupMenuItem);
        this.containerEnableComp.add(this.createSpaceButton);
        this.containerEnableComp.add(this.restartButton);
        this.containerEnableComp.add(this.shutdownButton);
        this.containerEnableComp.add(this.createMenuItem);
        this.containerEnableComp.add(this.restartMenuItem);
        this.containerEnableComp.add(this.shutdownMenuItem);
        this.containerEnableComp.add(this.createPopupMenuItem);
        this.containerEnableComp.add(this.restartPopupMenuItem);
        this.containerEnableComp.add(this.shutdownPopupMenuItem);
        this.containerEnableComp.add(this.refreshButton);
        this.containerEnableComp.add(this.refreshMenuItem);
        this.containerEnableComp.add(this.refreshPopupMenuItem);
        this.containerEnableComp.add(this.showDumpMenuItem);
        this.containerEnableComp.add(this.showDumpPopupMenuItem);
    }

    public void showRuntimePanel() {
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin;
        this.setEnable(this.spaceEnableComp, false);
        this.setEnable(this.containerEnableComp, false);
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.runtimePanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getSelectedTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        IJSpace iJSpace = (IJSpace)((JSpaceProxyWrapper)defaultMutableTreeNode2.getUserObject()).proxy();
        ServiceID serviceID = null;
        try {
            iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
            if (defaultMutableTreeNode2.getUserObject() instanceof JSpaceProxyWrapper) {
                serviceID = ((JSpaceProxyWrapper)defaultMutableTreeNode2.getUserObject()).getServiceID();
            } else if (defaultMutableTreeNode2.getUserObject() instanceof SecureSpaceNode) {
                serviceID = ((SecureSpaceNode)defaultMutableTreeNode2.getUserObject()).getServiceID();
            }
        }
        catch (RemoteException remoteException) {
            expDialog.showException("getting runtime info from space", remoteException);
            return;
        }
        this.runtimePanel.setSpaceAdmin(iRemoteJSpaceAdmin, serviceID);
    }

    public void updateContainerConfig(IJSpaceContainerAdmin iJSpaceContainerAdmin) {
        this.setEnable(this.spaceEnableComp, false);
        this.setEnable(this.containerEnableComp, iJSpaceContainerAdmin != null);
        if (iJSpaceContainerAdmin != null) {
            this.containerConfigPanel.updateConfig(iJSpaceContainerAdmin);
        } else {
            this.containerConfigPanel.cleanup();
        }
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.containerConfigPanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    public void updateSpaceConfig(String string, IJSpace iJSpace) {
        this.setEnableSpaceControls(iJSpace);
        this.setEnable(this.containerEnableComp, false);
        if (iJSpace != null) {
            this.spaceConfigPanel.updateDialog(string, iJSpace);
        } else {
            this.spaceConfigPanel.cleanup();
        }
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.add((Component)this.spaceConfigPanel, "Center");
        this.mainConfigPanel.validate();
        this.mainConfigPanel.repaint();
    }

    public boolean isProxyExists(Object object) {
        return this.m_proxyServiceTable.containsKey(object);
    }

    public void addContainerTree(IJSpaceContainer iJSpaceContainer, ServiceID serviceID, boolean bl2) {
        this.addContainerTree(iJSpaceContainer, serviceID, false, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addContainerTree(IJSpaceContainer iJSpaceContainer, ServiceID serviceID, boolean bl2, boolean bl3) {
        String[] stringArray = null;
        DefaultTreeModel defaultTreeModel = this.conTreeModel;
        synchronized (defaultTreeModel) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("> Add container");
            }
            if (this.m_proxyServiceTable.containsKey(iJSpaceContainer)) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_proxyServiceTable.get(iJSpaceContainer);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("addContainerTree: This container already exists: " + iJSpaceContainer.getName() + " serviceID: " + serviceID);
                    }
                    if (serviceID != null) {
                        this.m_serviceIDtable.put(serviceID, defaultMutableTreeNode);
                        this.m_containerMutableNode.put(defaultMutableTreeNode, serviceID);
                        return;
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("add space nodes 1");
                    }
                    this.addSpaceNodes(this.conTreeModel, defaultMutableTreeNode, iJSpaceContainer, bl2, bl3);
                    if (this.runtimePanel.isStop()) {
                        this.containerConfigPanel.updateConfig((IJSpaceContainerAdmin)((Object)iJSpaceContainer));
                    }
                    if (!bl3) return;
                    this.setSelectedTreeNode(defaultMutableTreeNode, true, true);
                    this.setEnable(this.spaceEnableComp, false);
                    this.setEnable(this.containerEnableComp, true);
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.FINE)) return;
                    _logger.log(Level.FINE, exception.toString(), exception);
                }
                return;
            }
        }
        for (int i2 = 0; i2 < this.m_Retries; ++i2) {
            try {
                iJSpaceContainer.ping();
                continue;
            }
            catch (Exception exception) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("addContainerTree() " + exception.getMessage() + " TTL: " + i2);
                }
                if (i2 != this.m_Retries - 1) continue;
                return;
            }
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new JSpaceProxyWrapper(iJSpaceContainer));
        try {
            Object[] objectArray = this.conTreeModel;
            synchronized (this.conTreeModel) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                boolean bl4 = false;
                if (this.spacesRoot.getChildCount() == 0) {
                    stringArray = this.addSpaceNodes(this.conTreeModel, defaultMutableTreeNode, iJSpaceContainer, bl2, bl3);
                    SpaceBrowser.addTreeNodeToContainerTreeNodeTable(defaultMutableTreeNode, defaultMutableTreeNode.toString());
                    this.conTreeModel.insertNodeInto(defaultMutableTreeNode, this.spacesRoot, this.spacesRoot.getChildCount());
                    this.m_proxyServiceTable.put(iJSpaceContainer, defaultMutableTreeNode);
                } else {
                    for (int i3 = 0; i3 < this.spacesRoot.getChildCount(); ++i3) {
                        defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.spacesRoot.getChildAt(i3);
                        if (defaultMutableTreeNode2.getUserObject() instanceof StaleContainerService || !defaultMutableTreeNode.toString().equals(defaultMutableTreeNode2.toString()) || !iJSpaceContainer.equals(((JSpaceProxyWrapper)defaultMutableTreeNode2.getUserObject()).proxy())) continue;
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                        if (!this.m_proxyServiceTable.containsKey(iJSpaceContainer)) {
                            this.m_proxyServiceTable.put(iJSpaceContainer, defaultMutableTreeNode);
                            stringArray = this.addSpaceNodes(this.conTreeModel, defaultMutableTreeNode2, iJSpaceContainer, bl2, bl3);
                        }
                        bl4 = true;
                        break;
                    }
                    if (!bl4) {
                        stringArray = this.addSpaceNodes(this.conTreeModel, defaultMutableTreeNode, iJSpaceContainer, bl2, bl3);
                        SpaceBrowser.addTreeNodeToContainerTreeNodeTable(defaultMutableTreeNode, defaultMutableTreeNode.toString());
                        this.m_proxyServiceTable.put(iJSpaceContainer, defaultMutableTreeNode);
                        this.conTreeModel.insertNodeInto(defaultMutableTreeNode, this.spacesRoot, this.spacesRoot.getChildCount());
                    }
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Debug: containerTree=" + defaultMutableTreeNode + " spaceNames=" + stringArray);
                }
                if (stringArray == null) {
                    this.showStatus(defaultMutableTreeNode + " container loaded empty.");
                }
                // ** MonitorExit[var7_12] (shouldn't be in output)
                if (serviceID != null) {
                    this.m_serviceIDtable.put(serviceID, defaultMutableTreeNode);
                    this.m_containerMutableNode.put(defaultMutableTreeNode, serviceID);
                }
                if (this.runtimePanel.isStop() && bl3) {
                    this.containerConfigPanel.updateConfig((IJSpaceContainerAdmin)((Object)iJSpaceContainer));
                }
                objectArray = this.conTreeModel.getPathToRoot(defaultMutableTreeNode);
                TreePath treePath = new TreePath(objectArray);
                this.conTree.expandPath(treePath);
                TreePath treePath2 = this.conTree.getSelectionPath();
                defaultMutableTreeNode2 = null;
                if (treePath2 != null) {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath2.getPath()[treePath2.getPath().length - 1];
                }
                this.setEnable(this.spaceEnableComp, false);
                if (defaultMutableTreeNode2 != null && defaultMutableTreeNode2.getUserObject() instanceof IJSpaceContainerAdmin) {
                    this.setEnable(this.containerEnableComp, true);
                } else {
                    this.setEnable(this.containerEnableComp, false);
                }
                if (!bl3 && defaultMutableTreeNode2 != null) return;
                this.setSelectedTreeNode(defaultMutableTreeNode, true, true);
                return;
            }
        }
        catch (Exception exception) {
            if (!_logger.isLoggable(Level.FINE)) return;
            _logger.log(Level.FINE, exception.toString(), exception);
        }
    }

    public void addContainerTree(ServiceItem serviceItem) {
        if (!this.m_proxyServiceTable.containsKey(serviceItem.service) && !this.m_serviceIDtable.containsKey(serviceItem.serviceID)) {
            this.addContainerTree((IJSpaceContainer)serviceItem.service, serviceItem.serviceID, false);
        }
    }

    public void removeContainerTree(ServiceID serviceID) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_serviceIDtable.remove(serviceID);
        if (defaultMutableTreeNode != null) {
            this.removeContainerTree(defaultMutableTreeNode, false);
        }
    }

    public void restartSelectedContainer() {
        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getSelectedTreeNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        final String string = defaultMutableTreeNode.toString();
        boolean bl2 = this.runtimePanel.isStop();
        int n2 = JOptionPane.showConfirmDialog(this, "Restart <" + string + "> container, are you sure?", "Question", 0, 3, this.QUESTION_ICON);
        if (n2 == 1) {
            return;
        }
        this.runtimePanel.stopStatusRuntime();
        this.mainConfigPanel.removeAll();
        this.mainConfigPanel.validate();
        final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(this, "Restart container:", string);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object;
                    IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
                    DefaultMutableTreeNode defaultMutableTreeNode5 = SpaceBrowser.this.spacesRoot;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                    int n2 = defaultMutableTreeNode5.getChildCount();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        object = (DefaultMutableTreeNode)defaultMutableTreeNode5.getChildAt(i2);
                        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                        if (!(object2 instanceof JSpaceProxyWrapper)) continue;
                        ++n3;
                        if (defaultMutableTreeNode2 == null) {
                            defaultMutableTreeNode2 = object;
                            continue;
                        }
                        if (defaultMutableTreeNode3 != null) continue;
                        defaultMutableTreeNode3 = object;
                    }
                    DefaultTreeModel defaultTreeModel = SpaceBrowser.this.conTreeModel;
                    synchronized (defaultTreeModel) {
                        if (n3 > 1) {
                            DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode != defaultMutableTreeNode2 ? defaultMutableTreeNode2 : defaultMutableTreeNode3;
                            SpaceBrowser.this.removeContainerTree(defaultMutableTreeNode, true);
                            SpaceBrowser.this.setSelectedTreeNode(defaultMutableTreeNode4, true, true);
                            object = defaultMutableTreeNode4.getUserObject();
                            if (object instanceof JSpaceProxyWrapper) {
                                SpaceBrowser.this.containerConfigPanel.updateConfig((IJSpaceContainerAdmin)((JSpaceProxyWrapper)object).proxy());
                            }
                        } else {
                            SpaceBrowser.this.removeContainerTree(defaultMutableTreeNode, true);
                            SpaceBrowser.this.conTreeModel.reload();
                            SpaceBrowser.this.containerConfigPanel.cleanup();
                            SpaceBrowser.this.spaceConfigPanel.cleanup();
                            SpaceBrowser.this.setEnable(SpaceBrowser.this.spaceEnableComp, false);
                            SpaceBrowser.this.setEnable(SpaceBrowser.this.containerEnableComp, false);
                        }
                        SpaceBrowser.this.cleanContainerTables(string, true);
                    }
                    iJSpaceContainerAdmin.restart();
                    progressMonitorBar.terminate();
                    SpaceBrowser.this.showStatus(string + " container restarted successfully");
                    JOptionPane.showMessageDialog(SpaceBrowser.this, "<" + string + "> container restarted successfully.", "Restart container", 1);
                }
                catch (RemoteException remoteException) {
                    SpaceBrowser.this.showStatus("Restart " + string + " container failed: " + remoteException.getMessage());
                    progressMonitorBar.terminate();
                    expDialog.showException("Restart " + string + " container ", remoteException);
                }
            }
        });
        this.m_StaleServiceCleaner.gotoSleep();
        progressMonitorBar.start();
        thread.start();
        this.m_StaleServiceCleaner.wakeUp();
    }

    public void removeContainerTree(IJSpaceContainerAdmin iJSpaceContainerAdmin) {
        this.removeContainerTree((DefaultMutableTreeNode)this.m_proxyServiceTable.get(iJSpaceContainerAdmin), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerTree(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl2) {
        JSpaceProxyWrapper jSpaceProxyWrapper;
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof StaleContainerService) {
            return;
        }
        DefaultTreeModel defaultTreeModel = this.conTreeModel;
        synchronized (defaultTreeModel) {
            jSpaceProxyWrapper = (JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject();
            defaultMutableTreeNode.setUserObject(new StaleContainerService(jSpaceProxyWrapper.toString()));
            this.m_proxyServiceTable.remove(jSpaceProxyWrapper.proxy());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("removeContainerTree() - ContainerName: " + jSpaceProxyWrapper.getProxyName());
            }
            for (int i2 = 0; i2 < defaultMutableTreeNode.getChildCount(); ++i2) {
                IJSpace iJSpace = null;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i2);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (object instanceof StaleSpaceService) continue;
                ServiceID serviceID = null;
                if (object instanceof SecureSpaceNode) {
                    iJSpace = ((SecureSpaceNode)object).getSpaceProxy();
                    serviceID = ((SecureSpaceNode)object).getServiceID();
                } else if (object instanceof JSpaceProxyWrapper) {
                    SpaceTreeNode spaceTreeNode;
                    Object object2;
                    StatisticPanel statisticPanel;
                    iJSpace = (IJSpace)((JSpaceProxyWrapper)object).proxy();
                    serviceID = ((JSpaceProxyWrapper)object).getServiceID();
                    if (object instanceof SpaceTreeNode && (statisticPanel = (StatisticPanel)this.statisticsPerSpace.get(object2 = (spaceTreeNode = (SpaceTreeNode)object).getSpaceObjectID())) != null) {
                        statisticPanel.stopRefresh();
                        this.statisticsPerSpace.remove(object2);
                    }
                }
                this.m_proxyServiceTable.remove(iJSpace);
                this.spacesViewPanel.removeSpace(serviceID);
                defaultMutableTreeNode2.setUserObject(new StaleSpaceService(iJSpace.getName(), jSpaceProxyWrapper.getProxyName()));
                if (bl2) continue;
                this.m_StaleServiceCleaner.addServiceNode(defaultMutableTreeNode2);
            }
        }
        this.conTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        this.cleanContainerTables(jSpaceProxyWrapper.toString(), false);
        this.conTree.repaint();
    }

    public void cleanContainerTables(String string, boolean bl2) {
        ServiceID serviceID = null;
        SpaceBrowser.removeContainerConfigFromMap(string);
        this.spaceConfigPanel.conConfigTable.remove(string);
        DefaultMutableTreeNode defaultMutableTreeNode = SpaceBrowser.removeTreeNodeFromContainerTreeNodeTable(string);
        if (defaultMutableTreeNode != null) {
            serviceID = (ServiceID)this.m_containerMutableNode.remove(defaultMutableTreeNode);
            if (bl2) {
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof JSpaceProxyWrapper) {
                    JSpaceProxyWrapper jSpaceProxyWrapper = (JSpaceProxyWrapper)object;
                    this.m_proxyServiceTable.remove(jSpaceProxyWrapper.proxy());
                } else {
                    this.m_proxyServiceTable.remove(object);
                }
            }
        }
        if (serviceID != null) {
            this.m_serviceIDtable.remove(serviceID);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.newMenuItem || object == this.newClusterPopupMenuItem) {
            this.createNewCluster();
        } else if (object == this.openMenuItem || object == this.openClusterPopupMenuItem) {
            this.openCluster();
        } else if (object == this.verifyMenuItem || object == this.verifyClusterPopupMenuItem) {
            this.verifyCluster();
        } else if (object == this.clusterViewMenuItem || object == this.viewClusterPopupMenuItem) {
            this.clusterView();
        } else if (object == this.closeClusterMenuItem) {
            this.closeCluster(this.currentCluster.getClusterMembers(), this.curSelectedNode, true);
        } else if (object == this.startClusterMenuItem) {
            this.startClusterMembers();
        } else if (object == this.stopClusterMenuItem) {
            if (this.showConfirmMultiSpaceOperationDialog(CONFIRM_MESSAGE_STOP_CLUSTER) == 0) {
                this.stopClusterMembers();
            }
        } else if (object == this.restartClusterMenuItem) {
            if (this.showConfirmMultiSpaceOperationDialog(CONFIRM_MESSAGE_RESTART_CLUSTER) == 0) {
                this.restartClusterMembers();
            }
        } else if (object == this.shutdownClusterMenuItem) {
            if (this.showConfirmMultiSpaceOperationDialog(CONFIRM_MESSAGE_SHUTDOWN_CLUSTER) == 0) {
                this.shutdownClusterMembers();
            }
        } else if (object == this.cleanClusterMenuItem && this.showConfirmMultiSpaceOperationDialog(CONFIRM_MESSAGE_CLEAN_CLUSTER) == 0) {
            this.cleanClusterMembers();
        }
    }

    private int showConfirmMultiSpaceOperationDialog(String string) {
        return JOptionPane.showConfirmDialog(this, string, "Confirm", 0, 2);
    }

    private void closeCluster(ClusterMemberInfo[] clusterMemberInfoArray, MutableTreeNode mutableTreeNode, boolean bl2) {
        this.closeClusterServices(clusterMemberInfoArray);
        String string = mutableTreeNode.toString();
        this._dynamicClusterRefreshThread.clearDynamicClusteredProxy(string);
        TreePath treePath = null;
        if (this.curSelPath != null) {
            treePath = this.curSelPath.getParentPath();
        }
        this.m_clusterViewDialog.removeCluster(mutableTreeNode.toString());
        this.conTreeModel.removeNodeFromParent(mutableTreeNode);
        if (treePath != null && bl2) {
            this.conTree.setSelectionPath(treePath);
            this.doNodeSelected(treePath);
        }
    }

    private void closeClusterServices(ClusterMemberInfo[] clusterMemberInfoArray) {
        ServiceManagerImpl serviceManagerImpl = this.m_clusterViewDialog.getServiceManager();
        serviceManagerImpl.setStaticClusterMembers(null);
        for (int i2 = 0; i2 < clusterMemberInfoArray.length; ++i2) {
            ServiceID serviceID = this.getServiceId(serviceManagerImpl, clusterMemberInfoArray[i2]);
            if (serviceID == null) continue;
            serviceManagerImpl.removeService(serviceID);
        }
    }

    private void startClusterMembers() {
        final ClusterMemberInfo[] clusterMemberInfoArray = this.currentCluster.getClusterMembers();
        final ProgressDialog progressDialog = new ProgressDialog(this, "Starting cluster members...", 0, clusterMemberInfoArray.length);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n2;
                int n3 = 0;
                try {
                    for (n2 = 0; n2 < clusterMemberInfoArray.length && !progressDialog.isCancel(); ++n2) {
                        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = SpaceBrowser.this.getIRemoteJSpaceAdmin(clusterMemberInfoArray[n2]);
                        try {
                            if (iRemoteJSpaceAdmin != null) {
                                iRemoteJSpaceAdmin.start();
                                continue;
                            }
                            ++n3;
                            continue;
                        }
                        catch (SpaceAlreadyStartedException spaceAlreadyStartedException) {
                            ++n3;
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            ++n3;
                            remoteException.printStackTrace();
                            continue;
                        }
                        finally {
                            progressDialog.setProgress(n2 + 1);
                        }
                    }
                }
                finally {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    progressDialog.stopProgress();
                    String string = "Successfully started " + (n2 - n3) + " member(s).";
                    string = string + "\nFailed to start " + n3 + " member(s).";
                    JOptionPane.showMessageDialog(SpaceBrowser.this, string, "Started cluster members", 1);
                }
            }
        };
        thread.start();
        if (thread.isAlive()) {
            progressDialog.setVisible(true);
        }
    }

    private void stopClusterMembers() {
        final ClusterMemberInfo[] clusterMemberInfoArray = this.currentCluster.getClusterMembers();
        final ProgressDialog progressDialog = new ProgressDialog(this, "Stopping cluster members...", 0, clusterMemberInfoArray.length);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n2;
                int n3 = 0;
                try {
                    for (n2 = 0; n2 < clusterMemberInfoArray.length && !progressDialog.isCancel(); ++n2) {
                        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = SpaceBrowser.this.getIRemoteJSpaceAdmin(clusterMemberInfoArray[n2]);
                        try {
                            if (iRemoteJSpaceAdmin != null) {
                                iRemoteJSpaceAdmin.stop();
                                continue;
                            }
                            ++n3;
                            continue;
                        }
                        catch (SpaceAlreadyStoppedException spaceAlreadyStoppedException) {
                            ++n3;
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            ++n3;
                            remoteException.printStackTrace();
                            continue;
                        }
                        finally {
                            progressDialog.setProgress(n2 + 1);
                        }
                    }
                }
                finally {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    progressDialog.stopProgress();
                    String string = "Successfully stopped " + (n2 - n3) + " member(s).";
                    string = string + "\nFailed to stop " + n3 + " member(s).";
                    JOptionPane.showMessageDialog(SpaceBrowser.this, string, "Stopped cluster members", 1);
                }
            }
        };
        thread.start();
        if (thread.isAlive()) {
            progressDialog.setVisible(true);
        }
    }

    private void restartClusterMembers() {
        final ClusterMemberInfo[] clusterMemberInfoArray = this.currentCluster.getClusterMembers();
        final ProgressDialog progressDialog = new ProgressDialog(this, "Restarting cluster members...", 0, clusterMemberInfoArray.length);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n2;
                int n3 = 0;
                try {
                    for (n2 = 0; n2 < clusterMemberInfoArray.length && !progressDialog.isCancel(); ++n2) {
                        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = SpaceBrowser.this.getIRemoteJSpaceAdmin(clusterMemberInfoArray[n2]);
                        try {
                            if (iRemoteJSpaceAdmin != null) {
                                iRemoteJSpaceAdmin.restart();
                                continue;
                            }
                            ++n3;
                            continue;
                        }
                        catch (SpaceAlreadyStoppedException spaceAlreadyStoppedException) {
                            ++n3;
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            ++n3;
                            remoteException.printStackTrace();
                            continue;
                        }
                        finally {
                            progressDialog.setProgress(n2 + 1);
                        }
                    }
                }
                finally {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    progressDialog.stopProgress();
                    String string = "Successfully restarted " + (n2 - n3) + " member(s).";
                    string = string + "\nFailed to restart " + n3 + " member(s).";
                    JOptionPane.showMessageDialog(SpaceBrowser.this, string, "Restarted cluster members", 1);
                }
            }
        };
        thread.start();
        if (thread.isAlive()) {
            progressDialog.setVisible(true);
        }
    }

    private void shutdownClusterMembers() {
        final ClusterMemberInfo[] clusterMemberInfoArray = this.currentCluster.getClusterMembers();
        final ProgressDialog progressDialog = new ProgressDialog(this, "Shutting down cluster members...", 0, clusterMemberInfoArray.length);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                int n2;
                int n3 = 0;
                try {
                    for (n2 = 0; n2 < clusterMemberInfoArray.length && !progressDialog.isCancel(); ++n2) {
                        IJSpace iJSpace = SpaceBrowser.this.getSpaceProxy(clusterMemberInfoArray[n2]);
                        try {
                            if (iJSpace != null) {
                                object = iJSpace.getAdmin();
                                if (!(object instanceof DestroyAdmin)) continue;
                                ((DestroyAdmin)object).destroy();
                                continue;
                            }
                            ++n3;
                            continue;
                        }
                        catch (Exception exception) {
                            ++n3;
                            exception.printStackTrace();
                            continue;
                        }
                        finally {
                            progressDialog.setProgress(n2 + 1);
                        }
                    }
                }
                finally {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    progressDialog.stopProgress();
                    object = "Successfully shutdown " + (n2 - n3) + " member(s).";
                    object = (String)object + "\nFailed to shutdown " + n3 + " member(s).";
                    JOptionPane.showMessageDialog(SpaceBrowser.this, object, "Shutdown cluster members", 1);
                }
            }
        };
        thread.start();
        if (thread.isAlive()) {
            progressDialog.setVisible(true);
        }
    }

    private void cleanClusterMembers() {
        final ClusterMemberInfo[] clusterMemberInfoArray = this.currentCluster.getClusterMembers();
        final ProgressDialog progressDialog = new ProgressDialog(this, "Cleaning cluster members...", 0, clusterMemberInfoArray.length);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n2;
                int n3 = 0;
                try {
                    for (n2 = 0; n2 < clusterMemberInfoArray.length && !progressDialog.isCancel(); ++n2) {
                        IJSpace iJSpace = SpaceBrowser.this.getSpaceProxy(clusterMemberInfoArray[n2]);
                        try {
                            if (iJSpace != null) {
                                iJSpace.clean();
                                continue;
                            }
                            ++n3;
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            ++n3;
                            remoteException.printStackTrace();
                            continue;
                        }
                        finally {
                            progressDialog.setProgress(n2 + 1);
                        }
                    }
                }
                finally {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    progressDialog.stopProgress();
                    String string = "Successfully cleaned " + (n2 - n3) + " member(s).";
                    string = string + "\nFailed to clean " + n3 + " member(s).";
                    JOptionPane.showMessageDialog(SpaceBrowser.this, string, "Cleaned cluster members", 1);
                }
            }
        };
        thread.start();
        if (thread.isAlive()) {
            progressDialog.setVisible(true);
        }
    }

    private IRemoteJSpaceAdmin getIRemoteJSpaceAdmin(ClusterMemberInfo clusterMemberInfo) {
        String string = clusterMemberInfo.memberName;
        ServiceManagerImpl.ClusterMember clusterMember = this.m_clusterViewDialog.getServiceManager().getClusterMember(string);
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = null;
        if (clusterMember != null) {
            iRemoteJSpaceAdmin = clusterMember.getSpaceRemoteRef();
        }
        return iRemoteJSpaceAdmin;
    }

    private IJSpace getSpaceProxy(ClusterMemberInfo clusterMemberInfo) {
        String string = clusterMemberInfo.memberName;
        IJSpace iJSpace = null;
        ServiceManagerImpl.ClusterMember clusterMember = this.m_clusterViewDialog.getServiceManager().getClusterMember(string);
        if (clusterMember != null) {
            iJSpace = clusterMember.getRegularProxy();
        }
        return iJSpace;
    }

    private ServiceID getServiceId(ServiceManagerImpl serviceManagerImpl, ClusterMemberInfo clusterMemberInfo) {
        String string = clusterMemberInfo.memberName;
        ServiceManagerImpl.ClusterMember clusterMember = serviceManagerImpl.getClusterMember(string);
        ServiceID serviceID = null;
        if (clusterMember != null) {
            serviceID = clusterMember.getServiceID();
        }
        return serviceID;
    }

    private void clusterView() {
        this.m_clusterViewDialog.selectClusterFile();
    }

    public void verifyCluster() {
        try {
            File file = this.chooseFile();
            if (file == null) {
                return;
            }
            this.m_clusterWizardDialog.verifyClusterFile(file.getPath());
            this.m_clusterWizardDialog.showClusterDialog();
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, exception.toString(), exception);
            }
            expDialog.showException("cluster configuration parsing", exception);
        }
    }

    private void createNewCluster() {
        try {
            this.m_clusterWizardDialog.reset();
            Hashtable hashtable = this.getBrowserInfo();
            if (hashtable.size() > 0) {
                this.m_clusterWizardDialog.setLiveMemberItem(hashtable);
            }
            this.m_clusterWizardDialog.showClusterDialog(true);
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, exception.toString(), exception);
            }
            expDialog.showException("new cluster creation", exception);
        }
    }

    private void openCluster() {
        try {
            File file = this.chooseFile();
            if (file == null) {
                return;
            }
            Hashtable hashtable = this.getBrowserInfo();
            this.m_clusterWizardDialog.createEditInfo(file.getPath(), true, hashtable.size() > 0 ? hashtable : null);
            this.m_clusterWizardDialog.showClusterDialog();
        }
        catch (Exception exception) {
            String string;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, exception.toString(), exception);
            }
            if ((string = exception.getMessage()).length() > 150) {
                int n2 = string.indexOf(" ", 75);
                string = string.substring(0, n2 + 1) + "\n" + string.substring(n2 + 1);
            }
            expDialog.showException("cluster configuration parsing", exception);
        }
    }

    private void cleanSpaceConfigTable(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.spaceConfigPanel.conConfigTable.get(string);
        if (hashtable != null) {
            hashtable.remove(string2);
        }
    }

    public SpaceConfig getSpaceConfig(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.spaceConfigPanel.conConfigTable.get(string);
        if (hashtable != null) {
            return (SpaceConfig)hashtable.get(string2);
        }
        return null;
    }

    public void showClusterPanel(EditCluster editCluster, boolean bl2) {
        this.currentCluster = editCluster;
        this.mainConfigPanel.removeAll();
        this.m_clusterViewDialog.setClusterView(editCluster, true, bl2);
        this.mainConfigPanel.add((Component)this.m_clusterViewDialog.getClusterPanel(), "Center");
        this.mainConfigPanel.validate();
    }

    public void addClusterTree(ClusterTree clusterTree, DefaultMutableTreeNode defaultMutableTreeNode, EditCluster editCluster, ClusterViewDlg clusterViewDlg, boolean bl2) {
        this.m_clusterViewDialog = clusterViewDlg;
        String string = editCluster.getClusterName();
        if (this.isClusterCanBeAdded(string)) {
            this.conTreeModel.insertNodeInto(defaultMutableTreeNode, this.clusterRoot, this.clusterRoot.getChildCount());
            this.m_clusterViewDialog.putCluster(editCluster, clusterTree);
        } else {
            bl2 = false;
        }
        Object[] objectArray = this.conTreeModel.getPathToRoot(defaultMutableTreeNode);
        TreePath treePath = new TreePath(objectArray);
        this.conTree.expandPath(treePath);
        if (bl2) {
            this.conTree.setSelectionPath(treePath);
        }
        defaultMutableTreeNode.setUserObject(editCluster);
        this.viewMenu.setEnabled(true);
    }

    public DefaultMutableTreeNode getClustersRootNode() {
        return this.clusterRoot;
    }

    public DefaultMutableTreeNode getSpacesRootNode() {
        return this.spacesRoot;
    }

    private boolean isClusterCanBeAdded(String string) {
        boolean bl2 = true;
        if (this.m_clusterViewDialog.containsCluster(string)) {
            int n2 = this.clusterRoot.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.clusterRoot.getChildAt(i2);
                if (!defaultMutableTreeNode.toString().equals(string)) continue;
                Object object = defaultMutableTreeNode.getUserObject();
                EditCluster editCluster = (EditCluster)object;
                long l2 = System.currentTimeMillis();
                if (l2 - editCluster.getCreationTime() > 25000L) {
                    ClusterMemberInfo[] clusterMemberInfoArray = editCluster.getClusterMembers();
                    for (int i3 = 0; i3 < clusterMemberInfoArray.length; ++i3) {
                        ClusterMemberInfo clusterMemberInfo = clusterMemberInfoArray[i3];
                        String string2 = ServiceManagerImpl.getMemberStatus(clusterMemberInfo.memberName, clusterMemberInfo.isMirror());
                        if (!string2.equals("Alive") && !string2.equals("MirrorAlive")) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) break;
                    this.closeCluster(clusterMemberInfoArray, defaultMutableTreeNode, false);
                    break;
                }
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    public void removeTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath) {
        this.conTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        this.conTree.setSelectionPath(treePath);
        this.doNodeSelected(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] addSpaceNodes(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, IJSpaceContainer iJSpaceContainer, boolean bl2, boolean bl3) throws LostConnectionException, RemoteException, NoSuchNameException {
        Object[] objectArray;
        DefaultTreeModel defaultTreeModel2 = this.conTreeModel;
        synchronized (defaultTreeModel2) {
            Cloneable cloneable;
            for (int i2 = 0; i2 < defaultMutableTreeNode.getChildCount(); ++i2) {
                cloneable = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i2);
                Object object = cloneable.getUserObject();
                if (object == null) continue;
                if (object instanceof JSpaceProxyWrapper) {
                    this.m_proxyServiceTable.remove(((JSpaceProxyWrapper)object).proxy());
                    continue;
                }
                if (!(object instanceof SecureSpaceNode)) continue;
                this.m_proxyServiceTable.remove(((SecureSpaceNode)object).getSpaceProxy());
            }
            defaultMutableTreeNode.removeAllChildren();
            if (bl3) {
                defaultTreeModel.reload(defaultMutableTreeNode);
            }
            SpaceBrowser.removeContainerConfigFromMap(defaultMutableTreeNode.toString());
            this.spaceConfigPanel.conConfigTable.remove(defaultMutableTreeNode.toString());
            objectArray = iJSpaceContainer.getSpaceNames();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("> added spaceNames: " + _Arrays.toString(objectArray) + " to container node:" + defaultMutableTreeNode + ", THERAD ID:" + _Thread.getId(Thread.currentThread()));
            }
            IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((Object)iJSpaceContainer);
            cloneable = SpaceBrowser.addContainerToMap(iJSpaceContainerAdmin);
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                Cloneable cloneable2;
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode2;
                Object object2;
                IJSpace iJSpace;
                block22: {
                    iJSpace = null;
                    Object object3 = objectArray[i3];
                    if (this.getChildTreeNodeByName(defaultMutableTreeNode, (String)object3) != null) continue;
                    try {
                        iJSpace = iJSpaceContainer.getClusteredSpace((String)object3, bl2);
                    }
                    catch (Throwable throwable) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, throwable.toString(), throwable);
                        continue;
                    }
                    if (iJSpace == null) {
                        iJSpace = iJSpaceContainer.getSpace((String)object3, bl2);
                    }
                    try {
                        iJSpace.ping();
                    }
                    catch (Exception exception) {
                        System.out.println("*** addSpaceNodes() remote ping to space fail ***");
                        if (!_logger.isLoggable(Level.FINEST)) continue;
                        _logger.log(Level.FINEST, exception.toString(), exception);
                        continue;
                    }
                    if (this.m_proxyServiceTable.containsKey(iJSpace)) continue;
                    if (iJSpace.isSecured()) {
                        object2 = new SecureSpaceNode(iJSpaceContainer.getName(), iJSpace);
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode(object2);
                    } else {
                        defaultMutableTreeNode2 = this.createSpaceNode(iJSpace, iJSpaceContainer);
                    }
                    object2 = null;
                    if (defaultMutableTreeNode2.getUserObject() instanceof JSpaceProxyWrapper) {
                        object2 = ((JSpaceProxyWrapper)defaultMutableTreeNode2.getUserObject()).getServiceID();
                    } else if (defaultMutableTreeNode2.getUserObject() instanceof SecureSpaceNode) {
                        object2 = ((SecureSpaceNode)defaultMutableTreeNode2.getUserObject()).getServiceID();
                    }
                    try {
                        object = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
                        cloneable2 = object.getConfig();
                        this.spacesViewPanel.addSpace(iJSpace, (IRemoteJSpaceAdmin)object, (ServiceID)object2, (SpaceConfig)cloneable2, (ContainerConfig)cloneable);
                    }
                    catch (SpaceSecurityException spaceSecurityException) {
                        if (!_logger.isLoggable(Level.FINE)) break block22;
                        _logger.log(Level.FINE, "Failed to add secured space into the Spaces view panel: ", spaceSecurityException);
                    }
                }
                object = new SpaceRuntimeInfo();
                cloneable2 = new DefaultMutableTreeNode(object);
                defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)cloneable2), defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(TRANSACTIONS_LABEL);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(SQL_LABEL);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(STATISTICS_LABEL);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode5, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(BENCHMARK_LABEL);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode6, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(USER_LABEL);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode7, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("> insert space: " + defaultMutableTreeNode2 + " to container node:" + defaultMutableTreeNode + ", THERAD ID:" + _Thread.getId(Thread.currentThread()));
                }
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                this.m_serviceIDtable.put(object2, defaultMutableTreeNode2);
                this.checkForClusterdSpaceAndAddClusterToTree(iJSpace, (ServiceID)object2);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("addSpaceNodes:  ContainerName: [" + iJSpaceContainer.getName() + "] SpaceName: [" + iJSpace.getName() + "] HashCode: " + iJSpace.hashCode());
                }
                this.m_proxyServiceTable.put(iJSpace, defaultMutableTreeNode2);
            }
        }
        return objectArray == null ? new String[]{} : objectArray;
    }

    private synchronized DefaultMutableTreeNode getChildTreeNodeByName(TreeNode treeNode, String string) {
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i2 = 0; i2 < treeNode.getChildCount(); ++i2) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(i2);
            if (!defaultMutableTreeNode.toString().equals(string)) continue;
            bl2 = true;
            break;
        }
        return bl2 ? defaultMutableTreeNode : null;
    }

    public void removeSpaceNode(ServiceID serviceID) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_serviceIDtable.remove(serviceID);
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.removeSpaceNode(defaultMutableTreeNode);
        this.spacesViewPanel.removeSpace(serviceID);
    }

    public void removeSpaceNode(IJSpace iJSpace) {
        this.removeSpaceNode((DefaultMutableTreeNode)this.m_proxyServiceTable.get(iJSpace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpaceNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string;
        if (defaultMutableTreeNode == null) {
            return;
        }
        IJSpace iJSpace = null;
        DefaultTreeModel defaultTreeModel = this.conTreeModel;
        synchronized (defaultTreeModel) {
            Object object;
            Serializable serializable;
            if (defaultMutableTreeNode.getUserObject() instanceof StaleSpaceService) {
                return;
            }
            Object object2 = defaultMutableTreeNode.getUserObject();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode2 == null) {
                return;
            }
            if (object2 instanceof SpaceTreeNode && (serializable = (StatisticPanel)this.statisticsPerSpace.get(object = ((SpaceTreeNode)object2).getSpaceObjectID())) != null) {
                serializable.stopRefresh();
                this.statisticsPerSpace.remove(object);
            }
            string = (object = defaultMutableTreeNode2.getUserObject()) instanceof JSpaceProxyWrapper ? ((JSpaceProxyWrapper)object).getProxyName() : ((StaleContainerService)object).getContainerName();
            serializable = null;
            if (object2 instanceof SecureSpaceNode) {
                iJSpace = ((SecureSpaceNode)object2).getSpaceProxy();
                serializable = ((SecureSpaceNode)object2).getServiceID();
            } else if (object2 instanceof JSpaceProxyWrapper) {
                iJSpace = (IJSpace)((JSpaceProxyWrapper)object2).proxy();
                serializable = ((JSpaceProxyWrapper)object2).getServiceID();
            }
            this.cleanDestroyedSpaceFromInternalMaps(iJSpace, (ServiceID)serializable, string);
            this.spacesViewPanel.removeSpace((ServiceID)serializable);
            defaultMutableTreeNode.setUserObject(new StaleSpaceService(iJSpace.getName(), string));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removeSpaceNode() - ContainerName: " + string + " SpaceName: " + iJSpace.getName());
        }
        this.m_StaleServiceCleaner.addServiceNode(defaultMutableTreeNode);
        this.conTree.repaint();
    }

    private void cleanDestroyedSpaceFromInternalMaps(IJSpace iJSpace, ServiceID serviceID, String string) {
        this.m_proxyServiceTable.remove(iJSpace);
        this.m_serviceIDtable.remove(serviceID);
        Hashtable hashtable = (Hashtable)this.spaceConfigPanel.conConfigTable.get(string);
        if (hashtable != null) {
            hashtable.remove(iJSpace.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpaceNode(IJSpaceContainer iJSpaceContainer, IJSpace iJSpace, ServiceID serviceID) throws RemoteException {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_proxyServiceTable.get(iJSpaceContainer);
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        String string = iJSpace.getName();
        Object[] objectArray = this.conTreeModel;
        synchronized (this.conTreeModel) {
            Object object;
            defaultMutableTreeNode = this.getChildTreeNodeByName(defaultMutableTreeNode2, string);
            if (defaultMutableTreeNode != null) {
                if (serviceID != null) {
                    this.m_serviceIDtable.put(serviceID, defaultMutableTreeNode);
                }
                this.m_proxyServiceTable.put(iJSpace, defaultMutableTreeNode);
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("addSpaceNode: ContainerName: " + iJSpaceContainer + " SpaceName: " + iJSpace.getName() + " HashCode: " + iJSpace.hashCode());
            }
            if (!this.m_proxyServiceTable.containsKey(iJSpace)) {
                if (iJSpace.isSecured()) {
                    object = new SecureSpaceNode(iJSpaceContainer.getName(), iJSpace);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                } else {
                    defaultMutableTreeNode = this.createSpaceNode(iJSpace, iJSpaceContainer);
                }
            } else {
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            this.m_proxyServiceTable.put(iJSpace, defaultMutableTreeNode);
            this.m_serviceIDtable.put(serviceID, defaultMutableTreeNode);
            object = new SpaceRuntimeInfo();
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(TRANSACTIONS_LABEL);
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(SQL_LABEL);
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(STATISTICS_LABEL);
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(BENCHMARK_LABEL);
            DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(USER_LABEL);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
            defaultMutableTreeNode.add(defaultMutableTreeNode5);
            defaultMutableTreeNode.add(defaultMutableTreeNode6);
            defaultMutableTreeNode.add(defaultMutableTreeNode7);
            defaultMutableTreeNode.add(defaultMutableTreeNode8);
            IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((Object)iJSpaceContainer);
            ContainerConfig containerConfig = SpaceBrowser.addContainerToMap(iJSpaceContainerAdmin);
            IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
            SpaceConfig spaceConfig = iRemoteJSpaceAdmin.getConfig();
            this.spacesViewPanel.addSpace(iJSpace, iRemoteJSpaceAdmin, serviceID, spaceConfig, containerConfig);
            int n2 = defaultMutableTreeNode2.getChildCount();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("> addSpaceNode, insert space: " + defaultMutableTreeNode + " to container node:" + defaultMutableTreeNode2 + ", THERAD ID:" + _Thread.getId(Thread.currentThread()));
            }
            this.conTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2);
            this.checkForClusterdSpaceAndAddClusterToTree(iJSpace, serviceID);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            objectArray = this.conTreeModel.getPathToRoot(defaultMutableTreeNode2);
            object = new TreePath(objectArray);
            if (!this.conTree.isExpanded((TreePath)object)) {
                this.conTree.expandPath((TreePath)object);
            }
            return;
        }
    }

    private void checkForClusterdSpaceAndAddClusterToTree(IJSpace iJSpace, ServiceID serviceID) {
        if (iJSpace == null) {
            return;
        }
        try {
            Object object = iJSpace.getAdmin();
            SpaceConfig spaceConfig = ((IRemoteJSpaceAdmin)object).getConfig();
            if (spaceConfig == null || spaceConfig.isPrivate() || !spaceConfig.isClustered()) {
                return;
            }
            ClusterPolicy clusterPolicy = spaceConfig.getClusterPolicy();
            if (clusterPolicy != null) {
                Object object2;
                String string = clusterPolicy.m_ClusterName;
                if (this.isClusterCanBeAdded(string)) {
                    object2 = ((IInternalRemoteJSpaceAdmin)object).getClusterConfigFile();
                    if (object2 != null) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                        String string2 = spaceConfig.getClusterConfigURL();
                        this.m_clusterViewDialog.addCluster(string, byteArrayInputStream, string2, false, clusterPolicy);
                    }
                } else {
                    this.expandClusterTree(string);
                }
                object2 = iJSpace.getContainer().getName() + ":" + iJSpace.getName();
                this.m_clusterViewDialog.setSpaceID(string, serviceID, (String)object2);
                if (clusterPolicy._logicMembers > 0) {
                    this._dynamicClusterRefreshThread.addDynamicClusteredProxy(string, (JSpaceClusteredProxy)iJSpace);
                }
            }
        }
        catch (CreateException createException) {
            SpaceBrowser.showException(createException.toString(), createException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void expandClusterTree(String string) {
        Object object;
        int n2 = this.clusterRoot.getChildCount();
        Object object2 = this.clusterRoot;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.clusterRoot.getChildAt(i2);
            String string2 = object.toString();
            if (!string2.equals(string)) continue;
            object2 = object;
            break;
        }
        Object[] objectArray = this.conTreeModel.getPathToRoot((TreeNode)object2);
        object = new TreePath(objectArray);
        this.conTree.expandPath((TreePath)object);
    }

    public void setEnable(Vector vector, boolean bl2) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            JComponent jComponent = (JComponent)iterator.next();
            jComponent.setEnabled(bl2);
        }
    }

    private void setEnableSpaceControls(IJSpace iJSpace) {
        Object object;
        if (iJSpace == null) {
            return;
        }
        int n2 = 6;
        Object v2 = this.m_proxyServiceTable.get(iJSpace);
        if (v2 instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)v2).getUserObject()) instanceof JSpaceProxyWrapper) {
            JSpaceProxyWrapper jSpaceProxyWrapper = (JSpaceProxyWrapper)object;
            n2 = jSpaceProxyWrapper.getState();
        }
        boolean bl2 = n2 == 1;
        this.setEnable(this.spaceEnableComp, bl2);
        this.stopSpaceMenuItem.setEnabled(bl2);
        this.stopSpacePopupMenuItem.setEnabled(bl2);
        this.startSpaceMenuItem.setEnabled(!bl2);
        this.startSpacePopupMenuItem.setEnabled(!bl2);
    }

    public void updateSpaceState(IJSpace iJSpace, int n2) {
        Object v2 = this.m_proxyServiceTable.get(iJSpace);
        if (v2 instanceof DefaultMutableTreeNode) {
            Object object = ((DefaultMutableTreeNode)v2).getUserObject();
            if (object instanceof JSpaceProxyWrapper) {
                ((JSpaceProxyWrapper)object).setState(n2);
            } else if (object instanceof SecureSpaceNode) {
                ((SecureSpaceNode)object).setState(n2);
            }
            this.spaceConfigPanel.updateSpaceState(iJSpace.getName(), n2);
        }
    }

    public void showStatus(String string) {
    }

    public static String[] getResources(String string) {
        String string2 = resource.getString(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
        return stringArray;
    }

    public Object getSelectedTreeNode() {
        if (this.curSelectedNode != null && !(this.curSelectedNode.getUserObject() instanceof StaleSpaceService) && !(this.curSelectedNode.getUserObject() instanceof StaleContainerService)) {
            return this.curSelectedNode;
        }
        return null;
    }

    public IJSpace getSelectedSpace() {
        SpaceTreeNode spaceTreeNode = this.getSelectedSpaceNode();
        if (spaceTreeNode != null) {
            return (IJSpace)spaceTreeNode.proxy();
        }
        return null;
    }

    public void refreshCurSelectedRigthPanel(boolean bl2) {
        if (this.curSelectedNode != null) {
            Object[] objectArray = this.conTreeModel.getPathToRoot(this.curSelectedNode);
            TreePath treePath = new TreePath(objectArray);
            this.curSelectedNode = null;
            if (this.curCluster != null) {
                this.currentCluster = null;
                this.m_clusterViewDialog.clearCurrentCluster();
            }
            this.doNodeSelected(treePath);
            if (bl2 && !this.conTree.isExpanded(treePath)) {
                this.conTree.expandPath(treePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSpaceOperationNode(ServiceID serviceID, String string) {
        block5: {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_serviceIDtable.get(serviceID);
                if (defaultMutableTreeNode == null) break block5;
                if (string == null) {
                    this.setSelectedTreeNode(defaultMutableTreeNode, true, true);
                    break block5;
                }
                int n2 = defaultMutableTreeNode.getChildCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    TreeNode treeNode = defaultMutableTreeNode.getChildAt(i2);
                    if (!treeNode.toString().equals(string)) continue;
                    this.setSelectedTreeNode((DefaultMutableTreeNode)treeNode, true, true);
                    break;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void setSelectedTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl2, boolean bl3) {
        TreePath treePath = null;
        if (defaultMutableTreeNode == null) {
            this.setEnable(this.spaceEnableComp, false);
            this.setEnable(this.containerEnableComp, false);
            return;
        }
        if (bl2) {
            Object[] objectArray = this.conTreeModel.getPathToRoot(defaultMutableTreeNode);
            treePath = new TreePath(objectArray);
            this.conTree.setSelectionPath(treePath);
            this.doNodeSelected(treePath);
        }
        if (treePath != null && bl3 && !this.conTree.isExpanded(treePath)) {
            this.conTree.expandPath(treePath);
        }
    }

    public void setSelectedTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.setSelectedTreeNode(defaultMutableTreeNode, false, false);
    }

    private static void loadWebsterHttpServer() {
        String string = li.a();
        String string2 = string + "/lib;" + string + "/lib/jini";
        String string3 = System.getProperty("com.gs.browser.httpd.port");
        if (string3 == null || SpaceBrowser.isPortBusy(string3)) {
            try {
                string3 = SpaceBrowser.getAnonymousPort();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string3 = "9813";
            }
        }
        try {
            System.out.println("Starting Webster...");
            if (_logger.isLoggable(Level.FINE)) {
                System.setProperty("org.jini.rio.tools.webster.debug", "true");
            }
            websterHttpServer = new Webster(Integer.parseInt(string3), string2);
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = System.getProperty("java.rmi.server.codebase");
            if (string4 != null) {
                stringBuffer.append(string4);
                stringBuffer.append(' ');
            }
            stringBuffer.append(BootUtil.getCodebase((String)"JSpaces-dl.jar", (String)string3));
            System.setProperty("java.rmi.server.codebase", stringBuffer.toString());
            System.out.println("INFO: java.rmi.server.codebase = " + stringBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SpaceConfigPanel getSpaceConfigDialog() {
        return this.spaceConfigPanel;
    }

    public ContainerConfigPanel getContainerConfigPanel() {
        return this.containerConfigPanel;
    }

    public static ContainerConfig getContainerConfig(String string) {
        return (ContainerConfig)containersMap.get(string);
    }

    public void addSpaceConfigToContainerConfig(String string, String string2, SpaceConfig spaceConfig) {
        ContainerConfig containerConfig = SpaceBrowser.getContainerConfig(string);
        containerConfig.getSpaceSchemasMap().put(string2, spaceConfig);
    }

    public static boolean isAvailableLookAndFeel(String string) {
        try {
            Class clazz = ci.a(string);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            return lookAndFeel.isSupportedLookAndFeel();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void exit(int n2) {
        this.m_clusterViewDialog.getServiceManager().shutdown();
        if (websterHttpServer != null) {
            websterHttpServer.terminate();
        }
        if (this.m_systemExit) {
            System.exit(n2);
        } else {
            this.setVisible(false);
        }
    }

    public void debug(Throwable throwable) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, throwable.getMessage(), throwable);
        }
    }

    public static String getAnonymousPort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int n2 = serverSocket.getLocalPort();
        serverSocket.close();
        return Integer.toString(n2);
    }

    public static void showException(String string, Throwable throwable) {
        if (expDialog != null) {
            expDialog.showException(string, throwable);
        }
    }

    public JTree getContainerTree() {
        return this.conTree;
    }

    public static JPanel getMainPanel() {
        em.a();
        _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
        if (instance == null) {
            instance = new SpaceBrowser(false, true);
        }
        return instance.getMainContainer();
    }

    private static void ensureSecurity() {
        if (System.getProperty("java.security.policy") == null) {
            ey.a("policy/gigaspaces.policy");
        } else {
            System.setSecurityManager(new RMISecurityManager());
        }
    }

    public static void main(String[] stringArray) {
        SpaceBrowser.ensureSecurity();
        if (System.getProperty("java.security.policy") == null) {
            ey.a("policy/gigaspaces.policy");
        }
        em.a();
        _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
        boolean bl2 = true;
        boolean bl3 = true;
        try {
            if (stringArray != null && stringArray.length >= 1) {
                bl2 = Boolean.valueOf(stringArray[0]);
            }
            if (stringArray != null && stringArray.length >= 2) {
                bl3 = Boolean.valueOf(stringArray[1]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            JFrame jFrame;
            ShowLogo showLogo;
            block14: {
                boolean bl4;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension dimension = toolkit.getScreenSize();
                showLogo = null;
                jFrame = null;
                if (bl3) {
                    jFrame = new JFrame();
                    jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(jFrame.getClass().getResource(LOGO_ICON)));
                    showLogo = new ShowLogo(jFrame, dimension);
                    showLogo.showSplash();
                }
                if (bl4 = Boolean.getBoolean("com.gs.browser.httpd.enabled")) {
                    SpaceBrowser.loadWebsterHttpServer();
                }
                JSpaceUtilities.setXMLImplSystemProps();
                try {
                    String string = UIManager.getSystemLookAndFeelClassName();
                    if (Boolean.getBoolean("com.gs.browser.laf.isCross")) {
                        string = UIManager.getCrossPlatformLookAndFeelClassName();
                    }
                    if (SpaceBrowser.isAvailableLookAndFeel(string)) {
                        UIManager.setLookAndFeel(string);
                    }
                    System.out.println("Look and Feel:" + UIManager.getLookAndFeel());
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.FINE)) break block14;
                    _logger.log(Level.FINE, exception.toString(), exception);
                }
            }
            instance = !bl2 ? new SpaceBrowser(bl2) : SpaceBrowser.getInstance();
            if (bl3) {
                showLogo.setVisible(false);
                jFrame.dispose();
            }
            instance.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JPanel getMainContainer() {
        return this.mainContainer;
    }

    private static boolean isPortBusy(int n2) {
        try {
            new ServerSocket(n2).close();
        }
        catch (IOException iOException) {
            return true;
        }
        return false;
    }

    private static boolean isPortBusy(String string) {
        return SpaceBrowser.isPortBusy(Integer.parseInt(string));
    }

    public boolean isCreatedWithinAnotherGUIAppl() {
        return this.isCreatedWithinAnotherGUIAppl;
    }

    public void updateDynamicClusterMembers(String string, List list) {
        EditCluster editCluster = this.m_clusterViewDialog.updateDynamicClusterMembers(string, list);
        if (editCluster != null) {
            int n2 = this.clusterRoot.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.clusterRoot.getChildAt(i2);
                if (!string.equals(defaultMutableTreeNode.toString())) continue;
                defaultMutableTreeNode.setUserObject(editCluster);
                break;
            }
            if (this.curCluster != null && this.curCluster == editCluster) {
                this.refreshCurSelectedRigthPanel(false);
            }
        }
    }

    public DefaultTreeModel getContainersTreeModel() {
        return this.conTreeModel;
    }

    static {
        containersMap = new HashMap(3);
        containerTreeNodeTable = new Hashtable(3);
        containerAdminMap = new HashMap();
        websterHttpServer = null;
    }

    public class ShowDumpResultsFrame
    extends JFrame {
        private JTextArea textArea = new JTextArea();
        private JScrollPane scrollPane = new JScrollPane(this.textArea);
        private JTextField findTextField = new JTextField();
        private JButton findButton = new JButton("Find");
        private JButton saveAsButton = new JButton("Save As...");
        private String curDump;
        private JFileChooser fileChooser;
        private String curContainerName;

        public ShowDumpResultsFrame() {
            this.init();
            this.setSize(750, 450);
        }

        private void init() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.setIconImage(toolkit.getImage(this.getClass().getResource(SpaceBrowser.LOGO_ICON)));
            this.textArea.setEditable(false);
            this.textArea.setFont(UIManager.getFont("JTextField.font"));
            this.getContentPane().add((Component)this.scrollPane, "Center");
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setRollover(true);
            this.findTextField.setPreferredSize(new Dimension(120, 23));
            this.findTextField.setMaximumSize(new Dimension(120, 23));
            jToolBar.add(Box.createHorizontalStrut(1));
            jToolBar.add(Box.createHorizontalStrut(3));
            jToolBar.add(this.findTextField);
            jToolBar.add(Box.createHorizontalStrut(3));
            jToolBar.add(this.findButton);
            Box box = this.createCloseButtonBox();
            this.getContentPane().add((Component)box, "South");
            this.getContentPane().add((Component)jToolBar, "North");
            this.findTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        ShowDumpResultsFrame.this.invokeFind();
                    }
                }
            });
            this.findButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowDumpResultsFrame.this.invokeFind();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        ShowDumpResultsFrame.this.setVisible(false);
                    }
                }
            });
        }

        private Box createCloseButtonBox() {
            JButton jButton = new JButton("Close");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowDumpResultsFrame.this.setVisible(false);
                }
            });
            this.saveAsButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ShowDumpResultsFrame.this.fileChooser == null) {
                        ShowDumpResultsFrame.this.fileChooser = new JFileChooser(li.a());
                    }
                    ShowDumpResultsFrame.this.curContainerName = ShowDumpResultsFrame.this.curContainerName.replace(':', '_');
                    ShowDumpResultsFrame.this.fileChooser.setSelectedFile(new File(ShowDumpResultsFrame.this.curContainerName + ".txt"));
                    int n2 = ShowDumpResultsFrame.this.fileChooser.showSaveDialog(ShowDumpResultsFrame.this);
                    if (n2 == 0) {
                        File file = ShowDumpResultsFrame.this.fileChooser.getSelectedFile();
                        try {
                            ShowDumpResultsFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            fileOutputStream.write(ShowDumpResultsFrame.this.curDump.getBytes());
                            fileOutputStream.flush();
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            SpaceBrowser.showException(exception.toString(), exception);
                        }
                        finally {
                            ShowDumpResultsFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setRollover(true);
            jToolBar.add(this.saveAsButton);
            jToolBar.add(Box.createHorizontalStrut(10));
            jToolBar.add(jButton);
            Box box = new Box(0);
            Box box2 = new Box(1);
            box2.add(Box.createVerticalStrut(2));
            box2.add(jToolBar);
            box2.add(Box.createVerticalStrut(2));
            box.add(Box.createHorizontalGlue());
            box.add(box2);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        private void invokeFind() {
            String string = this.findTextField.getText();
            if (string.length() > 0) {
                int n2 = this.textArea.getCaretPosition();
                int n3 = this.curDump.indexOf(string, n2);
                if (n3 < 0 && n2 != 0) {
                    n3 = this.curDump.indexOf(string, 0);
                }
                if (n3 >= 0) {
                    this.textArea.select(n3, n3 + string.length());
                    this.textArea.grabFocus();
                }
            }
        }

        public void setDump(String string, String string2) {
            this.curContainerName = string2;
            this.curDump = string;
            this.textArea.setText(string);
            this.textArea.select(0, 0);
            this.setTitle("Configuration report results for <" + string2 + ">");
        }
    }

    public class SpaceBrowserMainContainer
    extends JPanel {
        public void removeNotify() {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Remove Notify");
            }
            SpaceBrowser.this.onClose();
        }

        public void serviceAdded(ServiceItem serviceItem) {
            if (serviceItem.service instanceof IJSpace || serviceItem.service instanceof IJSpaceContainer) {
                SpaceBrowser.this.sdmListener.serviceAdded(serviceItem);
            }
        }

        public void serviceRemoved(ServiceItem serviceItem) {
            if (serviceItem.service instanceof IJSpace || serviceItem.service instanceof IJSpaceContainer) {
                SpaceBrowser.this.sdmListener.serviceRemoved(serviceItem);
            }
        }

        public void serviceChanged(ServiceItem serviceItem) {
        }
    }

    public static class ProgressDialog
    extends JDialog {
        private JProgressBar progressBar;
        private JLabel noteLabel = new JLabel();
        private JButton cancelButton = new JButton("Cancel");
        private int incrementIndex = 10;
        private boolean isCancel = false;

        public ProgressDialog(JFrame jFrame, String string, int n2, int n3) {
            super(jFrame, "Progress...", true);
            this.progressBar = new JProgressBar(n2 * this.incrementIndex, n3 * this.incrementIndex);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.noteLabel.setText(string);
            this.init();
            this.setLocationRelativeTo(jFrame);
        }

        private void init() {
            this.progressBar.setBorder(BorderFactory.createEtchedBorder(1));
            this.progressBar.setMaximumSize(new Dimension(1000, 22));
            this.progressBar.setPreferredSize(new Dimension(1000, 22));
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            JLabel jLabel = new JLabel(UIManager.getIcon("OptionPane.informationIcon"));
            Box box = new Box(0);
            Box box2 = new Box(0);
            Box box3 = new Box(0);
            box.add(Box.createHorizontalStrut(45));
            box.add(this.noteLabel);
            box.add(Box.createHorizontalGlue());
            box2.add(Box.createHorizontalStrut(5));
            box2.add(jLabel);
            box2.add(Box.createHorizontalStrut(8));
            box2.add(this.progressBar);
            box2.add(Box.createHorizontalStrut(5));
            box3.add(Box.createHorizontalGlue());
            box3.add(this.cancelButton);
            box3.add(Box.createHorizontalGlue());
            container.add(Box.createVerticalStrut(5));
            container.add(box);
            container.add(Box.createVerticalStrut(4));
            container.add(box2);
            container.add(Box.createVerticalStrut(7));
            container.add(box3);
            container.add(Box.createVerticalStrut(10));
            this.setDefaultCloseOperation(0);
            this.setSize(250, 125);
            this.progressBar.setValue(1);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressDialog.this.isCancel = true;
                    ProgressDialog.this.setVisible(false);
                }
            });
        }

        public void setProgress(int n2) {
            this.progressBar.setValue(n2 * this.incrementIndex);
        }

        public void stopProgress() {
            this.setVisible(false);
        }

        public static void main(String[] stringArray) {
            Object object;
            block4: {
                try {
                    object = UIManager.getSystemLookAndFeelClassName();
                    if (Boolean.getBoolean("com.gs.browser.laf.isCross")) {
                        object = UIManager.getCrossPlatformLookAndFeelClassName();
                    }
                    if (SpaceBrowser.isAvailableLookAndFeel((String)object)) {
                        UIManager.setLookAndFeel((String)object);
                    }
                    System.out.println("Look and Feel:" + UIManager.getLookAndFeel());
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.FINE)) break block4;
                    _logger.log(Level.FINE, exception.toString(), exception);
                }
            }
            object = new JFrame("Test");
            ((Window)object).setSize(200, 200);
            ((Window)object).setVisible(true);
            ProgressDialog progressDialog = new ProgressDialog((JFrame)object, "Progress...", 0, 20);
            progressDialog.setVisible(true);
        }

        public boolean isCancel() {
            return this.isCancel;
        }
    }

    public class StopSpaceAL
    implements ActionListener {
        public SpaceBrowser browser;
        public IJSpace spaceProxy;

        public StopSpaceAL(SpaceBrowser spaceBrowser2) {
            this.browser = spaceBrowser2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(SpaceBrowser.this, "Stop space", SpaceBrowser.this.curSelectedNode.toString(), 250L);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.curSelectedNode.getParent();
                            IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
                            StopSpaceAL.this.spaceProxy = (IJSpace)((JSpaceProxyWrapper)SpaceBrowser.this.curSelectedNode.getUserObject()).proxy();
                            IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)StopSpaceAL.this.spaceProxy.getAdmin();
                            iRemoteJSpaceAdmin.stop();
                            SpaceBrowser.this.spaceConfigPanel.updateDialog(iJSpaceContainerAdmin.getName(), StopSpaceAL.this.spaceProxy);
                            SpaceBrowser.this.setEnableSpaceControls(StopSpaceAL.this.spaceProxy);
                            progressMonitorBar.terminate();
                            JOptionPane.showMessageDialog(SpaceBrowser.this, StopSpaceAL.this.spaceProxy.getName() + " stopped successfully.");
                        }
                        catch (Exception exception) {
                            SpaceBrowser.this.showStatus("Stop " + StopSpaceAL.this.spaceProxy.getName() + " space is failed: " + exception.getMessage());
                            progressMonitorBar.terminate();
                            expDialog.showException("Stop " + StopSpaceAL.this.spaceProxy.getName() + " space", exception);
                            if (!_logger.isLoggable(Level.FINE)) break block2;
                            _logger.log(Level.FINE, exception.toString(), exception);
                        }
                    }
                }
            });
            progressMonitorBar.start();
            thread.start();
        }
    }

    public class StartSpaceAL
    implements ActionListener {
        public SpaceBrowser browser;
        public IJSpace spaceProxy;

        public StartSpaceAL(SpaceBrowser spaceBrowser2) {
            this.browser = spaceBrowser2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(SpaceBrowser.this, "Start space", SpaceBrowser.this.curSelectedNode.toString(), 250L);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.curSelectedNode.getParent();
                            IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
                            StartSpaceAL.this.spaceProxy = (IJSpace)((JSpaceProxyWrapper)SpaceBrowser.this.curSelectedNode.getUserObject()).proxy();
                            IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)StartSpaceAL.this.spaceProxy.getAdmin();
                            iRemoteJSpaceAdmin.start();
                            SpaceBrowser.this.spaceConfigPanel.updateDialog(iJSpaceContainerAdmin.getName(), StartSpaceAL.this.spaceProxy);
                            SpaceBrowser.this.setEnableSpaceControls(StartSpaceAL.this.spaceProxy);
                            progressMonitorBar.terminate();
                            JOptionPane.showMessageDialog(SpaceBrowser.this, StartSpaceAL.this.spaceProxy.getName() + " started successfully.");
                        }
                        catch (Exception exception) {
                            SpaceBrowser.this.showStatus("Start " + StartSpaceAL.this.spaceProxy.getName() + " space is failed: " + exception.getMessage());
                            progressMonitorBar.terminate();
                            expDialog.showException("Start " + StartSpaceAL.this.spaceProxy.getName() + " space", exception);
                            if (!_logger.isLoggable(Level.FINE)) break block2;
                            _logger.log(Level.FINE, exception.toString(), exception);
                        }
                    }
                }
            });
            progressMonitorBar.start();
            thread.start();
        }
    }

    public class ProgressThread
    extends Thread {
        public int i;
        public int cnt = 0;
        public int progMax = 200;
        public String URL;
        public SpaceURL spaceUrl = null;
        public Exception exception = null;
        public String containerName;
        public Object proxy = null;

        public void setURL(String string) throws MalformedURLException {
            this.URL = string;
            this.spaceUrl = SpaceURLParser.parseURL(string);
            this.containerName = this.spaceUrl.getContainerName();
        }

        public void run() {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ProgressThread.this.proxy = SpaceFinder.find(SpaceURL.concatAttrIfNotExist(ProgressThread.this.URL, "timeout", String.valueOf(100000)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        ProgressThread.this.exception = exception;
                    }
                }
            });
            ProgressMonitor progressMonitor = new ProgressMonitor(SpaceBrowser.this, "Looking for Container:", this.containerName, 0, this.progMax);
            thread.start();
            while (this.proxy == null && this.exception == null && !progressMonitor.isCanceled() && this.cnt != this.progMax) {
                progressMonitor.setProgress(++this.cnt);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, interruptedException.toString(), interruptedException);
                }
            }
            if (progressMonitor.isCanceled()) {
                SpaceBrowser.this.showStatus("Discovery of " + this.containerName + " container was canceled!");
                progressMonitor.close();
                JOptionPane.showMessageDialog(SpaceBrowser.this, "Container discovery process canceled!", "Cancellation", 0);
            }
            if (this.exception != null) {
                progressMonitor.close();
                SpaceBrowser.this.showStatus("Discovery of " + this.containerName + " container failed");
                expDialog.showException("discovering " + this.containerName + " container", this.exception);
            }
            if (this.cnt == this.progMax) {
                SpaceBrowser.this.showStatus("Discovery of " + this.containerName + " container time out");
                JOptionPane.showMessageDialog(SpaceBrowser.this, "The " + this.containerName + " container can not be found!", "Time out", 2);
            }
            thread.interrupt();
            if (this.proxy != null) {
                boolean bl2 = this.spaceUrl.getProtocol().startsWith("java:");
                if (this.proxy instanceof IJSpaceContainer) {
                    SpaceBrowser.this.addContainerTree((IJSpaceContainer)this.proxy, null, bl2, true);
                } else if (this.proxy instanceof IJSpace) {
                    SpaceBrowser.this.addContainerTree(((IJSpace)this.proxy).getContainer(), null, bl2, true);
                }
            }
            progressMonitor.close();
        }
    }

    public class RestartSpaceAL
    implements ActionListener {
        public SpaceBrowser browser;
        public IJSpace spaceProxy;

        public RestartSpaceAL(SpaceBrowser spaceBrowser2) {
            this.browser = spaceBrowser2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(SpaceBrowser.this, "Restart space", SpaceBrowser.this.curSelectedNode.toString(), 250L);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.curSelectedNode.getParent();
                            RestartSpaceAL.this.spaceProxy = (IJSpace)((JSpaceProxyWrapper)SpaceBrowser.this.curSelectedNode.getUserObject()).proxy();
                            IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)RestartSpaceAL.this.spaceProxy.getAdmin();
                            iRemoteJSpaceAdmin.restart();
                            String string = defaultMutableTreeNode.toString();
                            RestartSpaceAL.this.browser.cleanSpaceConfigTable(string, RestartSpaceAL.this.spaceProxy.getName());
                            RestartSpaceAL.this.browser.spaceConfigPanel.updateDialog(string, RestartSpaceAL.this.spaceProxy);
                            ServiceID serviceID = ((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).getServiceID();
                            SpaceBrowser.this.checkForClusterdSpaceAndAddClusterToTree(RestartSpaceAL.this.spaceProxy, serviceID);
                            progressMonitorBar.terminate();
                            JOptionPane.showMessageDialog(SpaceBrowser.this, RestartSpaceAL.this.spaceProxy.getName() + " restarted successfully.");
                        }
                        catch (Exception exception) {
                            SpaceBrowser.this.showStatus("Restart " + RestartSpaceAL.this.spaceProxy.getName() + " space failed: " + exception.getMessage());
                            progressMonitorBar.terminate();
                            expDialog.showException("Restart " + RestartSpaceAL.this.spaceProxy.getName() + " space", exception);
                            if (!_logger.isLoggable(Level.FINE)) break block2;
                            _logger.log(Level.FINE, exception.toString(), exception);
                        }
                    }
                }
            });
            progressMonitorBar.start();
            thread.start();
        }
    }

    public class HelpAL
    implements ActionListener {
        public Hashtable helpDocFilesTable = new Hashtable();

        public HelpAL() {
            String[] stringArray = SpaceBrowser.getResources(SpaceBrowser.HELP_MENU);
            String[] stringArray2 = SpaceBrowser.getResources(SpaceBrowser.HELP_MENU_DOCFILES);
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                if (stringArray2[i2].equalsIgnoreCase("none")) continue;
                String string = stringArray2[i2].startsWith("http") ? stringArray2[i2] : "file://" + new File(stringArray2[i2]).getAbsolutePath();
                this.helpDocFilesTable.put(MenuWithIcon.getMenuNameWithoutMnemonicsChar(stringArray[i2]), string);
            }
            this.helpDocFilesTable.put("", "file://" + new File(stringArray2[1]).getAbsolutePath());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpaceBrowser.this.helpAboutDialog.show();
        }
    }

    public class RefreshContainerAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.getSelectedTreeNode();
            if (defaultMutableTreeNode == null) {
                return;
            }
            final IJSpaceContainer iJSpaceContainer = (IJSpaceContainer)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
            final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(SpaceBrowser.this, "Refresh Container:", defaultMutableTreeNode.toString());
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SpaceBrowser.this.addContainerTree(iJSpaceContainer, null, true);
                    SpaceBrowser.this.showStatus(defaultMutableTreeNode + " container refreshed successfully");
                    progressMonitorBar.terminate();
                }
            });
            thread.start();
            progressMonitorBar.start();
        }
    }

    public class ShowContainerDumpAction
    implements ActionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.getSelectedTreeNode();
            if (defaultMutableTreeNode == null) {
                return;
            }
            IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
            try {
                SpaceBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
                if (SpaceBrowser.this.dumpResultsFrame == null) {
                    SpaceBrowser.this.dumpResultsFrame = new ShowDumpResultsFrame();
                    SpaceBrowser.this.dumpResultsFrame.setLocationRelativeTo(SpaceBrowser.this);
                }
                String string = iJSpaceContainerAdmin.getRuntimeConfigReport();
                SpaceBrowser.this.dumpResultsFrame.setDump(string, defaultMutableTreeNode.toString());
                SpaceBrowser.this.dumpResultsFrame.setVisible(true);
            }
            catch (Exception exception) {
                expDialog.showException("Configuration report results for <" + defaultMutableTreeNode.toString() + " >", exception);
            }
            finally {
                SpaceBrowser.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public class DestroySpaceAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.getSelectedTreeNode();
            if (defaultMutableTreeNode == null) {
                return;
            }
            final DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            String string = "Are you sure you want to destroy space <" + defaultMutableTreeNode + "> running on \"" + defaultMutableTreeNode2 + "\" ?";
            if (JOptionPane.showConfirmDialog(SpaceBrowser.this, string, "Confirmation", 0) != 0) {
                return;
            }
            if (defaultMutableTreeNode2 == null) {
                return;
            }
            final String string2 = defaultMutableTreeNode2.toString();
            final String string3 = defaultMutableTreeNode.toString();
            final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(SpaceBrowser.this, "Destroying space:", defaultMutableTreeNode.toString());
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    IJSpaceContainer iJSpaceContainer = (IJSpaceContainer)((JSpaceProxyWrapper)defaultMutableTreeNode2.getUserObject()).proxy();
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        String string = defaultMutableTreeNode.toString();
                        iJSpaceContainer.destroySpace(string);
                        SpaceBrowser.this.removeSpaceNode(defaultMutableTreeNode);
                        if (defaultMutableTreeNode.getUserObject() instanceof StaleSpaceService) {
                            progressMonitorBar.terminate();
                            return;
                        }
                        progressMonitorBar.terminate();
                        SpaceBrowser.this.showStatus(string + " space destroyed successfully");
                        JOptionPane.showMessageDialog(SpaceBrowser.this, string + " space destroyed in " + string2 + " container successfully.", "Destroy Space", 1);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, illegalArgumentException.toString(), illegalArgumentException);
                        }
                    }
                    catch (Exception exception) {
                        SpaceBrowser.this.showStatus("Destroy " + string3 + " space failed: " + exception.getMessage());
                        progressMonitorBar.terminate();
                        expDialog.showException("destroying " + string3 + " space", exception);
                    }
                }
            });
            progressMonitorBar.start();
            thread.start();
        }
    }

    public class PingSpaceAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.getSelectedTreeNode();
            if (defaultMutableTreeNode == null) {
                return;
            }
            final IJSpace iJSpace = (IJSpace)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
            final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(SpaceBrowser.this, "Ping to space:", defaultMutableTreeNode.toString());
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        iJSpace.ping();
                        progressMonitorBar.terminate();
                        SpaceBrowser.this.showStatus(defaultMutableTreeNode + " space is alive!");
                        JOptionPane.showMessageDialog(SpaceBrowser.this, defaultMutableTreeNode + " space is alive!", "Ping to Server...", 1);
                    }
                    catch (Exception exception) {
                        SpaceBrowser.this.showStatus("Ping to " + defaultMutableTreeNode + " space failed: " + exception.getMessage());
                        progressMonitorBar.terminate();
                        expDialog.showException("ping to " + defaultMutableTreeNode + " space", exception);
                    }
                }
            });
            progressMonitorBar.start();
            thread.start();
        }
    }

    public class CleanSpaceAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.getSelectedTreeNode();
            if (defaultMutableTreeNode == null) {
                return;
            }
            try {
                object2 = (IJSpace)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
                object = (IRemoteJSpaceAdmin)object2.getAdmin();
                if (object.getConfig().isClustered() && JOptionPane.showConfirmDialog(SpaceBrowser.this, "Space " + object2.getName() + " is clustered.\nThis will clean only space " + object2.getName() + ".\nDo you want to Continue?", "Clean cluster space?", 2) != 0) {
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object2 = new ProgressMonitorBar(SpaceBrowser.this, "Clean space:", defaultMutableTreeNode.toString());
            object = new Thread(new Runnable((ProgressMonitorBar)object2){
                public final /* synthetic */ ProgressMonitorBar val$pb;
                {
                    this.val$pb = progressMonitorBar;
                }

                public void run() {
                    try {
                        IJSpace iJSpace = (IJSpace)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
                        iJSpace.clean();
                        this.val$pb.terminate();
                        SpaceBrowser.this.showStatus(iJSpace.getName() + " space cleaned successfully");
                        JOptionPane.showMessageDialog(SpaceBrowser.this, defaultMutableTreeNode + " space cleaned successfully.", "Clean Space", 1);
                    }
                    catch (SecurityException securityException) {
                        this.val$pb.terminate();
                        JOptionPane.showMessageDialog(SpaceBrowser.this, "You don't have permission to clean " + defaultMutableTreeNode + " space.", "Clean Space failed", 0);
                    }
                    catch (Exception exception) {
                        SpaceBrowser.this.showStatus("Clean " + defaultMutableTreeNode + " space failed: " + exception.getMessage());
                        this.val$pb.terminate();
                        expDialog.showException("clean " + defaultMutableTreeNode + " space", exception);
                    }
                }
            });
            ((ProgressMonitorBar)object2).start();
            ((Thread)object).start();
        }
    }

    public class ShutdownContainerAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.getSelectedTreeNode();
            if (defaultMutableTreeNode == null) {
                return;
            }
            final String string = defaultMutableTreeNode.toString();
            int n2 = JOptionPane.showConfirmDialog(SpaceBrowser.this, "Are sure you want to shutdown <" + string + "> container?", "Question", 0, 3, SpaceBrowser.this.QUESTION_ICON);
            if (n2 == 1) {
                return;
            }
            SpaceBrowser.this.runtimePanel.stopStatusRuntime();
            final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(SpaceBrowser.this, "Shutdown Container:", defaultMutableTreeNode.toString());
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    IJSpaceContainer iJSpaceContainer = (IJSpaceContainer)((JSpaceProxyWrapper)defaultMutableTreeNode.getUserObject()).proxy();
                    try {
                        iJSpaceContainer.shutdown();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = SpaceBrowser.this.spacesRoot;
                        DefaultTreeModel defaultTreeModel = SpaceBrowser.this.conTreeModel;
                        synchronized (defaultTreeModel) {
                            if (defaultMutableTreeNode3.getChildCount() > 1) {
                                DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getNextSibling();
                                if (defaultMutableTreeNode2 == null) {
                                    defaultMutableTreeNode2 = defaultMutableTreeNode.getPreviousSibling();
                                }
                                SpaceBrowser.this.removeContainerTree(defaultMutableTreeNode, true);
                                if (defaultMutableTreeNode2 != null) {
                                    Object object;
                                    SpaceBrowser.this.setSelectedTreeNode(defaultMutableTreeNode2, true, true);
                                    Object object2 = defaultMutableTreeNode2.getUserObject();
                                    if (object2 instanceof JSpaceProxyWrapper && (object = ((JSpaceProxyWrapper)object2).proxy()) instanceof IJSpaceContainerAdmin) {
                                        IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)object;
                                        SpaceBrowser.this.containerConfigPanel.updateConfig(iJSpaceContainerAdmin);
                                    }
                                } else {
                                    SpaceBrowser.this.setSelectedTreeNode(SpaceBrowser.this.spacesRoot, true, false);
                                }
                            } else {
                                SpaceBrowser.this.removeContainerTree(defaultMutableTreeNode, true);
                                SpaceBrowser.this.containerConfigPanel.cleanup();
                                SpaceBrowser.this.spaceConfigPanel.cleanup();
                                SpaceBrowser.this.setSelectedTreeNode(SpaceBrowser.this.spacesRoot, true, false);
                            }
                        }
                        progressMonitorBar.terminate();
                        SpaceBrowser.this.showStatus(string + " container shutdowned successfully");
                        JOptionPane.showMessageDialog(SpaceBrowser.this, "<" + string + "> container shutdowned successfully.", "Shutdown container", 1);
                    }
                    catch (Exception exception) {
                        SpaceBrowser.this.showStatus("shutdown " + string + " container failed: " + exception.getMessage());
                        progressMonitorBar.terminate();
                        expDialog.showException("shutdown " + string + " container", exception);
                    }
                    SpaceBrowser.this.cleanContainerTables(string, true);
                }
            });
            progressMonitorBar.start();
            thread.start();
        }
    }

    public class RestartContainerAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SpaceBrowser.this.restartSelectedContainer();
        }
    }

    public class CreateSpaceAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SpaceBrowser.this.getSelectedTreeNode();
            if (defaultMutableTreeNode != null) {
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof JSpaceProxyWrapper) {
                    object = ((JSpaceProxyWrapper)object).proxy();
                }
                if (object instanceof IJSpaceContainer) {
                    SpaceBrowser.this.newSpaceDialog.cleanup();
                    String string = defaultMutableTreeNode.toString();
                    SpaceBrowser.this.newSpaceDialog.setContainer(string, (IJSpaceContainer)object);
                    SpaceBrowser.this.newSpaceDialog.setDefaultSettings(SpaceBrowser.getContainerConfig(string));
                    SpaceBrowser.this.newSpaceDialog.setVisible(true);
                }
            }
        }
    }

    public class TreeRenderer
    extends DefaultTreeCellRenderer {
        public final ImageIcon spacesRootIcon;
        public final ImageIcon containerTreeIcon;
        public final ImageIcon spaceIcon;
        public final ImageIcon runtimeIcon;
        public final ImageIcon containerLocalIcon;
        public final ImageIcon containerStaleIcon;
        public final ImageIcon spaceStaleIcon;
        public final ImageIcon spaceStopIcon;
        public final ImageIcon user;
        public final ImageIcon transactionsIcon;
        public final ImageIcon sqlIcon;
        public final ImageIcon statisticsIcon;
        public final ImageIcon benchmarkIcon;
        public final ImageIcon clustersRootIcon;
        public final ImageIcon securedSpaceIcon;
        public final ImageIcon clusterIcon;
        public final ImageIcon groupIcon;

        public TreeRenderer() {
            String[] stringArray = SpaceBrowser.getResources(SpaceBrowser.TREE_ICONS);
            this.runtimeIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[0]));
            this.containerTreeIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[1]));
            this.spaceIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[2]));
            this.containerStaleIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[3]));
            this.spaceStaleIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[4]));
            this.containerLocalIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[5]));
            this.spaceStopIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[6]));
            this.transactionsIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[11]));
            this.sqlIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[7]));
            this.statisticsIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[8]));
            this.benchmarkIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[9]));
            this.securedSpaceIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray[10]));
            this.clusterIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/clusterIcon.gif"));
            this.groupIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/groupTree.gif"));
            this.spacesRootIcon = new ImageIcon(this.getClass().getResource("/image/browser/grid.gif"));
            this.user = new ImageIcon(this.getClass().getResource("/image/browser/user.gif"));
            this.clustersRootIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/clustersRoot.gif"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            try {
                super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
                ImageIcon imageIcon = this.getIcon(object);
                this.setIcon(imageIcon);
            }
            catch (LostConnectionException lostConnectionException) {
                // empty catch block
            }
            return this;
        }

        private ImageIcon getIcon(Object object) {
            Object object2;
            ImageIcon imageIcon = null;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object3 = defaultMutableTreeNode.getUserObject();
            int n2 = 0;
            if (object.equals(SpaceBrowser.this.spacesRoot)) {
                imageIcon = this.spacesRootIcon;
                return imageIcon;
            }
            if (object.equals(SpaceBrowser.this.clusterRoot)) {
                imageIcon = this.clustersRootIcon;
                return imageIcon;
            }
            if (object3 instanceof JSpaceProxyWrapper) {
                object2 = (JSpaceProxyWrapper)object3;
                object3 = ((JSpaceProxyWrapper)object2).proxy();
                n2 = ((JSpaceProxyWrapper)object2).getState();
            }
            if (object3 instanceof EditCluster) {
                imageIcon = this.clusterIcon;
            }
            if (object3 instanceof IJSpaceContainer) {
                imageIcon = this.containerTreeIcon;
            } else if (object3 instanceof IJSpace) {
                imageIcon = n2 == 1 ? this.spaceIcon : this.spaceStopIcon;
            } else if (object3 instanceof SecureSpaceNode) {
                imageIcon = this.securedSpaceIcon;
            } else if (object3 instanceof SpaceRuntimeInfo) {
                imageIcon = this.runtimeIcon;
            } else if (object3 instanceof StaleContainerService) {
                imageIcon = this.containerStaleIcon;
            } else if (object3 instanceof StaleSpaceService) {
                imageIcon = this.spaceStaleIcon;
            } else if (object3 instanceof String) {
                imageIcon = this.containerLocalIcon;
                object2 = (String)object3;
                imageIcon = SpaceBrowser.SQL_LABEL.equalsIgnoreCase((String)object2) ? this.sqlIcon : (SpaceBrowser.TRANSACTIONS_LABEL.equalsIgnoreCase((String)object2) ? this.transactionsIcon : (SpaceBrowser.STATISTICS_LABEL.equalsIgnoreCase((String)object2) ? this.statisticsIcon : (SpaceBrowser.USER_LABEL.equalsIgnoreCase((String)object2) ? this.user : (SpaceBrowser.BENCHMARK_LABEL.equalsIgnoreCase((String)object2) ? this.benchmarkIcon : (defaultMutableTreeNode.isLeaf() ? this.spaceIcon : this.groupIcon)))));
            }
            return imageIcon;
        }
    }
}

