/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.filters;

import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.core.filters.UserDefinedRole;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.FileFilterExt;
import com.j_spaces.tools.cluster.ListItemAlreadyExistsException;
import com.j_spaces.tools.filters.FiltersInfo;
import com.j_spaces.tools.filters.SortFiltersDialog;
import com.j_spaces.tools.filters.UserDetailsDialog;
import com.j_spaces.tools.spacebrowser.ProgressMonitorBar;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class FilterDetailsDialog
extends JDialog {
    private JLabel filterNameLabel = new JLabel();
    private JLabel classNameLabel = new JLabel();
    private JLabel paramUrlLabel = new JLabel();
    private JLabel permFileLabel = new JLabel();
    private JTextField paramUrlTF = new JTextField();
    private JTextField filterNameTF = new JTextField();
    private JTextField classNameTF = new JTextField();
    private JTextField permFileTF = new JTextField();
    private JCheckBox beforeReadCB = new JCheckBox();
    private JCheckBox beforeWriteCB = new JCheckBox();
    private JCheckBox beforeTakeCB = new JCheckBox();
    private JCheckBox beforeNotifyCB = new JCheckBox();
    private JCheckBox securedCB = new JCheckBox();
    private JCheckBox beforeCleanCB = new JCheckBox();
    private JCheckBox afterWriteCB = new JCheckBox();
    private JCheckBox afterRemoveCB = new JCheckBox();
    private JCheckBox afterUpdateCB = new JCheckBox();
    private JCheckBox beforeUpdateCB = new JCheckBox();
    private JCheckBox beforeGetAdminCB = new JCheckBox();
    private DefaultTableModel tableModel = new DefaultTableModelExt(FiltersInfo.tableColNames.toArray(), 0, null);
    private JTable usersTable = new JTable(this.tableModel);
    private JButton addUserButton = new JButton();
    private JButton removeRuleButton = new JButton();
    private JButton editUserButton = new JButton();
    private JButton createButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton paramUrlButton = new JButton();
    private JButton updateServerButton = new JButton();
    private JPanel centerPanel = new JPanel();
    private JPanel mainCenterPanel = new JPanel();
    private JPanel codeOperPanel = new JPanel();
    private JPanel userPermPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JPanel userPerButtonPanel = new JPanel();
    private JPanel filterNamePanel = new JPanel();
    private JPanel codeOperPan2 = new JPanel();
    private JPanel codeOperPanel3 = new JPanel();
    private JPanel codeOperInterPan = new JPanel();
    private JPanel perFilePanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JPanel innerEastButtonPanel = new JPanel();
    private JPanel innerWestButtonPanel = new JPanel();
    public JFileChooser fileChooser = new JFileChooser(".");
    public SortFiltersDialog parentDialog;
    private UserDetailsDialog userDetailsDialog;
    private List m_hiddenUsers = new Vector();

    public FilterDetailsDialog(SortFiltersDialog sortFiltersDialog, String string, boolean bl2) {
        super(sortFiltersDialog, string, bl2);
        try {
            this.parentDialog = sortFiltersDialog;
            this.userDetailsDialog = new UserDetailsDialog(this);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FilterDetailsDialog(SortFiltersDialog sortFiltersDialog) {
        this(sortFiltersDialog, "Create new Filter", true);
    }

    public void setUserDefinedRoles(UserDefinedRole[] userDefinedRoleArray) {
        this.userDetailsDialog.setUserDefinedRoles(userDefinedRoleArray);
    }

    public void updateUsers() {
        IJSpace iJSpace = null;
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = null;
        String string = null;
        try {
            iJSpace = SpaceBrowser.getInstance().getSelectedSpace();
            iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
            string = iJSpace.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, JSpaceUtilities.getStackTrace(exception), "Error", 0);
            return;
        }
        final ProgressMonitorBar progressMonitorBar = new ProgressMonitorBar(this, "Update Server", string);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    FiltersInfo filtersInfo = FilterDetailsDialog.this.createFilterInfo();
                    IDirectSpaceProxy iDirectSpaceProxy = (IDirectSpaceProxy)SpaceBrowser.getInstance().getSelectedSpace();
                    iDirectSpaceProxy.getRemoteJSpace().updateSecurityRuntime(filtersInfo);
                    progressMonitorBar.terminate();
                    JOptionPane.showMessageDialog(FilterDetailsDialog.this, iDirectSpaceProxy.getName() + " space updated successfully", "Update Server", 1);
                    FilterDetailsDialog.this.dispose();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    progressMonitorBar.terminate();
                    JOptionPane.showMessageDialog(FilterDetailsDialog.this, illegalArgumentException.getMessage(), "Message", 2);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    progressMonitorBar.terminate();
                    JOptionPane.showMessageDialog(FilterDetailsDialog.this, "Update fail: " + exception.getMessage(), "Update Server", 0);
                }
            }
        });
        progressMonitorBar.start();
        thread.start();
    }

    public void fromRolesManager_actionOK() {
        List list = this.userDetailsDialog.roleManager.getRoleNamesList();
        for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
            GenericPrincipal genericPrincipal = (GenericPrincipal)this.tableModel.getValueAt(i2, 0);
            for (int i3 = 0; i3 < genericPrincipal.userDefinedRoles.size(); ++i3) {
                String string = (String)genericPrincipal.userDefinedRoles.get(i3);
                if (list.contains(string)) continue;
                genericPrincipal.userDefinedRoles.remove(i3);
            }
        }
    }

    private void jbInit() throws Exception {
        FileFilterExt fileFilterExt = new FileFilterExt("xml", "Permission file");
        this.fileChooser.addChoosableFileFilter(fileFilterExt);
        this.mainCenterPanel.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BorderLayout());
        this.userPermPanel.setLayout(new BorderLayout());
        this.codeOperPanel.setLayout(new BoxLayout2());
        this.buttonPanel.setLayout(new FlowLayout());
        this.codeOperInterPan.setLayout(new VerticalFlowLayout());
        this.codeOperPan2.setLayout(new VerticalFlowLayout());
        this.codeOperPanel3.setLayout(new VerticalFlowLayout());
        this.filterNamePanel.setLayout(new GridBagLayout());
        this.perFilePanel.setLayout(new GridBagLayout());
        this.securedCB.setBorder(null);
        this.securedCB.setText("Secured");
        this.beforeReadCB.setText("Before Read");
        this.beforeWriteCB.setText("Before Write");
        this.beforeTakeCB.setText("Before Take");
        this.beforeNotifyCB.setText("Before Notify");
        this.paramUrlLabel.setText("Filter Parameters: ");
        this.addUserButton.setText("Add...");
        this.removeRuleButton.setText("Remove");
        this.editUserButton.setText("Edit...");
        this.createButton.setText("OK");
        this.cancelButton.setText("Cancel");
        this.updateServerButton.setText("Update Now...");
        this.filterNameLabel.setText("Filter Name:  ");
        this.classNameLabel.setText("Filter Class Name: ");
        this.paramUrlButton.setText("...");
        this.filterNamePanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.codeOperPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Code Operations"));
        this.userPermPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "User Permissions"));
        this.beforeCleanCB.setText("Before Clean");
        this.permFileLabel.setText("Permission File: ");
        this.perFilePanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.afterWriteCB.setText("After Write");
        this.afterRemoveCB.setText("After Remove");
        this.afterUpdateCB.setText("After Update");
        this.beforeUpdateCB.setText("Before Update");
        this.beforeGetAdminCB.setText("Before get Admin");
        this.mainCenterPanel.add((Component)this.centerPanel, "Center");
        this.codeOperPanel.add((Component)this.codeOperInterPan, null);
        this.codeOperPanel.add((Component)this.codeOperPanel3, null);
        this.codeOperPanel.add((Component)this.codeOperPan2, null);
        this.codeOperInterPan.add((Component)this.beforeWriteCB, null);
        this.codeOperInterPan.add((Component)this.beforeReadCB, null);
        this.codeOperInterPan.add((Component)this.beforeTakeCB, null);
        this.codeOperInterPan.add((Component)this.beforeUpdateCB, null);
        this.codeOperPan2.add((Component)this.afterWriteCB, null);
        this.codeOperPan2.add((Component)this.afterRemoveCB, null);
        this.codeOperPan2.add((Component)this.afterUpdateCB, null);
        this.codeOperPanel3.add((Component)this.beforeCleanCB, null);
        this.codeOperPanel3.add((Component)this.beforeNotifyCB, null);
        this.codeOperPanel3.add((Component)this.beforeGetAdminCB, null);
        this.centerPanel.add((Component)this.userPermPanel, "Center");
        this.userPerButtonPanel.add((Component)this.addUserButton, null);
        this.userPerButtonPanel.add((Component)this.editUserButton, null);
        this.userPerButtonPanel.add((Component)this.removeRuleButton, null);
        this.userPermPanel.add((Component)this.perFilePanel, "North");
        this.usersTable.setPreferredScrollableViewportSize(new Dimension(0, 120));
        this.userPermPanel.add((Component)new JScrollPane(this.usersTable), "Center");
        this.perFilePanel.add((Component)this.permFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 15));
        this.perFilePanel.add((Component)this.permFileTF, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 3), 0, 0));
        this.userPermPanel.add((Component)this.userPerButtonPanel, "South");
        this.mainCenterPanel.add((Component)this.filterNamePanel, "North");
        this.filterNamePanel.add((Component)this.filterNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 10));
        this.filterNamePanel.add((Component)this.filterNameTF, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.filterNamePanel.add((Component)this.classNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 10));
        this.filterNamePanel.add((Component)this.classNameTF, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.filterNamePanel.add((Component)this.paramUrlLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 10));
        this.filterNamePanel.add((Component)this.paramUrlTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.filterNamePanel.add((Component)this.paramUrlButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, -6));
        this.filterNamePanel.add((Component)this.securedCB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 25));
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add(this.innerEastButtonPanel);
        this.buttonPanel.add(this.innerWestButtonPanel);
        this.innerWestButtonPanel.add((Component)this.updateServerButton, null);
        this.innerEastButtonPanel.add((Component)this.createButton, null);
        this.innerEastButtonPanel.add((Component)this.cancelButton, null);
        this.mainPanel.add((Component)this.mainCenterPanel, "Center");
        this.centerPanel.add((Component)this.codeOperPanel, "North");
        this.getContentPane().add(this.mainPanel);
        JSpaceUtilities.setLocationRelativeTo(this, this.parentDialog);
        this.paramUrlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDetailsDialog.this.openFileChooser(FilterDetailsDialog.this.paramUrlTF, FilterDetailsDialog.this.paramUrlButton);
            }
        });
        this.filterNameTF.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (FilterDetailsDialog.this.filterNameTF.getText().trim().length() == 0) {
                    FilterDetailsDialog.this.createButton.setEnabled(false);
                } else {
                    FilterDetailsDialog.this.createButton.setEnabled(true);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDetailsDialog.this.dispose();
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!(FilterDetailsDialog.this.securedCB.isSelected() || FilterDetailsDialog.this.securedCB.isSelected() || FilterDetailsDialog.this.beforeCleanCB.isSelected() || FilterDetailsDialog.this.beforeNotifyCB.isSelected() || FilterDetailsDialog.this.beforeReadCB.isSelected() || FilterDetailsDialog.this.beforeTakeCB.isSelected() || FilterDetailsDialog.this.beforeWriteCB.isSelected() || FilterDetailsDialog.this.afterWriteCB.isSelected() || FilterDetailsDialog.this.afterRemoveCB.isSelected() || FilterDetailsDialog.this.beforeUpdateCB.isSelected() || FilterDetailsDialog.this.afterUpdateCB.isSelected() || FilterDetailsDialog.this.beforeGetAdminCB.isSelected())) {
                    JOptionPane.showConfirmDialog(FilterDetailsDialog.this, "At lease one of operation codes should be selected or the filter should be secured", "Warning", -1, 2);
                    return;
                }
                if (FilterDetailsDialog.this.classNameTF.getText().trim().length() <= 0) {
                    JOptionPane.showConfirmDialog(FilterDetailsDialog.this, "Filter classname not defined.", "Warning", -1, 2);
                    return;
                }
                try {
                    FilterDetailsDialog.this.parentDialog.setFiltersInfo(FilterDetailsDialog.this.createFilterInfo(), !FilterDetailsDialog.this.filterNameTF.isEditable());
                    FilterDetailsDialog.this.dispose();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JOptionPane.showMessageDialog(FilterDetailsDialog.this, illegalArgumentException.getMessage(), "Warning", 2);
                    return;
                }
            }
        });
        this.updateServerButton.addActionListener(new UpdateServerAL());
        this.removeRuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDetailsDialog.this.removeUserPermData();
            }
        });
        this.addUserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDetailsDialog.this.showUserDetails(false);
            }
        });
        this.editUserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDetailsDialog.this.showUserDetails(true);
            }
        });
    }

    public void showWizardData(FiltersInfo filtersInfo, boolean bl2) {
        if (filtersInfo == null) {
            return;
        }
        boolean bl3 = filtersInfo.isDefaultSecurityFilter();
        if (bl2) {
            this.setTitle("Edit Filter Definition");
            this.filterNameTF.setText(filtersInfo.filterName);
            this.filterNameTF.setEditable(false);
            this.createButton.setEnabled(true);
            this.securedCB.setEnabled(!bl3);
            this.classNameTF.setEditable(!bl3);
            JSpaceUtilities.setAWTComponentsStatus(this.codeOperPanel3, !bl3);
            JSpaceUtilities.setAWTComponentsStatus(this.codeOperPan2, !bl3);
            if (bl3) {
                this.filterNamePanel.remove(this.paramUrlLabel);
                this.filterNamePanel.remove(this.paramUrlTF);
                this.filterNamePanel.remove(this.paramUrlButton);
                this.removeOperationCodePanel();
                this.centerPanel.add((Component)this.userPermPanel, "Center");
            } else {
                this.centerPanel.add((Component)this.userPermPanel, "Center");
                this.filterNamePanel.add((Component)this.paramUrlLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 10));
                this.filterNamePanel.add((Component)this.paramUrlTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
                this.filterNamePanel.add((Component)this.paramUrlButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, -6));
                this.centerPanel.remove(this.userPermPanel);
            }
        } else {
            this.setTitle("Add new Filter Definition");
            this.filterNameTF.setText("");
            this.filterNameTF.setEditable(true);
            this.classNameTF.setEditable(true);
            this.createButton.setEnabled(false);
            this.securedCB.setEnabled(true);
            JSpaceUtilities.setAWTComponentsStatus(this.codeOperPanel3, true);
            JSpaceUtilities.setAWTComponentsStatus(this.codeOperPan2, true);
            this.centerPanel.add((Component)this.userPermPanel, "Center");
            this.filterNamePanel.add((Component)this.paramUrlLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 10));
            this.filterNamePanel.add((Component)this.paramUrlTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.filterNamePanel.add((Component)this.paramUrlButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, -6));
            this.centerPanel.remove(this.userPermPanel);
        }
        this.classNameTF.setText(filtersInfo.filterClassName);
        this.paramUrlTF.setText(filtersInfo.paramURL);
        this.permFileTF.setText(filtersInfo.paramURL);
        if (bl3) {
            this.securedCB.setSelected(true);
            this.beforeReadCB.setSelected(true);
            this.beforeTakeCB.setSelected(true);
            this.beforeWriteCB.setSelected(true);
            this.beforeUpdateCB.setSelected(true);
        } else {
            this.securedCB.setSelected(filtersInfo.secured);
            this.beforeReadCB.setSelected(filtersInfo.beforeRead);
            this.beforeTakeCB.setSelected(filtersInfo.beforeTake);
            this.beforeWriteCB.setSelected(filtersInfo.beforeWrite);
            this.beforeUpdateCB.setSelected(filtersInfo.beforeUpdate);
        }
        this.beforeCleanCB.setSelected(filtersInfo.beforeClean);
        this.beforeNotifyCB.setSelected(filtersInfo.beforeNotify);
        this.afterRemoveCB.setSelected(filtersInfo.afterRemove);
        this.afterWriteCB.setSelected(filtersInfo.afterWrite);
        this.afterUpdateCB.setSelected(filtersInfo.afterUpdate);
        this.beforeGetAdminCB.setSelected(filtersInfo.beforeGetAdmin);
        this.createButton.setVisible(!bl3);
        this.cancelButton.setVisible(!bl3);
        this.updateServerButton.setVisible(bl3);
        this.clearUserPermissionTable();
        if (filtersInfo != null && filtersInfo.usersInfo != null) {
            for (int i2 = 0; i2 < filtersInfo.usersInfo.length; ++i2) {
                this.addUserInfo(filtersInfo.usersInfo[i2], false);
            }
        }
        if (this.tableModel.getRowCount() > 0) {
            this.usersTable.setRowSelectionInterval(0, 0);
        }
        if (bl3) {
            SpaceBrowser.getInstance().replaceRightPanel(this.mainPanel);
        } else {
            this.pack();
            JSpaceUtilities.setLocationRelativeTo(this, this.parentDialog);
            this.show();
        }
    }

    private FiltersInfo createFilterInfo() throws IllegalArgumentException {
        boolean bl2 = !this.filterNameTF.isEditable();
        FiltersInfo filtersInfo = (FiltersInfo)this.parentDialog.m_filterList.getSelectedValue();
        FiltersInfo filtersInfo2 = new FiltersInfo();
        if (bl2) {
            filtersInfo2.enabled = filtersInfo.enabled;
        }
        filtersInfo2.secured = this.securedCB.isSelected();
        filtersInfo2.beforeClean = this.beforeCleanCB.isSelected();
        filtersInfo2.beforeNotify = this.beforeNotifyCB.isSelected();
        filtersInfo2.beforeRead = this.beforeReadCB.isSelected();
        filtersInfo2.beforeTake = this.beforeTakeCB.isSelected();
        filtersInfo2.beforeWrite = this.beforeWriteCB.isSelected();
        filtersInfo2.afterRemove = this.afterRemoveCB.isSelected();
        filtersInfo2.afterWrite = this.afterWriteCB.isSelected();
        filtersInfo2.afterUpdate = this.afterUpdateCB.isSelected();
        filtersInfo2.beforeUpdate = this.beforeUpdateCB.isSelected();
        filtersInfo2.beforeGetAdmin = this.beforeGetAdminCB.isSelected();
        filtersInfo2.filterName = this.filterNameTF.getText().trim();
        filtersInfo2.filterClassName = this.classNameTF.getText().trim();
        filtersInfo2.paramURL = this.paramUrlTF.getText().trim();
        if (this.classNameTF.isEditable()) {
            filtersInfo2.paramURL = this.paramUrlTF.getText().trim().length() == 0 ? "none" : this.paramUrlTF.getText();
        } else {
            filtersInfo2.paramURL = this.permFileTF.getText();
            if (filtersInfo2.paramURL.trim().length() == 0) {
                throw new IllegalArgumentException("Please define security permission file name");
            }
        }
        filtersInfo2.usersInfo = new GenericPrincipal[this.tableModel.getRowCount()];
        for (int i2 = 0; i2 < filtersInfo2.usersInfo.length; ++i2) {
            filtersInfo2.usersInfo[i2] = (GenericPrincipal)this.tableModel.getValueAt(i2, 0);
        }
        filtersInfo2.userDefinedRoles = this.userDetailsDialog.roleManager.getUserDefinedRoles();
        if (!bl2) {
            try {
                this.parentDialog.isFilterExists(filtersInfo2.filterName);
            }
            catch (ListItemAlreadyExistsException listItemAlreadyExistsException) {
                throw new IllegalArgumentException(listItemAlreadyExistsException.getMessage());
            }
        }
        return filtersInfo2;
    }

    public void addUserInfo(GenericPrincipal genericPrincipal, boolean bl2) {
        if (genericPrincipal.isHidden()) {
            this.m_hiddenUsers.add(genericPrincipal);
            return;
        }
        String string = Arrays.asList(genericPrincipal.getRoles()).toString();
        if (bl2) {
            GenericPrincipal genericPrincipal2;
            int n2;
            for (n2 = 0; n2 < this.tableModel.getRowCount() && !(genericPrincipal2 = (GenericPrincipal)this.tableModel.getValueAt(n2, 0)).getUserName().equals(genericPrincipal.getUserName()); ++n2) {
            }
            this.tableModel.setValueAt(genericPrincipal, n2, 0);
        } else {
            if (this.m_hiddenUsers.contains(genericPrincipal)) {
                throw new RuntimeException("The username: " + genericPrincipal.getUserName() + " already exists.");
            }
            for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
                GenericPrincipal genericPrincipal3 = (GenericPrincipal)this.tableModel.getValueAt(i2, 0);
                if (!genericPrincipal3.getUserName().equals(genericPrincipal.getUserName())) continue;
                throw new RuntimeException("The username: " + genericPrincipal.getUserName() + " already exists.");
            }
            this.tableModel.addRow(new Object[]{genericPrincipal});
        }
    }

    private void showUserDetails(boolean bl2) {
        if (bl2) {
            int n2 = this.usersTable.getSelectedRow();
            if (n2 == -1) {
                return;
            }
            GenericPrincipal genericPrincipal = (GenericPrincipal)this.tableModel.getValueAt(n2, 0);
            this.userDetailsDialog.clear();
            this.userDetailsDialog.setUserData(genericPrincipal);
        } else {
            this.userDetailsDialog.clear();
        }
        this.userDetailsDialog.show();
    }

    private void removeUserPermData() {
        int n2 = this.usersTable.getSelectedRow();
        if (n2 == -1) {
            return;
        }
        this.tableModel.removeRow(n2);
    }

    public void clearUserPermissionTable() {
        this.tableModel.setDataVector(new Vector(), FiltersInfo.tableColNames);
    }

    private void openFileChooser(JTextField jTextField, JButton jButton) {
        int n2 = this.fileChooser.showSaveDialog(this);
        File file = this.fileChooser.getSelectedFile();
        if (file != null && n2 == 0) {
            String string = file.getPath();
            if (!string.endsWith(".xml")) {
                string = string + ".xml";
            }
            jTextField.setText(string);
            if (jTextField.getText().trim().length() > 0) {
                jButton.setEnabled(true);
            }
        }
    }

    public void removeOperationCodePanel() {
        this.centerPanel.remove(this.codeOperPanel);
    }

    public void addOperationCodePanel() {
        this.centerPanel.add((Component)this.codeOperPanel, "North");
    }

    public class UpdateServerAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FilterDetailsDialog.this.updateUsers();
        }
    }

    private class DefaultTableModelExt
    extends DefaultTableModel {
        private DefaultTableModelExt(Object[] objectArray, int n2) {
            super(objectArray, n2);
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public /* synthetic */ DefaultTableModelExt(Object[] objectArray, int n2, 1 var4_4) {
            this(objectArray, n2);
        }
    }
}

