/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class ClusterViewMenuBar
extends JMenuBar
implements ActionListener {
    public static boolean FREEZE_ALL_MEMBERS;
    public static boolean SHOW_BACKWARD_REPLICATION;
    public static boolean SHOW_OVAL;
    public static boolean PING_MODE;
    public ClusterViewDlg m_owner;
    public ServiceManagerImpl serviceManager;
    public JMenu menuView;
    public JMenuItem menuItemRefresh;
    public JMenu menuUpdateSpeed;
    public JRadioButtonMenuItem menuItemUpdateSpeedHigh;
    public JRadioButtonMenuItem menuItemUpdateSpeedNormal;
    public JRadioButtonMenuItem menuItemUpdateSpeedLow;
    public JRadioButtonMenuItem menuItemUpdateSpeedPaused;
    public JRadioButtonMenuItem menuItemUpdateSpeedCustom;
    public JMenu menuShapeMode;
    public JRadioButtonMenuItem menuItemShapeModeOval;
    public JRadioButtonMenuItem menuItemShapeModeRect;
    public JCheckBoxMenuItem chboxMenuShowLegend;
    public JMenu menuOptions;
    public JCheckBoxMenuItem chboxMenuItemFreezeAllMembers;
    public JCheckBoxMenuItem chboxMenuItemShowBackwardReplication;
    public JCheckBoxMenuItem chboxMenuItemPingMode;
    private JMenu menuZoom;
    private JRadioButtonMenuItem menuItemZoomIn;
    private JRadioButtonMenuItem menuItemZoomOut;
    private static Logger _logger;

    public ClusterViewMenuBar(ClusterViewDlg clusterViewDlg) {
        block2: {
            this.menuView = new JMenu();
            this.menuItemRefresh = new JMenuItem();
            this.menuUpdateSpeed = new JMenu();
            this.menuItemUpdateSpeedHigh = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedNormal = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedLow = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedPaused = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedCustom = new JRadioButtonMenuItem();
            this.menuShapeMode = new JMenu();
            this.menuItemShapeModeOval = new JRadioButtonMenuItem();
            this.menuItemShapeModeRect = new JRadioButtonMenuItem();
            this.chboxMenuShowLegend = new JCheckBoxMenuItem();
            this.menuOptions = new JMenu();
            this.chboxMenuItemFreezeAllMembers = new JCheckBoxMenuItem();
            this.chboxMenuItemShowBackwardReplication = new JCheckBoxMenuItem();
            this.chboxMenuItemPingMode = new JCheckBoxMenuItem();
            this.menuZoom = new JMenu("Zoom");
            this.menuItemZoomIn = new JRadioButtonMenuItem("Zoom In");
            this.menuItemZoomOut = new JRadioButtonMenuItem("Zoom Out");
            this.m_owner = clusterViewDlg;
            SHOW_OVAL = true;
            PING_MODE = true;
            try {
                this.serviceManager = this.m_owner.getServiceManager();
                this.jbInit();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    private void jbInit() throws Exception {
        this.menuView.setText("View");
        this.menuItemRefresh.setText("Refresh Now");
        this.menuItemRefresh.addActionListener(this);
        this.menuUpdateSpeed.setText("Update Speed");
        this.menuItemUpdateSpeedHigh.setText("High");
        this.menuItemUpdateSpeedNormal.setText("Normal");
        this.menuItemUpdateSpeedLow.setText("Low");
        this.menuItemUpdateSpeedPaused.setText("Paused");
        this.menuItemUpdateSpeedCustom.setText("Custom...");
        this.menuShapeMode.setText("Shape Mode");
        this.menuItemShapeModeOval.setText("Oval");
        this.menuItemShapeModeRect.setText("Rectangle");
        this.chboxMenuShowLegend.setText("Show Legend");
        this.chboxMenuShowLegend.addActionListener(this);
        this.menuOptions.setText("Options");
        this.chboxMenuItemFreezeAllMembers.setText("Freeze All Members");
        this.chboxMenuItemFreezeAllMembers.addActionListener(this);
        this.chboxMenuItemShowBackwardReplication.setText("Backward Replication");
        this.chboxMenuItemShowBackwardReplication.addActionListener(this);
        this.chboxMenuItemPingMode.setText("Ping mode");
        this.chboxMenuItemPingMode.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.menuItemUpdateSpeedHigh);
        buttonGroup.add(this.menuItemUpdateSpeedNormal);
        buttonGroup.add(this.menuItemUpdateSpeedLow);
        buttonGroup.add(this.menuItemUpdateSpeedPaused);
        buttonGroup.add(this.menuItemUpdateSpeedCustom);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.menuItemZoomIn);
        buttonGroup2.add(this.menuItemZoomOut);
        this.menuItemZoomIn.addActionListener(this);
        this.menuItemZoomOut.addActionListener(this);
        Object object = buttonGroup.getElements();
        while (object.hasMoreElements()) {
            ((JRadioButtonMenuItem)object.nextElement()).addActionListener(this);
        }
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.menuItemShapeModeOval);
        ((ButtonGroup)object).add(this.menuItemShapeModeRect);
        Enumeration<AbstractButton> enumeration = ((ButtonGroup)object).getElements();
        while (enumeration.hasMoreElements()) {
            ((JRadioButtonMenuItem)enumeration.nextElement()).addActionListener(this);
        }
        this.menuView.add(this.menuItemRefresh);
        this.menuView.add(this.menuUpdateSpeed);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedHigh);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedNormal);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedLow);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedPaused);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedCustom);
        this.menuView.add(new JSeparator());
        this.menuView.add(this.menuShapeMode);
        this.menuShapeMode.add(this.menuItemShapeModeOval);
        this.menuShapeMode.add(this.menuItemShapeModeRect);
        this.menuView.add(this.menuZoom);
        this.menuZoom.add(this.menuItemZoomIn);
        this.menuZoom.add(this.menuItemZoomOut);
        this.menuView.add(this.menuOptions);
        this.menuView.add(new JSeparator());
        this.menuOptions.add(this.chboxMenuItemFreezeAllMembers);
        this.menuOptions.add(this.chboxMenuItemShowBackwardReplication);
        this.add(this.menuView);
        this.resetMenuToDefault();
        this.selectDefaultSpeedMenu();
    }

    public JMenu getMenu() {
        return this.menuView;
    }

    public void resetMenuToDefault() {
        this.menuItemUpdateSpeedNormal.setSelected(true);
        this.menuItemShapeModeOval.setSelected(true);
        this.chboxMenuShowLegend.setSelected(true);
        this.chboxMenuItemFreezeAllMembers.setSelected(false);
        this.chboxMenuItemShowBackwardReplication.setSelected(false);
        this.chboxMenuItemPingMode.setSelected(PING_MODE);
        this.menuItemZoomIn.setSelected(true);
    }

    public void setSelectedZoomIncreaseOption(boolean bl2) {
        this.menuItemZoomIn.setSelected(bl2);
    }

    public void selectDefaultSpeedMenu() {
        if (this.serviceManager.isPaused()) {
            this.menuItemUpdateSpeedPaused.setSelected(true);
            return;
        }
        switch (this.serviceManager.getUpdateSpeed()) {
            case 1000: {
                this.menuItemUpdateSpeedHigh.setSelected(true);
                break;
            }
            case 5000: {
                this.menuItemUpdateSpeedNormal.setSelected(true);
                break;
            }
            case 10000: {
                this.menuItemUpdateSpeedLow.setSelected(true);
                break;
            }
            default: {
                this.menuItemUpdateSpeedCustom.setSelected(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.menuItemRefresh)) {
            boolean bl2 = this.m_owner.getServiceManager().isPaused();
            this.m_owner.getServiceManager().paused(false, false);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_owner.getServiceManager().paused(bl2, false);
            return;
        }
        if (object.equals(this.chboxMenuItemFreezeAllMembers)) {
            FREEZE_ALL_MEMBERS = this.chboxMenuItemFreezeAllMembers.isSelected();
            return;
        }
        if (object.equals(this.chboxMenuItemShowBackwardReplication)) {
            SHOW_BACKWARD_REPLICATION = this.chboxMenuItemShowBackwardReplication.isSelected();
            EditCluster editCluster = this.m_owner.getCurEditCluster();
            if (editCluster != null) {
                String string = editCluster.getClusterName();
                this.m_owner.getClusterTree(string).performSelectedNodeAction();
            }
            return;
        }
        if (object.equals(this.chboxMenuItemPingMode)) {
            PING_MODE = this.chboxMenuItemPingMode.isSelected();
            return;
        }
        if (object.equals(this.menuItemUpdateSpeedHigh)) {
            this.serviceManager.setUpdateSpeed(1000);
            return;
        }
        if (object.equals(this.menuItemUpdateSpeedNormal)) {
            this.serviceManager.setUpdateSpeed(5000);
            return;
        }
        if (object.equals(this.menuItemUpdateSpeedLow)) {
            this.serviceManager.setUpdateSpeed(10000);
            return;
        }
        if (object.equals(this.menuItemUpdateSpeedPaused)) {
            this.serviceManager.paused(true, false);
            return;
        }
        if (object.equals(this.menuItemUpdateSpeedCustom)) {
            block21: {
                String string = "Try to input only integer number, not negative.";
                String string2 = JOptionPane.showInputDialog(this.m_owner, (Object)"Update speed in seconds: ");
                if (string2 != null) {
                    try {
                        int n2 = Integer.parseInt(string2);
                        if (n2 != Math.abs(n2)) {
                            JOptionPane.showMessageDialog(this.m_owner, string);
                            this.selectDefaultSpeedMenu();
                            break block21;
                        }
                        this.serviceManager.setUpdateSpeed(n2 * 1000);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this.m_owner, string);
                        this.selectDefaultSpeedMenu();
                    }
                } else {
                    this.selectDefaultSpeedMenu();
                }
            }
            return;
        }
        if (object.equals(this.menuItemShapeModeOval)) {
            SHOW_OVAL = true;
            return;
        }
        if (object.equals(this.menuItemShapeModeRect)) {
            SHOW_OVAL = false;
            return;
        }
        if (object.equals(this.menuItemZoomIn)) {
            this.m_owner.decreaseZoom();
            return;
        }
        if (object.equals(this.menuItemZoomOut)) {
            this.m_owner.increaseZoom();
            return;
        }
    }

    static {
        _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");
    }
}

