/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.j_spaces.core.EntryPacket;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryInfo;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.JSpaceProxyUtil;
import com.j_spaces.core.client.TypeTableEntry;
import com.j_spaces.core.cluster.BroadcastTarget;
import com.j_spaces.core.cluster.ClusterException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.ILoadBalance;
import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.core.cluster.LoadBalanceBroadcastInfo;
import com.j_spaces.core.cluster.LoadBalancingPolicy;
import com.j_spaces.core.cluster.MultiTargetsScatterInfo;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.ScatterTarget;
import com.j_spaces.kernel.UIDStringFactory;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.server.RMIClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.space.InternalSpaceException;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class LoadBalanceImpl
implements ILoadBalance,
Serializable {
    private static final long serialVersionUID = 1L;
    private static UIDStringFactory m_UIDFactory = new UIDStringFactory();
    private HashMap m_MemberAttributes;
    private GroupData[] m_Groups;
    private volatile int m_CurrentGropNumberRead;
    private volatile int m_CurrentGropNumberWrite;
    private volatile int m_CurrentGropNumberTake;
    private volatile int m_CurrentGropNumberNotify;
    private boolean IsFailOver;
    private ClusterPolicy m_policy;
    private Hashtable m_Indexes_FIELDS;
    private Hashtable m_Indexes_POS;
    private Hashtable m_StandByMembers;
    private JSpaceClusteredProxy m_Proxy;
    private GroupData m_GDLocalSpace;
    public int m_LocalSpaceIndex;
    private boolean m_FixedOwnership_Write;
    private boolean m_FixedOwnership_Read;
    private boolean m_FixedOwnership_Take;
    private boolean m_FixedOwnership_Notify;
    private boolean m_ApplyOwnership;
    private static final String m_NoMemberFromOwnership = "N";
    private LoadBalanceBroadcastInfo m_LBBroadcast_write;
    private MemberAttributes[][] m_LBBroadcastWrite_members;
    private LoadBalanceBroadcastInfo m_LBBroadcast_notify;
    private MemberAttributes[][] m_LBBroadcastNotify_members;
    private LoadBalanceBroadcastInfo m_LBBroadcast_take;
    private MemberAttributes[][] m_LBBroadcastTake_members;
    private LoadBalanceBroadcastInfo m_LBBroadcast_read;
    private MemberAttributes[][] m_LBBroadcastRead_members;
    private static final int POLICY_NONE = -1;
    private static final int POLICY_RR = 0;
    private static final int POLICY_FIXED_BY_HASH = 1;
    private static final int POLICY_HASH_BASED = 2;
    private static final int POLICY_WEIGHTED_RR = 3;
    private static final int POLICY_WEIGHTED_HASH = 4;
    private static final int POLICY_PRIORITY = 5;
    private static final int POLICY_LOCAL_SPACE = 6;
    public static final String RR_POLICY = "round-robin";
    public static final String FIXED_BY_HASH_POLICY = "fixed-by-hash";
    public static final String HASH_BASED_POLICY = "hash-based";
    public static final String WEIGHTED_RR_POLICY = "weighted-round-robin";
    public static final String WEIGHTED_HASH_POLICY = "weighted-hash";
    public static final String PRIORITY_POLICY = "select-by-priority";
    public static final String LOCAL_SPACE_POLICY = "local-space";
    private static final int NO_HASH = -2;
    private static final int STANDBY_WAIT_TIME = 1000;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");

    public List init(ClusterPolicy clusterPolicy, IJSpace iJSpace) throws ClusterException {
        Serializable serializable;
        int n2;
        this.m_policy = clusterPolicy;
        this.m_LocalSpaceIndex = -1;
        this.m_MemberAttributes = new HashMap();
        this.m_Indexes_FIELDS = new Hashtable();
        this.m_Indexes_POS = new Hashtable();
        this.m_StandByMembers = new Hashtable();
        this.m_Proxy = (JSpaceClusteredProxy)iJSpace;
        this.m_ApplyOwnership = clusterPolicy.m_LoadBalancingPolicy.m_ApplyOwnership;
        if (clusterPolicy.m_FailOverPolicy != null) {
            this.IsFailOver = true;
        }
        boolean bl2 = false;
        if (clusterPolicy.m_FailOverPolicy != null && clusterPolicy.m_FailOverPolicy.alterGroup != null && clusterPolicy.m_FailOverPolicy.alterGroup.length > 0) {
            bl2 = true;
        }
        int n3 = bl2 ? clusterPolicy.m_FailOverPolicy.alterGroup.length + 1 : 1;
        this.m_Groups = new GroupData[n3];
        GroupData groupData = new GroupData();
        groupData.m_IsPrimary = true;
        groupData = this.BuildGroupData(clusterPolicy.m_LoadBalancingPolicy, clusterPolicy.m_LoadBalancingPolicy.loadBalanceGroupMembersNames, groupData);
        this.markFixedOwnerships(groupData);
        this.m_Groups[0] = groupData;
        for (n2 = 0; n2 < clusterPolicy.m_LoadBalancingPolicy.loadBalanceGroupMembersNames.size(); ++n2) {
            serializable = new MemberAttributes();
            serializable.m_GroupData = groupData;
            serializable.m_Index = n2;
            String string = (String)clusterPolicy.m_LoadBalancingPolicy.loadBalanceGroupMembersNames.get(n2);
            this.m_MemberAttributes.put(string, serializable);
            if (this.m_GDLocalSpace != null || !string.equals(clusterPolicy.m_ClusterGroupMember)) continue;
            this.m_GDLocalSpace = groupData;
            groupData.m_LocalSpaceHere = true;
            this.m_LocalSpaceIndex = n2;
        }
        if (this.IsFailOver) {
            this.setFO(clusterPolicy.m_FailOverPolicy, groupData, clusterPolicy.m_ClusterGroupMember);
        }
        serializable = new ArrayList();
        serializable = this.buildPreopenedMembers((ArrayList)serializable, this.m_Groups[0].m_ReadInfo, this.m_Groups[0], this.m_Groups[0].m_ReadFO);
        serializable = this.buildPreopenedMembers((ArrayList)serializable, this.m_Groups[0].m_WriteInfo, this.m_Groups[0], this.m_Groups[0].m_WriteFO);
        serializable = this.buildPreopenedMembers((ArrayList)serializable, this.m_Groups[0].m_TakeInfo, this.m_Groups[0], this.m_Groups[0].m_TakeFO);
        if (!bl2) {
            this.build_broadcast_objects();
            return serializable;
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            groupData = new GroupData();
            this.m_Groups[i2] = groupData = this.BuildGroupData(clusterPolicy.m_FailOverPolicy.m_AlternateLB[i2 - 1], clusterPolicy.m_FailOverPolicy.m_AlternateGroupMemberNames[i2 - 1], groupData);
            this.markFixedOwnerships(groupData);
            for (n2 = 0; n2 < clusterPolicy.m_FailOverPolicy.m_AlternateGroupMemberNames[i2 - 1].size(); ++n2) {
                MemberAttributes memberAttributes = new MemberAttributes();
                memberAttributes.m_GroupData = groupData;
                memberAttributes.m_Index = n2;
                String string = (String)clusterPolicy.m_FailOverPolicy.m_AlternateGroupMemberNames[i2 - 1].get(n2);
                this.m_MemberAttributes.put(string, memberAttributes);
                if (this.m_GDLocalSpace != null || !string.equals(clusterPolicy.m_ClusterGroupMember)) continue;
                this.m_GDLocalSpace = groupData;
                groupData.m_LocalSpaceHere = true;
                this.m_LocalSpaceIndex = n2;
            }
            if (clusterPolicy.m_FailOverPolicy.m_AlternateFO[i2 - 1] == null) continue;
            this.setFO(clusterPolicy.m_FailOverPolicy.m_AlternateFO[i2 - 1], groupData, this.m_policy.m_ClusterGroupMember);
        }
        this.build_broadcast_objects();
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object selectMemberForOperation(int n2, int n3, Object object, String string, ScatterTarget scatterTarget, BroadcastTarget broadcastTarget, String string2) {
        String string3 = this.selectMemberForOperationMain(n2, n3, object, string, scatterTarget, broadcastTarget, string2);
        if (string3 == null && !this.m_StandByMembers.isEmpty()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Hashtable hashtable = this.m_StandByMembers;
            synchronized (hashtable) {
                Iterator iterator = this.m_StandByMembers.keySet().iterator();
                String string4 = null;
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    hashMap.put(string4, string4);
                    iterator.remove();
                    this.setMemberAvailability(string4, true, false);
                }
                if (!hashMap.isEmpty()) {
                    string3 = this.selectMemberForOperationMain(n2, n3, object, string, scatterTarget, broadcastTarget, string2);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(Thread.currentThread().getName() + " LoadBalance-" + this.m_policy.m_ClusterGroupMember + " --> primary space under election, waiting " + 1000 + " ms...");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(Thread.currentThread().getName() + " LoadBalance-" + this.m_policy.m_ClusterGroupMember + " --> selectMemberForOperation() result: " + string3 + " operation: " + n2);
        }
        return string3;
    }

    private String selectMemberForOperationMain(int n2, int n3, Object object, String string, ScatterTarget scatterTarget, BroadcastTarget broadcastTarget, String string2) {
        int n4;
        OperationData operationData = null;
        OperationData operationData2 = null;
        FOOperationData fOOperationData = null;
        FOOperationData fOOperationData2 = null;
        String string3 = null;
        int n5 = 0;
        switch (n3) {
            case 2: {
                n5 = this.m_CurrentGropNumberRead;
                operationData = this.m_Groups[n5].m_ReadInfo;
                operationData2 = this.m_Groups[0].m_ReadInfo;
                fOOperationData = this.m_Groups[n5].m_ReadFO;
                fOOperationData2 = this.m_Groups[0].m_ReadFO;
                break;
            }
            case 1: {
                n5 = this.m_CurrentGropNumberWrite;
                operationData = this.m_Groups[n5].m_WriteInfo;
                operationData2 = this.m_Groups[0].m_WriteInfo;
                fOOperationData = this.m_Groups[n5].m_WriteFO;
                fOOperationData2 = this.m_Groups[0].m_WriteFO;
                break;
            }
            case 4: {
                n5 = this.m_CurrentGropNumberTake;
                operationData = this.m_Groups[n5].m_TakeInfo;
                operationData2 = this.m_Groups[0].m_TakeInfo;
                fOOperationData = this.m_Groups[n5].m_TakeFO;
                fOOperationData2 = this.m_Groups[0].m_TakeFO;
                break;
            }
            case 6: {
                n5 = this.m_CurrentGropNumberNotify;
                operationData = this.m_Groups[n5].m_NotifyInfo;
                operationData2 = this.m_Groups[0].m_NotifyInfo;
                fOOperationData = this.m_Groups[n5].m_NotifyFO;
                fOOperationData2 = this.m_Groups[0].m_NotifyFO;
            }
        }
        if (broadcastTarget != null) {
            return this.selectBroadcastMember(n2, n3, object, operationData, fOOperationData, string, broadcastTarget);
        }
        if (this.m_ApplyOwnership && object != null) {
            int n6 = n4 = n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5 || n2 == 12 || n2 == 13 ? 1 : 0;
            if (n4 != 0) {
                string3 = this.selectMemberIfUidOwnership(n2, n3, object, operationData, fOOperationData, string, scatterTarget);
                if (string3 == m_NoMemberFromOwnership) {
                    string3 = null;
                } else {
                    return string3;
                }
            }
        }
        if ((string3 = this.GetNextFromPolicy(n2, n3, object, operationData2, fOOperationData2, 0, string, scatterTarget, broadcastTarget, string2)) != null) {
            return string3;
        }
        if (fOOperationData2 != null && fOOperationData2.m_DoNotUseAlternateGroups) {
            return null;
        }
        if (!operationData.m_Group.m_IsPrimary && (string3 = this.GetNextFromPolicy(n2, n3, object, operationData, fOOperationData, n5, null, scatterTarget, broadcastTarget, string2)) != null) {
            return string3;
        }
        if (this.m_Groups.length == 1) {
            return null;
        }
        for (n4 = 1; n4 < this.m_Groups.length; ++n4) {
            GroupData groupData = this.m_Groups[n4];
            switch (n3) {
                case 2: {
                    operationData = groupData.m_ReadInfo;
                    fOOperationData = groupData.m_ReadFO;
                    break;
                }
                case 1: {
                    operationData = groupData.m_WriteInfo;
                    fOOperationData = groupData.m_WriteFO;
                    break;
                }
                case 4: {
                    operationData = groupData.m_TakeInfo;
                    fOOperationData = groupData.m_TakeFO;
                    break;
                }
                case 6: {
                    operationData = groupData.m_NotifyInfo;
                    fOOperationData = groupData.m_NotifyFO;
                }
            }
            string3 = this.GetNextFromPolicy(n2, n3, object, operationData, fOOperationData, n4, null, scatterTarget, broadcastTarget, string2);
            if (string3 == null) continue;
            return string3;
        }
        return null;
    }

    public boolean isFixedOwnershipLBPolicy(int n2) {
        switch (n2) {
            case 1: {
                return this.m_FixedOwnership_Write;
            }
            case 2: {
                return this.m_FixedOwnership_Read;
            }
            case 4: {
                return this.m_FixedOwnership_Take;
            }
            case 6: {
                return this.m_FixedOwnership_Notify;
            }
        }
        return false;
    }

    public MultiTargetsScatterInfo getMultiObjectsScatterInfo(int n2, int n3, Object object, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.m_ApplyOwnership) {
            bl3 = n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5 || n2 == 12 || n2 == 13;
        }
        OperationData operationData = null;
        FOOperationData fOOperationData = null;
        switch (n3) {
            case 2: {
                operationData = this.m_Groups[0].m_ReadInfo;
                fOOperationData = this.m_Groups[0].m_ReadFO;
                break;
            }
            case 1: {
                operationData = this.m_Groups[0].m_WriteInfo;
                fOOperationData = this.m_Groups[0].m_WriteFO;
                break;
            }
            case 4: {
                operationData = this.m_Groups[0].m_TakeInfo;
                fOOperationData = this.m_Groups[0].m_TakeFO;
                break;
            }
            case 6: {
                operationData = this.m_Groups[0].m_NotifyInfo;
                fOOperationData = this.m_Groups[0].m_NotifyFO;
            }
        }
        boolean bl5 = bl3 && (object instanceof String[] || n2 == 12 || n2 == 13);
        boolean bl6 = bl4 = operationData.m_PolicyType == 2 && !bl5;
        if (!bl4 && !bl3) {
            return null;
        }
        GroupData groupData = operationData.m_Group;
        int[] nArray = new int[groupData.m_Availability.length];
        int[] nArray2 = new int[groupData.m_Availability.length];
        boolean[] blArray = new boolean[groupData.m_Availability.length];
        Entry[] entryArray = null;
        EntryPacket[] entryPacketArray = null;
        String[] stringArray = null;
        int n4 = 0;
        if (object instanceof Entry[]) {
            entryArray = (Entry[])object;
            n4 = entryArray.length;
        } else if (object instanceof EntryPacket[]) {
            entryPacketArray = (EntryPacket[])object;
            n4 = entryPacketArray.length;
        } else {
            stringArray = (String[])object;
            n4 = stringArray.length;
        }
        MultiTargetsScatterInfo multiTargetsScatterInfo = new MultiTargetsScatterInfo(n4, bl4, bl2);
        int n5 = 0;
        int[] nArray3 = multiTargetsScatterInfo.get_mTargetsForObjects();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6;
            int n7;
            EntryPacket entryPacket = null;
            Entry entry = null;
            Object object2 = null;
            if (entryArray != null) {
                entry = entryArray[i2];
            } else if (entryPacketArray != null) {
                entryPacket = entryPacketArray[i2];
            } else if (bl3) {
                object2 = stringArray[i2];
            }
            if (entry == null && entryPacket == null && object2 == null) {
                throw new RuntimeException("hash-based/uid-based load-balancing and null entry/template or null UID was given.");
            }
            String string = null;
            String string2 = null;
            if (bl3) {
                if (object2 == null) {
                    if (entry != null && !bl4 && entry instanceof EntrySnapshot) {
                        if (bl5) {
                            throw new RuntimeException("uid-based load-balancing snapshot entry/template given.");
                        }
                        return null;
                    }
                    Object object3 = object2 = entry != null ? this.getUidFromEntry(entry) : this.getUidFromEntry(entryPacket);
                    if (object2 == null && !bl4) {
                        if (bl5) {
                            throw new RuntimeException("uid-based load-balancing is used but UID was not given.");
                        }
                        return null;
                    }
                }
                if (object2 != null && (string = this.getSpaceNameFromUid(object2)) == null) {
                    if (!bl4) {
                        return null;
                    }
                    bl3 = false;
                }
                if (string != null) {
                    string2 = this.checkUidMemberAvaliability(string, n2, n3, null);
                    if (string2 == null) {
                        multiTargetsScatterInfo.getTargets().clear();
                        return multiTargetsScatterInfo;
                    }
                    MemberAttributes memberAttributes = (MemberAttributes)this.m_MemberAttributes.get(string2);
                    if (blArray[memberAttributes.m_Index]) {
                        n7 = nArray[memberAttributes.m_Index];
                    } else if (!bl2 || n5 == 0) {
                        n7 = multiTargetsScatterInfo.getTargets().size();
                        blArray[memberAttributes.m_Index] = true;
                        nArray[memberAttributes.m_Index] = n7;
                        multiTargetsScatterInfo.setTargetName(string2);
                        ++n5;
                    } else {
                        n7 = -1;
                    }
                    if (n7 != -1) {
                        int n8 = n7;
                        nArray2[n8] = nArray2[n8] + 1;
                    }
                    nArray3[i2] = n7;
                    continue;
                }
            }
            if ((n6 = this.selectMemberHashBased_pos(n2, n3, entry != null ? entry : entryPacket, operationData, fOOperationData, true, multiTargetsScatterInfo.get_mHashCodes(), i2, false)) == -1) {
                multiTargetsScatterInfo.getTargets().clear();
                return multiTargetsScatterInfo;
            }
            if (blArray[n6]) {
                n7 = nArray[n6];
            } else if (!bl2 || n5 == 0) {
                n7 = multiTargetsScatterInfo.getTargets().size();
                blArray[n6] = true;
                nArray[n6] = n7;
                string2 = (String)groupData.m_GroupMembers.get(n6);
                multiTargetsScatterInfo.setTargetName(string2);
                ++n5;
            } else {
                n7 = -1;
            }
            if (n7 != -1) {
                int n9 = n7;
                nArray2[n9] = nArray2[n9] + 1;
            }
            nArray3[i2] = n7;
        }
        int[] nArray4 = new int[multiTargetsScatterInfo.getTargets().size()];
        System.arraycopy(nArray2, 0, nArray4, 0, multiTargetsScatterInfo.getTargets().size());
        multiTargetsScatterInfo.set_mNumObjectsPerTargets(nArray4);
        return multiTargetsScatterInfo;
    }

    public LoadBalanceBroadcastInfo getLoadBalanceBroadcastInfo(int n2) {
        switch (n2) {
            case 2: {
                return this.m_LBBroadcast_read;
            }
            case 4: {
                return this.m_LBBroadcast_take;
            }
            case 6: {
                return this.m_LBBroadcast_notify;
            }
            case 1: {
                return this.m_LBBroadcast_write;
            }
        }
        throw new InternalSpaceException("invalid operation type :" + n2);
    }

    public LoadBalanceBroadcastInfo setLoadBalanceBroadcastCondition(LoadBalancingPolicy.BroadcastCondition broadcastCondition, int n2) {
        LoadBalanceBroadcastInfo loadBalanceBroadcastInfo = null;
        switch (n2) {
            case 2: {
                this.m_LBBroadcast_read = loadBalanceBroadcastInfo = new LoadBalanceBroadcastInfo(this.m_LBBroadcast_read.getTargetGroups(), broadcastCondition);
                break;
            }
            case 4: {
                this.m_LBBroadcast_take = loadBalanceBroadcastInfo = new LoadBalanceBroadcastInfo(this.m_LBBroadcast_take.getTargetGroups(), broadcastCondition);
                break;
            }
            case 6: {
                if (this.m_LBBroadcast_notify == null) {
                    throw new RuntimeException("LoadBalanceImpl:setLoadBalanceBroadcastCondition not supported for notify operation");
                }
                this.m_LBBroadcast_notify = loadBalanceBroadcastInfo = new LoadBalanceBroadcastInfo(this.m_LBBroadcast_notify.getTargetGroups(), broadcastCondition);
                break;
            }
            case 1: {
                if (this.m_LBBroadcast_write == null) {
                    throw new RuntimeException("LoadBalanceImpl:setLoadBalanceBroadcastCondition not supported for write operation");
                }
                this.m_LBBroadcast_write = loadBalanceBroadcastInfo = new LoadBalanceBroadcastInfo(this.m_LBBroadcast_write.getTargetGroups(), broadcastCondition);
                break;
            }
            default: {
                throw new InternalSpaceException("invalid operation type :" + n2);
            }
        }
        return loadBalanceBroadcastInfo;
    }

    public int getPartitionOfMember(String string, int n2) {
        int n3;
        OperationData operationData = null;
        FOOperationData fOOperationData = null;
        switch (n2) {
            case 2: {
                operationData = this.m_Groups[0].m_ReadInfo;
                fOOperationData = this.m_Groups[0].m_ReadFO;
                break;
            }
            case 1: {
                operationData = this.m_Groups[0].m_WriteInfo;
                fOOperationData = this.m_Groups[0].m_WriteFO;
                break;
            }
            case 4: {
                operationData = this.m_Groups[0].m_TakeInfo;
                fOOperationData = this.m_Groups[0].m_TakeFO;
                break;
            }
            case 6: {
                operationData = this.m_Groups[0].m_NotifyInfo;
                fOOperationData = this.m_Groups[0].m_NotifyFO;
            }
        }
        if (operationData.m_PolicyType != 2) {
            return -1;
        }
        MemberAttributes memberAttributes = (MemberAttributes)this.m_MemberAttributes.get(string);
        int n4 = memberAttributes.m_Index;
        if (fOOperationData != null) {
            if (fOOperationData.m_PolicyType != 1) {
                return -1;
            }
        } else {
            return n4;
        }
        for (n3 = 0; n3 < fOOperationData.m_ActiveMembers.length; ++n3) {
            if (fOOperationData.m_ActiveMembers[n3] != n4) continue;
            return n3;
        }
        for (n3 = 0; n3 < fOOperationData.m_ActiveMembers.length; ++n3) {
            List list = fOOperationData.m_Backups[fOOperationData.m_ActiveMembers[n3]];
            if (list == null) continue;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string2 = (String)list.get(i2);
                if (!string2.equals(string)) continue;
                return n3;
            }
        }
        return -1;
    }

    public int getPartitionForKey(Object object, int n2) {
        OperationData operationData = null;
        FOOperationData fOOperationData = null;
        switch (n2) {
            case 2: {
                operationData = this.m_Groups[0].m_ReadInfo;
                fOOperationData = this.m_Groups[0].m_ReadFO;
                break;
            }
            case 1: {
                operationData = this.m_Groups[0].m_WriteInfo;
                fOOperationData = this.m_Groups[0].m_WriteFO;
                break;
            }
            case 4: {
                operationData = this.m_Groups[0].m_TakeInfo;
                fOOperationData = this.m_Groups[0].m_TakeFO;
                break;
            }
            case 6: {
                operationData = this.m_Groups[0].m_NotifyInfo;
                fOOperationData = this.m_Groups[0].m_NotifyFO;
            }
        }
        if (operationData.m_PolicyType != 2) {
            return -1;
        }
        if (fOOperationData != null && fOOperationData.m_PolicyType != 1) {
            return -1;
        }
        return fOOperationData != null ? Math.abs(object.hashCode()) % fOOperationData.m_ActiveMembers.length : Math.abs(object.hashCode()) % operationData.m_Group.m_Availability.length;
    }

    private String GetNextFromPolicy(int n2, int n3, Object object, OperationData operationData, FOOperationData fOOperationData, int n4, String string, ScatterTarget scatterTarget, BroadcastTarget broadcastTarget, String string2) {
        String string3 = null;
        switch (operationData.m_PolicyType) {
            case -1: {
                string3 = this.selectAnyMember(operationData, fOOperationData, string);
                break;
            }
            case 0: {
                string3 = this.selectMemberRoundRobin(operationData, fOOperationData, string);
                break;
            }
            case 1: {
                string3 = this.selectMemberFixedByHASH(n2, object, operationData, fOOperationData, string);
                break;
            }
            case 2: {
                string3 = this.selectMemberHashBased(n2, n3, object, operationData, fOOperationData, string, scatterTarget, string2);
                break;
            }
            case 4: {
                string3 = this.selectMemberWeightedHash(n2, object, operationData, fOOperationData, string);
                break;
            }
            case 3: {
                string3 = this.selectMemberWeightedRR(n2, object, operationData, fOOperationData, string);
                break;
            }
            case 5: {
                string3 = this.selectMemberPriority(operationData, fOOperationData, string);
                break;
            }
            case 6: {
                string3 = this.selectMemberLocalSpace(operationData, fOOperationData, string, n3);
            }
        }
        if (string3 != null && string3 != string2) {
            switch (n3) {
                case 2: {
                    this.m_CurrentGropNumberRead = n4;
                    break;
                }
                case 1: {
                    this.m_CurrentGropNumberWrite = n4;
                    break;
                }
                case 4: {
                    this.m_CurrentGropNumberTake = n4;
                    break;
                }
                case 6: {
                    this.m_CurrentGropNumberNotify = n4;
                }
            }
        }
        return string3;
    }

    private String selectAnyMember(OperationData operationData, FOOperationData fOOperationData, String string) {
        int n2;
        int n3;
        if (string != null) {
            return string;
        }
        GroupData groupData = operationData.m_Group;
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        if ((n3 = operationData.m_AtomicIndex.get()) == -1) {
            if (groupData.m_IsPrimary) {
                MemberAttributes memberAttributes = (MemberAttributes)this.m_MemberAttributes.get(this.m_policy.m_ClusterGroupMember);
                n3 = memberAttributes.m_Index;
            } else {
                n3 = 0;
            }
            operationData.m_AtomicIndex.compareAndSet(-1, n3);
            n3 = operationData.m_AtomicIndex.get();
        }
        if (groupData.m_Availability[n3]) {
            return (String)groupData.m_GroupMembers.get(n3);
        }
        boolean bl3 = false;
        for (n2 = 0; n2 < groupData.m_Availability.length; ++n2) {
            if (bl2 && fOOperationData.m_OnlyBackups[n2]) {
                bl3 = true;
                continue;
            }
            if (!groupData.m_Availability[n2]) continue;
            return (String)groupData.m_GroupMembers.get(n2);
        }
        if (bl3) {
            for (n2 = 0; n2 < groupData.m_Availability.length; ++n2) {
                if (!groupData.m_Availability[n2]) continue;
                return (String)groupData.m_GroupMembers.get(n2);
            }
        }
        return null;
    }

    private String selectMemberRoundRobin(OperationData operationData, FOOperationData fOOperationData, String string) {
        int n2;
        if (string != null) {
            return string;
        }
        GroupData groupData = operationData.m_Group;
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        if ((n2 = operationData.m_AtomicIndex.incrementAndGet()) < 0) {
            n2 = 0;
            operationData.m_AtomicIndex.set(0);
        }
        int n3 = n2;
        if (!bl2) {
            int n4 = 0;
            while (n4 < groupData.m_Availability.length) {
                int n5;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (groupData.m_Availability[n5 = n3 % groupData.m_Availability.length]) {
                    if (n2 != n3) {
                        operationData.m_AtomicIndex.set(n3);
                    }
                    return (String)groupData.m_GroupMembers.get(n5);
                }
                if (!this.IsFailOver || fOOperationData == null) {
                    return null;
                }
                if (fOOperationData.m_PolicyType == 2) {
                    return null;
                }
                ++n4;
                ++n3;
            }
        } else {
            int n6 = 0;
            while (n6 < fOOperationData.m_ActiveMembers.length) {
                String string2;
                if (n3 >= fOOperationData.m_ActiveMembers.length) {
                    n3 = 0;
                }
                if ((string2 = this.selectFailToBkupByBase(n3, operationData, fOOperationData)) != null) {
                    if (n2 != n3) {
                        operationData.m_AtomicIndex.set(n3);
                    }
                    return string2;
                }
                ++n6;
                ++n3;
            }
        }
        return null;
    }

    private String selectFailToBkupByBase(int n2, OperationData operationData, FOOperationData fOOperationData) {
        GroupData groupData = operationData.m_Group;
        int n3 = this.selectFailToBkupByBase_pos(n2, operationData, fOOperationData);
        return n3 == -1 ? null : (String)groupData.m_GroupMembers.get(n3);
    }

    private int selectFailToBkupByBase_pos(int n2, OperationData operationData, FOOperationData fOOperationData) {
        GroupData groupData = operationData.m_Group;
        int n3 = n2 % fOOperationData.m_ActiveMembers.length;
        int n4 = fOOperationData.m_ActiveMembers[n3];
        if (groupData.m_Availability[n4]) {
            return n4;
        }
        return this.getBackupForMember_pos(n4, operationData, fOOperationData);
    }

    private String getBackupForMember(int n2, OperationData operationData, FOOperationData fOOperationData) {
        GroupData groupData = operationData.m_Group;
        int n3 = this.getBackupForMember_pos(n2, operationData, fOOperationData);
        return n3 == -1 ? null : (String)groupData.m_GroupMembers.get(n3);
    }

    private int getBackupForMember_pos(int n2, OperationData operationData, FOOperationData fOOperationData) {
        GroupData groupData = operationData.m_Group;
        List list = fOOperationData.m_Backups[n2];
        if (list == null) {
            return -1;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            MemberAttributes memberAttributes = (MemberAttributes)this.m_MemberAttributes.get(string);
            if (!groupData.m_Availability[memberAttributes.m_Index]) continue;
            return memberAttributes.m_Index;
        }
        return -1;
    }

    private String selectMemberFixedByHASH(int n2, Object object, OperationData operationData, FOOperationData fOOperationData, String string) {
        int n3;
        int n4;
        int n5;
        if (string != null) {
            return string;
        }
        GroupData groupData = operationData.m_Group;
        Entry entry = null;
        EntryPacket entryPacket = null;
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        if ((n5 = operationData.m_AtomicIndex.get()) == -1) {
            if (n2 == 9) {
                if (object instanceof Entry[]) {
                    entry = ((Entry[])object)[0];
                } else {
                    entryPacket = ((EntryPacket[])object)[0];
                }
            } else if (object instanceof Entry) {
                entry = (Entry)object;
            } else {
                entryPacket = (EntryPacket)object;
            }
            n4 = 0;
            if (entry != null) {
                n4 = entry.hashCode();
            } else if (entryPacket != null) {
                n4 = entryPacket.hashCode();
            }
            if (n4 < 0) {
                n4 = -n4;
            }
            n5 = !bl2 ? n4 % groupData.m_Availability.length : n4 % fOOperationData.m_ActiveMembers.length;
            operationData.m_AtomicIndex.compareAndSet(-1, n5);
            n5 = operationData.m_AtomicIndex.get();
        }
        if (groupData.m_Availability[n5]) {
            return (String)groupData.m_GroupMembers.get(n5);
        }
        if (!this.IsFailOver || fOOperationData == null) {
            return null;
        }
        if (fOOperationData != null && fOOperationData.m_PolicyType == 2) {
            return null;
        }
        n4 = 0;
        for (n3 = 0; n3 < groupData.m_Availability.length; ++n3) {
            if (bl2 && fOOperationData.m_OnlyBackups[n3]) {
                n4 = 1;
                continue;
            }
            if (!groupData.m_Availability[n3]) continue;
            return (String)groupData.m_GroupMembers.get(n3);
        }
        if (n4 != 0) {
            for (n3 = 0; n3 < groupData.m_Availability.length; ++n3) {
                if (!groupData.m_Availability[n3]) continue;
                return (String)groupData.m_GroupMembers.get(n3);
            }
        }
        return null;
    }

    private String selectMemberHashBased(int n2, int n3, Object object, OperationData operationData, FOOperationData fOOperationData, String string, ScatterTarget scatterTarget, String string2) {
        if ((n2 == 9 || n2 == 13) && scatterTarget != null) {
            return this.selectMemberHashBasedMultiple(object, operationData, fOOperationData, scatterTarget);
        }
        GroupData groupData = operationData.m_Group;
        boolean bl2 = string2 != null;
        int n4 = this.selectMemberHashBased_pos(n2, n3, object, operationData, fOOperationData, false, null, -1, bl2);
        if (bl2 && n4 == -2) {
            return string2;
        }
        return n4 == -1 ? null : (String)groupData.m_GroupMembers.get(n4);
    }

    private int selectMemberHashBased_pos(int n2, int n3, Object object, OperationData operationData, FOOperationData fOOperationData, boolean bl2, int[] nArray, int n4, boolean bl3) {
        GroupData groupData = operationData.m_Group;
        Entry entry = null;
        EntryPacket entryPacket = null;
        int n5 = 0;
        boolean bl4 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl4 = true;
        }
        if (!(n2 != 9 && n2 != 13 || bl2)) {
            if (object instanceof Entry[]) {
                entry = ((Entry[])object)[0];
            } else {
                entryPacket = ((EntryPacket[])object)[0];
            }
        } else if (object instanceof Entry) {
            entry = (Entry)object;
        } else {
            entryPacket = (EntryPacket)object;
        }
        if (entry == null && entryPacket == null) {
            throw new RuntimeException("hash-based load-balancing and null entry/template given.");
        }
        int n6 = 0;
        if (entry != null) {
            n6 = this.getFieldBasedHashValueAbs(entry, bl3, n2, n3);
            if (bl3 && n6 == -2) {
                return n6;
            }
        } else {
            n6 = Math.abs(entryPacket.hashCode());
        }
        if (nArray != null) {
            nArray[n4] = n6;
        }
        if (!bl4) {
            int n7;
            n5 = n6 % groupData.m_Availability.length;
            if (groupData.m_Availability[n5]) {
                return n5;
            }
            if (!this.IsFailOver || fOOperationData == null) {
                return -1;
            }
            if (fOOperationData != null && fOOperationData.m_PolicyType == 2) {
                return -1;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(groupData.m_Availability.length);
            int n8 = 0;
            for (n7 = 0; n7 < groupData.m_Availability.length; ++n7) {
                if (!groupData.m_Availability[n7]) continue;
                arrayList.add(_Integer.valueOf(n7));
                ++n8;
            }
            if (n8 == 0) {
                return -1;
            }
            while (n8 > 0) {
                n5 = n8 > 1 ? n6 % n8 : 0;
                n7 = (Integer)arrayList.remove(n5);
                if (groupData.m_Availability[n7]) {
                    return n7;
                }
                --n8;
            }
        } else {
            return this.selectFailToBkupByBase_pos(n6, operationData, fOOperationData);
        }
        return -1;
    }

    private String selectMemberHashBasedMultiple(Object object, OperationData operationData, FOOperationData fOOperationData, ScatterTarget scatterTarget) {
        int n2;
        int n3;
        GroupData groupData = operationData.m_Group;
        int n4 = 0;
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        boolean bl3 = false;
        boolean[] blArray = scatterTarget.getAlreadySent();
        boolean[] blArray2 = scatterTarget.getNeedSend();
        int[] nArray = scatterTarget.getHashCodes();
        if (blArray2 == null) {
            bl3 = true;
            blArray2 = new boolean[blArray.length];
        }
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (blArray[i2]) continue;
            n3 = 0;
            n3 = nArray[i2];
            n2 = bl2 ? n3 % fOOperationData.m_ActiveMembers.length : n3 % groupData.m_Availability.length;
            if (n5 == -1) {
                n5 = i2;
                n6 = n2;
                n7 = n3;
                blArray2[i2] = true;
                ++n8;
                continue;
            }
            if (n2 == n6) {
                ++n8;
                blArray2[i2] = true;
                continue;
            }
            blArray2[i2] = false;
        }
        if (n5 == -1) {
            throw new RuntimeException("internal error- no batch of entries selected.");
        }
        if (bl3) {
            scatterTarget.setNeedSend(blArray2);
        }
        if (!bl2) {
            int n9;
            n4 = n6;
            if (groupData.m_Availability[n4]) {
                return (String)groupData.m_GroupMembers.get(n4);
            }
            if (!this.IsFailOver || fOOperationData == null) {
                return null;
            }
            if (fOOperationData.m_PolicyType == 2) {
                return null;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(groupData.m_Availability.length);
            n3 = 0;
            for (n9 = 0; n9 < groupData.m_Availability.length; ++n9) {
                if (!groupData.m_Availability[n9]) continue;
                arrayList.add(_Integer.valueOf(n9));
                ++n3;
            }
            if (n3 == 0) {
                return null;
            }
            while (n3 > 0) {
                n4 = n3 > 1 ? n7 % n3 : 0;
                n2 = (Integer)arrayList.remove(n4);
                if (groupData.m_Availability[n2]) {
                    for (n9 = 0; n9 < blArray.length; ++n9) {
                        if (blArray[n9] || blArray2[n9] && nArray[n9] % n3 == n4) continue;
                        blArray2[n9] = n3 == 1 || nArray[n9] % groupData.m_Availability.length == n2;
                    }
                    return (String)groupData.m_GroupMembers.get(n2);
                }
                --n3;
            }
        } else {
            return this.selectFailToBkupByBase(n7, operationData, fOOperationData);
        }
        return null;
    }

    private int getFieldBasedHashValueAbs(Entry entry, boolean bl2, int n2, int n3) {
        String string = null;
        TypeTableEntry typeTableEntry = null;
        Object object = null;
        String string2 = null;
        if (entry instanceof EntrySnapshot) {
            EntrySnapshot entrySnapshot = (EntrySnapshot)entry;
            EntryPacket entryPacket = entrySnapshot.getEntryPacket();
            string = entryPacket.m_ClassName;
            typeTableEntry = this.m_Proxy._proxyUtil.isTypeInfo(entryPacket.m_ClassName);
            if (typeTableEntry.m_FieldsNames.length == 0) {
                if (bl2) {
                    return -2;
                }
                throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "object with no fields-no explicit index defined"));
            }
            object = entryPacket.m_FieldsValues[typeTableEntry.m_FirstDefinedIndex];
            if (object == null) {
                if (bl2) {
                    return -2;
                }
                throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "NULL value in indexed field " + typeTableEntry.m_FieldsNames[typeTableEntry.m_FirstDefinedIndex]));
            }
            return Math.abs(object.hashCode());
        }
        if (!(entry instanceof ExternalEntry)) {
            String string3;
            Class<?> clazz = entry.getClass();
            string = string3 = clazz.getName();
            Field field = (Field)this.m_Indexes_FIELDS.get(string3);
            if (field == null) {
                typeTableEntry = this.m_Proxy._proxyUtil.isTypeInfo(string3);
                if (typeTableEntry == null) {
                    typeTableEntry = this.m_Proxy._proxyUtil.getTypeInfo(string3, RMIClassLoader.getClassAnnotation(clazz), entry);
                }
                if (typeTableEntry.m_FieldsNames.length == 0) {
                    if (bl2) {
                        return -2;
                    }
                    throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "object with no fields-no explicit index defined"));
                }
                field = typeTableEntry.m_Fields[typeTableEntry.m_FirstDefinedIndex];
                this.m_Indexes_FIELDS.put(string3, field);
                this.m_Indexes_POS.put(string3, new Integer(typeTableEntry.m_FirstDefinedIndex));
            }
            string2 = field.getName();
            try {
                object = field.get(entry);
            }
            catch (Exception exception) {
                throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "Got exception while accessing field " + field.getName() + " : " + exception.toString()), exception);
            }
        }
        ExternalEntry externalEntry = (ExternalEntry)entry;
        string = externalEntry.m_ClassName;
        if (externalEntry.m_FieldsValues == null || externalEntry.m_FieldsValues.length == 0) {
            if (bl2) {
                return -2;
            }
            throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "no explicit index defined"));
        }
        Integer n4 = (Integer)this.m_Indexes_POS.get(externalEntry.m_ClassName);
        if (n4 == null) {
            typeTableEntry = this.m_Proxy._proxyUtil.isTypeInfo(externalEntry.m_ClassName);
            if (typeTableEntry == null) {
                typeTableEntry = this.m_Proxy._proxyUtil.getTypeInfo(externalEntry.m_ClassName, null, entry);
            }
            if (typeTableEntry.m_FieldsNames.length == 0) {
                if (bl2) {
                    return -2;
                }
                throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "object with no fields-no explicit index defined"));
            }
            n4 = new Integer(typeTableEntry.m_FirstDefinedIndex);
            this.m_Indexes_POS.put(externalEntry.m_ClassName, n4);
        }
        try {
            int n5 = -1;
            String[] stringArray = externalEntry.m_FieldsNames;
            if (stringArray == null) {
                n5 = n4;
            } else {
                if (typeTableEntry == null) {
                    typeTableEntry = this.m_Proxy._proxyUtil.isTypeInfo(externalEntry.m_ClassName);
                }
                if (stringArray.length != typeTableEntry.m_FieldsNames.length) {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (!stringArray[i2].equals(typeTableEntry.m_FieldsNames[typeTableEntry.m_FirstDefinedIndex])) continue;
                        n5 = i2;
                        break;
                    }
                } else {
                    n5 = n4;
                }
            }
            if (n5 >= 0) {
                if (externalEntry.m_FieldsValues == null) {
                    if (bl2) {
                        return -2;
                    }
                    object = new Integer(0);
                } else {
                    if (bl2 && externalEntry.m_ExtendedMatchCodes != null && externalEntry.m_ExtendedMatchCodes[n5] != 0) {
                        return -2;
                    }
                    object = externalEntry.m_FieldsValues[n5];
                    string2 = externalEntry.m_FieldsNames[n5];
                }
            }
        }
        catch (Exception exception) {
            if (typeTableEntry != null && typeTableEntry.m_FieldsNames != null && typeTableEntry.m_FieldsNames.length > 0) {
                throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "Got exception while accessing field " + typeTableEntry.m_FieldsNames[typeTableEntry.m_FirstDefinedIndex] + " : " + exception.toString()), exception);
            }
            if (bl2) {
                return -2;
            }
            throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "Exception occured - no indexed field is defined for this class : " + exception.toString()), exception);
        }
        if (object == null) {
            if (bl2) {
                return -2;
            }
            throw new RuntimeException(this.formatException(string, this.getUidFromEntry(entry), n2, n3, "NULL value in indexed field '" + string2 + "' is not permitted."));
        }
        return Math.abs(object.hashCode());
    }

    private String formatException(String string, Object object, int n2, int n3, String string2) {
        String string3 = null;
        String string4 = LoadBalancingPolicy.getOperationName(n2);
        LoadBalanceBroadcastInfo loadBalanceBroadcastInfo = this.getLoadBalanceBroadcastInfo(n3);
        String string5 = null;
        string5 = loadBalanceBroadcastInfo != null ? loadBalanceBroadcastInfo.getDependsOn().name() : this.m_policy.m_LoadBalancingPolicy.m_DefaultPolicy.m_BroadcastCondition.name();
        string3 = object != null ? "Object UID: [" + object + "], class: [" + string + "], operation: [" + string4 + "], load-balancing: [hash-based], Broadcast mode: [" + string5 + "]" : "Class: " + string + " , operation: " + string4 + " , load-balancing: hash-based, Broadcast mode: " + string5;
        return string3 + " , problem: " + string2;
    }

    private String selectMemberWeightedHash(int n2, Object object, OperationData operationData, FOOperationData fOOperationData, String string) {
        if (string != null) {
            return string;
        }
        Entry entry = null;
        EntryPacket entryPacket = null;
        if (n2 == 9) {
            if (object instanceof Entry[]) {
                entry = ((Entry[])object)[0];
            } else {
                entryPacket = ((EntryPacket[])object)[0];
            }
        } else if (object instanceof Entry) {
            entry = (Entry)object;
        } else {
            entryPacket = (EntryPacket)object;
        }
        int n3 = 0;
        if (entry != null) {
            n3 = entry.hashCode();
        } else if (entryPacket != null) {
            n3 = entryPacket.hashCode();
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        return this.selectMemberByWeigth(operationData, n3, fOOperationData);
    }

    private String selectMemberWeightedRR(int n2, Object object, OperationData operationData, FOOperationData fOOperationData, String string) {
        if (string != null) {
            return string;
        }
        int n3 = operationData.m_AtomicIndex.incrementAndGet();
        if (n3 < 0) {
            n3 = 0;
            operationData.m_AtomicIndex.set(0);
        }
        return this.selectMemberByWeigth(operationData, n3, fOOperationData);
    }

    private String selectMemberByWeigth(OperationData operationData, int n2, FOOperationData fOOperationData) {
        GroupData groupData = operationData.m_Group;
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        block0: while (true) {
            int n3;
            int n4;
            Weights weights;
            if (operationData.m_NeedRefresh) {
                weights = new Weights(groupData.m_GroupMembers.size());
                weights.m_WeigthsSum = 0;
                weights.m_Weights = operationData.m_weights.m_Weights;
                for (n4 = 0; n4 < groupData.m_GroupMembers.size(); ++n4) {
                    weights.m_WeightSteps[n4] = 0;
                    if (!groupData.m_Availability[n4] || weights.m_Weights[n4] <= 0) continue;
                    n3 = 1;
                    if (bl2 && fOOperationData.m_OnlyBackups[n4]) {
                        n3 = 0;
                    }
                    if (n3 == 0) continue;
                    weights.m_WeigthsSum += weights.m_Weights[n4];
                    weights.m_WeightSteps[n4] = weights.m_WeigthsSum;
                }
                operationData.m_weights = weights;
                operationData.m_NeedRefresh = false;
            }
            weights = operationData.m_weights;
            if (weights.m_WeigthsSum == 0) {
                return null;
            }
            n3 = n2 % weights.m_WeigthsSum;
            n4 = 0;
            while (true) {
                if (n4 >= groupData.m_GroupMembers.size()) continue block0;
                if (!(weights.m_WeightSteps[n4] == 0 || weights.m_WeightSteps[n4] <= n3 || bl2 && fOOperationData.m_OnlyBackups[n4])) {
                    if (groupData.m_Availability[n4]) {
                        return (String)groupData.m_GroupMembers.get(n4);
                    }
                    if (!this.IsFailOver || fOOperationData == null) {
                        return null;
                    }
                    if (fOOperationData.m_PolicyType == 2) {
                        return null;
                    }
                    if (!bl2) {
                        operationData.m_NeedRefresh = true;
                        continue block0;
                    }
                    return this.getBackupForMember(n4, operationData, fOOperationData);
                }
                ++n4;
            }
            break;
        }
    }

    private String selectMemberPriority(OperationData operationData, FOOperationData fOOperationData, String string) {
        if (string != null) {
            return string;
        }
        GroupData groupData = operationData.m_Group;
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        if (operationData.m_Priorities.isEmpty()) {
            return null;
        }
        Iterator iterator = operationData.m_Priorities.iterator();
        while (iterator.hasNext()) {
            int n2 = -((Integer)iterator.next()).intValue();
            if (bl2 && fOOperationData.m_OnlyBackups[n2 %= 1000]) continue;
            if (groupData.m_Availability[n2]) {
                return (String)groupData.m_GroupMembers.get(n2);
            }
            if (!this.IsFailOver || fOOperationData == null) {
                return null;
            }
            if (fOOperationData != null && fOOperationData.m_PolicyType == 2) {
                return null;
            }
            if (!bl2) continue;
            return this.getBackupForMember(n2, operationData, fOOperationData);
        }
        return null;
    }

    private String selectBroadcastMember(int n2, int n3, Object object, OperationData operationData, FOOperationData fOOperationData, String string, BroadcastTarget broadcastTarget) {
        MemberAttributes[][] memberAttributesArray;
        switch (n3) {
            case 2: {
                memberAttributesArray = this.m_LBBroadcastRead_members;
                break;
            }
            case 4: {
                memberAttributesArray = this.m_LBBroadcastTake_members;
                break;
            }
            case 6: {
                memberAttributesArray = this.m_LBBroadcastNotify_members;
                break;
            }
            case 1: {
                memberAttributesArray = this.m_LBBroadcastWrite_members;
                break;
            }
            default: {
                throw new InternalSpaceException("Invalid operation type: " + n3);
            }
        }
        ArrayList arrayList = broadcastTarget.getTargetGroup();
        int n4 = arrayList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            MemberAttributes memberAttributes = memberAttributesArray[broadcastTarget.getTargetNumber()][i2];
            if (!memberAttributes.m_GroupData.m_Availability[memberAttributes.m_Index]) continue;
            return (String)arrayList.get(i2);
        }
        return null;
    }

    private String selectMemberIfUidOwnership(int n2, int n3, Object object, OperationData operationData, FOOperationData fOOperationData, String string, ScatterTarget scatterTarget) {
        if (object instanceof EntrySnapshot) {
            return m_NoMemberFromOwnership;
        }
        if (n2 == 13) {
            return this.selectMemberIfUidOwnershipMultiple(n2, n3, object, operationData, fOOperationData, string, scatterTarget);
        }
        Object object2 = this.getUidFromEntry(object);
        if (object2 == null) {
            return m_NoMemberFromOwnership;
        }
        String string2 = this.getSpaceNameFromUid(object2);
        if (string2 == null) {
            return m_NoMemberFromOwnership;
        }
        return this.checkUidMemberAvaliability(string2, n2, n3, string);
    }

    private String checkUidMemberAvaliability(String string, int n2, int n3, String string2) {
        MemberAttributes memberAttributes = (MemberAttributes)this.m_MemberAttributes.get(string);
        GroupData groupData = memberAttributes.m_GroupData;
        if (groupData.m_Availability[memberAttributes.m_Index]) {
            return string;
        }
        OperationData operationData = groupData.m_WriteInfo;
        FOOperationData fOOperationData = groupData.m_WriteFO;
        if (!this.IsFailOver || fOOperationData == null) {
            return null;
        }
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        if (!bl2) {
            if (fOOperationData.m_PolicyType == 2) {
                return null;
            }
            if (string2 != null && !string2.equals(string)) {
                MemberAttributes memberAttributes2 = (MemberAttributes)this.m_MemberAttributes.get(string2);
                GroupData groupData2 = memberAttributes2.m_GroupData;
                if (groupData2.m_Availability[memberAttributes2.m_Index]) {
                    return string2;
                }
            }
            for (int i2 = 0; i2 < groupData.m_Availability.length; ++i2) {
                if (!groupData.m_Availability[i2]) continue;
                return (String)groupData.m_GroupMembers.get(i2);
            }
            return null;
        }
        if (!fOOperationData.m_OnlyBackups[memberAttributes.m_Index]) {
            return this.getBackupForMember(memberAttributes.m_Index, operationData, fOOperationData);
        }
        return this.getBackupForMember(fOOperationData.m_MasterForBackupOnly[memberAttributes.m_Index], operationData, fOOperationData);
    }

    private Object getUidFromEntry(Object object) {
        EntryInfo entryInfo;
        String string;
        if (object instanceof ExternalEntry) {
            ExternalEntry externalEntry = (ExternalEntry)object;
            return externalEntry.m_UID;
        }
        if (object instanceof EntryPacket) {
            EntryPacket entryPacket = (EntryPacket)object;
            return entryPacket.m_EntryUID;
        }
        Entry entry = (Entry)object;
        TypeTableEntry typeTableEntry = null;
        Class<?> clazz = entry.getClass();
        String string2 = clazz.getName();
        typeTableEntry = this.m_Proxy._proxyUtil.isTypeInfo(string2);
        if (typeTableEntry == null) {
            typeTableEntry = this.m_Proxy._proxyUtil.getTypeInfo(string2, RMIClassLoader.getClassAnnotation(clazz), entry);
        }
        if ((string = JSpaceProxyUtil.getEntryUid(entry, typeTableEntry)) == null && (entryInfo = JSpaceProxyUtil.getEntryInfo(entry, typeTableEntry)) != null) {
            string = entryInfo.m_UID;
        }
        return string;
    }

    private String getSpaceNameFromUid(Object object) {
        String string = (String)object;
        return m_UIDFactory.getSpaceNameFromUID(string);
    }

    private String selectMemberIfUidOwnershipMultiple(int n2, int n3, Object object, OperationData operationData, FOOperationData fOOperationData, String string, ScatterTarget scatterTarget) {
        boolean bl2 = false;
        Entry[] entryArray = null;
        EntryPacket[] entryPacketArray = null;
        boolean[] blArray = scatterTarget.getAlreadySent();
        boolean[] blArray2 = scatterTarget.getNeedSend();
        if (blArray2 == null) {
            bl2 = true;
            blArray2 = new boolean[blArray.length];
        }
        if (object instanceof Entry[]) {
            entryArray = (Entry[])object;
        } else {
            entryPacketArray = (EntryPacket[])object;
        }
        int n4 = -1;
        String string2 = null;
        int n5 = 0;
        boolean bl3 = false;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (blArray[i2] || !bl2 && !blArray2[i2]) continue;
            Object object2 = null;
            object2 = entryArray != null ? this.getUidFromEntry(entryArray[i2]) : this.getUidFromEntry(entryPacketArray[i2]);
            if (object2 == null) {
                bl3 = true;
                continue;
            }
            String string3 = this.getSpaceNameFromUid(object2);
            if (string3 == null) {
                bl3 = true;
                continue;
            }
            String string4 = this.checkUidMemberAvaliability(string3, n2, n3, string);
            if (string4 == null) {
                return null;
            }
            if (n4 == -1) {
                n4 = i2;
                string2 = string4;
                blArray2[i2] = true;
                ++n5;
                continue;
            }
            if (string4.equals(string2)) {
                ++n5;
                blArray2[i2] = true;
                continue;
            }
            blArray2[i2] = false;
        }
        if (n4 == -1) {
            if (bl3) {
                return m_NoMemberFromOwnership;
            }
            throw new InternalSpaceException("no batch of entries selected.");
        }
        if (bl2 && n5 < blArray2.length) {
            scatterTarget.setNeedSend(blArray2);
        }
        return string2;
    }

    private String selectMemberLocalSpace(OperationData operationData, FOOperationData fOOperationData, String string, int n2) {
        if (string != null) {
            return string;
        }
        GroupData groupData = operationData.m_Group;
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        if (this.m_GDLocalSpace == null) {
            throw new RuntimeException("The load-balance policy is Localspace but localSpace= " + this.m_policy.m_ClusterGroupMember + " and is not in any load-balance group");
        }
        if (this.m_GDLocalSpace != groupData) {
            if (groupData.m_IsPrimary) {
                throw new RuntimeException("load-balance conflict: policy is Localspace but localSpace= " + this.m_policy.m_ClusterGroupMember + " and is not defined in primary load-balance group");
            }
            return null;
        }
        String string2 = this.m_policy.m_ClusterGroupMember;
        int n3 = this.m_LocalSpaceIndex;
        if (fOOperationData != null && fOOperationData.m_ActualLocalSpace != null) {
            string2 = fOOperationData.m_ActualLocalSpace;
        }
        if (groupData.m_Availability[n3]) {
            return string2;
        }
        if (bl2) {
            return this.getBackupForMember(n3, operationData, fOOperationData);
        }
        if (fOOperationData != null && fOOperationData.m_PolicyType == 2) {
            return null;
        }
        for (int i2 = 0; i2 < groupData.m_Availability.length; ++i2) {
            if (!groupData.m_Availability[i2]) continue;
            return (String)groupData.m_GroupMembers.get(i2);
        }
        return null;
    }

    public void setMemberAvailability(String string, boolean bl2, boolean bl3) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(Thread.currentThread().getName() + " LoadBalance-" + this.m_policy.m_ClusterGroupMember + " --> setMemberAvailability() memberName: " + string + " isAlive: " + bl2 + " isStandby: " + bl3);
        }
        MemberAttributes memberAttributes = (MemberAttributes)this.m_MemberAttributes.get(string);
        if (memberAttributes.m_GroupData.m_Availability[memberAttributes.m_Index] == bl2) {
            return;
        }
        if (bl2 && this.m_StandByMembers.containsKey(string)) {
            return;
        }
        if (!bl2 && bl3) {
            this.m_StandByMembers.put(string, string);
        }
        memberAttributes.m_GroupData.m_Availability[memberAttributes.m_Index] = bl2;
        memberAttributes.m_GroupData.m_NotifyInfo.m_NeedRefresh = true;
        memberAttributes.m_GroupData.m_ReadInfo.m_NeedRefresh = true;
        memberAttributes.m_GroupData.m_WriteInfo.m_NeedRefresh = true;
        memberAttributes.m_GroupData.m_TakeInfo.m_NeedRefresh = true;
    }

    private GroupData BuildGroupData(LoadBalancingPolicy loadBalancingPolicy, List list, GroupData groupData) throws ClusterException {
        groupData.m_GroupMembers = list;
        int n2 = list.size();
        groupData.m_Availability = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            groupData.m_Availability[i2] = true;
        }
        if (loadBalancingPolicy == null) {
            OperationData operationData = new OperationData(groupData, 0);
            operationData.m_PolicyType = -1;
            groupData.m_ReadInfo = operationData;
            groupData.m_WriteInfo = operationData;
            groupData.m_NotifyInfo = operationData;
            groupData.m_TakeInfo = operationData;
            return groupData;
        }
        OperationData operationData = null;
        if (loadBalancingPolicy.m_DefaultPolicy != null) {
            operationData = new OperationData(groupData, 0);
            operationData = this.BuildOperationData(loadBalancingPolicy.m_DefaultPolicy, operationData, groupData);
        }
        groupData.m_DefaultInfo = operationData;
        OperationData operationData2 = null;
        operationData2 = new OperationData(groupData, 2);
        if (loadBalancingPolicy.m_ReadOperationsPolicy != null) {
            groupData.m_ReadInfo = this.BuildOperationData(loadBalancingPolicy.m_ReadOperationsPolicy, operationData2, groupData);
        } else if (loadBalancingPolicy.m_DefaultPolicy != null) {
            groupData.m_ReadInfo = this.BuildOperationData(loadBalancingPolicy.m_DefaultPolicy, operationData2, groupData);
        }
        operationData2 = new OperationData(groupData, 1);
        if (loadBalancingPolicy.m_WriteOperationsPolicy != null) {
            groupData.m_WriteInfo = this.BuildOperationData(loadBalancingPolicy.m_WriteOperationsPolicy, operationData2, groupData);
        } else if (loadBalancingPolicy.m_DefaultPolicy != null) {
            groupData.m_WriteInfo = this.BuildOperationData(loadBalancingPolicy.m_DefaultPolicy, operationData2, groupData);
        }
        operationData2 = new OperationData(groupData, 4);
        if (loadBalancingPolicy.m_TakeOperationsPolicy != null) {
            groupData.m_TakeInfo = this.BuildOperationData(loadBalancingPolicy.m_TakeOperationsPolicy, operationData2, groupData);
        } else if (loadBalancingPolicy.m_DefaultPolicy != null) {
            groupData.m_TakeInfo = this.BuildOperationData(loadBalancingPolicy.m_DefaultPolicy, operationData2, groupData);
        }
        operationData2 = new OperationData(groupData, 6);
        if (loadBalancingPolicy.m_NotifyOperationsPolicy != null) {
            groupData.m_NotifyInfo = this.BuildOperationData(loadBalancingPolicy.m_NotifyOperationsPolicy, operationData2, groupData);
        } else if (loadBalancingPolicy.m_DefaultPolicy != null) {
            groupData.m_NotifyInfo = this.BuildOperationData(loadBalancingPolicy.m_DefaultPolicy, operationData2, groupData);
        }
        return groupData;
    }

    public OperationData BuildOperationData(LoadBalancingPolicy.LoadBalancingPolicyDescription loadBalancingPolicyDescription, OperationData operationData, GroupData groupData) throws ClusterException {
        Serializable serializable;
        Object object;
        int n2;
        if (loadBalancingPolicyDescription.m_PolicyType.equals(RR_POLICY)) {
            operationData.m_PolicyType = 0;
        } else if (loadBalancingPolicyDescription.m_PolicyType.equals(FIXED_BY_HASH_POLICY)) {
            operationData.m_PolicyType = 1;
        } else if (loadBalancingPolicyDescription.m_PolicyType.equals(HASH_BASED_POLICY)) {
            operationData.m_PolicyType = 2;
        } else if (loadBalancingPolicyDescription.m_PolicyType.equals(WEIGHTED_RR_POLICY)) {
            operationData.m_PolicyType = 3;
        } else if (loadBalancingPolicyDescription.m_PolicyType.equals(WEIGHTED_HASH_POLICY)) {
            operationData.m_PolicyType = 4;
        } else if (loadBalancingPolicyDescription.m_PolicyType.equals(PRIORITY_POLICY)) {
            operationData.m_PolicyType = 5;
        } else if (loadBalancingPolicyDescription.m_PolicyType.equals(LOCAL_SPACE_POLICY)) {
            operationData.m_PolicyType = 6;
        } else {
            throw new ClusterException(" invalid load balincing policy = " + loadBalancingPolicyDescription.m_PolicyType);
        }
        int n3 = groupData.m_GroupMembers.size();
        if (operationData.m_PolicyType == 3 || operationData.m_PolicyType == 4) {
            Weights weights = operationData.m_weights = new Weights(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = 0;
                object = null;
                serializable = (Properties)this.m_policy.m_ClusterMembersProperties.get(groupData.m_GroupMembers.get(n2));
                if (serializable != null && (object = serializable.getProperty("weight", null)) != null) {
                    try {
                        n4 = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {
                        throw new ClusterException(" invalid weigth for in general params member " + (String)groupData.m_GroupMembers.get(n2));
                    }
                }
                if (loadBalancingPolicyDescription.m_Properties != null && (object = loadBalancingPolicyDescription.m_Properties.getProperty((String)groupData.m_GroupMembers.get(n2), null)) != null) {
                    try {
                        n4 = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {
                        throw new ClusterException(" invalid policy-level weigth param member " + (String)groupData.m_GroupMembers.get(n2));
                    }
                }
                int n5 = weights.m_Weights[n2] = n4 > 0 ? n4 : 0;
                if (n4 > 0) {
                    weights.m_WeigthsSum += n4;
                    weights.m_WeightSteps[n2] = weights.m_WeigthsSum;
                    continue;
                }
                weights.m_WeightSteps[n2] = 0;
            }
        }
        if (operationData.m_PolicyType == 5) {
            operationData.m_Priorities = new TreeSet();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = 0;
                String string = null;
                object = (Properties)this.m_policy.m_ClusterMembersProperties.get(groupData.m_GroupMembers.get(i2));
                if (object != null && (string = ((Properties)object).getProperty("priority", null)) != null) {
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        throw new ClusterException(" invalid priority for general params member " + (String)groupData.m_GroupMembers.get(i2));
                    }
                }
                if (loadBalancingPolicyDescription.m_Properties != null && (string = loadBalancingPolicyDescription.m_Properties.getProperty((String)groupData.m_GroupMembers.get(i2), null)) != null) {
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        throw new ClusterException(" invalid policy-level priority param for  member " + (String)groupData.m_GroupMembers.get(i2));
                    }
                }
                if (n2 <= 0) continue;
                serializable = new Integer(-i2 - n2 * 1000);
                operationData.m_Priorities.add(serializable);
            }
        }
        return operationData;
    }

    public ArrayList buildPreopenedMembers(ArrayList arrayList, OperationData operationData, GroupData groupData, FOOperationData fOOperationData) {
        int n2 = groupData.m_GroupMembers.size();
        boolean bl2 = false;
        if (fOOperationData != null && fOOperationData.m_PolicyType == 1) {
            bl2 = true;
        }
        switch (operationData.m_PolicyType) {
            case -1: 
            case 1: 
            case 6: {
                break;
            }
            case 0: 
            case 2: {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (bl2 && fOOperationData.m_OnlyBackups[i2]) continue;
                    arrayList.add(groupData.m_GroupMembers.get(i2));
                }
                break;
            }
            case 3: 
            case 4: {
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (operationData.m_weights.m_Weights[i3] <= 0 || bl2 && fOOperationData.m_OnlyBackups[i3]) continue;
                    arrayList.add(groupData.m_GroupMembers.get(i3));
                }
                break;
            }
            case 5: {
                if (operationData.m_Priorities.isEmpty()) break;
                int n3 = -((Integer)operationData.m_Priorities.first()).intValue();
                if (bl2 && fOOperationData.m_OnlyBackups[n3 %= 1000]) break;
                arrayList.add(groupData.m_GroupMembers.get(n3));
            }
        }
        return arrayList;
    }

    private void setFO(FailOverPolicy failOverPolicy, GroupData groupData, String string) {
        FOOperationData fOOperationData = null;
        FOOperationData fOOperationData2 = null;
        if (failOverPolicy.m_DefaultFOPolicy != null) {
            fOOperationData = new FOOperationData(this, failOverPolicy.m_DefaultFOPolicy, groupData, 0, this.m_MemberAttributes, string);
        }
        groupData.m_DefaultFO = fOOperationData;
        groupData.m_ReadFO = failOverPolicy.m_ReadFOPolicy != null ? (fOOperationData2 = new FOOperationData(this, failOverPolicy.m_ReadFOPolicy, groupData, 2, this.m_MemberAttributes, string)) : fOOperationData;
        groupData.m_WriteFO = failOverPolicy.m_WriteFOPolicy != null ? (fOOperationData2 = new FOOperationData(this, failOverPolicy.m_WriteFOPolicy, groupData, 1, this.m_MemberAttributes, string)) : fOOperationData;
        groupData.m_TakeFO = failOverPolicy.m_TakeFOPolicy != null ? (fOOperationData2 = new FOOperationData(this, failOverPolicy.m_TakeFOPolicy, groupData, 4, this.m_MemberAttributes, string)) : fOOperationData;
        groupData.m_NotifyFO = failOverPolicy.m_NotifyFOPolicy != null ? (fOOperationData2 = new FOOperationData(this, failOverPolicy.m_NotifyFOPolicy, groupData, 6, this.m_MemberAttributes, string)) : fOOperationData;
        groupData.m_NotifyInfo.m_NeedRefresh = true;
        groupData.m_ReadInfo.m_NeedRefresh = true;
        groupData.m_WriteInfo.m_NeedRefresh = true;
        groupData.m_TakeInfo.m_NeedRefresh = true;
    }

    private void markFixedOwnerships(GroupData groupData) {
        if (groupData.m_WriteInfo.m_PolicyType == 2) {
            this.m_FixedOwnership_Write = true;
        }
        if (groupData.m_ReadInfo.m_PolicyType == 2) {
            this.m_FixedOwnership_Read = true;
        }
        if (groupData.m_TakeInfo.m_PolicyType == 2) {
            this.m_FixedOwnership_Take = true;
        }
        if (groupData.m_NotifyInfo.m_PolicyType == 2) {
            this.m_FixedOwnership_Notify = true;
        }
    }

    private void build_broadcast_objects() {
        if (!this.m_policy.m_LoadBalancingPolicy.m_DisableMultiSpacesBroadcast) {
            this.buildBroadCast(2);
            this.buildBroadCast(4);
            this.buildBroadCast(6);
        }
    }

    private void buildBroadCast(int n2) {
        Object object;
        Object object2;
        Serializable serializable;
        ArrayList arrayList = new ArrayList();
        boolean bl2 = this.m_policy.m_ReplicationGroups != null && !this.m_policy.m_ReplicationGroups.isEmpty();
        HashMap hashMap = null;
        if (bl2) {
            hashMap = new HashMap();
        }
        for (int i2 = 0; i2 < this.m_Groups.length; ++i2) {
            ArrayList<Object> arrayList2;
            int n3;
            serializable = this.m_Groups[i2];
            object2 = null;
            switch (n2) {
                case 2: {
                    object2 = serializable.m_ReadFO;
                    break;
                }
                case 4: {
                    object2 = serializable.m_TakeFO;
                    break;
                }
                case 1: {
                    object2 = serializable.m_WriteFO;
                    break;
                }
                case 6: {
                    object2 = serializable.m_NotifyFO;
                }
            }
            boolean bl3 = false;
            if (object2 != null && ((FOOperationData)object2).m_PolicyType == 1) {
                bl3 = true;
            }
            boolean bl4 = false;
            for (n3 = 0; n3 < serializable.m_GroupMembers.size(); ++n3) {
                if (bl3 && ((FOOperationData)object2).m_OnlyBackups[n3]) {
                    bl4 = true;
                    continue;
                }
                object = (String)serializable.m_GroupMembers.get(n3);
                arrayList2 = new ArrayList<Object>();
                arrayList2.add(object);
                arrayList.add(arrayList2);
                if (!bl2) continue;
                hashMap.put(object, arrayList2);
            }
            if (!bl4) continue;
            for (n3 = 0; n3 < ((FOOperationData)object2).m_OnlyBackups.length; ++n3) {
                if (!((FOOperationData)object2).m_OnlyBackups[n3]) continue;
                object = (String)serializable.m_GroupMembers.get(n3);
                arrayList2 = new ArrayList();
                arrayList2.add(object);
                arrayList.add(arrayList2);
                if (!bl2) continue;
                hashMap.put(object, arrayList2);
            }
        }
        if (bl2) {
            Iterator iterator = this.m_policy.m_ReplicationGroups.iterator();
            while (iterator.hasNext()) {
                serializable = (ReplicationPolicy)iterator.next();
                if (n2 == 6 && !((ReplicationPolicy)serializable).m_ReplicateNotifyTemplates) continue;
                object2 = null;
                String string = null;
                Iterator iterator2 = ((ReplicationPolicy)serializable).m_ReplicationGroupMembersNames.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    object = (ArrayList)hashMap.get(string2);
                    if (object == null) continue;
                    if (string == null) {
                        string = string2;
                        object2 = object;
                        continue;
                    }
                    ((ArrayList)object2).add(string2);
                    arrayList.remove(object);
                }
            }
        }
        MemberAttributes[][] memberAttributesArrayArray = new MemberAttributes[arrayList.size()][];
        int n4 = 0;
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            ArrayList arrayList3 = (ArrayList)object2.next();
            memberAttributesArrayArray[n4] = new MemberAttributes[arrayList3.size()];
            int n5 = 0;
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                memberAttributesArrayArray[n4][n5++] = (MemberAttributes)this.m_MemberAttributes.get(object);
            }
            ++n4;
        }
        object2 = null;
        switch (n2) {
            case 2: {
                this.m_LBBroadcastRead_members = memberAttributesArrayArray;
                object2 = this.m_policy.m_LoadBalancingPolicy.m_ReadOperationsPolicy != null ? this.m_policy.m_LoadBalancingPolicy.m_ReadOperationsPolicy : this.m_policy.m_LoadBalancingPolicy.m_DefaultPolicy;
                this.m_LBBroadcast_read = new LoadBalanceBroadcastInfo(arrayList, ((LoadBalancingPolicy.LoadBalancingPolicyDescription)object2).m_BroadcastCondition);
                break;
            }
            case 4: {
                this.m_LBBroadcastTake_members = memberAttributesArrayArray;
                object2 = this.m_policy.m_LoadBalancingPolicy.m_TakeOperationsPolicy != null ? this.m_policy.m_LoadBalancingPolicy.m_TakeOperationsPolicy : this.m_policy.m_LoadBalancingPolicy.m_DefaultPolicy;
                this.m_LBBroadcast_take = new LoadBalanceBroadcastInfo(arrayList, ((LoadBalancingPolicy.LoadBalancingPolicyDescription)object2).m_BroadcastCondition);
                break;
            }
            case 1: {
                this.m_LBBroadcastWrite_members = memberAttributesArrayArray;
                object2 = this.m_policy.m_LoadBalancingPolicy.m_WriteOperationsPolicy != null ? this.m_policy.m_LoadBalancingPolicy.m_WriteOperationsPolicy : this.m_policy.m_LoadBalancingPolicy.m_DefaultPolicy;
                this.m_LBBroadcast_write = new LoadBalanceBroadcastInfo(arrayList, ((LoadBalancingPolicy.LoadBalancingPolicyDescription)object2).m_BroadcastCondition);
                break;
            }
            case 6: {
                this.m_LBBroadcastNotify_members = memberAttributesArrayArray;
                object2 = this.m_policy.m_LoadBalancingPolicy.m_NotifyOperationsPolicy != null ? this.m_policy.m_LoadBalancingPolicy.m_NotifyOperationsPolicy : this.m_policy.m_LoadBalancingPolicy.m_DefaultPolicy;
                this.m_LBBroadcast_notify = new LoadBalanceBroadcastInfo(arrayList, ((LoadBalancingPolicy.LoadBalancingPolicyDescription)object2).m_BroadcastCondition);
            }
        }
    }

    public static class MemberAttributes
    implements Serializable {
        public GroupData m_GroupData;
        public int m_Index;
    }

    public static class FOOperationData
    implements Serializable {
        public int m_PolicyType;
        public int m_OperationType;
        public GroupData m_Group;
        public boolean m_DoNotUseAlternateGroups;
        public boolean[] m_OnlyBackups;
        public int[] m_MasterForBackupOnly;
        public List[] m_Backups;
        public int[] m_ActiveMembers;
        public String m_ActualLocalSpace;

        public FOOperationData(LoadBalanceImpl loadBalanceImpl, FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription, GroupData groupData, int n2, HashMap hashMap, String string) {
            this.m_PolicyType = failOverPolicyDescription.m_PolicyType;
            this.m_Group = groupData;
            this.m_OperationType = n2;
            this.m_DoNotUseAlternateGroups = failOverPolicyDescription.m_DisableAlternateGroups;
            int n3 = groupData.m_Availability.length;
            boolean bl2 = false;
            if (this.m_PolicyType == 1) {
                Object object;
                int n4;
                Object object2;
                this.m_OnlyBackups = new boolean[groupData.m_Availability.length];
                Iterator iterator = failOverPolicyDescription.m_BackupOnly.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    object2 = (MemberAttributes)hashMap.get(string2);
                    this.m_OnlyBackups[((MemberAttributes)object2).m_Index] = true;
                    bl2 = true;
                    --n3;
                }
                if (n3 == 0) {
                    throw new RuntimeException("invalid fail-over policy, no active members, only backups.");
                }
                this.m_ActiveMembers = new int[n3];
                int n5 = 0;
                this.m_MasterForBackupOnly = new int[groupData.m_GroupMembers.size()];
                for (n4 = 0; n4 < groupData.m_GroupMembers.size(); ++n4) {
                    if (this.m_OnlyBackups[n4]) {
                        this.m_MasterForBackupOnly[n4] = -1;
                        continue;
                    }
                    this.m_ActiveMembers[n5++] = n4;
                }
                this.m_Backups = new List[groupData.m_Availability.length];
                for (n4 = 0; n4 < groupData.m_GroupMembers.size(); ++n4) {
                    object2 = (String)groupData.m_GroupMembers.get(n4);
                    object = (List)failOverPolicyDescription.m_BackupMemberNames.get(object2);
                    if (object == null) continue;
                    this.m_Backups[n4] = object;
                    if (!bl2) continue;
                    int n6 = object.size();
                    for (int i2 = 0; i2 < n6; ++i2) {
                        String string3 = (String)object.get(i2);
                        MemberAttributes memberAttributes = (MemberAttributes)hashMap.get(string3);
                        if (!this.m_OnlyBackups[memberAttributes.m_Index] || this.m_MasterForBackupOnly[memberAttributes.m_Index] != -1) continue;
                        this.m_MasterForBackupOnly[memberAttributes.m_Index] = n4;
                    }
                }
                if (groupData.m_LocalSpaceHere) {
                    MemberAttributes memberAttributes = (MemberAttributes)hashMap.get(string);
                    if (this.m_OnlyBackups[memberAttributes.m_Index]) {
                        for (int i3 = 0; i3 < this.m_Backups.length; ++i3) {
                            if (this.m_Backups[i3] == null || !this.m_Backups[i3].contains(string)) continue;
                            this.m_ActualLocalSpace = (String)groupData.m_GroupMembers.get(i3);
                            object = (MemberAttributes)hashMap.get(this.m_ActualLocalSpace);
                            loadBalanceImpl.m_LocalSpaceIndex = ((MemberAttributes)object).m_Index;
                            break;
                        }
                        if (this.m_ActualLocalSpace == null) {
                            throw new RuntimeException("LoadBalangingImpl::FOOperationData, member is backup-only without master " + string);
                        }
                    }
                }
            }
        }
    }

    public static class Weights
    implements Serializable {
        public int[] m_WeightSteps;
        public int[] m_Weights;
        public int m_WeigthsSum;

        public Weights(int n2) {
            this.m_WeightSteps = new int[n2];
            this.m_Weights = new int[n2];
        }
    }

    public static class OperationData
    implements Serializable {
        public int m_PolicyType = -1;
        public int m_OperationType;
        public volatile Weights m_weights;
        public AtomicInteger m_AtomicIndex;
        public TreeSet m_Priorities;
        public volatile boolean m_NeedRefresh;
        public GroupData m_Group;

        public OperationData(GroupData groupData, int n2) {
            this.m_Group = groupData;
            this.m_OperationType = n2;
            this.m_AtomicIndex = new AtomicInteger(-1);
        }
    }

    public static class GroupData
    implements Serializable {
        public List m_GroupMembers;
        public boolean[] m_Availability;
        public OperationData m_ReadInfo;
        public OperationData m_WriteInfo;
        public OperationData m_NotifyInfo;
        public OperationData m_TakeInfo;
        public OperationData m_DefaultInfo;
        public boolean m_IsPrimary;
        public FOOperationData m_ReadFO;
        public FOOperationData m_WriteFO;
        public FOOperationData m_NotifyFO;
        public FOOperationData m_TakeFO;
        public FOOperationData m_DefaultFO;
        public boolean m_LocalSpaceHere;
    }
}

