/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.client.IRemoteLocalTransactionManager;
import com.j_spaces.core.client.LocalTransactionLeaseMap;
import com.j_spaces.kernel.time.SystemTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

public class LocalTransactionLease
implements Lease,
Serializable {
    public long xtnID;
    public long xtnLease;
    public transient long m_AbsExprTime;
    public int m_SerialFormat;
    public transient IRemoteLocalTransactionManager m_LocalMng;
    public IRemoteLocalTransactionManager m_RemoteMng;

    public LocalTransactionLease(long l2, long l3, IRemoteLocalTransactionManager iRemoteLocalTransactionManager) {
        this.xtnID = l2;
        this.xtnLease = l3;
        this.m_LocalMng = iRemoteLocalTransactionManager;
        this.m_AbsExprTime = this.xtnLease != -1L && this.xtnLease != Long.MAX_VALUE ? l3 + SystemTime.timeMillis() : Long.MAX_VALUE;
    }

    public boolean canBatch(Lease lease) {
        if (!(lease instanceof LocalTransactionLease)) {
            return false;
        }
        LocalTransactionLease localTransactionLease = (LocalTransactionLease)lease;
        if (this.m_LocalMng != null) {
            return this.m_LocalMng.equals(localTransactionLease.m_LocalMng);
        }
        return this.m_RemoteMng.equals(localTransactionLease.m_RemoteMng);
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        if (this.m_LocalMng != null) {
            this.m_LocalMng.cancel(this.xtnID);
        } else {
            this.m_RemoteMng.cancel(this.xtnID);
        }
    }

    public LeaseMap createLeaseMap(long l2) {
        return new LocalTransactionLeaseMap(this, l2, this.m_LocalMng, this.m_RemoteMng);
    }

    public long getExpiration() {
        return this.m_AbsExprTime;
    }

    public int getSerialFormat() {
        return this.m_SerialFormat;
    }

    public void setSerialFormat(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid serial format");
        }
        this.m_SerialFormat = n2;
    }

    public void renew(long l2) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        if (this.m_LocalMng != null) {
            this.m_LocalMng.renew(this.xtnID, l2);
        } else {
            this.m_RemoteMng.renew(this.xtnID, l2);
        }
        this.m_AbsExprTime = SystemTime.timeMillis() + l2;
        if (this.m_AbsExprTime < 0L) {
            this.m_AbsExprTime = Long.MAX_VALUE;
        }
    }

    public void setExprInternal(long l2) {
        this.m_AbsExprTime = l2;
    }

    public long getTransactionID() {
        return this.xtnID;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_AbsExprTime = objectInputStream.readLong();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.m_RemoteMng = this.m_LocalMng.getStub();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.m_AbsExprTime);
    }
}

