/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.j_spaces.core.IStubHandler;
import com.j_spaces.kernel.log.JProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StubHandlerImpl
implements IStubHandler {
    private static final long serialVersionUID = 2L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private int _spacePort;
    private int _clientPort;
    private int _bindPort;

    public void init(String string) {
        this._spacePort = Integer.parseInt(JProperties.getSpaceProperty(string, "lrmi-stub-handler.server-port", "0"));
        this._clientPort = Integer.parseInt(JProperties.getSpaceProperty(string, "lrmi-stub-handler.client-port", "0"));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Space [" + string + "]" + " initialized " + this.getClass() + " with the following configuration: " + "\nProtocol: RMI" + "\nServerPort: " + this._spacePort + "\nClientPort: " + this._clientPort);
        }
        this._bindPort = this._spacePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote exportObject(Remote remote) throws RemoteException {
        Remote remote2 = null;
        StubHandlerImpl stubHandlerImpl = this;
        synchronized (stubHandlerImpl) {
            try {
                remote2 = RemoteObject.toStub(remote);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                remote2 = UnicastRemoteObject.exportObject(remote, this._bindPort);
            }
        }
        return remote2;
    }

    public void unexportObject(Remote remote, boolean bl2) throws RemoteException {
        UnicastRemoteObject.unexportObject(remote, bl2);
    }

    public boolean isStub(Remote remote) {
        return remote instanceof RemoteStub;
    }

    public String getProtocolName() {
        return "RMI";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._bindPort = this._clientPort;
    }
}

