/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.util;

import com.j_spaces.obf.fd;
import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final char a = '.';
    private static final char b = '$';
    private static final String c = "$$";
    private static final Logger d;
    private static final Map e;
    private static final Map f;
    static /* synthetic */ Class class$com$gigaspaces$util$ClassUtils;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            Class<?> clazz = class$com$gigaspaces$util$ClassUtils;
            if (clazz == null) {
                clazz = class$com$gigaspaces$util$ClassUtils = new ClassUtils[0].getClass().getComponentType();
            }
            classLoader = clazz.getClassLoader();
        }
        return classLoader;
    }

    public static boolean isPresent(String string) {
        try {
            ClassUtils.forName(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return ClassUtils.forName(string, ClassUtils.getDefaultClassLoader());
    }

    public static Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassUtils.resolvePrimitiveClassName(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.endsWith(ARRAY_SUFFIX)) {
            String string2 = string.substring(0, string.length() - ARRAY_SUFFIX.length());
            Class clazz2 = ClassUtils.forName(string2, classLoader);
            return Array.newInstance(clazz2, 0).getClass();
        }
        return Class.forName(string, true, classLoader);
    }

    public static Class resolvePrimitiveClassName(String string) {
        Class clazz = null;
        if (string != null && string.length() <= 8) {
            clazz = (Class)f.get(string);
        }
        return clazz;
    }

    public static String getShortName(String string) {
        fd.a(string, "Class name must not be empty");
        int n2 = string.lastIndexOf(46);
        int n3 = string.indexOf(c);
        if (n3 == -1) {
            n3 = string.length();
        }
        String string2 = string.substring(n2 + 1, n3);
        string2 = string2.replace('$', '.');
        return string2;
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class clazz) {
        return Introspector.decapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getQualifiedName(Class clazz) {
        fd.b(clazz, "Class must not be null");
        if (clazz.isArray()) {
            return ClassUtils.a(clazz);
        }
        return clazz.getName();
    }

    public static String getQualifiedMethodName(Method method) {
        fd.b(method, "Method must not be null");
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public static boolean hasMethod(Class clazz, String string, Class[] classArray) {
        return ClassUtils.getMethodIfAvailable(clazz, string, classArray) != null;
    }

    public static Method getMethodIfAvailable(Class clazz, String string, Class[] classArray) {
        fd.b(clazz, "Class must not be null");
        fd.b((Object)string, "Method name must not be null");
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static int getMethodCountForName(Class clazz, String string) {
        Class<?>[] classArray;
        Class<?>[] classArray2;
        fd.b(clazz, "Class must not be null");
        fd.b((Object)string, "Method name must not be null");
        int n2 = 0;
        for (int i2 = 0; i2 < clazz.getDeclaredMethods().length; ++i2) {
            classArray2 = clazz.getDeclaredMethods()[i2];
            if (!string.equals(classArray2.getName())) continue;
            ++n2;
        }
        classArray2 = classArray = clazz.getInterfaces();
        int n3 = classArray2.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            Class<?> clazz2 = classArray2[i3];
            n2 += ClassUtils.getMethodCountForName(clazz2, string);
        }
        if (clazz.getSuperclass() != null) {
            n2 += ClassUtils.getMethodCountForName(clazz.getSuperclass(), string);
        }
        return n2;
    }

    public static boolean hasAtLeastOneMethodWithName(Class clazz, String string) {
        Class<?>[] classArray;
        Class<?>[] classArray2;
        fd.b(clazz, "Class must not be null");
        fd.b((Object)string, "Method name must not be null");
        for (int i2 = 0; i2 < clazz.getDeclaredMethods().length; ++i2) {
            classArray2 = clazz.getDeclaredMethods()[i2];
            if (!classArray2.getName().equals(string)) continue;
            return true;
        }
        classArray2 = classArray = clazz.getInterfaces();
        int n2 = classArray2.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            Class<?> clazz2 = classArray2[i3];
            if (!ClassUtils.hasAtLeastOneMethodWithName(clazz2, string)) continue;
            return true;
        }
        return clazz.getSuperclass() != null && ClassUtils.hasAtLeastOneMethodWithName(clazz.getSuperclass(), string);
    }

    public static Method getStaticMethod(Class clazz, String string, Class[] classArray) {
        fd.b(clazz, "Class must not be null");
        fd.b((Object)string, "Method name must not be null");
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        fd.b(clazz, "Class must not be null");
        return e.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        fd.b(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        fd.b(clazz, "Class must not be null");
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class clazz) {
        fd.b(clazz, "Class must not be null");
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        fd.b(clazz, "Target type must not be null");
        fd.b(clazz2, "Value type must not be null");
        return clazz.isAssignableFrom(clazz2) || clazz.equals(e.get(clazz2));
    }

    public static boolean isAssignableValue(Class clazz, Object object) {
        fd.b(clazz, "Type must not be null");
        return object != null ? ClassUtils.isAssignable(clazz, object.getClass()) : !clazz.isPrimitive();
    }

    public static String addResourcePathToPackagePath(Class clazz, String string) {
        fd.b((Object)string, "Resource name must not be null");
        if (!string.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + string;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + string;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static Class[] getAllInterfaces(Object object) {
        Set set = ClassUtils.getAllInterfacesAsSet(object);
        return set.toArray(new Class[set.size()]);
    }

    public static Class[] getAllInterfacesForClass(Class clazz) {
        Set set = ClassUtils.getAllInterfacesForClassAsSet(clazz);
        return set.toArray(new Class[set.size()]);
    }

    public static Set getAllInterfacesAsSet(Object object) {
        return ClassUtils.getAllInterfacesForClassAsSet(object.getClass());
    }

    public static Set getAllInterfacesForClassAsSet(Class clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        HashSet hashSet = new HashSet();
        while (clazz != null) {
            for (int i2 = 0; i2 < clazz.getInterfaces().length; ++i2) {
                Class<?> clazz2 = clazz.getInterfaces()[i2];
                hashSet.add(clazz2);
            }
            clazz = clazz.getSuperclass();
        }
        return hashSet;
    }

    private static String a(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            stringBuffer.append(ARRAY_SUFFIX);
        }
        stringBuffer.insert(0, clazz.getName());
        return stringBuffer.toString();
    }

    static {
        Class<?> clazz = class$com$gigaspaces$util$ClassUtils;
        if (clazz == null) {
            clazz = class$com$gigaspaces$util$ClassUtils = new ClassUtils[0].getClass().getComponentType();
        }
        d = Logger.getLogger(clazz.getName());
        e = new HashMap(8);
        f = new HashMap(8);
        Class<?> clazz2 = class$java$lang$Boolean;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        e.put(clazz2, Boolean.TYPE);
        Class<?> clazz3 = class$java$lang$Byte;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        e.put(clazz3, Byte.TYPE);
        Class<?> clazz4 = class$java$lang$Character;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        e.put(clazz4, Character.TYPE);
        Class<?> clazz5 = class$java$lang$Double;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        e.put(clazz5, Double.TYPE);
        Class<?> clazz6 = class$java$lang$Float;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        e.put(clazz6, Float.TYPE);
        Class<?> clazz7 = class$java$lang$Integer;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        e.put(clazz7, Integer.TYPE);
        Class<?> clazz8 = class$java$lang$Long;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        e.put(clazz8, Long.TYPE);
        Class<?> clazz9 = class$java$lang$Short;
        if (clazz9 == null) {
            clazz9 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        e.put(clazz9, Short.TYPE);
        Iterator iterator = e.values().iterator();
        while (iterator.hasNext()) {
            Class clazz10;
            Class clazz11 = clazz10 = (Class)iterator.next();
            f.put(clazz11.getName(), clazz11);
        }
    }
}

