/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.jeri.internal.connection.BasicServerConnManager;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.ssl.ConnectionContext;
import net.jini.jeri.ssl.ServerAuthManager;
import net.jini.jeri.ssl.SslEndpoint;
import net.jini.jeri.ssl.SslServerEndpoint;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.AuthenticationPermission;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

class SslServerEndpointImpl
extends Utilities {
    static final Logger logger;
    static long maxServerSessionDuration;
    static final Executor systemExecutor;
    private static final ServerConnManager defaultServerConnectionManager;
    final ServerEndpoint serverEndpoint;
    final Subject serverSubject;
    final Set serverPrincipals;
    final String serverHost;
    final int port;
    final SocketFactory socketFactory;
    final ServerSocketFactory serverSocketFactory;
    Permission[] listenPermissions;
    private final ServerEndpoint.ListenEndpoint listenEndpoint;
    private SSLSocketFactory sslSocketFactory;
    private ServerAuthManager authManager;
    ServerConnManager serverConnectionManager = defaultServerConnectionManager;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$javax$security$auth$x500$X500Principal;
    static /* synthetic */ Class class$java$security$cert$CertPath;
    static /* synthetic */ Class class$net$jini$jeri$ssl$SslServerEndpointImpl$SslListenHandle;
    static /* synthetic */ Class class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection;

    SslServerEndpointImpl(ServerEndpoint serverEndpoint, Subject serverSubject, X500Principal[] serverPrincipals, String serverHost, int port, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        boolean useCurrentSubject;
        this.serverEndpoint = serverEndpoint;
        boolean bl = useCurrentSubject = serverSubject == null;
        if (useCurrentSubject) {
            final AccessControlContext acc = AccessController.getContext();
            serverSubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Subject.getSubject(acc);
                }
            });
        }
        Set set = this.serverPrincipals = serverPrincipals == null ? SslServerEndpointImpl.computePrincipals(serverSubject) : SslServerEndpointImpl.checkPrincipals(serverPrincipals);
        if (this.serverPrincipals == null) {
            this.listenPermissions = null;
        } else {
            this.listenPermissions = new AuthenticationPermission[this.serverPrincipals.size()];
            int i = 0;
            Iterator iter = this.serverPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                this.listenPermissions[i] = new AuthenticationPermission(Collections.singleton(p), null, "listen");
                ++i;
            }
        }
        if (this.serverPrincipals == null || useCurrentSubject && serverPrincipals != null && !this.hasListenPermissions()) {
            this.serverSubject = null;
            this.listenPermissions = null;
        } else {
            this.serverSubject = serverSubject;
        }
        this.serverHost = serverHost;
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.port = port;
        this.socketFactory = socketFactory;
        this.serverSocketFactory = serverSocketFactory;
        this.listenEndpoint = this.createListenEndpoint();
    }

    private static Set computePrincipals(Subject subject) {
        if (subject == null) {
            return null;
        }
        X500PrivateCredential[] credentials = (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(subject));
        Set result = SubjectCredentials.getPrincipals(subject, -1, credentials);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                try {
                    sm.checkPermission(new AuthenticationPermission(Collections.singleton(p), null, "listen"));
                }
                catch (SecurityException e) {
                    logger.log(Levels.HANDLED, "compute principals for server endpoint caught exception", e);
                    iter.remove();
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    private boolean hasListenPermissions() {
        try {
            this.checkListenPermissions(false);
            return true;
        }
        catch (SecurityException e) {
            logger.log(Levels.HANDLED, "check listen permissions for server endpoint caught exception", e);
            return false;
        }
    }

    private static Set checkPrincipals(X500Principal[] principals) {
        if (principals.length == 0) {
            return null;
        }
        HashSet<X500Principal> result = new HashSet<X500Principal>(principals.length);
        int i = principals.length;
        while (--i >= 0) {
            X500Principal p = principals[i];
            if (p == null) {
                throw new NullPointerException("Server principal cannot be null");
            }
            result.add(p);
        }
        return result;
    }

    private void sslInit() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Utilities.SSLContextInfo info = SslServerEndpointImpl.getServerSSLContextInfo(this.serverSubject, this.serverPrincipals);
        this.sslSocketFactory = info.sslContext.getSocketFactory();
        this.authManager = (ServerAuthManager)info.authManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SSLSocketFactory getSSLSocketFactory() {
        SslServerEndpointImpl sslServerEndpointImpl = this;
        synchronized (sslServerEndpointImpl) {
            if (this.sslSocketFactory == null) {
                this.sslInit();
            }
        }
        return this.sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ServerAuthManager getAuthManager() {
        SslServerEndpointImpl sslServerEndpointImpl = this;
        synchronized (sslServerEndpointImpl) {
            if (this.authManager == null) {
                this.sslInit();
            }
        }
        return this.authManager;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ System.identityHashCode(this.serverSubject) ^ (this.serverPrincipals == null ? 0 : ((Object)this.serverPrincipals).hashCode()) ^ (this.serverHost == null ? 0 : this.serverHost.hashCode()) ^ this.port ^ (this.socketFactory != null ? this.socketFactory.hashCode() : 0) ^ (this.serverSocketFactory != null ? this.serverSocketFactory.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SslServerEndpointImpl other = (SslServerEndpointImpl)object;
        return this.serverSubject == other.serverSubject && SslServerEndpointImpl.safeEquals(this.serverPrincipals, other.serverPrincipals) && SslServerEndpointImpl.safeEquals(this.serverHost, other.serverHost) && this.port == other.port && Util.sameClassAndEquals(this.socketFactory, other.socketFactory) && Util.sameClassAndEquals(this.serverSocketFactory, other.serverSocketFactory);
    }

    public String toString() {
        return SslServerEndpointImpl.getClassName(this) + this.fieldsToString();
    }

    final String fieldsToString() {
        return "[" + (this.serverPrincipals == null ? "" : this.serverPrincipals.toString() + ", ") + (this.serverHost == null ? "" : this.serverHost + ":") + this.port + (this.serverSocketFactory != null ? ", " + this.serverSocketFactory : "") + (this.socketFactory != null ? ", " + this.socketFactory : "") + "]";
    }

    final InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        try {
            this.checkListenPermissions(false);
        }
        catch (SecurityException e) {
            if (logger.isLoggable(Levels.FAILED)) {
                SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpoint.class, "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, constraints}, e);
            }
            throw e;
        }
        Set<Principal> clientPrincipals = SslServerEndpointImpl.getClientPrincipals(constraints);
        if (clientPrincipals == null) {
            clientPrincipals = Collections.singleton(UNKNOWN_PRINCIPAL);
        }
        HashMap<X500Principal, ArrayList<String>> serverKeyTypes = new HashMap<X500Principal, ArrayList<String>>();
        List certPaths = SubjectCredentials.getCertificateChains(this.serverSubject);
        if (certPaths != null) {
            int i = certPaths.size();
            while (--i >= 0) {
                CertPath chain = (CertPath)certPaths.get(i);
                X509Certificate cert = SubjectCredentials.firstX509Cert(chain);
                X500Principal principal = SubjectCredentials.getPrincipal(this.serverSubject, cert);
                if (principal == null) continue;
                ArrayList<String> keyTypes = (ArrayList<String>)serverKeyTypes.get(principal);
                if (keyTypes == null) {
                    keyTypes = new ArrayList<String>(1);
                    serverKeyTypes.put(principal, keyTypes);
                }
                keyTypes.add(cert.getPublicKey().getAlgorithm());
            }
        }
        String[] suites = SslServerEndpointImpl.getSupportedCipherSuites();
        int suiteIndex = suites.length;
        while (--suiteIndex >= 0) {
            X500Principal server;
            String suite = suites[suiteIndex];
            String suiteKeyType = SslServerEndpointImpl.getKeyAlgorithm(suite);
            Iterator sIter = (this.serverPrincipals == null ? Collections.EMPTY_SET : this.serverPrincipals).iterator();
            do {
                Principal client;
                if (sIter.hasNext()) {
                    server = (X500Principal)sIter.next();
                    if (!$assertionsDisabled && server == null) {
                        throw new AssertionError();
                    }
                    Collection keyTypes = (Collection)serverKeyTypes.get(server);
                    if (keyTypes == null || !keyTypes.contains(suiteKeyType)) {
                        continue;
                    }
                } else {
                    server = null;
                }
                Iterator<Principal> cIter = clientPrincipals.iterator();
                do {
                    InvocationConstraints unfulfilledConstraints;
                    if (cIter.hasNext()) {
                        client = cIter.next();
                        if (!$assertionsDisabled && client == null) {
                            throw new AssertionError();
                        }
                    } else {
                        client = null;
                    }
                    if ((unfulfilledConstraints = SslServerEndpointImpl.getUnfulfilledConstraints(suite, client, server, constraints)) == null) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "check constraints for {0}\nwith {1}\nreturns {2}", new Object[]{this.serverEndpoint, constraints, unfulfilledConstraints});
                    }
                    return unfulfilledConstraints;
                } while (client != null);
            } while (server != null);
        }
        UnsupportedConstraintException uce = new UnsupportedConstraintException("Constraints are not supported: " + constraints);
        if (logger.isLoggable(Levels.FAILED)) {
            SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpoint.class, "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this.serverEndpoint, constraints}, uce);
        }
        throw uce;
    }

    static InvocationConstraints getUnfulfilledConstraints(String cipherSuite, Principal client, Principal server, InvocationConstraints constraints) {
        boolean supported = false;
        int i = 2;
        while (--i >= 0) {
            boolean integrity = i == 0;
            ConnectionContext context = ConnectionContext.getInstance(cipherSuite, client, server, integrity, false, constraints);
            if (context == null) continue;
            if (context.getIntegrityRequired()) {
                return INTEGRITY_REQUIRED;
            }
            if (context.getIntegrityPreferred()) {
                return INTEGRITY_PREFERRED;
            }
            supported = true;
        }
        return supported ? InvocationConstraints.EMPTY : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        Endpoint endpoint;
        block12: {
            SecurityException exception = null;
            try {
                String resolvedHost = this.serverHost;
                if (resolvedHost == null) {
                    InetAddress localAddr;
                    try {
                        localAddr = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws UnknownHostException {
                                return InetAddress.getLocalHost();
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        UnknownHostException uhe = (UnknownHostException)e.getCause();
                        if (logger.isLoggable(Levels.FAILED)) {
                            SslServerEndpointImpl.logThrow(logger, Levels.FAILED, this.getClass(), "enumerateListenEndpoints", "InetAddress.getLocalHost() throws", null, uhe);
                        }
                        InetAddress.getLocalHost();
                        throw new UnknownHostException("Host name cleared due to insufficient caller permissions");
                    }
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        try {
                            sm.checkConnect(localAddr.getHostName(), -1);
                        }
                        catch (SecurityException e) {
                            exception = e;
                            throw new SecurityException("Access to resolve local host denied");
                        }
                    }
                    resolvedHost = localAddr.getHostAddress();
                }
                Endpoint result = this.createEndpoint(resolvedHost, this.checkCookie(listenContext.addListenEndpoint(this.listenEndpoint)));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "enumerate listen endpoints for {0}\nreturns {1}", new Object[]{this, result});
                }
                endpoint = result;
                Object var9_10 = null;
                if (exception == null || !logger.isLoggable(Levels.FAILED)) break block12;
                SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpointImpl.class, "enumerateListenEndpoints", "enumerate listen endpoints for {0}\nthrows", new Object[]{this}, exception);
            }
            catch (Throwable throwable) {
                block13: {
                    Object var9_11 = null;
                    if (exception == null || !logger.isLoggable(Levels.FAILED)) break block13;
                    SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpointImpl.class, "enumerateListenEndpoints", "enumerate listen endpoints for {0}\nthrows", new Object[]{this}, exception);
                }
                throw throwable;
            }
        }
        return endpoint;
    }

    ServerEndpoint.ListenEndpoint createListenEndpoint() {
        return new SslListenEndpoint();
    }

    Endpoint createEndpoint(String serverHost, SslListenCookie cookie) {
        return SslEndpoint.getInstance(serverHost, cookie.getPort(), this.socketFactory);
    }

    private SslListenCookie checkCookie(ServerEndpoint.ListenCookie cookie) {
        if (!(cookie instanceof SslListenCookie)) {
            throw new IllegalArgumentException("Cookie must be of type SslListenCookie: " + cookie);
        }
        SslListenCookie sslListenCookie = (SslListenCookie)cookie;
        ServerEndpoint.ListenEndpoint cookieListenEndpoint = sslListenCookie.getListenEndpoint();
        if (!this.listenEndpoint.equals(cookieListenEndpoint)) {
            throw new IllegalArgumentException("Cookie has wrong listen endpoint: found " + cookieListenEndpoint + ", expected " + this.listenEndpoint);
        }
        return sslListenCookie;
    }

    final void checkListenPermissions(boolean checkSocket) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (checkSocket) {
                sm.checkListen(this.port);
            }
            if (this.listenPermissions != null) {
                int i = this.listenPermissions.length;
                while (--i >= 0) {
                    sm.checkPermission(this.listenPermissions[i]);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !SslServerEndpointImpl.class.desiredAssertionStatus();
        logger = serverLogger;
        maxServerSessionDuration = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.ssl.maxServerSessionDuration", 86400000L));
        systemExecutor = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
        defaultServerConnectionManager = new BasicServerConnManager();
    }

    class SslServerConnection
    extends Utilities
    implements ServerConnection {
        private final SslListenHandle listenHandle;
        final SSLSocket sslSocket;
        private final InboundRequestHandle requestHandle = new InboundRequestHandle(this){
            private final /* synthetic */ SslServerConnection this$1;
            {
                this.this$1 = this$1;
            }
        };
        private SSLSession session;
        private Subject clientSubject;
        private X500Principal clientPrincipal;
        private X500Principal serverPrincipal;
        private AuthenticationPermission authPermission;
        private String cipherSuite;
        boolean closed;

        SslServerConnection(SslListenHandle listenHandle, Socket socket) throws IOException {
            this.listenHandle = listenHandle;
            this.sslSocket = (SSLSocket)SslServerEndpointImpl.this.getSSLSocketFactory().createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
            this.sslSocket.setEnabledCipherSuites(SslServerConnection.getSupportedCipherSuites());
            this.sslSocket.setUseClientMode(false);
            this.sslSocket.setWantClientAuth(true);
            logger.log(Level.FINE, "created {0}", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String sessionString;
            SslServerConnection sslServerConnection = this;
            synchronized (sslServerConnection) {
                sessionString = this.session == null ? "" : this.session + ", ";
            }
            return SslServerConnection.getClassName(this) + "[" + sessionString + SslServerEndpointImpl.this.serverHost + ":" + this.sslSocket.getLocalPort() + "<=" + this.sslSocket.getInetAddress().getHostName() + ":" + this.sslSocket.getPort() + "]";
        }

        public InputStream getInputStream() throws IOException {
            return this.sslSocket.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.sslSocket.getOutputStream();
        }

        public SocketChannel getChannel() {
            return null;
        }

        public InboundRequestHandle processRequestData(InputStream in, OutputStream out) {
            SecurityException exception;
            if (in == null || out == null) {
                throw new NullPointerException("Arguments cannot be null");
            }
            try {
                long now = System.currentTimeMillis();
                this.decacheSession();
                long create = this.session.getCreationTime();
                long expiration = create + maxServerSessionDuration;
                if (expiration < create) {
                    expiration = Long.MAX_VALUE;
                }
                if (expiration < now) {
                    this.session.invalidate();
                    throw new SecurityException("Session has expired");
                }
                if (this.serverPrincipal != null) {
                    SslServerEndpointImpl.this.getAuthManager().checkCredentials(this.session, this.clientSubject);
                }
                return this.requestHandle;
            }
            catch (SecurityException e) {
                exception = e;
            }
            catch (GeneralSecurityException e) {
                exception = new SecurityException(e.getMessage());
                exception.initCause(e);
            }
            try {
                out.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            if (logger.isLoggable(Levels.FAILED)) {
                SslServerConnection.logThrow(logger, Levels.FAILED, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection == null ? (class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection = SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslServerConnection")) : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection, "processRequestData", "process request data for session {0}\nclient {1}\nthrows", new Object[]{this.session, SslServerConnection.subjectString(this.clientSubject)}, exception);
            }
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decacheSession() {
            SslServerConnection sslServerConnection = this;
            synchronized (sslServerConnection) {
                SSLSession socketSession = this.sslSocket.getSession();
                if (this.session == socketSession) {
                    return;
                }
                if (this.session != null) {
                    throw new SecurityException("New handshake occurred on socket");
                }
                this.session = socketSession;
                this.sslSocket.setEnableSessionCreation(false);
                this.cipherSuite = this.session.getCipherSuite();
                if ("NULL".equals(SslServerConnection.getKeyExchangeAlgorithm(this.cipherSuite))) {
                    throw new SecurityException("Handshake failed");
                }
                this.clientSubject = this.getClientSubject(this.sslSocket);
                this.clientPrincipal = this.clientSubject != null ? (X500Principal)this.clientSubject.getPrincipals().iterator().next() : null;
                X509Certificate serverCert = SslServerEndpointImpl.this.getAuthManager().getServerCertificate(this.session);
                X500Principal x500Principal = this.serverPrincipal = serverCert != null ? serverCert.getSubjectX500Principal() : null;
                if (this.serverPrincipal != null) {
                    this.authPermission = new AuthenticationPermission(Collections.singleton(this.serverPrincipal), this.clientPrincipal != null ? Collections.singleton(this.clientPrincipal) : null, "accept");
                }
            }
        }

        private Subject getClientSubject(SSLSocket socket) {
            SSLSession session = socket.getSession();
            try {
                Certificate[] certificateChain = session.getPeerCertificates();
                if (certificateChain != null && certificateChain.length > 0 && certificateChain[0] instanceof X509Certificate) {
                    X509Certificate cert = (X509Certificate)certificateChain[0];
                    return new Subject(true, Collections.singleton(cert.getSubjectX500Principal()), Collections.singleton(SslServerConnection.getCertFactory().generateCertPath(Arrays.asList(certificateChain))), Collections.EMPTY_SET);
                }
            }
            catch (SSLPeerUnverifiedException e) {
            }
            catch (CertificateException e) {
                logger.log(Levels.HANDLED, "get client subject caught exception", e);
            }
            return null;
        }

        public void checkPermissions(InboundRequestHandle requestHandle) {
            this.check(requestHandle);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkAccept(this.sslSocket.getInetAddress().getHostAddress(), this.sslSocket.getPort());
                    if (this.authPermission != null) {
                        sm.checkPermission(this.authPermission);
                    }
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        SslServerConnection.logThrow(logger, Levels.FAILED, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection == null ? (class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection = SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslServerConnection")) : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection, "checkPermissions", "check permissions for {0} throws", new Object[]{this}, e);
                    }
                    throw e;
                }
            }
        }

        private void check(InboundRequestHandle requestHandle) {
            if (requestHandle == null) {
                throw new NullPointerException("Request handle cannot be null");
            }
            if (requestHandle != this.requestHandle) {
                throw new IllegalArgumentException("Wrong request handle: found " + requestHandle + ", expected " + this.requestHandle);
            }
        }

        public InvocationConstraints checkConstraints(InboundRequestHandle requestHandle, InvocationConstraints constraints) throws UnsupportedConstraintException {
            this.check(requestHandle);
            if (constraints == null) {
                throw new NullPointerException("Constraints cannot be null");
            }
            InvocationConstraints result = SslServerEndpointImpl.getUnfulfilledConstraints(this.cipherSuite, this.clientPrincipal, this.serverPrincipal, constraints);
            if (result == null) {
                UnsupportedConstraintException uce = new UnsupportedConstraintException("Constraints are not supported: " + constraints);
                if (logger.isLoggable(Levels.FAILED)) {
                    SslServerConnection.logThrow(logger, Levels.FAILED, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection == null ? (class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection = SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslServerConnection")) : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection, "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, constraints}, uce);
                }
                throw uce;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "check constraints for {0}\nwith {1}\nreturns {2}", new Object[]{this, constraints, result});
            }
            return result;
        }

        public void populateContext(InboundRequestHandle requestHandle, Collection context) {
            this.check(requestHandle);
            Util.populateContext(context, this.sslSocket.getInetAddress());
            Util.populateContext(context, this.clientSubject);
        }

        public void close() throws IOException {
            this.closeInternal(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeInternal(boolean removeFromListener) throws IOException {
            SslServerConnection sslServerConnection = this;
            synchronized (sslServerConnection) {
                if (this.closed) {
                    return;
                }
                logger.log(Level.FINE, "closing {0}", this);
                this.closed = true;
                this.sslSocket.close();
            }
            if (removeFromListener) {
                this.listenHandle.noteConnectionClosed(this);
            }
        }
    }

    final class SslListenCookie
    implements ServerEndpoint.ListenCookie {
        private final int port;

        SslListenCookie(int port) {
            this.port = port;
        }

        final int getPort() {
            return this.port;
        }

        final ServerEndpoint.ListenEndpoint getListenEndpoint() {
            return SslServerEndpointImpl.this.listenEndpoint;
        }
    }

    class SslListenHandle
    extends Utilities
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher requestDispatcher;
        final ServerSocket serverSocket;
        private final SecurityContext securityContext;
        private boolean closed = false;
        private final Set connections = new HashSet();
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;

        SslListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
            this.requestDispatcher = requestDispatcher;
            this.serverSocket = serverSocket;
            this.securityContext = Security.getContext();
            systemExecutor.execute(new Runnable(this){
                private final /* synthetic */ SslListenHandle this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.acceptLoop();
                }
            }, this.toString());
            logger.log(Level.FINE, "created {0}", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void acceptLoop() {
            block25: {
                boolean knownFailure;
                Throwable exception;
                while (true) {
                    boolean closedSync;
                    Socket socket = null;
                    SslServerConnection connection = null;
                    try {
                        socket = this.serverSocket.accept();
                        try {
                            socket.setTcpNoDelay(true);
                        }
                        catch (SocketException e) {
                            // empty catch block
                        }
                        try {
                            socket.setKeepAlive(true);
                        }
                        catch (SocketException e) {
                            // empty catch block
                        }
                        connection = this.serverConnection(socket);
                        SslListenHandle e = this;
                        synchronized (e) {
                            if (this.closed) {
                                try {
                                    connection.closeInternal(false);
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                break block25;
                            }
                            this.connections.add(connection);
                        }
                        SslServerConnection finalConnection = connection;
                        AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction(this, finalConnection){
                            private final /* synthetic */ SslServerConnection val$finalConnection;
                            private final /* synthetic */ SslListenHandle this$1;
                            {
                                this.this$1 = this$1;
                                this.val$finalConnection = val$finalConnection;
                            }

                            public Object run() {
                                this.this$1.handleConnection(this.val$finalConnection, SslListenHandle.access$000(this.this$1));
                                return null;
                            }
                        }), this.securityContext.getAccessControlContext());
                        continue;
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    catch (Error e) {
                        exception = e;
                    }
                    SslListenHandle e2 = this;
                    synchronized (e2) {
                        closedSync = this.closed;
                    }
                    if (!closedSync && logger.isLoggable(Level.INFO)) {
                        String msg = "handling connection {0} throws";
                        Utilities arg = connection;
                        if (connection == null) {
                            msg = "accepting connection on {0} throws";
                            arg = this;
                        }
                        SslListenHandle.logThrow(logger, Level.INFO, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslListenHandle == null ? SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslListenHandle") : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslListenHandle, "acceptLoop", msg, new Object[]{arg}, exception);
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (closedSync) break block25;
                    boolean bl = knownFailure = exception instanceof Exception || exception instanceof OutOfMemoryError || exception instanceof NoClassDefFoundError;
                    if (!knownFailure || !this.continueAfterAcceptFailure(exception)) break;
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!knownFailure) {
                    throw (Error)exception;
                }
                return;
            }
        }

        private boolean continueAfterAcceptFailure(Throwable t) {
            int NFAIL = 10;
            int NMSEC = 5000;
            long now = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || now - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = now;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        public String toString() {
            return SslListenHandle.getClassName(this) + "[" + SslServerEndpointImpl.this.serverHost + ":" + this.getPort() + "]";
        }

        SslServerConnection serverConnection(Socket socket) throws IOException {
            return new SslServerConnection(this, socket);
        }

        void handleConnection(SslServerConnection connection, RequestDispatcher requestDispatcher) {
            SslServerEndpointImpl.this.serverConnectionManager.handleConnection(connection, requestDispatcher);
        }

        private int getPort() {
            return this.serverSocket.getLocalPort();
        }

        public synchronized void close() {
            if (!this.closed) {
                logger.log(Level.FINE, "closing {0}", this);
                this.closed = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Iterator i = this.connections.iterator();
                while (i.hasNext()) {
                    SslServerConnection connection = (SslServerConnection)i.next();
                    try {
                        connection.closeInternal(false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    i.remove();
                }
            }
        }

        synchronized void noteConnectionClosed(SslServerConnection connection) {
            this.connections.remove(connection);
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return new SslListenCookie(this.getPort());
        }

        static /* synthetic */ RequestDispatcher access$000(SslListenHandle x0) {
            return x0.requestDispatcher;
        }
    }

    class SslListenEndpoint
    extends Utilities
    implements ServerEndpoint.ListenEndpoint {
        SslListenEndpoint() {
        }

        public void checkPermissions() {
            SslServerEndpointImpl.this.checkListenPermissions(true);
        }

        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            if (requestDispatcher == null) {
                throw new NullPointerException("Request dispatcher cannot be null");
            }
            this.checkCredentials();
            ServerSocket serverSocket = SslServerEndpointImpl.this.serverSocketFactory != null ? SslServerEndpointImpl.this.serverSocketFactory.createServerSocket(SslServerEndpointImpl.this.port) : new ServerSocket(SslServerEndpointImpl.this.port);
            return this.createListenHandle(requestDispatcher, serverSocket);
        }

        private void checkCredentials() throws UnsupportedConstraintException {
            if (SslServerEndpointImpl.this.serverSubject == null) {
                return;
            }
            SslServerEndpointImpl.this.checkListenPermissions(false);
            Set<Principal> principals = SslServerEndpointImpl.this.serverSubject.getPrincipals();
            HashMap<X500Principal, Serializable> progress = new HashMap<X500Principal, Serializable>(SslServerEndpointImpl.this.serverPrincipals.size());
            Iterator i = SslServerEndpointImpl.this.serverPrincipals.iterator();
            while (i.hasNext()) {
                X500Principal p = (X500Principal)i.next();
                if (!principals.contains(p)) {
                    throw new UnsupportedConstraintException("Missing principal: " + p);
                }
                progress.put(p, class$javax$security$auth$x500$X500Principal == null ? SslServerEndpointImpl.class$("javax.security.auth.x500.X500Principal") : class$javax$security$auth$x500$X500Principal);
            }
            X500PrivateCredential[] privateCredentials = (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(SslServerEndpointImpl.this.serverSubject));
            List certPaths = SubjectCredentials.getCertificateChains(SslServerEndpointImpl.this.serverSubject);
            if (certPaths != null) {
                int i2 = certPaths.size();
                block3: while (--i2 >= 0) {
                    CertPath chain = (CertPath)certPaths.get(i2);
                    X509Certificate firstCert = SslListenEndpoint.firstX509Cert(chain);
                    X500Principal p = firstCert.getSubjectX500Principal();
                    if (!progress.containsKey(p)) continue;
                    try {
                        SslListenEndpoint.checkValidity(chain, null);
                    }
                    catch (CertificateException e) {
                        progress.put(p, e);
                        continue;
                    }
                    progress.put(p, class$java$security$cert$CertPath == null ? SslServerEndpointImpl.class$("java.security.cert.CertPath") : class$java$security$cert$CertPath);
                    int j = privateCredentials.length;
                    while (--j >= 0) {
                        X509Certificate cert = privateCredentials[j].getCertificate();
                        if (!firstCert.equals(cert)) continue;
                        progress.remove(p);
                        continue block3;
                    }
                }
            }
            if (!progress.isEmpty()) {
                X500Principal p = (X500Principal)progress.keySet().iterator().next();
                Object result = progress.get(p);
                if (result == (class$javax$security$auth$x500$X500Principal == null ? (class$javax$security$auth$x500$X500Principal = SslServerEndpointImpl.class$("javax.security.auth.x500.X500Principal")) : class$javax$security$auth$x500$X500Principal)) {
                    throw new UnsupportedConstraintException("Missing public credentials: " + p);
                }
                if (result == (class$java$security$cert$CertPath == null ? (class$java$security$cert$CertPath = SslServerEndpointImpl.class$("java.security.cert.CertPath")) : class$java$security$cert$CertPath)) {
                    throw new UnsupportedConstraintException("Missing private credentials: " + p);
                }
                throw new UnsupportedConstraintException("Problem with certificates: " + p + "\n" + result, (CertificateException)result);
            }
        }

        ServerEndpoint.ListenHandle createListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
            return new SslListenHandle(requestDispatcher, serverSocket);
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ System.identityHashCode(SslServerEndpointImpl.this.serverSubject) ^ (SslServerEndpointImpl.this.serverPrincipals == null ? 0 : ((Object)SslServerEndpointImpl.this.serverPrincipals).hashCode()) ^ SslServerEndpointImpl.this.port ^ (SslServerEndpointImpl.this.serverSocketFactory != null ? SslServerEndpointImpl.this.serverSocketFactory.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SslServerEndpointImpl other = ((SslListenEndpoint)object).getImpl();
            return SslServerEndpointImpl.this.serverSubject == other.serverSubject && SslListenEndpoint.safeEquals(SslServerEndpointImpl.this.serverPrincipals, other.serverPrincipals) && SslServerEndpointImpl.this.port == other.port && Util.sameClassAndEquals(SslServerEndpointImpl.this.serverSocketFactory, other.serverSocketFactory);
        }

        private SslServerEndpointImpl getImpl() {
            return SslServerEndpointImpl.this;
        }
    }
}

