/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.ConstraintsChecker;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X509CertImpl;

class ReverseState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    X500Principal subjectDN;
    PublicKey pubKey;
    SubjectKeyIdentifierExtension subjKeyId;
    NameConstraintsExtension nc;
    int explicitPolicy;
    int policyMapping;
    int inhibitAnyPolicy;
    int certIndex;
    PolicyNodeImpl rootNode;
    int remainingCACerts;
    ArrayList userCheckers;
    private boolean init = true;
    public CrlRevocationChecker crlChecker;
    TrustAnchor trustAnchor;

    ReverseState() {
    }

    public boolean isInitial() {
        return this.init;
    }

    public boolean keyParamsNeeded() {
        return false;
    }

    public Object clone() {
        try {
            ReverseState reverseState = (ReverseState)super.clone();
            reverseState.userCheckers = (ArrayList)this.userCheckers.clone();
            ListIterator<Object> listIterator = reverseState.userCheckers.listIterator();
            while (listIterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)listIterator.next();
                if (!(pKIXCertPathChecker instanceof Cloneable)) continue;
                listIterator.set(pKIXCertPathChecker.clone());
            }
            if (this.nc != null) {
                reverseState.nc = new NameConstraintsExtension(new Boolean(this.nc.isCritical()), this.nc.getExtensionValue());
            }
            if (this.rootNode != null) {
                reverseState.rootNode = this.rootNode.copyTree();
            }
            return reverseState;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer;
        block2: {
            stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("State [");
                stringBuffer.append("\n  subjectDN of last cert: " + this.subjectDN);
                stringBuffer.append("\n  subjectKeyIdentifier: " + String.valueOf(this.subjKeyId));
                stringBuffer.append("\n  nameConstraints: " + String.valueOf(this.nc));
                stringBuffer.append("\n  certIndex: " + this.certIndex);
                stringBuffer.append("\n  explicitPolicy: " + this.explicitPolicy);
                stringBuffer.append("\n  policyMapping:  " + this.policyMapping);
                stringBuffer.append("\n  inhibitAnyPolicy:  " + this.inhibitAnyPolicy);
                stringBuffer.append("\n  rootNode: " + this.rootNode);
                stringBuffer.append("\n  remainingCACerts: " + this.remainingCACerts);
                stringBuffer.append("\n  init: " + String.valueOf(this.init));
                stringBuffer.append("\n]\n");
            }
            catch (Exception exception) {
                if (debug == null) break block2;
                debug.println("ReverseState.toString() unexpected exception");
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    public void updateState(TrustAnchor trustAnchor) throws CertificateException, IOException, CertPathValidatorException {
        this.trustAnchor = trustAnchor;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate != null) {
            this.updateState(x509Certificate);
        } else {
            X500Principal x500Principal = CertPathHelper.getCA(trustAnchor);
            this.updateState(trustAnchor.getCAPublicKey(), x500Principal);
        }
        this.init = false;
    }

    public void updateState(X509Certificate x509Certificate) throws CertificateException, IOException, CertPathValidatorException {
        if (x509Certificate == null) {
            return;
        }
        this.subjectDN = x509Certificate.getSubjectX500Principal();
        X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.pubKey);
        }
        this.pubKey = publicKey;
        if (this.init) {
            this.init = false;
            return;
        }
        this.subjKeyId = x509CertImpl.getSubjectKeyIdentifierExtension();
        if (this.nc != null) {
            this.nc.merge(x509CertImpl.getNameConstraintsExtension());
        } else {
            this.nc = x509CertImpl.getNameConstraintsExtension();
        }
        this.explicitPolicy = PolicyChecker.mergeExplicitPolicy(this.explicitPolicy, x509CertImpl, false);
        this.policyMapping = PolicyChecker.mergePolicyMapping(this.policyMapping, x509CertImpl);
        this.inhibitAnyPolicy = PolicyChecker.mergeInhibitAnyPolicy(this.inhibitAnyPolicy, x509CertImpl);
        ++this.certIndex;
        this.remainingCACerts = ConstraintsChecker.mergeBasicConstraints(x509Certificate, this.remainingCACerts);
        this.init = false;
    }

    public void initState(int n2, boolean bl2, boolean bl3, boolean bl4, List list) throws CertPathValidatorException {
        this.remainingCACerts = n2 == -1 ? Integer.MAX_VALUE : n2;
        if (bl2) {
            this.explicitPolicy = 0;
        } else {
            int n3 = this.explicitPolicy = n2 == -1 ? n2 : n2 + 2;
        }
        if (bl3) {
            this.policyMapping = 0;
        } else {
            int n4 = this.policyMapping = n2 == -1 ? n2 : n2 + 2;
        }
        this.inhibitAnyPolicy = bl4 ? 0 : (n2 == -1 ? n2 : n2 + 2);
        this.certIndex = 1;
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add("2.5.29.32.0");
        this.rootNode = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, hashSet, false);
        if (list != null) {
            this.userCheckers = new ArrayList(list);
            Iterator iterator = this.userCheckers.iterator();
            while (iterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)iterator.next();
                pKIXCertPathChecker.init(false);
            }
        } else {
            this.userCheckers = new ArrayList();
        }
        this.init = true;
    }

    private void updateState(PublicKey publicKey, X500Principal x500Principal) {
        this.subjectDN = x500Principal;
        this.pubKey = publicKey;
    }
}

