/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.ByteArrayInputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetPropertyAction;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.util.Cache;
import sun.security.util.Debug;

public class LDAPCertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean DEBUG = false;
    private static final String USER_CERT = "userCertificate;binary";
    private static final String CA_CERT = "cACertificate;binary";
    private static final String CROSS_CERT = "crossCertificatePair;binary";
    private static final String CRL = "certificateRevocationList;binary";
    private static final String ARL = "authorityRevocationList;binary";
    private static final String DELTA_CRL = "deltaRevocationList;binary";
    private static final String[] STRING0 = new String[0];
    private static final byte[][] BB0 = new byte[0][];
    private static final Attributes EMPTY_ATTRIBUTES = new BasicAttributes();
    private static final int DEFAULT_CACHE_SIZE = 750;
    private static final int DEFAULT_CACHE_LIFETIME = 30;
    private static final int LIFETIME;
    private static final String PROP_LIFETIME = "sun.security.certpath.ldap.cache.lifetime";
    private CertificateFactory cf;
    private DirContext ctx;
    private boolean prefetchCRLs = false;
    private final Cache valueCache;
    private int cacheHits = 0;
    private int cacheMisses = 0;
    private int requests = 0;

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction(PROP_LIFETIME);
        String string = AccessController.doPrivileged(getPropertyAction);
        LIFETIME = string != null ? Integer.parseInt(string) : 30;
    }

    private void createInitialDirContext(String string, int n2) throws InvalidAlgorithmParameterException {
        String string2 = "ldap://" + string + ":" + n2;
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", string2);
        try {
            this.ctx = new InitialDirContext(properties);
            Hashtable<?, ?> hashtable = this.ctx.getEnvironment();
            if (hashtable.get("java.naming.referral") == null) {
                this.ctx.addToEnvironment("java.naming.referral", "follow");
            }
        }
        catch (NamingException namingException) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineInit about to throw InvalidAlgorithmParameterException");
                namingException.printStackTrace();
            }
            InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException("unable to create InitialDirContext using supplied parameters");
            invalidAlgorithmParameterException.initCause(namingException);
            throw invalidAlgorithmParameterException;
        }
    }

    public LDAPCertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        LDAPCertStoreParameters lDAPCertStoreParameters = (LDAPCertStoreParameters)certStoreParameters;
        this.createInitialDirContext(lDAPCertStoreParameters.getServerName(), lDAPCertStoreParameters.getPort());
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new InvalidAlgorithmParameterException("unable to create CertificateFactory for X.509");
        }
        this.valueCache = LIFETIME == 0 ? Cache.newNullCache() : (LIFETIME < 0 ? Cache.newSoftMemoryCache(750) : Cache.newSoftMemoryCache(750, LIFETIME));
    }

    public synchronized Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        Object object;
        Collection<Object> collection;
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCRLs() selector: " + cRLSelector);
        }
        if (cRLSelector == null) {
            cRLSelector = new X509CRLSelector();
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        HashSet hashSet = new HashSet();
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate != null) {
            collection = new HashSet<Object>();
            object = x509Certificate.getIssuerX500Principal();
            collection.add(((X500Principal)object).getName("RFC2253"));
        } else {
            collection = x509CRLSelector.getIssuerNames();
            if (collection == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        object = collection.iterator();
        while (object.hasNext()) {
            LDAPRequest lDAPRequest;
            String string;
            Object object2;
            block17: {
                block16: {
                    Object e2 = object.next();
                    if (e2 instanceof byte[]) {
                        try {
                            object2 = new X500Principal((byte[])e2);
                            string = ((X500Principal)object2).getName("RFC2253");
                            break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                    }
                    string = (String)e2;
                }
                object2 = Collections.EMPTY_LIST;
                if (x509Certificate == null || x509Certificate.getBasicConstraints() != -1) {
                    lDAPRequest = new LDAPRequest(string);
                    lDAPRequest.addRequestedAttribute(CROSS_CERT);
                    lDAPRequest.addRequestedAttribute(CA_CERT);
                    lDAPRequest.addRequestedAttribute(ARL);
                    if (this.prefetchCRLs) {
                        lDAPRequest.addRequestedAttribute(CRL);
                    }
                    try {
                        object2 = this.getCRLs(lDAPRequest, ARL, x509CRLSelector);
                        if (object2.isEmpty()) {
                            this.prefetchCRLs = true;
                        }
                    }
                    catch (CertStoreException certStoreException) {
                        if (debug == null) break block17;
                        debug.println("LDAPCertStore.engineGetCRLs non-fatal error retrieving ARLs:" + certStoreException);
                        certStoreException.printStackTrace();
                    }
                }
            }
            if (object2.isEmpty() || x509Certificate == null) {
                lDAPRequest = new LDAPRequest(string);
                lDAPRequest.addRequestedAttribute(CRL);
                object2 = this.getCRLs(lDAPRequest, CRL, x509CRLSelector);
            }
            hashSet.addAll(object2);
        }
        return hashSet;
    }

    public synchronized Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        LDAPRequest lDAPRequest;
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() selector: " + String.valueOf(certSelector));
        }
        if (certSelector == null) {
            certSelector = new X509CertSelector();
        }
        if (!(certSelector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        X509CertSelector x509CertSelector = (X509CertSelector)certSelector;
        int n2 = x509CertSelector.getBasicConstraints();
        String string = x509CertSelector.getSubjectAsString();
        String string2 = x509CertSelector.getIssuerAsString();
        HashSet hashSet = new HashSet();
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() basicConstraints: " + n2);
        }
        if (string != null) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is not null");
            }
            lDAPRequest = new LDAPRequest(string);
            if (n2 > -2) {
                lDAPRequest.addRequestedAttribute(CROSS_CERT);
                lDAPRequest.addRequestedAttribute(CA_CERT);
                lDAPRequest.addRequestedAttribute(ARL);
                if (this.prefetchCRLs) {
                    lDAPRequest.addRequestedAttribute(CRL);
                }
            }
            if (n2 < 0) {
                lDAPRequest.addRequestedAttribute(USER_CERT);
            }
            if (n2 > -2) {
                hashSet.addAll(this.getMatchingCrossCerts(lDAPRequest, x509CertSelector, null));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(subject,xsel,null),certs.size(): " + hashSet.size());
                }
                hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT, x509CertSelector));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,CA_CERT,xsel),certs.size(): " + hashSet.size());
                }
            }
            if (n2 < 0) {
                hashSet.addAll(this.getCertificates(lDAPRequest, USER_CERT, x509CertSelector));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,USER_CERT, xsel),certs.size(): " + hashSet.size());
                }
            }
        } else {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is null");
            }
            if (n2 == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (string2 == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() about to getMatchingCrossCerts...");
        }
        if (string2 != null && n2 > -2) {
            lDAPRequest = new LDAPRequest(string2);
            lDAPRequest.addRequestedAttribute(CROSS_CERT);
            lDAPRequest.addRequestedAttribute(CA_CERT);
            lDAPRequest.addRequestedAttribute(ARL);
            if (this.prefetchCRLs) {
                lDAPRequest.addRequestedAttribute(CRL);
            }
            hashSet.addAll(this.getMatchingCrossCerts(lDAPRequest, null, x509CertSelector));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(issuer,null,xsel),certs.size(): " + hashSet.size());
            }
            hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT, x509CertSelector));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(issuer,CA_CERT,xsel),certs.size(): " + hashSet.size());
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() returning certs");
        }
        return hashSet;
    }

    private Collection getCertPairs(LDAPRequest lDAPRequest, String string) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509CertificatePair> arrayList = new ArrayList<X509CertificatePair>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                X509CertificatePair x509CertificatePair = X509CertificatePair.generateCertificatePair(byArray[i2]);
                arrayList.add(x509CertificatePair);
                continue;
            }
            catch (CertificateException certificateException) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCertPairs() encountered exception while parsing cert, skipping the bad data: ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i2]) + " ]");
            }
        }
        return arrayList;
    }

    private Collection getCRLs(LDAPRequest lDAPRequest, String string, CRLSelector cRLSelector) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CRL> arrayList = new ArrayList<CRL>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                CRL cRL = this.cf.generateCRL(new ByteArrayInputStream(byArray[i2]));
                if (!cRLSelector.match(cRL)) continue;
                arrayList.add(cRL);
                continue;
            }
            catch (CRLException cRLException) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCRLs() encountered exception while parsing CRL, skipping the bad data: ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i2]) + " ]");
            }
        }
        return arrayList;
    }

    private Collection getCertificates(LDAPRequest lDAPRequest, String string, CertSelector certSelector) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[i2]);
            try {
                Certificate certificate = this.cf.generateCertificate(byteArrayInputStream);
                if (!certSelector.match(certificate)) continue;
                arrayList.add(certificate);
                continue;
            }
            catch (CertificateException certificateException) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCertificates() encountered exception while parsing cert, skipping the bad data: ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i2]) + " ]");
            }
        }
        return arrayList;
    }

    private Collection getMatchingCrossCerts(LDAPRequest lDAPRequest, CertSelector certSelector, CertSelector certSelector2) throws CertStoreException {
        Collection collection = this.getCertPairs(lDAPRequest, CROSS_CERT);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate;
            X509CertificatePair x509CertificatePair = (X509CertificatePair)iterator.next();
            if (certSelector != null && (x509Certificate = x509CertificatePair.getForward()) != null && certSelector.match(x509Certificate)) {
                arrayList.add(x509Certificate);
            }
            if (certSelector2 == null || (x509Certificate = x509CertificatePair.getReverse()) == null || !certSelector2.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    private class LDAPRequest {
        private final String name;
        private Map valueMap;
        private final List requestedAttributes;

        String getName() {
            return this.name;
        }

        void addRequestedAttribute(String string) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            this.requestedAttributes.add(string);
        }

        byte[][] getValues(String string) throws NamingException {
            String string2 = this.name + "|" + string;
            byte[][] byArray = (byte[][])LDAPCertStore.this.valueCache.get(string2);
            if (byArray != null) {
                LDAPCertStore.this.cacheHits++;
                return byArray;
            }
            LDAPCertStore.this.cacheMisses++;
            Map map = this.getValueMap();
            byArray = (byte[][])map.get(string);
            return byArray;
        }

        private void cacheAttribute(String string, byte[][] byArray) {
            String string2 = this.name + "|" + string;
            LDAPCertStore.this.valueCache.put(string2, byArray);
        }

        private Map getValueMap() throws NamingException {
            Attributes attributes;
            if (this.valueMap != null) {
                return this.valueMap;
            }
            this.valueMap = new HashMap(8);
            String[] stringArray = this.requestedAttributes.toArray(STRING0);
            try {
                attributes = LDAPCertStore.this.ctx.getAttributes(this.name, stringArray);
            }
            catch (NameNotFoundException nameNotFoundException) {
                attributes = EMPTY_ATTRIBUTES;
            }
            Iterator iterator = this.requestedAttributes.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Attribute attribute = attributes.get(string);
                byte[][] byArray = this.getAttributeValues(attribute);
                this.cacheAttribute(string, byArray);
                this.valueMap.put(string, byArray);
            }
            return this.valueMap;
        }

        private byte[][] getAttributeValues(Attribute attribute) throws NamingException {
            Object object;
            if (attribute == null) {
                object = BB0;
            } else {
                object = new byte[attribute.size()][];
                int n2 = 0;
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    Object obj = namingEnumeration.next();
                    if (debug != null && obj instanceof String) {
                        debug.println("LDAPCertStore.getAttrValues() enum.next is a string!: " + obj);
                    }
                    byte[] byArray = (byte[])obj;
                    object[n2++] = byArray;
                }
            }
            return object;
        }

        LDAPRequest(String string) {
            this.name = string;
            this.requestedAttributes = new ArrayList(5);
        }
    }
}

