/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.CoreAction;
import org.isqlviewer.core.action.DefaultActionManager;
import org.isqlviewer.core.action.DefaultMenuBar;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.event.DatabaseEvent;
import org.isqlviewer.event.DatabaseListener;
import org.isqlviewer.sql.BatchRunner;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.BookmarkEditor;
import org.isqlviewer.swing.BookmarkTreeCellRenderer;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.swing.JDrawer;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.AboutBox;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.ui.BatchWizard;
import org.isqlviewer.ui.DataMigrator;
import org.isqlviewer.ui.HistoryViewer;
import org.isqlviewer.ui.ImportWizard;
import org.isqlviewer.ui.JDBCExplorer;
import org.isqlviewer.ui.LoginOptionPane;
import org.isqlviewer.ui.PreferencesEditor;
import org.isqlviewer.ui.QueryWizard;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.ui.ScriptManager;
import org.isqlviewer.ui.ServiceManager;
import org.isqlviewer.ui.TableEditor;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class MainFrame
extends JFrame
implements AppController {
    private static final long serialVersionUID = 1L;
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    public final ThreadGroup BATCH_THREADS = new ThreadGroup("isql-batch-threads");
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private UserPreferences preferences = this.sysConfig.getPreferences();
    private ServiceDefinition serviceDef;
    private DatabaseConnection databaseConnection;
    private Thread actionThread;
    private DefaultMenuBar menuBar;
    private MainToolbar fileBar;
    private SQLWorkBench workbench;
    private ActionManager actionManager = null;
    private ActionManagerHandler actionHandler = new ActionManagerHandler(null);
    private JConsole sysOut = new JConsole(BasicUtilities.getString("Default_Console_String") + "\n");
    private TreeDropTarget dndHandler = new TreeDropTarget(null);
    private JDrawer bookDrawer = null;
    private JSplitPane rootPane = new JSplitPane(0);
    private JTree treBookmarks = null;
    private JPanel contentPane = new JPanel(new BorderLayout());
    private JPanel statusBar = null;
    private JLabel lblInfo = new JLabel("", 2);
    private JLabel lblCommit = new JLabel(" " + BasicUtilities.getString("AutoCommit_ON") + " ", 0);
    private DragSource dndDragSource = DragSource.getDefaultDragSource();
    private JTextComponent defaultComponent = null;
    private String currentStatus = "";
    private WizardPanel panel = new WizardPanel();
    static /* synthetic */ Class class$org$isqlviewer$ui$MainFrame;

    public MainFrame() {
        super("iSQL-Viewer v.2.1.8");
        Object object;
        JFrame.setDefaultLookAndFeelDecorated(false);
        if (BasicUtilities.isMac()) {
            try {
                object = Class.forName("org.isqlviewer.mrj.MRJAdapter");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$org$isqlviewer$ui$MainFrame;
                if (clazz == null) {
                    clazz = class$org$isqlviewer$ui$MainFrame = new MainFrame[0].getClass().getComponentType();
                }
                classArray[0] = clazz;
                ((Class)object).getConstructor(classArray).newInstance(this);
                System.setProperty("isql.mrj.enabled", "true");
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "mrj:<init>");
            }
        }
        this.enableEvents(24L);
        this.actionManager = new DefaultActionManager();
        this.menuBar = new DefaultMenuBar(this.actionManager);
        object = this.sysConfig.getHistoryManager();
        ((HistoryManager)object).addChangeListener(this.actionHandler);
        boolean bl2 = ((HistoryManager)object).size() >= 1;
        this.actionManager.setActionEnabled(7, bl2);
        this.actionManager.setActionEnabled(48, false);
        this.actionManager.addActionListener(this.actionHandler);
        this.actionManager.addItemListener(this.actionHandler);
        this.actionManager.addPropertyChangeListener(this.actionHandler);
        this.actionThread = new Thread((Runnable)this.actionManager, "action-manager-thread");
        this.actionThread.setDaemon(true);
        this.actionThread.start();
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "MainFrame::initUI()");
            System.exit(-1);
            return;
        }
    }

    public void setDBConnection(DatabaseConnection databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public SQLWorkBench getWorkBench() {
        return this.workbench;
    }

    public void addAccessory(int n2, JComponent jComponent) {
        Container container = this.getContentPane();
        switch (n2) {
            case 3: 
            case 4: {
                container.add((Component)jComponent, "East");
                break;
            }
            case 2: 
            case 7: {
                container.add((Component)jComponent, "West");
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(n2));
            }
        }
    }

    public void removeAccessory(int n2, JComponent jComponent) {
    }

    public Component zoomComponent(Component component) {
        Component component2 = this.panel.removeCard("ZOOM");
        if (component != null && component != component2) {
            this.panel.add(component, "ZOOM");
            this.panel.showCard("ZOOM");
            this.validateTree();
        }
        return component2;
    }

    public boolean validateConnection() {
        if (!this.isValidDatabaseConnection() && this.promptForService() != 1) {
            this.updateStatus(BasicUtilities.getString("Not_Connected"));
            System.out.println(BasicUtilities.getString("Invalid_Connection"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.databaseConnection == null) {
            System.out.println(BasicUtilities.getString("Not_Connected"));
            return;
        }
        if (this.databaseConnection.isClosed()) {
            this.updateStatus(BasicUtilities.getString("Already_Disconnected"));
        } else {
            Object object;
            if (!this.databaseConnection.getVerboseOn()) {
                System.out.println(BasicUtilities.getString("Disconnect_Message", this.databaseConnection.getConnectionName()));
            }
            this.databaseConnection.removeDatabaseListener(this.actionHandler);
            this.currentStatus = BasicUtilities.getString("Disconnected");
            try {
                object = this.databaseConnection.getConnectionName();
                this.serviceDef.close();
                System.out.println(BasicUtilities.getString("Disconnect_Success", (String)object));
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, BasicUtilities.getString("Disconnect_Exception"));
            }
            finally {
                this.actionManager.setActionEnabled(12, false);
                this.actionManager.setActionEnabled(14, false);
                this.actionManager.setActionEnabled(13, false);
                this.actionManager.setActionEnabled(48, false);
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
                this.databaseConnection = null;
                this.serviceDef = null;
            }
            this.updateStatus(this.currentStatus);
            object = this.sysConfig.getIPCService();
            ((IPCService)object).publish(this, "isql-service-change", null);
        }
        try {
            DriverManager.getLogWriter().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public DatabaseConnection getJDBCConnection() {
        return this.databaseConnection;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public void updateStatus(String string) {
        String[] stringArray = new String[]{BasicUtilities.getString("Status"), string};
        this.lblInfo.setText(BasicUtilities.getString("Status_Label", stringArray));
    }

    public void changeService(String string) {
        Object object;
        if (this.serviceDef != null && this.serviceDef.getName().equals(string) && this.isValidDatabaseConnection()) {
            System.out.println(BasicUtilities.getString("Already_Connected_Message", string));
            return;
        }
        this.disconnect();
        this.actionManager.setActionEnabled(14, false);
        this.actionManager.setActionEnabled(13, false);
        this.actionManager.setActionEnabled(48, false);
        this.databaseConnection = null;
        ServiceProvider serviceProvider = this.sysConfig.getServiceProvider();
        try {
            this.serviceDef = serviceProvider.serviceForName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BasicUtilities.showExceptionPopup(this, illegalArgumentException, null);
            return;
        }
        this.initTracing(this.serviceDef.getPreferences());
        try {
            this.databaseConnection = this.serviceDef.createConnection();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = BasicUtilities.getString("Connect_Failed", classNotFoundException.getMessage());
            BasicUtilities.HandleException(classNotFoundException, string2);
            System.err.println(BasicUtilities.getString("No_Class_Error", this.serviceDef.getDriverClass()));
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        catch (SQLException sQLException) {
            String string3 = BasicUtilities.getString("Connect_Failed", sQLException.getMessage());
            System.err.println(string3);
            BasicUtilities.showExceptionPopup(this, sQLException, string3);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
        }
        if (this.serviceDef.isPromptRequired()) {
            object = LoginOptionPane.showDialog(this);
            if (object == null) {
                System.out.println(BasicUtilities.getString("Connect_Cancelled", string));
                this.databaseConnection = null;
                this.serviceDef.close();
                this.serviceDef = null;
                return;
            }
            this.databaseConnection.updateAutheticationTokens(object[0], (String)object[1]);
        }
        try {
            if (!this.databaseConnection.gsConnect()) {
                object = this.databaseConnection.getLastError();
                String string4 = BasicUtilities.getString("Connect_Failed", ((Throwable)object).getMessage());
                System.err.println(string4);
                BasicUtilities.showExceptionPopup(this, this.databaseConnection.getLastError(), string4);
                this.databaseConnection = null;
                this.serviceDef.close();
                this.serviceDef = null;
                return;
            }
        }
        catch (SQLException sQLException) {
            String string5 = BasicUtilities.getString("Connect_Failed", sQLException.getMessage());
            System.err.println(string5);
            BasicUtilities.showExceptionPopup(this, sQLException, string5);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        catch (Throwable throwable) {
            String string6 = BasicUtilities.getString("Connect_Failed", throwable.getMessage());
            BasicUtilities.HandleException(throwable, string6);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        System.out.println(BasicUtilities.getString("Connect_Sucess_Message", string));
        this.updateStatus(BasicUtilities.getString("Connect_Status", string));
        boolean bl2 = this.databaseConnection.isTransactionsSupported();
        this.actionManager.setActionEnabled(12, bl2);
        bl2 = this.databaseConnection.isSavePointsSupported();
        this.actionManager.setActionEnabled(48, bl2);
        this.databaseConnection.addDatabaseListener(this.actionHandler);
        IPCService iPCService = this.sysConfig.getIPCService();
        iPCService.publish(this, "isql-service-change", this.databaseConnection);
    }

    public boolean isValidDatabaseConnection() {
        if (this.databaseConnection == null) {
            return false;
        }
        return !this.databaseConnection.isClosed();
    }

    public int promptForService() {
        return 1;
    }

    public void showInvalidConnection() {
        String string = BasicUtilities.getString("Connection_Nag");
        String string2 = BasicUtilities.getString("Error");
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    public void setDefaultTextComponent(JTextComponent jTextComponent) {
        this.menuBar.addEditMenu(jTextComponent);
        this.defaultComponent = jTextComponent;
    }

    public Window getRootWindow() {
        return this;
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            Boolean bl2 = (Boolean)this.getRootPane().getClientProperty("windowModified");
            if (bl2.booleanValue()) {
                Object[] objectArray;
                int n2;
                int n3;
                String string;
                String string2 = BasicUtilities.getString("Transaction_Pending_Warning");
                int n4 = JOptionPane.showOptionDialog(this, string2, string = BasicUtilities.getString("Warning"), n3 = 1, n2 = 2, null, objectArray = new String[]{BasicUtilities.getString("Commit"), BasicUtilities.getString("Rollback"), BasicUtilities.getString("Cancel")}, objectArray[0]);
                if (n4 == 1) {
                    this.databaseConnection.performRollBack();
                    this.databaseConnection.setAutoCommit(true);
                    this.disconnect();
                } else if (n4 == 0) {
                    this.databaseConnection.performCommit();
                    this.databaseConnection.setAutoCommit(true);
                    this.disconnect();
                } else {
                    return;
                }
            }
            this.finalizeApplication();
            if (Boolean.getBoolean("isql.stand-alone")) {
                System.exit(0);
            }
        } else if (windowEvent.getID() == 200) {
            this.updateStatus("");
            System.out.println(BasicUtilities.getString("Init_Success", "2.1.8"));
            System.setOut(new PrintStream(this.sysOut.toOutputStream(), true));
            System.setErr(new PrintStream(this.sysOut.createFilteredStream("err"), true));
            this.checkEmptyServices();
            this.connectStartupService();
            this.bookDrawer = this.configureBookmarkDrawer();
            if (this.preferences.getBoolean("advanced.versioncheck-enabled")) {
                this.performWebCheck(false);
            }
        } else if (windowEvent.getID() == 205) {
            if (this.defaultComponent != null) {
                this.defaultComponent.requestFocus();
            }
            if (this.bookDrawer != null && this.bookDrawer.isVisible()) {
                this.bookDrawer.toFront();
            }
        }
        super.processWindowEvent(windowEvent);
        System.runFinalization();
    }

    public void handleActionEvent(ActionEvent actionEvent) {
        int n2 = actionEvent.getID();
        switch (n2) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                TreePath treePath = this.treBookmarks.getSelectionPath();
                Object object = treePath == null ? null : treePath.getLastPathComponent();
                this.handleBookmarkAction(n2, object);
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 31: {
                this.performWebCheck(true);
                break;
            }
            case 12: {
                this.databaseConnection.setAutoCommit(!this.databaseConnection.getAutoCommit());
                break;
            }
            case 4: {
                PreferencesEditor.showDialog(this);
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 3: {
                ServiceManager.showDialog(this);
                this.menuBar.refreshServiceMenu();
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 0: {
                File file = BasicUtilities.saveSystemFile(this);
                if (file == null) break;
                this.sysConfig.getHistoryManager().store(file);
                break;
            }
            case 36: {
                if (!this.validateConnection()) break;
                QueryWizard.showDialog(this, this.databaseConnection, this.workbench);
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 34: {
                ScriptManager.showDialog(this, this.databaseConnection, this.workbench);
                break;
            }
            case 41: {
                this.doQuickBatch();
                break;
            }
            case 9: {
                if (!this.validateConnection()) break;
                ImportWizard importWizard = new ImportWizard((Frame)this, this.databaseConnection);
                importWizard.show();
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 46: {
                DataMigrator dataMigrator = new DataMigrator(this, this);
                dataMigrator.show();
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 2: {
                if (!this.isValidDatabaseConnection() && this.promptForService() != 1) {
                    return;
                }
                JDBCExplorer.showDialog(this);
                break;
            }
            case 42: {
                if (!this.validateConnection()) break;
                TableEditor.showDialog(this);
                break;
            }
            case 25: {
                this.disconnect();
                break;
            }
            case -2: {
                if (!this.validateConnection()) break;
                try {
                    String[] stringArray = new String[]{this.databaseConnection.getCatalog(), actionEvent.getActionCommand()};
                    String string = BasicUtilities.getString("Catalog_Change", stringArray);
                    System.out.println(string);
                    this.databaseConnection.changeCatalog(actionEvent.getActionCommand());
                }
                catch (SQLException sQLException) {
                    String string = BasicUtilities.getString("Catalog_Change_Err", actionEvent.getActionCommand());
                    BasicUtilities.showExceptionPopup(this, sQLException, string);
                }
                catch (Throwable throwable) {
                    String string = BasicUtilities.getString("Catalog_Change_Err", actionEvent.getActionCommand());
                    BasicUtilities.HandleException(throwable, string);
                }
                break;
            }
            case 7: {
                HistoryViewer.showDialog(this, this.sysConfig.getHistoryManager(), this.workbench);
                break;
            }
            case 6: {
                BatchWizard.showDialog(this);
                break;
            }
            case -1: {
                this.changeService(actionEvent.getActionCommand());
                break;
            }
            case 33: {
                if (this.bookDrawer == null) break;
                this.bookDrawer.toggle();
                break;
            }
            case 24: {
                SQLWarningViewer.showDialog(this);
                break;
            }
            case 14: {
                if (this.databaseConnection == null) break;
                this.databaseConnection.performRollBack();
                break;
            }
            case 48: {
                BasicUtilities.beep();
                break;
            }
            case 13: {
                if (this.databaseConnection == null) break;
                this.databaseConnection.performCommit();
                break;
            }
            case 23: {
                AboutBox.showDialog(this);
                break;
            }
            case 8: {
                this.dispatchEvent(new WindowEvent(this, 201));
            }
        }
    }

    public void performWebCheck(boolean bl2) {
        try {
            System.out.println(BasicUtilities.getString("Checking_For_Updated_iSQL"));
            Object[] objectArray = this.sysConfig.performWebCheck();
            int n2 = this.preferences.getInt("advanced.versioncheck-type");
            if (n2 == 0 && objectArray[0].toString().equalsIgnoreCase("Beta") && !bl2 || !((Boolean)objectArray[2]).booleanValue()) {
                System.out.println(BasicUtilities.getString("No_Update_Available"));
            } else if (((Boolean)objectArray[2]).booleanValue()) {
                System.out.println(BasicUtilities.getString("New_Version_Available"));
                System.out.println(BasicUtilities.getString("Version_Type_" + objectArray[0]) + " :: " + objectArray[1]);
            }
        }
        catch (Exception exception) {
            BasicUtilities.HandleException(exception, BasicUtilities.getString("Web_Check_Error"));
        }
    }

    public void connectStartupService() {
        ServiceProvider serviceProvider;
        String string;
        boolean bl2 = this.preferences.containsKey("jdbc.auto-service");
        if (bl2 && (string = this.preferences.get("jdbc.auto-service")) != null && string.trim().length() >= 1 && (serviceProvider = this.sysConfig.getServiceProvider()).isRegistered(string)) {
            System.out.println(BasicUtilities.getString("Auto_Connect_Message", string));
            this.changeService(string);
        }
    }

    public void toggleTransactionState() {
        if (!this.isValidDatabaseConnection()) {
            System.out.println(BasicUtilities.getString("Invalid_Connection"));
            return;
        }
        boolean bl2 = false;
        if (!this.databaseConnection.isTransactionsSupported()) {
            System.out.println(BasicUtilities.getString("Transaction_Warning"));
            return;
        }
        try {
            boolean bl3 = bl2 = !this.databaseConnection.getAutoCommit();
            if (bl2) {
                this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
            } else {
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
            }
            String string = bl2 ? BasicUtilities.getString("AutoCommit_OFF") : BasicUtilities.getString("AutoCommit_ON");
            this.lblCommit.setText(" ".concat(string).concat(" "));
            this.statusBar.revalidate();
            this.actionManager.setActionEnabled(14, bl2);
            this.actionManager.setActionEnabled(13, bl2);
        }
        catch (Exception exception) {
            BasicUtilities.HandleException(exception, BasicUtilities.getString("Transaction_Exception"));
            this.actionManager.setActionEnabled(14, false);
            this.actionManager.setActionEnabled(13, false);
            this.lblCommit.setText(BasicUtilities.getString("AutoCommit_ON"));
            return;
        }
    }

    public void initTracing(Properties properties) {
        String string = properties.getProperty("jdbc.trace-enabled", "false");
        if (Boolean.valueOf(string).booleanValue()) {
            PrintWriter printWriter = new PrintWriter(this.sysOut.createFilteredStream(JConsole.CATEGORY_DRIVER_MANAGER), true);
            DriverManager.setLogWriter(printWriter);
        } else {
            DriverManager.setLogWriter(null);
        }
    }

    public void checkEmptyServices() {
        ServiceProvider serviceProvider = this.sysConfig.getServiceProvider();
        int n2 = serviceProvider.getRegisteredServices().size();
        if (n2 == 0) {
            String string = BasicUtilities.getString("ServiceEmptyPrompt");
            Object[] objectArray = new String[]{BasicUtilities.getString("Yes"), BasicUtilities.getString("No"), BasicUtilities.getString("Detect_Services")};
            int n3 = JOptionPane.showOptionDialog(this, string, "", 1, 1, null, objectArray, objectArray[2]);
            if (n3 == 0) {
                this.actionManager.forwardAction(new ActionEvent(this, 3, ""));
            } else if (n3 == 2) {
                SystemConfig.getInstance().getServiceProvider().detectServices();
                this.menuBar.refreshServiceMenu();
            }
        }
    }

    public void doQuickBatch() {
        File file;
        if (this.validateConnection() && (file = BasicUtilities.getSystemFile(this, 0)) != null) {
            try {
                BatchRunner batchRunner = new BatchRunner(file, null);
                batchRunner.setConnection(this.getJDBCConnection());
                batchRunner.loadStatements(this.preferences);
                Thread thread = new Thread(this.BATCH_THREADS, batchRunner, file.getName());
                thread.start();
            }
            catch (IOException iOException) {
                BasicUtilities.beep();
                BasicUtilities.HandleException(iOException, "SQLWorkbench::doQuickBatch()");
            }
        }
    }

    private void configureFileToolbar() {
        if (!this.preferences.getBoolean("toolbar.file-visible")) {
            return;
        }
        if (this.fileBar == null) {
            this.fileBar = new MainToolbar(this.actionManager);
            String string = this.preferences.get("toolbar.file-dock");
            this.getContentPane().add((Component)this.fileBar, string);
            if (string.equalsIgnoreCase("East") || string.equalsIgnoreCase("West")) {
                this.fileBar.setOrientation(1);
            } else {
                this.fileBar.setOrientation(0);
            }
        }
    }

    private void doPostServiceInit(String string) {
        System.out.println(BasicUtilities.getString("Connect_Sucess_Message", string));
        this.currentStatus = BasicUtilities.getString("Connect_Status", string);
        this.updateStatus(this.currentStatus);
        this.databaseConnection.setConnectionName(string);
        this.sysConfig.getIPCService().publish(this, "isql-service-change", this.databaseConnection);
        boolean bl2 = this.databaseConnection.isTransactionsSupported();
        this.actionManager.setActionEnabled(12, bl2);
        bl2 = this.databaseConnection.isSavePointsSupported();
        this.actionManager.setActionEnabled(48, bl2);
        try {
            SQLWarningViewer.addConnectionWarnings(this.databaseConnection.getWarnings());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeFileToolbar() {
        if (this.fileBar != null) {
            this.getContentPane().remove(this.fileBar);
            this.validateTree();
            this.fileBar.removeAll();
            this.fileBar = null;
        }
    }

    private void finalizeApplication() {
        this.actionThread.interrupt();
        this.saveSession();
        this.actionManager = null;
        this.menuBar = null;
        this.workbench = null;
    }

    private void restoreSession() {
        BasicUtilities.setPreferredGeometry(this, new Dimension(800, 600), "MainFrame.bounds");
        String string = "session.".concat("MainFrame.split.loc");
        int n2 = this.preferences.getInt(string);
        if (n2 < 0) {
            n2 = 350;
        }
        this.rootPane.setDividerLocation(n2);
        this.workbench.restoreSession();
    }

    private void saveSession() {
        this.preferences.putRect("session.".concat("MainFrame.bounds"), this.getBounds());
        int n2 = this.rootPane.getDividerLocation();
        this.preferences.putInt("session.".concat("MainFrame.split.loc"), n2);
        if (this.workbench != null) {
            this.workbench.saveSession();
        }
    }

    private JPanel configureStatusBar() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder();
        this.lblInfo.setBorder(border);
        this.lblCommit.setBorder(border);
        MainFrame.constrain(0, 0, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        MainFrame.constrain(1, 0, 1, 1, 1.0, 0.0, 17, 2);
        jPanel.add((Component)this.lblInfo, UI_CONSTRAINT);
        MainFrame.constrain(2, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.lblCommit, UI_CONSTRAINT);
        MainFrame.constrain(3, 0, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        return jPanel;
    }

    private JDrawer configureBookmarkDrawer() {
        JDrawer jDrawer = new JDrawer((Window)this);
        BookmarkTreeCellRenderer bookmarkTreeCellRenderer = new BookmarkTreeCellRenderer();
        this.treBookmarks = new JTree(this.sysConfig.getBookmarks());
        this.treBookmarks.setEditable(true);
        this.treBookmarks.setCellRenderer(bookmarkTreeCellRenderer);
        this.treBookmarks.setRootVisible(false);
        this.treBookmarks.setCellEditor(new BookmarkEditor.TreeCell(this.treBookmarks, bookmarkTreeCellRenderer));
        this.treBookmarks.addMouseListener(this.actionHandler);
        Action action = this.actionManager.getAction(38);
        String string = "delete-selected-bookmarks";
        InputMap inputMap = this.treBookmarks.getInputMap(2);
        ActionMap actionMap = this.treBookmarks.getActionMap();
        inputMap.put(BasicUtilities.createKeyStroke(127, 0), string);
        actionMap.put(string, action);
        DropTarget dropTarget = new DropTarget(this.treBookmarks, this.dndHandler);
        this.treBookmarks.setDropTarget(dropTarget);
        String string2 = this.preferences.get("bookmark.location");
        if (string2.equalsIgnoreCase(BasicUtilities.getString("Bookmark_Pref_Loc_Left"))) {
            jDrawer.setPreferredLocation(7);
        } else {
            jDrawer.setPreferredLocation(3);
        }
        JScrollPane jScrollPane = new JScrollPane(this.treBookmarks);
        jDrawer.addChangeListener(this.actionHandler);
        jDrawer.getContentPane().add((Component)jScrollPane, "Center");
        jDrawer.getContentPane().add((Component)new BookmarkToolbar(this.actionManager), "North");
        this.dndDragSource.createDefaultDragGestureRecognizer(this.treBookmarks, 3, this.dndHandler);
        return jDrawer;
    }

    private void handleBookmarkAction(int n2, Object object) {
        SQLBookmark sQLBookmark = null;
        Window window = null;
        BookmarkTreeModel bookmarkTreeModel = this.sysConfig.getBookmarks();
        switch (n2) {
            case 37: {
                sQLBookmark = new SQLBookmark(BasicUtilities.getString("New_Bookmark_Name"));
                if (object instanceof String || object == null) {
                    sQLBookmark.setPath(object == null ? "/" : (String)object);
                } else if (object instanceof SQLBookmark) {
                    sQLBookmark.setPath(((SQLBookmark)object).getPath());
                }
                window = new BookmarkEditor(this, bookmarkTreeModel);
                ((BookmarkEditor)window).setBookmark(sQLBookmark);
                ((BookmarkEditor)window).setIsNew(true);
                ((Dialog)window).show();
                break;
            }
            case 39: {
                if (object == null || !(object instanceof SQLBookmark)) {
                    JOptionPane.showMessageDialog(this, BasicUtilities.getString("Bookmark_Select_Nag"));
                    return;
                }
                sQLBookmark = (SQLBookmark)object;
                window = new BookmarkEditor(this, bookmarkTreeModel);
                ((BookmarkEditor)window).installEditorSupport(this.getJDBCConnection());
                ((BookmarkEditor)window).setBookmark(sQLBookmark);
                ((BookmarkEditor)window).setIsNew(false);
                ((Dialog)window).show();
                break;
            }
            case 38: {
                TreePath[] treePathArray;
                int n3;
                if (object == null) {
                    return;
                }
                if (this.preferences.getBoolean("bookmarks.deletewarning-enabled") && (n3 = JOptionPane.showConfirmDialog(this, treePathArray = BasicUtilities.getString("Bookmark_DeleteWarning"), "", 0)) == 1) {
                    return;
                }
                treePathArray = this.treBookmarks.getSelectionPaths();
                for (n3 = 0; n3 < treePathArray.length; ++n3) {
                    object = treePathArray[n3].getLastPathComponent();
                    if (object == null) continue;
                    if (object instanceof String) {
                        String string = (String)object;
                        int n4 = string.lastIndexOf(47);
                        String string2 = string.substring(0, string.lastIndexOf(47, string.length() - 2) + 1);
                        String string3 = string.substring(string.lastIndexOf(47, n4 - 1) + 1, n4);
                        try {
                            bookmarkTreeModel.deleteFolder(string2, string3);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                        catch (Throwable throwable) {
                            BasicUtilities.HandleException(throwable, "BookmarkTreeModel::deleteFolder(String, String)");
                            break;
                        }
                    }
                    if (!(object instanceof SQLBookmark)) continue;
                    try {
                        bookmarkTreeModel.deleteBookmark((SQLBookmark)object);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable, "BookmarkTreeModel::deleteBookmark(SQLBookmark)");
                        break;
                    }
                }
                this.treBookmarks.validate();
                break;
            }
            case 40: {
                String string = JOptionPane.showInputDialog(this, (Object)"");
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                if (object instanceof String || object == null) {
                    bookmarkTreeModel.createFolder(object == null ? "/" : (String)object, string);
                    break;
                }
                if (!(object instanceof SQLBookmark)) break;
                sQLBookmark = (SQLBookmark)object;
                bookmarkTreeModel.createFolder(sQLBookmark.getPath(), string);
            }
        }
        if (window != null) {
            window.dispose();
        }
        window = null;
    }

    private void initUI() throws Exception {
        this.enableEvents(72L);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.menuBar);
        this.preferences.addPreferenceChangeListener(this.actionHandler);
        this.configureFileToolbar();
        try {
            if (!BasicUtilities.isMac()) {
                Image image = ((ImageIcon)BasicUtilities.loadIconResource("Database24")).getImage();
                this.setIconImage(image);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.workbench = new SQLWorkBench(this);
        this.sysOut.configure(this.preferences);
        this.panel.add((Component)this.rootPane, "root");
        this.panel.showCard("root");
        this.contentPane.add((Component)this.panel, "Center");
        this.statusBar = this.configureStatusBar();
        this.contentPane.add((Component)this.statusBar, "South");
        this.rootPane.setTopComponent(this.workbench);
        this.rootPane.setBorder(BorderFactory.createEmptyBorder());
        this.rootPane.setContinuousLayout(true);
        this.rootPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
        this.restoreSession();
        this.validateTree();
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        MainFrame.UI_CONSTRAINT.gridx = n2;
        MainFrame.UI_CONSTRAINT.gridy = n3;
        MainFrame.UI_CONSTRAINT.gridwidth = n4;
        MainFrame.UI_CONSTRAINT.gridheight = n5;
        MainFrame.UI_CONSTRAINT.weightx = d2;
        MainFrame.UI_CONSTRAINT.weighty = d3;
        MainFrame.UI_CONSTRAINT.anchor = n6;
        MainFrame.UI_CONSTRAINT.fill = n7;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JSplitPane getSplitPanel() {
        return this.rootPane;
    }

    public static class 1 {
    }

    private static class MainToolbar
    extends ActionToolBar {
        private static final long serialVersionUID = 1L;

        public void addButtons() {
            this.addButton(this.manager.getAction(3));
            this.addButton(this.manager.getAction(41));
            this.addSeparator();
            this.addButton(this.manager.getAction(4));
            this.addButton(this.manager.getAction(33));
            this.addSeparator();
            this.addButton(this.manager.getAction(5));
            this.addButton(this.manager.getAction(1));
            this.addSeparator();
            this.addButton(this.manager.getAction(2));
            this.addButton(this.manager.getAction(42));
            this.addButton(this.manager.getAction(7));
            this.addButton(this.manager.getAction(24));
            this.addButton(this.manager.getAction(36));
            this.addButton(this.manager.getAction(46));
            this.addButton(this.manager.getAction(34));
        }

        public MainToolbar(ActionManager actionManager) {
            super(actionManager);
            this.setFloatable(false);
        }

        public void processDropProxy(Transferable transferable, int n2) {
        }

        public void configureButton(AbstractButton abstractButton, Action action) {
            super.configureButton(abstractButton, action);
            if (action instanceof CoreAction) {
                try {
                    String string = (String)action.getValue("ICON_NAME");
                    abstractButton.setIcon(BasicUtilities.loadToolbarIconResource(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class TreeDropTarget
    extends DropTargetAdapter
    implements DragSourceListener,
    DragGestureListener {
        private Point pt = new Point(2, 2);

        private TreeDropTarget() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                int n2 = dropTargetDropEvent.getLocation().x;
                int n3 = dropTargetDropEvent.getLocation().y;
                TreePath treePath = MainFrame.this.treBookmarks.getPathForLocation(n2, n3);
                Object object = treePath != null ? treePath.getLastPathComponent() : "/";
                String string = object instanceof SQLBookmark ? ((SQLBookmark)object).getPath() : object.toString();
                BookmarkTreeModel bookmarkTreeModel = MainFrame.this.sysConfig.getBookmarks();
                if (transferable.isDataFlavorSupported(BasicUtilities.bookmarkFlavour)) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    SQLBookmark sQLBookmark = (SQLBookmark)transferable.getTransferData(BasicUtilities.bookmarkFlavour);
                    switch (dropTargetDropEvent.getSourceActions()) {
                        case 2: 
                        case 3: {
                            bookmarkTreeModel.moveBookmark(sQLBookmark, string);
                            break;
                        }
                        case 1: {
                            bookmarkTreeModel.copyBookmark(sQLBookmark, string);
                            break;
                        }
                        default: {
                            BasicUtilities.beep();
                            dropTargetDropEvent.rejectDrop();
                            return;
                        }
                    }
                    dropTargetDropEvent.dropComplete(true);
                    MainFrame.this.treBookmarks.expandPath(sQLBookmark.toTreePath());
                    MainFrame.this.treBookmarks.setSelectionPath(sQLBookmark.toTreePath());
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    String string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (bookmarkTreeModel.isPath(string2)) {
                        switch (dropTargetDropEvent.getSourceActions()) {
                            case 2: 
                            case 3: {
                                string = string2.substring(string2.lastIndexOf(47, string2.length() - 2) + 1, string2.length() - 1) + "/";
                                treePath = BookmarkTreeModel.getTreePath(string);
                                bookmarkTreeModel.movePath(string2, string);
                                break;
                            }
                            case 1: {
                                bookmarkTreeModel.copyPath(string2, string);
                                treePath = BookmarkTreeModel.getTreePath(string);
                                break;
                            }
                            default: {
                                BasicUtilities.beep();
                                dropTargetDropEvent.rejectDrop();
                                return;
                            }
                        }
                        dropTargetDropEvent.dropComplete(true);
                        MainFrame.this.treBookmarks.expandPath(treePath);
                        MainFrame.this.treBookmarks.setSelectionPath(treePath);
                    } else {
                        int n4 = Math.min(12, string2.length());
                        String string3 = string2.substring(0, n4 - 1);
                        SQLBookmark sQLBookmark = new SQLBookmark(string3, string2);
                        sQLBookmark.setPath(string);
                        bookmarkTreeModel.addBookmark(sQLBookmark);
                        treePath = BookmarkTreeModel.getTreePath(string);
                        MainFrame.this.treBookmarks.expandPath(treePath);
                        MainFrame.this.treBookmarks.setSelectionPath(treePath);
                        dropTargetDropEvent.dropComplete(true);
                    }
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            DragGestureRecognizer dragGestureRecognizer = dragGestureEvent.getSourceAsDragGestureRecognizer();
            MainFrame.this.treBookmarks.cancelEditing();
            try {
                int n2 = dragGestureEvent.getDragOrigin().x;
                int n3 = dragGestureEvent.getDragOrigin().y;
                boolean bl2 = true;
                int n4 = MainFrame.this.treBookmarks.getRowForLocation(n2, n3);
                TreePath treePath = MainFrame.this.treBookmarks.getPathForLocation(n2, n3);
                if (treePath == null) {
                    dragGestureRecognizer.resetRecognizer();
                    return;
                }
                Object object = treePath.getLastPathComponent();
                if (object == null) {
                    dragGestureRecognizer.resetRecognizer();
                    return;
                }
                Transferable transferable = null;
                if (object instanceof SQLBookmark) {
                    transferable = (SQLBookmark)object;
                    bl2 = true;
                } else {
                    transferable = new StringSelection(object.toString());
                    bl2 = false;
                }
                if (DragSource.isDragImageSupported()) {
                    GraphicsConfiguration graphicsConfiguration = MainFrame.this.treBookmarks.getGraphicsConfiguration();
                    TreeCellRenderer treeCellRenderer = MainFrame.this.treBookmarks.getCellRenderer();
                    Component component = treeCellRenderer.getTreeCellRendererComponent(MainFrame.this.treBookmarks, object, true, false, bl2, n4, false);
                    Dimension dimension = component.getPreferredSize();
                    component.setSize(dimension);
                    BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(dimension.width, dimension.height);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    component.paint(graphics2D);
                    graphics2D.setColor(new Color(255, 255, 255, 112));
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                    MainFrame.this.dndDragSource.startDrag(dragGestureEvent, null, bufferedImage, this.pt, transferable, this);
                } else {
                    MainFrame.this.dndDragSource.startDrag(dragGestureEvent, null, null, this.pt, transferable, this);
                }
            }
            catch (Throwable throwable) {
                dragGestureRecognizer.resetRecognizer();
                BasicUtilities.beep();
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            MainFrame.this.treBookmarks.cancelEditing();
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public /* synthetic */ TreeDropTarget(1 var2_2) {
            this();
        }
    }

    private class BookmarkToolbar
    extends ActionToolBar {
        private static final long serialVersionUID = 1L;

        public void addButtons() {
            try {
                this.addButton(this.manager.getAction(37));
                this.addButton(this.manager.getAction(38));
                this.addButton(this.manager.getAction(39));
                this.addButton(this.manager.getAction(40));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public BookmarkToolbar(ActionManager actionManager) {
            super(actionManager);
            this.setFloatable(false);
        }

        public void configureButton(AbstractButton abstractButton, Action action) {
            super.configureButton(abstractButton, action);
            if (action instanceof CoreAction) {
                try {
                    String string = (String)action.getValue("ICON_NAME");
                    abstractButton.setIcon(this.manager.getSmallIcon(string, "png"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void processDropProxy(Transferable transferable, int n2) {
        }
    }

    private class ActionManagerHandler
    implements ItemListener,
    MouseListener,
    DatabaseListener,
    ChangeListener,
    ActionListener,
    PropertyChangeListener,
    PreferenceChangeListener {
        private ActionManagerHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JCheckBoxAction jCheckBoxAction = (JCheckBoxAction)itemEvent.getItem();
            String string = jCheckBoxAction.getValue("Name").toString();
            boolean bl2 = jCheckBoxAction.isSelected();
            if (string.equalsIgnoreCase(BasicUtilities.getString("File_Toolbar"))) {
                MainFrame.this.preferences.putBoolean("toolbar.file-visible", bl2);
                if (bl2) {
                    MainFrame.this.configureFileToolbar();
                } else {
                    MainFrame.this.removeFileToolbar();
                }
            }
        }

        public void processDatabaseEvent(DatabaseEvent databaseEvent) {
            switch (databaseEvent.getID()) {
                case 4: {
                    MainFrame.this.toggleTransactionState();
                    break;
                }
                case 0: {
                    MainFrame.this.disconnect();
                    break;
                }
                case 3: {
                    MainFrame.this.doPostServiceInit(databaseEvent.getConnection().getConnectionName());
                }
            }
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            String string2 = preferenceChangeEvent.getNewValue();
            if (string.equals("bookmark.location")) {
                if (string2.equalsIgnoreCase(BasicUtilities.getString("Bookmark_Pref_Loc_Left"))) {
                    MainFrame.this.bookDrawer.setPreferredLocation(7);
                } else {
                    MainFrame.this.bookDrawer.setPreferredLocation(3);
                }
                return;
            }
            if (string.equals("toolbar.file-dock")) {
                MainFrame.this.removeFileToolbar();
                MainFrame.this.configureFileToolbar();
                return;
            }
            if (string.equals("general.plaf-class")) {
                try {
                    BasicUtilities.setLookAndFeel(preferenceChangeEvent.getNewValue());
                    Window[] windowArray = MainFrame.this.getOwnedWindows();
                    if (windowArray != null) {
                        for (int i2 = 0; i2 < windowArray.length; ++i2) {
                            SwingUtilities.updateComponentTreeUI(windowArray[i2]);
                        }
                    }
                    SwingUtilities.updateComponentTreeUI(MainFrame.this);
                }
                catch (Throwable throwable) {
                    BasicUtilities.showExceptionPopup(MainFrame.this, throwable, throwable.getMessage());
                }
                return;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getNewValue() == null) {
                return;
            }
            String string2 = propertyChangeEvent.getNewValue().toString();
            if (string.equals("begin-command")) {
                MainFrame.this.updateStatus(string2);
                return;
            }
            if (string.equals("end-command")) {
                MainFrame.this.updateStatus(MainFrame.this.currentStatus);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                MainFrame.this.handleActionEvent(actionEvent);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ActionManager::actionPerformed(ActionEvent)");
            }
            finally {
                MainFrame.this.setCursor(Cursor.getDefaultCursor());
                System.runFinalization();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            HistoryManager historyManager;
            Object object = changeEvent.getSource();
            if (object == (historyManager = MainFrame.this.sysConfig.getHistoryManager())) {
                boolean bl2 = historyManager.size() >= 1;
                MainFrame.this.actionManager.setActionEnabled(7, bl2);
            } else if (object == MainFrame.this.bookDrawer && MainFrame.this.bookDrawer.isToggled()) {
                MainFrame.this.treBookmarks.validate();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doTreeClick(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void doTreeClick(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            TreePath treePath = MainFrame.this.treBookmarks.getPathForLocation(n2, n3);
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object != null && object instanceof SQLBookmark) {
                if (!MainFrame.this.preferences.getBoolean("bookmark.activation-style")) {
                    ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), 39, "");
                    MainFrame.this.actionManager.forwardAction(actionEvent);
                } else {
                    SQLBookmark sQLBookmark = (SQLBookmark)object;
                    MainFrame.this.workbench.executeBookmark(sQLBookmark, MainFrame.this, false);
                }
            }
        }

        public /* synthetic */ ActionManagerHandler(1 var2_2) {
            this();
        }
    }
}

