/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.swing.TableFilterEditor;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;

public final class ExportWizard
extends WizardContainer {
    private final String STEP_EXPORT = "EXPORT";
    private final String STEP_SELECT = "SELECT";
    private final String STEP_TAILOR = "TALIOR";
    private EnhancedTableModel mdlData;
    private TableFilterEditor tfEditor = null;
    private Thread exportThread;
    private ProgressPanel pnlProgress = new ProgressPanel();

    public ExportWizard(Frame frame, EnhancedTableModel enhancedTableModel, DatabaseConnection databaseConnection) {
        super(frame);
        this.setIcon(BasicUtilities.loadIconResource("Export24"));
        this.mdlData = (EnhancedTableModel)enhancedTableModel.clone();
        this.tfEditor = new TableFilterEditor(1, databaseConnection);
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ExportWizard::initUI()");
            this.dispose();
        }
        this.setSize(new Dimension(640, 480));
        this.setLocationRelativeTo(frame);
    }

    private void initUI() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setHomeAllowable(false);
        this.setPreviousStepEnabled(false);
        this.addUserComponent("SELECT", this.tfEditor);
        this.addUserComponent("TALIOR", new ExportTailor(this.mdlData));
        this.addUserComponent("EXPORT", this.pnlProgress);
        this.tfEditor.setFilterContent(this.mdlData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 200) {
            this.startWizard();
            int n2 = -1;
            if (n2 >= 0) {
                this.tfEditor.setSelectedFilterIndex(n2);
            } else {
                this.tfEditor.setSelectedFilterIndex(0);
            }
        } else if (windowEvent.getID() == 201) {
            if (this.exportThread != null && this.exportThread.isAlive()) {
                if (!this.exportThread.isInterrupted()) {
                    this.exportThread.interrupt();
                }
                try {
                    this.exportThread.join(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.exportThread = null;
                }
            }
            this.tfEditor.close();
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean isStepValid(String string) {
        if (string != null && string.equals("TALIOR")) {
            this.exportThread = new Thread(new ExportProcess(null));
            this.exportThread.start();
        }
        return true;
    }

    public void processStepChange(String string, boolean bl2, String string2) {
        if (string.equalsIgnoreCase("SELECT")) {
            this.setBanner(BasicUtilities.getString("Export_Filter_Select"));
            this.setComment(BasicUtilities.getString("Export_Select_Comment"));
            return;
        }
        if (string.equalsIgnoreCase("TALIOR")) {
            this.setBanner(BasicUtilities.getString("Export_Tailor_Text"));
            this.setComment(BasicUtilities.getString("Export_Tailor_Comment"));
            return;
        }
        if (string.equalsIgnoreCase("EXPORT")) {
            this.setBanner(BasicUtilities.getString("Export_Progress_Text"));
            this.setComment(BasicUtilities.getString("Progress_Console_Tip"));
            return;
        }
    }

    public static class 1 {
    }

    private static class ExportTailor
    extends JPanel
    implements ActionListener {
        private ITable table = new ITable();
        private JButton delete = new JButton();

        public ExportTailor(TableModel tableModel) {
            try {
                this.table.setModel(tableModel);
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ExportTailer:initUI()");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (this.table.getRowSelectionAllowed()) {
                if (object == this.delete) {
                    BasicUtilities.removeSelectedRows(this.table);
                } else {
                    this.delete.setIcon(BasicUtilities.loadToolbarIconResource("RowDelete"));
                }
            } else if (object == this.delete) {
                BasicUtilities.removeSelectedColumns(this.table);
            } else {
                this.delete.setIcon(BasicUtilities.loadToolbarIconResource("ColumnDelete"));
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            JScrollPane jScrollPane = new JScrollPane(this.table);
            this.table.addActionListener(this);
            this.table.allowColumnReordering(false);
            this.delete.addActionListener(this);
            this.delete.setIcon(BasicUtilities.loadToolbarIconResource("RowDelete"));
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.delete, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 1.0, 1.0, 10, 1);
            this.add((Component)jScrollPane, WizardContainer.UI_CONSTRAINT);
        }
    }

    private class ExportProcess
    implements Runnable {
        private ExportProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block21: {
                try {
                    TableFilter tableFilter = ExportWizard.this.tfEditor.getSelectedFilter();
                    if (tableFilter == null) {
                        JOptionPane.showMessageDialog(ExportWizard.this, BasicUtilities.getString("Export_No_Filter_Error"));
                        return;
                    }
                    tableFilter.addProgressListener(ExportWizard.this.pnlProgress);
                    tableFilter.setLogStream(new PrintWriter(ExportWizard.this.pnlProgress.getOutStream(), true));
                    int n2 = 0;
                    File file = null;
                    PrintStream printStream = ExportWizard.this.pnlProgress.getOutStream();
                    PrintStream printStream2 = ExportWizard.this.pnlProgress.getErrStream();
                    if (tableFilter.isFileRequired(1)) {
                        FileFilter[] fileFilterArray = tableFilter.getSupportedFileTypes(1);
                        file = BasicUtilities.saveSystemFile(ExportWizard.this, fileFilterArray);
                        if (file != null && tableFilter.accept(1, file)) {
                            file.createNewFile();
                            FileOutputStream fileOutputStream = null;
                            long l2 = System.currentTimeMillis();
                            try {
                                fileOutputStream = new FileOutputStream(file);
                                String string = BasicUtilities.getString("Export_Starting", tableFilter.getName());
                                ExportWizard.this.pnlProgress.getOutStream().println(string);
                                n2 = tableFilter.filterOut(ExportWizard.this.mdlData, file, fileOutputStream);
                                if (n2 != 1) {
                                    string = BasicUtilities.getString("Export_Failure", tableFilter.getName());
                                    printStream2.println(string);
                                } else {
                                    string = BasicUtilities.getString("Export_Success", tableFilter.getName());
                                    printStream.println(string);
                                }
                                l2 = System.currentTimeMillis() - l2;
                                string = BasicUtilities.getString("Export_Complete", Long.toString(l2));
                                ExportWizard.this.pnlProgress.getOutStream().println(string);
                                break block21;
                            }
                            catch (Throwable throwable) {
                                BasicUtilities.HandleException(throwable, "filter();", true, ExportWizard.this.pnlProgress.getErrStream());
                                break block21;
                            }
                            finally {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        JOptionPane.showMessageDialog(ExportWizard.this, BasicUtilities.getString("Export_Cancelled"));
                        return;
                    }
                    long l3 = System.currentTimeMillis();
                    String string = BasicUtilities.getString("Export_Starting", tableFilter.getName());
                    ExportWizard.this.pnlProgress.getOutStream().println(string);
                    n2 = tableFilter.filterOut(ExportWizard.this.mdlData, file, null);
                    l3 = System.currentTimeMillis() - l3;
                    if (n2 == 0) {
                        string = BasicUtilities.getString("Export_Failed", tableFilter.getName());
                        ExportWizard.this.pnlProgress.getOutStream().println(string);
                    } else {
                        string = BasicUtilities.getString("Export_Success", tableFilter.getName());
                        ExportWizard.this.pnlProgress.getOutStream().println(string);
                    }
                    string = BasicUtilities.getString("Export_Complete", Long.toString(l3));
                    ExportWizard.this.pnlProgress.getOutStream().println(string);
                }
                catch (InterruptedException interruptedException) {
                    JOptionPane.showMessageDialog(ExportWizard.this, BasicUtilities.getString("Export_Cancelled"));
                    return;
                }
                catch (Exception exception) {
                    String string = BasicUtilities.getString("Export_Exception", "" + exception);
                    JOptionPane.showMessageDialog(ExportWizard.this, string);
                    return;
                }
            }
        }

        public /* synthetic */ ExportProcess(1 var2_2) {
            this();
        }
    }
}

