/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.print;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public abstract class DefaultPaperComponent
extends JComponent
implements Printable,
Pageable {
    private static final int PAGE_MARGIN = 36;
    private final DateFormat df = DateFormat.getDateInstance(2);
    private final String TIMESTAMP = BasicUtilities.getString("Print_Timestamp", new String[]{this.df.format(new Date()), System.getProperty("user.name", "Nobody")});
    private final String SFOOTER = "iSQL-Viewer v.2.1.8";
    public double mZoomLevel = 0.0;
    public int mCurrentPage = 0;
    public PageFormat mPageFormat = null;
    private Dimension mContentArea = null;
    private PrinterJob printerJob = null;
    private Paper pPaper = null;
    private boolean includeHeader = true;
    private boolean includeFooter = true;
    private boolean printInColor = true;
    private boolean isPrinting = false;
    public boolean isValid = false;
    private Font fntHeader = new Font("Lucinda Sans", 1, 11);
    private Font fntSFooter = new Font("Lucinda Sans", 2, 8);
    private int h_HeaderBox = 0;
    private int w_HeaderBox = 0;
    private int h_FooterBox = 0;
    private int w_FooterBox = 0;
    private int h_PaperArea = 0;
    private int w_PaperArea = 0;
    private StringBuffer titleBuffer = new StringBuffer("");
    private String titleString = "No-Data to Print";

    public DefaultPaperComponent() {
        this.mPageFormat = new PageFormat();
        this.pPaper = new Paper();
        this.pPaper.setImageableArea(36.0, 36.0, this.pPaper.getWidth() - 72.0, this.pPaper.getHeight() - 72.0);
        this.mPageFormat.setPaper(this.pPaper);
        try {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setZoomLevel(1.0);
        this.setDoubleBuffered(true);
    }

    public abstract void setContent(Object var1);

    public void setZoomLevel(double d2) {
        this.mZoomLevel = d2;
        this.setPreferredSize(new Dimension((int)(this.mPageFormat.getWidth() * d2), (int)(this.mPageFormat.getHeight() * d2)));
        this.invalidate();
    }

    public double getZoomLevel() {
        return this.mZoomLevel;
    }

    public String getTitleString() {
        return this.titleString;
    }

    public void setTitleString(String string) {
        this.titleString = StringUtilities.oneLine(string);
    }

    public PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.mPageFormat = pageFormat;
    }

    public int getPageCount() {
        return 0;
    }

    public void setPageNumber(int n2) {
        this.mCurrentPage = this.getPageCount() <= n2 ? this.getPageCount() - 1 : (n2 < 0 ? 0 : n2);
        this.repaint();
    }

    public int getPage() {
        return this.mCurrentPage;
    }

    public void configure(UserPreferences userPreferences) {
        this.includeHeader = userPreferences.getBoolean("print.header-enabled");
        this.includeFooter = userPreferences.getBoolean("print.footer-enabled");
        this.printInColor = userPreferences.getBoolean("print.color-enabled");
        this.fntHeader = new Font("Default", 1, 11);
        this.isValid = false;
    }

    public final void print() {
        try {
            this.setDoubleBuffered(false);
            this.printerJob.setPageable(this);
            this.printerJob.setJobName("iSQL-Viewer[" + this.getTitleString() + "] PrintJob");
            if (this.printerJob.printDialog()) {
                this.isValid = false;
                this.isPrinting = true;
                this.printerJob.print();
            }
            this.setDoubleBuffered(true);
            this.isPrinting = false;
            this.isValid = false;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, BasicUtilities.getString("Print_Exception"));
        }
    }

    public void initialize(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.fntHeader);
        this.titleBuffer.setLength(0);
        this.titleBuffer.append(this.getTitleString());
        this.h_PaperArea = (int)this.mPageFormat.getImageableHeight() - (graphics2D.getFontMetrics(this.fntSFooter).getHeight() + 2);
        this.w_PaperArea = (int)this.mPageFormat.getImageableWidth() - 2;
        this.h_HeaderBox = 2 * (fontMetrics.getHeight() + 4) - fontMetrics.getDescent();
        this.w_HeaderBox = this.w_PaperArea - 2;
        this.h_FooterBox = 1 * (fontMetrics.getHeight() + 4) - fontMetrics.getDescent();
        this.w_FooterBox = this.w_PaperArea - 2;
        int n2 = this.h_PaperArea - 2;
        int n3 = this.w_PaperArea - 2;
        if (this.includeHeader) {
            n2 -= this.h_HeaderBox;
        }
        if (this.includeFooter) {
            n2 -= this.h_FooterBox;
        }
        this.mContentArea = new Dimension(n3, n2);
        int n4 = (int)((double)this.getContentWidth() * 0.75);
        int n5 = fontMetrics.stringWidth(this.titleBuffer.toString()) + fontMetrics.getLeading();
        if (n5 >= n4) {
            n4 -= fontMetrics.stringWidth("...");
            while (n5 >= n4) {
                this.titleBuffer.deleteCharAt(this.titleBuffer.length() - 1);
                n5 = fontMetrics.stringWidth(this.titleBuffer.toString()) + fontMetrics.getLeading();
            }
            this.titleBuffer.append("...");
        }
        this.isValid = true;
    }

    public final int getNumberOfPages() {
        return this.getPageCount();
    }

    public final PageFormat getPageFormat(int n2) throws IndexOutOfBoundsException {
        return this.getPageFormat();
    }

    public final Printable getPrintable(int n2) throws IndexOutOfBoundsException {
        return this;
    }

    public final void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (this.isPrinting) {
                return;
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            this.print(graphics, this.getPageFormat(), this.getPage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.scale(this.getZoomLevel(), this.getZoomLevel());
        try {
            if (!this.isValidated()) {
                if (!this.isPrinting) {
                    new Thread(new Initializer(graphics2D)).start();
                    return 1;
                }
                new Initializer(graphics2D).run();
            }
        }
        catch (Throwable throwable) {
            return 1;
        }
        if (n2 >= this.getPageCount()) {
            return 1;
        }
        graphics2D.translate(36, 36);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, this.w_PaperArea, this.h_PaperArea);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.fntSFooter);
        graphics2D.setFont(this.fntSFooter);
        graphics2D.drawString("iSQL-Viewer v.2.1.8", this.w_PaperArea / 2 - fontMetrics.stringWidth("iSQL-Viewer v.2.1.8") / 2, this.h_PaperArea + fontMetrics.getHeight() + 1 - fontMetrics.getDescent());
        if (this.includeFooter) {
            this.drawPageFooter(graphics2D, n2);
        }
        if (this.includeHeader) {
            this.drawPageHeader(graphics2D, n2);
        }
        try {
            if (this.includeHeader) {
                graphics2D.translate(1, this.h_HeaderBox + 2);
            } else {
                graphics2D.translate(1, 0);
            }
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(0, 0, this.getContentWidth(), this.getContentHeight());
            this.drawPageContents(graphics2D2, n2);
            if (this.includeHeader) {
                graphics2D.translate(-1, -(this.h_HeaderBox + 2));
            } else {
                graphics2D.translate(-1, 0);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "DefaultPaperComponent::print(Grpahics,PageFormat,int)");
        }
        return 0;
    }

    public final int getContentWidth() {
        return this.mContentArea.width;
    }

    public final int getContentHeight() {
        return this.mContentArea.height;
    }

    public final boolean useColor() {
        return this.printInColor;
    }

    public String getHeaderString(int n2) {
        return "[" + (n2 + 1) + " -- " + this.getPageCount() + "]";
    }

    public String getFooterString(int n2) {
        return "[" + (n2 + 1) + "/" + this.getPageCount() + "]";
    }

    public boolean isValidated() {
        return this.isValid;
    }

    public abstract void drawPageContents(Graphics2D var1, int var2);

    private void drawPageFooter(Graphics2D graphics2D, int n2) {
        int n3 = graphics2D.getFontMetrics(this.fntHeader).getHeight();
        int n4 = graphics2D.getFontMetrics(this.fntHeader).getDescent();
        int n5 = this.h_PaperArea - this.h_FooterBox;
        graphics2D.translate(1, n5);
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillRect(0, 0, this.w_FooterBox, this.h_FooterBox);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, this.w_FooterBox, this.h_FooterBox);
        String string = this.getFooterString(n2);
        int n6 = 2 + (n3 - n4);
        int n7 = graphics2D.getFontMetrics(this.fntHeader).stringWidth(string);
        graphics2D.setFont(this.fntHeader);
        graphics2D.drawString(string, this.w_FooterBox - (n7 + 2), n6);
        graphics2D.translate(-1, -n5);
    }

    private void drawPageHeader(Graphics2D graphics2D, int n2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.fntHeader);
        String string = BasicUtilities.getString("Page") + " : " + (n2 + 1) + "/" + this.getPageCount();
        String string2 = this.getHeaderString(n2);
        int n3 = fontMetrics.stringWidth(string2) + fontMetrics.getLeading();
        int n4 = fontMetrics.stringWidth(string) + fontMetrics.getLeading();
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        graphics2D.translate(1, 1);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, 0, this.w_HeaderBox, this.h_HeaderBox);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, this.w_HeaderBox, this.h_HeaderBox);
        graphics2D.setFont(this.fntHeader);
        graphics2D.setColor(Color.black);
        int n7 = 2 + (n5 - n6);
        int n8 = 2 * n5 + 2 - n6;
        graphics2D.drawString(this.titleBuffer.toString(), 2 + fontMetrics.getLeading(), n7);
        graphics2D.drawString(this.TIMESTAMP, 2 + fontMetrics.getLeading(), n8);
        graphics2D.drawString(string2, this.w_HeaderBox - (n3 + 2), n7);
        graphics2D.drawString(string, this.w_HeaderBox - (n4 + 2), n8);
        graphics2D.translate(-1, -1);
    }

    private class Initializer
    implements Runnable {
        public Graphics2D g2;

        public Initializer(Graphics2D graphics2D) {
            this.g2 = graphics2D;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DefaultPaperComponent.this.setCursor(Cursor.getPredefinedCursor(3));
                DefaultPaperComponent.this.initialize(this.g2);
                DefaultPaperComponent.this.isValid = true;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "Initializer::run()");
            }
            finally {
                DefaultPaperComponent.this.setZoomLevel(1.0);
                DefaultPaperComponent.this.setPageNumber(0);
                DefaultPaperComponent.this.setCursor(Cursor.getDefaultCursor());
                DefaultPaperComponent.this.invalidate();
                DefaultPaperComponent.this.repaint(50L);
                DefaultPaperComponent.this.validateTree();
            }
        }
    }
}

