/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.isqlviewer.core.ImportPlugin;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class ImportRunner {
    private ImportConfig config = null;
    private DatabaseConnection connection = null;
    private EnhancedTableModel sourceData = null;
    private Collection plugins = SystemConfig.getInstance().getPluginFactory().createImportHandlers();
    private PrintWriter out = new PrintWriter(System.out, true);
    private PrintWriter err = new PrintWriter(System.err, true);
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$org$isqlviewer$event$ProgressListener;

    public ImportRunner(ImportConfig importConfig, DatabaseConnection databaseConnection) {
        if (importConfig == null || databaseConnection == null) {
            throw new NullPointerException();
        }
        this.config = importConfig;
        this.connection = databaseConnection;
    }

    public void setSourceData(EnhancedTableModel enhancedTableModel) {
        this.sourceData = enhancedTableModel;
    }

    public void setStdOut(OutputStream outputStream) {
        this.out = outputStream == null ? new PrintWriter(System.out, true) : new PrintWriter(outputStream, true);
    }

    public void setStdErr(OutputStream outputStream) {
        this.err = outputStream == null ? new PrintWriter(System.err, true) : new PrintWriter(outputStream, true);
    }

    public void addProgressListener(ProgressListener progressListener) {
        Class<?> clazz = class$org$isqlviewer$event$ProgressListener;
        if (clazz == null) {
            clazz = class$org$isqlviewer$event$ProgressListener = new ProgressListener[0].getClass().getComponentType();
        }
        this.listeners.add(clazz, progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        Class<?> clazz = class$org$isqlviewer$event$ProgressListener;
        if (clazz == null) {
            clazz = class$org$isqlviewer$event$ProgressListener = new ProgressListener[0].getClass().getComponentType();
        }
        this.listeners.remove(clazz, progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void runImport() {
        var1_1 = this.sourceData.getTrueRowCount();
        var2_2 = this.connection.getDebugOn();
        var3_3 = this.connection.getVerboseOn();
        var4_4 = this.connection.getAutoCommit();
        var5_5 = this.config.isUseTransaction() != false && this.connection.isTransactionsSupported() != false;
        var6_6 = this.config.isUseBatch() != false && this.connection.isBatchSupported() != false;
        var7_7 = this.connection.getCatalog();
        var8_8 = null;
        var9_9 = this.config.getTable();
        var10_10 = null;
        var11_11 = this.config.keys();
        var12_12 = new ArrayList<String>();
        var13_13 = this.getColumnTypeMap(var9_9);
        var14_14 = new ProgressEvent(this, 0, var6_6 != false ? var1_1 * 2 : var1_1);
        while (var11_11.hasNext()) {
            var15_15 = (String)var11_11.next();
            var16_22 = this.config.getEntry(var15_15);
            if (var16_22 != null) {
                var17_29 = var16_22.getPluginName();
                var18_34 = this.pluginForName(var17_29);
                var19_37 = var18_34.createProcessor();
                try {
                    var19_37.setEntry(var16_22);
                    if (!var19_37.canSkip()) {
                        var12_12.add(var15_15);
                        continue;
                    }
                    this.out.println(BasicUtilities.getString("ImportColumnSkip", var15_15));
                    continue;
                }
                catch (Throwable var20_38) {
                    var21_40 = BasicUtilities.getString("ImmportProcessError", var15_15);
                    throw new RuntimeException(var21_40, var20_38);
                }
            }
            this.out.println(BasicUtilities.getString("ImportColumnSkip", var15_15));
        }
        if (var12_12.isEmpty()) {
            this.out.println(BasicUtilities.getString("ImportEmptyError"));
            return;
        }
        var8_8 = JDBCUtilities.generatePreparedInsertRequest(var9_9, var12_12.toArray(new String[0]));
        try {
            var10_10 = this.connection.createPreparedStatement(var8_8);
            this.out.println(BasicUtilities.getString("Prepared_Statement_Info"));
            this.out.println(var8_8);
        }
        catch (Throwable var15_16) {
            this.finalizeStatement(var10_10);
            BasicUtilities.HandleException(var15_16, BasicUtilities.getString("Prepared_Statement_Error"), var2_2, this.err);
            return;
        }
        if (var5_5) {
            this.out.println(BasicUtilities.getString("Import_Transaction_Start"));
            if (var4_4) {
                this.connection.setAutoCommit(false);
            } else {
                var15_15 = BasicUtilities.getString("Import_Tx_Overlap_Warning");
                var16_23 = JOptionPane.showConfirmDialog(null, var15_15, null, 1);
                if (var16_23 == 0) {
                    this.connection.performCommit();
                } else if (var16_23 == 2) {
                    this.finalizeStatement(var10_10);
                    return;
                }
            }
        }
        try {
            try {
                var15_15 = null;
                if (var7_7 != null && var15_15 != null && !var7_7.equals(var15_15)) {
                    var16_24 = new String[]{var15_15, var7_7};
                    this.out.println(BasicUtilities.getString("Import_Catalog_Change", var16_24));
                    this.connection.changeCatalog(var15_15);
                }
            }
            catch (Throwable var15_17) {
                var16_25 = BasicUtilities.getString("Catalog_Change_Exception", var7_7);
                BasicUtilities.HandleException(var15_17, var16_25, var2_2, this.err);
                this.restoreAutoCommit(false, var4_4, var5_5);
                this.finalizeStatement(var10_10);
                var14_14.setProgress(var14_14.getMaximum());
                this.fireProgressEvent(var14_14);
                return;
            }
            block33: for (var15_18 = 0; var15_18 < var1_1; ++var15_18) {
                var11_11 = var12_12.iterator();
                var16_26 = 0;
                var14_14.setProgress(var15_18);
                while (var11_11.hasNext()) {
                    var17_30 = (String)var11_11.next();
                    var18_34 = this.config.getEntry(var17_30);
                    var19_37 = var18_34.getPluginName();
                    var20_39 = this.pluginForName((String)var19_37);
                    var21_41 = var20_39.createProcessor();
                    if (var21_41 == null) {
                        throw new NullPointerException((String)var19_37 + "::createProcessor()");
                    }
                    var22_42 = this.sourceData.getRowMap(var15_18);
                    var21_41.setEntry((ImportConfig.Entry)var18_34);
                    var23_43 = -1;
                    try {
                        var24_44 = (Integer)var13_13.get(var17_30);
                        var25_46 = var24_44 == null ? 1111 : var24_44;
                        var23_43 = var21_41.prepareImport(var15_18, ++var16_26, var22_42, var10_10, var25_46);
                    }
                    catch (Throwable var24_45) {
                        var25_47 = BasicUtilities.getString("ImmportProcessError", var17_30);
                        throw new RuntimeException(var25_47, var24_45);
                    }
                    switch (var23_43) {
                        case 2: {
                            this.restoreAutoCommit(false, var4_4, var5_5);
                            return;
                        }
                        case 3: {
                            JDBCUtilities.configurePreparedStatement(var10_10, var16_26 - 1, null, 0, false);
                            break;
                        }
                        case 1: {
                            var10_10.clearParameters();
                            continue block33;
                        }
                        ** case 0:
lbl111:
                        // 2 sources

                        default: {
                            var21_41 = null;
                            break;
                        }
                    }
                }
                this.fireProgressEvent(var14_14);
                if (var6_6) {
                    try {
                        this.out.println(BasicUtilities.getString("Import_AddBatch_Info", Integer.toString(var15_18)));
                        var10_10.addBatch();
                        continue;
                    }
                    catch (Throwable var17_31) {
                        var18_34 = BasicUtilities.getString("Import_AddBatch_Error", Integer.toString(var15_18));
                        BasicUtilities.HandleException(var17_31, (String)var18_34, var2_2, this.err);
                        this.restoreAutoCommit(false, var4_4, var5_5);
                        this.finalizeStatement(var10_10);
                        var14_14.setProgress(var14_14.getMaximum());
                        this.fireProgressEvent(var14_14);
                        return;
                    }
                }
                var17_32 = -1;
                try {
                    this.out.println(BasicUtilities.getString("Import_Exec_Info", Integer.toString(var15_18)));
                    var17_32 = var10_10.executeUpdate();
                    try {
                        var10_10.clearParameters();
                    }
                    catch (Throwable var18_35) {
                        // empty catch block
                    }
                    this.out.println(BasicUtilities.getString("Import_Exec_Result", Integer.toString(var17_32)));
                    continue;
                }
                catch (Throwable var18_36) {
                    var19_37 = BasicUtilities.getString("Import_Exec_Error");
                    BasicUtilities.HandleException(var18_36, (String)var19_37, var2_2, this.err);
                    this.restoreAutoCommit(false, var4_4, var5_5);
                    this.finalizeStatement(var10_10);
                    var14_14.setProgress(var14_14.getMaximum());
                    this.fireProgressEvent(var14_14);
                    return;
                }
            }
            if (var6_6) {
                try {
                    this.out.println(BasicUtilities.getString("Import_BatchInfo_Info"));
                    var15_19 = var10_10.executeBatch();
                    if (var2_2 && var3_3) {
                        var16_27 = var14_14.getProgress();
                        var14_14 = new ProgressEvent(this, var16_27, var16_27 + var15_19.length);
                        for (var17_33 = 0; var17_33 < var15_19.length; ++var17_33) {
                            var14_14.setProgress(var16_27++);
                            this.fireProgressEvent(var14_14);
                            var18_34 = Integer.toString(var15_19[var17_33]);
                            this.out.println(BasicUtilities.getString("Import_Exec_Result", (String)var18_34));
                        }
                    }
                }
                catch (Throwable var15_20) {
                    var16_28 = BasicUtilities.getString("Import_Exec_Error");
                    BasicUtilities.HandleException(var15_20, var16_28, var2_2, this.err);
                    this.restoreAutoCommit(false, var4_4, var5_5);
                    this.finalizeStatement(var10_10);
                    var14_14.setProgress(var14_14.getMaximum());
                    this.fireProgressEvent(var14_14);
                    return;
                }
            }
            this.restoreAutoCommit(true, var4_4, var5_5);
        }
        catch (Throwable var15_21) {
            BasicUtilities.HandleException(var15_21, "ImportWizard::runImport()", true, this.err);
            this.restoreAutoCommit(false, var4_4, var5_5);
            return;
        }
        finally {
            this.finalizeStatement(var10_10);
            var14_14.setProgress(var14_14.getMaximum());
            this.fireProgressEvent(var14_14);
        }
    }

    public void restoreAutoCommit(boolean bl2, boolean bl3, boolean bl4) {
        if (bl4 && !this.connection.getAutoCommit()) {
            if (bl2) {
                this.out.println(BasicUtilities.getString("Import_Transaction_Commit"));
                this.connection.performCommit();
            } else {
                this.out.println(BasicUtilities.getString("Import_Transaction_Rollback"));
                this.connection.performRollBack();
            }
            this.connection.setAutoCommit(bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getColumnTypeMap(String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        DatabaseMetaData databaseMetaData = this.connection.getDatabaseInformation();
        ResultSet resultSet = null;
        String string2 = this.connection.getCatalog();
        String string3 = this.connection.getSchema();
        try {
            resultSet = databaseMetaData.getColumns(string2, string3, string, "%");
            while (resultSet.next()) {
                String string4 = resultSet.getString("COLUMN_NAME");
                int n2 = resultSet.getInt("DATA_TYPE");
                hashMap.put(string4, new Integer(n2));
            }
        }
        catch (Throwable throwable) {
            hashMap.clear();
            BasicUtilities.beep();
            BasicUtilities.HandleException(throwable);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
            resultSet = null;
        }
        return hashMap;
    }

    public void fireProgressEvent(ProgressEvent progressEvent) {
        Class<?> clazz = class$org$isqlviewer$event$ProgressListener;
        if (clazz == null) {
            clazz = class$org$isqlviewer$event$ProgressListener = new ProgressListener[0].getClass().getComponentType();
        }
        EventListener[] eventListenerArray = this.listeners.getListeners(clazz);
        for (int i2 = 0; i2 < eventListenerArray.length; ++i2) {
            ProgressListener progressListener = (ProgressListener)eventListenerArray[i2];
            try {
                progressListener.progressUpdated(progressEvent);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.clearBatch();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                preparedStatement.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                preparedStatement.clearParameters();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                preparedStatement.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                preparedStatement = null;
            }
        }
    }

    private ImportPlugin pluginForName(String string) {
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            ImportPlugin importPlugin = (ImportPlugin)iterator.next();
            if (!importPlugin.getClass().getName().equals(string)) continue;
            return importPlugin;
        }
        return null;
    }
}

