/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.naming.spi.NamingManager;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.isqlviewer.core.ConfigConstants;
import org.isqlviewer.core.ContextFactoryBuilderImpl;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;
import org.xml.sax.XMLReader;

public final class SystemConfig {
    public static final int VERSION_MAJOR = 2;
    public static final int VERSION_MINOR = 1;
    public static final int VERSION_BUILD = 8;
    public static final String ISQL_VERSION = "2.1.8";
    public static final String PROPERTY_MRJ_ENABLED = "isql.mrj.enabled";
    public static final String PROPERTY_HOME = "isql.home";
    public static final String PROPERTY_PLUGIN_HOME = "isql.home.plugins";
    public static final String PROPERTY_SCRIPT_HOME = "isql.home.scripts";
    public static final String PROPERTY_LIBRARY_HOME = "isql.home.library";
    public static final String PROPERTY_VERSION = "isql.version";
    public static final String PROPERTY_SERVICE_PROVIDER = "isql.service.provider";
    public static final String PROPERTY_DEBUG = "isql.debug";
    public static final String PROPERTY_DEBUG_THREADS = "isql.debug.threads";
    public static final String PROPERTY_JAVA_WEBSTART = "isql.jnlp";
    public static final String PROPERTY_PROXY_ENABLED = "isql.proxy.enabled";
    public static final String PROPERTY_STANDALONE = "isql.stand-alone";
    public static final String PROPERTY_DEFAULTS_ROOT = "isql.prefs.root";
    private static final String preferencesRoot = System.getProperty("isql.prefs.root", "/org/isqlviewer/core/Preferences");
    private static final String fileBookmarks = "bookmarks.xml";
    private static File baseDirectory = null;
    private static File scriptDirectory = null;
    private static File pluginDirectory = null;
    private static File libraryDirectory = null;
    private static SystemConfig instance = new SystemConfig();
    private final String serviceProviderClass = System.getProperty("isql.service.provider", "org.isqlviewer.core.ServiceProviderImpl");
    private final String fileDrivers = "driver.properties";
    private UserPreferences userPreferences = new UserPreferences(SystemConfig.getDefaults(), preferencesRoot);
    private IPCService ipcService = new IPCService();
    private PluginFactory pluginFactory = PluginFactory.createInstance();
    private HistoryManager historyManager = HistoryManager.createInstance(this);
    private ServiceProvider serviceProvider = null;
    private EventHandlerSupport eventSupport = new EventHandlerSupport(null);
    private ClassLoader rtClassLoader = null;
    private Thread threadBookmarkSaver = null;
    private Thread threadIPC = null;
    private BookmarkTreeModel bookmarks = null;
    private long sessionTime = 0L;
    static /* synthetic */ Class class$org$isqlviewer$core$SystemConfig;

    public static File getBaseDirectory() {
        File file;
        String string = System.getProperty("user.home");
        if (baseDirectory == null && !(baseDirectory = new File(System.getProperty(PROPERTY_HOME, (file = new File(string, ".iSQL-Viewer")).getAbsolutePath()))).exists()) {
            baseDirectory.mkdirs();
        }
        return baseDirectory;
    }

    public static File getScriptsDirectory() {
        if (scriptDirectory == null) {
            File file = new File(SystemConfig.getBaseDirectory(), "scripts");
            scriptDirectory = new File(System.getProperty(PROPERTY_SCRIPT_HOME, file.getAbsolutePath()));
        }
        return scriptDirectory;
    }

    public static File getLibraryDirectory() {
        if (libraryDirectory == null) {
            File file = new File(SystemConfig.getBaseDirectory(), "lib");
            libraryDirectory = new File(System.getProperty(PROPERTY_LIBRARY_HOME, file.getAbsolutePath()));
        }
        return libraryDirectory;
    }

    public static File getPluginDirectory() {
        if (pluginDirectory == null) {
            File file = new File(SystemConfig.getBaseDirectory(), "plugins");
            pluginDirectory = new File(System.getProperty(PROPERTY_PLUGIN_HOME, file.getAbsolutePath()));
        }
        return pluginDirectory;
    }

    public static File getiSQLSubDir(String string) {
        File file = new File(baseDirectory, string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static synchronized SystemConfig getInstance() {
        return instance;
    }

    private SystemConfig() {
        System.setProperty(PROPERTY_HOME, SystemConfig.getBaseDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_LIBRARY_HOME, SystemConfig.getLibraryDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_SCRIPT_HOME, SystemConfig.getScriptsDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_PLUGIN_HOME, SystemConfig.getPluginDirectory().getAbsolutePath());
        System.setProperty(PROPERTY_VERSION, ISQL_VERSION);
        System.setProperty(PROPERTY_SERVICE_PROVIDER, this.serviceProviderClass);
        System.setProperty(PROPERTY_DEFAULTS_ROOT, preferencesRoot);
        this.createServiceProvider();
        if (Boolean.valueOf(System.getProperty(PROPERTY_STANDALONE, "true")).booleanValue()) {
            System.setProperty(PROPERTY_STANDALONE, "true");
        }
        if (Boolean.valueOf(System.getProperty(PROPERTY_PROXY_ENABLED, "true")).booleanValue()) {
            Authenticator.setDefault(new ProxyAuthenticator(null));
            System.setProperty(PROPERTY_PROXY_ENABLED, "true");
        }
        String string = this.userPreferences.get("iSQL-Version");
        boolean bl2 = this.userPreferences.getBoolean("general.driverupdate-enabled");
        this.initDriverDefinitions(bl2 && !string.equalsIgnoreCase(ISQL_VERSION));
        this.userPreferences.put("iSQL-Version", ISQL_VERSION);
        try {
            NamingManager.setInitialContextFactoryBuilder(new ContextFactoryBuilderImpl());
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
        }
        this.threadIPC = new Thread((Runnable)this.ipcService, "isql-ipc-service");
        this.threadIPC.start();
        this.sessionTime = System.currentTimeMillis();
        this.killSessionPreferences();
    }

    public UserPreferences getPreferences() {
        return this.userPreferences;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public File[] getRuntimeClasspaths() {
        String string = this.userPreferences.get("advanced.classpath");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, false);
        File[] fileArray = new File[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            fileArray[n2++] = new File(stringTokenizer.nextToken());
        }
        return fileArray;
    }

    public Properties getDriverDefinitions() {
        File file = new File(baseDirectory, "driver.properties");
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "SystemConfig::getDriverDefinitions()");
            }
        } else {
            try {
                URL uRL = BasicUtilities.getResourceURL("driver.properties");
                properties.load(uRL.openStream());
                uRL = null;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "SystemConfig::getDriverDefinitions()");
            }
        }
        file = null;
        return properties;
    }

    public ClassLoader getRuntimeClassLoader(boolean bl2) {
        if (bl2 || this.rtClassLoader == null) {
            this.initRuntimeClasspath();
        }
        return this.rtClassLoader;
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.getRuntimeClassLoader(false);
    }

    public BookmarkTreeModel getBookmarks() {
        if (this.bookmarks == null) {
            this.bookmarks = new BookmarkTreeModel();
            this.bookmarks.addTreeModelListener(this.eventSupport);
            try {
                File file = new File(SystemConfig.getBaseDirectory(), fileBookmarks);
                if (!file.exists()) {
                    return this.bookmarks;
                }
                this.bookmarks.load(this.getXMLReader(), new FileInputStream(file));
                Thread thread = new Thread((Runnable)this.eventSupport, "bookmark-saver");
                thread.setDaemon(true);
                thread.setPriority(1);
                thread.start();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
        }
        return this.bookmarks;
    }

    public Properties getJDBCDefaults() {
        String[] stringArray = new String[]{"jdbc.autocommit-enabled", "jdbc.debug-enabled", "jdbc.escapeProc-enabled", "jdbc.keepalive-enabled", "jdbc.max-fieldsize", "jdbc.max-rows", "jdbc.reverseFetch-enabled", "jdbc.trace-enabled", "jdbc.verbose-enabled", "jdbc.echo-query", "jdbc.echo-rowcount", "jdbc.resultsetkeys-enabled"};
        return this.userPreferences.toPropertiesWithKeys(Arrays.asList(stringArray));
    }

    public XMLReader getXMLReader() {
        XMLReader xMLReader = null;
        try {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                BasicUtilities.HandleException(parserConfigurationException);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
            xMLReader = null;
        }
        return xMLReader;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public IPCService getIPCService() {
        return this.ipcService;
    }

    public String getFormatForSQLType(int n2) {
        switch (n2) {
            case 91: {
                return this.userPreferences.get("general.date-format");
            }
            case 92: {
                return this.userPreferences.get("general.time-format");
            }
            case 93: {
                return this.userPreferences.get("general.timestamp-format");
            }
        }
        return null;
    }

    public Object[] performWebCheck() throws Exception {
        int n2;
        int n3;
        Object[] objectArray = new Object[]{null, null, Boolean.FALSE};
        if (Boolean.getBoolean(PROPERTY_JAVA_WEBSTART)) {
            return objectArray;
        }
        URL uRL = new URL("http://isql.sourceforge.net/version.php");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        objectArray[1] = uRLConnection.getHeaderField("iSQL-Version");
        objectArray[0] = uRLConnection.getHeaderField("Version-Type");
        if (objectArray[1] == null) {
            throw new IOException(BasicUtilities.getString("Web_Check_Proxy_Warning"));
        }
        String string = objectArray[1].toString();
        int n4 = 0;
        int n5 = string.indexOf(46, n4);
        int n6 = Integer.parseInt(string.substring(n4, n5));
        n4 = n5 + 1;
        n5 = string.indexOf(46, n4);
        int n7 = Integer.parseInt(string.substring(n4, n5));
        int n8 = 100 * n6 + 10 * n7 + (n3 = Integer.parseInt(string.substring(n4 = n5 + 1)));
        objectArray[2] = new Boolean(n8 > (n2 = 218));
        return objectArray;
    }

    public long getSessionTime() {
        return this.sessionTime;
    }

    public static synchronized void shutdown() {
        if (instance == null) {
            return;
        }
        instance.killSessionPreferences();
        SystemConfig.instance.threadIPC.interrupt();
        instance.getHistoryManager().shutdown(instance);
        SystemConfig.instance.pluginFactory.shutdown();
        if (SystemConfig.instance.threadBookmarkSaver != null) {
            SystemConfig.instance.threadBookmarkSaver.interrupt();
            try {
                SystemConfig.instance.threadBookmarkSaver.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        SystemConfig.storeBookmarks(instance.getBookmarks());
        if (!Boolean.getBoolean(PROPERTY_STANDALONE)) {
            try {
                Preferences preferences = Preferences.userRoot().node(preferencesRoot);
                preferences.removeNode();
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeBookmarks(BookmarkTreeModel bookmarkTreeModel) {
        if (bookmarkTreeModel != null && bookmarkTreeModel.isModified()) {
            File file = new File(SystemConfig.getBaseDirectory(), fileBookmarks);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file, false);
                PrintStream printStream = new PrintStream(fileOutputStream, true);
                BookmarkTreeModel bookmarkTreeModel2 = bookmarkTreeModel;
                synchronized (bookmarkTreeModel2) {
                    bookmarkTreeModel.store(printStream);
                }
                printStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                BasicUtilities.HandleException(iOException, BasicUtilities.getString("CFG_SAVE_ERROR"), true);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    fileOutputStream = null;
                }
            }
        }
    }

    private void killSessionPreferences() {
        if (!this.userPreferences.getBoolean("general.metrics-enabled")) {
            Preferences preferences = this.userPreferences.toPreferences();
            try {
                String[] stringArray = preferences.keys();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!stringArray[i2].startsWith("session.")) continue;
                    preferences.remove(stringArray[i2]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRuntimeClasspath() {
        Serializable serializable;
        try {
            URL[] uRLArray;
            serializable = new Vector();
            if (!((Vector)serializable).isEmpty()) {
                uRLArray = ((Vector)serializable).toArray(new URL[((Vector)serializable).size()]);
                Class<?> clazz = class$org$isqlviewer$core$SystemConfig;
                if (clazz == null) {
                    clazz = class$org$isqlviewer$core$SystemConfig = new SystemConfig[0].getClass().getComponentType();
                }
                this.rtClassLoader = new URLClassLoader(uRLArray, clazz.getClassLoader());
            } else {
                Class<?> clazz = class$org$isqlviewer$core$SystemConfig;
                if (clazz == null) {
                    clazz = class$org$isqlviewer$core$SystemConfig = new SystemConfig[0].getClass().getComponentType();
                }
                this.rtClassLoader = clazz.getClassLoader();
            }
            uRLArray = new StringBuffer("");
            Enumeration enumeration = ((Vector)serializable).elements();
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                uRLArray.append(uRL.getFile());
                uRLArray.append(File.pathSeparatorChar);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
            Class<?> clazz = class$org$isqlviewer$core$SystemConfig;
            if (clazz == null) {
                clazz = class$org$isqlviewer$core$SystemConfig = new SystemConfig[0].getClass().getComponentType();
            }
            this.rtClassLoader = clazz.getClassLoader();
        }
        finally {
            UIManager.put("ClassLoader", this.rtClassLoader);
            Thread.currentThread().setContextClassLoader(this.rtClassLoader);
            try {
                serializable = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel", true, this.rtClassLoader);
                ((Class)serializable).newInstance();
                serializable = null;
            }
            catch (Throwable throwable) {}
        }
    }

    private void initDriverDefinitions(boolean bl2) {
        File file = new File(baseDirectory, "driver.properties");
        if (file.exists() && bl2 && !file.delete()) {
            System.out.println("Could not reset driver definitions from file (" + file + ")");
        }
    }

    private void createServiceProvider() {
        try {
            Class<?> clazz = Class.forName(this.serviceProviderClass, true, this.getRuntimeClassLoader());
            this.serviceProvider = (ServiceProvider)clazz.newInstance();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "");
            System.exit(-1);
            return;
        }
    }

    private static Preferences getDefaults() {
        Preferences preferences = Preferences.userRoot().node("/org/isqlviewer/core/Defaults");
        preferences.put("iSQL-Version", ISQL_VERSION);
        preferences.put("advanced.xml-parser", "org.apache.xerces.parsers.SAXParser");
        preferences.putBoolean("general.security-enabled", true);
        preferences.putInt("print.table-style", 0);
        preferences.putBoolean("print.grid-enabled", true);
        preferences.putBoolean("print.header-enabled", true);
        preferences.putBoolean("print.footer-enabled", true);
        preferences.putBoolean("print.color-enabled", true);
        preferences.putBoolean("general.servicescan-enabled", false);
        preferences.putBoolean("general.alldrivers-visible", false);
        preferences.putBoolean("servicemanager.switchtab-enabled", true);
        preferences.putBoolean("general.driversort-enabled", true);
        preferences.putBoolean("general.driverupdate-enabled", true);
        preferences.putBoolean("general.showupdatetab-enabled", false);
        preferences.put("advanced.httpproxy-host", System.getProperty("http.proxyHost", ""));
        preferences.put("advanced.httpproxy-port", System.getProperty("http.proxyPort", "80"));
        preferences.put("advanced.httpproxy-user", "");
        preferences.put("advanced.httpproxy-pass", "");
        preferences.putInt("general.max-resultsets", 10);
        preferences.putBoolean("general.hiddenfiles-enabled", false);
        String string = BasicUtilities.getString("Preferred_Date_Format");
        preferences.put("general.date-format", string);
        string = BasicUtilities.getString("Preferred_Time_Format");
        preferences.put("general.time-format", string);
        string = BasicUtilities.getString("Preferred_Timestamp_Format");
        preferences.put("general.timestamp-format", string);
        preferences.putBoolean("general.ascii2native-enabled", false);
        preferences.putBoolean("toolbar.file-visible", true);
        preferences.putBoolean("toolbar.history-visible", true);
        preferences.putBoolean("toolbar.resultset-visible", true);
        preferences.put("toolbar.history-dock", "North");
        preferences.put("toolbar.file-dock", "North");
        preferences.put("toolbar.resultset-dock", "West");
        preferences.put("general.results-format", "%s (%r,%c)");
        preferences.put("general.plaf-class", UIManager.getSystemLookAndFeelClassName());
        preferences.putBoolean("general.1clicksort-enabled", BasicUtilities.isMac());
        preferences.putInt("history.style", 0);
        preferences.putInt("history.max-count", 256);
        preferences.putInt("history.max-days", 30);
        preferences.putBoolean("history.sessionclear-enabled", true);
        preferences.putBoolean("history.circular-enabled", true);
        preferences.putBoolean("history.duplicates-enabled", true);
        preferences.putBoolean("history.crc32-enabled", true);
        preferences.putBoolean("history.persistent-enabled", false);
        preferences.put("bookmark.location", BasicUtilities.getString("Bookmark_Pref_Loc_Right"));
        preferences.putBoolean("bookmark.activation-style", false);
        preferences.putBoolean("bookmarks.deletewarning-enabled", true);
        preferences.putInt("general.tablepage-size", 4096);
        preferences.putBoolean("general.refresh-reuse", true);
        preferences.putBoolean("general.large-icons", true);
        preferences.putBoolean("general.metrics-enabled", false);
        preferences.put("advanced.classpath", "");
        preferences.put("general.null-color", "#FF0000");
        preferences.putInt("advanced.versioncheck-type", 0);
        preferences.putBoolean("advanced.versioncheck-enabled", false);
        preferences.putBoolean("editor.syntax-help.enabled", true);
        preferences.putBoolean("editor.context-help.enabled", true);
        preferences.put("editor.font", "Default,11");
        String string2 = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.background"));
        preferences.put("editor.background-color", string2);
        string2 = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.foreground"));
        preferences.put("editor.default-color", string2);
        String string3 = null;
        string3 = ConfigConstants.createStyleKey("editor.sql-keywords", "color");
        preferences.put(string3, "#0000FF");
        string3 = ConfigConstants.createStyleKey("editor.sql-keywords", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.sql-keywords", "italics");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.functions", "color");
        preferences.put(string3, "#000808");
        string3 = ConfigConstants.createStyleKey("editor.functions", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.functions", "italics");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.literals", "color");
        preferences.put(string3, "#0000FF");
        string3 = ConfigConstants.createStyleKey("editor.literals", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.literals", "italics");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.local-obj", "color");
        preferences.put(string3, "#810558");
        string3 = ConfigConstants.createStyleKey("editor.local-obj", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.local-obj", "italics");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.foreign-obj", "color");
        preferences.put(string3, "#6666FF");
        string3 = ConfigConstants.createStyleKey("editor.foreign-obj", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.foreign-obj", "italics");
        preferences.putBoolean(string3, true);
        string3 = ConfigConstants.createStyleKey("editor.procedures", "color");
        preferences.put(string3, "#000808");
        string3 = ConfigConstants.createStyleKey("editor.procedures", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.procedures", "italics");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.parameters", "color");
        preferences.put(string3, "#808080");
        string3 = ConfigConstants.createStyleKey("editor.parameters", "bolded");
        preferences.putBoolean(string3, true);
        string3 = ConfigConstants.createStyleKey("editor.parameters", "italics");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.sline-comments", "color");
        preferences.put(string3, "#808080");
        string3 = ConfigConstants.createStyleKey("editor.sline-comments", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.sline-comments", "italics");
        preferences.putBoolean(string3, true);
        string3 = ConfigConstants.createStyleKey("editor.multicomment-color", "color");
        preferences.put(string3, "#5F9479");
        string3 = ConfigConstants.createStyleKey("editor.multicomment-color", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.multicomment-color", "italics");
        preferences.putBoolean(string3, true);
        string3 = ConfigConstants.createStyleKey("editor.tablespace", "color");
        preferences.put(string3, "#000088");
        string3 = ConfigConstants.createStyleKey("editor.tablespace", "bolded");
        preferences.putBoolean(string3, false);
        string3 = ConfigConstants.createStyleKey("editor.tablespace", "italics");
        preferences.putBoolean(string3, true);
        preferences.putBoolean("editor.caretoffset-enabled", false);
        preferences.putBoolean("editor.autoclear-enabled", false);
        preferences.put("console.timestamp-format", "[HH:mm:ss]");
        preferences.put("console.err-color", "#FF0000");
        preferences.put("console.sql-color", "#0000FF");
        string2 = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.background"));
        preferences.put("console.background-color", string2);
        string2 = StringUtilities.getHTMLColor(UIManager.getColor("TextArea.foreground"));
        preferences.put("console.foreground-color", string2);
        preferences.put("console.font", "Monospaced,9");
        preferences.putBoolean("jdbc.verbose-enabled", false);
        preferences.putBoolean("jdbc.reverseFetch-enabled", false);
        preferences.putBoolean("jdbc.debug-enabled", false);
        preferences.putBoolean("jdbc.trace-enabled", false);
        preferences.putBoolean("jdbc.escapeProc-enabled", false);
        preferences.putBoolean("jdbc.echo-query", true);
        preferences.putBoolean("jdbc.echo-rowcount", true);
        preferences.putBoolean("jdbc.keepalive-enabled", true);
        preferences.putBoolean("jdbc.autocommit-enabled", true);
        preferences.putBoolean("general.security-enabled", false);
        preferences.putInt("jdbc.timeout-login", 0);
        preferences.putInt("jdbc.timeout-query", 0);
        preferences.putInt("jdbc.max-fieldsize", 0);
        preferences.putInt("jdbc.max-rows", 0);
        preferences.putInt("jdbc.max-warnings", 10);
        preferences.put("batch.comment-char", "#");
        preferences.put("batch.literal-char", "\"");
        preferences.put("batch.seperator-char", ";");
        preferences.putInt("batch.comment-style", 0);
        preferences.putInt("batch.literal-style", 0);
        preferences.putInt("batch.seperator-style", 0);
        preferences.put("batch.lowercase-enable", "false");
        return preferences;
    }

    public static class 1 {
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private ProxyAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            SystemConfig systemConfig = SystemConfig.getInstance();
            UserPreferences userPreferences = systemConfig.getPreferences();
            String string = userPreferences.get("advanced.httpproxy-user");
            char[] cArray = userPreferences.get("advanced.httpproxy-pass").toCharArray();
            return new PasswordAuthentication(string, cArray);
        }

        public /* synthetic */ ProxyAuthenticator(1 var1_1) {
            this();
        }
    }

    private static class EventHandlerSupport
    implements TreeModelListener,
    Runnable {
        private static final long SAVE_THRESHOLD = 300000L;
        private long lastSave = 0L;

        private EventHandlerSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            EventHandlerSupport eventHandlerSupport = this;
            synchronized (eventHandlerSupport) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.interrupted()) {
                Object object = this;
                synchronized (object) {
                    try {
                        this.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                if (instance == null || this.lastSave + 300000L < System.currentTimeMillis()) continue;
                object = instance.getBookmarks();
                SystemConfig.storeBookmarks((BookmarkTreeModel)object);
                this.lastSave = System.currentTimeMillis();
            }
        }

        public /* synthetic */ EventHandlerSupport(1 var1_1) {
            this();
        }
    }
}

