/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.DriverPool;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceDefinition
implements Transferable,
Cloneable {
    public static final String REMOTE_URL = "url";
    public static final String REMOTE_VERSION = "version";
    public static final String REMOTE_SYNC_TYPE = "sync-type";
    public static final String REMOTE_RESOURCES = "local-resources";
    private static final String TAG_ROOT = "isql-service";
    private static final String TAG_AUTH = "authorization";
    private static final String TAG_EXTP = "extended-properties";
    private static final String TAG_JDBC = "jdbc-properties";
    private static final String TAG_RSRC = "resources";
    private static final String TAG_PROP = "property";
    private static final String TAG_JAR = "jar";
    private static final String TAG_CFG = "config";
    private static final String TAG_REMOTE = "remote-config";
    private static final String ATTRIB_SECURE = "secure";
    private static final String ATTRIB_SCHEMA = "preferred-schema";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_VALUE = "value";
    private static final String ATTRIB_DRVR = "driver";
    private static final String ATTRIB_USER = "user";
    private static final String ATTRIB_PASS = "password";
    private static final String ATTRIB_HREF = "href";
    private static final String ATTRIB_URL = "url";
    private static final byte[] xorKey = new byte[]{1, 8, 16, 24, 2, 10, 18, 26, 4, 12, 20, 28, 6, 14, 22, 30, 8, 16, 24, 32, 10, 18, 26, 34};
    private ArrayList resourceList = null;
    private String serviceName = null;
    private String driverClass = null;
    private String serviceURL = null;
    private String serviceUser = null;
    private String servicePass = null;
    private String preferredSchema = null;
    private Properties extProps = null;
    private Properties jdbcProps = null;
    private HashMap remoteProps = null;
    private boolean isSecure = false;
    private boolean isSynced = false;
    private ClassLoader classLoader = null;
    private DatabaseConnection cnx = null;
    private static final FilenameFilter filter = new ServiceFileFilter(null);
    private static final Charset charset = Charset.forName("UTF8");

    public static FilenameFilter getFileNameFilter() {
        return filter;
    }

    public ServiceDefinition(Properties properties, boolean bl2) {
        this.jdbcProps = properties == null ? null : (Properties)properties.clone();
        this.setSecurityEnabled(bl2);
    }

    private ServiceDefinition() {
    }

    private ServiceDefinition(ServiceDefinition serviceDefinition) {
        this.resourceList = serviceDefinition.resourceList != null ? (ArrayList)serviceDefinition.resourceList.clone() : null;
        this.extProps = serviceDefinition.extProps != null ? (Properties)serviceDefinition.extProps.clone() : null;
        this.serviceName = serviceDefinition.serviceName != null ? new String(serviceDefinition.serviceName) : null;
        this.driverClass = serviceDefinition.driverClass != null ? new String(serviceDefinition.driverClass) : null;
        this.serviceURL = serviceDefinition.serviceURL != null ? new String(serviceDefinition.serviceURL) : null;
        this.serviceUser = serviceDefinition.serviceUser != null ? new String(serviceDefinition.serviceUser) : null;
        this.servicePass = serviceDefinition.servicePass != null ? new String(serviceDefinition.servicePass) : null;
        this.preferredSchema = serviceDefinition.preferredSchema != null ? new String(serviceDefinition.preferredSchema) : null;
        this.isSecure = serviceDefinition.isSecure;
    }

    public void store(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, false);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + charset.name() + "\" standalone='yes' ?>");
        this.printRootTag(printWriter);
        printWriter.flush();
        printWriter.close();
        outputStreamWriter.close();
        printWriter = null;
        outputStreamWriter = null;
    }

    public void close() {
        if (this.cnx != null) {
            DriverPool.deregisterDriver(this.cnx.getDriver());
            this.cnx.disconnect();
            this.cnx = null;
        }
        this.classLoader = null;
        System.runFinalization();
    }

    public DatabaseConnection createConnection() throws ClassNotFoundException, SQLException {
        if (this.needsRemoteUpdate()) {
            try {
                this.synchronize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.cnx == null) {
            Properties properties;
            DriverPool.registerDriver(this.driverClass, this.getClassLoader());
            Properties properties2 = properties = this.extProps == null ? new Properties() : this.extProps;
            if (!properties.containsKey(ATTRIB_USER) && this.serviceUser != null) {
                properties.setProperty(ATTRIB_USER, this.serviceUser);
            }
            if (!properties.containsKey(ATTRIB_PASS) && this.servicePass != null) {
                properties.setProperty(ATTRIB_PASS, this.servicePass);
            }
            this.cnx = new DatabaseConnection(this.serviceURL.trim(), properties);
            this.cnx.configureOptions(this.jdbcProps);
            this.cnx.setPreferredSchema(this.preferredSchema);
            this.cnx.setConnectionName(this.getName());
        }
        return this.cnx;
    }

    public boolean isPromptRequired() {
        return this.serviceUser == null && this.servicePass == null;
    }

    public URL[] getResourceURLs() {
        URL[] uRLArray = new URL[this.resourceList == null ? 0 : this.resourceList.size()];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = (URL)this.resourceList.get(i2);
        }
        return uRLArray;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public Properties getProperties() {
        return this.extProps;
    }

    public Properties getPreferences() {
        return (Properties)this.jdbcProps.clone();
    }

    public ArrayList getResourceList() {
        return this.resourceList;
    }

    public String getName() {
        return this.serviceName;
    }

    public String getURL() {
        return this.serviceURL;
    }

    public String getUserName() {
        return this.serviceUser;
    }

    public void setDriverClass(String string) {
        this.driverClass = string;
    }

    public void setProperties(Properties properties) {
        this.extProps = properties;
    }

    public void setPreferences(Properties properties) {
        this.jdbcProps = properties;
    }

    public void setResourceList(ArrayList arrayList) {
        this.resourceList = arrayList;
        this.classLoader = null;
    }

    public void setName(String string) {
        this.serviceName = string;
    }

    public Object getRemoteConfig(String string) {
        if (this.isRemote()) {
            return this.remoteProps.get(string);
        }
        return null;
    }

    public void setSecurityEnabled(boolean bl2) {
        this.isSecure = bl2;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setPassword(String string) {
        this.servicePass = string;
    }

    public void setPreferredSchema(String string) {
        this.preferredSchema = string != null && string.trim().length() == 0 ? null : string;
    }

    public String getPreferredSchema() {
        return this.preferredSchema;
    }

    public void setURL(String string) {
        this.serviceURL = string;
    }

    public void setUserName(String string) {
        this.serviceUser = string;
    }

    public void setRemoteProperty(String string, Object object) {
        if (string == null | !this.isRemote() || object == null) {
            return;
        }
        if (string.equalsIgnoreCase(REMOTE_RESOURCES) && !(object instanceof ArrayList)) {
            throw new IllegalArgumentException(object.getClass().toString());
        }
        this.remoteProps.put(string, object);
    }

    public void setRemoteEnabled(boolean bl2, String string) {
        if (string == null) {
            string = "";
        }
        if (bl2) {
            if (this.remoteProps == null) {
                this.remoteProps = new HashMap();
            }
            this.remoteProps.put("url", string);
            this.remoteProps.put(REMOTE_VERSION, "0");
        } else {
            this.remoteProps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream) throws IOException {
        XMLReader xMLReader = null;
        SystemConfig systemConfig = SystemConfig.getInstance();
        try {
            xMLReader = systemConfig.getXMLReader();
            xMLReader.setContentHandler(new ServiceParser(this, false));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ServiceDefinition::load(InputStream, SystemConfig)");
        }
        finally {
            xMLReader = null;
            this.isSynced = false;
        }
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            ArrayList arrayList;
            URL[] uRLArray = this.getResourceURLs();
            if (this.isRemote() && (arrayList = (ArrayList)this.remoteProps.get(REMOTE_RESOURCES)) != null) {
                arrayList.addAll(Arrays.asList(uRLArray));
                uRLArray = arrayList.toArray(new URL[0]);
            }
            this.classLoader = uRLArray.length == 0 ? SystemConfig.getInstance().getRuntimeClassLoader() : new URLClassLoader(uRLArray, SystemConfig.getInstance().getRuntimeClassLoader());
        }
        return this.classLoader;
    }

    public void localize() {
        if (!this.isRemote()) {
            return;
        }
        this.remoteProps.put(REMOTE_VERSION, "-1");
        try {
            this.synchronize();
            ArrayList arrayList = (ArrayList)this.remoteProps.get(REMOTE_RESOURCES);
            if (arrayList != null) {
                if (this.resourceList != null) {
                    this.resourceList.addAll(arrayList);
                } else {
                    this.resourceList = new ArrayList(arrayList);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.remoteProps.clear();
        this.remoteProps = null;
    }

    public Object clone() {
        return new ServiceDefinition(this);
    }

    public boolean isRemote() {
        return this.remoteProps != null && !this.remoteProps.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        try {
            object = this;
            synchronized (object) {
                this.store(byteArrayOutputStream);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
        }
        object = byteArrayOutputStream.toString();
        byteArrayOutputStream.reset();
        byteArrayOutputStream = null;
        return object;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceDefinition) {
            ServiceDefinition serviceDefinition = (ServiceDefinition)object;
            return serviceDefinition.hashCode() == this.hashCode();
        }
        return false;
    }

    public boolean synchronize() throws IOException {
        if (this.isRemote() && this.needsRemoteUpdate()) {
            this.remoteSync();
            this.isSynced = true;
            return this.isSynced;
        }
        this.isSynced = true;
        return false;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{BasicUtilities.serviceFlavour, DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return BasicUtilities.serviceFlavour.equals(dataFlavor) || DataFlavor.javaFileListFlavor.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (BasicUtilities.serviceFlavour.equals(dataFlavor)) {
            return this;
        }
        if (dataFlavor.isFlavorJavaFileListType()) {
            ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(new File(this.getName().concat(".service")));
            return arrayList;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.toString();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsRemoteUpdate() {
        if (this.isRemote() && !this.isSynced) {
            String string;
            URLConnection uRLConnection = null;
            long l2 = -1L;
            try {
                string = (String)this.remoteProps.get(REMOTE_VERSION);
                l2 = Long.parseLong(string);
            }
            catch (Throwable throwable) {
                this.remoteProps.put(REMOTE_VERSION, Long.toString(l2));
            }
            try {
                string = (String)this.remoteProps.get("url");
                URL uRL = new URL(string);
                uRLConnection = uRL.openConnection();
                boolean bl2 = uRLConnection.getLastModified() != l2;
                return bl2;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                uRLConnection = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteSync() throws IOException {
        SystemConfig systemConfig = SystemConfig.getInstance();
        String string = (String)this.remoteProps.get("url");
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        String string2 = new String(this.serviceName == null ? "" : this.serviceName);
        InputStream inputStream = uRLConnection.getInputStream();
        XMLReader xMLReader = null;
        try {
            xMLReader = systemConfig.getXMLReader();
            xMLReader.setContentHandler(new ServiceParser(this, true));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ServiceDefinition::remoteUpdate()");
        }
        finally {
            xMLReader = null;
        }
        this.remoteProps.put(REMOTE_VERSION, Long.toString(uRLConnection.getLastModified()));
        this.setName(string2);
    }

    private String encryptString(String string) {
        int n2;
        byte[] byArray;
        if (string == null) {
            return "";
        }
        if (string.length() < xorKey.length) {
            int n3 = xorKey.length - string.length();
            byArray = new byte[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                byArray[n2] = xorKey[n2];
            }
            string = string.concat(new String(byArray));
        }
        byte[] byArray2 = string.getBytes();
        byArray = new byte[byArray2.length];
        n2 = 0;
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (n2 >= xorKey.length) {
                n2 = 0;
            }
            byArray[i2] = (byte)(xorKey[n2++] ^ byArray2[i2]);
        }
        String string2 = new String(byArray);
        return string2.trim();
    }

    private void printRootTag(PrintWriter printWriter) {
        printWriter.print("<");
        printWriter.print(TAG_ROOT);
        printWriter.print(" ");
        printWriter.print(ATTRIB_SECURE);
        printWriter.print("=\"");
        printWriter.print(this.isSecure);
        printWriter.print("\" ");
        printWriter.print(ATTRIB_NAME);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(this.serviceName).trim());
        printWriter.println("\" >");
        this.printRemoteTag(printWriter);
        this.printAuthTag(printWriter);
        this.printConfig(printWriter);
        printWriter.print("</");
        printWriter.print(TAG_ROOT);
        printWriter.println(">");
    }

    private void printAuthTag(PrintWriter printWriter) {
        if (this.serviceUser != null) {
            String string;
            printWriter.print("\t<");
            printWriter.print(TAG_AUTH);
            printWriter.print(" ");
            printWriter.print(ATTRIB_USER);
            printWriter.print("=\"");
            printWriter.print(StringUtilities.encodeXMLEntities(this.serviceUser).trim());
            printWriter.print("\" ");
            printWriter.print(ATTRIB_PASS);
            String string2 = string = this.servicePass == null ? "" : this.servicePass;
            if (string.trim().length() >= 1) {
                if (this.isSecure) {
                    string = this.encryptString(string);
                    Base64Encoder base64Encoder = new Base64Encoder(string);
                    string = base64Encoder.processString();
                } else {
                    Base64Encoder base64Encoder = new Base64Encoder(string);
                    string = base64Encoder.processString();
                }
            }
            printWriter.print("=\"");
            printWriter.print(string.trim());
            printWriter.println("\" />");
        }
    }

    private void printConfig(PrintWriter printWriter) {
        String string;
        Object object;
        Iterator<Object> iterator;
        printWriter.print("\t<");
        printWriter.print(TAG_CFG);
        printWriter.print(" ");
        if (this.preferredSchema != null) {
            printWriter.print(ATTRIB_SCHEMA);
            printWriter.print("=\"");
            printWriter.print(StringUtilities.encodeXMLEntities(this.preferredSchema).trim());
            printWriter.print("\" ");
        }
        printWriter.print(ATTRIB_DRVR);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(this.driverClass).trim());
        printWriter.print("\" ");
        printWriter.print("url");
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(this.serviceURL).trim());
        printWriter.println("\" >");
        if (this.extProps != null && !this.extProps.isEmpty()) {
            printWriter.print("\t\t<");
            printWriter.print(TAG_EXTP);
            printWriter.println(">");
            iterator = this.extProps.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                string = this.extProps.getProperty((String)object, "");
                printWriter.print("\t\t\t<");
                printWriter.print(TAG_PROP);
                printWriter.print(" ");
                printWriter.print(ATTRIB_NAME);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities((String)object).trim());
                printWriter.print("\" ");
                printWriter.print(ATTRIB_VALUE);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities(string).trim());
                printWriter.println("\" />");
            }
            printWriter.print("\t\t</");
            printWriter.print(TAG_EXTP);
            printWriter.println(">");
        }
        if (this.jdbcProps != null && !this.jdbcProps.isEmpty()) {
            printWriter.print("\t\t<");
            printWriter.print(TAG_JDBC);
            printWriter.println(">");
            iterator = this.jdbcProps.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                string = this.jdbcProps.getProperty((String)object, "");
                printWriter.print("\t\t\t<");
                printWriter.print(TAG_PROP);
                printWriter.print(" ");
                printWriter.print(ATTRIB_NAME);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities((String)object).trim());
                printWriter.print("\" ");
                printWriter.print(ATTRIB_VALUE);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities(string).trim());
                printWriter.println("\" />");
            }
            printWriter.print("\t\t</");
            printWriter.print(TAG_JDBC);
            printWriter.println(">");
        }
        if (this.resourceList != null && !this.resourceList.isEmpty()) {
            printWriter.print("\t\t<");
            printWriter.print(TAG_RSRC);
            printWriter.println(">");
            iterator = this.resourceList.iterator();
            while (iterator.hasNext()) {
                object = (URL)iterator.next();
                if (object == null) continue;
                printWriter.print("\t\t\t<");
                printWriter.print(TAG_JAR);
                printWriter.print(" ");
                printWriter.print(ATTRIB_HREF);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities(((URL)object).toExternalForm()).trim());
                printWriter.println("\" />");
            }
            printWriter.print("\t\t</");
            printWriter.print(TAG_RSRC);
            printWriter.println(">");
        }
        printWriter.print("\t</");
        printWriter.print(TAG_CFG);
        printWriter.println(">");
    }

    private void printRemoteTag(PrintWriter printWriter) {
        Object object;
        Object object2;
        Object object3;
        if (!this.isRemote()) {
            return;
        }
        Object object4 = null;
        printWriter.print("\t<");
        printWriter.print(TAG_REMOTE);
        printWriter.print(" ");
        printWriter.print(REMOTE_VERSION);
        printWriter.print("=\"");
        object4 = this.remoteProps.get(REMOTE_VERSION);
        printWriter.print(object4 == null ? "0" : object4);
        printWriter.print("\" ");
        printWriter.print("url");
        printWriter.print("=\"");
        object4 = this.remoteProps.get("url");
        printWriter.print(StringUtilities.encodeXMLEntities(object4.toString()).trim());
        printWriter.println("\" >");
        object4 = this.remoteProps.get(REMOTE_RESOURCES);
        if (object4 != null && object4 instanceof Collection) {
            object3 = (Collection)object4;
            object2 = object3.iterator();
            if (!object3.isEmpty()) {
                printWriter.print("\t\t<");
                printWriter.print(REMOTE_RESOURCES);
                printWriter.println(" >");
                while (object2.hasNext()) {
                    object = (URL)object2.next();
                    if (object == null) continue;
                    printWriter.print("\t\t\t<");
                    printWriter.print(TAG_JAR);
                    printWriter.print(" ");
                    printWriter.print(ATTRIB_HREF);
                    printWriter.print("=\"");
                    printWriter.print(StringUtilities.encodeXMLEntities(((URL)object).toExternalForm()).trim());
                    printWriter.println("\" />");
                }
                printWriter.print("\t\t</");
                printWriter.print(REMOTE_RESOURCES);
                printWriter.println(" >");
            }
        }
        object3 = this.remoteProps.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (((String)object2).equals(REMOTE_VERSION) || ((String)object2).equals("url") || ((String)object2).equals(REMOTE_RESOURCES)) continue;
            object = (String)this.remoteProps.get(object2);
            printWriter.print("\t\t<");
            printWriter.print(TAG_PROP);
            printWriter.print(" ");
            printWriter.print(ATTRIB_NAME);
            printWriter.print("=\"");
            printWriter.print(StringUtilities.encodeXMLEntities((String)object2).trim());
            printWriter.print("\" ");
            printWriter.print(ATTRIB_VALUE);
            printWriter.print("=\"");
            printWriter.print(StringUtilities.encodeXMLEntities((String)object).trim());
            printWriter.println("\" />");
        }
        printWriter.print("\t</");
        printWriter.print(TAG_REMOTE);
        printWriter.println(">");
    }

    private static String decryptString(String string) {
        if (string == null) {
            return "";
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (n2 >= xorKey.length) {
                n2 = 0;
            }
            byArray2[i2] = (byte)(byArray[i2] ^ xorKey[n2++]);
        }
        String string2 = new String(byArray2);
        string2.replace('\u0000', ' ');
        return string2.trim();
    }

    public static class 1 {
    }

    private static class ServiceParser
    extends DefaultHandler {
        private ArrayList tagStack = new ArrayList();
        private boolean ignoreRemoteTag = false;
        private ServiceDefinition reference = null;

        public ServiceParser(ServiceDefinition serviceDefinition, boolean bl2) {
            this.reference = serviceDefinition;
            this.ignoreRemoteTag = bl2;
        }

        public void endElement(String string, String string2, String string3) {
            try {
                this.tagStack.remove(this.tagStack.size() - 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Serializable serializable;
            this.tagStack.add(string3);
            String string4 = null;
            try {
                string4 = (String)this.tagStack.get(this.tagStack.size() - 2);
            }
            catch (Throwable throwable) {
                string4 = ServiceDefinition.TAG_ROOT;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_ROOT)) {
                if (attributes.getIndex(ServiceDefinition.ATTRIB_NAME) < 0) {
                    throw new SAXException("name attribute missing from root tag");
                }
                if (!this.ignoreRemoteTag) {
                    this.reference.serviceName = attributes.getValue(ServiceDefinition.ATTRIB_NAME);
                }
                try {
                    this.reference.isSecure = Boolean.valueOf(attributes.getValue(ServiceDefinition.ATTRIB_SECURE));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_REMOTE)) {
                if (this.ignoreRemoteTag || !string4.equals(ServiceDefinition.TAG_ROOT)) {
                    return;
                }
                if (attributes.getIndex("url") >= 0) {
                    this.reference.remoteProps = new HashMap();
                    this.reference.remoteProps.put("url", attributes.getValue("url"));
                    int n2 = attributes.getIndex(ServiceDefinition.REMOTE_VERSION);
                    if (n2 >= 0) {
                        this.reference.remoteProps.put(ServiceDefinition.REMOTE_VERSION, attributes.getValue(n2));
                    } else {
                        this.reference.remoteProps.put(ServiceDefinition.REMOTE_VERSION, "0");
                    }
                }
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_JDBC)) {
                if (!string4.equals(ServiceDefinition.TAG_CFG)) {
                    return;
                }
                this.reference.jdbcProps = this.reference.jdbcProps == null ? new Properties() : this.reference.jdbcProps;
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_RSRC)) {
                if (!string4.equals(ServiceDefinition.TAG_CFG)) {
                    return;
                }
                this.reference.resourceList = new ArrayList();
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_EXTP)) {
                if (!string4.equals(ServiceDefinition.TAG_CFG)) {
                    return;
                }
                this.reference.extProps = new Properties();
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_AUTH)) {
                String string5;
                if (!string4.equals(ServiceDefinition.TAG_ROOT)) {
                    return;
                }
                if (attributes.getIndex(ServiceDefinition.ATTRIB_USER) < 0) {
                    throw new SAXException("user attribute missing from authorization tag");
                }
                this.reference.servicePass = attributes.getValue(ServiceDefinition.ATTRIB_PASS) == null ? "" : attributes.getValue(ServiceDefinition.ATTRIB_PASS);
                String string6 = string5 = this.reference.servicePass == null ? "" : new String(this.reference.servicePass);
                if (string5.trim().length() >= 1) {
                    try {
                        Base64Decoder base64Decoder = new Base64Decoder(string5);
                        string5 = this.reference.isSecure ? ServiceDefinition.decryptString(base64Decoder.processString()) : base64Decoder.processString();
                    }
                    catch (Throwable throwable) {
                        System.out.println(BasicUtilities.getString("Password_Warning"));
                        string5 = this.reference.servicePass == null ? "" : new String(this.reference.servicePass);
                    }
                }
                this.reference.servicePass = new String(string5);
                this.reference.serviceUser = attributes.getValue(ServiceDefinition.ATTRIB_USER);
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.REMOTE_RESOURCES)) {
                if (this.ignoreRemoteTag || !string4.equals(ServiceDefinition.TAG_REMOTE)) {
                    return;
                }
                serializable = new ArrayList();
                this.reference.remoteProps.put(ServiceDefinition.REMOTE_RESOURCES, serializable);
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_CFG)) {
                if (!string4.equals(ServiceDefinition.TAG_ROOT)) {
                    return;
                }
                if (attributes.getIndex(ServiceDefinition.ATTRIB_DRVR) < 0) {
                    throw new SAXException("driver attribute missing from config tag");
                }
                if (attributes.getIndex("url") < 0) {
                    throw new SAXException("url attribute missing from config tag");
                }
                if (attributes.getIndex(ServiceDefinition.ATTRIB_SCHEMA) >= 0) {
                    this.reference.setPreferredSchema(attributes.getValue(ServiceDefinition.ATTRIB_SCHEMA));
                } else {
                    this.reference.preferredSchema = null;
                }
                this.reference.serviceURL = attributes.getValue("url");
                this.reference.driverClass = attributes.getValue(ServiceDefinition.ATTRIB_DRVR);
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_PROP)) {
                String string7;
                if (attributes.getIndex(ServiceDefinition.ATTRIB_NAME) < 0) {
                    throw new SAXException("name attribute missing from property tag");
                }
                serializable = null;
                if (string4.equals(ServiceDefinition.TAG_EXTP)) {
                    serializable = this.reference.extProps;
                } else if (string4.equals(ServiceDefinition.TAG_JDBC)) {
                    serializable = this.reference.jdbcProps;
                } else if (string4.equals(ServiceDefinition.TAG_REMOTE)) {
                    if (this.ignoreRemoteTag) {
                        return;
                    }
                    serializable = this.reference.remoteProps;
                }
                String string8 = string7 = attributes.getValue(ServiceDefinition.ATTRIB_NAME) == null ? "" : attributes.getValue(ServiceDefinition.ATTRIB_NAME);
                if (serializable != null && string7.trim().length() >= 1) {
                    String string9 = attributes.getValue(ServiceDefinition.ATTRIB_VALUE) == null ? "" : attributes.getValue(ServiceDefinition.ATTRIB_VALUE);
                    serializable.put(string7, string9);
                }
                return;
            }
            if (string3.equalsIgnoreCase(ServiceDefinition.TAG_JAR)) {
                if (!string4.equals(ServiceDefinition.TAG_RSRC) && !string4.equals(ServiceDefinition.REMOTE_RESOURCES)) {
                    return;
                }
                if (attributes.getIndex(ServiceDefinition.ATTRIB_HREF) < 0) {
                    throw new SAXException("href attribute missing from resource tag");
                }
                try {
                    serializable = new URL(attributes.getValue(ServiceDefinition.ATTRIB_HREF));
                    if (string4.equals(ServiceDefinition.TAG_RSRC)) {
                        if (this.reference.resourceList == null) {
                            this.reference.resourceList = new ArrayList();
                        }
                        this.reference.resourceList.add(serializable);
                    } else {
                        if (this.ignoreRemoteTag) {
                            return;
                        }
                        ArrayList<Serializable> arrayList = (ArrayList<Serializable>)this.reference.remoteProps.get(ServiceDefinition.REMOTE_RESOURCES);
                        if (arrayList == null) {
                            arrayList = new ArrayList<Serializable>();
                            this.reference.remoteProps.put(ServiceDefinition.REMOTE_RESOURCES, arrayList);
                        }
                        arrayList.add(serializable);
                    }
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                    System.out.println("Warning :: " + attributes.getValue(ServiceDefinition.ATTRIB_HREF) + " could not be interpeted as a URL");
                }
                return;
            }
        }
    }

    private static class ServiceFileFilter
    implements FilenameFilter {
        private ServiceFileFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl2 = string.endsWith(".service");
            return bl2;
        }

        public /* synthetic */ ServiceFileFilter(1 var1_1) {
            this();
        }
    }
}

