/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.zip.CRC32;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;

public class HistoryItem
implements Comparator,
Comparable,
Cloneable {
    public static final int COMPARE_MODE_SQL = 1;
    public static final int COMPARE_MODE_TIME = 0;
    public static final int COMPARE_MODE_SERVICE = 2;
    private long execTime = 0L;
    private String sql = null;
    private String serviceRef = null;
    private Date dte = null;
    private static final String FIELD_SEPERATOR = "\u0006";
    private static int comparableMode = 0;
    private static boolean useCRC32 = false;

    public static synchronized void setComparableMode(int n2, boolean bl2) {
        useCRC32 = bl2;
        switch (comparableMode) {
            case 0: 
            case 1: 
            case 2: {
                comparableMode = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static HistoryItem decode(String string) {
        HistoryItem historyItem = new HistoryItem();
        try {
            Base64Decoder base64Decoder = new Base64Decoder(string, true);
            StringTokenizer stringTokenizer = new StringTokenizer(base64Decoder.processString(), FIELD_SEPERATOR, false, false);
            historyItem.execTime = Long.parseLong(stringTokenizer.nextToken());
            historyItem.serviceRef = stringTokenizer.nextToken();
            historyItem.sql = stringTokenizer.nextToken();
            return historyItem;
        }
        catch (Base64FormatException base64FormatException) {
            try {
                Base64Decoder base64Decoder = new Base64Decoder(string);
                StringTokenizer stringTokenizer = new StringTokenizer(base64Decoder.processString(), FIELD_SEPERATOR, false, false);
                historyItem.execTime = Long.parseLong(stringTokenizer.nextToken());
                historyItem.serviceRef = stringTokenizer.nextToken();
                historyItem.sql = stringTokenizer.nextToken();
                return historyItem;
            }
            catch (Base64FormatException base64FormatException2) {
                return null;
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "HistoryItem::decode(String)");
            return null;
        }
    }

    public static String encode(HistoryItem historyItem) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(Long.toString(historyItem.execTime));
        stringBuffer.append(FIELD_SEPERATOR);
        stringBuffer.append(historyItem.serviceRef);
        stringBuffer.append(FIELD_SEPERATOR);
        stringBuffer.append(historyItem.sql);
        stringBuffer.append(FIELD_SEPERATOR);
        Base64Encoder base64Encoder = new Base64Encoder(stringBuffer.toString(), true);
        return base64Encoder.processString();
    }

    public HistoryItem(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.sql = string2;
        this.serviceRef = string;
        this.updateTimestamp();
    }

    public HistoryItem() {
        this("", "");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("HistoryItem[Service='");
        stringBuffer.append(this.serviceRef);
        stringBuffer.append("', executed='");
        stringBuffer.append(this.getTimeStamp());
        stringBuffer.append("', sql='");
        stringBuffer.append(this.getSQLData());
        stringBuffer.append("']");
        return stringBuffer.toString();
    }

    public Object clone() {
        HistoryItem historyItem = new HistoryItem();
        historyItem.execTime = this.execTime;
        historyItem.serviceRef = this.serviceRef;
        historyItem.sql = this.sql;
        return historyItem;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof HistoryItem) {
            HistoryItem historyItem = (HistoryItem)object;
            return this.compareTo(historyItem) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.sql.hashCode() + this.serviceRef.hashCode();
    }

    public int compare(Object object, Object object2) {
        if (!(object instanceof HistoryItem) && !(object instanceof HistoryItem)) {
            return 0;
        }
        HistoryItem historyItem = (HistoryItem)object;
        HistoryItem historyItem2 = (HistoryItem)object2;
        if (historyItem == null && historyItem2 == null) {
            return 0;
        }
        if (historyItem == null && historyItem2 != null) {
            return -1;
        }
        if (historyItem != null && historyItem2 == null) {
            return 1;
        }
        switch (comparableMode) {
            case 2: {
                return historyItem.serviceRef.compareTo(historyItem2.serviceRef);
            }
            case 0: {
                return historyItem.getTimeStamp().compareTo(historyItem2.getTimeStamp());
            }
            case 1: {
                if (useCRC32) {
                    try {
                        String string = StringUtilities.stripCharacters(historyItem.sql, "\r\t\n ").toLowerCase();
                        String string2 = StringUtilities.stripCharacters(historyItem2.sql, "\r\t\n ").toLowerCase();
                        CRC32 cRC32 = new CRC32();
                        CRC32 cRC322 = new CRC32();
                        cRC32.update(string.getBytes("UTF8"));
                        cRC322.update(string2.getBytes("UTF8"));
                        long l2 = cRC32.getValue();
                        long l3 = cRC322.getValue();
                        cRC32 = null;
                        cRC322 = null;
                        return l2 == l3 ? 0 : (l2 < l3 ? -1 : 1);
                    }
                    catch (Throwable throwable) {
                        return historyItem.sql.compareTo(historyItem2.sql);
                    }
                }
                return historyItem.sql.compareTo(historyItem2.sql);
            }
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compare(this, object);
    }

    public Date getTimeStamp() {
        if (this.dte == null) {
            this.dte = new Date(this.execTime);
        }
        return this.dte;
    }

    public String getServiceReference() {
        return this.serviceRef;
    }

    public String getSQLData() {
        return this.sql;
    }

    public String toMenuString() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.sql, "\t\r\n ");
        String string = stringTokenizer.nextToken();
        String string2 = "{0}, {1}";
        String string3 = DateFormat.getDateTimeInstance(3, 3).format(this.getTimeStamp());
        Object[] objectArray = new String[]{string, string3};
        return MessageFormat.format(string2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp() {
        HistoryItem historyItem = this;
        synchronized (historyItem) {
            this.dte = null;
            this.execTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSQL(String string) {
        HistoryItem historyItem = this;
        synchronized (historyItem) {
            this.sql = string;
        }
    }
}

