/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.PersistentComparator;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.SortedCollection;
import org.garret.perst.StorageError;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.TtreePage;

public class Ttree
extends PersistentResource
implements SortedCollection {
    private PersistentComparator comparator;
    private boolean unique;
    private TtreePage root;
    private int nMembers;
    static final IPersistent[] emptySelection = new IPersistent[0];

    private Ttree() {
    }

    Ttree(PersistentComparator persistentComparator, boolean bl2) {
        this.comparator = persistentComparator;
        this.unique = bl2;
    }

    public PersistentComparator getComparator() {
        return this.comparator;
    }

    public boolean recursiveLoading() {
        return false;
    }

    public IPersistent get(Object object) {
        if (this.root != null) {
            ArrayList arrayList = new ArrayList();
            this.root.find(this.comparator, object, 1, object, 1, arrayList);
            if (arrayList.size() > 1) {
                throw new StorageError(4);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return (IPersistent)arrayList.get(0);
        }
        return null;
    }

    public IPersistent[] get(Object object, Object object2) {
        return this.get(object, true, object2, true);
    }

    public IPersistent[] get(Object object, boolean bl2, Object object2, boolean bl3) {
        if (this.root != null) {
            ArrayList arrayList = new ArrayList();
            this.root.find(this.comparator, object, bl2 ? 1 : 0, object2, bl3 ? 1 : 0, arrayList);
            if (arrayList.size() != 0) {
                return arrayList.toArray(new IPersistent[arrayList.size()]);
            }
        }
        return emptySelection;
    }

    public boolean add(IPersistent iPersistent) {
        TtreePage ttreePage;
        if (this.root == null) {
            ttreePage = new TtreePage(iPersistent);
        } else {
            TtreePage.PageReference pageReference = new TtreePage.PageReference(this.root);
            if (this.root.insert(this.comparator, iPersistent, this.unique, pageReference) == 1) {
                return false;
            }
            ttreePage = pageReference.pg;
        }
        this.root = ttreePage;
        ++this.nMembers;
        this.modify();
        return true;
    }

    public boolean contains(IPersistent iPersistent) {
        return this.root != null && iPersistent != null ? this.root.contains(this.comparator, iPersistent) : false;
    }

    public boolean containsObject(IPersistent iPersistent) {
        return this.root != null && iPersistent != null ? this.root.containsObject(this.comparator, iPersistent) : false;
    }

    public void remove(IPersistent iPersistent) {
        if (this.root == null) {
            throw new StorageError(5);
        }
        TtreePage.PageReference pageReference = new TtreePage.PageReference(this.root);
        if (this.root.remove(this.comparator, iPersistent, pageReference) == 2) {
            throw new StorageError(5);
        }
        this.root = pageReference.pg;
        --this.nMembers;
        this.modify();
    }

    public int size() {
        return this.nMembers;
    }

    public void clear() {
        if (this.root != null) {
            this.root.prune();
            this.root = null;
            this.nMembers = 0;
            this.modify();
        }
    }

    public void deallocate() {
        if (this.root != null) {
            this.root.prune();
        }
        super.deallocate();
    }

    public IPersistent[] toPersistentArray() {
        if (this.root == null) {
            return emptySelection;
        }
        IPersistent[] iPersistentArray = new IPersistent[this.nMembers];
        this.root.toArray(iPersistentArray, 0);
        return iPersistentArray;
    }

    public IPersistent[] toPersistentArray(IPersistent[] iPersistentArray) {
        if (iPersistentArray.length < this.nMembers) {
            iPersistentArray = (IPersistent[])Array.newInstance(iPersistentArray.getClass().getComponentType(), this.nMembers);
        }
        if (this.root != null) {
            this.root.toArray(iPersistentArray, 0);
        }
        if (iPersistentArray.length > this.nMembers) {
            iPersistentArray[this.nMembers] = null;
        }
        return iPersistentArray;
    }

    public Iterator iterator() {
        return this.iterator(null, null);
    }

    public Iterator iterator(Object object, Object object2) {
        return this.iterator(object, true, object2, true);
    }

    public Iterator iterator(Object object, boolean bl2, Object object2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (this.root != null) {
            this.root.find(this.comparator, object, bl2 ? 1 : 0, object2, bl3 ? 1 : 0, arrayList);
        }
        return new TtreeIterator(this, arrayList);
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    static class TtreeIterator
    implements PersistentIterator {
        int i;
        ArrayList list;
        boolean removed;
        Ttree tree;

        TtreeIterator(Ttree ttree, ArrayList arrayList) {
            this.tree = ttree;
            this.list = arrayList;
            this.i = -1;
        }

        public Object next() {
            if (this.i + 1 >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return this.list.get(++this.i);
        }

        public int nextOid() {
            return ((IPersistent)this.next()).getOid();
        }

        public void remove() {
            if (this.removed || this.i < 0 || this.i >= this.list.size()) {
                throw new IllegalStateException();
            }
            this.tree.remove((IPersistent)this.list.get(this.i));
            this.list.remove(this.i--);
            this.removed = true;
        }

        public boolean hasNext() {
            return this.i + 1 < this.list.size();
        }
    }
}

