/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Link;
import org.garret.perst.PersistentResource;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

class ScalableSet
extends PersistentResource
implements IPersistentSet {
    Link link;
    IPersistentSet set;
    static final int BTREE_THRESHOLD = 128;

    ScalableSet(StorageImpl storageImpl, int n2) {
        super(storageImpl);
        if (n2 <= 128) {
            this.link = storageImpl.createLink(n2);
        } else {
            this.set = storageImpl.createSet();
        }
    }

    ScalableSet() {
    }

    public boolean isEmpty() {
        return this.size() != 0;
    }

    public int size() {
        return this.link != null ? this.link.size() : this.set.size();
    }

    public void clear() {
        if (this.link != null) {
            this.link.clear();
            this.modify();
        } else {
            this.set.clear();
        }
    }

    public boolean contains(Object object) {
        if (object instanceof IPersistent) {
            IPersistent iPersistent = (IPersistent)object;
            return this.link != null ? this.link.contains(iPersistent) : this.set.contains(iPersistent);
        }
        return false;
    }

    public Object[] toArray() {
        return this.link != null ? (Object[])this.link.toArray() : this.set.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.link != null ? (Object[])this.link.toArray((IPersistent[])objectArray) : this.set.toArray(objectArray);
    }

    public Iterator iterator() {
        return this.link != null ? this.link.iterator() : this.set.iterator();
    }

    public boolean add(Object object) {
        if (this.link != null) {
            IPersistent iPersistent = (IPersistent)object;
            if (this.link.indexOf(iPersistent) >= 0) {
                return false;
            }
            if (this.link.size() == 128) {
                this.set = this.getStorage().createSet();
                int n2 = this.link.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.set.add(this.link.getRaw(i2));
                }
                this.link = null;
                this.modify();
                this.set.add(iPersistent);
            } else {
                this.modify();
                this.link.add(iPersistent);
            }
            return true;
        }
        return this.set.add(object);
    }

    public boolean remove(Object object) {
        if (this.link != null) {
            IPersistent iPersistent = (IPersistent)object;
            int n2 = this.link.indexOf(iPersistent);
            if (n2 < 0) {
                return false;
            }
            this.link.remove(n2);
            this.modify();
            return true;
        }
        return this.set.remove(object);
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.add(iterator.next());
        }
        return bl2;
    }

    public boolean retainAll(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (collection.contains(e2)) continue;
            arrayList.add(e2);
        }
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.remove(arrayList.get(i2));
        }
        return n2 != 0;
    }

    public boolean removeAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.remove(iterator.next());
        }
        return bl2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (collection.size() != this.size()) {
            return false;
        }
        return this.containsAll(collection);
    }

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            n2 += ((IPersistent)iterator.next()).getOid();
        }
        return n2;
    }

    public void deallocate() {
        if (this.set != null) {
            this.set.deallocate();
        }
        super.deallocate();
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }
}

