/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Collection;
import java.util.Iterator;
import org.garret.perst.ITable;
import org.garret.perst.JSQLArithmeticException;
import org.garret.perst.JSQLRuntimeException;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;

class BinOpNode
extends Node {
    Node left;
    Node right;

    public boolean equals(Object object) {
        return object instanceof BinOpNode && super.equals(object) && ((BinOpNode)object).left.equals(this.left) && ((BinOpNode)object).right.equals(this.right);
    }

    long evaluateInt(FilterIterator filterIterator) {
        long l2 = this.left.evaluateInt(filterIterator);
        long l3 = this.right.evaluateInt(filterIterator);
        switch (this.tag) {
            case 1: {
                return l2 + l3;
            }
            case 2: {
                return l2 - l3;
            }
            case 3: {
                return l2 * l3;
            }
            case 4: {
                if (l3 == 0L) {
                    throw new JSQLArithmeticException("Divided by zero");
                }
                return l2 / l3;
            }
            case 5: {
                return l2 & l3;
            }
            case 6: {
                return l2 | l3;
            }
            case 10: {
                long l4 = 1L;
                if (l3 < 0L) {
                    l2 = 1L / l2;
                    l3 = -l3;
                }
                while (l3 != 0L) {
                    if ((l3 & 1L) != 0L) {
                        l4 *= l2;
                    }
                    l2 *= l2;
                    l3 >>>= 1;
                }
                return l4;
            }
        }
        throw new Error("Invalid tag");
    }

    double evaluateReal(FilterIterator filterIterator) {
        double d2 = this.left.evaluateReal(filterIterator);
        double d3 = this.right.evaluateReal(filterIterator);
        switch (this.tag) {
            case 38: {
                return d2 + d3;
            }
            case 39: {
                return d2 - d3;
            }
            case 40: {
                return d2 * d3;
            }
            case 41: {
                return d2 / d3;
            }
            case 44: {
                return Math.pow(d2, d3);
            }
        }
        throw new Error("Invalid tag");
    }

    String evaluateStr(FilterIterator filterIterator) {
        String string = this.left.evaluateStr(filterIterator);
        String string2 = this.right.evaluateStr(filterIterator);
        return string + string2;
    }

    Object evaluateObj(FilterIterator filterIterator) {
        Object object;
        try {
            object = this.left.evaluateObj(filterIterator);
        }
        catch (JSQLRuntimeException jSQLRuntimeException) {
            filterIterator.query.reportRuntimeError(jSQLRuntimeException);
            Object object2 = this.right.evaluateObj(filterIterator);
            if (object2 instanceof Boolean) {
                return (Boolean)object2 != false ? Boolean.TRUE : Boolean.FALSE;
            }
            throw jSQLRuntimeException;
        }
        if (object instanceof Boolean) {
            switch (this.tag) {
                case 125: {
                    return (Boolean)object != false && (Boolean)this.right.evaluateObj(filterIterator) != false ? Boolean.TRUE : Boolean.FALSE;
                }
                case 126: {
                    return (Boolean)object != false || (Boolean)this.right.evaluateObj(filterIterator) != false ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            throw new Error("Operation is not applicable to operands of boolean type");
        }
        Object object3 = this.right.evaluateObj(filterIterator);
        if (object instanceof Double || object instanceof Float || object3 instanceof Double || object3 instanceof Float) {
            double d2 = ((Number)object).doubleValue();
            double d3 = ((Number)object3).doubleValue();
            switch (this.tag) {
                case 121: {
                    return new Double(d2 + d3);
                }
                case 122: {
                    return new Double(d2 - d3);
                }
                case 123: {
                    return new Double(d2 * d3);
                }
                case 124: {
                    return new Double(d2 / d3);
                }
                case 130: {
                    return new Double(Math.pow(d2, d3));
                }
            }
            throw new Error("Operation is not applicable to operands of real type");
        }
        if (object instanceof String && object3 instanceof String) {
            return (String)object + (String)object3;
        }
        long l2 = ((Number)object).longValue();
        long l3 = ((Number)object3).longValue();
        switch (this.tag) {
            case 121: {
                return new Long(l2 + l3);
            }
            case 122: {
                return new Long(l2 - l3);
            }
            case 123: {
                return new Long(l2 * l3);
            }
            case 124: {
                if (l3 == 0L) {
                    throw new JSQLArithmeticException("Divided by zero");
                }
                return new Long(l2 / l3);
            }
            case 125: {
                return new Long(l2 & l3);
            }
            case 126: {
                return new Long(l2 | l3);
            }
            case 130: {
                long l4 = 1L;
                if (l2 < 0L) {
                    l3 = 1L / l3;
                    l2 = -l2;
                }
                while (l2 != 0L) {
                    if ((l2 & 1L) != 0L) {
                        l4 *= l3;
                    }
                    l3 *= l3;
                    l2 >>>= 1;
                }
                return new Long(l4);
            }
        }
        throw new Error("Operation is not applicable to operands of integer type");
    }

    static boolean areEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object instanceof Double || object instanceof Float || object2 instanceof Double || object2 instanceof Float) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        if (object instanceof Number || object2 instanceof Number) {
            return ((Number)object).longValue() == ((Number)object2).longValue();
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }

    static int compare(Object object, Object object2) {
        if (object instanceof Double || object instanceof Float || object2 instanceof Double || object2 instanceof Float) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            return d3 < (d2 = ((Number)object2).doubleValue()) ? -1 : (d3 == d2 ? 0 : 1);
        }
        if (object instanceof Number || object2 instanceof Number) {
            long l2;
            long l3 = ((Number)object).longValue();
            return l3 < (l2 = ((Number)object2).longValue()) ? -1 : (l3 == l2 ? 0 : 1);
        }
        return ((Comparable)object).compareTo(object2);
    }

    boolean evaluateBool(FilterIterator filterIterator) {
        switch (this.tag) {
            case 131: {
                return BinOpNode.areEqual(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator));
            }
            case 132: {
                return !BinOpNode.areEqual(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator));
            }
            case 135: {
                return BinOpNode.compare(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator)) < 0;
            }
            case 136: {
                return BinOpNode.compare(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator)) <= 0;
            }
            case 133: {
                return BinOpNode.compare(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator)) > 0;
            }
            case 134: {
                return BinOpNode.compare(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator)) >= 0;
            }
            case 139: {
                Object object = this.left.evaluateObj(filterIterator);
                Object object2 = this.right.evaluateObj(filterIterator);
                if (object2 instanceof String) {
                    return ((String)object2).indexOf((String)object) >= 0;
                }
                Object[] objectArray = (Object[])object2;
                int n2 = objectArray.length;
                while (--n2 >= 0) {
                    if (!object.equals(objectArray[n2])) continue;
                    return true;
                }
                return false;
            }
            case 94: {
                try {
                    if (!this.left.evaluateBool(filterIterator)) {
                        return false;
                    }
                }
                catch (JSQLRuntimeException jSQLRuntimeException) {
                    filterIterator.query.reportRuntimeError(jSQLRuntimeException);
                }
                return this.right.evaluateBool(filterIterator);
            }
            case 95: {
                try {
                    if (this.left.evaluateBool(filterIterator)) {
                        return true;
                    }
                }
                catch (JSQLRuntimeException jSQLRuntimeException) {
                    filterIterator.query.reportRuntimeError(jSQLRuntimeException);
                }
                return this.right.evaluateBool(filterIterator);
            }
            case 11: {
                return this.left.evaluateInt(filterIterator) == this.right.evaluateInt(filterIterator);
            }
            case 12: {
                return this.left.evaluateInt(filterIterator) != this.right.evaluateInt(filterIterator);
            }
            case 15: {
                return this.left.evaluateInt(filterIterator) < this.right.evaluateInt(filterIterator);
            }
            case 16: {
                return this.left.evaluateInt(filterIterator) <= this.right.evaluateInt(filterIterator);
            }
            case 13: {
                return this.left.evaluateInt(filterIterator) > this.right.evaluateInt(filterIterator);
            }
            case 14: {
                return this.left.evaluateInt(filterIterator) >= this.right.evaluateInt(filterIterator);
            }
            case 18: {
                return this.left.evaluateReal(filterIterator) == this.right.evaluateReal(filterIterator);
            }
            case 19: {
                return this.left.evaluateReal(filterIterator) != this.right.evaluateReal(filterIterator);
            }
            case 22: {
                return this.left.evaluateReal(filterIterator) < this.right.evaluateReal(filterIterator);
            }
            case 23: {
                return this.left.evaluateReal(filterIterator) <= this.right.evaluateReal(filterIterator);
            }
            case 20: {
                return this.left.evaluateReal(filterIterator) > this.right.evaluateReal(filterIterator);
            }
            case 21: {
                return this.left.evaluateReal(filterIterator) >= this.right.evaluateReal(filterIterator);
            }
            case 25: {
                return this.left.evaluateStr(filterIterator).equals(this.right.evaluateStr(filterIterator));
            }
            case 26: {
                return !this.left.evaluateStr(filterIterator).equals(this.right.evaluateStr(filterIterator));
            }
            case 29: {
                return this.left.evaluateStr(filterIterator).compareTo(this.right.evaluateStr(filterIterator)) < 0;
            }
            case 30: {
                return this.left.evaluateStr(filterIterator).compareTo(this.right.evaluateStr(filterIterator)) <= 0;
            }
            case 27: {
                return this.left.evaluateStr(filterIterator).compareTo(this.right.evaluateStr(filterIterator)) > 0;
            }
            case 28: {
                return this.left.evaluateStr(filterIterator).compareTo(this.right.evaluateStr(filterIterator)) >= 0;
            }
            case 34: {
                return this.left.evaluateBool(filterIterator) == this.right.evaluateBool(filterIterator);
            }
            case 35: {
                return this.left.evaluateBool(filterIterator) != this.right.evaluateBool(filterIterator);
            }
            case 36: {
                return BinOpNode.areEqual(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator));
            }
            case 37: {
                return BinOpNode.areEqual(this.left.evaluateObj(filterIterator), this.right.evaluateObj(filterIterator));
            }
            case 143: {
                return ((Collection)this.right.evaluateObj(filterIterator)).contains(this.left.evaluateObj(filterIterator));
            }
            case 144: {
                Iterator iterator = ((ITable)this.right.evaluateObj(filterIterator)).iterator();
                Object object = this.left.evaluateObj(filterIterator);
                while (iterator.hasNext()) {
                    if (iterator.next() != object) continue;
                    return true;
                }
                return false;
            }
            case 72: {
                boolean bl2 = this.left.evaluateBool(filterIterator);
                boolean[] blArray = (boolean[])this.right.evaluateObj(filterIterator);
                int n3 = blArray.length;
                while (--n3 >= 0) {
                    if (blArray[n3] != bl2) continue;
                    return true;
                }
                return false;
            }
            case 74: {
                long l2 = this.left.evaluateInt(filterIterator);
                byte[] byArray = (byte[])this.right.evaluateObj(filterIterator);
                int n4 = byArray.length;
                while (--n4 >= 0) {
                    if ((long)byArray[n4] != l2) continue;
                    return true;
                }
                return false;
            }
            case 73: {
                long l3 = this.left.evaluateInt(filterIterator);
                char[] cArray = (char[])this.right.evaluateObj(filterIterator);
                int n5 = cArray.length;
                while (--n5 >= 0) {
                    if ((long)cArray[n5] != l3) continue;
                    return true;
                }
                return false;
            }
            case 75: {
                long l4 = this.left.evaluateInt(filterIterator);
                short[] sArray = (short[])this.right.evaluateObj(filterIterator);
                int n6 = sArray.length;
                while (--n6 >= 0) {
                    if ((long)sArray[n6] != l4) continue;
                    return true;
                }
                return false;
            }
            case 76: {
                long l5 = this.left.evaluateInt(filterIterator);
                int[] nArray = (int[])this.right.evaluateObj(filterIterator);
                int n7 = nArray.length;
                while (--n7 >= 0) {
                    if ((long)nArray[n7] != l5) continue;
                    return true;
                }
                return false;
            }
            case 77: {
                long l6 = this.left.evaluateInt(filterIterator);
                long[] lArray = (long[])this.right.evaluateObj(filterIterator);
                int n8 = lArray.length;
                while (--n8 >= 0) {
                    if (lArray[n8] != l6) continue;
                    return true;
                }
                return false;
            }
            case 78: {
                double d2 = this.left.evaluateReal(filterIterator);
                float[] fArray = (float[])this.right.evaluateObj(filterIterator);
                int n9 = fArray.length;
                while (--n9 >= 0) {
                    if ((double)fArray[n9] != d2) continue;
                    return true;
                }
                return false;
            }
            case 79: {
                double d3 = this.left.evaluateReal(filterIterator);
                double[] dArray = (double[])this.right.evaluateObj(filterIterator);
                int n10 = dArray.length;
                while (--n10 >= 0) {
                    if (dArray[n10] != d3) continue;
                    return true;
                }
                return false;
            }
            case 80: {
                String string = this.left.evaluateStr(filterIterator);
                String[] stringArray = (String[])this.right.evaluateObj(filterIterator);
                int n11 = stringArray.length;
                while (--n11 >= 0) {
                    if (!string.equals(stringArray[n11])) continue;
                    return true;
                }
                return false;
            }
            case 81: {
                Object object = this.left.evaluateObj(filterIterator);
                Object[] objectArray = (Object[])this.right.evaluateObj(filterIterator);
                int n12 = objectArray.length;
                while (--n12 >= 0) {
                    if (!BinOpNode.areEqual(object, objectArray[n12])) continue;
                    return true;
                }
                return false;
            }
            case 82: {
                String string = this.left.evaluateStr(filterIterator);
                String string2 = this.right.evaluateStr(filterIterator);
                return string2.indexOf(string) >= 0;
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    BinOpNode(int n2, int n3, Node node, Node node2) {
        super(n2, n3);
        this.left = node;
        this.right = node2;
    }
}

