/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.Date;
import java.util.Iterator;
import org.garret.perst.Assert;
import org.garret.perst.Link;
import org.garret.perst.PersistentResource;
import org.garret.perst.Version;

public class VersionHistory
extends PersistentResource {
    Link versions;
    Version current;

    public synchronized Version getCurrent() {
        return this.current;
    }

    public synchronized void setCurrent(Version version) {
        this.current = version;
        this.modify();
    }

    public synchronized Version checkout() {
        Assert.that(this.current.isCheckedIn());
        return this.current.newVersion();
    }

    public synchronized Version getRoot() {
        return (Version)this.versions.get(0);
    }

    public synchronized Version getLatestBefore(Date date) {
        int n2;
        if (date == null) {
            return (Version)this.versions.get(this.versions.size() - 1);
        }
        int n3 = 0;
        int n4 = n2 = this.versions.size();
        long l2 = date.getTime() + 1L;
        while (n3 < n4) {
            int n5 = n3 + n4 >> 1;
            if (((Version)this.versions.get(n5)).getDate().getTime() < l2) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n4 > 0 ? (Version)this.versions.get(n4 - 1) : null;
    }

    public synchronized Version getEarliestAfter(Date date) {
        int n2;
        if (date == null) {
            return (Version)this.versions.get(0);
        }
        int n3 = 0;
        int n4 = n2 = this.versions.size();
        long l2 = date.getTime();
        while (n3 < n4) {
            int n5 = n3 + n4 >> 1;
            if (((Version)this.versions.get(n5)).getDate().getTime() < l2) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n4 < n2 ? (Version)this.versions.get(n4) : null;
    }

    public synchronized Version getVersionByLabel(String string) {
        int n2 = this.versions.size();
        while (--n2 >= 0) {
            Version version = (Version)this.versions.get(n2);
            if (!version.hasLabel(string)) continue;
            return version;
        }
        return null;
    }

    public synchronized Version getVersionById(String string) {
        int n2 = this.versions.size();
        while (--n2 >= 0) {
            Version version = (Version)this.versions.get(n2);
            if (!version.getId().equals(string)) continue;
            return version;
        }
        return null;
    }

    public synchronized Version[] getAllVersions() {
        return (Version[])this.versions.toArray(new Version[this.versions.size()]);
    }

    public synchronized Iterator iterator() {
        return this.versions.iterator();
    }

    public VersionHistory(Version version) {
        this.versions = version.getStorage().createLink(1);
        this.versions.add(version);
        this.current = version;
        this.current.history = this;
    }
}

