/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Index;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Query;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.ClassDescriptor;

public class Database {
    HashMap tables;
    Storage storage;
    Index metadata;
    boolean multithreaded;
    static /* synthetic */ Class class$java$lang$String;

    public Database(Storage storage, boolean bl2) {
        this.storage = storage;
        this.multithreaded = bl2;
        this.metadata = (Index)storage.getRoot();
        if (this.metadata == null) {
            this.metadata = storage.createIndex(class$java$lang$String == null ? (class$java$lang$String = Database.class$("java.lang.String")) : class$java$lang$String, true);
            storage.setRoot(this.metadata);
        }
        Iterator iterator = this.metadata.entryIterator();
        this.tables = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Class clazz = ClassDescriptor.loadClass(storage, (String)entry.getKey());
            this.tables.put(clazz, entry.getValue());
        }
    }

    public Database(Storage storage) {
        this(storage, false);
    }

    public boolean createTable(Class clazz) {
        if (this.multithreaded) {
            this.metadata.exclusiveLock();
        }
        if (this.tables.get(clazz) == null) {
            Table table = new Table();
            table.extent = this.storage.createSet();
            table.indices = this.storage.createLink();
            table.indicesMap = new HashMap();
            this.tables.put(clazz, table);
            this.metadata.put(clazz.getName(), (IPersistent)table);
            return true;
        }
        return false;
    }

    public boolean dropTable(Class clazz) {
        if (this.multithreaded) {
            this.metadata.exclusiveLock();
        }
        if (this.tables.remove(clazz) != null) {
            this.metadata.remove(clazz.getName());
            return true;
        }
        return false;
    }

    public boolean addRecord(IPersistent iPersistent) {
        return this.addRecord(iPersistent.getClass(), iPersistent);
    }

    private Table locateTable(Class clazz, boolean bl2) {
        Table table = null;
        if (this.multithreaded) {
            this.metadata.sharedLock();
        }
        for (Class clazz2 = clazz; clazz2 != null && (table = (Table)this.tables.get(clazz2)) == null; clazz2 = clazz2.getSuperclass()) {
        }
        if (table == null) {
            throw new StorageError(18, clazz.getName());
        }
        if (bl2) {
            table.extent.exclusiveLock();
        } else {
            table.extent.sharedLock();
        }
        return table;
    }

    public boolean addRecord(Class clazz, IPersistent iPersistent) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.multithreaded) {
            this.metadata.sharedLock();
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Table table = (Table)this.tables.get(clazz2);
            if (table == null) continue;
            bl3 = true;
            if (this.multithreaded) {
                table.extent.exclusiveLock();
            }
            if (!table.extent.add(iPersistent)) continue;
            Iterator iterator = table.indicesMap.values().iterator();
            while (iterator.hasNext()) {
                FieldIndex fieldIndex = (FieldIndex)iterator.next();
                fieldIndex.put(iPersistent);
            }
            bl2 = true;
        }
        if (!bl3) {
            throw new StorageError(18, clazz.getName());
        }
        return bl2;
    }

    public boolean deleteRecord(IPersistent iPersistent) {
        return this.deleteRecord(iPersistent.getClass(), iPersistent);
    }

    public boolean deleteRecord(Class clazz, IPersistent iPersistent) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.multithreaded) {
            this.metadata.sharedLock();
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Table table = (Table)this.tables.get(clazz2);
            if (table == null) continue;
            bl3 = true;
            if (this.multithreaded) {
                table.extent.exclusiveLock();
            }
            if (!table.extent.remove(iPersistent)) continue;
            Iterator iterator = table.indicesMap.values().iterator();
            while (iterator.hasNext()) {
                FieldIndex fieldIndex = (FieldIndex)iterator.next();
                fieldIndex.remove(iPersistent);
            }
            bl2 = true;
        }
        if (!bl3) {
            throw new StorageError(18, clazz.getName());
        }
        if (bl2) {
            iPersistent.deallocate();
        }
        return bl2;
    }

    public boolean createIndex(Class clazz, String string, boolean bl2) {
        Table table = this.locateTable(clazz, true);
        if (table.indicesMap.get(string) == null) {
            FieldIndex fieldIndex = this.storage.createFieldIndex(clazz, string, bl2);
            table.indicesMap.put(string, fieldIndex);
            table.indices.add(fieldIndex);
            return true;
        }
        return false;
    }

    public boolean dropIndex(Class clazz, String string) {
        Table table = this.locateTable(clazz, true);
        FieldIndex fieldIndex = (FieldIndex)table.indicesMap.remove(string);
        if (fieldIndex != null) {
            table.indices.remove(table.indices.indexOf(fieldIndex));
            return true;
        }
        return false;
    }

    public boolean excludeFromIndex(IPersistent iPersistent, String string) {
        return this.excludeFromIndex(iPersistent.getClass(), iPersistent, string);
    }

    public boolean excludeFromIndex(Class clazz, IPersistent iPersistent, String string) {
        Table table = this.locateTable(clazz, true);
        FieldIndex fieldIndex = (FieldIndex)table.indicesMap.get(string);
        if (fieldIndex != null) {
            fieldIndex.remove(iPersistent);
            return true;
        }
        return false;
    }

    public boolean includeInIndex(IPersistent iPersistent, String string) {
        return this.includeInIndex(iPersistent.getClass(), iPersistent, string);
    }

    public boolean includeInIndex(Class clazz, IPersistent iPersistent, String string) {
        Table table = this.locateTable(clazz, true);
        FieldIndex fieldIndex = (FieldIndex)table.indicesMap.get(string);
        if (fieldIndex != null) {
            fieldIndex.put(iPersistent);
            return true;
        }
        return false;
    }

    public Iterator select(Class clazz, String string) {
        return this.select(clazz, string, false);
    }

    public Iterator select(Class clazz, String string, boolean bl2) {
        Query query = this.prepare(clazz, string, bl2);
        return query.execute(this.getRecords(clazz));
    }

    public Query prepare(Class clazz, String string) {
        return this.prepare(clazz, string, false);
    }

    public Query prepare(Class clazz, String string, boolean bl2) {
        Table table = this.locateTable(clazz, bl2);
        Query query = this.storage.createQuery();
        query.prepare(clazz, string);
        Iterator iterator = table.indicesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FieldIndex fieldIndex = (FieldIndex)entry.getValue();
            String string2 = (String)entry.getKey();
            query.addIndex(string2, fieldIndex);
        }
        return query;
    }

    public Iterator getRecords(Class clazz) {
        return this.getRecords(clazz, false);
    }

    public Iterator getRecords(Class clazz, boolean bl2) {
        Table table = this.locateTable(clazz, bl2);
        return table.extent.iterator();
    }

    public Storage getStorage() {
        return this.storage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Table
    extends Persistent {
        IPersistentSet extent;
        Link indices;
        transient HashMap indicesMap = new HashMap();

        Table() {
        }

        public void onLoad() {
            int n2 = this.indices.size();
            while (--n2 >= 0) {
                FieldIndex fieldIndex = (FieldIndex)this.indices.get(n2);
                this.indicesMap.put(fieldIndex.getKeyFields()[0].getName(), fieldIndex);
            }
        }
    }
}

