/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.plugins;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.Rule;
import org.apache.commons.gs.digester.Rules;
import org.apache.commons.gs.digester.RulesBase;
import org.apache.commons.gs.digester.plugins.InitializableRule;
import org.apache.commons.gs.digester.plugins.LogUtils;
import org.apache.commons.gs.digester.plugins.PluginConfigurationException;
import org.apache.commons.gs.digester.plugins.PluginContext;
import org.apache.commons.gs.digester.plugins.PluginException;
import org.apache.commons.gs.digester.plugins.PluginManager;
import org.apache.commons.gs.digester.plugins.RulesFactory;

public class PluginRules
implements Rules {
    public Digester digester = null;
    private RulesFactory rulesFactory;
    private Rules decoratedRules;
    private PluginManager pluginManager;
    private String mountPoint = null;
    private PluginRules parent = null;
    private PluginContext pluginContext = null;

    public PluginRules() {
        this(new RulesBase());
    }

    public PluginRules(Rules rules) {
        this.decoratedRules = rules;
        this.pluginContext = new PluginContext();
        this.pluginManager = new PluginManager(this.pluginContext);
    }

    public PluginRules(Digester digester, String string, PluginRules pluginRules, Class clazz) throws PluginException {
        this.digester = digester;
        this.mountPoint = string;
        this.parent = pluginRules;
        this.rulesFactory = pluginRules.rulesFactory;
        this.decoratedRules = this.rulesFactory == null ? new RulesBase() : this.rulesFactory.newRules(digester, clazz);
        this.pluginContext = pluginRules.pluginContext;
        this.pluginManager = new PluginManager(pluginRules.pluginManager);
    }

    public Rules getParent() {
        return this.parent;
    }

    public Digester getDigester() {
        return this.digester;
    }

    public void setDigester(Digester digester) {
        this.digester = digester;
        this.decoratedRules.setDigester(digester);
    }

    public String getNamespaceURI() {
        return this.decoratedRules.getNamespaceURI();
    }

    public void setNamespaceURI(String string) {
        this.decoratedRules.setNamespaceURI(string);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public List getRuleFinders() {
        return this.pluginContext.getRuleFinders();
    }

    public void setRuleFinders(List list) {
        this.pluginContext.setRuleFinders(list);
    }

    public RulesFactory getRulesFactory() {
        return this.rulesFactory;
    }

    public void setRulesFactory(RulesFactory rulesFactory) {
        this.rulesFactory = rulesFactory;
    }

    public Rules getDecoratedRules() {
        return this.decoratedRules;
    }

    public List rules() {
        return this.decoratedRules.rules();
    }

    public void add(String string, Rule rule) {
        Logger logger = LogUtils.getLogger(this.digester);
        boolean bl2 = logger.isLoggable(Level.FINE);
        if (bl2) {
            logger.fine("add entry: mapping pattern [" + string + "]" + " to rule of type [" + rule.getClass().getName() + "]");
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.mountPoint != null && !string.equals(this.mountPoint) && !string.startsWith(this.mountPoint + "/")) {
            logger.warning("An attempt was made to add a rule with a pattern thatis not at or below the mountpoint of the current PluginRules object. Rule pattern: " + string + ", mountpoint: " + this.mountPoint + ", rule type: " + rule.getClass().getName());
            return;
        }
        this.decoratedRules.add(string, rule);
        if (rule instanceof InitializableRule) {
            try {
                ((InitializableRule)((Object)rule)).postRegisterInit(string);
            }
            catch (PluginConfigurationException pluginConfigurationException) {
                if (bl2) {
                    logger.log(Level.FINE, "Rule initialisation failed", pluginConfigurationException);
                }
                return;
            }
        }
        if (bl2) {
            logger.fine("add exit: mapped pattern [" + string + "]" + " to rule of type [" + rule.getClass().getName() + "]");
        }
    }

    public void clear() {
        this.decoratedRules.clear();
    }

    public List match(String string) {
        return this.match(null, string);
    }

    public List match(String string, String string2) {
        List list;
        Logger logger = LogUtils.getLogger(this.digester);
        boolean bl2 = logger.isLoggable(Level.FINE);
        if (bl2) {
            logger.fine("Matching path [" + string2 + "] on rules object " + this.toString());
        }
        if (this.mountPoint != null && string2.length() <= this.mountPoint.length()) {
            if (bl2) {
                logger.fine("Path [" + string2 + "] delegated to parent.");
            }
            list = this.parent.match(string, string2);
        } else {
            logger.fine("delegating to decorated rules.");
            list = this.decoratedRules.match(string, string2);
        }
        return list;
    }

    public void setPluginClassAttribute(String string, String string2) {
        this.pluginContext.setPluginClassAttribute(string, string2);
    }

    public void setPluginIdAttribute(String string, String string2) {
        this.pluginContext.setPluginIdAttribute(string, string2);
    }

    public String getPluginClassAttrNs() {
        return this.pluginContext.getPluginClassAttrNs();
    }

    public String getPluginClassAttr() {
        return this.pluginContext.getPluginClassAttr();
    }

    public String getPluginIdAttrNs() {
        return this.pluginContext.getPluginIdAttrNs();
    }

    public String getPluginIdAttr() {
        return this.pluginContext.getPluginIdAttr();
    }
}

