/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.gs.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];

    public static Object invokeConstructor(Class clazz, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray = new Object[]{object};
        return ConstructorUtils.invokeConstructor(clazz, objectArray);
    }

    public static Object invokeConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == objectArray) {
            objectArray = emptyObjectArray;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return ConstructorUtils.invokeConstructor(clazz, objectArray, classArray);
    }

    public static Object invokeConstructor(Class clazz, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor constructor;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (null == (constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, classArray))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray = new Object[]{object};
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == objectArray) {
            objectArray = emptyObjectArray;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray, classArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor constructor;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (null == (constructor = ConstructorUtils.getAccessibleConstructor(clazz, classArray))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray);
    }

    public static Constructor getAccessibleConstructor(Class clazz, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return ConstructorUtils.getAccessibleConstructor(clazz, classArray);
    }

    public static Constructor getAccessibleConstructor(Class clazz, Class[] classArray) {
        try {
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Constructor getAccessibleConstructor(Constructor constructor) {
        if (constructor == null) {
            return null;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return null;
        }
        Class clazz = constructor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return constructor;
        }
        return null;
    }

    private static Constructor getMatchingAccessibleConstructor(Class clazz, Class[] classArray) {
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            int n2 = classArray.length;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n3 = constructorArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Constructor constructor;
                Class<?>[] classArray2 = constructorArray[i2].getParameterTypes();
                int n4 = classArray2.length;
                if (n4 != n2) continue;
                boolean bl2 = true;
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (MethodUtils.isAssignmentCompatible(classArray2[i3], classArray[i3])) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2 || (constructor = ConstructorUtils.getAccessibleConstructor(constructorArray[i2])) == null) continue;
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return constructor;
            }
            return null;
        }
    }
}

