/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.BasicTypeInfo;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;

public class ClassPropertiesPanel
extends JPanel
implements Runnable {
    private IRemoteJSpaceAdmin spaceAdmin;
    private String className;
    private JPanel classPropertiesPanel = new JPanel();
    private JPanel checkBoxesPanel = new JPanel();
    private JLabel classNameLabel = new JLabel();
    private JTextField classNameTF = new JTextField();
    private JLabel superClassesListLabel = new JLabel();
    private JTextField superClassesListTF = new JTextField();
    private JLabel codeBaseLabel = new JLabel();
    private JTextField codeBaseTF = new JTextField();
    private JCheckBox fifoModeCB = new JCheckBox();
    private JLabel fifoModeLabel = new JLabel("FIFO Enabled");
    private JCheckBox replicationModeCB = new JCheckBox();
    private JLabel replicationModeLabel = new JLabel("Partial Replication Enabled");
    private JCheckBox extendedMatchingModeCB = new JCheckBox();
    private JLabel extendedMatchingModeLabel = new JLabel("Extended Indexing");
    private JLabel objectFormatNameLabel = new JLabel("Object Format:");
    private JLabel objectFormatLabel = new JLabel();
    private JScrollPane jScrollPane = new JScrollPane();
    private Border border1;
    private String[] resColumn;
    private String[] columnNames = new String[]{"Name", "Type", "Indexed"};
    private DefaultTableModel model = new DefaultTableModel();
    private JTable jTable = new JTable(this.model);
    private Thread m_classPropertiesThread;

    public ClassPropertiesPanel() {
        try {
            this.jbInit();
            this.m_classPropertiesThread = new Thread(this);
            this.m_classPropertiesThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buildTableColumns() {
        for (int i2 = 0; i2 < this.columnNames.length; ++i2) {
            this.model.addColumn(this.columnNames[i2]);
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.setLayout(new GridBagLayout());
        this.classNameLabel.setText("Class Name: ");
        this.classPropertiesPanel.setLayout(new GridBagLayout());
        this.checkBoxesPanel.setLayout(new GridBagLayout());
        this.classNameTF.setText("");
        this.classNameTF.setEditable(false);
        this.superClassesListLabel.setText("Super Classes List: ");
        this.superClassesListTF.setText("");
        this.superClassesListTF.setEditable(false);
        this.codeBaseLabel.setText("Codebase: ");
        this.codeBaseTF.setText("");
        this.codeBaseTF.setEditable(false);
        this.fifoModeCB.setEnabled(false);
        this.replicationModeCB.setEnabled(false);
        this.extendedMatchingModeCB.setEnabled(false);
        this.jScrollPane.setColumnHeader(null);
        this.jScrollPane.setAutoscrolls(true);
        this.jScrollPane.setBorder(this.border1);
        this.jScrollPane.setToolTipText("");
        this.buildTableColumns();
        this.jTable.setEnabled(false);
        this.jTable.getTableHeader().addMouseListener(new ColumnSortListener());
        this.fifoModeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassPropertiesPanel.this.fifoModeCB.setSelected(!ClassPropertiesPanel.this.fifoModeCB.isSelected());
            }
        });
        this.replicationModeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassPropertiesPanel.this.replicationModeCB.setSelected(!ClassPropertiesPanel.this.replicationModeCB.isSelected());
            }
        });
        this.extendedMatchingModeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassPropertiesPanel.this.extendedMatchingModeCB.setSelected(!ClassPropertiesPanel.this.extendedMatchingModeCB.isSelected());
            }
        });
        this.add((Component)this.classPropertiesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.classPropertiesPanel.add((Component)this.classNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 7, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.classNameTF, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.superClassesListLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 7, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.codeBaseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 7, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.codeBaseTF, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.checkBoxesPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.classPropertiesPanel.add((Component)this.jScrollPane, new GridBagConstraints(0, 4, 3, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jScrollPane.getViewport().add((Component)this.jTable, null);
        this.classPropertiesPanel.add((Component)this.superClassesListTF, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.fifoModeCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.fifoModeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.replicationModeCB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 10, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.replicationModeLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.extendedMatchingModeCB, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 10, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.extendedMatchingModeLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.checkBoxesPanel.add((Component)this.objectFormatNameLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 10, 2, 2), 0, 0));
        this.objectFormatLabel.setPreferredSize(new Dimension(55, 20));
        this.objectFormatLabel.setFont(this.objectFormatLabel.getFont().deriveFont(1));
        this.checkBoxesPanel.add((Component)this.objectFormatLabel, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 2, 2), 0, 0));
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ClassProperties");
        jFrame.setDefaultCloseOperation(3);
        ClassPropertiesPanel classPropertiesPanel = new ClassPropertiesPanel();
        classPropertiesPanel.setOpaque(true);
        jFrame.setContentPane(classPropertiesPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            try {
                this.clearClassPropertiesDialog();
                BasicTypeInfo basicTypeInfo = this.spaceAdmin.getClassTypeInfo(this.getClassName());
                this.classNameTF.setText(basicTypeInfo.m_ClassName);
                this.superClassesListTF.setText(this.getSuperClasses(basicTypeInfo.m_SuperClasses));
                this.codeBaseTF.setText(basicTypeInfo.m_CodeBase);
                this.fifoModeCB.setSelected(basicTypeInfo.m_IsFifo);
                this.replicationModeCB.setSelected(basicTypeInfo.m_IsReplicatable);
                this.extendedMatchingModeCB.setSelected(basicTypeInfo.isExtendedIndexing());
                object = this.getObjectFormatName(basicTypeInfo.getObjectFormat());
                this.objectFormatLabel.setText((String)object);
                this.buildDataTable(basicTypeInfo, this.columnNames.length, this.model);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private String getObjectFormatName(short s2) {
        String string = "";
        switch (s2) {
            case 0: {
                string = "Entry";
                break;
            }
            case 1: {
                string = "POJO";
            }
        }
        return string;
    }

    private void buildDataTable(BasicTypeInfo basicTypeInfo, int n2, DefaultTableModel defaultTableModel) {
        int n3 = basicTypeInfo.m_FieldsTypes.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[0] = basicTypeInfo.m_FieldsNames[i2];
            objectArray[1] = basicTypeInfo.m_FieldsTypes[i2];
            objectArray[2] = basicTypeInfo.m_IndexedFields[i2] ? "true" : "false";
            defaultTableModel.addRow(objectArray);
        }
    }

    private String getSuperClasses(String[] stringArray) {
        String string = new String();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            string = string + stringArray[i2];
            if (i2 == stringArray.length - 1) continue;
            string = string + "  ;  ";
        }
        return string;
    }

    public void clearClassPropertiesDialog() {
        this.model.setDataVector((Object[][])null, this.columnNames);
        this.classNameTF.setText("");
        this.superClassesListTF.setText("");
        this.codeBaseTF.setText("");
        this.fifoModeCB.setSelected(false);
        this.replicationModeCB.setSelected(false);
        this.extendedMatchingModeCB.setSelected(false);
        this.objectFormatLabel.setText("");
    }

    public void setSpaceAdmin(IRemoteJSpaceAdmin iRemoteJSpaceAdmin) {
        this.spaceAdmin = iRemoteJSpaceAdmin;
        this.clearClassPropertiesDialog();
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }
}

