/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.j_spaces.core.EntrySerializationException;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.TypeTableEntry;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.JSpaceProxyUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.sf.retrotranslator.runtime.java.lang._Byte;
import net.sf.retrotranslator.runtime.java.lang._Character;
import net.sf.retrotranslator.runtime.java.lang._Double;
import net.sf.retrotranslator.runtime.java.lang._Float;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.lang._Long;
import net.sf.retrotranslator.runtime.java.lang._Short;

public class EntryPacket
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public String m_EntryUID;
    public String m_ClassName;
    public String m_CodeBase;
    public String[] m_SuperClasses;
    public String[] m_FieldsNames;
    public String[] m_FieldsTypes;
    public boolean[] m_IndexIndicators;
    public boolean m_Replicatable;
    public boolean m_FifoOrder;
    public boolean m_Transient;
    public Object[] m_FieldsValues;
    public int m_VersionID;
    public long m_TimeToLive;
    public String[] m_MultipleUIDs;
    public int m_SuperClassesChecksum;
    public int m_FieldsNamesChecksum;
    public int m_FieldsTypesChecksum;
    public String _firstIndexName;
    public boolean m_NOWriteLease;
    public short _objectFormat;
    public int _logicID = -1;
    public boolean _isFromClusteredProxy;
    private static final byte OBJECT_BIT = 0;
    private static final byte INTEGER_BIT = 1;
    private static final byte DOUBLE_BIT = 2;
    private static final byte FLOAT_BIT = 3;
    private static final byte LONG_BIT = 4;
    private static final byte STRING_BIT = 5;
    private static final byte SHORT_BIT = 6;
    private static final byte BOOLEAN_BIT = 7;
    private static final byte CHAR_BIT = 8;
    private static final byte BYTE_BIT = 9;

    public EntryPacket(String string, String string2, String string3, int n2, int n3, int n4, Object[] objectArray, int n5, long l2, boolean bl2, boolean bl3, boolean bl4, short s2) {
        this.m_ClassName = string;
        this.m_EntryUID = string2;
        this.m_CodeBase = string3;
        this.m_SuperClassesChecksum = n2;
        this.m_FieldsNamesChecksum = n3;
        this.m_FieldsTypesChecksum = n4;
        this.m_FieldsValues = objectArray;
        this.m_VersionID = n5;
        this.m_TimeToLive = l2;
        this.m_FifoOrder = bl2;
        this.m_Transient = bl3;
        this.m_NOWriteLease = bl4;
        this._objectFormat = s2;
    }

    public EntryPacket(String string, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3, int n2, int n3, int n4, Object[] objectArray, int n5, long l2, boolean[] blArray, boolean bl2, boolean bl3, boolean bl4, boolean bl5, short s2, String string4) {
        this(string, string2, string3, n2, n3, n4, objectArray, n5, l2, bl3, bl4, bl5, s2);
        this.m_SuperClasses = stringArray;
        this.m_FieldsNames = stringArray2;
        this.m_FieldsTypes = stringArray3;
        this.m_IndexIndicators = blArray;
        this.m_Replicatable = bl2;
        this._firstIndexName = string4;
    }

    public EntryPacket(String string, int n2) {
        this.m_EntryUID = string;
        this.m_VersionID = n2;
    }

    public EntryPacket(String[] stringArray) {
        this.m_MultipleUIDs = stringArray;
    }

    public EntryPacket(IGSEntry iGSEntry) {
        this.m_ClassName = iGSEntry.getClassName();
        this.m_EntryUID = iGSEntry.getUID();
        this.m_SuperClassesChecksum = JSpaceProxyUtil.getCheckSum(iGSEntry.getSuperClassesNames());
        this.m_FieldsNamesChecksum = JSpaceProxyUtil.getCheckSum(iGSEntry.getFieldsNames());
        this.m_FieldsTypesChecksum = JSpaceProxyUtil.getCheckSum(iGSEntry.getFieldsTypes());
        this.m_FieldsValues = iGSEntry.getFieldsValues();
        this.m_TimeToLive = iGSEntry.getTimeToLive();
        this.m_Transient = iGSEntry.isTransient();
        this.m_FifoOrder = iGSEntry.isFifo();
        this.m_SuperClasses = iGSEntry.getSuperClassesNames();
        this.m_FieldsNames = iGSEntry.getFieldsNames();
        this.m_FieldsTypes = iGSEntry.getFieldsTypes();
        this.m_IndexIndicators = iGSEntry.getIndexIndicators();
        this.m_Replicatable = iGSEntry.isReplicatable();
        this.m_VersionID = iGSEntry.getVersion();
        this._objectFormat = iGSEntry.getFormat();
        this._firstIndexName = iGSEntry.getPrimaryKeyName();
        this.m_CodeBase = null;
        this.m_NOWriteLease = false;
    }

    public EntryPacket() {
    }

    private void writePrimitiveObject(ObjectOutput objectOutput, Object object, int n2) throws IOException {
        try {
            if (object instanceof Integer) {
                objectOutput.writeByte(1);
                objectOutput.writeInt((Integer)object);
            } else if (object instanceof Double) {
                objectOutput.writeByte(2);
                objectOutput.writeDouble((Double)object);
            } else if (object instanceof Float) {
                objectOutput.writeByte(3);
                objectOutput.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Long) {
                objectOutput.writeByte(4);
                objectOutput.writeLong((Long)object);
            } else if (object instanceof String && (long)((String)object).length() <= 65535L) {
                objectOutput.writeByte(5);
                objectOutput.writeUTF((String)object);
            } else if (object instanceof Short) {
                objectOutput.writeByte(6);
                objectOutput.writeShort(((Short)object).shortValue());
            } else if (object instanceof Boolean) {
                objectOutput.writeByte(7);
                objectOutput.writeBoolean((Boolean)object);
            } else if (object instanceof Character) {
                objectOutput.writeByte(8);
                objectOutput.writeChar(((Character)object).charValue());
            } else if (object instanceof Byte) {
                objectOutput.writeByte(9);
                objectOutput.writeByte(((Byte)object).byteValue());
            } else {
                objectOutput.writeByte(0);
                if (objectOutput instanceof ObjectOutputStream) {
                    ((ObjectOutputStream)objectOutput).writeUnshared(object);
                } else {
                    objectOutput.writeObject(object);
                }
            }
        }
        catch (IOException iOException) {
            String string = "";
            String string2 = "";
            if (this.m_FieldsNames != null && this.m_FieldsNames[n2] != null) {
                string = "\nField Name      : " + this.m_FieldsNames[n2];
            }
            if (this.m_FieldsValues != null && this.m_FieldsValues[n2] != null) {
                string2 = "\nField Type     : " + this.m_FieldsValues[n2].getClass().getName();
            }
            throw new EntrySerializationException("Failed to serialize Entry field.\nEntry Classname : " + this.m_ClassName + string2 + string, iOException);
        }
    }

    private Object readPrimitiveObject(ObjectInput objectInput, int n2) throws IOException, ClassNotFoundException {
        try {
            byte by2 = objectInput.readByte();
            switch (by2) {
                case 1: {
                    return _Integer.valueOf(objectInput.readInt());
                }
                case 2: {
                    return _Double.valueOf(objectInput.readDouble());
                }
                case 3: {
                    return _Float.valueOf(objectInput.readFloat());
                }
                case 4: {
                    return _Long.valueOf(objectInput.readLong());
                }
                case 5: {
                    return objectInput.readUTF();
                }
                case 6: {
                    return _Short.valueOf(objectInput.readShort());
                }
                case 7: {
                    return objectInput.readBoolean();
                }
                case 8: {
                    return _Character.valueOf(objectInput.readChar());
                }
                case 9: {
                    return _Byte.valueOf(objectInput.readByte());
                }
            }
            if (objectInput instanceof ObjectInputStream) {
                return ((ObjectInputStream)objectInput).readUnshared();
            }
            return objectInput.readObject();
        }
        catch (IOException iOException) {
            String string = "";
            String string2 = "";
            if (this.m_FieldsNames != null && this.m_FieldsNames[n2] != null) {
                string = "\nField Name      : " + this.m_FieldsNames[n2];
            }
            if (this.m_FieldsValues != null && this.m_FieldsValues[n2] != null) {
                string2 = "\nField Type     : " + this.m_FieldsValues[n2].getClass().getName();
            }
            throw new EntrySerializationException("Failed to deserialize Entry field.\nEntry Classname : " + this.m_ClassName + string2 + string, iOException);
        }
    }

    private int buildFlags() {
        int n2 = 0;
        if (this.m_EntryUID != null) {
            n2 |= 0x10000000;
        }
        if (this.m_TimeToLive != 0L) {
            n2 |= 0x20000000;
        }
        if (this.m_ClassName != null) {
            n2 |= 0x40000000;
        }
        if (this.m_CodeBase != null) {
            n2 |= Integer.MIN_VALUE;
        }
        if (this.m_FifoOrder) {
            n2 |= 0x1000000;
        }
        if (this.m_Transient) {
            n2 |= 0x2000000;
        }
        if (this.m_NOWriteLease) {
            n2 |= 0x4000000;
        }
        if (this.m_FieldsValues != null) {
            n2 |= 0x8000000;
        }
        if (this.m_FieldsNames != null) {
            n2 |= 0x100000;
        }
        if (this.m_Replicatable) {
            n2 |= 0x200000;
        }
        if (this.m_SuperClasses != null) {
            n2 |= 0x400000;
        }
        if (this.m_MultipleUIDs != null && this.m_ClassName == null) {
            n2 |= 0x800000;
        }
        if (this._firstIndexName != null) {
            n2 |= 0x10000;
        }
        if (this._logicID != -1) {
            n2 |= 0x20000;
        }
        if (this._isFromClusteredProxy) {
            n2 |= 0x40000;
        }
        return n2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            int n2;
            objectOutput.writeInt(this.buildFlags());
            if (this.m_EntryUID != null) {
                objectOutput.writeUTF(this.m_EntryUID);
                objectOutput.writeInt(this.m_VersionID);
                if (this.m_TimeToLive != 0L) {
                    objectOutput.writeLong(this.m_TimeToLive);
                }
            }
            if (this.m_ClassName != null) {
                objectOutput.writeUTF(this.m_ClassName);
                if (this.m_CodeBase != null) {
                    objectOutput.writeUTF(this.m_CodeBase);
                }
                objectOutput.writeInt(this.m_SuperClassesChecksum);
                objectOutput.writeInt(this.m_FieldsNamesChecksum);
                objectOutput.writeInt(this.m_FieldsTypesChecksum);
            }
            if (this.m_FieldsValues != null) {
                int n3;
                n2 = this.m_FieldsValues.length;
                objectOutput.writeInt(n2);
                int n4 = 0;
                boolean bl2 = false;
                if (n2 > 3) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (this.m_FieldsValues[n3] == null) continue;
                        ++n4;
                    }
                    if (n4 < n2 / 2) {
                        bl2 = true;
                    }
                    objectOutput.writeBoolean(bl2);
                    if (bl2) {
                        objectOutput.writeInt(n4);
                    }
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    if (this.m_FieldsValues[n3] != null) {
                        if (bl2) {
                            objectOutput.writeInt(n3);
                        } else {
                            objectOutput.writeBoolean(true);
                        }
                        this.writePrimitiveObject(objectOutput, this.m_FieldsValues[n3], n3);
                        continue;
                    }
                    if (bl2) continue;
                    objectOutput.writeBoolean(false);
                }
            }
            if (this.m_FieldsNames != null) {
                objectOutput.writeInt(this.m_FieldsNames.length);
                for (n2 = 0; n2 < this.m_FieldsNames.length; ++n2) {
                    objectOutput.writeUTF(this.m_FieldsNames[n2]);
                }
                for (n2 = 0; n2 < this.m_FieldsNames.length; ++n2) {
                    objectOutput.writeUTF(this.m_FieldsTypes[n2]);
                }
                for (n2 = 0; n2 < this.m_FieldsNames.length; ++n2) {
                    objectOutput.writeBoolean(this.m_IndexIndicators[n2]);
                }
                objectOutput.writeShort(this._objectFormat);
                if (this._firstIndexName != null) {
                    objectOutput.writeUTF(this._firstIndexName);
                }
            }
            if (this.m_ClassName != null && this.m_SuperClasses != null) {
                objectOutput.writeInt(this.m_SuperClasses.length);
                for (n2 = 0; n2 < this.m_SuperClasses.length; ++n2) {
                    objectOutput.writeUTF(this.m_SuperClasses[n2]);
                }
            }
            if (this.m_MultipleUIDs != null && this.m_ClassName == null) {
                objectOutput.writeObject(this.m_MultipleUIDs);
            }
            if (this._logicID != -1) {
                objectOutput.writeInt(this._logicID);
            }
        }
        catch (Exception exception) {
            if (exception instanceof EntrySerializationException) {
                throw (EntrySerializationException)exception;
            }
            String string = this.m_ClassName != null ? this.m_ClassName : ".";
            throw new EntrySerializationException("Failed to serialize Entry " + string, exception);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            int n2;
            int n3;
            int n4 = objectInput.readInt();
            if ((n4 & 0x10000000) != 0) {
                this.m_EntryUID = objectInput.readUTF();
                this.m_VersionID = objectInput.readInt();
                if ((n4 & 0x20000000) != 0) {
                    this.m_TimeToLive = objectInput.readLong();
                }
            }
            if ((n4 & 0x40000000) != 0) {
                this.m_ClassName = objectInput.readUTF();
                if ((n4 & Integer.MIN_VALUE) != 0) {
                    this.m_CodeBase = objectInput.readUTF();
                }
                this.m_SuperClassesChecksum = objectInput.readInt();
                this.m_FieldsNamesChecksum = objectInput.readInt();
                this.m_FieldsTypesChecksum = objectInput.readInt();
            }
            this.m_FifoOrder = (n4 & 0x1000000) != 0;
            this.m_Transient = (n4 & 0x2000000) != 0;
            this.m_NOWriteLease = (n4 & 0x4000000) != 0;
            boolean bl2 = this._isFromClusteredProxy = (n4 & 0x40000) != 0;
            if ((n4 & 0x8000000) != 0) {
                int n5;
                n3 = objectInput.readInt();
                this.m_FieldsValues = new Object[n3];
                n2 = 0;
                boolean bl3 = false;
                if (n3 > 3 && (bl3 = objectInput.readBoolean())) {
                    n2 = objectInput.readInt();
                }
                if (bl3) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        int n6 = objectInput.readInt();
                        this.m_FieldsValues[n6] = this.readPrimitiveObject(objectInput, n6);
                    }
                } else {
                    for (n5 = 0; n5 < n3; ++n5) {
                        if (!objectInput.readBoolean()) continue;
                        this.m_FieldsValues[n5] = this.readPrimitiveObject(objectInput, n5);
                    }
                }
            }
            if ((n4 & 0x100000) != 0) {
                n3 = objectInput.readInt();
                this.m_FieldsNames = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_FieldsNames[n2] = objectInput.readUTF();
                }
                this.m_FieldsTypes = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_FieldsTypes[n2] = objectInput.readUTF();
                }
                this.m_IndexIndicators = new boolean[n3];
                for (n2 = 0; n2 < this.m_FieldsNames.length; ++n2) {
                    this.m_IndexIndicators[n2] = objectInput.readBoolean();
                }
                this._objectFormat = objectInput.readShort();
                if ((n4 & 0x10000) != 0) {
                    this._firstIndexName = objectInput.readUTF();
                }
            }
            if (this.m_ClassName != null && (n4 & 0x400000) != 0) {
                n3 = objectInput.readInt();
                this.m_SuperClasses = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.m_SuperClasses[n2] = objectInput.readUTF();
                }
            }
            boolean bl4 = this.m_Replicatable = (n4 & 0x200000) != 0;
            if ((n4 & 0x800000) != 0) {
                this.m_MultipleUIDs = (String[])objectInput.readObject();
            }
            if ((n4 & 0x20000) != 0) {
                this._logicID = objectInput.readInt();
            }
        }
        catch (Exception exception) {
            if (exception instanceof EntrySerializationException) {
                throw (EntrySerializationException)exception;
            }
            String string = this.m_ClassName != null ? this.m_ClassName : ".";
            throw new EntrySerializationException("Failed to deserialize Entry " + string, exception);
        }
    }

    public Object getFieldValue(int n2) {
        try {
            return this.m_FieldsValues[n2];
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("The field values array was not properly set");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public Object setFieldValue(int n2, Object object) {
        try {
            Object object2 = this.m_FieldsValues[n2];
            this.m_FieldsValues[n2] = object;
            return object2;
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("The field values array was not properly set");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public Entry getEntry(IJSpace iJSpace) throws UnusableEntryException {
        IDirectSpaceProxy iDirectSpaceProxy;
        if (iJSpace instanceof DCacheSpaceImpl) {
            DCacheSpaceImpl dCacheSpaceImpl = (DCacheSpaceImpl)iJSpace;
            iDirectSpaceProxy = (IDirectSpaceProxy)dCacheSpaceImpl.getLocalSpace();
        } else {
            iDirectSpaceProxy = (IDirectSpaceProxy)iJSpace;
        }
        return iDirectSpaceProxy.getEntry(this);
    }

    public ExternalEntry getExternalEntry(IJSpace iJSpace) throws UnusableEntryException {
        IDirectSpaceProxy iDirectSpaceProxy;
        if (iJSpace instanceof DCacheSpaceImpl) {
            DCacheSpaceImpl dCacheSpaceImpl = (DCacheSpaceImpl)iJSpace;
            iDirectSpaceProxy = (IDirectSpaceProxy)dCacheSpaceImpl.getLocalSpace();
        } else {
            iDirectSpaceProxy = (IDirectSpaceProxy)iJSpace;
        }
        return iDirectSpaceProxy.getExternalEntry(this);
    }

    public void fillExternalDataSourceEvent(TypeTableEntry typeTableEntry) {
        if (this.m_FieldsValues != null && this.m_FieldsValues.length > 0) {
            Object[] objectArray = new Object[this.m_FieldsValues.length];
            objectArray[typeTableEntry._firstIndexesPos] = this.m_FieldsValues[typeTableEntry._firstIndexesPos];
            this.m_FieldsValues = objectArray;
        }
        this.m_SuperClassesChecksum = typeTableEntry.m_SuperClassesChecksum;
        this.m_FieldsNamesChecksum = typeTableEntry.m_FieldsNamesChecksum;
        this.m_FieldsTypesChecksum = typeTableEntry.m_FieldsTypesChecksum;
    }
}

