/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.cli;

import com.j_spaces.kernel.PlatformVersion;
import com.j_spaces.obf.li;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class RuntimeInfo {
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");

    public static String getEnvironmentInfo() {
        Runtime runtime = Runtime.getRuntime();
        StringBuffer stringBuffer = new StringBuffer();
        String string = RuntimeInfo.getNetworkInterfaceInfo();
        stringBuffer.append("\n\n System Environment: ");
        stringBuffer.append("\n\t System:");
        stringBuffer.append("\n\t\t OS Version: " + System.getProperty("os.version"));
        stringBuffer.append("\n\t\t Architecture: " + System.getProperty("os.arch"));
        stringBuffer.append("\n\t\t OS Name: " + System.getProperty("os.name"));
        stringBuffer.append("\n\t\t Number Of Processors: " + runtime.availableProcessors());
        stringBuffer.append("\n\t J2SE Support:");
        stringBuffer.append("\n\t\t VM Vendor: " + System.getProperty("java.vm.vendor"));
        stringBuffer.append("\n\t\t Using Java Home: " + System.getProperty("java.home"));
        stringBuffer.append("\n\t\t " + System.getProperty("java.runtime.name"));
        stringBuffer.append("\n\t\t " + System.getProperty("java.vm.name"));
        stringBuffer.append(" (build " + System.getProperty("java.vm.version") + " )");
        stringBuffer.append("\n\t JVM Memory:");
        stringBuffer.append("\n\t\t Max Heap Size (KB): " + runtime.maxMemory() / 1024L);
        stringBuffer.append("\n\t\t Current Allocated Heap Size (KB): " + runtime.freeMemory() / 1024L);
        if (string != null) {
            stringBuffer.append("\n\t Network Interfaces Information:");
            stringBuffer.append(string);
        }
        stringBuffer.append("\n\t GigaSpaces Platform:");
        stringBuffer.append("\n\t\t Version: " + PlatformVersion.V_NUM);
        stringBuffer.append("\n\t\t Build: 1708");
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public static String getEnvironmentInfo(boolean bl2) {
        String string = RuntimeInfo.getEnvironmentInfo();
        if (!bl2) {
            return string;
        }
        String string2 = RuntimeInfo.getGSConfigContent();
        String string3 = RuntimeInfo.getSystemEnv();
        String string4 = RuntimeInfo.getJavaSystemProperties();
        StringBuffer stringBuffer = new StringBuffer("\n\n =========== START GIGASPACES ENVIROMENT REPORT " + new Date() + " ==========");
        stringBuffer.append(string);
        stringBuffer.append("\n\n" + string2);
        if (string3 != null) {
            stringBuffer.append("\n\n" + string3);
        }
        stringBuffer.append("\n\n" + string4);
        stringBuffer.append("\n\n ===========  END GIGASPACES ENVIROMENT REPORT =========== ");
        return stringBuffer.toString();
    }

    public static String getJavaSystemProperties() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("JVM System properties: ");
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            stringBuffer.append("\n\t\t" + (String)object + "=" + properties.getProperty((String)object));
        }
        object = System.getSecurityManager();
        if (object != null) {
            stringBuffer.append("\n\t\t Security Manager: " + object);
        }
        return stringBuffer.toString();
    }

    public static String getSystemEnv() {
        Map<String, String> map = null;
        try {
            map = System.getenv();
        }
        catch (Throwable throwable) {
            return null;
        }
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        StringBuffer stringBuffer = new StringBuffer(string + " " + string2 + " System Environment:");
        Set<String> set = map.keySet();
        Iterator<String> iterator = set.iterator();
        for (int i2 = 0; i2 < set.size(); ++i2) {
            String string3 = iterator.next();
            String string4 = map.get(string3);
            stringBuffer.append("\n\t\t" + string3 + "=" + string4);
        }
        return stringBuffer.toString();
    }

    public static String getGSConfigContent() {
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string = li.a();
        File file = null;
        file = new File(string);
        File file2 = new File(file.getPath() + File.separator + "config");
        if (file2.isDirectory() && file2.canRead()) {
            bl2 = false;
            stringBuffer.append("GigaSpaces Config directory tree structure: ");
            stringBuffer.append(file2.getAbsolutePath() + " : ");
            RuntimeInfo.a(1, file2.getPath(), stringBuffer);
        }
        if (bl2) {
            stringBuffer.append("WARNING: Config directory under [" + file.getAbsolutePath() + "] not found.");
        }
        return stringBuffer.toString();
    }

    private static void a(int n2, String string, StringBuffer stringBuffer) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isFile()) {
                String string2 = fileArray[i2].getName();
                if (!string2.endsWith(".properties") && !string2.endsWith(".xml") && !string2.endsWith(".config")) continue;
                stringBuffer.append("\n\t");
                for (int i3 = 0; i3 < n2; ++i3) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append("- " + string2);
                continue;
            }
            ++n2;
            stringBuffer.append("\n");
            for (int i4 = 0; i4 < n2; ++i4) {
                stringBuffer.append("\t");
            }
            stringBuffer.append("-/" + fileArray[i2].getName());
            RuntimeInfo.a(n2, fileArray[i2].getPath(), stringBuffer);
            --n2;
        }
    }

    public static String getNetworkInterfaceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            String string = InetAddress.getLocalHost().getHostName();
            stringBuffer.append("\n\t\t Host Name: [" + string + "] ");
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                stringBuffer.append("\n\t\t Network Interface Name: " + networkInterface.getName() + " / " + networkInterface.getDisplayName());
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    stringBuffer.append("\n\t\t IP Address: " + inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            stringBuffer.append("WARNING: Failed to get Network Interface Info. Reason: " + exception.getMessage());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(RuntimeInfo.getEnvironmentInfo(true));
    }
}

