/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.cli;

import com.j_spaces.cli.CommandException;
import com.j_spaces.cli.ICommand;
import com.j_spaces.core.Constants;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.kernel.PlatformVersion;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.obf.ba;
import com.j_spaces.obf.mn;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateSpace
implements ICommand {
    private String a;
    private String b;
    private JSpaceAttributes c;
    private static Logger d = Logger.getLogger("com.gigaspaces.admin");
    private static final String e = "h";
    private static final String f = "p";
    private static final String g = "c";
    private static final String h = "m";
    private static final String i = "port";
    private static final String j = "schema";
    private static final String k = "properties";

    public CreateSpace() {
    }

    public CreateSpace(String string, String string2) {
        this.a = string;
        this.b = string2;
    }

    public void usage(PrintWriter printWriter) {
        System.out.println("\n*****************************************************\n");
        System.out.println("Usage: createSpace [container name] [space name] <options>");
        System.out.println("options:");
        System.out.println("           -h    prints help");
        System.out.println("           -schema\t    create space using the schema template");
        System.out.println("           -properties    properties file name used to overwrite default configuration properties. ");
        System.out.println("           -c    create cluster space [URL to cluster configuration file]");
        System.out.println("           -l    lookup service hostname");
        System.out.println("           -r    RMI registry hostname");
        System.out.println("           -g    lookup groups");
        System.out.println("           -port container binding the space on this port");
        System.out.println("           -p    persistency options [SA-class] SA-url");
        System.out.println("\n* Usage example with creating Persistent space: \ncreateSpace [container name] [space name] -p com.j_spaces.sadapter.GenericJDBC.JDBCStorageAdapter c:/GigaSpaces" + PlatformVersion.V_NUM + "/GenericJDBCProperties/CloudscapeProperties" + "\n\n* Usage example with LookupService: \ncreateSpace [container name] [space name] -l lookuphost -g group1 group2" + "\n\n* Usage example with RMIRegistry: \ncreateSpace [container name] [space name] -r rmiRegistryHost ");
        System.out.println("\n* Usage example creating clustered space: \ncreateSpace [container name] [space name] -c http://webhost:8087/clusterConfigFile.xml");
        System.out.println("\n*****************************************************\n");
    }

    public void execute(Map map, PrintWriter printWriter) throws CommandException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object var10_10 = null;
        if (map.containsKey(e)) {
            this.usage(printWriter);
            return;
        }
        stringBuffer.append("\nSpace Name: " + this.b);
        stringBuffer.append("\nContainer: " + this.a);
        if (map.containsKey(j)) {
            string3 = (String)map.get(j);
            stringBuffer.append("\nSchema: true");
            stringBuffer.append("\nSchema name: " + string3);
        }
        if (map.containsKey(k)) {
            string4 = (String)map.get(k);
            stringBuffer.append("\nCustom Properties: true");
            stringBuffer.append("\nCustom Properties file name: " + string4);
        }
        if (map.containsKey(g)) {
            string2 = (String)map.get(g);
            stringBuffer.append("\nCluster: true");
            stringBuffer.append("\nCluster configuration file: " + string2);
        }
        if (map.containsKey(i)) {
            string = (String)map.get(i);
            stringBuffer.append("\nPort: " + string);
        }
        if (map.containsKey(f)) {
            object = new StringTokenizer((String)map.get(f), " ");
            try {
                string5 = ((StringTokenizer)object).nextToken();
                string6 = ((StringTokenizer)object).nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                string5 = Constants.StorageAdapter.DEFAULT_STORAGE_ADAPTER_CLASS;
                string6 = (String)map.get(f);
            }
            stringBuffer.append("\nSA class:" + string5);
            stringBuffer.append("\nSA URL:" + string6);
        }
        stringBuffer.append("\n");
        System.out.println(stringBuffer.toString());
        try {
            object = ba.a(this.a, map);
            IJSpaceContainer iJSpaceContainer = (IJSpaceContainer)SpaceFinder.find((String)object);
            if (iJSpaceContainer == null) {
                System.out.println(this.a + " container could not be found.");
                System.exit(-1);
            }
            Properties properties = null;
            if (string4 != null && (properties = ResourceLoader.findCustomPropertiesObj(string4)) != null) {
                properties.setProperty(k, string4);
            }
            if (string3 == null) {
                string3 = "default";
                System.out.println("Since schema name was not passed, the 'default' schema will be used.");
            }
            this.c = new JSpaceAttributes(string3, string2, string != null ? Integer.parseInt(string) : 0);
            if (string4 != null) {
                properties.setProperty(k, string4);
            }
            this.c.setCustomProperties(properties);
            this.c.setLoadOnStartup(true);
            this.c.setClustered(string2 != null);
            System.out.println("Start to create a space...");
            iJSpaceContainer.createSpace(this.b, this.c);
            System.out.println(" Space was created.");
        }
        catch (Exception exception) {
            throw new CommandException(CreateSpace.a(exception).toString());
        }
    }

    private static StringWriter a(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter;
    }

    public static void main(String[] stringArray) {
        mn mn2 = new mn("h,l,g,r,p,c,port,d,m,schema,properties");
        try {
            if (stringArray.length < 2) {
                CreateSpace createSpace = new CreateSpace();
                createSpace.usage(new PrintWriter(System.out));
                System.exit(1);
            } else {
                CreateSpace createSpace = new CreateSpace(stringArray[0], stringArray[1]);
                createSpace.execute(mn2.a(stringArray), new PrintWriter(System.out));
            }
        }
        catch (CommandException commandException) {
            d.log(Level.SEVERE, commandException.toString(), commandException);
        }
    }
}

