/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.Constants;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import java.io.BufferedReader;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateSpace
implements GS.OptionHandler,
Constants {
    private JSpaceAttributes a;
    private static Logger b = Logger.getLogger("com.gigaspaces.admin");
    private OptionHandler c;
    public static final String OPERATION_NAME = "create";

    public CreateSpace() {
        String[] stringArray = new String[]{"h", "help", "url", "name", "p", "persistent", "c", "cluster", "port", "schema", "properties"};
        this.c = new OptionHandler(Formatter.fromArray((String[])stringArray));
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*****************************************************\n\n");
        stringBuffer.append("Usage: space create [options]\n");
        stringBuffer.append("options:\n");
        stringBuffer.append("\t-h/-help    prints help\n");
        stringBuffer.append("\t-url    container url, mandatory option\n");
        stringBuffer.append("\t-name  space name, mandatory option\n");
        stringBuffer.append("\t-schema    create space using the schema template\n");
        stringBuffer.append("\t-properties    properties file name used to overwrite default configuration properties.\n");
        stringBuffer.append("\t-c/-cluster    create cluster space [URL to cluster configuration file]\n");
        stringBuffer.append("\t-port    container binding the space on this port\n");
        stringBuffer.append("\t-p/-persistent    persistency options [SA-class] SA-url\n");
        stringBuffer.append("\n*****************************************************\n");
        return stringBuffer.toString();
    }

    public String process(String string, BufferedReader bufferedReader) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        try {
            Object object;
            String string9;
            Map map = this.c.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            if (!map.containsKey("url")) {
                CLIUtilities.printMissingParameterMessage("url");
                return this.getUsage();
            }
            if (!map.containsKey("name")) {
                CLIUtilities.printMissingParameterMessage("name");
                return this.getUsage();
            }
            if (map.containsKey("schema")) {
                string4 = (String)map.get("schema");
                stringBuffer.append("\nSchema: true");
                stringBuffer.append("\nSchema name: " + string4);
            }
            if (map.containsKey("properties")) {
                string5 = (String)map.get("properties");
                stringBuffer.append("\nCustom Properties: true");
                stringBuffer.append("\nCustom Properties file name: " + string5);
            }
            if (map.containsKey("c") || map.containsKey("cluster")) {
                string3 = (String)map.get("c");
                if (string3 == null) {
                    string3 = (String)map.get("cluster");
                }
                stringBuffer.append("\nCluster: true");
                stringBuffer.append("\nCluster configuration file: " + string3);
            }
            if (map.containsKey("port")) {
                string2 = (String)map.get("port");
                stringBuffer.append("\nPort: " + string2);
            }
            if (map.containsKey("p") || map.containsKey("persistent")) {
                string9 = JSpaceUtilities.isEmpty((String)map.get("p"), true) ? (String)map.get("persistent") : (String)map.get("p");
                object = new StringTokenizer(string9, " ");
                try {
                    string6 = ((StringTokenizer)object).nextToken();
                    string7 = ((StringTokenizer)object).nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    string6 = Constants.StorageAdapter.DEFAULT_STORAGE_ADAPTER_CLASS;
                    string7 = string9;
                }
                stringBuffer.append("\nSA class:" + string6);
                stringBuffer.append("\nSA URL:" + string7);
            }
            stringBuffer.append("\n");
            System.out.println(stringBuffer.toString());
            string9 = (String)map.get("url");
            if (JSpaceUtilities.isEmpty(string9, true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            object = SpaceURLParser.parseURL(string9);
            string8 = (String)map.get("name");
            IJSpaceContainer iJSpaceContainer = null;
            try {
                iJSpaceContainer = (IJSpaceContainer)CLIFinder.find((SpaceURL)object, -1);
            }
            catch (Exception exception) {
                CLIUtilities.printWrongContainerURLMessage(string9);
                return "";
            }
            if (iJSpaceContainer == null) {
                CLIUtilities.printWrongContainerURLMessage(string9);
                return "";
            }
            Properties properties = null;
            if (string5 != null && (properties = ResourceLoader.findCustomPropertiesObj(string5)) != null) {
                properties.setProperty("properties", string5);
            }
            if (string4 == null) {
                string4 = "default";
                System.out.println("Since schema name was not passed, the 'default' schema will be used.");
            }
            this.a = new JSpaceAttributes(string4, string3, string2 != null ? Integer.parseInt(string2) : 0);
            if (string5 != null) {
                properties.setProperty("properties", string5);
            }
            if (string6 != null && string7 != null) {
                this.a.setStorageAdapterClass(string6);
                this.a.setStorageAdapterURL(string7);
                this.a.setPersistent(true);
            }
            this.a.setCustomProperties(properties);
            this.a.setLoadOnStartup(true);
            this.a.setClustered(string3 != null);
            System.out.println("Start to create a space...");
            iJSpaceContainer.createSpace(string8, this.a);
            System.out.println("Space <" + string8 + "> was created.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            System.out.println("Failed to create space <" + string8 + ">");
            b.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }
}

