/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.StringUtilities;

public class Base64Decoder {
    private static final int BUFFER_SIZE = 1024;
    public InputStream in = null;
    public OutputStream out = null;
    public boolean stringp = false;
    public boolean native2ascii = false;

    private final int get1(byte[] byArray, int n2) {
        return (byArray[n2] & 0x3F) << 2 | (byArray[n2 + 1] & 0x30) >>> 4;
    }

    private final int get2(byte[] byArray, int n2) {
        return (byArray[n2 + 1] & 0xF) << 4 | (byArray[n2 + 2] & 0x3C) >>> 2;
    }

    private final int get3(byte[] byArray, int n2) {
        return (byArray[n2 + 2] & 3) << 6 | byArray[n2 + 3] & 0x3F;
    }

    private final int check(int n2) {
        if (n2 >= 65 && n2 <= 90) {
            return n2 - 65;
        }
        if (n2 >= 97 && n2 <= 122) {
            return n2 - 97 + 26;
        }
        if (n2 >= 48 && n2 <= 57) {
            return n2 - 48 + 52;
        }
        switch (n2) {
            case 61: {
                return 65;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    public void process() throws IOException, Base64FormatException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4];
        int n2 = -1;
        int n3 = 0;
        block0: while ((n2 = this.in.read(byArray)) > 0) {
            int n4 = 0;
            while (n4 < n2) {
                while (n3 < 4) {
                    int n5;
                    if (n4 >= n2) continue block0;
                    if ((n5 = this.check(byArray[n4++])) < 0) continue;
                    byArray2[n3++] = (byte)n5;
                }
                if (byArray2[2] == 65) {
                    this.out.write(this.get1(byArray2, 0));
                    return;
                }
                if (byArray2[3] == 65) {
                    this.out.write(this.get1(byArray2, 0));
                    this.out.write(this.get2(byArray2, 0));
                    return;
                }
                this.out.write(this.get1(byArray2, 0));
                this.out.write(this.get2(byArray2, 0));
                this.out.write(this.get3(byArray2, 0));
                n3 = 0;
            }
        }
        if (n3 != 0) {
            throw new Base64FormatException("Invalid length.");
        }
        this.out.flush();
    }

    public String processString() throws Base64FormatException {
        if (!this.stringp) {
            throw new RuntimeException("[processString] invalid call (not a String)");
        }
        try {
            this.process();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        try {
            String string2 = ((ByteArrayOutputStream)this.out).toString("ISO-8859-1");
            string = this.native2ascii ? StringUtilities.decode(string2) : string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("[processString] Unable to convert properly char to bytes");
        }
        return string;
    }

    public Base64Decoder(String string) {
        this(string, false);
    }

    public Base64Decoder(String string, boolean bl2) {
        byte[] byArray;
        this.native2ascii = bl2;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[Constructor] Unable to convert" + "properly char to bytes");
        }
        this.stringp = true;
        this.in = new ByteArrayInputStream(byArray);
        this.out = new ByteArrayOutputStream();
    }

    public Base64Decoder(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        this.stringp = false;
    }
}

