/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLWarning;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.model.SQLWarningTableModel;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.util.BasicUtilities;

public class SQLWarningViewer
extends JDialog
implements ListSelectionListener,
ActionListener {
    public static SQLWarningTableModel mdlConnection = new SQLWarningTableModel();
    public static SQLWarningTableModel mdlStatements = new SQLWarningTableModel();
    public static SQLWarningTableModel mdlResultSet = new SQLWarningTableModel();
    private JTable tabConnection = new JTable(mdlConnection);
    private JTable tabStatements = new JTable(mdlStatements);
    private JTable tabResultSet = new JTable(mdlResultSet);
    private JTabbedPane jtpWarnings = new JTabbedPane(1);
    private JSplitPane jspRootContainer = new JSplitPane(0);
    private JTextArea txtMessageArea = new JTextArea();
    private JToolBar jtbMain = ActionToolBar.createNullInstance();
    private JButton btnClearWarnings = new JButton();
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));

    public static int showDialog(Frame frame) {
        try {
            SQLWarningViewer sQLWarningViewer = new SQLWarningViewer(frame);
            sQLWarningViewer.show();
            return 0;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "SQLWarningViewer::showDialog(Frame)");
            return -1;
        }
    }

    private SQLWarningViewer(Frame frame) {
        super(frame, BasicUtilities.getString("Warning_Viewer_Title"), false);
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "SQLWarningViewer::initUI()");
        }
    }

    private void initUI() {
        this.tabConnection.getSelectionModel().addListSelectionListener(this);
        this.tabResultSet.getSelectionModel().addListSelectionListener(this);
        this.tabStatements.getSelectionModel().addListSelectionListener(this);
        this.jtbMain.setFloatable(false);
        this.jtbMain.add(this.btnClearWarnings);
        this.btnClearWarnings.setIcon(BasicUtilities.loadToolbarIconResource("Delete"));
        this.btnClearWarnings.setToolTipText(BasicUtilities.getString("Clear_Warning_Tab_Tip"));
        this.btnClearWarnings.addActionListener(this);
        String string = BasicUtilities.getString("Connection_Warning_Tab");
        Icon icon = BasicUtilities.loadIconResource("WebComponent16");
        JScrollPane jScrollPane = new JScrollPane(this.tabConnection);
        this.jtpWarnings.addTab(string, icon, jScrollPane);
        string = BasicUtilities.getString("Statement_Warning_Tab");
        icon = BasicUtilities.loadIconResource("Query16");
        jScrollPane = new JScrollPane(this.tabStatements);
        this.jtpWarnings.addTab(string, icon, jScrollPane);
        string = BasicUtilities.getString("Resultset_Warning_Tab");
        icon = BasicUtilities.loadIconResource("Table16");
        jScrollPane = new JScrollPane(this.tabResultSet);
        this.jtpWarnings.addTab(string, icon, jScrollPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(BasicUtilities.getString("SQL_Warning_Message")), "North");
        jPanel.add((Component)new JScrollPane(this.txtMessageArea), "Center");
        this.btnOK.addActionListener(this);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.jtbMain.setOrientation(0);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(this.btnOK);
        jToolBar.setFloatable(false);
        this.jspRootContainer.setTopComponent(this.jtpWarnings);
        this.jspRootContainer.setBottomComponent(jPanel);
        Container container = this.getContentPane();
        container.add((Component)this.jtbMain, "North");
        container.add((Component)this.jspRootContainer, "Center");
        container.add((Component)jToolBar, "South");
        this.pack();
        this.setSize(512, 420);
        this.jspRootContainer.setDividerLocation(0.5);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void addConnectionWarnings(SQLWarning sQLWarning) {
        mdlConnection.setData(sQLWarning, true);
    }

    public static void setConnectionWarnings(SQLWarning sQLWarning) {
        mdlConnection.setData(sQLWarning, false);
    }

    public static void addStatementWarnings(SQLWarning sQLWarning) {
        mdlStatements.setData(sQLWarning, true);
    }

    public static void setStatementWarnings(SQLWarning sQLWarning) {
        mdlStatements.setData(sQLWarning, false);
    }

    public static void addResultsetWarnings(SQLWarning sQLWarning) {
        mdlResultSet.setData(sQLWarning, true);
    }

    public static void setResultsetWarnings(SQLWarning sQLWarning) {
        mdlResultSet.setData(sQLWarning, false);
    }

    public static void clearAll() {
        mdlResultSet.clear();
        mdlStatements.clear();
        mdlConnection.clear();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = this.jtpWarnings.getTitleAt(this.jtpWarnings.getSelectedIndex());
        if (string.equalsIgnoreCase(BasicUtilities.getString("Connection_Warning_Tab"))) {
            this.txtMessageArea.setText(mdlConnection.getWarningMessageForRow(listSelectionEvent.getFirstIndex()));
        } else if (string.equalsIgnoreCase(BasicUtilities.getString("Statement_Warning_Tab"))) {
            this.txtMessageArea.setText(mdlStatements.getWarningMessageForRow(listSelectionEvent.getFirstIndex()));
        } else if (string.equalsIgnoreCase(BasicUtilities.getString("Resultset_Warning_Tab"))) {
            this.txtMessageArea.setText(mdlResultSet.getWarningMessageForRow(listSelectionEvent.getFirstIndex()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object == this.btnOK) {
            this.dispose();
        }
        if ((string = this.jtpWarnings.getTitleAt(this.jtpWarnings.getSelectedIndex())).equalsIgnoreCase(BasicUtilities.getString("Connection_Warning_Tab"))) {
            mdlConnection.clear();
            this.tabConnection.repaint();
        } else if (string.equalsIgnoreCase(BasicUtilities.getString("Statement_Warning_Tab"))) {
            mdlStatements.clear();
            this.tabStatements.repaint();
        } else if (string.equalsIgnoreCase(BasicUtilities.getString("Resultset_Warning_Tab"))) {
            mdlResultSet.clear();
            this.tabResultSet.repaint();
        }
    }

    static {
        WarningListener warningListener = new WarningListener(null);
        mdlConnection.addTableModelListener(warningListener);
        mdlStatements.addTableModelListener(warningListener);
        mdlResultSet.addTableModelListener(warningListener);
    }

    public static class 1 {
    }

    private static class WarningListener
    implements TableModelListener {
        private WarningListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() != 1) {
                return;
            }
            String string = "";
            if (tableModelEvent.getSource() == mdlConnection) {
                string = BasicUtilities.getString("Connection_Warning_Tab");
            } else if (tableModelEvent.getSource() == mdlStatements) {
                string = BasicUtilities.getString("Statement_Warning_Tab");
            } else if (tableModelEvent.getSource() == mdlResultSet) {
                string = BasicUtilities.getString("Resultset_Warning_Tab");
            }
            String[] stringArray = new String[]{Integer.toString(tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1), string};
            System.out.println(BasicUtilities.getString("Warnings_Added", stringArray));
        }

        public /* synthetic */ WarningListener(1 var1_1) {
            this();
        }
    }
}

