/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.CheckListTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.IconListCellRenderer;
import org.isqlviewer.swing.OrderEditor;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.swing.WhereEditor;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.ui.TableSelector;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ColumnMetaData;

public class QueryWizard
extends WizardContainer {
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private TreeMap columnSelection = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TreeMap tableSelection = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ArrayList relationships = new ArrayList();
    private ArrayList lstEditor = new ArrayList();
    private ArrayList lstOrderings = new ArrayList();
    private int[] preparedTypes = null;
    private Object[] preparedData = null;
    private DatabaseConnection cnx = null;
    private ColumnSelectionPanel columnSelector = null;
    private TableSelectionPanel tableSelector = null;
    private WhereSelectionPanel whereSelector = null;
    private ProgressPanel metaLoadProgress = null;
    private SQLWorkBench workbench = null;
    private OrderByConfig orderbyConfig = null;
    private QueryPreview queryPreview = null;
    private Thread metaLoadThread = null;
    private final String PROP_CATALOG = "catalog";
    private final String PROP_SCHEMA = "schema";
    private final String PROP_ALIAS = "alias";
    private final String PROP_COLUMN = "column";
    private final String PROP_TYPE = "type";
    private Calendar calendar = Calendar.getInstance();
    public final String TABLE_SELECT = "TABLE_SELECT";
    public final String COLUMN_SELECT = "COLUMN_SELECT";
    public final String WHERE_SELECT = "WHERE_SELECT";
    public final String META_LOAD = "META_LOAD";
    public final String FK_SELECT = "FK_SELECT";
    public final String ORDER_BY_SELECT = "ORDER_BY_SELECT";
    public final String PREVIEW = "PREVIEW";

    public QueryWizard(Frame frame, DatabaseConnection databaseConnection, SQLWorkBench sQLWorkBench) {
        super(frame);
        this.setTitle(BasicUtilities.getString("QueryWizard_Title"));
        this.cnx = databaseConnection;
        this.workbench = sQLWorkBench;
        this.setHomeAllowable(false);
        this.configureTableSelector();
        this.pack();
        this.setSize(640, 480);
    }

    public static int showDialog(Frame frame, DatabaseConnection databaseConnection, SQLWorkBench sQLWorkBench) {
        QueryWizard queryWizard = new QueryWizard(frame, databaseConnection, sQLWorkBench);
        queryWizard.setLocationRelativeTo(frame);
        queryWizard.show();
        return 1;
    }

    public boolean isStepValid(String string) {
        if (string.equals("FK_SELECT") && this.hasAllRelationshipsDisabled()) {
            String string2 = BasicUtilities.getString("QBuild_Relations_Warning");
            int n2 = JOptionPane.showConfirmDialog(this, string2, "", 0, 2);
            return n2 == 0;
        }
        return super.isStepValid(string);
    }

    public void processStepChange(String string, boolean bl2, String string2) {
        block26: {
            if (bl2) {
                try {
                    String string3 = this.queryPreview.getSQL();
                    this.queryPreview.createBookmark();
                    if (this.preparedData != null && this.preparedTypes != null) {
                        this.sysConfig.getHistoryManager().addHistoryItem(string3, this.cnx);
                        ResultSetViewer resultSetViewer = this.workbench.createResultSetDelegate();
                        this.cnx.executePreparedRequest(string3, this.preparedData, this.preparedTypes, resultSetViewer);
                        break block26;
                    }
                    this.workbench.performQuery(string3, true);
                }
                catch (Throwable throwable) {
                    String string4 = "QueryWizard.processStepChange(String,boolean)";
                    BasicUtilities.HandleException(throwable, string4, this.cnx.getDebugOn());
                }
            } else if (string.equals("COLUMN_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Table24"));
                this.setBanner(BasicUtilities.getString("QBuild_Column_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Column_Select_Comment"));
                this.columnSelector.refreshList();
            } else if (string.equals("PREVIEW")) {
                this.setIcon(BasicUtilities.loadIconResource("Query24"));
                this.setBanner(BasicUtilities.getString("QBuild_Preview_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Preview_Comment"));
                this.queryPreview.update();
            } else if (string.equals("WHERE_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Query24"));
                this.setBanner(BasicUtilities.getString("QBuild_Where_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Where_Select_Comment"));
                this.whereSelector.refreshMap();
            } else if (string.equals("ORDER_BY_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Query24"));
                this.setBanner(BasicUtilities.getString("QBuild_OrderBy_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_OrderBy_Select_Comment"));
                this.orderbyConfig.refreshMap();
            } else if (string.equals("FK_SELECT")) {
                if (this.getTrueTableSelectionCount() < 2) {
                    if (string2.equals("COLUMN_SELECT")) {
                        this.showStep("WHERE_SELECT");
                    } else if (string2.equals("WHERE_SELECT")) {
                        this.showStep("COLUMN_SELECT");
                    }
                } else {
                    this.setIcon(BasicUtilities.loadIconResource("Query24"));
                    this.setBanner(BasicUtilities.getString("QBuild_FK_Banner"));
                    this.setComment(BasicUtilities.getString("QBuild_FK_Comment"));
                }
            } else if (string.equals("TABLE_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Table24"));
                this.setBanner(BasicUtilities.getString("QBuild_Table_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Table_Select_Comment"));
                this.setNextStepEnabled(!this.tableSelection.isEmpty());
            } else if (string.equals("META_LOAD")) {
                if (string2.equals("TABLE_SELECT")) {
                    if (this.metaLoadThread != null && this.metaLoadThread.isAlive()) {
                        this.metaLoadThread.interrupt();
                    }
                    this.metaLoadThread = new Thread(new MetaLoader(null));
                    this.metaLoadThread.start();
                    this.setNextStepEnabled(false);
                    this.setPreviousStepEnabled(false);
                    this.setIcon(BasicUtilities.loadIconResource("Table24"));
                    this.setBanner(BasicUtilities.getString("QBuild_Metaload_Banner"));
                    this.setComment(BasicUtilities.getString("QBuild_Metaload_Comment"));
                } else {
                    this.showStep("TABLE_SELECT");
                }
            }
        }
    }

    public boolean isTableSelected(String string, String string2, String string3, String string4) {
        String string5 = null;
        string5 = string != null && string.trim().length() >= 1 ? string.concat(".") : new String("");
        if (string2 != null && string2.trim().length() >= 1) {
            string5 = string5.concat(string2).concat(".");
        }
        if (this.tableSelection.containsKey(string5 = string5.concat(string4))) {
            SelectionItem selectionItem = (SelectionItem)this.tableSelection.get(string5);
            Collection collection = selectionItem.getSubSelection();
            return collection.contains(string3);
        }
        return false;
    }

    public boolean hasAllRelationshipsDisabled() {
        Iterator iterator = this.relationships.iterator();
        while (iterator.hasNext()) {
            SelectionItem selectionItem = (SelectionItem)iterator.next();
            if (!selectionItem.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public int getTableSelectionCount() {
        int n2 = 0;
        Iterator iterator = this.tableSelection.values().iterator();
        while (iterator.hasNext()) {
            SelectionItem selectionItem = (SelectionItem)iterator.next();
            if (selectionItem.isEmpty()) continue;
            n2 += selectionItem.getSubSelection().size();
        }
        return n2;
    }

    public int getTrueTableSelectionCount() {
        int n2 = 0;
        Iterator iterator = this.columnSelection.values().iterator();
        while (iterator.hasNext()) {
            SelectionItem selectionItem = (SelectionItem)iterator.next();
            if (selectionItem.isEmpty()) continue;
            ++n2;
        }
        return n2;
    }

    public int getColumnSelectionCount() {
        int n2 = 0;
        Iterator iterator = this.columnSelection.values().iterator();
        while (iterator.hasNext()) {
            SelectionItem selectionItem = (SelectionItem)iterator.next();
            if (selectionItem.isEmpty()) continue;
            n2 += selectionItem.getSubSelection().size();
        }
        return n2;
    }

    public String generateSelectClause() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("SELECT\n");
        int n2 = this.getTrueTableSelectionCount();
        boolean bl2 = n2 >= 27;
        Iterator iterator = this.columnSelection.keySet().iterator();
        int n3 = 0;
        char c2 = 'a';
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            SelectionItem selectionItem = (SelectionItem)this.columnSelection.get(string);
            Collection collection = selectionItem.getSubSelection();
            if (collection == null || collection.isEmpty()) {
                selectionItem.setEnabled(false);
                continue;
            }
            selectionItem.setEnabled(true);
            Iterator iterator2 = collection.iterator();
            if (n2 >= 2) {
                char c3 = c2;
                c2 = (char)(c2 + 1);
                selectionItem.setProperty("alias", c3 + (bl2 ? Integer.toString(n3++) : ""));
            } else {
                selectionItem.setProperty("alias", "");
            }
            StringBuffer stringBuffer2 = new StringBuffer("");
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                SelectClause selectClause = new SelectClause(string2);
                String string3 = selectClause.getSQL(selectionItem.getProperty("alias"));
                if (stringBuffer2.length() + (string3.length() + 2) > 80) {
                    stringBuffer.append(stringBuffer2.toString());
                    stringBuffer.append("\n");
                    stringBuffer2.setLength(0);
                }
                stringBuffer2.append(" ");
                stringBuffer2.append(string3);
                if (!iterator2.hasNext() && !iterator.hasNext()) continue;
                stringBuffer2.append(",");
            }
            if (stringBuffer2.length() >= 1) {
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2.setLength(0);
            }
            if (iterator.hasNext()) {
                stringBuffer.append("\n");
            }
            ++n3;
        }
        string = stringBuffer.toString().trim();
        if (string.endsWith(",")) {
            stringBuffer.deleteCharAt(string.lastIndexOf(44));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateFromClause(boolean bl2) {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("FROM\n");
        Iterator iterator = this.columnSelection.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            string = (String)iterator.next();
            SelectionItem selectionItem = (SelectionItem)this.columnSelection.get(string);
            if (!selectionItem.isEnabled()) continue;
            String string2 = selectionItem.getProperty("schema");
            String string3 = selectionItem.getProperty("catalog");
            ResultSet resultSet = null;
            try {
                object = new String[]{selectionItem.getProperty("type").trim()};
                resultSet = this.cnx.getDatabaseInformation().getTables(string3, string2, string, (String[])object);
                if (resultSet.next()) {
                    string3 = resultSet.getString("TABLE_CAT");
                    string2 = resultSet.getString("TABLE_SCHEM");
                }
            }
            catch (Throwable throwable) {
                if (this.cnx.getVerboseOn()) {
                    BasicUtilities.HandleException(throwable, "generateFromClause(" + bl2 + ")", this.cnx.getDebugOn());
                }
                string2 = selectionItem.getProperty("schema");
                string3 = selectionItem.getProperty("catalog");
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            object = new FromClause(this.cnx, string2, string3, string);
            ((FromClause)object).setAlias(selectionItem.getProperty("alias"));
            stringBuffer.append("  ");
            stringBuffer.append(((FromClause)object).getSQL(bl2));
            if (iterator.hasNext()) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        string = stringBuffer.toString().trim();
        if (string.endsWith(",")) {
            stringBuffer.deleteCharAt(string.lastIndexOf(44));
        }
        return stringBuffer.toString().trim();
    }

    public String generateWhereClause() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = this.relationships.iterator();
        StringBuffer stringBuffer2 = new StringBuffer("   (");
        boolean bl2 = false;
        while (iterator.hasNext()) {
            SelectionItem selectionItem = (SelectionItem)iterator.next();
            if (!selectionItem.isEnabled()) continue;
            SelectionItem selectionItem2 = (SelectionItem)selectionItem.subSelections.get(0);
            SelectionItem selectionItem3 = (SelectionItem)this.columnSelection.get(selectionItem2.getSelectionName());
            SelectionItem selectionItem4 = (SelectionItem)this.columnSelection.get(selectionItem.getSelectionName());
            if (!selectionItem3.isEnabled() || !selectionItem4.isEnabled()) continue;
            String string = selectionItem3.getProperty("alias");
            String string2 = selectionItem4.getProperty("alias");
            stringBuffer2.append(string2);
            stringBuffer2.append(".");
            stringBuffer2.append(selectionItem2.getProperty("column"));
            stringBuffer2.append(" = ");
            stringBuffer2.append(string);
            stringBuffer2.append(".");
            stringBuffer2.append(selectionItem2.getProperty("column"));
            bl2 = true;
            if (!iterator.hasNext()) continue;
            stringBuffer2.append(" AND ");
        }
        stringBuffer2.append(")");
        if (stringBuffer2.toString().trim().length() >= 3) {
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append("\n");
        }
        stringBuffer2.setLength(0);
        if (this.whereSelector.isSelectionEnabled()) {
            stringBuffer2.append(this.generateUserWhereClause());
            if (stringBuffer2.toString().trim().length() >= 1) {
                if (bl2) {
                    stringBuffer.append(" AND\n   (");
                }
                stringBuffer.append(stringBuffer2.toString());
                if (bl2) {
                    stringBuffer.append("   )\n");
                }
            }
        }
        if (stringBuffer.toString().trim().length() >= 1) {
            stringBuffer.insert(0, "WHERE\n");
        }
        return stringBuffer.toString().trim();
    }

    public String generateUserWhereClause() throws ParseException {
        Object object;
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = this.lstEditor.iterator();
        StringBuffer stringBuffer2 = new StringBuffer("");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (iterator.hasNext()) {
            object3 = (WhereEditor)iterator.next();
            object2 = ((WhereEditor)object3).getSelectedColumn();
            if (object2 == null) continue;
            SelectionItem selectionItem = (SelectionItem)this.columnSelection.get(((ColumnMetaData)object2).getTable());
            object = selectionItem.getProperty("alias");
            int n2 = ((WhereEditor)object3).getSelectedStyle();
            Object[] objectArray = null;
            try {
                objectArray = ((WhereEditor)object3).getUserOptions();
            }
            catch (Throwable throwable) {
                continue;
            }
            String string = null;
            string = object != null && ((String)object).trim().length() >= 1 ? ((String)object).concat(".").concat(((ColumnMetaData)object2).getName()) : ((ColumnMetaData)object2).getName();
            switch (n2) {
                case 5: {
                    string = string.concat(" NOT");
                }
                case 4: {
                    string = string.concat(" LIKE '%");
                    string = string.concat((String)objectArray[0]);
                    string = string.concat("%' ");
                    break;
                }
                case 10: {
                    string = string.concat(" LIKE '%");
                    string = string.concat((String)objectArray[0]);
                    string = string.concat("' ");
                    break;
                }
                case 11: {
                    string = string.concat(" LIKE '");
                    string = string.concat((String)objectArray[0]);
                    string = string.concat("%' ");
                    break;
                }
                case 0: {
                    string = string.concat(" = ?");
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(objectArray[0], ((ColumnMetaData)object2).getType(), null));
                    break;
                }
                case 1: {
                    string = string.concat(" <> ?");
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(objectArray[0], ((ColumnMetaData)object2).getType(), null));
                    break;
                }
                case 7: {
                    string = string.concat(" NOT");
                }
                case 6: {
                    string = string.concat(" BETWEEN ? AND ?");
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(objectArray[0], ((ColumnMetaData)object2).getType(), null));
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(objectArray[1], ((ColumnMetaData)object2).getType(), null));
                    break;
                }
                case 9: {
                    string = string.concat(" NOT");
                }
                case 8: {
                    string = string.concat(" BETWEEN ? AND ?");
                    Date date = new Date();
                    this.calendar.setTime(date);
                    int n3 = ((Number)objectArray[0]).intValue();
                    String string2 = (String)objectArray[1];
                    switch (Integer.parseInt(string2)) {
                        case 0: {
                            this.calendar.roll(11, -1 * n3);
                            break;
                        }
                        case 1: {
                            this.calendar.roll(6, -1 * n3);
                            break;
                        }
                        case 2: {
                            this.calendar.roll(3, -1 * n3);
                            break;
                        }
                        case 3: {
                            this.calendar.roll(2, -1 * n3);
                            break;
                        }
                        case 4: {
                            this.calendar.roll(1, -1 * n3);
                            break;
                        }
                    }
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(this.calendar.getTime(), ((ColumnMetaData)object2).getType(), null));
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(date, ((ColumnMetaData)object2).getType(), null));
                    break;
                }
                case 2: {
                    string = string.concat(" > ?");
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(objectArray[0], ((ColumnMetaData)object2).getType(), null));
                    break;
                }
                case 3: {
                    string = string.concat(" < ?");
                    arrayList.add(new Integer(((ColumnMetaData)object2).getType()));
                    arrayList2.add(JDBCUtilities.convertValue(objectArray[0], ((ColumnMetaData)object2).getType(), null));
                    break;
                }
            }
            if (iterator.hasNext()) {
                string = this.whereSelector.allRequired() ? string.concat("\n  AND\n   ") : string.concat("\n  OR\n   ");
            }
            if (stringBuffer2.length() + (string.length() + 2) > 80) {
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2.setLength(0);
            }
            stringBuffer.append(string);
        }
        if (!arrayList2.isEmpty()) {
            this.preparedData = new Object[arrayList2.size()];
            this.preparedTypes = new int[arrayList.size()];
            object3 = arrayList2.iterator();
            object2 = arrayList.iterator();
            int n4 = 0;
            while (object3.hasNext() && object2.hasNext()) {
                object = (Integer)object2.next();
                Object e2 = object3.next();
                this.preparedData[n4] = e2;
                this.preparedTypes[n4] = (Integer)object;
                ++n4;
            }
        } else {
            this.preparedData = null;
            this.preparedTypes = null;
        }
        return stringBuffer.toString().trim();
    }

    public String generateOrderByClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = this.lstOrderings.iterator();
        StringBuffer stringBuffer2 = new StringBuffer("");
        while (iterator.hasNext()) {
            OrderEditor orderEditor = (OrderEditor)iterator.next();
            ColumnMetaData columnMetaData = orderEditor.getSelectedColumn();
            if (columnMetaData == null) continue;
            SelectionItem selectionItem = (SelectionItem)this.columnSelection.get(columnMetaData.getTable());
            String string = selectionItem.getProperty("alias");
            int n2 = orderEditor.getSelectedStyle();
            String string2 = null;
            string2 = string != null && string.trim().length() >= 1 ? string.concat(".").concat(columnMetaData.getName()) : columnMetaData.getName();
            switch (n2) {
                case 1: {
                    string2 = string2.concat(" DESC");
                    break;
                }
                default: {
                    string2 = string2.concat(" ASC");
                }
            }
            if (stringBuffer2.length() + (string2.length() + 2) > 80) {
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("\n ");
                stringBuffer2.setLength(0);
            }
            stringBuffer2.append(" ");
            stringBuffer2.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuffer2.append(",");
        }
        if (stringBuffer2.toString().trim().length() >= 1) {
            stringBuffer.append(stringBuffer2);
        }
        if (stringBuffer.toString().trim().length() >= 1) {
            stringBuffer.insert(0, "ORDER BY\n ");
        }
        return stringBuffer.toString().trim();
    }

    public String generateSQL() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.generateSelectClause());
        stringBuffer.append("\n");
        stringBuffer.append(this.generateFromClause(true));
        stringBuffer.append("\n");
        stringBuffer.append(this.generateWhereClause());
        if (this.orderbyConfig.isSelectionEnabled()) {
            stringBuffer.append("\n");
            stringBuffer.append(this.generateOrderByClause());
        }
        return stringBuffer.toString().trim();
    }

    public void configureTableSelector() {
        this.columnSelector = new ColumnSelectionPanel();
        this.tableSelector = new TableSelectionPanel();
        this.whereSelector = new WhereSelectionPanel();
        this.metaLoadProgress = new ProgressPanel();
        this.orderbyConfig = new OrderByConfig();
        this.queryPreview = new QueryPreview();
        this.addUserComponent("TABLE_SELECT", this.tableSelector);
        this.addUserComponent("META_LOAD", this.metaLoadProgress);
        this.addUserComponent("COLUMN_SELECT", this.columnSelector);
        this.addUserComponent("WHERE_SELECT", this.whereSelector);
        this.addUserComponent("ORDER_BY_SELECT", this.orderbyConfig);
        this.addUserComponent("PREVIEW", this.queryPreview);
        this.startWizard();
    }

    public static class 1 {
    }

    private class SelectClause {
        private String name = null;
        private String alias = null;

        public SelectClause(String string) {
            this.name = string;
        }

        public String getSQL(String string) {
            String string2 = null;
            string2 = string != null && string.length() >= 1 ? string.concat(".").concat(this.name) : this.name;
            if (this.alias != null && this.alias.length() >= 1) {
                string2 = string2.concat(" AS ").concat(this.alias);
            }
            return string2;
        }

        public void setAlias(String string) {
            this.alias = string;
        }
    }

    private class MetaLoader
    implements Runnable {
        private MetaLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PrintStream printStream = QueryWizard.this.metaLoadProgress.getOutStream();
            DatabaseMetaData databaseMetaData = QueryWizard.this.cnx.getDatabaseInformation();
            ResultSet resultSet = null;
            Iterator iterator = QueryWizard.this.tableSelection.keySet().iterator();
            TreeMap<String, ColumnMetaData> treeMap = new TreeMap<String, ColumnMetaData>(String.CASE_INSENSITIVE_ORDER);
            boolean bl2 = QueryWizard.this.getTableSelectionCount() >= 2;
            ProgressEvent progressEvent = new ProgressEvent(this, 0, QueryWizard.this.tableSelection.size());
            int n2 = 0;
            ArrayList arrayList = QueryWizard.this.relationships;
            synchronized (arrayList) {
                QueryWizard.this.relationships.clear();
            }
            int n3 = QueryWizard.this.getTableSelectionCount();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SelectionItem selectionItem = (SelectionItem)QueryWizard.this.tableSelection.get(string);
                Iterator iterator2 = selectionItem.getSubSelection().iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    String string2 = (String)iterator2.next();
                    String string3 = selectionItem.getProperty("catalog");
                    String string4 = selectionItem.getProperty("schema");
                    String[] stringArray = new String[]{string3, string4, string2};
                    try {
                        printStream.println(BasicUtilities.getString("QBuild_MetaLoad_Info", stringArray));
                        resultSet = databaseMetaData.getColumns(string3, string4, string2, "%");
                        while (resultSet.next()) {
                            ColumnMetaData columnMetaData = new ColumnMetaData();
                            columnMetaData.setTable(string2);
                            columnMetaData.setCatalog(resultSet.getString("TABLE_CAT"));
                            columnMetaData.setSchema(resultSet.getString("TABLE_SCHEM"));
                            columnMetaData.setName(resultSet.getString("COLUMN_NAME"));
                            columnMetaData.setPrecision(resultSet.getInt("COLUMN_SIZE"));
                            columnMetaData.setType(resultSet.getInt("DATA_TYPE"));
                            columnMetaData.setNullable("yes".equalsIgnoreCase(resultSet.getString("IS_NULLABLE")));
                            if (n3 == 1) {
                                treeMap.put(columnMetaData.getName(), columnMetaData);
                            } else {
                                treeMap.put(string2.concat(".").concat(columnMetaData.getName()), columnMetaData);
                            }
                            progressEvent.setNote(columnMetaData.getName());
                            QueryWizard.this.metaLoadProgress.progressUpdated(progressEvent);
                        }
                    }
                    catch (Throwable throwable) {
                        if (QueryWizard.this.cnx.getVerboseOn()) {
                            object = QueryWizard.this.metaLoadProgress.getErrStream();
                            BasicUtilities.HandleException(throwable, null, QueryWizard.this.cnx.getDebugOn(), (PrintStream)object);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (bl2) {
                        Object object2;
                        int n4 = 0;
                        try {
                            object = selectionItem.getSelectionName();
                            resultSet = databaseMetaData.getImportedKeys(string3, string4, string2);
                            printStream.println(BasicUtilities.getString("QBuild_MetaLoad_FK_Info", stringArray));
                            while (resultSet.next()) {
                                object2 = resultSet.getString("PKTABLE_CAT");
                                String string5 = resultSet.getString("PKTABLE_SCHEM");
                                String string6 = resultSet.getString("PKCOLUMN_NAME");
                                String string7 = resultSet.getString("PKTABLE_NAME");
                                if (!QueryWizard.this.isTableSelected((String)object2, string5, string7, (String)object)) continue;
                                SelectionItem selectionItem2 = new SelectionItem(string7);
                                selectionItem2.setProperty("catalog", (String)object2);
                                selectionItem2.setProperty("schema", string5);
                                selectionItem2.setProperty("column", string6);
                                SelectionItem selectionItem3 = new SelectionItem(string2);
                                selectionItem3.setProperty("catalog", string3);
                                selectionItem3.setProperty("schema", string4);
                                selectionItem3.addSubSelection(selectionItem2);
                                ArrayList arrayList2 = QueryWizard.this.relationships;
                                synchronized (arrayList2) {
                                    QueryWizard.this.relationships.add(selectionItem3);
                                }
                                ++n4;
                                progressEvent.setNote(string7);
                                QueryWizard.this.metaLoadProgress.progressUpdated(progressEvent);
                            }
                        }
                        catch (Throwable throwable) {
                            if (QueryWizard.this.cnx.getVerboseOn()) {
                                object2 = QueryWizard.this.metaLoadProgress.getErrStream();
                                BasicUtilities.HandleException(throwable, null, QueryWizard.this.cnx.getDebugOn(), (PrintStream)object2);
                            }
                        }
                        finally {
                            printStream.println(BasicUtilities.getString("QBuild_MetaLoad_FK_Result", Integer.toString(n4)));
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }
                    progressEvent.setProgress(++n2);
                    QueryWizard.this.metaLoadProgress.progressUpdated(progressEvent);
                }
            }
            if (QueryWizard.this.relationships.size() > 0) {
                QueryWizard.this.insertStepAfter("COLUMN_SELECT", "FK_SELECT", new FKAutoJoin());
            } else {
                QueryWizard.this.removeUserComponent("FK_SELECT");
            }
            QueryWizard.this.metaLoadProgress.setCompleted();
            QueryWizard.this.setNextStepEnabled(true);
            QueryWizard.this.setPreviousStepEnabled(true);
            QueryWizard.this.whereSelector.setSelection(treeMap);
        }

        public /* synthetic */ MetaLoader(1 var2_2) {
            this();
        }
    }

    public static class FromClause {
        private String scm = null;
        private String cat = null;
        private String tab = null;
        private String alias = null;
        private DatabaseConnection connection = null;

        public FromClause(DatabaseConnection databaseConnection, String string, String string2, String string3) {
            this.connection = databaseConnection;
            this.scm = string;
            this.cat = string2;
            this.tab = string3;
        }

        public String getSQL(boolean bl2) {
            String string = ".";
            boolean bl3 = true;
            try {
                bl3 = this.connection.getDatabaseInformation().isCatalogAtStart();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                string = this.connection.getDatabaseInformation().getCatalogSeparator();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string2 = new String("");
            if (bl3) {
                if (bl2) {
                    if (this.cat != null && this.cat.trim().length() >= 1) {
                        string2 = this.cat.concat(string);
                    }
                    if (this.scm != null && this.scm.trim().length() >= 1) {
                        string2 = string2.concat(this.scm).concat(".");
                    }
                }
                string2 = string2.concat(this.tab);
                if (this.alias != null && this.alias.trim().length() >= 1) {
                    string2 = string2.concat(" ");
                    string2 = string2.concat(this.alias);
                }
            } else {
                if (bl2 && this.scm != null && this.scm.trim().length() >= 1) {
                    string2 = string2.concat(this.scm).concat(".");
                }
                string2 = string2.concat(this.tab);
                if (bl2 && this.cat != null && this.cat.trim().length() >= 1) {
                    string2 = string2.concat(string.concat(this.cat));
                }
                if (this.alias != null && this.alias.trim().length() >= 1) {
                    string2 = string2.concat(" ");
                    string2 = string2.concat(this.alias);
                }
            }
            return string2;
        }

        public void setAlias(String string) {
            this.alias = string;
        }
    }

    private class SelectionItem {
        private String selection = null;
        private ArrayList subSelections = null;
        private TreeMap properties = null;
        private boolean enabled = true;

        public SelectionItem(String string) {
            this.selection = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String string, String string2) {
            if (this.properties == null && string2 != null) {
                this.properties = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            if (this.properties == null) {
                return;
            }
            TreeMap treeMap = this.properties;
            synchronized (treeMap) {
                if (string2 == null) {
                    if (this.properties.containsKey(string)) {
                        this.properties.remove(string);
                    }
                } else {
                    this.properties.put(string, string2);
                }
            }
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        }

        public String getProperty(String string) {
            if (this.properties == null) {
                return null;
            }
            return (String)this.properties.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubSelection(Object object) {
            if (this.subSelections == null) {
                this.subSelections = new ArrayList(1);
            }
            ArrayList arrayList = this.subSelections;
            synchronized (arrayList) {
                this.subSelections.add(object);
            }
        }

        public String getSelectionName() {
            return this.selection;
        }

        public boolean contains(Object object) {
            if (this.subSelections == null) {
                return false;
            }
            return this.subSelections.contains(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSubSelection(String string) {
            if (this.subSelections == null) {
                return;
            }
            ArrayList arrayList = this.subSelections;
            synchronized (arrayList) {
                this.subSelections.remove(string);
            }
        }

        public boolean isEmpty() {
            if (this.subSelections == null) {
                return true;
            }
            return this.subSelections.isEmpty();
        }

        public Collection getSubSelection() {
            if (this.subSelections != null) {
                return (Collection)this.subSelections.clone();
            }
            return null;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl2) {
            this.enabled = bl2;
        }
    }

    private class TableSelectionPanel
    extends JPanel
    implements ListSelectionListener,
    ChangeListener,
    TableModelListener {
        private DefaultListModel mdlTypeSelection = new DefaultListModel();
        private CheckListTableModel mdlTableSelection = new CheckListTableModel();
        private JTable tabTableSelection = new JTable(this.mdlTableSelection);
        private JList lstTypeSelection = new JList(this.mdlTypeSelection);
        private TableSelector tabSelector = new TableSelector(QueryWizard.access$200(QueryWizard.this).getDatabaseInformation(), false);
        private JSplitPane jsp = new JSplitPane(1);
        private int maxTables = 0;

        public TableSelectionPanel() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "QueryWizard.TableSelectionPanel::initUI()");
            }
            try {
                this.maxTables = QueryWizard.this.cnx.getDatabaseInformation().getMaxTablesInSelect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.maxTables == 0) {
                this.maxTables = Integer.MAX_VALUE;
            }
        }

        private void initUI() {
            this.tabSelector.addChangeListener(this);
            this.jsp.setLeftComponent(new JScrollPane(this.lstTypeSelection));
            this.jsp.setRightComponent(new JScrollPane(this.tabTableSelection));
            this.setLayout(new BorderLayout());
            this.add((Component)this.tabSelector, "North");
            this.add((Component)this.jsp, "Center");
            IconListCellRenderer iconListCellRenderer = new IconListCellRenderer(BasicUtilities.loadIconResource("Query16"));
            this.tabTableSelection.getTableHeader().setReorderingAllowed(false);
            this.mdlTableSelection.setSelectableTitle(BasicUtilities.getString("Select_Tables"));
            this.mdlTableSelection.addTableModelListener(this);
            this.lstTypeSelection.setCellRenderer(iconListCellRenderer);
            this.lstTypeSelection.addListSelectionListener(this);
            this.tabSelector.setSelectedCatalog(QueryWizard.this.cnx.getCatalog());
            this.tabSelector.setSelectedSchema(QueryWizard.this.cnx.getSchema());
            this.refreshList(QueryWizard.this.cnx.getCatalog(), QueryWizard.this.cnx.getSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshList(String string, String string2) {
            int n2;
            String[] stringArray = QueryWizard.this.cnx.getTableTypes();
            ResultSet resultSet = null;
            this.mdlTypeSelection.clear();
            this.mdlTableSelection.clear();
            DatabaseMetaData databaseMetaData = QueryWizard.this.cnx.getDatabaseInformation();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                try {
                    resultSet = databaseMetaData.getTables(string, string2, null, new String[]{stringArray[n2]});
                    if (!resultSet.next()) continue;
                    this.mdlTypeSelection.addElement(stringArray[n2]);
                    continue;
                }
                catch (Throwable throwable) {
                    if (QueryWizard.this.cnx.getVerboseOn()) {
                        BasicUtilities.HandleException(throwable, null, QueryWizard.this.cnx.getDebugOn());
                    }
                    return;
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                    resultSet = null;
                }
            }
            n2 = this.lstTypeSelection.getPreferredScrollableViewportSize().width;
            int n3 = this.jsp.getDividerSize() * 2 + 2;
            if (this.jsp.getDividerLocation() < n2 + n3) {
                this.jsp.setDividerLocation(n2 + n3);
            }
            try {
                if (this.mdlTypeSelection.size() >= 1) {
                    this.lstTypeSelection.setSelectedIndex(0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            QueryWizard.this.setNextStepEnabled(!QueryWizard.this.tableSelection.isEmpty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            String string = (String)this.lstTypeSelection.getSelectedValue();
            if (string == null) {
                return;
            }
            String string2 = this.tabSelector.getSelectedCatalog();
            String string3 = this.tabSelector.getSelectedSchema();
            ResultSet resultSet = null;
            Object[] objectArray = null;
            try {
                object = QueryWizard.this.cnx.getDatabaseInformation();
                resultSet = object.getTables(string2, string3, null, new String[]{string.trim()});
                objectArray = JDBCUtilities.getSingleColumn(resultSet, "TABLE_NAME", null);
            }
            catch (Throwable throwable) {
                if (QueryWizard.this.cnx.getVerboseOn()) {
                    BasicUtilities.HandleException(throwable, "TableSelectionPanel::valueChanged()", QueryWizard.this.cnx.getDebugOn());
                }
                return;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
                resultSet = null;
            }
            this.mdlTableSelection.setSelectableData(Arrays.asList(objectArray));
            object = null;
            object = string2 != null && string2.trim().length() >= 1 ? string2.concat(".") : new String("");
            if (string3 != null && string3.trim().length() >= 1) {
                object = ((String)object).concat(string3).concat(".");
            }
            object = ((String)object).concat(string);
            SelectionItem selectionItem = (SelectionItem)QueryWizard.this.tableSelection.get(object);
            if (selectionItem != null && !selectionItem.isEmpty()) {
                this.mdlTableSelection.setItemsAsSelected(selectionItem.getSubSelection());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.refreshList(this.tabSelector.getSelectedCatalog(), this.tabSelector.getSelectedSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n2 = tableModelEvent.getFirstRow();
            int n3 = tableModelEvent.getColumn();
            if (n2 < 0 || n2 >= this.mdlTableSelection.getRowCount()) {
                return;
            }
            if (n3 < 0 || n3 >= this.mdlTableSelection.getColumnCount()) {
                return;
            }
            if (tableModelEvent.getType() == 0) {
                Object object;
                Object object2;
                Boolean bl2 = (Boolean)this.mdlTableSelection.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                String string = (String)this.mdlTableSelection.getValueAt(tableModelEvent.getFirstRow(), 0);
                String string2 = (String)this.lstTypeSelection.getSelectedValue();
                String string3 = this.tabSelector.getSelectedCatalog();
                String string4 = this.tabSelector.getSelectedSchema();
                String string5 = null;
                string5 = string3 != null && string3.trim().length() >= 1 ? string3.concat(".") : new String("");
                if (string4 != null && string4.trim().length() >= 1) {
                    string5 = string5.concat(string4).concat(".");
                }
                string5 = string5.concat(string2);
                if (!QueryWizard.this.tableSelection.containsKey(string5)) {
                    object2 = QueryWizard.this.tableSelection;
                    synchronized (object2) {
                        object = new SelectionItem(string2);
                        ((SelectionItem)object).setProperty("catalog", this.tabSelector.getSelectedCatalog());
                        ((SelectionItem)object).setProperty("schema", this.tabSelector.getSelectedSchema());
                        QueryWizard.this.tableSelection.put(string5, object);
                    }
                }
                object2 = (SelectionItem)QueryWizard.this.tableSelection.get(string5);
                if (bl2.booleanValue()) {
                    ((SelectionItem)object2).addSubSelection(string);
                } else {
                    ((SelectionItem)object2).removeSubSelection(string);
                    if (((SelectionItem)object2).isEmpty()) {
                        object = QueryWizard.this.tableSelection;
                        synchronized (object) {
                            QueryWizard.this.tableSelection.remove(string5);
                        }
                    }
                }
                int n4 = QueryWizard.this.getTableSelectionCount();
                QueryWizard.this.setNextStepEnabled(n4 >= 1 && n4 <= this.maxTables);
            }
        }
    }

    private class WhereSelectionPanel
    extends JPanel
    implements ActionListener {
        private JPanel pnlEditor;
        private JCheckBox chkEnable;
        private JComboBox jcbBool;
        private TreeMap metaMap;

        public WhereSelectionPanel() {
            super(new GridBagLayout());
            this.pnlEditor = new JPanel(new GridBagLayout());
            this.chkEnable = new JCheckBox();
            this.jcbBool = new JComboBox<String>(new String[]{BasicUtilities.getString("QBuild_All"), BasicUtilities.getString("QBuild_Any")});
            this.metaMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "QueryWizard.TableSelectionPanel::initUI()");
            }
        }

        public boolean allRequired() {
            return this.jcbBool.getSelectedIndex() == 0;
        }

        public boolean isSelectionEnabled() {
            return this.chkEnable.isSelected();
        }

        public void refreshMap() {
            int n2 = QueryWizard.this.getTrueTableSelectionCount();
            TreeMap<String, ColumnMetaData> treeMap = new TreeMap<String, ColumnMetaData>(String.CASE_INSENSITIVE_ORDER);
            Iterator iterator = this.metaMap.values().iterator();
            while (iterator.hasNext()) {
                ColumnMetaData columnMetaData = (ColumnMetaData)iterator.next();
                String string = columnMetaData.getTable();
                if (n2 == 1) {
                    SelectionItem selectionItem = (SelectionItem)QueryWizard.this.columnSelection.get(string);
                    if (selectionItem.isEmpty()) continue;
                    treeMap.put(columnMetaData.getName(), columnMetaData);
                } else {
                    treeMap.put(string.concat(".").concat(columnMetaData.getName()), columnMetaData);
                }
                iterator.remove();
            }
            this.setSelection(treeMap);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof WhereEditor) {
                WhereEditor whereEditor = (WhereEditor)object;
                switch (actionEvent.getID()) {
                    case 0: {
                        this.addWhereEditor(QueryWizard.this.lstEditor.indexOf(whereEditor));
                        break;
                    }
                    case 1: {
                        this.removeWhereEditor(whereEditor);
                    }
                }
                return;
            }
            if (object == this.chkEnable) {
                int n2 = QueryWizard.this.lstEditor.size();
                Iterator iterator = QueryWizard.this.lstEditor.iterator();
                this.jcbBool.setEnabled(this.chkEnable.isSelected());
                while (iterator.hasNext()) {
                    WhereEditor whereEditor = (WhereEditor)iterator.next();
                    whereEditor.setEnabled(this.chkEnable.isSelected());
                    if (!this.chkEnable.isSelected()) continue;
                    whereEditor.setDeleteEnabled(n2 >= 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelection(Map map) {
            Object object = this.metaMap;
            synchronized (object) {
                this.metaMap.clear();
                this.metaMap.putAll(map);
            }
            object = QueryWizard.this.lstEditor.iterator();
            while (object.hasNext()) {
                WhereEditor whereEditor = (WhereEditor)object.next();
                whereEditor.updateMetamap(map);
            }
        }

        private void initUI() {
            String string = BasicUtilities.getString("QBuild_Match_Conditions", "@");
            int n2 = string.indexOf(64);
            this.chkEnable.setText(string.substring(0, n2));
            this.chkEnable.setToolTipText(BasicUtilities.getString("QBuild_Match_Conditions_Tip"));
            this.pnlEditor.setBorder(BorderFactory.createBevelBorder(1));
            WizardContainer.constrain(1, 0, 3, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            JScrollPane jScrollPane = new JScrollPane(this.pnlEditor);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 1);
            this.add((Component)this.chkEnable, WizardContainer.UI_CONSTRAINT);
            JLabel jLabel = new JLabel(string.substring(n2 + 1));
            WizardContainer.constrain(2, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jcbBool, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 1);
            this.add((Component)jLabel, WizardContainer.UI_CONSTRAINT);
            this.jcbBool.setVisible(false);
            WizardContainer.constrain(1, 2, 3, 1, 1.0, 1.0, 17, 1);
            this.add((Component)jScrollPane, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 3, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            this.addWhereEditor(0);
            this.chkEnable.doClick();
            this.chkEnable.addActionListener(this);
        }

        private void addWhereEditor(int n2) {
            WhereEditor whereEditor = new WhereEditor(this.metaMap);
            whereEditor.addActionListener(this);
            int n3 = QueryWizard.this.lstEditor.size();
            if (++n2 > n3 || n3 < 0) {
                QueryWizard.this.lstEditor.add(whereEditor);
            } else {
                QueryWizard.this.lstEditor.add(n2, whereEditor);
            }
            this.pnlEditor.removeAll();
            n3 = QueryWizard.this.lstEditor.size();
            Iterator iterator = QueryWizard.this.lstEditor.iterator();
            WizardContainer.constrain(0, 0, 1, 1, 1.0, 0.0, 17, 2);
            while (iterator.hasNext()) {
                WhereEditor whereEditor2 = (WhereEditor)iterator.next();
                whereEditor2.setDeleteEnabled(n3 >= 2);
                this.jcbBool.setVisible(n3 >= 2);
                this.pnlEditor.add((Component)whereEditor2, WizardContainer.UI_CONSTRAINT);
                ++WizardContainer.UI_CONSTRAINT.gridy;
            }
            WizardContainer.UI_CONSTRAINT.fill = 3;
            WizardContainer.UI_CONSTRAINT.weighty = 1.0;
            this.pnlEditor.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            this.pnlEditor.invalidate();
            this.validateTree();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeWhereEditor(WhereEditor whereEditor) {
            Serializable serializable = QueryWizard.this.lstEditor;
            synchronized (serializable) {
                QueryWizard.this.lstEditor.remove(whereEditor);
                QueryWizard.this.lstEditor.trimToSize();
            }
            this.pnlEditor.remove(whereEditor);
            if (QueryWizard.this.lstEditor.size() == 1) {
                serializable = (WhereEditor)QueryWizard.this.lstEditor.get(0);
                ((WhereEditor)serializable).setDeleteEnabled(false);
            }
            this.jcbBool.setVisible(QueryWizard.this.lstEditor.size() >= 2);
            this.pnlEditor.invalidate();
            this.validateTree();
        }
    }

    private class OrderByConfig
    extends JPanel
    implements ActionListener {
        private JPanel pnlEditor;
        private JCheckBox chkEnable;
        private TreeMap metaMap;
        private int maxOrderings;

        public OrderByConfig() {
            super(new GridBagLayout());
            this.pnlEditor = new JPanel(new GridBagLayout());
            this.chkEnable = new JCheckBox();
            this.metaMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.maxOrderings = 0;
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "QueryWizard.TableSelectionPanel::initUI()");
            }
            try {
                this.maxOrderings = QueryWizard.this.cnx.getDatabaseInformation().getMaxColumnsInOrderBy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.maxOrderings == 0) {
                this.maxOrderings = Integer.MAX_VALUE;
            }
        }

        public boolean isSelectionEnabled() {
            return this.chkEnable.isSelected();
        }

        public void refreshMap() {
            Iterator iterator = QueryWizard.this.columnSelection.keySet().iterator();
            int n2 = QueryWizard.this.getTrueTableSelectionCount();
            int n3 = QueryWizard.this.getTableSelectionCount();
            TreeMap<String, ColumnMetaData> treeMap = new TreeMap<String, ColumnMetaData>(String.CASE_INSENSITIVE_ORDER);
            boolean bl2 = false;
            try {
                bl2 = QueryWizard.this.cnx.getDatabaseInformation().supportsOrderByUnrelated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl2) {
                this.setSelection(QueryWizard.this.whereSelector.metaMap);
            } else {
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    SelectionItem selectionItem = (SelectionItem)QueryWizard.this.columnSelection.get(string);
                    Collection collection = selectionItem.getSubSelection();
                    if (collection == null || collection.isEmpty()) {
                        selectionItem.setEnabled(false);
                        continue;
                    }
                    Iterator iterator2 = collection.iterator();
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        String string3 = null;
                        string3 = n3 >= 2 ? string.concat(".").concat(string2) : string2;
                        ColumnMetaData columnMetaData = (ColumnMetaData)QueryWizard.this.whereSelector.metaMap.get(string3);
                        string3 = n2 >= 2 ? string.concat(".").concat(string2) : string2;
                        treeMap.put(string3, columnMetaData);
                    }
                }
                this.setSelection(treeMap);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof OrderEditor) {
                OrderEditor orderEditor = (OrderEditor)object;
                switch (actionEvent.getID()) {
                    case 0: {
                        this.addOrderEditor(QueryWizard.this.lstEditor.indexOf(orderEditor));
                        break;
                    }
                    case 1: {
                        this.removeOrderEditor(orderEditor);
                    }
                }
                return;
            }
            if (object == this.chkEnable) {
                int n2 = QueryWizard.this.lstEditor.size();
                Iterator iterator = QueryWizard.this.lstOrderings.iterator();
                while (iterator.hasNext()) {
                    OrderEditor orderEditor = (OrderEditor)iterator.next();
                    orderEditor.setEnabled(this.chkEnable.isSelected());
                    if (!this.chkEnable.isSelected()) continue;
                    orderEditor.setDeleteEnabled(n2 >= 2);
                    orderEditor.setAddEnabled(n2 < Math.min(this.metaMap.size(), this.maxOrderings));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelection(Map map) {
            TreeMap treeMap = this.metaMap;
            synchronized (treeMap) {
                this.metaMap.clear();
                this.metaMap.putAll(map);
            }
            int n2 = QueryWizard.this.lstOrderings.size();
            Iterator iterator = QueryWizard.this.lstOrderings.iterator();
            while (iterator.hasNext()) {
                OrderEditor orderEditor = (OrderEditor)iterator.next();
                orderEditor.updateMetamap(map);
                orderEditor.setDeleteEnabled(n2 >= 2);
                orderEditor.setAddEnabled(n2 < Math.min(this.metaMap.size(), this.maxOrderings));
            }
        }

        private void initUI() {
            this.chkEnable.setText(BasicUtilities.getString("QBuild_OrderBy_Enable"));
            this.chkEnable.setToolTipText(BasicUtilities.getString("QBuild_OrderBy_Enable_Tip"));
            this.pnlEditor.setBorder(BorderFactory.createBevelBorder(1));
            WizardContainer.constrain(1, 0, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            JScrollPane jScrollPane = new JScrollPane(this.pnlEditor);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 1);
            this.add((Component)this.chkEnable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 2, 1, 1.0, 1.0, 17, 1);
            this.add((Component)jScrollPane, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            this.addOrderEditor(0);
            this.chkEnable.addActionListener(this);
            this.chkEnable.doClick();
        }

        private void addOrderEditor(int n2) {
            OrderEditor orderEditor = new OrderEditor(this.metaMap);
            orderEditor.addActionListener(this);
            int n3 = QueryWizard.this.lstOrderings.size();
            if (++n2 > n3 || n3 < 0) {
                QueryWizard.this.lstOrderings.add(orderEditor);
            } else {
                QueryWizard.this.lstOrderings.add(n2, orderEditor);
            }
            this.pnlEditor.removeAll();
            n3 = QueryWizard.this.lstOrderings.size();
            Iterator iterator = QueryWizard.this.lstOrderings.iterator();
            WizardContainer.constrain(0, 0, 1, 1, 1.0, 0.0, 17, 2);
            while (iterator.hasNext()) {
                OrderEditor orderEditor2 = (OrderEditor)iterator.next();
                orderEditor2.setDeleteEnabled(n3 >= 2);
                orderEditor2.setAddEnabled(n3 < Math.min(this.metaMap.size(), this.maxOrderings));
                this.pnlEditor.add((Component)orderEditor2, WizardContainer.UI_CONSTRAINT);
                ++WizardContainer.UI_CONSTRAINT.gridy;
            }
            WizardContainer.UI_CONSTRAINT.fill = 3;
            WizardContainer.UI_CONSTRAINT.weighty = 1.0;
            this.pnlEditor.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            this.pnlEditor.invalidate();
            this.validateTree();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOrderEditor(OrderEditor orderEditor) {
            ArrayList arrayList = QueryWizard.this.lstOrderings;
            synchronized (arrayList) {
                QueryWizard.this.lstOrderings.remove(orderEditor);
                QueryWizard.this.lstOrderings.trimToSize();
            }
            this.pnlEditor.remove(orderEditor);
            int n2 = QueryWizard.this.lstOrderings.size();
            if (QueryWizard.this.lstEditor.size() == 1) {
                OrderEditor orderEditor2 = (OrderEditor)QueryWizard.this.lstOrderings.get(0);
                orderEditor2.setDeleteEnabled(false);
                orderEditor2.setAddEnabled(n2 < Math.min(this.metaMap.size(), this.maxOrderings));
            }
            this.pnlEditor.invalidate();
            this.validateTree();
        }
    }

    private class FKAutoJoin
    extends JPanel
    implements ActionListener,
    TableModelListener {
        private JCheckBox chkEnable;
        private CheckListTableModel mdlKeys;
        private JTable tabKeys;

        public FKAutoJoin() {
            super(new GridBagLayout());
            this.chkEnable = new JCheckBox("", true);
            this.mdlKeys = new CheckListTableModel();
            this.tabKeys = new JTable(this.mdlKeys);
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "QueryWizard.FKAutoJoin::initUI()");
            }
            Iterator iterator = QueryWizard.this.relationships.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                SelectionItem selectionItem = (SelectionItem)iterator.next();
                SelectionItem selectionItem2 = (SelectionItem)selectionItem.subSelections.get(0);
                String[] stringArray = new String[]{selectionItem.getSelectionName(), selectionItem2.getSelectionName(), selectionItem2.getProperty("column")};
                String string = BasicUtilities.getString("QBuild_Relationship_Template", stringArray);
                arrayList.add(string);
            }
            this.mdlKeys.setSelectableData(arrayList);
            this.mdlKeys.setAllSelected(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tabKeys.setEnabled(!this.chkEnable.isSelected());
            if (this.chkEnable.isSelected()) {
                this.mdlKeys.setAllSelected(true);
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n2 = tableModelEvent.getFirstRow();
            int n3 = tableModelEvent.getColumn();
            if (n2 < 0 || n2 >= this.mdlKeys.getRowCount()) {
                return;
            }
            if (n3 < 0 || n3 >= this.mdlKeys.getColumnCount()) {
                return;
            }
            if (tableModelEvent.getType() == 0) {
                Boolean bl2 = (Boolean)this.mdlKeys.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                SelectionItem selectionItem = (SelectionItem)QueryWizard.this.relationships.get(tableModelEvent.getFirstRow());
                selectionItem.setEnabled(bl2);
            }
        }

        private void initUI() {
            this.mdlKeys.setSelectableTitle(BasicUtilities.getString("QBuild_Relationships"));
            this.mdlKeys.addTableModelListener(this);
            this.chkEnable.setText(BasicUtilities.getString("QBuild_Relations_Enable_All"));
            this.chkEnable.setToolTipText(BasicUtilities.getString("QBuild_Relations_Enable_All_Tip"));
            this.chkEnable.addActionListener(this);
            this.tabKeys.setEnabled(false);
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            JScrollPane jScrollPane = new JScrollPane(this.tabKeys);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkEnable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 1.0, 1.0, 17, 1);
            this.add((Component)jScrollPane, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            BasicUtilities.optimizeTableView(this.tabKeys);
        }
    }

    private class ColumnSelectionPanel
    extends JPanel
    implements ListSelectionListener,
    TableModelListener {
        private DefaultListModel mdlTableSelection = new DefaultListModel();
        private CheckListTableModel mdlColumnSelection = new CheckListTableModel();
        private JTable tabColumnSelection = new JTable(this.mdlColumnSelection);
        private JList lstTableSelection = new JList(this.mdlTableSelection);
        private JSplitPane jsp = new JSplitPane(1);
        private int maxColumns = 0;

        public ColumnSelectionPanel() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.maxColumns = QueryWizard.this.cnx.getDatabaseInformation().getMaxColumnsInSelect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.maxColumns == 0) {
                this.maxColumns = Integer.MAX_VALUE;
            }
        }

        private void initUI() {
            this.jsp.setLeftComponent(new JScrollPane(this.lstTableSelection));
            this.jsp.setRightComponent(new JScrollPane(this.tabColumnSelection));
            this.setLayout(new BorderLayout());
            this.add((Component)this.jsp, "Center");
            IconListCellRenderer iconListCellRenderer = new IconListCellRenderer(BasicUtilities.loadIconResource("Table16"));
            this.mdlColumnSelection.setSelectableTitle(BasicUtilities.getString("Select_Columns"));
            this.tabColumnSelection.getTableHeader().setReorderingAllowed(false);
            this.lstTableSelection.setCellRenderer(iconListCellRenderer);
            this.lstTableSelection.addListSelectionListener(this);
            this.mdlColumnSelection.addTableModelListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshList() {
            Iterator iterator = QueryWizard.this.tableSelection.values().iterator();
            this.mdlTableSelection.clear();
            while (iterator.hasNext()) {
                SelectionItem selectionItem = (SelectionItem)iterator.next();
                if (selectionItem.isEmpty()) continue;
                Iterator iterator2 = selectionItem.getSubSelection().iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    if (!QueryWizard.this.columnSelection.containsKey(string)) {
                        TreeMap treeMap = QueryWizard.this.columnSelection;
                        synchronized (treeMap) {
                            SelectionItem selectionItem2 = new SelectionItem(string);
                            selectionItem2.setProperty("catalog", selectionItem.getProperty("catalog"));
                            selectionItem2.setProperty("schema", selectionItem.getProperty("schema"));
                            selectionItem2.setProperty("type", selectionItem.getSelectionName());
                            QueryWizard.this.columnSelection.put(string, selectionItem2);
                        }
                    }
                    this.mdlTableSelection.addElement(string);
                }
            }
            if (this.mdlTableSelection.size() >= 1) {
                this.lstTableSelection.setSelectedIndex(0);
            }
            QueryWizard.this.setNextStepEnabled(QueryWizard.this.getTrueTableSelectionCount() >= 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            String string = (String)this.lstTableSelection.getSelectedValue();
            if (string == null) {
                return;
            }
            ResultSet resultSet = null;
            try {
                DatabaseMetaData databaseMetaData = QueryWizard.this.cnx.getDatabaseInformation();
                SelectionItem selectionItem = (SelectionItem)QueryWizard.this.columnSelection.get(string);
                String string2 = selectionItem.getProperty("catalog");
                String string3 = selectionItem.getProperty("schema");
                resultSet = databaseMetaData.getColumns(string2, string3, string, null);
                Object[] objectArray = JDBCUtilities.getSingleColumn(resultSet, "COLUMN_NAME", null);
                this.mdlColumnSelection.setSelectableData(Arrays.asList(objectArray));
                if (selectionItem != null && !selectionItem.isEmpty()) {
                    this.mdlColumnSelection.setItemsAsSelected(selectionItem.getSubSelection());
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ColumnSelectionPanel::valueChanged()");
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n2;
            int n3 = tableModelEvent.getFirstRow();
            int n4 = tableModelEvent.getColumn();
            if (n3 < 0 || n3 >= this.mdlColumnSelection.getRowCount()) {
                return;
            }
            if (n4 < 0 || n4 >= this.mdlColumnSelection.getColumnCount()) {
                return;
            }
            if (tableModelEvent.getType() == 0) {
                Boolean bl2 = (Boolean)this.mdlColumnSelection.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                String string = (String)this.mdlColumnSelection.getValueAt(tableModelEvent.getFirstRow(), 0);
                String string2 = (String)this.lstTableSelection.getSelectedValue();
                SelectionItem selectionItem = (SelectionItem)QueryWizard.this.columnSelection.get(string2);
                if (bl2.booleanValue()) {
                    selectionItem.addSubSelection(string);
                } else {
                    selectionItem.removeSubSelection(string);
                }
            }
            QueryWizard.this.setNextStepEnabled((n2 = QueryWizard.this.getColumnSelectionCount()) >= 1 && n2 <= this.maxColumns);
        }
    }

    private class QueryPreview
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private JCheckBox chkCreateBm = new JCheckBox();
        private JCheckBox chkAllowEdit = new JCheckBox();
        private JTextField txtBookmark = new JTextField(12);
        private SQLEditor txtEditor = new SQLEditor(null);

        public QueryPreview() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String getSQL() {
            return this.txtEditor.getText();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.chkCreateBm) {
                this.txtBookmark.setEnabled(this.chkCreateBm.isSelected());
                if (this.chkCreateBm.isSelected()) {
                    QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
                } else {
                    QueryWizard.this.setNextStepEnabled(true);
                }
            } else {
                String string;
                String string2 = BasicUtilities.getString("QBuild_PreEdit_Warning");
                int n2 = JOptionPane.showConfirmDialog(this, string2, string = BasicUtilities.getString("Warning"), 0);
                if (n2 == 0) {
                    this.txtEditor.setEditable(true);
                    QueryWizard.this.setPreviousStepEnabled(false);
                    this.chkAllowEdit.setEnabled(false);
                } else {
                    this.chkAllowEdit.setEnabled(true);
                    this.chkAllowEdit.setSelected(false);
                }
            }
        }

        public void createBookmark() {
            if (this.chkCreateBm.isSelected() && this.txtBookmark.getText().trim().length() >= 1) {
                SQLBookmark sQLBookmark = new SQLBookmark(this.txtBookmark.getText().trim());
                sQLBookmark.setSQL(this.txtEditor.getText());
                sQLBookmark.setPath("/");
                SystemConfig.getInstance().getBookmarks().addBookmark(sQLBookmark);
            }
        }

        public void update() {
            try {
                this.txtEditor.setText(QueryWizard.this.generateSQL());
                this.txtEditor.setCaretPosition(0);
                this.txtEditor.validate();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "QueryWizard::generateSQL()");
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            this.txtEditor.setEditable(false);
            this.chkCreateBm.setText(BasicUtilities.getString("QBuild_CreateBookmark"));
            this.chkCreateBm.setToolTipText(BasicUtilities.getString("QBuild_CreateBookmark_Tip"));
            this.chkCreateBm.addActionListener(this);
            this.chkCreateBm.setSelected(false);
            this.chkAllowEdit.setText(BasicUtilities.getString("QBuild_PreEdit_Query"));
            this.chkAllowEdit.setToolTipText(BasicUtilities.getString("QBuild_PreEdit_Query_Tip"));
            this.chkAllowEdit.addActionListener(this);
            this.txtBookmark.getDocument().addDocumentListener(this);
            this.txtBookmark.setEnabled(this.chkCreateBm.isSelected());
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 6, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 1, 2, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkCreateBm, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 2, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.txtBookmark, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 4, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkAllowEdit, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 5, 2, 1, 1.0, 1.0, 17, 1);
            this.add((Component)this.txtEditor, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 6, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 0, 1, 6, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.chkCreateBm.isSelected()) {
                QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
            } else {
                QueryWizard.this.setNextStepEnabled(true);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.chkCreateBm.isSelected()) {
                QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
            } else {
                QueryWizard.this.setNextStepEnabled(true);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.chkCreateBm.isSelected()) {
                QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
            } else {
                QueryWizard.this.setNextStepEnabled(true);
            }
        }
    }
}

