/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.BatchRunner;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.ProgressListCellRenderer;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public final class BatchWizard
extends WizardContainer {
    private static final String STEP_SELECTION = "SELECT";
    private static final String STEP_CONFIGURE = "CONFIG";
    private static final String STEP_PREVIEWER = "PREVIEW";
    private static final String STEP_PROGRESS = "PROGRESS";
    private final ThreadGroup batch_procs = new ThreadGroup("SQL_BATCH_THREADS");
    private SystemConfig config = SystemConfig.getInstance();
    private ServiceProvider serviceProvider = this.config.getServiceProvider();
    private GridBagLayout gbl = new GridBagLayout();
    private PreferencesBatch prefs;
    private Selection selection;
    private Preview preview;
    private Progress progress;
    private BatchModel batchTableModel = new BatchModel();
    private ArrayList batchRunners = new ArrayList();
    private ArrayList services = new ArrayList();

    public static final int showDialog(JFrame jFrame) {
        BatchWizard batchWizard = new BatchWizard(jFrame);
        batchWizard.show();
        return 0;
    }

    public BatchWizard(JFrame jFrame) {
        super(jFrame);
        this.setTitle(BasicUtilities.getString("Batch_Runner_Title", ""));
        this.setComment("");
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "BatchWizard::InitUI()");
        }
        this.pack();
        this.setSize(new Dimension(524, 480));
        this.setLocationRelativeTo(jFrame);
    }

    public void initUI() {
        this.selection = new Selection();
        this.addUserComponent(STEP_SELECTION, this.selection);
        this.prefs = new PreferencesBatch();
        this.addUserComponent(STEP_CONFIGURE, this.prefs);
        this.preview = new Preview();
        this.addUserComponent(STEP_PREVIEWER, this.preview);
        this.progress = new Progress();
        this.addUserComponent(STEP_PROGRESS, this.progress);
        this.setBanner(BasicUtilities.getString("Batch_Home_Label"));
        this.setComment(BasicUtilities.getString("Batch_Home_Comment"));
        this.setIcon(BasicUtilities.loadIconResource("Script24"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBatch() {
        ArrayList arrayList = this.batchRunners;
        synchronized (arrayList) {
            this.batchRunners.clear();
        }
        this.setNextStepEnabled(false);
        for (int i2 = 0; i2 < this.batchTableModel.getRowCount(); ++i2) {
            try {
                File file = (File)this.batchTableModel.getValueAt(i2, 0);
                BatchRunner batchRunner = new BatchRunner(file, null);
                ArrayList arrayList2 = this.batchRunners;
                synchronized (arrayList2) {
                    this.batchRunners.add(batchRunner);
                    String string = this.batchTableModel.getValueAt(i2, 1).toString();
                    this.services.add(this.serviceProvider.serviceForName(string));
                }
                this.preview.mPreviewModel.setValueAt(new Integer(batchRunner.getStatements().size()), i2, 1);
                continue;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "initAllBatchThreads(" + i2 + ")");
                this.preview.mPreviewModel.setValueAt(new Integer(0), i2, 1);
            }
        }
        this.setNextStepEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() {
        this.setNextStepEnabled(false);
        this.setPreviousStepEnabled(false);
        this.setHomeAllowable(false);
        this.progress.mProgressModel.addTableModelListener(this.progress);
        ArrayList arrayList = this.batchRunners;
        synchronized (arrayList) {
            for (int i2 = 0; i2 < this.batchRunners.size(); ++i2) {
                BatchRunner batchRunner = (BatchRunner)this.batchRunners.get(i2);
                if (batchRunner == null) continue;
                BatchRunner batchRunner2 = batchRunner;
                synchronized (batchRunner2) {
                    try {
                        ServiceDefinition serviceDefinition = (ServiceDefinition)this.services.get(i2);
                        batchRunner.setConnection(serviceDefinition.createConnection());
                        batchRunner.setBatchParams((Boolean)this.batchTableModel.getValueAt(i2, 2), (Boolean)this.batchTableModel.getValueAt(i2, 3));
                        batchRunner.setBatchListener(this.progress);
                        Thread thread = new Thread(this.batch_procs, batchRunner, batchRunner.getBatchFile().getAbsolutePath());
                        thread.start();
                    }
                    catch (Throwable throwable) {
                        BasicUtilities.HandleException(throwable, "BatchWizard::executeBatch(" + i2 + ")");
                    }
                    continue;
                }
            }
        }
        System.runFinalization();
    }

    public void haltBatch() {
        this.batch_procs.interrupt();
        Iterator iterator = this.services.iterator();
        this.progress.mProgressModel.removeTableModelListener(this.progress);
        while (iterator.hasNext()) {
            try {
                ServiceDefinition serviceDefinition = (ServiceDefinition)iterator.next();
                serviceDefinition.close();
                iterator.remove();
            }
            catch (Throwable throwable) {}
        }
        System.runFinalization();
    }

    public void processStepChange(String string, boolean bl2, String string2) {
        if (string2 != null && string2.equals(STEP_CONFIGURE)) {
            this.prefs.saveProperties();
        }
        if (string2 != null && string2.equalsIgnoreCase(STEP_PROGRESS)) {
            this.haltBatch();
        }
        if (string.equals(STEP_CONFIGURE)) {
            this.setBanner(BasicUtilities.getString("Batch_Configure_Label"));
            this.setComment(BasicUtilities.getString("Batch_Configure_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Script24"));
            this.prefs.loadProperties();
        }
        if (string.equals(STEP_SELECTION)) {
            this.setBanner(BasicUtilities.getString("Batch_Home_Label"));
            this.setComment(BasicUtilities.getString("Batch_Home_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Script24"));
        }
        if (string.equals(STEP_PREVIEWER)) {
            this.setBanner(BasicUtilities.getString("Batch_Preview_Label"));
            this.setComment(BasicUtilities.getString("Batch_Preview_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("ZoomIn24"));
            this.preview.refreshall();
        }
        if (string.equals(STEP_PROGRESS)) {
            this.setBanner(BasicUtilities.getString("Batch_Progress_Label"));
            this.setComment(BasicUtilities.getString("Batch_Progress_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Batch24"));
            this.progress.initProgressTable();
            this.executeBatch();
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        boolean bl2 = this.progress.mProgressModel.isFinished();
        if (windowEvent.getID() == 201 && !bl2 && this.getCurrentStep().equalsIgnoreCase("Progress")) {
            String string = BasicUtilities.getString("Batch_In_Progress");
            String string2 = BasicUtilities.getString("Batch_Wait_Notice");
            JOptionPane.showMessageDialog(this, string, string2, 0);
            return;
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean isStepValid(String string) {
        if (string.equals(STEP_SELECTION) && this.batchTableModel.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, BasicUtilities.getString("Batch_Selection_Missing"));
            return false;
        }
        return super.isStepValid(string);
    }

    public BatchModel creatFromFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BatchModel batchModel = new BatchModel();
        StringTokenizer stringTokenizer = new StringTokenizer("", File.pathSeparator, false, false);
        int n2 = 0;
        int n3 = 0;
        block4: while (bufferedReader.ready()) {
            stringTokenizer.setString(bufferedReader.readLine());
            batchModel.addNewRow();
            n3 = batchModel.getRowCount() - 1;
            n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string = stringTokenizer.nextToken();
                    batchModel.setValueAt(string, n3, n2++);
                }
                catch (Exception exception) {
                    continue block4;
                }
            }
        }
        try {
            stringTokenizer = null;
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return batchModel;
    }

    public static /* synthetic */ ServiceProvider access$200(BatchWizard batchWizard) {
        return batchWizard.serviceProvider;
    }

    private class ProgressModel
    extends EnhancedTableModel {
        private final String[] COLUMN_HEADERS = new String[]{BasicUtilities.getString("Batch_File"), BasicUtilities.getString("Batch_Progress")};
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$org$isqlviewer$event$ProgressEvent;

        public ProgressModel() {
            this.setColumns(this.COLUMN_HEADERS);
        }

        public boolean isFinished() {
            try {
                for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                    ProgressEvent progressEvent = (ProgressEvent)this.getValueAt(i2, 1);
                    if (progressEvent.getMaximum() == progressEvent.getProgress()) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        public Class getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    Class<?> clazz = class$java$io$File;
                    if (clazz == null) {
                        clazz = class$java$io$File = new File[0].getClass().getComponentType();
                    }
                    return clazz;
                }
                case 1: {
                    Class<?> clazz = class$org$isqlviewer$event$ProgressEvent;
                    if (clazz == null) {
                        clazz = class$org$isqlviewer$event$ProgressEvent = new ProgressEvent[0].getClass().getComponentType();
                    }
                    return clazz;
                }
            }
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            return clazz;
        }
    }

    private class BatchModel
    extends EnhancedTableModel {
        private final String[] ColumnHeaders = new String[]{BasicUtilities.getString("Batch_File"), BasicUtilities.getString("Batch_Service"), BasicUtilities.getString("Batch_Transaction"), BasicUtilities.getString("Batch_Support")};
        private StringBuffer sb = new StringBuffer("");

        public BatchModel() {
            this.setColumns(this.ColumnHeaders);
        }

        public String toRowString(int n2) {
            int n3 = 0;
            this.sb.setLength(0);
            Object object = this.getValueAt(n2, n3++);
            this.sb.append(object == null ? "" : object.toString());
            this.sb.append(File.pathSeparatorChar);
            object = this.getValueAt(n2, n3++);
            this.sb.append(object == null ? "" : object.toString());
            this.sb.append(File.pathSeparatorChar);
            object = this.getValueAt(n2, n3++);
            this.sb.append(object == null ? "false" : object.toString());
            this.sb.append(File.pathSeparatorChar);
            object = this.getValueAt(n2, n3++);
            this.sb.append(object == null ? "false" : object.toString());
            this.sb.append(File.pathSeparatorChar);
            return this.sb.toString();
        }

        public void addNewRow() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(new File(""));
            arrayList.add("");
            arrayList.add(Boolean.FALSE);
            arrayList.add(Boolean.FALSE);
            this.addRow(arrayList);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount());
        }
    }

    private class Preview
    extends JPanel
    implements ActionListener {
        private final String[] COLUMN_HEADERS = new String[]{BasicUtilities.getString("Batch_File"), BasicUtilities.getString("Batch_Count")};
        private EnhancedTableModel mPreviewModel = new EnhancedTableModel(this.COLUMN_HEADERS);
        private ITable mPreviewList = new ITable(this.mPreviewModel);
        private JButton mRefreshAll = new JButton(BasicUtilities.loadIconResource("Refresh24"));
        private JButton mRefreshOne = new JButton(BasicUtilities.loadIconResource("Redo24"));

        public Preview() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "BatchWizard::Preview()");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(this.mRefreshAll)) {
                this.refreshall();
                return;
            }
            if (object.equals(this.mRefreshOne)) {
                this.refreshselected();
                return;
            }
        }

        private void initUI() throws Exception {
            this.setLayout(new GridBagLayout());
            ActionToolBar actionToolBar = ActionToolBar.createNullInstance();
            actionToolBar.setOrientation(0);
            actionToolBar.setFloatable(false);
            ((Container)actionToolBar).add(this.mRefreshAll);
            ((Container)actionToolBar).add(this.mRefreshOne);
            ((Container)actionToolBar).add(Box.createHorizontalGlue());
            this.mPreviewList.setSelectionMode(2);
            this.mPreviewList.setRowSelectionAllowed(true);
            this.mPreviewList.allowColumnReordering(false);
            this.mRefreshOne.addActionListener(this);
            this.mRefreshAll.addActionListener(this);
            this.mRefreshOne.setToolTipText(BasicUtilities.getString("Batch_Refresh_Selected_Tip"));
            this.mRefreshAll.setToolTipText(BasicUtilities.getString("Batch_Refresh_All_Tip"));
            WizardContainer.constrain(0, 0, 1, 2, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 1, 1, 1.0, 0.0, 10, 2);
            this.add((Component)actionToolBar, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 1.0, 1.0, 10, 1);
            this.add((Component)new JScrollPane(this.mPreviewList), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 0, 1, 2, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 1, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshselected() {
            int[] nArray = this.mPreviewList.getSelectedRows();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                try {
                    BatchRunner batchRunner;
                    int n2 = nArray[i2];
                    ArrayList arrayList = BatchWizard.this.batchRunners;
                    synchronized (arrayList) {
                        batchRunner = (BatchRunner)BatchWizard.this.batchRunners.get(n2);
                        this.mPreviewModel.setValueAt(BasicUtilities.getString("Batch_Refreshing_Data"), n2, 1);
                    }
                    this.mPreviewModel.setValueAt(new Integer(batchRunner.getStatements().size()), i2, 1);
                    continue;
                }
                catch (Throwable throwable) {
                    this.mPreviewModel.setValueAt(new Integer(-1), i2, 1);
                    BasicUtilities.HandleException(throwable, "BatchWizard::refreshSelected()");
                }
            }
            BasicUtilities.optimizeTableView(this.mPreviewList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshall() {
            Preview preview = this;
            synchronized (preview) {
                this.mPreviewModel.clear();
                for (int i2 = 0; i2 < BatchWizard.this.batchTableModel.getRowCount(); ++i2) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(BatchWizard.this.batchTableModel.getValueAt(i2, 0));
                    arrayList.add(BasicUtilities.getString("Batch_Parsing_File"));
                    this.mPreviewModel.addRow(arrayList);
                }
                BatchWizard.this.initBatch();
            }
            this.mPreviewModel.fireTableStructureChanged();
            BasicUtilities.optimizeTableView(this.mPreviewList);
        }
    }

    private class Progress
    extends JPanel
    implements ActionListener,
    ProgressListener,
    TableModelListener {
        public ProgressModel mProgressModel;
        public JButton btn;
        public JToolBar mProgressToolBox;
        public ITable mProgressTable;
        static /* synthetic */ Class class$org$isqlviewer$event$ProgressEvent;

        public Progress() {
            this.mProgressModel = new ProgressModel();
            this.btn = new JButton(BasicUtilities.loadToolbarIconResource("Stop"));
            this.mProgressToolBox = new JToolBar(0);
            this.mProgressTable = new ITable(this.mProgressModel);
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "BatchWizard::Progress()");
            }
        }

        public void progressUpdated(ProgressEvent progressEvent) {
            Object object = progressEvent.getSource();
            BatchRunner batchRunner = (BatchRunner)object;
            int n2 = BatchWizard.this.batchRunners.indexOf(batchRunner);
            this.mProgressModel.setValueAt(progressEvent, n2, 1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BatchWizard.this.haltBatch();
            this.mProgressModel.clear();
            BatchWizard.this.setNextStepEnabled(true);
            BatchWizard.this.setPreviousStepEnabled(true);
            BatchWizard.this.setHomeAllowable(true);
        }

        public void initProgressTable() {
            this.mProgressModel.setRowCount(0);
            for (int i2 = 0; i2 < BatchWizard.this.batchTableModel.getRowCount(); ++i2) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(BatchWizard.this.batchTableModel.getValueAt(i2, 0));
                arrayList.add(null);
                this.mProgressModel.addRow(arrayList);
            }
            this.mProgressModel.fireTableStructureChanged();
        }

        public void initUI() throws Exception {
            this.setLayout(new BorderLayout());
            Class<?> clazz = class$org$isqlviewer$event$ProgressEvent;
            if (clazz == null) {
                clazz = class$org$isqlviewer$event$ProgressEvent = new ProgressEvent[0].getClass().getComponentType();
            }
            this.mProgressTable.setDefaultRenderer(clazz, new ProgressListCellRenderer());
            this.btn.setToolTipText(BasicUtilities.getString("Batch_Halt_All_Batch_Jobs"));
            this.btn.addActionListener(this);
            this.mProgressToolBox.add(this.btn);
            this.mProgressToolBox.add(Box.createHorizontalGlue());
            this.mProgressToolBox.setFloatable(false);
            this.add((Component)this.mProgressToolBox, "North");
            this.add((Component)new JScrollPane(this.mProgressTable), "Center");
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            BatchWizard.this.setNextStepEnabled(this.mProgressModel.isFinished());
        }
    }

    private class Selection
    extends JPanel
    implements ListSelectionListener,
    ActionListener {
        private static final int MASK_SERVICE = 1;
        private static final int MASK_BATCH = 2;
        private static final int MASK_TRANS = 4;
        private File mCurrentScript = null;
        private ITable tabScript = new ITable();
        private JLabel lblFileNme = new JLabel(BasicUtilities.getString("Batch_Select_Batch_File"));
        private JLabel lblService = new JLabel(BasicUtilities.getString("Batch_Select_Service"));
        private JButton btnBrws = new JButton(BasicUtilities.getString("Elipsis"));
        private JButton btnOpen = new JButton(BasicUtilities.loadToolbarIconResource("Open"));
        private JButton btnSave = new JButton(BasicUtilities.loadToolbarIconResource("Save"));
        private JButton btnSvAs = new JButton(BasicUtilities.loadToolbarIconResource("SaveAs"));
        private JButton btnAdd = new JButton(BasicUtilities.loadToolbarIconResource("Add"));
        private JButton btnDel = new JButton(BasicUtilities.loadToolbarIconResource("Delete"));
        private JButton btnNew = new JButton(BasicUtilities.loadToolbarIconResource("New"));
        private JTextField txtBatchFile = new JTextField(16);
        private JCheckBox chkUseTrans = new JCheckBox();
        private JCheckBox chkOverride = new JCheckBox();
        private JComboBox cmbServices = new JComboBox<Object>(BatchWizard.access$200(BatchWizard.this).getRegisteredServices().toArray());

        public Selection() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "BatchWizard.Selection::()");
                return;
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl2 = this.tabScript.getSelectedRows().length == 1;
            this.txtBatchFile.setEnabled(bl2);
            this.btnBrws.setEnabled(bl2);
            if (bl2) {
                int n2 = this.tabScript.getSelectedRow();
                this.txtBatchFile.setText(BatchWizard.this.batchTableModel.getValueAt(n2, 0).toString());
                this.cmbServices.setSelectedItem(BatchWizard.this.batchTableModel.getValueAt(n2, 1));
                this.chkOverride.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(n2, 3));
                this.chkUseTrans.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(n2, 2));
            } else if (this.tabScript.getRowCount() >= 1) {
                int n3 = -1;
                try {
                    n3 = this.tabScript.getSelectedRows()[0];
                }
                catch (Throwable throwable) {
                    n3 = 0;
                }
                this.txtBatchFile.setText("");
                this.cmbServices.setSelectedItem(BatchWizard.this.batchTableModel.getValueAt(n3, 1));
                this.chkOverride.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(n3, 2));
                this.chkUseTrans.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(n3, 3));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl2;
            Object object = actionEvent.getSource();
            boolean bl3 = bl2 = this.tabScript.getSelectedRows().length >= 1;
            if (object == this.btnAdd || object == this.btnBrws) {
                this.browseForFile(object == this.btnAdd);
                return;
            }
            if (object == this.chkOverride && bl2) {
                this.updateServiceAssignments(2);
                return;
            }
            if (object == this.chkUseTrans && bl2) {
                this.updateServiceAssignments(4);
                return;
            }
            if (object == this.cmbServices && bl2) {
                this.updateServiceAssignments(1);
                return;
            }
            if (object == this.btnDel) {
                this.removeFileFromScript();
                return;
            }
            if (object == this.btnNew) {
                this.createNewScript();
                return;
            }
            if (object == this.btnOpen) {
                try {
                    this.openScript(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (object == this.btnSave || object == this.btnSvAs) {
                try {
                    this.saveScript(null, object == this.btnSvAs);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openScript(File file) throws IOException {
            Selection selection = this;
            synchronized (selection) {
                BatchWizard.this.batchTableModel = BatchWizard.this.creatFromFile(file);
                BatchWizard.this.setTitle(BasicUtilities.getString("Batch_Title", file.getName()));
                this.tabScript.setModel(BatchWizard.this.batchTableModel);
                BasicUtilities.optimizeTableView(this.tabScript);
            }
            System.runFinalization();
        }

        private void browseForFile(boolean bl2) {
            File file = null;
            int n2 = this.tabScript.getSelectedRow();
            if (n2 != -1) {
                file = (File)BatchWizard.this.batchTableModel.getValueAt(n2, 0);
            }
            if ((file = file != null ? BasicUtilities.getSystemFile(this, 0) : BasicUtilities.getSystemFile(this, 0)) != null) {
                if (bl2 || n2 < 0) {
                    BatchWizard.this.batchTableModel.addNewRow();
                    n2 = this.tabScript.getSelectedRow();
                    n2 = n2 < 0 && !bl2 ? 0 : BatchWizard.this.batchTableModel.getRowCount() - 1;
                    BatchWizard.this.batchTableModel.setValueAt(file, bl2 ? BatchWizard.this.batchTableModel.getRowCount() - 1 : n2, 0);
                    BatchWizard.this.batchTableModel.fireTableStructureChanged();
                    this.tabScript.getSelectionModel().setSelectionInterval(n2, n2);
                    BasicUtilities.optimizeTableView(this.tabScript);
                } else {
                    BatchWizard.this.batchTableModel.setValueAt(file, n2, 0);
                    this.tabScript.getSelectionModel().setSelectionInterval(n2, n2);
                    BasicUtilities.optimizeTableView(this.tabScript);
                }
                this.txtBatchFile.setText(file.getAbsolutePath());
            }
        }

        private void removeFileFromScript() {
            int[] nArray = this.tabScript.getSelectedRows();
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                BatchWizard.this.batchTableModel.removeRow(nArray[i2]);
            }
            if (BatchWizard.this.batchTableModel.getRowCount() >= 1) {
                try {
                    this.tabScript.setRowSelectionInterval(0, 0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            BatchWizard.this.batchTableModel.fireTableStructureChanged();
            BasicUtilities.optimizeTableView(this.tabScript);
        }

        private void createNewScript() {
            BatchWizard.this.batchTableModel.setRowCount(0);
            BatchWizard.this.batchTableModel.fireTableStructureChanged();
            BasicUtilities.optimizeTableView(this.tabScript);
            this.mCurrentScript = null;
            this.browseForFile(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveScript(File file, boolean bl2) throws IOException {
            Object object;
            if (bl2 || file == null) {
                file = BasicUtilities.saveSystemFile(this);
                if (file == null) {
                    return;
                }
                object = file.toString();
                if (!((String)object).endsWith(".script")) {
                    object = ((String)object).concat(".script");
                    file = this.mCurrentScript = new File((String)object);
                }
            }
            object = this;
            synchronized (object) {
                if (!file.exists()) {
                    file.createNewFile();
                }
                BatchWizard.this.setTitle(BasicUtilities.getString("Batch_Title", file.getName()));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                for (int i2 = 0; i2 < this.tabScript.getRowCount(); ++i2) {
                    bufferedWriter.write(BatchWizard.this.batchTableModel.toRowString(i2));
                    if (i2 == this.tabScript.getRowCount() - 1) continue;
                    bufferedWriter.newLine();
                }
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void initUI() throws Exception {
            this.setLayout(BatchWizard.this.gbl);
            this.txtBatchFile.setToolTipText(BasicUtilities.getString("Batch_Batch_Name_Tip"));
            this.chkUseTrans.setToolTipText(BasicUtilities.getString("Batch_Use_Transaction_Tip"));
            this.chkUseTrans.setText(BasicUtilities.getString("Batch_Use_Transaction_Text"));
            this.chkOverride.setToolTipText(BasicUtilities.getString("Batch_Override_Support_Tip"));
            this.chkOverride.setText(BasicUtilities.getString("Batch_Override_Support_Text"));
            this.cmbServices.setToolTipText(BasicUtilities.getString("Batch_Service_Select_Tip"));
            this.btnBrws.setToolTipText(BasicUtilities.getString("Browse_File_System"));
            this.btnSave.setToolTipText(BasicUtilities.getString("Batch_Save_Script_Tip"));
            this.btnOpen.setToolTipText(BasicUtilities.getString("Batch_Open_Script_Tip"));
            this.btnSvAs.setToolTipText(BasicUtilities.getString("Batch_Save_Script_As_Tip"));
            this.btnAdd.setToolTipText(BasicUtilities.getString("Batch_Add_Batch_Tip"));
            this.btnDel.setToolTipText(BasicUtilities.getString("Batch_Remove_Batch_Tip"));
            this.btnNew.setToolTipText(BasicUtilities.getString("Batch_New_Script_Tip"));
            this.btnSave.addActionListener(this);
            this.btnOpen.addActionListener(this);
            this.btnSvAs.addActionListener(this);
            this.btnBrws.addActionListener(this);
            this.btnAdd.addActionListener(this);
            this.btnDel.addActionListener(this);
            this.btnNew.addActionListener(this);
            this.txtBatchFile.addActionListener(this);
            this.cmbServices.addActionListener(this);
            this.chkUseTrans.addActionListener(this);
            this.chkOverride.addActionListener(this);
            ActionToolBar actionToolBar = ActionToolBar.createNullInstance();
            actionToolBar.setOrientation(0);
            actionToolBar.setFloatable(false);
            ((Container)actionToolBar).add(this.btnNew);
            ((Container)actionToolBar).add(this.btnOpen);
            ((Container)actionToolBar).add(this.btnSave);
            ((Container)actionToolBar).add(this.btnSvAs);
            actionToolBar.addSeparator();
            ((Container)actionToolBar).add(this.btnAdd);
            ((Container)actionToolBar).add(this.btnDel);
            JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 2));
            jPanel.setBorder(new TitledBorder(BasicUtilities.getString("Batch_Options_Title")));
            jPanel.add(this.chkUseTrans);
            jPanel.add(this.chkOverride);
            JScrollPane jScrollPane = new JScrollPane(this.tabScript);
            this.tabScript.setModel(BatchWizard.this.batchTableModel);
            this.tabScript.allowColumnReordering(false);
            this.tabScript.setRowSelectionAllowed(true);
            this.tabScript.getSelectionModel().addListSelectionListener(this);
            BasicUtilities.optimizeTableView(this.tabScript);
            WizardContainer.constrain(0, 0, 1, 5, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.lblFileNme, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 0, 2, 1, 0.1, 0.0, 10, 2);
            this.add((Component)this.txtBatchFile, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(4, 0, 1, 1, 0.0, 0.0, 10, 0);
            this.add((Component)this.btnBrws, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.lblService, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 1, 2, 1, 0.0, 0.0, 10, 2);
            this.add((Component)this.cmbServices, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 2, 2, 2, 1.0, 0.0, 13, 0);
            this.add((Component)jPanel, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 2, 1, 1.0, 0.0, 16, 2);
            this.add((Component)actionToolBar, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 4, 4, 1, 1.0, 1.0, 10, 1);
            this.add((Component)jScrollPane, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(5, 0, 1, 5, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(6), WizardContainer.UI_CONSTRAINT);
        }

        private void updateServiceAssignments(int n2) {
            int n3;
            int[] nArray = this.tabScript.getSelectedRows();
            if ((n2 & 1) == 1) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    BatchWizard.this.batchTableModel.setValueAt(this.cmbServices.getSelectedItem(), nArray[n3], 1);
                }
            }
            if ((n2 & 4) == 4) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    BatchWizard.this.batchTableModel.setValueAt(new Boolean(this.chkUseTrans.isSelected()), nArray[n3], 2);
                }
            }
            if ((n2 & 2) == 2) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    BatchWizard.this.batchTableModel.setValueAt(new Boolean(this.chkOverride.isSelected()), nArray[n3], 3);
                }
            }
        }
    }

    public static class PreferencesBatch
    extends AbstractPropertyPage
    implements ActionListener {
        private ButtonGroup[] groups = new ButtonGroup[]{new ButtonGroup(), new ButtonGroup(), new ButtonGroup()};
        private JPanel mCommentOptions = new JPanel();
        private JPanel mQuoteOptions = new JPanel();
        private JPanel pnlGenOpts = new JPanel();
        private JTextField txtSeperator = new JTextField(6);
        private JTextField txtComment = new JTextField(6);
        private JTextField txtLiteral = new JTextField(6);
        private JRadioButton rdoLitNone = new JRadioButton();
        private JRadioButton rdoLitSingle = new JRadioButton();
        private JRadioButton rdoLitDouble = new JRadioButton();
        private JRadioButton rdoLitCustom = new JRadioButton();
        private JRadioButton rdoSepEOL = new JRadioButton();
        private JRadioButton rdoSepCustom = new JRadioButton();
        private JCheckBox chkForceLow = new JCheckBox();
        private JRadioButton rdoCommentC = new JRadioButton();
        private JRadioButton rdoCommentCpp = new JRadioButton();
        private JRadioButton rdoCommentSingle = new JRadioButton();
        private JRadioButton rdoCommentNone = new JRadioButton();

        public PreferencesBatch() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "PreferencesBatch::initUI()");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.txtComment.setEnabled(this.rdoCommentSingle.isSelected());
            this.txtSeperator.setEnabled(this.rdoSepCustom.isSelected());
            this.txtLiteral.setEnabled(this.rdoLitCustom.isSelected());
        }

        public void initUI() {
            this.setLayout(new GridBagLayout());
            this.rdoLitDouble.addActionListener(this);
            this.rdoLitCustom.addActionListener(this);
            this.rdoSepEOL.addActionListener(this);
            this.rdoCommentNone.addActionListener(this);
            this.rdoLitNone.addActionListener(this);
            this.rdoCommentSingle.addActionListener(this);
            this.rdoLitSingle.addActionListener(this);
            this.rdoCommentC.addActionListener(this);
            this.rdoCommentCpp.addActionListener(this);
            this.rdoSepCustom.addActionListener(this);
            this.chkForceLow.addActionListener(this);
            this.groups[0].add(this.rdoCommentC);
            this.groups[0].add(this.rdoCommentNone);
            this.groups[0].add(this.rdoCommentCpp);
            this.groups[0].add(this.rdoCommentSingle);
            this.groups[1].add(this.rdoLitNone);
            this.groups[1].add(this.rdoLitDouble);
            this.groups[1].add(this.rdoLitSingle);
            this.groups[1].add(this.rdoLitCustom);
            this.groups[2].add(this.rdoSepEOL);
            this.groups[2].add(this.rdoSepCustom);
            this.addButtonGroupProperty(this.groups[0], "batch.comment-style");
            this.addButtonGroupProperty(this.groups[1], "batch.literal-style");
            this.addButtonGroupProperty(this.groups[2], "batch.seperator-style");
            this.rdoSepCustom.setActionCommand(Integer.toString(0));
            this.rdoSepEOL.setActionCommand(Integer.toString(1));
            this.rdoCommentC.setActionCommand(Integer.toString(2));
            this.rdoCommentCpp.setActionCommand(Integer.toString(3));
            this.rdoCommentNone.setActionCommand(Integer.toString(1));
            this.rdoCommentSingle.setActionCommand(Integer.toString(0));
            this.rdoLitDouble.setActionCommand(Integer.toString(0));
            this.rdoLitSingle.setActionCommand(Integer.toString(2));
            this.rdoLitNone.setActionCommand(Integer.toString(1));
            this.rdoLitCustom.setActionCommand(Integer.toString(3));
            this.setPropertyForComponent(this.chkForceLow, "batch.lowercase-enable");
            this.setPropertyForComponent(this.txtComment, "batch.comment-char");
            this.setPropertyForComponent(this.txtSeperator, "batch.seperator-char");
            this.setPropertyForComponent(this.txtLiteral, "batch.literal-char");
            this.mCommentOptions.setLayout(new GridLayout(5, 1, 2, 2));
            this.mCommentOptions.setBorder(new TitledBorder(BasicUtilities.getString("Batch_Select_Comment_Style")));
            this.mCommentOptions.add(this.rdoCommentNone);
            this.mCommentOptions.add(this.rdoCommentC);
            this.mCommentOptions.add(this.rdoCommentCpp);
            this.mCommentOptions.add(this.rdoCommentSingle);
            this.mCommentOptions.add(this.txtComment);
            this.mQuoteOptions.setLayout(new GridLayout(5, 1, 2, 2));
            this.mQuoteOptions.setBorder(new TitledBorder(BasicUtilities.getString("Batch_Select_Quote_Style")));
            this.mQuoteOptions.add(this.rdoLitNone);
            this.mQuoteOptions.add(this.rdoLitSingle);
            this.mQuoteOptions.add(this.rdoLitDouble);
            this.mQuoteOptions.add(this.rdoLitCustom);
            this.mQuoteOptions.add(this.txtLiteral);
            this.pnlGenOpts.setLayout(new GridBagLayout());
            this.pnlGenOpts.setBorder(new TitledBorder(BasicUtilities.getString("Batch_General_Properties")));
            PreferencesBatch.constrain(0, 0, 1, 3, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 0, 2, 1, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add((Component)this.chkForceLow, UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add((Component)this.rdoSepEOL, UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 2, 2, 1, 0.0, 1.0, 17, 0);
            this.pnlGenOpts.add((Component)this.rdoSepCustom, UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 3, 1, 1, 1.0, 0.0, 17, 2);
            this.pnlGenOpts.add((Component)this.txtSeperator, UI_CONSTRAINT);
            PreferencesBatch.constrain(3, 0, 1, 3, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 0, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(6), UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 1, 2, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.pnlGenOpts, UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 2, 1, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.mCommentOptions, UI_CONSTRAINT);
            PreferencesBatch.constrain(2, 2, 1, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.mQuoteOptions, UI_CONSTRAINT);
            PreferencesBatch.constrain(3, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 3, 2, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
            this.txtSeperator.setToolTipText(BasicUtilities.getString("Batch_Custom_Char_Tip"));
            this.txtComment.setToolTipText(this.txtSeperator.getToolTipText());
            this.txtLiteral.setToolTipText(this.txtSeperator.getToolTipText());
            this.rdoLitDouble.setText(BasicUtilities.getString("Batch_Double_Quote_Text"));
            this.rdoLitDouble.setToolTipText(BasicUtilities.getString("Batch_Double_Quote_Tip"));
            this.rdoLitSingle.setText(BasicUtilities.getString("Batch_Single_Quote_Text"));
            this.rdoLitSingle.setToolTipText(BasicUtilities.getString("Batch_Single_Quote_Tip"));
            this.rdoLitCustom.setText(BasicUtilities.getString("Batch_Custom_Quote_Text"));
            this.rdoLitCustom.setToolTipText(BasicUtilities.getString("Batch_Custom_Quote_Tip"));
            this.rdoSepEOL.setText(BasicUtilities.getString("Batch_EOL_Statement_Text"));
            this.rdoSepEOL.setToolTipText(BasicUtilities.getString("Batch_EOL_Statement_Tip"));
            this.rdoSepCustom.setText(BasicUtilities.getString("Batch_Custom_Delim_Text"));
            this.rdoSepCustom.setToolTipText(BasicUtilities.getString("Batch_Custom_Delim_Tip"));
            this.rdoCommentCpp.setText(BasicUtilities.getString("Batch_Slash_Star_Text"));
            this.rdoCommentCpp.setToolTipText(BasicUtilities.getString("Batch_Slash_Star_Tip"));
            this.rdoCommentC.setText(BasicUtilities.getString("Batch_Slash_Slash_Text"));
            this.rdoCommentC.setToolTipText(BasicUtilities.getString("Batch_Slash_Slash_Tip"));
            this.rdoCommentNone.setText(BasicUtilities.getString("Batch_No_Comment_Text"));
            this.rdoCommentNone.setToolTipText(BasicUtilities.getString("Batch_No_Comment_Tip"));
            this.rdoLitNone.setText(BasicUtilities.getString("Batch_No_Quote_Text"));
            this.rdoLitNone.setToolTipText(BasicUtilities.getString("Batch_No_Quote_Tip"));
            this.rdoCommentSingle.setText(BasicUtilities.getString("Batch_Single_Line_Comment_Text"));
            this.rdoCommentSingle.setToolTipText(BasicUtilities.getString("Batch_Single_Line_Comment_Tip"));
            this.chkForceLow.setText(BasicUtilities.getString("Batch_Force_Lower_Text"));
            this.chkForceLow.setToolTipText(BasicUtilities.getString("Batch_Force_Lower_Tip"));
        }

        public String getPropertyPageName() {
            return BasicUtilities.getString("Batch_Property_Page");
        }

        public Icon getUserIcon() {
            return BasicUtilities.loadIconResource("Batch16");
        }

        public void loadProperties() {
            super.loadProperties();
            this.actionPerformed(null);
        }
    }
}

