/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.print.DefaultPaperComponent;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class JTablePaper
extends DefaultPaperComponent {
    public static final int MODE_OVERDOWN = 0;
    public static final int MODE_DOWNOVER = 1;
    private int printMode = 0;
    private PageCfg[] pageConfig = null;
    private int pageCount = 0;
    private boolean showGridlines = true;
    private JTable table = new ITable();

    public void setContent(Object object) {
        if (object instanceof JTable) {
            this.table = (JTable)object;
        } else if (object instanceof TableModel) {
            this.table = new ITable();
            this.table.setModel((TableModel)object);
        } else {
            throw new IllegalArgumentException();
        }
        this.table.setFont(this.table.getFont().deriveFont(9.0f));
        this.table.putClientProperty("isPrinting", Boolean.TRUE);
        this.pageCount = 0;
        this.mCurrentPage = 0;
        this.isValid = false;
        this.invalidate();
    }

    public void initialize(Graphics2D graphics2D) {
        this.firePropertyChange("init", false, true);
        super.initialize(graphics2D);
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            this.firePropertyChange("init", true, false);
            this.isValid = true;
            return;
        }
        try {
            int n2 = this.getHeaderHeight();
            int[] nArray = this.getRowSet(this.getContentHeight() - n2);
            int[] nArray2 = this.getColumnSet(this.getContentWidth());
            this.pageCount = nArray2.length * nArray.length;
            this.pageConfig = new PageCfg[this.pageCount];
            int n3 = 0;
            int n4 = 0;
            int n5 = this.table.getColumnCount();
            int n6 = this.table.getRowCount();
            if (this.table.getModel() instanceof EnhancedTableModel) {
                n6 = ((EnhancedTableModel)this.table.getModel()).getTrueRowCount();
            }
            Dimension dimension = this.table.getIntercellSpacing();
            this.showGridlines = dimension.height >= 2 && dimension.width >= 2;
            int n7 = 0;
            block5: for (int i2 = 0; i2 < this.pageCount; ++i2) {
                switch (this.printMode) {
                    case 1: {
                        this.pageConfig[i2] = new PageCfg(null);
                        this.pageConfig[i2].columnCount = nArray2[n7];
                        this.pageConfig[i2].columnOffset = n3;
                        this.pageConfig[i2].rowOffset = n4;
                        this.pageConfig[i2].rowCount = nArray[i2 % nArray.length];
                        this.distrbuteWidths(this.getContentWidth(), this.pageConfig[i2]);
                        n4 += this.pageConfig[i2].rowCount;
                        if (i2 % nArray.length != nArray.length - 1) continue block5;
                        n4 = 0;
                        n3 += this.pageConfig[i2].columnCount;
                        ++n7;
                        continue block5;
                    }
                    default: {
                        this.pageConfig[i2] = new PageCfg(null);
                        this.pageConfig[i2].columnCount = nArray2[i2 % nArray2.length];
                        this.pageConfig[i2].columnOffset = n3;
                        this.pageConfig[i2].rowOffset = n4;
                        this.pageConfig[i2].rowCount = nArray[i2 % nArray.length];
                        this.distrbuteWidths(this.getContentWidth(), this.pageConfig[i2]);
                        n4 += this.pageConfig[i2].rowCount;
                        if ((n3 += this.pageConfig[i2].columnCount) >= n5 || i2 % nArray2.length == nArray2.length - 1) {
                            n3 = 0;
                        }
                        if (n4 < n6 && i2 % nArray.length != nArray.length - 1) continue block5;
                        n4 = 0;
                    }
                }
            }
            this.isValid = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.isValid = true;
        this.firePropertyChange("init", true, false);
    }

    public int getPageCount() {
        return this.pageConfig != null ? this.pageConfig.length : 0;
    }

    public void configure(UserPreferences userPreferences) {
        super.configure(userPreferences);
        this.showGridlines = userPreferences.getBoolean("print.grid-enabled");
        this.printMode = userPreferences.getInt("print.table-style");
        this.isValid = false;
        this.invalidate();
    }

    public void drawPageContents(Graphics2D graphics2D, int n2) {
        int n3 = this.drawTableColumnHeaders(graphics2D, n2);
        this.drawTableContents(n3, graphics2D, n2);
        if (this.showGridlines) {
            this.drawGridLines(n3, graphics2D, n2);
        }
    }

    public String getHeaderString(int n2) {
        int n3 = this.table.getRowCount();
        if (this.table.getModel() instanceof EnhancedTableModel) {
            n3 = ((EnhancedTableModel)this.table.getModel()).getTrueRowCount();
        }
        return BasicUtilities.getString("Print_Table_Header", Integer.toString(n3));
    }

    public String getFooterString(int n2) {
        PageCfg pageCfg = this.pageConfig[n2];
        String[] stringArray = new String[]{Integer.toString(pageCfg.rowOffset + 1), Integer.toString(pageCfg.rowOffset + pageCfg.rowCount)};
        return BasicUtilities.getString("Print_Footer_Text", stringArray);
    }

    private int drawTableColumnHeaders(Graphics2D graphics2D, int n2) {
        if (this.pageConfig == null) {
            return 0;
        }
        PageCfg pageCfg = this.pageConfig[n2];
        int n3 = -1;
        int n4 = pageCfg.margin / 2;
        int n5 = 0;
        for (int i2 = 0; i2 < pageCfg.columnCount; ++i2) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(pageCfg.columnOffset + i2);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.table.getTableHeader().getDefaultRenderer();
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, n3, i2);
            Rectangle rectangle = component.getBounds();
            Dimension dimension = component.getSize();
            Dimension dimension2 = component.getPreferredSize();
            dimension2.setSize(tableColumn.getPreferredWidth(), dimension2.height);
            component.setBounds(0, 0, dimension2.width, dimension2.height);
            component.setSize(dimension2.width, dimension2.height);
            n5 = Math.max(n5, dimension2.height);
            component.validate();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n4, 0, dimension2.width, dimension2.height);
            n4 += dimension2.width;
            component.paint(graphics2D2);
            component.setBounds(rectangle);
            component.setSize(dimension);
            component.validate();
        }
        return n5;
    }

    private void drawGridLines(int n2, Graphics2D graphics2D, int n3) {
        int n4;
        PageCfg pageCfg = this.pageConfig[n3];
        graphics2D.translate(0, n2);
        if (this.useColor()) {
            graphics2D.setColor(this.table.getGridColor());
        } else {
            graphics2D.setColor(Color.darkGray);
        }
        int n5 = 0;
        int n6 = pageCfg.margin / 2;
        int n7 = 0;
        for (n7 = 1; n7 <= pageCfg.rowCount; ++n7) {
            n4 = n7 * (this.table.getRowHeight(n7) + this.table.getRowMargin());
            n5 += n4;
            graphics2D.drawLine(pageCfg.margin / 2, n4, pageCfg.realWidth, n4);
        }
        n4 = this.table.getIntercellSpacing().width;
        for (int i2 = 0; i2 < pageCfg.columnCount - 1; ++i2) {
            int n8 = pageCfg.columnOffset + i2;
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n8);
            graphics2D.drawLine((n6 += tableColumn.getPreferredWidth()) - n4 / 2, 0, n6 - n4 / 2, n5);
        }
        graphics2D.translate(0, -n2);
    }

    private void drawTableContents(int n2, Graphics2D graphics2D, int n3) {
        if (this.pageConfig == null) {
            return;
        }
        PageCfg pageCfg = this.pageConfig[n3];
        int n4 = pageCfg.margin / 2;
        int n5 = 0;
        graphics2D.translate(0, n2);
        graphics2D.setColor(Color.black);
        Dimension dimension = this.table.getIntercellSpacing();
        try {
            for (int i2 = 0; i2 < pageCfg.rowCount; ++i2) {
                for (int i3 = 0; i3 < pageCfg.columnCount; ++i3) {
                    int n6 = pageCfg.columnOffset + i3;
                    int n7 = pageCfg.rowOffset + i2;
                    if (n6 >= this.table.getColumnCount() || n7 >= this.table.getRowCount()) continue;
                    TableColumn tableColumn = this.table.getColumnModel().getColumn(n6);
                    TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n7, n6);
                    Object object = this.table.getValueAt(n7, n6);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, n7, n6);
                    Dimension dimension2 = component.getPreferredSize();
                    Rectangle rectangle = component.getBounds();
                    Dimension dimension3 = component.getSize();
                    dimension2.setSize(tableColumn.getPreferredWidth(), this.table.getRowHeight(n7));
                    component.setBounds(0, 0, dimension2.width, dimension2.height);
                    component.setSize(dimension2);
                    component.validate();
                    Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n4 + 1, n5 + 1, dimension2.width - 1, dimension2.height - 1);
                    n4 += dimension2.width + dimension.width / 2;
                    component.paint(graphics2D2);
                    component.setBounds(rectangle);
                    component.setSize(dimension3);
                    component.validate();
                }
                n4 = pageCfg.margin / 2;
                n5 += this.table.getRowHeight(pageCfg.rowOffset + i2) + dimension.height;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics2D.translate(0, -n2);
    }

    private int[] getRowSet(int n2) {
        TableModel tableModel = this.table.getModel();
        int[] nArray = new int[]{};
        int n3 = 0;
        int n4 = 0;
        int n5 = this.table.getRowMargin();
        int n6 = this.table.getRowCount();
        if (tableModel instanceof EnhancedTableModel) {
            n6 = ((EnhancedTableModel)tableModel).getTrueRowCount();
        }
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = this.table.getRowHeight(i2) + n5;
            if ((n3 += n7) > n2) {
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray2.length - 1] = n4;
                nArray = nArray2;
                n4 = 1;
                n3 = n7;
                continue;
            }
            ++n4;
        }
        if (n4 >= 1) {
            int[] nArray3 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            nArray3[nArray3.length - 1] = n4;
            nArray = nArray3;
        }
        return nArray;
    }

    private void distrbuteWidths(int n2, PageCfg pageCfg) {
        int n3;
        int n4;
        int n5 = this.table.getIntercellSpacing().width;
        int n6 = 0;
        int n7 = 0;
        int n8 = pageCfg.columnCount;
        int n9 = pageCfg.columnOffset;
        for (n4 = 0; n4 < n8; ++n4) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n9 + n4);
            n3 = tableColumn.getPreferredWidth();
            n7 = Math.max(n3, n7);
            if ((n6 += n3 + n5) <= n2) continue;
            return;
        }
        n4 = n2 - n6;
        int n10 = n4 / n8;
        n6 = 0;
        for (n3 = 0; n3 < n8; ++n3) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n9 + n3);
            int n11 = tableColumn.getPreferredWidth();
            tableColumn.setPreferredWidth(n11 + n10);
            n6 += n11 + n10;
        }
        pageCfg.margin = n4 = n2 - n6;
        pageCfg.realWidth = n6;
    }

    private int getHeaderHeight() {
        TableModel tableModel = this.table.getModel();
        int n2 = 0;
        int n3 = -1;
        for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i2);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.table.getTableHeader().getDefaultRenderer();
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, n3, i2);
            Dimension dimension = component.getPreferredSize();
            dimension.setSize(tableColumn.getPreferredWidth(), dimension.height);
            component.setBounds(0, 0, dimension.width, dimension.height);
            component.setSize(dimension.width, dimension.height);
            n2 = Math.max(n2, dimension.height);
        }
        return n2;
    }

    private int[] getColumnSet(int n2) {
        int[] nArray = new int[]{};
        int n3 = this.table.getColumnCount();
        int n4 = this.table.getIntercellSpacing().width;
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i2);
            int n7 = tableColumn.getPreferredWidth() + n4;
            if ((n5 += n7) > n2) {
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray2.length - 1] = n6;
                nArray = nArray2;
                n6 = 1;
                n5 = n7;
                continue;
            }
            ++n6;
        }
        if (n6 >= 1) {
            int[] nArray3 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            nArray3[nArray3.length - 1] = n6;
            nArray = nArray3;
        }
        return nArray;
    }

    public static class 1 {
    }

    private static class PageCfg {
        public int columnOffset = 0;
        public int columnCount = 0;
        public int rowOffset = 0;
        public int rowCount = 0;
        public int margin = 0;
        public int realWidth = 0;

        private PageCfg() {
        }

        public /* synthetic */ PageCfg(1 var1_1) {
            this();
        }
    }
}

