/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class ITableCellRenderer
extends DefaultTableCellRenderer {
    private static UserPreferences prefs = SystemConfig.getInstance().getPreferences();
    private SimpleDateFormat sdf = null;
    private Border origBorder = this.getBorder();
    private String style = null;
    private int type = -1;

    public ITableCellRenderer() {
        this(1111);
    }

    public ITableCellRenderer(int n2) {
        this.type = n2;
    }

    public void applyStyle(String string) {
        this.style = string;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
        super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
        if (object == null) {
            Border border = BorderFactory.createLineBorder(prefs.getColor("general.null-color"));
            if (bl3) {
                this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), border));
            } else {
                this.setBorder(border);
            }
        } else {
            this.setBorder(this.origBorder);
            try {
                this.format(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (n2 == jTable.getEditingRow()) {
            this.setBackground(jTable.getBackground());
        }
        return this;
    }

    public void format(Object object) {
        if (object == null) {
            this.setText(null);
            return;
        }
        this.setHorizontalAlignment(2);
        this.setIcon(null);
        switch (this.type) {
            case 93: {
                if (this.sdf == null) {
                    if (this.style == null) {
                        this.sdf = new SimpleDateFormat(prefs.get("general.timestamp-format"));
                    } else {
                        this.sdf.applyPattern(prefs.get("general.timestamp-format"));
                    }
                }
                try {
                    this.setText(this.sdf.format((Date)object));
                }
                catch (Throwable throwable) {}
                break;
            }
            case 92: {
                if (this.sdf == null) {
                    if (this.style == null) {
                        this.sdf = new SimpleDateFormat(prefs.get("general.time-format"));
                    } else {
                        this.sdf.applyPattern(prefs.get("general.time-format"));
                    }
                }
                try {
                    this.setText(this.sdf.format((Date)object));
                }
                catch (Throwable throwable) {}
                break;
            }
            case 91: {
                if (this.sdf == null) {
                    if (this.style == null) {
                        this.sdf = new SimpleDateFormat(prefs.get("general.date-format"));
                    } else {
                        this.sdf.applyPattern(prefs.get("general.date-format"));
                    }
                }
                try {
                    this.setText(this.sdf.format((Date)object));
                }
                catch (Throwable throwable) {}
                break;
            }
            case 2006: {
                try {
                    Ref ref = (Ref)object;
                    Object[] objectArray = new String[]{ref.getBaseTypeName()};
                    String string = MessageFormat.format("REF ''{0}''", objectArray);
                    this.setText(string);
                }
                catch (Throwable throwable) {}
                break;
            }
            case 2004: {
                try {
                    long l2 = ((Blob)object).length();
                    Object[] objectArray = new String[]{StringUtilities.getHumanReadableSize(l2)};
                    String string = MessageFormat.format("BLOB {0}", objectArray);
                    this.setText(string);
                }
                catch (Throwable throwable) {}
                break;
            }
            case 2005: {
                try {
                    long l3 = ((Clob)object).length();
                    Object[] objectArray = new String[]{StringUtilities.getHumanReadableSize(l3)};
                    String string = MessageFormat.format("CLOB {0}", objectArray);
                    this.setText(string);
                }
                catch (Throwable throwable) {}
                break;
            }
            default: {
                this.setText(object.toString().trim());
            }
        }
    }
}

