/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.swing.JListUISupport;
import org.isqlviewer.ui.HelpWindow;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class BookmarkEditor
extends JDialog
implements DocumentListener,
ActionListener,
ListSelectionListener {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private DefaultListModel mdlParams = new DefaultListModel();
    private DefaultComboBoxModel mdlTypes = new DefaultComboBoxModel<String>(JDBCUtilities.getSQLTypes(true));
    private JLabel lblName = new JLabel(BasicUtilities.getString("Bookmark_Name"));
    private JLabel lblSQL = new JLabel(BasicUtilities.getString("Bookmark_SQL"));
    private JLabel lblUsage = new JLabel("");
    private JLabel lblCre8d = new JLabel("");
    private JLabel lblLastU = new JLabel("");
    private JLabel lblBPath = new JLabel("");
    private DateFormat df = DateFormat.getDateTimeInstance();
    private JTextField txtName = new JTextField("", 16);
    private JTextField txtParamValue = new JTextField("", 16);
    private JTextField txtParamOptions = new JTextField("", 16);
    private JButton btnParamAdd = new JButton("+");
    private JButton btnParamHlp = new JButton(BasicUtilities.loadIconResource("Help24"));
    private JButton btnParamDel = new JButton("-");
    private JComboBox jcbTypes = new JComboBox(this.mdlTypes);
    private JList lstParams = new JList(this.mdlParams);
    private HelpWindow helpView = null;
    private SQLEditor sqlEditor = new SQLEditor();
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnCancel = new JButton(BasicUtilities.getString("Cancel"));
    private boolean isNew = false;
    private boolean changeSelection = false;
    private SQLBookmark bookmark = null;
    private BookmarkTreeModel model = null;

    public BookmarkEditor(JDialog jDialog, BookmarkTreeModel bookmarkTreeModel) {
        super((Dialog)jDialog, true);
        this.model = bookmarkTreeModel;
        this.initUI();
    }

    public BookmarkEditor(JFrame jFrame, BookmarkTreeModel bookmarkTreeModel) {
        super((Frame)jFrame, true);
        this.model = bookmarkTreeModel;
        this.initUI();
    }

    public void setBookmark(SQLBookmark sQLBookmark) {
        this.bookmark = sQLBookmark;
        this.setTitle(BasicUtilities.getString("Bookmark_Editor_Title", sQLBookmark.getName()));
        this.sqlEditor.setText(sQLBookmark.getSQL());
        this.txtName.setText(sQLBookmark.getName());
        String string = this.df.format(sQLBookmark.getCreationDate());
        this.lblCre8d.setText(BasicUtilities.getString("Bookmark_Make_Date", string));
        string = this.df.format(sQLBookmark.getLastAccessTime());
        this.lblLastU.setText(BasicUtilities.getString("Bookmark_Last_Date", string));
        this.lblUsage.setText(BasicUtilities.getString("Bookmark_Use_Count", Long.toString(sQLBookmark.getUseCount())));
        this.lblBPath.setText(BasicUtilities.getString("Bookmark_Path", sQLBookmark.getPath()));
        this.mdlParams.clear();
        Iterator iterator = sQLBookmark.parameterIterator();
        while (iterator.hasNext()) {
            this.mdlParams.addElement(iterator.next());
        }
        if (this.mdlParams.isEmpty()) {
            this.jcbTypes.setEnabled(false);
            this.txtParamOptions.setEnabled(false);
            this.txtParamValue.setEnabled(false);
        } else {
            this.lstParams.setSelectedIndex(0);
        }
    }

    public void setIsNew(boolean bl2) {
        this.isNew = bl2;
    }

    public void installEditorSupport(DatabaseConnection databaseConnection) {
        this.sqlEditor.createContextHelp(this);
        this.sqlEditor.configureWithConnection(databaseConnection);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.lstParams.getSelectedIndex() < 0) {
            this.jcbTypes.setEnabled(false);
            this.txtParamOptions.setEnabled(false);
            this.txtParamValue.setEnabled(false);
            return;
        }
        this.changeSelection = true;
        SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)this.lstParams.getSelectedValue();
        if (parameter == null) {
            this.jcbTypes.setSelectedItem(null);
            this.txtParamOptions.setText("");
            this.txtParamValue.setText("");
            return;
        }
        this.jcbTypes.setSelectedItem(JDBCUtilities.getTypeforValue(parameter.getSQLType()));
        this.txtParamOptions.setText(parameter.getOptions());
        this.txtParamValue.setText(parameter.getValue());
        this.jcbTypes.setEnabled(true);
        this.txtParamOptions.setEnabled(true);
        this.txtParamValue.setEnabled(true);
        this.changeSelection = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOK) {
            this.bookmark.setName(this.txtName.getText());
            this.bookmark.setSQL(this.sqlEditor.getText());
            this.applyParameters();
            try {
                if (this.isNew) {
                    this.model.addBookmark(this.bookmark);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.model.setModified();
            this.model.refresh(this.bookmark);
            this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (object == this.btnCancel) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (object == this.btnParamHlp) {
            if (this.helpView == null) {
                URL uRL = BasicUtilities.getResourceURL(BasicUtilities.getString("Import_Auto_Inline_Help"));
                this.helpView = HelpWindow.showHelp(this, uRL, "Bork");
                this.helpView.setDefaultCloseOperation(1);
            } else {
                this.helpView.show();
            }
        } else if (object == this.btnParamAdd) {
            this.mdlParams.addElement(new SQLBookmark.Parameter());
            this.lstParams.setSelectedIndex(this.mdlParams.getSize() - 1);
            this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        } else if (object == this.btnParamDel) {
            int n2 = this.lstParams.getSelectedIndex();
            if (n2 >= 0) {
                this.mdlParams.remove(n2);
                this.lstParams.setSelectedIndex(Math.min(this.mdlParams.getSize() - 1, n2));
                this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
            }
        } else if (object == this.jcbTypes) {
            this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
            int[] nArray = this.lstParams.getSelectedIndices();
            int n3 = JDBCUtilities.getTypeforName((String)this.mdlTypes.getSelectedItem());
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)this.mdlParams.get(nArray[i2]);
                parameter.setSQLType(n3);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)this.lstParams.getSelectedValue();
        if (parameter != null && !this.changeSelection) {
            parameter.setOptions(this.txtParamOptions.getText());
            parameter.setValue(this.txtParamValue.getText());
            this.lstParams.invalidate();
            this.lstParams.repaint();
            return;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)this.lstParams.getSelectedValue();
        if (parameter != null && !this.changeSelection) {
            parameter.setOptions(this.txtParamOptions.getText());
            parameter.setValue(this.txtParamValue.getText());
            this.lstParams.invalidate();
            this.lstParams.repaint();
            return;
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.sqlEditor.requestFocus();
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
                break;
            }
            case 201: {
                String string;
                Boolean bl2 = (Boolean)this.getRootPane().getClientProperty("windowModified");
                if (bl2 == null || !bl2.booleanValue()) break;
                String string2 = BasicUtilities.getString("Bookmark_Edit_Warning");
                int n2 = JOptionPane.showConfirmDialog(this, string2 = StringUtilities.formatBreak(80, "<html>".concat(string2), "", true), string = BasicUtilities.getString("Warning"), 0);
                if (n2 != 1) break;
                return;
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private void initUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        this.setDefaultCloseOperation(2);
        jPanel.setLayout(new GridBagLayout());
        this.sqlEditor.setPreferredSize(new Dimension(360, 200));
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.txtName.getDocument().addDocumentListener(this);
        this.sqlEditor.getDocument().addDocumentListener(this);
        this.btnOK.setDefaultCapable(true);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.btnOK);
        BookmarkEditor.constrain(0, 1, 1, 1, 0.0, 0.0, 17, 0);
        jPanel2.add((Component)this.lblName, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 2, 2, 1, 0.0, 0.0, 17, 2);
        jPanel2.add((Component)this.txtName, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 3, 1, 1, 0.0, 0.0, 17, 0);
        jPanel2.add((Component)this.lblSQL, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 4, 2, 1, 1.0, 1.0, 17, 1);
        jPanel2.add((Component)this.sqlEditor, UI_CONSTRAINT);
        String string = BasicUtilities.getString("Bookmarks_General");
        Icon icon = BasicUtilities.loadIconResource("Bookmarks16");
        String string2 = BasicUtilities.getString("Bookmarks_General_Tip");
        JComponent jComponent = jPanel2;
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab(string, icon, jComponent, string2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        BookmarkEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.lblBPath, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 1, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.lblCre8d, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 2, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.lblLastU, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 3, 1, 1, 0.0, 0.0, 17, 0);
        jPanel3.add((Component)this.lblUsage, UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 0, 1, 5, 1.0, 0.0, 10, 2);
        jPanel3.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 4, 1, 1, 0.0, 1.0, 10, 3);
        jPanel3.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        string = BasicUtilities.getString("Boomark_Parameters");
        icon = BasicUtilities.loadIconResource("TableInfo16");
        string2 = BasicUtilities.getString("Boomark_Param_Tip");
        jComponent = this.createParameterEditor();
        jTabbedPane.addTab(string, icon, jComponent, string2);
        string = BasicUtilities.getString("Boomark_Info");
        icon = BasicUtilities.loadIconResource("Information16");
        string2 = BasicUtilities.getString("Boomark_Info_Tip");
        jComponent = jPanel3;
        jTabbedPane.addTab(string, icon, jComponent, string2);
        BookmarkEditor.constrain(0, 0, 1, 4, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 1, 3, 1, 1.0, 1.0, 10, 1);
        jPanel.add((Component)jTabbedPane, UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 2, 1, 1, 1.0, 0.0, 10, 2);
        jPanel.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        BookmarkEditor.constrain(2, 2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.btnCancel, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.btnOK, UI_CONSTRAINT);
        BookmarkEditor.constrain(4, 0, 1, 4, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 4, 3, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        this.pack();
        this.setSize(new Dimension(540, 320));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getOwner());
    }

    private JComponent createParameterEditor() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JListUISupport.install(this.lstParams, true);
        this.lstParams.setCellRenderer(new ParameterRenderer(null));
        this.lstParams.getSelectionModel().setSelectionMode(0);
        this.btnParamAdd.setFont(this.btnParamAdd.getFont().deriveFont(1, 16.0f));
        this.btnParamDel.setFont(this.btnParamDel.getFont().deriveFont(1, 16.0f));
        this.btnParamAdd.addActionListener(this);
        this.btnParamDel.addActionListener(this);
        this.btnParamHlp.addActionListener(this);
        this.lstParams.addListSelectionListener(this);
        this.jcbTypes.addActionListener(this);
        this.txtParamOptions.getDocument().addDocumentListener(this);
        this.txtParamValue.getDocument().addDocumentListener(this);
        this.btnParamAdd.setToolTipText(BasicUtilities.getString("Bookmark_AddParam_Tip"));
        this.btnParamDel.setToolTipText(BasicUtilities.getString("Bookmark_DelParam_Tip"));
        this.btnParamHlp.setToolTipText(BasicUtilities.getString("Bookmark_HlpParam_Tip"));
        BookmarkEditor.constrain(0, 0, 1, 10, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 1, 2, 7, 0.75, 1.0, 10, 1);
        jPanel.add((Component)new JScrollPane(this.lstParams), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 2);
        jPanel.add((Component)new JLabel(BasicUtilities.getString("Bookmark_Select_Parameter_Type")), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 2);
        jPanel.add((Component)this.jcbTypes, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 3, 1, 1, 0.0, 0.0, 17, 2);
        jPanel.add((Component)new JLabel(BasicUtilities.getString("Bookmark_Parameter_Value")), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 4, 2, 1, 0.0, 0.0, 17, 2);
        jPanel.add((Component)this.txtParamValue, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 5, 1, 1, 1.0, 0.0, 17, 2);
        jPanel.add((Component)new JLabel(BasicUtilities.getString("Bookmark_Parameter_Options")), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 6, 2, 1, 1.0, 0.0, 17, 2);
        jPanel.add((Component)this.txtParamOptions, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 7, 2, 2, 0.0, 1.0, 10, 3);
        jPanel.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 8, 1, 1, 0.0, 0.0, 18, 0);
        jPanel.add((Component)this.btnParamAdd, UI_CONSTRAINT);
        BookmarkEditor.constrain(2, 8, 1, 1, 0.0, 0.0, 18, 0);
        jPanel.add((Component)this.btnParamDel, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 8, 1, 1, 0.0, 0.0, 12, 0);
        jPanel.add((Component)this.btnParamHlp, UI_CONSTRAINT);
        BookmarkEditor.constrain(4, 0, 1, 10, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 9, 3, 1, 0.0, 0.0, 10, 0);
        jPanel.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
        return jPanel;
    }

    private void applyParameters() {
        this.bookmark.clearParameters();
        this.bookmark.addAll(Arrays.asList(this.mdlParams.toArray()));
    }

    private static void constrain(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        BookmarkEditor.UI_CONSTRAINT.gridx = n2;
        BookmarkEditor.UI_CONSTRAINT.gridy = n3;
        BookmarkEditor.UI_CONSTRAINT.gridwidth = n4;
        BookmarkEditor.UI_CONSTRAINT.gridheight = n5;
        BookmarkEditor.UI_CONSTRAINT.weightx = d2;
        BookmarkEditor.UI_CONSTRAINT.weighty = d3;
        BookmarkEditor.UI_CONSTRAINT.anchor = n6;
        BookmarkEditor.UI_CONSTRAINT.fill = n7;
    }

    public static class 1 {
    }

    private static class ParameterRenderer
    extends DefaultListCellRenderer {
        private ParameterRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            this.setIcon(BasicUtilities.loadIconResource("TableInfo16"));
            SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)object;
            this.setText(n2 + 1 + "-" + parameter.getValue());
            return this;
        }

        public /* synthetic */ ParameterRenderer(1 var1_1) {
            this();
        }
    }

    public static class TreeCell
    extends DefaultTreeCellEditor {
        public TreeCell(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                int n3 = string.lastIndexOf(47);
                n3 = string.lastIndexOf(47, n3 - 1);
                try {
                    object = string.substring(n3 + 1, string.length() - 1);
                }
                catch (Exception exception) {}
            } else if (object instanceof SQLBookmark) {
                SQLBookmark sQLBookmark = (SQLBookmark)object;
                object = sQLBookmark.getName();
            }
            return super.getTreeCellEditorComponent(jTree, object, bl2, bl3, bl4, n2);
        }
    }
}

