/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.CoreAction;
import org.isqlviewer.swing.AbstractItemAction;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.util.BasicUtilities;

public abstract class ActionToolBar
extends JToolBar
implements ItemListener,
PreferenceChangeListener {
    private static final Insets buttonInsets = BasicUtilities.isMac() ? new Insets(2, 3, 2, 3) : new Insets(1, 1, 1, 1);
    public ArrayList actionList = new ArrayList(1);
    public ActionManager manager;

    public static ActionToolBar createNullInstance() {
        return new NullActionToolbar();
    }

    public ActionToolBar() {
        this((ActionManager)null);
    }

    public ActionToolBar(ActionManager actionManager) {
        this.manager = actionManager;
        this.addButtons();
        SystemConfig.getInstance().getPreferences().addPreferenceChangeListener(this);
        if (actionManager != null) {
            actionManager.addItemListener(this);
        }
    }

    public void setActionEnabled(boolean bl2) {
        Iterator iterator = this.actionList.iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            action.setEnabled(bl2);
        }
    }

    public JButton addButton(Action action) {
        if (action == null) {
            return null;
        }
        JButton jButton = this.add(action);
        this.configureButton(jButton, action);
        this.actionList.add(action);
        return jButton;
    }

    public Component add(Component component) {
        if (component instanceof AbstractButton) {
            this.configureButton((AbstractButton)component, null);
        }
        return super.add(component);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JCheckBoxAction jCheckBoxAction = (JCheckBoxAction)itemEvent.getItem();
        String string = jCheckBoxAction.getValue("Name").toString().trim();
        String string2 = this.getName();
        boolean bl2 = jCheckBoxAction.isSelected();
        if (string.equalsIgnoreCase(string2)) {
            this.setVisible(bl2);
            this.validateTree();
        }
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string = preferenceChangeEvent.getKey();
        if (string.equals("general.large-icons")) {
            this.updateIconSizes(this);
        }
    }

    public void addToggleButton(AbstractItemAction abstractItemAction) {
        JToggleButton jToggleButton = new JToggleButton(abstractItemAction);
        jToggleButton.addItemListener(abstractItemAction);
        jToggleButton.setSelected(abstractItemAction.isSelected());
        this.add(jToggleButton);
        this.configureButton(jToggleButton, abstractItemAction);
    }

    public void addDropActionSupport(Component component, DataFlavor[] dataFlavorArray, int n2) {
        component.setDropTarget(new DropTarget(component, new DropActionProxy(this.manager, dataFlavorArray, n2)));
    }

    public void configureButton(AbstractButton abstractButton, Action action) {
        if (action != null) {
            abstractButton.setActionCommand(action.getValue("ActionCommandKey").toString());
            abstractButton.setText("");
        }
        if (action instanceof CoreAction) {
            try {
                String string = (String)action.getValue("ICON_NAME");
                abstractButton.setIcon(BasicUtilities.loadToolbarIconResource(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        abstractButton.setAlignmentY(0.5f);
        abstractButton.setBorderPainted(!BasicUtilities.isMac());
        abstractButton.setFocusPainted(false);
        abstractButton.setMargin(buttonInsets);
        abstractButton.addMouseListener(this.manager);
    }

    public ActionManager getManager() {
        return this.manager;
    }

    public void toggleAction(AbstractButton abstractButton, Action action) {
        abstractButton.setIcon(BasicUtilities.loadToolbarIconResource(action.getValue("ICON_NAME").toString()));
        abstractButton.setToolTipText(action.getValue("ShortDescription").toString());
        abstractButton.setActionCommand(action.getValue("ActionCommandKey").toString());
    }

    public abstract void processDropProxy(Transferable var1, int var2);

    public void addButtons() {
    }

    public void updateIconSizes(ActionToolBar actionToolBar) {
        int n2 = actionToolBar.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            AbstractButton abstractButton;
            Component component = actionToolBar.getComponent(i2);
            if (!(component instanceof AbstractButton) || (abstractButton = (AbstractButton)component).getIcon() == null) continue;
            Action action = abstractButton.getAction();
            if (action instanceof CoreAction) {
                try {
                    string = (String)action.getValue("ICON_NAME");
                    abstractButton.setIcon(BasicUtilities.loadToolbarIconResource(string));
                }
                catch (Exception exception) {}
                continue;
            }
            string = abstractButton.getName();
            if (string.trim().length() < 1) continue;
            abstractButton.setIcon(BasicUtilities.loadToolbarIconResource(string));
        }
    }

    protected class DropActionProxy
    extends DropTargetAdapter {
        private DataFlavor[] acceptable = new DataFlavor[0];
        private int actionIdentifier = Integer.MAX_VALUE;
        private ActionManager delegate = null;

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            List<DataFlavor> list = dropTargetDragEvent.getCurrentDataFlavorsAsList();
            if (this.acceptable.length >= 1) {
                for (int i2 = 0; i2 < this.acceptable.length; ++i2) {
                    if (!list.contains(this.acceptable[i2])) continue;
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getSourceActions());
                    return;
                }
                dropTargetDragEvent.rejectDrag();
            }
        }

        public DropActionProxy(ActionManager actionManager, DataFlavor[] dataFlavorArray, int n2) {
            this.acceptable = dataFlavorArray == null ? new DataFlavor[]{} : dataFlavorArray;
            this.actionIdentifier = n2;
            this.delegate = actionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.acceptable.length; ++i2) {
                if (!dropTargetDropEvent.isDataFlavorSupported(this.acceptable[i2])) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                ActionEvent actionEvent = new ActionEvent(transferable, this.actionIdentifier, "dnd-proxy");
                this.delegate.forwardAction(actionEvent);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
            }
            finally {
                dropTargetDropEvent.dropComplete(true);
            }
        }
    }

    private static class NullActionToolbar
    extends ActionToolBar {
        public NullActionToolbar() {
            super((ActionManager)null);
        }

        public void processDropProxy(Transferable transferable, int n2) {
        }
    }
}

